/*************************************************************************
 *
 *  $RCSfile: sibasic.cxx,v $
 *
 *  $Revision: 1.38.20.3 $
 *
 *  last change: $Author: vg $ $Date: 2004/02/10 13:29:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#if defined(WNT)
#include <tools/svwin.h>
#endif

#include <com/sun/star/uno/Reference.h>
#include <com/sun/star/lang/XComponent.hpp>
#include <cppuhelper/servicefactory.hxx>

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_PROCESS_HXX //autogen
#include <vos/process.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SBXCLASS_HXX //autogen
#include <svtools/sbx.hxx>
#endif

#ifndef _SB_SBMOD_HXX //autogen
#include <basic/sbmod.hxx>
#endif

#ifndef _SB_SBMETH_HXX //autogen
#include <basic/sbmeth.hxx>
#endif

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#include <tools/l2txtenc.hxx>

#include "sibasic.hxx"
#include "wrapper.hxx"
#include "decltor.hxx"
#include "fields.hxx"
#include "agenda.hxx"
#include "action.hxx"
#include "script.hxx"
#include "critical.hxx"
#include "sihelp.hxx"

#include "agentdlg.hxx"
#include "os.hxx"

#include "stringhelper.hxx"

// Mac OS X does not like really big char array variables declared as automatic
// variables so we need to make MAX_BUF smaller than the other platforms.
#ifdef MACOSX
#define MAX_BUF		 					16000
#else
#define MAX_BUF		 					32000
#endif
#define BUF_OVERFLOW_SPOOL_BACK			30

// jbu: I removed the apparently not needed SiBasicImpl struct, because it does not
//      seem to be needed.
//      TODO: Tide up class declaration
// struct SiBasicImpl
// {
// 	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > xFac;

// 	SiBasicImpl(SiEnvironment& rEnv);
// 	~SiBasicImpl();
// };

// SiBasicImpl::SiBasicImpl(SiEnvironment& rEnv)
// {
// 	SiDirEntry aOldCWD(".");
// 	aOldCWD.ToAbs();

// 	SiDirEntry aCWD( rEnv.GetDestPath() );
// 	aCWD += ByteString("program");

// 	aCWD.ToAbs();
// 	aCWD.SetCWD();
// 	aCWD += ByteString("applicat.rdb");

// 	::rtl::OUString regName = ::rtl::OStringToOUString( aCWD.GetFull().GetBuffer(),
// 			 RTL_TEXTENCODING_ASCII_US );
// 	xFac = ::cppu::createRegistryServiceFactory( regName );

// 	aOldCWD.SetCWD();
// }

// SiBasicImpl::~SiBasicImpl()
// {
// /*
//   	com::sun::star::uno::Reference< com::sun::star::lang::XComponent > xComponent(
// 		xFac, com::sun::star::uno::UNO_QUERY );
// 	if ( xComponent.is() )
// 		xComponent->dispose();
// */
// }

/*
UniString TrimString(String const& rStr)
{
	ByteString aStr( rStr );
	aStr.EraseTrailingChars();
	aStr.EraseLeadingChars();
	return aStr;
}
*/

//=============================================================================
//=============================================================================
// class SibListener

class SibListener : public SfxListener
{
	SiCompiledScript&	m_rCS;
	SiEnvironment&		m_rEnv;
	SiBasic*				m_pSiBasic;

	SvAgentDlg*			m_pDlg;
	BOOL				m_bFirstPage;
protected:
	virtual void Notify(SfxBroadcaster &, SfxHint const& rHint);

public:
	SibListener(SiCompiledScript &rCS, SiEnvironment &rEnv, SiBasic* pBasic) :
				m_rCS			( rCS ),
				m_rEnv			( rEnv ),
				m_pDlg			( NULL ),
				m_bFirstPage	( TRUE ),
				m_pSiBasic		( pBasic )
	{}

// 	SiBasicImpl*	GetImpl() { return m_pSiBasic->GetImpl(); }
	SiEnvironment&	GetEnvironment() const { return m_rEnv; }
	void 			SetAgentDlg(SvAgentDlg* pDlg) { m_pDlg = pDlg; }
};

//=============================================================================

BOOL _StarRegister( SbxArray* pArr, SiCompiledScript& rCS, SiEnvironment& rEnv, BOOL bWrite )
{
	ByteString aRegName	( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );
	ByteString aKey		( ByteString(pArr->Get(2)->GetString(), osl_getThreadTextEncoding()) );
	ByteString aValue	( ByteString(pArr->Get(3)->GetString(), osl_getThreadTextEncoding()) );

	BOOL bSoloStr = TRUE;
	for( USHORT nIdx = 4; nIdx < pArr->Count(); ++nIdx )
	{
		bSoloStr = FALSE;
		aValue += '|';
		aValue += ByteString(pArr->Get(nIdx)->GetString(), osl_getThreadTextEncoding());
	}

	SiStarRegistry* pRegistry = SiHelp::FindRegistryByName( rCS.GetRootModule(), aRegName );
	if( !pRegistry )
		return FALSE;

	SiStarRegistryItem aItem( SiIdentifier("INTERNAL"), NULL );
	aItem.SetProperty( PROPERTY_REGISTRYID, pRegistry );
	aItem.SetProperty( PROPERTY_KEY, aKey );
	aItem.SetProperty( bSoloStr? PROPERTY_VALUE : PROPERTY_SEQ_VALUE, aValue );

	SiAgenda aAgenda;
	SiStarRegistryAction aAction( &aAgenda, bWrite? PIA_CREATE : PIA_REMOVE, &aItem );
	if( !aAction.Execute(rEnv) )
		return FALSE;
	return TRUE;
}

sal_Int32 fromVisualBasicToVCL(sal_Int32 _nValue)
{
	sal_Int32 nRetVal = 0;
	if ((_nValue & 0xF) == 0x00000000L /*MB_OK*/)               nRetVal = WB_OK;
	if ((_nValue & 0xF) == 0x00000001L /*MB_OKCANCEL*/)         nRetVal = WB_OK_CANCEL;
	if ((_nValue & 0xF) == 0x00000003L /*MB_YESNOCANCEL*/)      nRetVal = WB_YES_NO_CANCEL;
	if ((_nValue & 0xF) == 0x00000004L /*MB_YESNO*/)            nRetVal = WB_YES_NO;
	if ((_nValue & 0xF) == 0x00000002L /*MB_ABORTRETRYIGNORE*/) nRetVal = WB_RETRY_CANCEL;
	if ((_nValue & 0xF) == 0x00000005L /*MB_RETRYCANCEL*/)      nRetVal = WB_RETRY_CANCEL;

	if ((_nValue & 0x300) == 0x00000000L /*MB_DEFBUTTON1*/)	  OSL_ENSURE(false, "Sorry, MB_DEFBUTTON1 not supported"); // nRetVal |= WB_;
	if ((_nValue & 0x300) == 0x00000100L /*MB_DEFBUTTON2*/)	  OSL_ENSURE(false, "Sorry, MB_DEFBUTTON2 not supported") ; // nRetVal |= WB_;
	if ((_nValue & 0x300) == 0x00000200L /*MB_DEFBUTTON3*/)	  OSL_ENSURE(false, "Sorry, MB_DEFBUTTON3 not supported") ; // nRetVal |= WB_;
	if ((_nValue & 0x1000) == 0x00000000L /*MB_APPLMODAL*/)		  OSL_ENSURE(false, "Sorry, MB_APPLMODAL not supported") ; // nRetVal |= WB_;
	if ((_nValue & 0x1000) == 0x00001000L /*MB_SYSTEMMODAL*/)     OSL_ENSURE(false, "Sorry, MB_SYSTEMMODAL not supported") ; // nRetVal |= WB_;

	return nRetVal;
}

sal_Int32 fromVCLToVisualBasic(sal_Int32 _nValue)
{
	sal_Int32 nRetVal = 2 /*IDCANCEL*/;
	if (_nValue == BUTTON_CANCEL)  nRetVal = 1 /*IDOK*/;
	if (_nValue == BUTTON_OK)      nRetVal = 2 /*IDCANCEL*/;

	if (_nValue == BUTTON_RETRY)  nRetVal = 4 /*IDRETRY*/;
	if (_nValue == BUTTON_YES)    nRetVal = 6 /*IDYES*/;
	if (_nValue == BUTTON_NO)     nRetVal = 7 /*IDNO*/;

	return nRetVal;
}

//=============================================================================
//=============================================================================
//	SibListener::Notify
void SibListener::Notify(SfxBroadcaster& rBC, SfxHint const& rHint)
{
	const SbxHint* pHint = (SbxHint*) &rHint;
	if( pHint->GetId() == SBX_HINT_DATAWANTED )
	{
		SbxVariable*	pVar  = pHint->GetVar();
		SbxArray*		pArr  = pVar->GetParameters();
		ByteString		aName = ByteString(pVar->GetName(), osl_getThreadTextEncoding());

		//=====================================================================
		//=====================================================================
		//	GetScriptObject
		if( aName.CompareIgnoreCaseToAscii("GetScriptObject") == COMPARE_EQUAL )
		{
			DBG_ASSERT(pArr->Count() == 2, "GetScriptObject(Param)");

			SbxVariable*	pParam = pArr->Get(1);
			SiDeclarator*	pDec = m_rCS.Find(ByteString(pParam->GetString(), osl_getThreadTextEncoding()));

			if( pDec == NULL )
			{
				pVar->PutObject( NULL );
				return;
			}

			if( pDec->IsA(TYPE(SiFile)) )
				pVar->PutObject( new SibFile((SiFile*)pDec) );
			else if( pDec->IsA(TYPE(SiDirectory)) )
				pVar->PutObject( new SibDirectory((SiDirectory*)pDec) );
			else if( pDec->IsA(TYPE(SiProfile)) )
				pVar->PutObject( new SibProfile((SiProfile*)pDec) );
			else if( pDec->IsA(TYPE(SiProfileItem)) )
				pVar->PutObject( new SibProfileItem((SiProfileItem*)pDec) );
			else if( pDec->IsA(TYPE(SiRegistryItem)) )
				pVar->PutObject( new SibRegistryItem((SiRegistryItem*)pDec) );
			else
				pVar->PutObject( NULL );
		}

		//=====================================================================
		//=====================================================================
		//	Copy
		else if( aName.CompareIgnoreCaseToAscii("Copy")  == COMPARE_EQUAL )
		{
			DBG_ASSERT(pArr->Count() == 3, "Copy(Param1,Param2)");

			SiDirEntry aFrom( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );
			SiDirEntry aTo( ByteString(pArr->Get(2)->GetString(), osl_getThreadTextEncoding()), FSYS_STYLE_FAT );

			FileCopier aCopier( aFrom, aTo );
			FSysError anErr = aCopier.Execute();

			pVar->PutBool( anErr == 0);
		}

		//=====================================================================
		//=====================================================================
		//	DestPath
		else if( aName.CompareIgnoreCaseToAscii("SetDestinationPath")  == COMPARE_EQUAL )
		{
			DBG_ASSERT(pArr->Count() == 2, "SetDestinationPath(Param1)");

			ByteString aPath( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );
			m_rEnv.SetDestPath(aPath);
		}
		//=====================================================================
		//=====================================================================
		//	GetSetupEnv
		else if( aName.CompareIgnoreCaseToAscii("GetSetupEnv") == COMPARE_EQUAL )
		{
			DBG_ASSERT(pArr == 0, "GetSetupEnv()");
			pVar->PutObject(new SibEnvironment(&m_rEnv));
		}

		//=====================================================================
		//=====================================================================
		//	DirEntry
		else if( aName.CompareIgnoreCaseToAscii("DirEntry") == COMPARE_EQUAL )
		{
			SiDirEntry aPath(ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()));
			for (USHORT i=2; i<pArr->Count(); i++)
				aPath += ByteString(pArr->Get(i)->GetString(), osl_getThreadTextEncoding());
			pVar->PutString( UniString(aPath.GetFull(), osl_getThreadTextEncoding()) );
		}

		//=====================================================================
		//=====================================================================
		//	HideSetup & ShowSetup
		else if( aName.CompareIgnoreCaseToAscii("HideSetup") == COMPARE_EQUAL )
		{
			Application::GetAppWindow()->Hide();
		}
		else if( aName.CompareIgnoreCaseToAscii("ShowSetup") == COMPARE_EQUAL )
		{
			Application::GetAppWindow()->Show();
			Application::GetAppWindow()->GrabFocus();
		}

		//=====================================================================
		//=====================================================================
		//	SetFollowApplication
		else if( aName.CompareIgnoreCaseToAscii("SetFollowApplication") == COMPARE_EQUAL )
		{
			ByteString* pAppName = new ByteString( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );
			m_rEnv.AddFollowAppList( pAppName );
		}

		//=====================================================================
		//=====================================================================
		//	SyncStartApplication
		else if( aName.CompareIgnoreCaseToAscii("SyncStartApplication") == COMPARE_EQUAL )
		{
			// we need at least two parameters, the first one is the return
            // value of this function, the second the name of the application
            // we want to start
            DBG_ASSERT( (pArr->Count() > 1), "SyncStartApplication(Param, ...)");

			SbxVariable* pParam = pArr->Get(1);
            rtl::OUString aApplication;

            FileBase::getFileURLFromSystemPath( pParam->GetString(), aApplication );

			USHORT nOptions = NAMESPACE_VOS(OProcess)::TOption_SearchPath |
				NAMESPACE_VOS(OProcess)::TOption_Minimized |
                NAMESPACE_VOS(OProcess)::TOption_Detached;

			NAMESPACE_VOS(OProcess)::TProcessOption eOptions =
				(NAMESPACE_VOS(OProcess)::TProcessOption)nOptions;

			// now collect the additional parameters for the function
            // (the first two parameters should be ignored ( s.o. ) )
            ::rtl::OUString* pArgs = new ::rtl::OUString [ pArr->Count()-2 ];
			if( pArr->Count() > 2 )
			{
				USHORT nIdx = 0;
				for( USHORT i = 2; i < pArr->Count(); ++i )
					pArgs[nIdx++] = ::rtl::OUString( pArr->Get(i)->GetString() );
			}

			NAMESPACE_VOS(OArgumentList) aArgs( pArgs, pArr->Count()-2 );

			NAMESPACE_VOS( OProcess ) aProcess( aApplication );
			aProcess.execute( eOptions, aArgs );
			aProcess.join();

			delete[] pArgs;

			pVar->PutBool( TRUE );
		}

#if defined(WNT)
		//=====================================================================
		//=====================================================================
		//	SyncStartApplication
		else if( aName.CompareIgnoreCaseToAscii("ShellExecute") == COMPARE_EQUAL )
		{
			ByteString aCmd( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );
			ShellExecute( NULL, NULL, aCmd.GetBuffer(), "", ".", SW_SHOW );
		}
#endif

		//=====================================================================
		//=====================================================================
		//	GetFreeOSDriveSize
		else if( aName.CompareIgnoreCaseToAscii("GetFreeOSDriveSize") == COMPARE_EQUAL )
		{
			ULONG nFreeSz = OS::GetDriveSize(SiDirEntry(OS::GetSystemPath()));
			pVar->PutLong( nFreeSz );
		}

		//=====================================================================
		//=====================================================================
		//	UIPage
		else if( aName.CompareIgnoreCaseToAscii("UI") == COMPARE_EQUAL )
		{
			pVar->PutObject( new SibPagePool() );
		}

		//=====================================================================
		//=====================================================================
		//	PageRule
		else if( aName.CompareIgnoreCaseToAscii("PageRule") == COMPARE_EQUAL )
		{
			DBG_ASSERT( pArr->Count() == 3, "PageRule(PageID,FollowPageID)" );
			if( !m_pDlg )
				return;

			USHORT nId 			= pArr->Get(1)->GetInteger();
			USHORT nFollowId	= pArr->Get(2)->GetInteger();

			if( m_bFirstPage ) {
				m_bFirstPage = FALSE;
				m_pDlg->AddAllPages();
				m_pDlg->SetStartPageId(nId);
			}

			m_pDlg->Rule( nId, nFollowId );
		}

		//=====================================================================
		//=====================================================================
		//	PageRuleIf
		else if( aName.CompareIgnoreCaseToAscii("PageRuleIf") == COMPARE_EQUAL )
		{
			DBG_ASSERT( pArr->Count() == 4, "PageRuleIf(PageID,ReturnValue,FollowPageID)" );
			if( !m_pDlg )
				return;

			USHORT nId 			= pArr->Get(1)->GetInteger();
			USHORT nRule		= pArr->Get(2)->GetInteger();
			USHORT nFollowId	= pArr->Get(3)->GetInteger();

			if( m_bFirstPage ) {
				m_bFirstPage = FALSE;
				m_pDlg->AddAllPages();
				m_pDlg->SetStartPageId(nId);
			}

			m_pDlg->RuleIf( nId, nRule, nFollowId );
		}

		//=====================================================================
		//=====================================================================
		//	SiMsgbox
		else if( aName.CompareIgnoreCaseToAscii("SiMsgbox") == COMPARE_EQUAL )
		{
			ByteString aByteStr( pArr->Get(1)->GetString(), RTL_TEXTENCODING_MS_1252 );
 			UniString aMsg( aByteStr, Langcode2TextEncoding(m_rEnv.GetUILanguage()) );
			InfoBox(NULL, aMsg).Execute();
		}
		else if ( aName.CompareIgnoreCaseToAscii("cvtuilang") == COMPARE_EQUAL)
		{
			ByteString aByteStr( pArr->Get(1)->GetString(), RTL_TEXTENCODING_MS_1252 );
 			UniString aMsg( aByteStr, Langcode2TextEncoding(m_rEnv.GetUILanguage()) );
			pVar->PutString( aMsg );
		}

		//=====================================================================
		//=====================================================================
		//	SiQueryBox
		else if ( aName.CompareIgnoreCaseToAscii("SiQueryBox") == COMPARE_EQUAL )
		{
			ByteString  aByteStr( pArr->Get(1)->GetString(), RTL_TEXTENCODING_MS_1252 );
			ULONG nButtons	    = pArr->Get(2)->GetLong();
			ByteString aTitleStr( pArr->Get(3)->GetString(), RTL_TEXTENCODING_MS_1252 );

 			UniString aMsg( aByteStr, Langcode2TextEncoding(m_rEnv.GetUILanguage()) );

			ULONG nVCLButtons = fromVisualBasicToVCL(nButtons);
			QueryBox aQueryBox(NULL, nVCLButtons | WB_CLOSEABLE, aMsg);
			if (aTitleStr.Len())
			{
				UniString aMsgTitle( aTitleStr, Langcode2TextEncoding(m_rEnv.GetUILanguage()) );
				aQueryBox.SetText(aMsgTitle);
			}
			sal_Int32 nImage = nButtons & 0x70;
			if ( nImage == 0x00000010L /*MB_ICONSTOP*/)        
				aQueryBox.SetImage(ErrorBox::GetStandardImage());
			if (nImage == 0x00000020L /*MB_ICONQUESTION*/)  
				aQueryBox.SetImage(QueryBox::GetStandardImage());
			if (nImage == 0x00000040L /*MB_ICONINFORMATION*/)
				aQueryBox.SetImage(InfoBox::GetStandardImage());
			if (nImage == 0x00000030L /*MB_ICONEXCLAMATION*/)
				aQueryBox.SetImage(WarningBox::GetStandardImage());

			short nVCLButton = aQueryBox.Execute();

			//# ByteString aStr;
			//# switch(nVCLButton)
			//# {
			//# case BUTTON_OK:
			//# 	aStr = "CANCEL";
			//# 	break;
			//# case BUTTON_YES:
			//# 	aStr = "YES";
			//# 	break;
			//# case BUTTON_NO:
			//# 	aStr = "NO";
			//# 	break;
			//# case BUTTON_CANCEL:
			//# 	aStr = "OK";
			//# 	break;
			//# case BUTTON_RETRY:
			//# 	aStr = "RETRY";
			//# 	break;
			//# default:
			//# 	aStr = "unknown";
			//# }
			//# aStr = ByteString("Button pressed: ") + aStr;
			//# UniString aMsg2( aStr, osl_getThreadTextEncoding());
			//# InfoBox(NULL, aMsg2).Execute();

			pVar->PutUShort( (USHORT) fromVCLToVisualBasic(nVCLButton));
		}

		//=====================================================================
		//=====================================================================
		//	SelectModuleSet
		else if( aName.CompareIgnoreCaseToAscii("SelectModuleSet") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			SiModuleSet* pSet = SiHelp::FindModuleSetByName( &m_rEnv, ByteString(pParam->GetString(), osl_getThreadTextEncoding()) );
			if( !pSet )
				pVar->PutBool( FALSE );
			else
			{
				pVar->PutBool( TRUE );
				pSet->Select();
			}
		}

		//=====================================================================
		//=====================================================================
		//	SelectModuleByName
		else if( aName.CompareIgnoreCaseToAscii("SelectModuleByName") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			SiModule* pMod = SiHelp::FindModuleByName( m_rCS.GetRootModule(), ByteString(pParam->GetString(), osl_getThreadTextEncoding()) );
			if( !pMod )
				pVar->PutBool( FALSE );
			else
			{
				pVar->PutBool( TRUE );
				pMod->Select(SiModule::ALL_SEL);
			}
		}

		//=====================================================================
		//=====================================================================
		//	SelectModuleByID
		else if( aName.CompareIgnoreCaseToAscii("SelectModuleByID") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			SiModule* pMod = PTR_CAST(SiModule, m_rCS.Find(ByteString(pParam->GetString(), osl_getThreadTextEncoding())));

			if( !pMod )
				pVar->PutBool( FALSE );
			else
			{
				pVar->PutBool( TRUE );
				pMod->Select(SiModule::ALL_SEL);
			}
		}

		//=====================================================================
		//=====================================================================
		//	DeSelectModuleSet
		else if( aName.CompareIgnoreCaseToAscii("DeSelectModuleSet") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			SiModuleSet* pSet = SiHelp::FindModuleSetByName( &m_rEnv, ByteString(pParam->GetString(), osl_getThreadTextEncoding()) );
			if( !pSet )
				pVar->PutBool( FALSE );
			else
			{
				pVar->PutBool( TRUE );
				pSet->DeSelect();
			}
		}

		//=====================================================================
		//=====================================================================
		//	DeSelectModuleByName
		else if( aName.CompareIgnoreCaseToAscii("DeSelectModuleByName") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			SiModule* pMod = SiHelp::FindModuleByName( m_rCS.GetRootModule(), ByteString(pParam->GetString(), osl_getThreadTextEncoding()) );
			if( !pMod )
				pVar->PutBool( FALSE );
			else
			{
				pVar->PutBool( TRUE );
				pMod->Select(SiModule::ALL_UNSEL);
			}
		}

		//=====================================================================
		//=====================================================================
		//	DeSelectModuleByID
		else if( aName.CompareIgnoreCaseToAscii("DeSelectModuleByID") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			SiModule* pMod = PTR_CAST(SiModule, m_rCS.Find(ByteString(pParam->GetString(), osl_getThreadTextEncoding())));
			if( !pMod )
				pVar->PutBool( FALSE );
			else
			{
				pVar->PutBool( TRUE );
				pMod->Select(SiModule::ALL_UNSEL);
			}
		}

		//=====================================================================
		//=====================================================================
		//	SetDefaultModuleByID
		else if( aName.CompareIgnoreCaseToAscii("SetDefaultModuleByID") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			BOOL		 bOn    = pArr->Get(2)->GetBool();

			SiModule* pMod = PTR_CAST(SiModule, m_rCS.Find(ByteString(pParam->GetString(), osl_getThreadTextEncoding())));
			if( !pMod )
				pVar->PutBool( FALSE );
			else
			{
				pVar->PutBool( TRUE );
				pMod->SetDefault( bOn );
			}
		}

		//=====================================================================
		//=====================================================================
		//	SetDefaultModuleByName
		else if( aName.CompareIgnoreCaseToAscii("SetDefaultModuleByName") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			BOOL		 bOn    = pArr->Get(2)->GetBool();

			SiModule* pMod = SiHelp::FindModuleByName( m_rCS.GetRootModule(), ByteString(pParam->GetString(), osl_getThreadTextEncoding()) );
			if( !pMod )
				pVar->PutBool( FALSE );
			else
			{
				pVar->PutBool( TRUE );
				pMod->SetDefault( bOn );
			}
		}

		//=====================================================================
		//=====================================================================
		//	SetMinimalModuleByID
		else if( aName.CompareIgnoreCaseToAscii("SetMinimalModuleByID") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			BOOL		 bOn    = pArr->Get(2)->GetBool();

			SiModule* pMod = PTR_CAST(SiModule, m_rCS.Find(ByteString(pParam->GetString(), osl_getThreadTextEncoding())));
			if( !pMod )
				pVar->PutBool( FALSE );
			else
			{
				pVar->PutBool( TRUE );
				pMod->SetMinimal( bOn );
			}
		}

		//=====================================================================
		//=====================================================================
		//	SetMinimalModuleByName
		else if( aName.CompareIgnoreCaseToAscii("SetMinimalModuleByName") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			BOOL		 bOn    = pArr->Get(2)->GetBool();

			SiModule* pMod = SiHelp::FindModuleByName( m_rCS.GetRootModule(), ByteString(pParam->GetString(), osl_getThreadTextEncoding()) );
			if( !pMod )
				pVar->PutBool( FALSE );
			else
			{
				pVar->PutBool( TRUE );
				pMod->SetMinimal( bOn );
			}
		}

		//=====================================================================
		//=====================================================================
		//	SetHiddenModuleByID
		else if( aName.CompareIgnoreCaseToAscii("SetHiddenModuleByID") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			BOOL		 bOn    = pArr->Get(2)->GetBool();

			SiModule* pMod = PTR_CAST(SiModule, m_rCS.Find(ByteString(pParam->GetString(), osl_getThreadTextEncoding())));
			if( !pMod )
				pVar->PutBool( FALSE );
			else
			{
				pVar->PutBool( TRUE );
				pMod->SetHidden( bOn );
			}
		}

		//=====================================================================
		//=====================================================================
		//	SetHiddenModuleByName
		else if( aName.CompareIgnoreCaseToAscii("SetHiddenModuleByName") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			BOOL		 bOn    = pArr->Get(2)->GetBool();

			SiModule* pMod = SiHelp::FindModuleByName( m_rCS.GetRootModule(), ByteString(pParam->GetString(), osl_getThreadTextEncoding()) );
			if( !pMod )
				pVar->PutBool( FALSE );
			else
			{
				pVar->PutBool( TRUE );
				pMod->SetHidden( bOn );
			}
		}

		//=====================================================================
		//=====================================================================
		//	SetReboot
		else if( aName.CompareIgnoreCaseToAscii("SetReboot") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			BOOL bDoReboot = pParam->GetBool();
			m_rEnv.SetReboot( bDoReboot );
		}

		//=====================================================================
		//=====================================================================
		//	SetLogout
		else if( aName.CompareIgnoreCaseToAscii("SetLogout") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			BOOL bDoLogout = pParam->GetBool();
			m_rEnv.SetLogout( bDoLogout );
		}

		//=====================================================================
		//=====================================================================
		//	DefuseRestart
		else if( aName.CompareIgnoreCaseToAscii("DefuseRestart") == COMPARE_EQUAL )
		{
			SbxVariable* pParam = pArr->Get(1);
			BOOL bDefuseReboot = pParam->GetBool();
			m_rEnv.SetDefuseRestart( bDefuseReboot );
		}

		//=====================================================================
		//=====================================================================
		//	GetMajor
		else if( aName.CompareIgnoreCaseToAscii("GetMajor") == COMPARE_EQUAL )
		{
			ByteString aMajor( ByteString::CreateFromInt32(SUPD) );
			pVar->PutString( UniString::CreateFromAscii(aMajor.GetBuffer()) );
		}
		//=====================================================================
		//=====================================================================
		//	IsMigration
		else if( aName.CompareIgnoreCaseToAscii("IsMigration") == COMPARE_EQUAL )
		{
			pVar->PutBool( m_rEnv.DoMigration() );
		}
		//=====================================================================
		//=====================================================================
		//	IsResponsefileMode
		else if( aName.CompareIgnoreCaseToAscii("IsResponsefileMode") == COMPARE_EQUAL )
		{
			pVar->PutBool( m_rEnv.IsResponsefileMode() );
		}

		//=====================================================================
		//=====================================================================
		//	SelectLanguages
		else if( aName.CompareIgnoreCaseToAscii("SelectLanguages") == COMPARE_EQUAL )
		{
			m_rEnv.SetUINiceLangDefault( FALSE );

			USHORT i;
			const SiLangCtxList *pLst = m_rEnv.GetUILanguageContext();
			for( i = 0; i < (short) pLst->Count(); ++i )
			{
				LanguageContext* pAct = pLst->GetObject(i);
				pAct->isDoc = FALSE;
				pAct->isProg = FALSE;
			}

			for( i = 1; i < pArr->Count(); i++ )
			{
				USHORT nLang = (USHORT) pArr->Get(i)->GetUShort();
				for( short x = 0; x < (short) pLst->Count(); ++x )
				{
					LanguageContext* pAct = pLst->GetObject(x);
					if( nLang == pAct->nLanguage )
					{
						pAct->isDoc		= i==1? TRUE : FALSE;
						pAct->isProg	= TRUE;
					}
				}
			}
		}

		//=====================================================================
		//=====================================================================
		//	GetSelectedLanguages
		else if( aName.CompareIgnoreCaseToAscii("GetSelectedLanguages") == COMPARE_EQUAL )
		{
			SbxDimArrayRef xArray = new SbxDimArray( SbxUSHORT );
			const SiLangCtxList* pLst = m_rEnv.GetUILanguageContext();
			USHORT nSize = 0;
			USHORT nDocLang = 0;

			for( short i = 0; i < (short) pLst->Count(); ++i ) {
				LanguageContext* pAct = pLst->GetObject(i);
				if( pAct->isDoc || pAct->isProg ) {
					nSize++;
					if( pAct->isDoc ) nDocLang = pAct->nLanguage;
				}
			}

            if ( !nSize )
            {
                // When there are languages, but no program or doc languages
                // (should only happen in response file mode ), we will try
                // the LanguageContext ( without ui )
                pLst = m_rEnv.GetLanguageContext();
                
                for( short i = 0; i < (short) pLst->Count(); ++i )
                {
                    LanguageContext* pAct = pLst->GetObject(i);
                    if( pAct->isDoc || pAct->isProg )
                    {
                        nSize++;
                        if( pAct->isDoc )
                            nDocLang = pAct->nLanguage;
                    }
                }

                // When we still didn't found a language, we will take the first one
                if ( !nSize )
                {
                    if ( pLst->Count() )
                    {
                        LanguageContext* pAct = pLst->GetObject(0);
                        pAct->isProg = TRUE;
                    }
                    else
                    {
                        nDocLang = (USHORT) m_rCS.GetInstallation()->GetDefLanguage().ToInt32();
                    }
                    nSize = 1;
                }
            }

			short arrayIdx = 0;
			xArray->unoAddDim( 0, (short) nSize - 1 );

			if( nDocLang != 0 )
			{
				SbxVariableRef xVar = new SbxVariable( SbxUSHORT );
				xVar->PutUShort( nDocLang != LANG_DEFAULT? nDocLang :
								 (USHORT) m_rCS.GetInstallation()->GetDefLanguage().ToInt32() );
				xArray->Put( xVar, &arrayIdx );
				arrayIdx++;
			}

			for( short ii = 0; ii < (short) pLst->Count(); ++ii ) {
				LanguageContext* pAct = pLst->GetObject(ii);
				if( (!nDocLang && pAct->isProg ) || (pAct->isProg && (pAct->nLanguage != nDocLang)) )
				{
					SbxVariableRef xVar = new SbxVariable( SbxUSHORT );
					xVar->PutUShort( pAct->nLanguage != LANG_DEFAULT? (USHORT) pAct->nLanguage :
									 (USHORT) m_rCS.GetInstallation()->GetDefLanguage().ToInt32() );
					xArray->Put( xVar, &arrayIdx );
					arrayIdx++;
				}
			}

			pVar->PutObject( xArray );
		}

		//=====================================================================
		//=====================================================================
		//	GetInstalledLanguages
		else if( aName.CompareIgnoreCaseToAscii("GetInstalledLanguages") == COMPARE_EQUAL )
		{
			SbxDimArrayRef xArray = new SbxDimArray( SbxUSHORT );
			const SiLangCtxList *pLst = m_rEnv.GetLanguageContext();

			xArray->unoAddDim( 0, (short) pLst->Count() - 1 );

			for( short i = 0; i < (short) pLst->Count(); ++i )
			{
				LanguageContext* pAct = pLst->GetObject(i);
				SbxVariableRef xVar = new SbxVariable( SbxUSHORT );
				xVar->PutUShort( pAct->nLanguage != LANG_DEFAULT? (USHORT) pAct->nLanguage :
								 (USHORT) m_rCS.GetInstallation()->GetDefLanguage().ToInt32() );
				xArray->Put( xVar, &i );
			}
			pVar->PutObject( xArray );
		}

		//=====================================================================
		//=====================================================================
		//	GetUILanguage
		else if( aName.CompareIgnoreCaseToAscii("GetUILanguage") == COMPARE_EQUAL )
		{
			pVar->PutUShort( m_rEnv.GetUILanguage() );
		}

		//=====================================================================
		//=====================================================================
		//
		else if( aName.CompareIgnoreCaseToAscii("InitiateWorkstation") == COMPARE_EQUAL )
		{
			InitiateWorkstation* pNew = new InitiateWorkstation;
			pNew->aDirectory = ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding());
			pNew->nLanguage	 = pArr->Get(2)? pArr->Get(2)->GetInteger() : LANG_DEFAULT;

			m_rEnv.AddWorkstationList( pNew );
		}

		//=====================================================================
		//=====================================================================
		//
		else if( aName.CompareIgnoreCaseToAscii("AddExplicitUNOReg") == COMPARE_EQUAL )
		{
			ByteString* pNew = new ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding());
			m_rCS.AddExplicitUNOReg( pNew );
		}

		//=====================================================================
		//=====================================================================
		//	WriteStarRegistry( RegistryName AS ByteString, Key AS ByteString, Value AS ByteString, .... )
		else if( aName.CompareIgnoreCaseToAscii("WriteStarRegistry") == COMPARE_EQUAL )
		{
			if( !_StarRegister(pArr, m_rCS, m_rEnv, TRUE) )
				pVar->PutBool( FALSE );
			else
				pVar->PutBool( TRUE );
		}

		//=====================================================================
		//=====================================================================
		//	RemoveStarRegistry( RegistryName AS ByteString, Key AS ByteString, Value AS ByteString )
		else if( aName.CompareIgnoreCaseToAscii("RemoveStarRegistry") == COMPARE_EQUAL )
		{
			if( !_StarRegister(pArr, m_rCS, m_rEnv, FALSE) )
				pVar->PutBool( FALSE );
			else
				pVar->PutBool( TRUE );
		}

		//=====================================================================
		//=====================================================================
		//	GetSystemPathArray()
		else if( aName.CompareIgnoreCaseToAscii("GetSystemPathArray") == COMPARE_EQUAL )
		{
			SbxDimArrayRef xArray = new SbxDimArray( SbxSTRING );
			ByteString aSysPath( getenv("PATH") );
			if( !aSysPath.Len() ) aSysPath = getenv("path");

#ifdef UNX
			char cDelim = ':';
#else
			char cDelim = ';';
#endif

			USHORT nDelimTok = 0;
			USHORT nTokCount = aSysPath.GetTokenCount( cDelim );

			xArray->unoAddDim( 0, nTokCount - 1);

			for( short x = 0; x < nTokCount; ++x )
			{
				ByteString aActValue( aSysPath.GetToken(0, cDelim, nDelimTok) );
				SbxVariableRef xVar = new SbxVariable( SbxSTRING );
				xVar->PutString( UniString::CreateFromAscii(aActValue.GetBuffer()) );
				xArray->Put( xVar, &x );
			}
			pVar->PutObject( xArray );
		}

		//=====================================================================
		//=====================================================================
		//			U S E R    D A T A
		else if( aName.CompareIgnoreCaseToAscii("SetUserFirstName") == COMPARE_EQUAL )
		{
			m_rEnv.SetUserFirstName( stringhelper::TrimString(pArr->Get(1)->GetString()));
		}
		else if( aName.CompareIgnoreCaseToAscii("SetUserLastName") == COMPARE_EQUAL )
		{
			m_rEnv.SetUserName( stringhelper::TrimString(pArr->Get(1)->GetString()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("SetUserID") == COMPARE_EQUAL )
		{
			m_rEnv.SetUserId( stringhelper::TrimString(pArr->Get(1)->GetString()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("SetUserEMail") == COMPARE_EQUAL )
		{
			m_rEnv.SetUserEMail( stringhelper::TrimString(pArr->Get(1)->GetString()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("SetUserStreet") == COMPARE_EQUAL )
		{
			m_rEnv.SetStreet( stringhelper::TrimString(pArr->Get(1)->GetString()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("SetUserZip") == COMPARE_EQUAL )
		{
			m_rEnv.SetZip( stringhelper::TrimString(pArr->Get(1)->GetString()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("SetUserCity") == COMPARE_EQUAL )
		{
			m_rEnv.SetCity( stringhelper::TrimString(pArr->Get(1)->GetString()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("SetUserCompanyname") == COMPARE_EQUAL )
		{
			m_rEnv.SetCompanyName( stringhelper::TrimString(pArr->Get(1)->GetString()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("SetUserCustomerNr") == COMPARE_EQUAL )
		{
			m_rEnv.SetCustomerNr( stringhelper::TrimString(pArr->Get(1)->GetString()) );
		}

#if defined OS2
		//=====================================================================
		//=====================================================================
		//	GetOSVersion
		else if( aName.CompareIgnoreCaseToAscii("GetOSVersion") == COMPARE_EQUAL )
		{
			USHORT nVersion = Os2OS::GetOSVersion();
			switch( nVersion )
			{
			case OS2_VER_211 :
				pVar->PutString( UniString::CreateFromAscii("OS2_VER_211") );
				break;
			case OS2_VER_WARP3:
				pVar->PutString( UniString::CreateFromAscii("OS2_VER_WARP3") );
				break;
			case OS2_VER_WARP4:
				pVar->PutString( UniString::CreateFromAscii("OS2_VER_WARP4") );
				break;
			default :
				pVar->PutString( UniString::CreateFromAscii("OS2_VER_ERROR") );
				break;
			}
		}
		//=====================================================================
		//=====================================================================
		//	GetOSSystemFolder
		else if( aName.CompareIgnoreCaseToAscii("GetOSSystemFolder") == COMPARE_EQUAL )
		{
			pVar->PutString( UniString::CreateFromAscii(OS::GetGUIPath().GetBuffer()) );
		}
		//=====================================================================
		//=====================================================================
		//	GetOSFavoritesFolder
		else if( pVar->GetName().CompareIgnoreCaseToAscii("GetOSFavoritesFolder") == COMPARE_EQUAL )
		{
			pVar->PutString( UniString::CreateFromAscii(Os2OS::GetFavoritesFolderName().GetBuffer()) );
		}
		//=====================================================================
		//=====================================================================
		//	WriteOS2Ini
		else if( pVar->GetName().CompareIgnoreCaseToAscii("WriteOS2Ini") == COMPARE_EQUAL )
		{
			Os2OS::WriteOS2Ini( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()),		/* AppName */
								ByteString(pArr->Get(2)->GetString(), osl_getThreadTextEncoding()),		/* Key */
								ByteString(pArr->Get(3)->GetString(), osl_getThreadTextEncoding()) ); 	/* Value */
		}
		//=====================================================================
		//=====================================================================
		//	ReadOS2Ini
		else if( pVar->GetName().CompareIgnoreCaseToAscii("ReadOS2Ini") == COMPARE_EQUAL )
		{
			ByteString aValue = Os2OS::ReadOS2Ini(
				ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()),		/* AppName */
				ByteString(pArr->Get(2)->GetString(), osl_getThreadTextEncoding()) );	/* Key */
			pVar->PutString( UniString::CreateFromAscii(aValue.GetBuffer()) );
		}
#endif

#if defined WIN || defined WNT
		//=====================================================================
		//=====================================================================
		//	AddEnvironmentPath
#define SUN_REMARK "rem insert by Sun Microsystems setup"

		else if( aName.CompareIgnoreCaseToAscii("AddEnvironmentPath") == COMPARE_EQUAL )
		{
			ByteString aPath( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );
			// ByteString aOS( WinOS::GetOSVersion() );
			if( !WinOS::IsNT()) // aOS == "W95" || aOS == "W98" )
			{
				SiDirEntry aEntry		( "c:\\autoexec.bat" );
				SiDirEntry aBakEntry	( "c:\\autoexec.bak" );

				if( m_rEnv.GetInstallType() != IT_RECOVER )
				{
					FileCopier aCopier( aEntry, aBakEntry );
					aBakEntry.Kill();
					aCopier.Execute();
				}

				FileStat::SetReadOnlyFlag( aEntry, FALSE );

				ByteString aKey( "set path=%path%;" );
				aKey += aPath;

				SvFileStream aStrm( aEntry.GetFullUni(), STREAM_READWRITE );

				BOOL bRecoverIt = TRUE;
				if( m_rEnv.GetInstallType() == IT_RECOVER )
				{
					ByteString aLine;
					while( aStrm.ReadLine(aLine) )
						if( aLine.CompareTo(aKey) == COMPARE_EQUAL )
							bRecoverIt = FALSE;
				}
				else
					aStrm.Seek( STREAM_SEEK_TO_END );

				if( m_rEnv.GetInstallType() != IT_RECOVER || bRecoverIt )
				{
					aStrm << "\r\n";          // #98747#
					aStrm << SUN_REMARK;
					aStrm << "\r\n";
					aStrm << aKey.GetBuffer();
					aStrm << "\r\n";
				}

				aStrm.Close();
			}
			else
			{
				ByteString aSysPath( WinOS::GetRegValue(
					"HKEY_CURRENT_USER",
					"Environment",
					"Path") );
/*				ByteString aSysPath( WinOS::GetRegValue(
				"HKEY_LOCAL_MACHINE",
				"SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment",
				"path") );
*/				if( !aSysPath.Len() || aSysPath.Search(aPath) == STRING_NOTFOUND )
 {
	 if( aSysPath.Len() &&
		 aSysPath.GetChar(aSysPath.Len() - 1) != ';' )
		 aSysPath += ';';
	 aSysPath += aPath;

//					WinOS::Register( "HKEY_LOCAL_MACHINE", "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment",
	 WinOS::Register( "HKEY_CURRENT_USER", "Environment",
					  "Path", aSysPath, FALSE, TRUE );
	 m_rEnv.SetPropagateWinEnvChange();
 }
			}
		}

		//=====================================================================
		//=====================================================================
		//	RemoveEnvironmentPath
		else if( aName.CompareIgnoreCaseToAscii("RemoveEnvironmentPath") == COMPARE_EQUAL )
		{
			ByteString aPath( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );

			// ByteString aOS( WinOS::GetOSVersion() );
			if( !WinOS::IsNT()) // aOS == "W95" || aOS == "W98" )
			{
				ByteString aLine;
				ByteString aKey( "set path=%path%;" );
				aKey += aPath;

				SiDirEntry aEntry( "c:\\autoexec.new" );
				aEntry.Kill();

				SvFileStream aStrm		( UniString::CreateFromAscii("c:\\autoexec.bat"), STREAM_READWRITE );
				SvFileStream aNewStrm	( UniString::CreateFromAscii("c:\\autoexec.new"), STREAM_READWRITE );

				while( aStrm.ReadLine(aLine) )
				{
					if( aLine.CompareIgnoreCaseToAscii(SUN_REMARK) != COMPARE_EQUAL &&
						aLine.CompareIgnoreCaseToAscii(aKey) != COMPARE_EQUAL )
						aNewStrm.WriteLine(aLine);
				}

				aStrm.Close();
				aNewStrm.Close();

				aEntry = ByteString("c:\\autoexec.bat");
				SiDirEntry aNewEntry( "c:\\autoexec.bak" );

				aNewEntry.Kill();
				aEntry.MoveTo( aNewEntry );

				aEntry = ByteString("c:\\autoexec.new");
				aNewEntry = ByteString("c:\\autoexec.bat");
				aEntry.MoveTo( aNewEntry );
			}
			else
			{
				ByteString aSysPath( WinOS::GetRegValue(
					"HKEY_CURRENT_USER",
					"Environment",
					"path") );
/*				ByteString aSysPath( WinOS::GetRegValue(
				"HKEY_LOCAL_MACHINE",
				"SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment",
				"path") );
*/
				while( aSysPath.SearchAndReplace(aPath, "") != STRING_NOTFOUND );
				while( aSysPath.SearchAndReplace(";;", ";") != STRING_NOTFOUND );

                if ( aSysPath.Len() )
                {
                    if( aSysPath.GetChar(aSysPath.Len() - 1) == ';' )
                        aSysPath.Erase( aSysPath.Len() - 1 );
//                  WinOS::Register( "HKEY_LOCAL_MACHINE", "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment",
                    WinOS::Register( "HKEY_CURRENT_USER", "Environment",
                                     "path", aSysPath, FALSE, TRUE );
                    m_rEnv.SetPropagateWinEnvChange();
                }
			}
		}

		//=====================================================================
		//=====================================================================
		//	AddEnvironmentVar
		else if( aName.CompareIgnoreCaseToAscii("AddEnvironmentVar") == COMPARE_EQUAL )
		{
			ByteString aKey( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );
			ByteString aVal( ByteString(pArr->Get(2)->GetString(), osl_getThreadTextEncoding()) );

			// ByteString aOS( WinOS::GetOSVersion() );
			if( !WinOS::IsNT() ) // aOS == "W95" || aOS == "W98" )
			{
				ByteString aEntryStr( "set " );
				aEntryStr += aKey;
				aEntryStr += "=";
				aEntryStr += aVal;

				SvFileStream aStrm( UniString::CreateFromAscii("c:\\autoexec.bat"), STREAM_READWRITE );

				BOOL bRecoverIt = TRUE;
				if( m_rEnv.GetInstallType() == IT_RECOVER )
				{
					ByteString aLine;
					while( aStrm.ReadLine(aLine) )
						if( aLine.CompareTo(aEntryStr) == COMPARE_EQUAL )
							bRecoverIt = FALSE;
				}
				else
					aStrm.Seek( STREAM_SEEK_TO_END );

				if( m_rEnv.GetInstallType() != IT_RECOVER || bRecoverIt )
				{
					aStrm << "\r\n";                   // #98747# added a newline first
					aStrm << SUN_REMARK;
					aStrm << "\r\n";
					aStrm << aEntryStr.GetBuffer();
					aStrm << "\r\n";
				}

				aStrm.Close();
			}
			else
			{
				WinOS::Register(
					"HKEY_CURRENT_USER",
					"Environment",
					aKey, aVal, FALSE, TRUE );
				m_rEnv.SetPropagateWinEnvChange();
			}
		}

		//=====================================================================
		//=====================================================================
		//	RemoveEnvironmentVar
		else if( aName.CompareIgnoreCaseToAscii("RemoveEnvironmentVar") == COMPARE_EQUAL )
		{
			ByteString aKey( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );
			ByteString aVal( ByteString(pArr->Get(2)->GetString(), osl_getThreadTextEncoding()) );

			// ByteString aOS( WinOS::GetOSVersion() );
			if( !WinOS::IsNT()) // aOS == "W95" || aOS == "W98" )
			{
				ByteString aLine;
				ByteString aEntryStr( "set " );
				aEntryStr += aKey;
				aEntryStr += "=";
				aEntryStr += aVal;

				SiDirEntry aEntry( "c:\\autoexec.new" );
				aEntry.Kill();

				SvFileStream aStrm		( UniString::CreateFromAscii("c:\\autoexec.bat"), STREAM_READWRITE );
				SvFileStream aNewStrm	( UniString::CreateFromAscii("c:\\autoexec.new"), STREAM_READWRITE );

				while( aStrm.ReadLine(aLine) )
				{
					if( aLine.CompareIgnoreCaseToAscii(SUN_REMARK) != COMPARE_EQUAL &&
						aLine.CompareIgnoreCaseToAscii(aEntryStr) != COMPARE_EQUAL )
						aNewStrm.WriteLine(aLine);
				}

				aStrm.Close();
				aNewStrm.Close();

				aEntry = ByteString("c:\\autoexec.bat");
				SiDirEntry aNewEntry( "c:\\autoexec.bak" );

				aNewEntry.Kill();
				aEntry.MoveTo( aNewEntry );

				aEntry = ByteString("c:\\autoexec.new");
				aNewEntry = ByteString("c:\\autoexec.bat");
				aEntry.MoveTo( aNewEntry );
			}
			else
			{
				ByteString aDelete("Environment");
				WinOS::Deregister( "HKEY_CURRENT_USER", aDelete, FALSE, aKey, FALSE, FALSE );
				m_rEnv.SetPropagateWinEnvChange();
			}
		}

		//=====================================================================
		//=====================================================================
		//	GetSystemFontPath
		else if( aName.CompareIgnoreCaseToAscii("GetSystemFontPath") == COMPARE_EQUAL )
		{
			ByteString aReturn = OS::GetSystemFontPath();
			pVar->PutString( UniString::CreateFromAscii(aReturn.GetBuffer()) );
		}

		//=====================================================================
		//=====================================================================
		//	GetOSVersion
		else if( aName.CompareIgnoreCaseToAscii("GetOSVersion") == COMPARE_EQUAL )
		{
			ByteString aReturn = WinOS::GetOSVersion();
			pVar->PutString( UniString::CreateFromAscii(aReturn.GetBuffer()) );
		}

		//=====================================================================
		//=====================================================================
		//	GetRegValue
		else if( pVar->GetName().CompareIgnoreCaseToAscii("GetRegValue") == COMPARE_EQUAL )
		{
			DBG_ASSERT(pArr->Count() == 4, "GetRegValue(Param1,Param2,Param3)");

			pVar->PutString(
				UniString::CreateFromAscii(WinOS::GetRegValue(
					ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()),
					ByteString(pArr->Get(2)->GetString(), osl_getThreadTextEncoding()),
					ByteString(pArr->Get(3)->GetString(), osl_getThreadTextEncoding())).GetBuffer()));
		}

        //=====================================================================
        //=====================================================================
        //	GetSubRegValues
        else if( pVar->GetName().CompareIgnoreCaseToAscii("GetSubRegValues") == COMPARE_EQUAL )
        {
            DBG_ASSERT(pArr->Count() == 3, "GetSubRegValues( Param1, Param2 )");

            SiValueList aValues = WinOS::GetSubRegValues( pArr->Get(1)->GetString(), 
                                                          pArr->Get(2)->GetString() );

            SbxDimArrayRef xArray = new SbxDimArray( SbxSTRING );

            xArray->unoAddDim( 0, (short) aValues.Count() - 1 );

            for( short i = 0; i < (short) aValues.Count(); ++i )
            {
                String* pValue = aValues.GetObject(i);
                SbxVariableRef xVar = new SbxVariable( SbxSTRING );
                xVar->PutString( *pValue );
                xArray->Put( xVar, &i );
                delete pValue;
            }

            USHORT nFlags = pVar->GetFlags();
            pVar->ResetFlag( SBX_FIXED );
            pVar->PutObject( xArray );
            pVar->SetFlags( nFlags );
            pVar->SetParameters( NULL );
        }

		//=====================================================================
		//=====================================================================
		//	SetRegValue
		else if( pVar->GetName().CompareIgnoreCaseToAscii("SetRegValue") == COMPARE_EQUAL )
		{
			ByteString aKey		( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );
			ByteString aSubKey	( ByteString(pArr->Get(2)->GetString(), osl_getThreadTextEncoding()) );
			ByteString aData	( ByteString(pArr->Get(3)->GetString(), osl_getThreadTextEncoding()) );
			ByteString aVal		( ByteString(pArr->Get(4)->GetString(), osl_getThreadTextEncoding()) );
			BOOL bHex = pArr->Get(5)->GetBool();

			WinOS::Register(aKey, aSubKey, aData, aVal, bHex);
		}

		//=====================================================================
		//=====================================================================
		//	DeleteRegValue
		else if( pVar->GetName().CompareIgnoreCaseToAscii("DeleteRegValue") == COMPARE_EQUAL )
		{
			ByteString aKey		( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );
			ByteString aSubKey	( ByteString(pArr->Get(2)->GetString(), osl_getThreadTextEncoding()) );
			ByteString aName	( ByteString(pArr->Get(3)->GetString(), osl_getThreadTextEncoding()) );

			WinOS::Deregister( aKey, aSubKey, aName.Len() == 0, aName, aName.Len() == 0, TRUE );
		}

		//=====================================================================
		//=====================================================================
		//	DeleteRecursiveRegKey
		else if( pVar->GetName().CompareIgnoreCaseToAscii("DeleteRecursiveRegKey") == COMPARE_EQUAL )
		{
			ByteString aKey		( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );
			ByteString aSubKey	( ByteString(pArr->Get(2)->GetString(), osl_getThreadTextEncoding()) );

			WinOS::Deregister( aKey, aSubKey, FALSE, "", TRUE, TRUE );
		}

		//=====================================================================
		//=====================================================================
		//	IsRegKey
		else if( pVar->GetName().CompareIgnoreCaseToAscii("IsRegKey") == COMPARE_EQUAL )
		{
			ByteString aKey		( ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding()) );
			ByteString aSubKey	( ByteString(pArr->Get(2)->GetString(), osl_getThreadTextEncoding()) );
			pVar->PutBool( WinOS::IsRegistered(aKey, aSubKey, "", FALSE) );
		}

		//=====================================================================
		//=====================================================================
		//	GetOSPersonalFolder
		else if( pVar->GetName().CompareIgnoreCaseToAscii("GetOSPersonalFolder") == COMPARE_EQUAL )
		{
			pVar->PutString( WinOS::SHGetPersonalFolderName().GetBuffer() );
		}

		//=====================================================================
		//=====================================================================
		//	GetOSFavoritesFolder
		else if( pVar->GetName().CompareIgnoreCaseToAscii("GetOSFavoritesFolder") == COMPARE_EQUAL )
		{
			pVar->PutString( WinOS::SHGetFavoritesFolderName().GetBuffer() );
		}

		//=====================================================================
		//=====================================================================
		//	GetOSTemplateFolder
		else if( pVar->GetName().CompareIgnoreCaseToAscii("GetOSTemplateFolder") == COMPARE_EQUAL )
		{
			pVar->PutString( WinOS::SHGetTemplateFolderName( FALSE ).GetBuffer() );
		}

		//=====================================================================
		//=====================================================================
		//	GetOSAutostartFolder
		else if( pVar->GetName().CompareIgnoreCaseToAscii("GetOSAutostartFolder") == COMPARE_EQUAL )
		{
			pVar->PutString( WinOS::SHGetAutostartFolderName().GetBuffer() );
		}

		//=====================================================================
		//=====================================================================
		//	GetOSDesktopFolder
		else if( pVar->GetName().CompareIgnoreCaseToAscii("GetOSDesktopFolder") == COMPARE_EQUAL )
		{
			pVar->PutString( WinOS::SHGetSystemDesktopFolderName().GetBuffer() );
		}

		//=====================================================================
		//=====================================================================
		//	GetOSSystemFolder
		else if( pVar->GetName().CompareIgnoreCaseToAscii("GetOSSystemFolder") == COMPARE_EQUAL )
		{
			pVar->PutString( UniString(OS::GetSystemPath().GetBuffer(), osl_getThreadTextEncoding()) );
		}
#endif
#ifdef UNX
		//=====================================================================
		//=====================================================================
		//	GetUNXPgpVersion
		else if( pVar->GetName().CompareIgnoreCaseToAscii("GetUNXPgpVersion") == COMPARE_EQUAL )
		{
			ByteString aAbsBinaryname( "/bin/sh -c \"" );
			aAbsBinaryname += ByteString(pArr->Get(1)->GetString(), osl_getThreadTextEncoding());
			aAbsBinaryname += " 2>&1 /dev/null\"";
			ByteString aVersion;

			FILE* pOut = popen( aAbsBinaryname.GetBuffer(), "r" );
			if( pOut )
			{
				char pBuf[MAX_BUF];
				while( !feof(pOut) )
				{
					size_t nRead = fread( pBuf, 1, MAX_BUF, pOut );
					ByteString aBuf( pBuf );
					USHORT nPos = aBuf.Search( "Version" );
					if( nPos != STRING_NOTFOUND )
					{
						nPos += 7;
						USHORT nLen = aBuf.Search( '\n', nPos );
						if( nLen != STRING_NOTFOUND )
						{
							aVersion = aBuf.Copy( nPos, nLen-nPos );
							break;
						}
					}
					if( !feof(pOut) ) {
						nRead -= BUF_OVERFLOW_SPOOL_BACK;
						fseek( pOut, 0, nRead );
					}
				}
				fclose( pOut );
			}
			aVersion.EraseLeadingChars();
			aVersion.EraseTrailingChars();
			pVar->PutString( UniString::CreateFromAscii(aVersion.GetBuffer()) );
		}
#endif
		return;
	}
	SfxListener::Notify(rBC, rHint);
}

//=============================================================================
//=============================================================================
//	Setup-Basic
void _Insert( SbxMethodRef pFnc, SibListener* pListener, StarBASIC* pBasic )
{
	pBasic->Insert( pFnc );
	pListener->StartListening( pFnc->GetBroadcaster(), TRUE );
}

void SiBasic::InsertMethod(const ByteString& rFncName, SbxDataType eType)
{
	SbxMethodRef pFnc = new SbxMethod( UniString::CreateFromAscii(rFncName.GetBuffer()), eType );
	m_rBasic->Insert( pFnc );
	m_Listener->StartListening( pFnc->GetBroadcaster(), TRUE );
}

// SiBasicImpl* SiBasic::GetImpl()
// {
// // 	if(!m_pImp)
// // 		m_pImp = new SiBasicImpl(m_rEnv);
// // 	return m_pImp;
//     OSL_ASSERT(0);
//     return 0;
// }

SiBasic::SiBasic(SiCompiledScript &rCS, SiEnvironment &rEnv) :
	m_rEnv( rEnv )
{
	m_rBasic	= new StarBASIC;
	m_pImp 		= NULL;
	m_Listener	= new SibListener(rCS, rEnv,this);

	////////////////////////////////////////////////////////////////////////////////
	//	Script Functions
	InsertMethod( "GetScriptObject",				SbxOBJECT );
	InsertMethod( "GetSetupEnv",					SbxOBJECT );
	InsertMethod( "SetReboot",						SbxVOID );
	InsertMethod( "SetLogout",						SbxVOID );
	InsertMethod( "DefuseRestart",					SbxVOID );
	InsertMethod( "DirEntry",						SbxSTRING );
	InsertMethod( "Copy",							SbxBOOL );
	InsertMethod( "SetSystemIntegration",			SbxVOID );

	InsertMethod( "SetUserFirstName",				SbxVOID );
	InsertMethod( "SetUserLastName",				SbxVOID );
	InsertMethod( "SetUserID",						SbxVOID );
	InsertMethod( "SetUserEMail",					SbxVOID );
	InsertMethod( "SetUserStreet",					SbxVOID );
	InsertMethod( "SetUserZip",						SbxVOID );
	InsertMethod( "SetUserCity",					SbxVOID );
	InsertMethod( "SetUserCompanyname",				SbxVOID );
	InsertMethod( "SetUserCustomerNr",				SbxVOID );

	InsertMethod( "SetDestinationPath",             SbxVOID );

	////////////////////////////////////////////////////////////////////////////////
	//	Module Functions
	InsertMethod( "SelectModuleSet",				SbxBOOL );
	InsertMethod( "SelectModuleByName",				SbxBOOL );
	InsertMethod( "SelectModuleByID",				SbxBOOL );
	InsertMethod( "DeSelectModuleSet",				SbxBOOL );
	InsertMethod( "DeSelectModuleByName",			SbxBOOL );
	InsertMethod( "DeSelectModuleByID",				SbxBOOL );
	InsertMethod( "SetDefaultModuleByID",			SbxBOOL );
	InsertMethod( "SetDefaultModuleByName",			SbxBOOL );
	InsertMethod( "SetMinimalModuleByID",			SbxBOOL );
	InsertMethod( "SetMinimalModuleByName",			SbxBOOL );
	InsertMethod( "SetHiddenModuleByID",			SbxBOOL );
	InsertMethod( "SetHiddenModuleByName",			SbxBOOL );

	////////////////////////////////////////////////////////////////////////////////
	//	UI Functions
	InsertMethod( "UI",								SbxOBJECT );
	InsertMethod( "PageRule",						SbxVOID );
	InsertMethod( "PageRuleIf",						SbxVOID );
	InsertMethod( "SiMsgbox",						SbxVOID );
	InsertMethod( "SiQueryBox",						SbxUSHORT );

	////////////////////////////////////////////////////////////////////////////////
	//	Help Functions
	InsertMethod( "GetRegValue",					SbxSTRING );
    InsertMethod( "GetSubRegValues",                SbxOBJECT );
	InsertMethod( "SetRegValue",					SbxVOID );
	InsertMethod( "DeleteRegValue",					SbxVOID );
	InsertMethod( "DeleteRecursiveRegKey",			SbxVOID );
	InsertMethod( "IsRegKey",						SbxBOOL );
	InsertMethod( "HideSetup",						SbxVOID );
	InsertMethod( "ShowSetup",						SbxVOID );
	InsertMethod( "SetFollowApplication",			SbxVOID );
	InsertMethod( "SyncStartApplication",			SbxBOOL );
	InsertMethod( "ShellExecute",					SbxVOID );
	InsertMethod( "GetFreeOSDriveSize",				SbxULONG );
	InsertMethod( "GetOSVersion",					SbxSTRING );
	InsertMethod( "GetMajor",						SbxSTRING );

	InsertMethod( "SelectLanguages",				SbxVOID );
	InsertMethod( "GetInstalledLanguages",			SbxOBJECT );
	InsertMethod( "GetSelectedLanguages",			SbxOBJECT );
	InsertMethod( "GetUILanguage",					SbxUSHORT );

	InsertMethod( "InitiateWorkstation",			SbxVOID );
	InsertMethod( "AddExplicitUNOReg",				SbxVOID );
	InsertMethod( "IsMigration",					SbxBOOL );
	InsertMethod( "IsResponsefileMode",				SbxBOOL );

	InsertMethod( "WriteStarRegistry",				SbxBOOL );
	InsertMethod( "RemoveStarRegistry",				SbxBOOL );
	InsertMethod( "GetSystemPathArray",				SbxOBJECT );
	InsertMethod( "cvtuilang",  					SbxSTRING );


	////////////////////////////////////////////////////////////////////////////////
	//	Special OS Folder
	InsertMethod( "GetOSPersonalFolder",			SbxSTRING );
	InsertMethod( "GetOSFavoritesFolder",			SbxSTRING );
	InsertMethod( "GetOSTemplateFolder",			SbxSTRING );
	InsertMethod( "GetOSAutostartFolder",			SbxSTRING );
	InsertMethod( "GetOSDesktopFolder",				SbxSTRING );
	InsertMethod( "GetOSSystemFolder", 				SbxSTRING );
#ifdef OS2
	InsertMethod( "WriteOS2Ini", 					SbxVOID );
	InsertMethod( "ReadOS2Ini", 					SbxSTRING );
#endif
#ifdef WNT
	InsertMethod( "AddEnvironmentPath",	  			SbxSTRING );
	InsertMethod( "RemoveEnvironmentPath",	  		SbxSTRING );
	InsertMethod( "AddEnvironmentVar",	  			SbxSTRING );
	InsertMethod( "RemoveEnvironmentVar",	  		SbxSTRING );
    InsertMethod( "GetSystemFontPath",              SbxSTRING );
#endif
#ifdef UNX
	InsertMethod( "GetUNXPgpVersion",	  	   		SbxSTRING );
#endif
}

SiBasic::~SiBasic()
{
	m_Listener->EndListeningAll();
	delete m_Listener;
// 	delete m_pImp;
}

void SiBasic::SetAgentDlg(SvAgentDlg* pDlg) const
	{
	if( m_Listener )
		m_Listener->SetAgentDlg( pDlg );
}

void SiBasic::Error(ByteString const& Message, ByteString const& SubName, USHORT nLine) const
{
	ByteString aMsg( Message );
	aMsg += "\nFunction: '";
	aMsg += SubName;
	aMsg += "' Line: ";
	aMsg += ByteString::CreateFromInt32(nLine);

	if ( m_rEnv.HasVCL() )
		InfoBox( NULL, UniString::CreateFromAscii(aMsg.GetBuffer()) ).Execute();
	else
		fprintf( stderr, "\n%s\n", aMsg.GetBuffer() );
}

BOOL SiBasic::Call(ByteString const& SubName, ByteString const& aSource)
{
	UniString aSourceCode( aSource, RTL_TEXTENCODING_MS_1252 );

	SbModuleRef rModule = m_rBasic->MakeModule( UniString::CreateFromAscii("aModule"), aSourceCode );
	BOOL bOk = TRUE;

	StarBASIC::StaticSuppressSfxResource( TRUE );

    if ( ! m_rEnv.HasVCL() )
        StarBASIC::StaticEnableReschedule( FALSE );

    if( !m_rBasic->Compile(rModule) )
	{
		if( !m_Listener->GetEnvironment().NoBasicError() )
		{
			Error( ByteString(m_rBasic->GetErrorText(), osl_getThreadTextEncoding()),
				   SubName,
				   m_rBasic->GetLine() );
		}
		bOk = FALSE;
	}

	UniString aUniProcName(SubName, osl_getThreadTextEncoding());
	if( bOk && (!m_rBasic->Call(aUniProcName) || m_rBasic->GetErrorCode() != 0) )
	{
		if( !m_Listener->GetEnvironment().NoBasicError() )
			Error( ByteString(m_rBasic->GetErrorText(), osl_getThreadTextEncoding()), SubName, m_rBasic->GetLine());
		bOk = FALSE;
	}

    StarBASIC::StaticSuppressSfxResource( FALSE );

    if ( ! m_rEnv.HasVCL() )
        StarBASIC::StaticEnableReschedule( TRUE );

    m_rBasic->Remove(rModule);
	return bOk;
}


