/*************************************************************************
 *
 *  $RCSfile: sample.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:08:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "sicustom.hxx"


SiSetupFnc aSetupFnc;

////////////////////////////////////////////////////////////////////////////////
//
//	EntryPoint
//
extern "C" {
BOOL _SV_CALL CustomInit(SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc)
{
	// inkompatibel oder nicht vorhanden ?
	if( !pSetupFnc || pSetupFnc->nVersion > SICUSTOM_VERSION )
		return FALSE;

	pCustomFnc->fncMain = (FncPtrCustomMain)CustomMain;

	aSetupFnc.nVersion 		= pSetupFnc->nVersion;
	aSetupFnc.fncHideSetup	= pSetupFnc->fncHideSetup;
	aSetupFnc.fncShowSetup	= pSetupFnc->fncShowSetup;

	return TRUE;
}
};

////////////////////////////////////////////////////////////////////////////////
//
//	CustomMain
//

BOOL gbWasAlive = FALSE;

BOOL _SV_CALL CustomMain(SiCustomEnvironment* pEnv, SiCustomModuleList* pList)
{
	ByteString aStr;

	aStr += "Demo CustomDLL 'sic";
	aStr += ByteString::CreateFromInt32(SUPD);
	aStr += __DLLEXTENSION;
	aStr += ".dll'\n";
	
    aStr += "\nFirstInstallation:\t";
	aStr += pEnv->IsFirstInstallation()? "Ja" : "Nein";
	
    aStr += "\nHas been alive:\t";
	aStr += gbWasAlive? "Yes" : "No";
	
    aStr += "\nIs Modify:\t";
	aStr += pEnv->IsModify()? "Yes" : "No";

	aStr += "\nIs Pre:\t";
	aStr += pEnv->IsPre()? "Yes" : "No";

	aStr += "\nContext:\t\t";
	aStr += pEnv->IsInstallation() ? "Installiert" : "Deinstalliert";

    aStr += "\nStartPath:\t\t";
	aStr += pEnv->GetStartPath();
	aStr += "\nSourcePath:\t";
	aStr += pEnv->GetSourcePath();
	aStr += "\nDestPath:\t\t";
	aStr += pEnv->GetDestPath();
	aStr += "\nInstalledPath:\t";
	aStr += pEnv->GetInstalledPath();
	aStr += "\n\nBekannte Module:\n";

	for(USHORT i = 0; i < pList->Count(); ++ i)
	{
		aStr += "\n";
		aStr += pList->GetObject(i)->GetModuleName();
		aStr += ";  ";
		aStr += pList->GetObject(i)->GetModuleID();
		aStr += ";  ";
		if(pList->GetObject(i)->IsSelected())
			aStr += "AN";
		else
			aStr += "AUS";
	}
	InfoBox(NULL, UniString::CreateFromAscii(aStr.GetBuffer()) ).Execute();

	// fncHideSetup
	InfoBox(NULL, UniString::CreateFromAscii("CustomDLL hidet Setup.\nfncHideSetup")).Execute();
	aSetupFnc.fncHideSetup();

	// fncShowSetup
	InfoBox(NULL, UniString::CreateFromAscii("... und showt es wieder.\nfncShowSetup")).Execute();
	aSetupFnc.fncShowSetup();

    gbWasAlive = TRUE;

	return TRUE;
}
