/*************************************************************************
#*
#*    $RCSfile: update.cxx,v $
#*
#*    class classname(s)
#*
#*    Implementation    APPSERV.CXX
#*
#*    Description       setup custom plugin for updateing a 6.0 to 6.x
#*                      main purpose is to provide an environment for a
#*                      XSLT parser/processor
#*                      
#*    Creation date     TPF  04/22/2002
#*    last change       $Author: hr $ $Date: 2004/01/09 18:52:39 $
#*    $Revision: 1.8.20.1 $
#*
#*    Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
#*
#*************************************************************************/

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _SV_CONFIG_HXX
#include <tools/config.hxx>
#endif

#include <vcl/svapp.hxx>

#include <vos/thread.hxx>
#include <vos/process.hxx>
#include <vos/socket.hxx>

#include <sifsys.hxx>
#include <environ.hxx>
#include <sicustom.hxx>

#ifndef __DECLTOR_HXX
#include <decltor.hxx>
#endif

#ifdef UNX
#include <unistd.h>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _RTL_URI_HXX_
#include <rtl/uri.hxx>
#endif

//#ifdef _USE_NAMESPACE
//using namespace vos;
//using namespace osl;
//#endif

//#define LIBXML_STATIC 1
//#define LIBXSLT_STATIC 1
//#define LIBEXSLT_STATIC 1
//
//#include <libxml/xmlmemory.h>
//#include <libxml/debugXML.h>
//#include <libxml/HTMLtree.h>
//#include <libxml/xmlIO.h>
//#include <libxml/DOCBparser.h>
//#include <libxml/xinclude.h>
//#include <libxml/catalog.h>
//#include <libxslt/xslt.h>
//#include <libxslt/xsltInternals.h>
//#include <libxslt/transform.h>
//#include <libxslt/xsltutils.h>

#ifndef SablotHIncl
#include <sablot/sablot.h>
#endif

#include "update.hxx"

using ::osl::FileBase;
using ::osl::FileStatus;
using ::rtl::OString;

//------------------------------------------------------------------------

static SiSetupFnc   setupFunction;
static BOOL         bWorkAroundWin32SecurityBug = FALSE;

UniString       sResourceHook_ProductName;
UniString       sResourceHook_ProductVersion;
ResHookProc     fOldResourceHook = NULL;

extern "C"
{
    BOOL _SV_CALL CustomInit
    (
        SiSetupFnc*     pSetupFunction,
        SiCustomFnc*    pCustomFunction
    )
    {
        BOOL    bResult = FALSE;

        if( pSetupFunction != 0 && pSetupFunction -> nVersion <= SICUSTOM_VERSION )

        {
            pCustomFunction -> fncMain = ( FncPtrCustomMain ) CustomMain;

            setupFunction.nVersion     = pSetupFunction -> nVersion;
            setupFunction.fncHideSetup = pSetupFunction -> fncHideSetup;
            setupFunction.fncShowSetup = pSetupFunction -> fncShowSetup;

            bResult = TRUE;
        }

        return bResult;
    }

    BOOL _SV_CALL CustomMain
    (
        SiCustomEnvironment*    pEnvironment,
        SiCustomModuleList*     pListOfModules
    )
    {

//String      sErrorMsg   = String( String::CreateFromAscii("CustomMain - Start") );
//WarningBox  wb          ( 0, WB_OK, sErrorMsg );
//            wb.Execute();

        BOOL    bResult =                       TRUE;
        String  sSetupDir(                      pEnvironment->GetStartPath(), osl_getThreadTextEncoding() );
        String  sInstallDir(                    pEnvironment->GetDestPath(), osl_getThreadTextEncoding() );
        String  sInstalledDir(                  pEnvironment->GetInstalledPath(), osl_getThreadTextEncoding() );
        String  sProductName(                   pEnvironment->GetBigEnv()->GetVendorName(), osl_getThreadTextEncoding() );
        String  sProductVersion(                pEnvironment->GetBigEnv()->GetVendorVersion(), osl_getThreadTextEncoding() );
                sResourceHook_ProductName   =   String( pEnvironment->GetBigEnv()->GetSingleProductName(), osl_getThreadTextEncoding() );
                sResourceHook_ProductVersion=   String( pEnvironment->GetBigEnv()->GetProductVersion(), osl_getThreadTextEncoding() );

        if ( pEnvironment->GetBigEnv()->IsUpdateOldVersion() && pEnvironment->IsPost() )
        {
//String      sErrorMsg   = String( String::CreateFromAscii("CustomMain - doUpdate") );
//WarningBox  wb          ( 0, WB_OK, sErrorMsg );
//            wb.Execute();

            sProductName = (sProductName.Append(String::CreateFromAscii(" "))).Append(sProductVersion);

            UpdatePlugIn aUpdatePlugIn( pEnvironment,
                                        pListOfModules,
                                        sSetupDir,
                                        sInstallDir,
                                        sInstalledDir,
                                        sProductName);

            bResult = aUpdatePlugIn.doUpdate();
        }

//if (bResult==TRUE) {
//    sErrorMsg   = String( String::CreateFromAscii("CustomMain - positive End") );
//}
//else {
//    sErrorMsg   = String( String::CreateFromAscii("CustomMain - negative End") );
//}
//WarningBox  wb1         ( 0, WB_OK, sErrorMsg );
//            wb1.Execute();

        return bResult;
    }

    void ResourceHook( UniString& rStr )
    {
        rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTNAME"),       sResourceHook_ProductName );
        rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTVERSION"),    sResourceHook_ProductVersion );
    }
};

//------------------------------------------------------------------------

UpdatePlugIn::UpdatePlugIn
(
    SiCustomEnvironment*    pEnvironment,
    SiCustomModuleList*     pListOfModules,
    const String            aSetupDir,
    const String            aInstallDir,
    const String            sInstalledDir,
    const String            sProductName
)
:   m_pEnvironment(pEnvironment),
    m_pListOfModules(pListOfModules),
    m_sSetupDir(aSetupDir),
    m_sInstallDir(aInstallDir),
    m_sInstalledDir(sInstalledDir),
    m_sProductName(sProductName)
{
    SiDirEntry aXsltPath(m_sSetupDir);
    aXsltPath += SiDirEntry("user_registry.xsl");

    FileBase::getFileURLFromSystemPath(aXsltPath.GetFullUni(), m_sXsltFile);
    
    SiDirEntry aOldXmlDir(m_sInstalledDir);
    aOldXmlDir += SiDirEntry(OUString::createFromAscii("user"));
    aOldXmlDir += SiDirEntry(OUString::createFromAscii("config"));
    aOldXmlDir += SiDirEntry(OUString::createFromAscii("registry"));
    aOldXmlDir += SiDirEntry(OUString::createFromAscii("instance"));
    FileBase::getFileURLFromSystemPath(aOldXmlDir.GetFullUni(), m_sOldRootDir);

    SiDirEntry aNewXmlDir(m_sInstalledDir);
    aNewXmlDir += SiDirEntry(OUString::createFromAscii("user"));
    aNewXmlDir += SiDirEntry(OUString::createFromAscii("registry"));
    aNewXmlDir += SiDirEntry(OUString::createFromAscii("data"));
    FileBase::getFileURLFromSystemPath(aNewXmlDir.GetFullUni(), m_sNewRootDir);
}

UpdatePlugIn::~UpdatePlugIn( )
{
}

//------------------------------------------------------------------------

BOOL UpdatePlugIn::doUpdate()
{
//String      sErrorMsg   = String( String::CreateFromAscii("doUpdate") );
//WarningBox  wb          ( 0, WB_OK, sErrorMsg );
//            wb.Execute();

    // transform UserProfile

    OUString sUserProfileSourceFileUrl;
    OUString sUserProfileDrainFileUrl;

    SiDirEntry aUserProfileSourceDir(m_sInstalledDir);
    aUserProfileSourceDir += SiDirEntry(OUString::createFromAscii("share"));
    aUserProfileSourceDir += SiDirEntry(OUString::createFromAscii("config"));
    aUserProfileSourceDir += SiDirEntry(OUString::createFromAscii("registry"));
    aUserProfileSourceDir += SiDirEntry(OUString::createFromAscii("instance"));
    aUserProfileSourceDir += SiDirEntry(OUString::createFromAscii("org"));
    aUserProfileSourceDir += SiDirEntry(OUString::createFromAscii("openoffice"));
    aUserProfileSourceDir += SiDirEntry(OUString::createFromAscii("UserProfile.xml"));
    FileBase::getFileURLFromSystemPath(aUserProfileSourceDir.GetFullUni(), sUserProfileSourceFileUrl);

    SiDirEntry aUserProfileDrainDir(m_sInstalledDir);
    aUserProfileDrainDir += SiDirEntry(OUString::createFromAscii("share"));
    aUserProfileDrainDir += SiDirEntry(OUString::createFromAscii("registry"));
    aUserProfileDrainDir += SiDirEntry(OUString::createFromAscii("data"));
    aUserProfileDrainDir += SiDirEntry(OUString::createFromAscii("org"));
    aUserProfileDrainDir += SiDirEntry(OUString::createFromAscii("openoffice"));
    aUserProfileDrainDir.MakeDir();
    aUserProfileDrainDir += SiDirEntry(OUString::createFromAscii("UserProfile.xcu"));
    FileBase::getFileURLFromSystemPath(aUserProfileDrainDir.GetFullUni(), sUserProfileDrainFileUrl);

    transform(sUserProfileSourceFileUrl, m_sXsltFile, sUserProfileDrainFileUrl);

    // create {inst_dir}/user/registry/data/org/openoffice/ucb + Office
    SiDirEntry aNewUcbDir(m_sInstalledDir);
    aNewUcbDir += SiDirEntry(OUString::createFromAscii("user"));
    aNewUcbDir += SiDirEntry(OUString::createFromAscii("registry"));
    aNewUcbDir += SiDirEntry(OUString::createFromAscii("data"));
    aNewUcbDir += SiDirEntry(OUString::createFromAscii("org"));
    aNewUcbDir += SiDirEntry(OUString::createFromAscii("openoffice"));
    aNewUcbDir += SiDirEntry(OUString::createFromAscii("ucb"));
    aNewUcbDir.MakeDir();
    SiDirEntry aNewOfficeDir(m_sInstalledDir);
    aNewOfficeDir += SiDirEntry(OUString::createFromAscii("user"));
    aNewOfficeDir += SiDirEntry(OUString::createFromAscii("registry"));
    aNewOfficeDir += SiDirEntry(OUString::createFromAscii("data"));
    aNewOfficeDir += SiDirEntry(OUString::createFromAscii("org"));
    aNewOfficeDir += SiDirEntry(OUString::createFromAscii("openoffice"));
    aNewOfficeDir += SiDirEntry(OUString::createFromAscii("Office"));
    aNewOfficeDir.MakeDir();

    // recurse in source dir
    Directory aDir(m_sOldRootDir);
    recurseUpdateDirs(aDir);

    return TRUE;
}

void UpdatePlugIn::recurseUpdateDirs(Directory & aDir)
{
    // proceed only if dir can be opened
    if (aDir.open()==FileBase::E_None)
    {
        // iterate over content of dir
        DirectoryItem aItem;
        while (aDir.getNextItem(aItem)==FileBase::E_None)
        {
            FileStatus aStatus(FileStatusMask_All);
            
            int nRc = aItem.getFileStatus(aStatus);
            
            if (nRc==FileBase::E_None)
            {
                // is item a dir?
                if (aStatus.getFileType()==FileStatus::Directory)
                {
                    // yes, so recurse
                    OUString sFileUrl(aStatus.getFileURL());
                    Directory aDir(sFileUrl);

                    recurseUpdateDirs(aDir);
                }
                else
                {
                    // no, so it's a file -> transform
                    FileStatus  aStatus(osl_FileStatus_Mask_All);
                    aItem.getFileStatus(aStatus);

                    OUString    sSourceUrl(aStatus.getFileURL());
                    OUString    sDrainUrl(sSourceUrl.replaceAt(
                                    sSourceUrl.lastIndexOf(OUString::createFromAscii(".xml")),
                                    4,
                                    OUString::createFromAscii(".xcu")));
                                    
                    sDrainUrl = sDrainUrl.replaceAt(0, m_sOldRootDir.getLength(), m_sNewRootDir);

                    transform(sSourceUrl, m_sXsltFile, sDrainUrl);
                }
            }
        }
    }
}

void UpdatePlugIn::transform(   const OUString & sSourceXml, 
                                const OUString & sTransformXml,
                                const OUString & sDrainXml)
{

    DirectoryItem aTestItem;

    // do source and transform file exist?
    if ((DirectoryItem::get(sSourceXml, aTestItem) == FileBase::E_None) &&
        (DirectoryItem::get(sTransformXml, aTestItem) == FileBase::E_None))
    {
        // yes, so transform
        SablotHandle p;
        SablotCreateProcessor(&p);
//        SablotSetLog( p, "user.log", 1);  
        
        OString sSourceXmlAscii(    rtl::OUStringToOString(sSourceXml,       RTL_TEXTENCODING_ASCII_US));
        OString sTransformXmlAscii( rtl::OUStringToOString(sTransformXml,    RTL_TEXTENCODING_ASCII_US));
        OString sDrainXmlAscii(     rtl::OUStringToOString(sDrainXml,        RTL_TEXTENCODING_ASCII_US));
        
        SablotRunProcessor( p,
                            (char*) sTransformXmlAscii.getStr(),
                            (char*) sSourceXmlAscii.getStr(),
                            (char*) sDrainXmlAscii.getStr(),
                            NULL,
                            NULL);

        if (p)
        {
            SablotDestroyProcessor(p);
        }
    }
}


//--- sablotron 0.97
//
//        SablotSituation S;
//        SablotHandle proc;
//        
//        SablotCreateSituation(&S);
//        SablotCreateProcessorForSituation(S, &proc);
//        
//        // sablot cannot handle encoded file URLs
//
//        OUString sSourceXmlDecoded(rtl::Uri::decode(    sSourceXml,     rtl_UriDecodeWithCharset, RTL_TEXTENCODING_UTF8));
//        OUString sTransformXmlDecoded(rtl::Uri::decode( sTransformXml,  rtl_UriDecodeWithCharset, RTL_TEXTENCODING_UTF8));
//        OUString sDrainXmlDecoded(rtl::Uri::decode(     sDrainXml,      rtl_UriDecodeWithCharset, RTL_TEXTENCODING_UTF8));
//    
//        // sablot cannot handle   file:///-URLs
//        // so I transform them to file://-URLs
//        // this holds true for non-UNIX systems only
//        
//        OString sSourceXmlAscii(    rtl::OUStringToOString(sSourceXmlDecoded,       osl_getThreadTextEncoding()));
//        OString sTransformXmlAscii( rtl::OUStringToOString(sTransformXmlDecoded,    osl_getThreadTextEncoding()));
//        OString sDrainXmlAscii(     rtl::OUStringToOString(sDrainXmlDecoded,        osl_getThreadTextEncoding()));
//        
//#ifndef UNX
//        sSourceXmlAscii =       sSourceXmlAscii.replaceAt(6, 1, "");
//        sTransformXmlAscii =    sTransformXmlAscii.replaceAt(6, 1, "");
//        sDrainXmlAscii =        sDrainXmlAscii.replaceAt(6, 1, "");
//#endif
//
//        SablotSetLog( proc, "user.log", 1);
//
//        SablotRunProcessorGen(  S,
//                                proc,
//                                (char*) sTransformXmlAscii.getStr(),
//                                (char*) sSourceXmlAscii.getStr(),
//                                (char*) sDrainXmlAscii.getStr());
//        
//        SablotDestroyProcessor(proc);
//        SablotDestroySituation(S);

//--- libxml
//
//    const char *pParams[1];
//    pParams[0] = NULL;
// 
//    xmlSubstituteEntitiesDefault(1);
//    xmlLoadExtDtdDefaultValue=1;
//    
//    xsltStylesheetPtr   aStyleSheetDOM  = xsltParseStylesheetFile((const xmlChar *) "D:\\xml\\testStyleSheet.xml");
//    xmlDocPtr           aSourceDOM      = xmlParseFile( "D:\\xml\\testSourceDOM.xml" );
//
//    xmlDocPtr           aDrainDOM       = xsltApplyStylesheet(aStyleSheetDOM, aSourceDOM, pParams);
//
//    FILE *              paDrainFile     = fopen( "D:\\xml\\testDrainDOM.xml", "a+");
//
//	xsltSaveResultToFile(paDrainFile, aDrainDOM, aStyleSheetDOM);
//	
//	fclose(paDrainFile);
//
//	xsltFreeStylesheet(aStyleSheetDOM);
//	xmlFreeDoc(aSourceDOM);
//	xmlFreeDoc(aDrainDOM);
//    xsltCleanupGlobals();
//    xmlCleanupParser();

