/*************************************************************************
 *
 *  $RCSfile: pasuname.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:08:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef UNX
#include <unistd.h>
#endif

#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif

#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "maindlg.hxx"
#include "environ.hxx"

#include "pasuname.hxx"
#include "pasuname.hrc"

PageASrvUserName::PageASrvUserName( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTUnxRights	( this, ResId(FT_UNX_RIGHTS, rResId.GetResMgr()) ),
	aCBUnxRights	( this, ResId(CB_UNX_RIGHTS, rResId.GetResMgr()) ),
	aEDUser         ( this, ResId(ED_NEWNAME, rResId.GetResMgr()) ),
	aPBAdd			( this, ResId(PB_ADD, rResId.GetResMgr()) ),
	aPBDelete		( this, ResId(PB_DELETE, rResId.GetResMgr()) ),
	aLBUsers		( this, ResId(LB_USER, rResId.GetResMgr()) ),
	aStrInsError	( ResId(STR_USERALREADYHAVE, rResId.GetResMgr()) ),
	aStrInsUser		( ResId(STR_ENTERUSER, rResId.GetResMgr()) )
{
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	pParent->SetTitleStr( aTitle );

	FreeResource();

	#ifndef UNX
		aFTUnxRights.Hide();
		aCBUnxRights.Hide();
		aCBUnxRights.Check(FALSE);
	#else
		if( getuid() != (uid_t) 0 )
		{
			aCBUnxRights.Check(FALSE);
			aCBUnxRights.Enable(FALSE);
		}
	else
		aCBUnxRights.Check(TRUE);
	#endif

	aPBDelete.Enable(FALSE);

	aPBAdd.SetClickHdl		( LINK(this, PageASrvUserName, ClickHdl) );
	aPBDelete.SetClickHdl	( LINK(this, PageASrvUserName, ClickHdl) );
	aLBUsers.SetSelectHdl	( LINK(this, PageASrvUserName, SelectHdl) );

	SiClientList& rList = GETDLG()->GetEnv()->GetClientNameList();
	for(USHORT z = 0; z < rList.Count(); ++z)
	{
		AppServerClient* pUser = rList.GetObject(z);
		if( !pUser->bToDelete )
		{
			USHORT nPos = aLBUsers.InsertEntry( pUser->aName );
			aLBUsers.SetEntryData( nPos, (void*)pUser );
		}
	}
}

PageASrvUserName::~PageASrvUserName()
{
/*	SiByteStringList& rList = GETDLG()->GetEnv()->GetClientNameList();
	for(USHORT z = 0; z < rList.Count(); ++z)
	{
		ByteString* pDel = rList.GetObject(z);
		delete pDel;
	}
	rList.Clear();

	for(USHORT i = 0; i < aLBUsers.GetEntryCount(); ++i)
	{
		ByteString* pNew = new ByteString(aLBUsers.GetEntry(i));
		rList.Insert( pNew );
	}
*/
	if( aCBUnxRights.IsChecked() )
		GETDLG()->GetEnv()->SetRights();
}

SvAgentPage* PageASrvUserName::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageASrvUserName( pParent, rResId );
}

BOOL PageASrvUserName::AllowNext()
{
	if(!aLBUsers.GetEntryCount())
	{
		InfoBox aBox(GetAgentDlg(), aStrInsUser);
		aBox.Execute();
		return FALSE;
	}
	return TRUE;
}

IMPL_LINK( PageASrvUserName, SelectHdl, ListBox*, pLBox )
{
	if( aLBUsers.GetSelectEntryPos() != LISTBOX_ENTRY_NOTFOUND )
		aPBDelete.Enable(TRUE);
	else
		aPBDelete.Enable(FALSE);
	return 1;
}

IMPL_LINK(PageASrvUserName, ClickHdl, Control*, pCtrl)
{
	if( pCtrl == &aPBDelete )
	{
		if( aLBUsers.GetSelectEntryPos() != LISTBOX_ENTRY_NOTFOUND )
		{
			USHORT nIdx = aLBUsers.GetSelectEntryPos();
			AppServerClient* pUser = (AppServerClient*)aLBUsers.GetEntryData( nIdx );

			if( pUser->bToInstall )
			{	// wurde gerade eingefuegt, deshalb gleich aus Liste loeschen.
				SiClientList& rList = GETDLG()->GetEnv()->GetClientNameList();
				rList.Remove( pUser );
				delete pUser;

				if( !GETDLG()->GetEnv()->IsFirstInstallation() )
				{
					GetAgentDlg()->Rule( RESID_PAGE_PAGEASRV_USERNAME, 0 );
					GetAgentDlg()->SetButtonState();
				}
			}
			else
			{
				pUser->bToDelete = TRUE;
				pUser->bToInstall = FALSE;
			}

			aLBUsers.RemoveEntry(nIdx);
			if( !aLBUsers.GetEntryCount() ||
				aLBUsers.GetSelectEntryPos() == LISTBOX_ENTRY_NOTFOUND )
				aPBDelete.Enable(FALSE);
		}
		return 1;
	}

	ByteString aNewUser( aEDUser.GetText() );
	if( aNewUser.Len() )
	{
		USHORT	nDelimTok = 0;
		USHORT	nTokCount = aNewUser.GetTokenCount(';');

		for( USHORT i = 0; i < nTokCount; ++i )
		{
			ByteString	aUser( aNewUser.GetToken(0, ';', nDelimTok) );
			BOOL	bInsNew = TRUE;

			aUser.EraseLeadingChars();
			aUser.EraseTrailingChars();

			if( !aUser.Len() )
				continue;

			SiClientList& rList = GETDLG()->GetEnv()->GetClientNameList();
			for(USHORT i = 0; i < rList.Count(); ++i)
			{
				AppServerClient* pUser = rList.GetObject(i);
				if( pUser->aName == aUser )
					if( pUser->bToDelete )
					{
						pUser->bToInstall = TRUE;
						pUser->bToDelete = FALSE;
						bInsNew = FALSE;

						USHORT nPos = aLBUsers.InsertEntry( pUser->aName );
						aLBUsers.SetEntryData( nPos, (void*)pUser );
						break;
					}
					else
					{
						ByteString aMsg(aStrInsError);
						aMsg.SearchAndReplace( "%s", aUser );
						InfoBox aError( GetAgentDlg(), aMsg );
						aError.Execute();
						bInsNew = FALSE;
						break;
					}
			}
			if( bInsNew )
			{
				AppServerClient* pUser = new AppServerClient;
				pUser->aName = aUser;
				pUser->bToInstall = TRUE;
				pUser->bToDelete = FALSE;

				USHORT nPos = aLBUsers.InsertEntry( pUser->aName );
				aLBUsers.SetEntryData( nPos, (void*)pUser );
				rList.Insert( pUser, LIST_APPEND );
			}
		}
		aEDUser.SetText("");
	}
	return 1;
}

