/*************************************************************************
 *
 *  $RCSfile: textani.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:50:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_GDIMTF_HXX
#include <vcl/gdimtf.hxx>
#endif

#include "textani.hxx"

/*************************************************************************
|*
|*    TextAnimation::TextAnimation()
|*
|*    Beschreibung      TEXTANI.SDW
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

TextAnimation::TextAnimation() :
				aNullPen( PEN_NULL ),
				aBackBrush( BRUSH_NULL )
{
	pInfoList       = new ImpTextAInfoList;
	pMtf            = NULL;
	nLoop           = -1;
	nAmount         = 1;
	nDelay          = TEXTANIMATION_DELAY;
	nMtfOrient      = 0;
	eMode           = TAM_SCROLL;
	eVAlign         = TAA_TOP;
	bDirection      = TRUE;
	bStartPos       = TRUE;
	bIsInAnimation  = FALSE;

	aFont.SetSize( Size( 0, 0 ) );
	SetFont( aFont );
	aTimer.SetTimeout( 10 );
	aTimer.SetTimeoutHdl( LINK( this, TextAnimation, ImpStepHdl ) );
}

/*************************************************************************
|*
|*    TextAnimation::~TextAnimation()
|*
|*    Beschreibung      TEXTANI.SDW
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

TextAnimation::~TextAnimation()
{
	ImpTextAInfo* pItem = pInfoList->First();
	while ( pItem )
	{
		delete pItem;
		pItem = pInfoList->Next();
	}
	delete pInfoList;
}

/*************************************************************************
|*
|*    TextAnimation::ImpNewOrientation()
|*
|*    Beschreibung      TEXTANI.SDW
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

short TextAnimation::ImpNewOrientation( short nOrientation )
{
	nOrientation %= 3600;
	bHorz = TRUE;
	bUp   = TRUE;
	if ( nOrientation > 0 )
	{
		if ( nOrientation > 900 )
		{
			if ( nOrientation > 1800 )
			{
				if ( nOrientation > 2700 )
					nOrientation = 0;
				else
				{
					bHorz = FALSE;
					nOrientation = 2700;
				}
			}
			else
			{
				bUp = FALSE;
				nOrientation = 1800;
			}
		}
		else
		{
			bHorz = FALSE;
			bUp = FALSE;
			nOrientation = 900;
		}
	}

	return nOrientation;
}

/*************************************************************************
|*
|*    TextAnimation::ImpCalcFontHeight()
|*
|*    Beschreibung      Berechnet die AutoFont-Hoehe
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

long TextAnimation::ImpCalcFontHeight( OutputDevice* pOutDev, const Size& rSize )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	ByteString  aEmptyStr;
	Font    aOldFont = pOutDev->GetFont();
	Font    aTempFont = aFont;
	long    nPixHeight;
	long    nMaxHeight;
	long    nCalcHeight;
	long    nTextHeight;

	if ( bHorz )
	{
		nPixHeight = pOutDev->PixelToLogic( Size( 0, 1 ) ).Height();
		nMaxHeight = rSize.Height();
	}
	else
	{
		nPixHeight = pOutDev->PixelToLogic( Size( 1, 0 ) ).Width();
		nMaxHeight = rSize.Width();
	}
	nMaxHeight -= nPixHeight*2;
	nCalcHeight = nMaxHeight;

	do
	{
		aTempFont.SetSize( Size( 0, nCalcHeight ) );
		pOutDev->SetFont( aTempFont );
		nTextHeight = pOutDev->GetTextHeight();
		if ( nTextHeight < nMaxHeight )
			break;
		nCalcHeight -= (nPixHeight*2);
	}
	while ( nCalcHeight > (nPixHeight*4) );
	pOutDev->SetFont( aOldFont );
	return nCalcHeight;
}

/*************************************************************************
|*
|*    TextAnimation::ImpCalcPoint()
|*
|*    Beschreibung      Berechnet die Position, bei Druckerausgabe
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

Point TextAnimation::ImpCalcPoint( const Point& rPoint, const Size& rSize,
								   long nItemHeight )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	Point aPos = rPoint;
	short nOrientation;

	if ( pMtf )
		nOrientation = nMtfOrient;
	else
		nOrientation = aFont.GetLineOrientation();

	switch ( nOrientation )
	{
		case 900:
			aPos.X() = rPoint.Y();
			aPos.Y() = rPoint.X()+rSize.Height();
			if ( eVAlign == TAA_BOTTOM )
				aPos.X() += rSize.Width()-nItemHeight;
			else if ( eVAlign == TAA_MIDDLE )
				aPos.X() += (rSize.Width()-nItemHeight)/2;
			break;
		case 1800:
			aPos.X() = rPoint.X()+rSize.Width();
			aPos.Y() = rPoint.Y()+rSize.Height();
			if ( eVAlign == TAA_BOTTOM )
				aPos.Y() -= rSize.Height()-nItemHeight;
			else if ( eVAlign == TAA_MIDDLE )
				aPos.Y() -= (rSize.Height()-nItemHeight)/2;
			break;
		case 2700:
			aPos.X() = rPoint.Y()+rSize.Width();
			aPos.Y() = rPoint.X();
			if ( eVAlign == TAA_BOTTOM )
				aPos.X() -= rSize.Width()-nItemHeight;
			else if ( eVAlign == TAA_MIDDLE )
				aPos.X() -= (rSize.Width()-nItemHeight)/2;
			break;
		default:
			{
			if ( eVAlign == TAA_BOTTOM )
				aPos.Y() += rSize.Height()-nItemHeight;
			else if ( eVAlign == TAA_MIDDLE )
				aPos.Y() += (rSize.Height()-nItemHeight)/2;
			}
	};

	return aPos;
}

/*************************************************************************
|*
|*    TextAnimation::ImpStart()
|*
|*    Beschreibung      Startet eine Animation neu
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::ImpStart()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	ImpTextAInfo* pItem = pInfoList->First();
	if ( !pItem )
		return;

	Font aTempFont = aFont;

	while ( pItem )
	{
		Size aOutDevSize = pItem->pOutDev->LogicToPixel( pItem->aStartSize );

		if ( pItem->bNew )
		{
			pItem->aVirDev.SetOutputSizePixel( aOutDevSize );

			// Itemgroesse berechnen
			long nItemWidth;
			long nItemHeight;
			if ( pMtf )
			{
				Size aSize = pItem->aVirDev.LogicToPixel( pMtf->GetPrefSize(), pMtf->GetPrefMapMode() );
				nItemWidth = aSize.Width();
				nItemHeight = aSize.Height();
			}
			else
			{
				Size aFontSize = aFont.GetSize();
				if ( !aFontSize.Height() )
					aFontSize = Size( 0, ImpCalcFontHeight( pItem->pOutDev, pItem->aStartSize ) );
				aFontSize = pItem->pOutDev->LogicToPixel( aFontSize );
				aTempFont.SetSize( aFontSize );
				pItem->aVirDev.SetFont( aTempFont );

				nItemWidth = pItem->aVirDev.GetTextWidth( UniString::CreateFromAscii(aText.GetBuffer()) );
				nItemHeight = pItem->aVirDev.GetTextHeight();
			}

			long nSize;
			long nOffset;
			long nOffset1;
			long nOffset2;

			if ( bHorz )
			{
				nSize = aOutDevSize.Width();

				if ( eVAlign == TAA_TOP )
				{
					if ( bUp )
						pItem->aOffset.Y() = 0;
					else
						pItem->aOffset.Y() = nItemHeight;
				}
				else if ( eVAlign == TAA_BOTTOM )
				{
					if ( bUp )
						pItem->aOffset.Y() = aOutDevSize.Height()-nItemHeight;
					else
						pItem->aOffset.Y() = aOutDevSize.Height();
				}
				else
				{
					pItem->aOffset.Y() = (aOutDevSize.Height()-nItemHeight)/2;
					if ( !bUp )
						pItem->aOffset.Y() += nItemHeight;
				}
			}
			else
			{
				nSize = aOutDevSize.Height();

				if ( eVAlign == TAA_TOP )
				{
					if ( !bUp )
						pItem->aOffset.X() = 0;
					else
						pItem->aOffset.X() = nItemHeight;
				}
				else if ( eVAlign == TAA_BOTTOM )
				{
					if ( !bUp )
						pItem->aOffset.X() = aOutDevSize.Width()-nItemHeight;
					else
						pItem->aOffset.X() = aOutDevSize.Width();
				}
				else
				{
					pItem->aOffset.X() = (aOutDevSize.Width()-nItemHeight)/2;
					if ( bUp )
						pItem->aOffset.X() += nItemHeight;
				}
			}

			if ( eMode == TAM_ALTERNATE )
			{
				if ( bUp )
				{
					if ( nItemWidth > nSize )
						nOffset = nSize-nItemWidth;
					else
						nOffset = 0;
				}
				else
				{
					if ( nItemWidth > nSize )
						nOffset = nItemWidth;
					else
						nOffset = nSize;
				}
			}
			else if ( bStartPos )
			{
				if ( bUp )
					nOffset = nSize;
				else
					nOffset = 0;
			}
			else
			{
				if ( bUp )
					nOffset = 0;
				else
					nOffset = nSize;
			}

			pItem->aOff1 = pItem->aOffset;
			if ( eMode == TAM_ALTERNATE )
			{
				if ( bUp )
				{
					if ( nItemWidth > nSize )
						nOffset2 = 0;
					else
						nOffset2 = nSize-nItemWidth;
				}
				else
				{
					if ( nItemWidth > nSize )
						nOffset2 = nSize;
					else
						nOffset2 = nItemWidth;
				}
				if ( bDirection )
				{
					nOffset1 = nOffset2;
					nOffset2 = nOffset;
					nOffset  = nOffset1;
				}
				else
					nOffset1 = nOffset;
			}
			else
			{
				nOffset1 = nOffset;
				if ( eMode == TAM_SLIDE )
				{
					if ( bUp )
						nOffset2 = 0;
					else
						nOffset2 = nSize;
				}
				else
				{
					if ( bUp )
						nOffset2 = -nItemWidth;
					else
						nOffset2 = nSize+nItemWidth;
				}
			}

			if ( (eMode != TAM_ALTERNATE) && !bDirection )
			{
				if ( !bStartPos )
				{
					nOffset1 += nSize;
					nOffset2 += nSize;
				}
				if ( eMode == TAM_SLIDE )
				{
					nOffset1 -= nItemWidth;
					nOffset2 -= nItemWidth;
				}
				nOffset     = nOffset2;
				nOffset2    = nOffset1;
				nOffset1    = nOffset;
			}

			if ( bHorz )
			{
				pItem->aOff1.Y()    = pItem->aOffset.Y();
				pItem->aOff2.Y()    = pItem->aOffset.Y();
				pItem->aOffset.X()  = nOffset;
				pItem->aOff1.X()    = nOffset1;
				pItem->aOff2.X()    = nOffset2;
			}
			else
			{
				pItem->aOff1.X()    = pItem->aOffset.X();
				pItem->aOff2.X()    = pItem->aOffset.X();
				pItem->aOffset.Y()  = nOffset;
				pItem->aOff1.Y()    = nOffset1;
				pItem->aOff2.Y()    = nOffset2;
			}

			pItem->nItemHeight  = nItemHeight;
			pItem->nCurLoop     = 0;
			pItem->bDirection   = bDirection;
		}


		if ( pItem->bNewBackground )
		{
			if ( aBackBrush.IsTransparent() )
			{
				pItem->aBackground.SetOutputSizePixel( aOutDevSize );
				Point aStartPos = pItem->pOutDev->LogicToPixel( pItem->aStartPos );
				BOOL bMapEnabled = pItem->pOutDev->IsMapModeEnabled();
				pItem->pOutDev->EnableMapMode( FALSE );
				pItem->aBackground.DrawOutDev( Point(), aOutDevSize,
											   aStartPos, aOutDevSize,
											   *(pItem->pOutDev) );
				pItem->pOutDev->EnableMapMode( bMapEnabled );

				// Evt. schon Background mit Hintergrund versehen
				BrushStyle eStyle = aBackBrush.GetStyle();
				if ( eStyle != BRUSH_NULL )
				{
					pItem->aBackground.SetPen( aNullPen );
					pItem->aBackground.SetFillInBrush( aBackBrush );
					Rectangle aRect( Point(0,0), aOutDevSize );
					pItem->aBackground.DrawRect( aRect );
				}
			}
			else
				pItem->aVirDev.SetFillInBrush( aBackBrush );

			pItem->bNewBackground = FALSE;
		}

		pItem->bDraw = TRUE;
		pItem->bDrawAll = TRUE;

		pItem = pInfoList->Next();
	}

	ImpDraw();
	bIsInAnimation = TRUE;
	nLastTime = Time::GetSystemTicks();
	aTimer.Start();
}

/*************************************************************************
|*
|*    TextAnimation::ImpNew()
|*
|*    Beschreibung      Updatet die Daten bei Datenaenderung
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::ImpNew()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	ImpTextAInfo* pItem = pInfoList->First();
	while ( pItem )
	{
		pItem->bNew = TRUE;
		pItem = pInfoList->Next();
	}
}

/*************************************************************************
|*
|*    TextAnimation::ImpStep()
|*
|*    Beschreibung      Stept entsprechend weiter
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::ImpStep()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	ULONG nTime = Time::GetSystemTicks();
	long nSteps = (nTime-nLastTime);
	nSteps /= nDelay;

	if ( nSteps )
	{
		nLastTime = nTime;
		nSteps *= nAmount;
		ImpTextAInfo* pItem = pInfoList->First();

		while ( pItem )
		{
			BOOL bStep = TRUE;

			if ( (nLoop >= 0) && (pItem->nCurLoop >= nLoop) )
			{
				bStep = FALSE;
				aReadyLink.Call( this );
			}
			else
			{
				if ( pItem->aOffset == pItem->aOff2 )
				{
					pItem->nCurLoop++;
					if ( (nLoop >= 0) && (pItem->nCurLoop >= nLoop) )
						bStep = FALSE;
					else
					{
						if ( pItem->aOffset != pItem->aOff1 )
						{
							if ( eMode == TAM_ALTERNATE )
							{
								pItem->aOffset = pItem->aOff2;
								pItem->aOff2   = pItem->aOff1;
								pItem->aOff1   = pItem->aOffset;
								pItem->bDirection = !pItem->bDirection;
							}
							else
								pItem->aOffset = pItem->aOff1;
							pItem->bDraw = TRUE;
						}
						bStep = FALSE;
					}
				}
			}

			if ( bStep )
			{
				long nTempSteps = nSteps;
				if ( !pItem->bDirection )
					nTempSteps *= -1;

				if ( bHorz )
				{
					if ( bUp )
						nTempSteps *= -1;

					pItem->aOffset.X() += nTempSteps;
					if ( nTempSteps > 0 )
					{
						if ( pItem->aOffset.X() > pItem->aOff2.X() )
							pItem->aOffset.X() = pItem->aOff2.X();
					}
					else
					{
						if ( pItem->aOffset.X() < pItem->aOff2.X() )
							pItem->aOffset.X() = pItem->aOff2.X();
					}
				}
				else
				{
					if ( bUp )
						nTempSteps *= -1;

					pItem->aOffset.Y() += nTempSteps;
					if ( nTempSteps > 0 )
					{
						if ( pItem->aOffset.Y() > pItem->aOff2.Y() )
							pItem->aOffset.Y() = pItem->aOff2.Y();
					}
					else
					{
						if ( pItem->aOffset.Y() < pItem->aOff2.Y() )
							pItem->aOffset.Y() = pItem->aOff2.Y();
					}
				}
				pItem->bDraw = TRUE;
			}

			pItem = pInfoList->Next();
		}
	}
}

/*************************************************************************
|*
|*    TextAnimation::ImpDraw()
|*
|*    Beschreibung      Zeichnet den Inhalt neu und merkt sich
|*                      gegebenenfalls den neuen Hintergrund
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::ImpDraw()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	ImpTextAInfo* pItem = pInfoList->First();
	while ( pItem )
	{
		if ( pItem->bDraw )
		{
			Point aOutPos;
			Point aOutLogPos = pItem->pOutDev->LogicToPixel( pItem->aStartPos );
			Size  aOutDevSize = pItem->aVirDev.GetOutputSizePixel();
			Size  aOutSize = aOutDevSize;

			if( !pItem->bDrawAll )
			{
				if ( bHorz )
				{
					if ( aOutSize.Height() > pItem->nItemHeight )
					{
						aOutPos.Y() = pItem->aOffset.Y();
						aOutSize.Height() = pItem->nItemHeight;
						if ( !bUp )
							aOutPos.Y() -= aOutSize.Height();
						aOutLogPos.Y() += aOutPos.Y();
					}
				}
				else
				{
					if ( aOutSize.Width() > pItem->nItemHeight )
					{
						aOutPos.X() = pItem->aOffset.X();
						aOutSize.Width() = pItem->nItemHeight;
						if ( bUp )
							aOutPos.X() -= aOutSize.Width();
						aOutLogPos.X() += aOutPos.X();
					}
				}
			}

			if ( aBackBrush.IsTransparent() )
			{
				pItem->aVirDev.DrawOutDev( aOutPos, aOutSize,
										   aOutPos, aOutSize,
										   pItem->aBackground );
			}
			else
				pItem->aVirDev.DrawRect( Rectangle( aOutPos, aOutSize ) );
			if ( pMtf )
			{
				MapMode aMapMode = pMtf->GetPrefMapMode();
				Point   aOrigin = pItem->aVirDev.PixelToLogic( pItem->aOffset, aMapMode );
				aMapMode.SetOrigin( aOrigin );
				pItem->aVirDev.SetMapMode( aMapMode );
				pMtf->WindStart();
				pMtf->Play( &(pItem->aVirDev) );
				pItem->aVirDev.SetMapMode( MapMode() );
			}
			else
				pItem->aVirDev.DrawText( pItem->aOffset, UniString::CreateFromAscii(aText.GetBuffer()) );

			BOOL bMapEnabled = pItem->pOutDev->IsMapModeEnabled();
			pItem->pOutDev->EnableMapMode( FALSE );
			pItem->pOutDev->DrawOutDev( aOutLogPos, aOutSize,
										aOutPos, aOutSize,
										pItem->aVirDev );
			pItem->pOutDev->EnableMapMode( bMapEnabled );
			pItem->bDraw = FALSE;
			pItem->bDrawAll = FALSE;
		}

		pItem = pInfoList->Next();
	}
}

/*************************************************************************
|*
|*    TextAnimation::ImpStepHdl()
|*
|*    Beschreibung      Stept weiter
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

IMPL_LINK( TextAnimation, ImpStepHdl, void*, EMPTYARG )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	aNotifyLink.Call( this );
	ImpStep();
	ImpDraw();
	aTimer.Start();
	return 0;
}

/*************************************************************************
|*
|*    TextAnimation::Start()
|*
|*    Beschreibung      TEXTANI.SDW
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::Start( OutputDevice* pOutDev,
						   const Point& rDestPt, const Size& rDestSize,
						   long nExtraData )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	if ( pOutDev->GetOutDevType() == OUTDEV_WINDOW )
	{
		ImpTextAInfo*   pItem;
		BOOL            bFound = FALSE;

		// Wenn es das gleiche ist, dann nur Updaten
		pItem = pInfoList->First();
		while ( pItem )
		{
			if ( ((pItem->nExtraData == nExtraData) || !nExtraData) &&
				 (pItem->pOutDev == pOutDev) )
			{

				if ( (pItem->aStartSize == rDestSize) &&
					 (pItem->pOutDev->LogicToPixel( pItem->aStartSize ) == pItem->aVirDev.GetOutputSizePixel()) )
				{
					if ( pItem->aStartPos != rDestPt )
						pItem->aStartPos = rDestPt;
					else
						pItem->bNewBackground = TRUE;
				}
				else
				{
					pItem->aStartPos        = rDestPt;
					pItem->aStartSize       = rDestSize;
					pItem->bNew             = TRUE;
					pItem->bNewBackground   = TRUE;
				}
				bFound = TRUE;
			}

			pItem = pInfoList->Next();
		}

		if ( !bFound )
		{
			pItem                   = new ImpTextAInfo;
			pItem->pOutDev          = pOutDev;
			pItem->aStartPos        = rDestPt;
			pItem->aStartSize       = rDestSize;
			pItem->nExtraData       = nExtraData;
			pItem->bNew             = TRUE;
			pItem->bNewBackground   = TRUE;
			pItem->bDraw            = FALSE;
			pItem->bDrawAll         = FALSE;

			pItem->aVirDev.SetPen( aNullPen );
			pInfoList->Insert( pItem, LIST_APPEND );
		}

		ImpStart();
	}
	else
	{
		pOutDev->Push();
		Rectangle aClipRect( rDestPt, rDestSize );
		if ( pMtf )
		{
			MapMode aMapMode = pMtf->GetPrefMapMode();
			Size    aMtfSize = pMtf->GetPrefSize();
			Region  aClipRegion( aClipRect );
			aMtfSize = pOutDev->LogicToPixel( aMtfSize, aMapMode );
			aMtfSize = pOutDev->PixelToLogic( aMtfSize );
			Point aPos = ImpCalcPoint( rDestPt, rDestSize, aMtfSize.Height() );
			aPos = pOutDev->LogicToPixel( aPos );
			Point aOrigin = pOutDev->PixelToLogic( aPos, aMapMode );
			aClipRegion = pOutDev->LogicToPixel( aClipRegion );
			aMapMode.SetOrigin( aOrigin );
			MapMode aOldMapMode = pOutDev->GetMapMode();
			pOutDev->SetMapMode( aMapMode );
			aClipRegion = pOutDev->PixelToLogic( aClipRegion );
			pOutDev->SetClipRegion( aClipRegion );
			pMtf->WindStart();
			pMtf->Play( pOutDev );
		}
		else
		{
			Font aTempFont( aFont );
			if ( !aTempFont.GetSize().Height() )
				aTempFont.SetSize( Size( 0, ImpCalcFontHeight( pOutDev, rDestSize ) ) );

			pOutDev->SetFont( aTempFont );

			long nTextHeight = pOutDev->GetTextHeight();
			Point aPos = ImpCalcPoint( rDestPt, rDestSize, nTextHeight );
			pOutDev->SetClipRegion( Region( aClipRect ) );
			pOutDev->DrawText( aPos, UniString::CreateFromAscii(aText.GetBuffer()) );
		}
		pOutDev->Pop();
	}
}

/*************************************************************************
|*
|*    TextAnimation::Stop()
|*
|*    Beschreibung      TEXTANI.SDW
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::Stop( OutputDevice* pOutDev, long nExtraData )
{
	ImpTextAInfo* pItem = pInfoList->First();
	while ( pItem )
	{
		if ( ((pItem->nExtraData == nExtraData) || !nExtraData) &&
			 ((pItem->pOutDev == pOutDev) || !pOutDev) )
		{
			delete pInfoList->Remove();
			pItem = pInfoList->GetCurObject();
		}
		else
			pItem = pInfoList->Next();
	}

	if ( !pInfoList->Count() )
	{
		aTimer.Stop();
		bIsInAnimation = FALSE;
	}
}

/*************************************************************************
|*
|*    TextAnimation::SetMode()
|*
|*    Beschreibung      TEXTANI.SDW
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::SetMode( TextAnimationMode eNewMode )
{
	eMode = eNewMode;

	ImpNew();
	ImpStart();
}

/*************************************************************************
|*
|*    TextAnimation::SetStartPos()
|*
|*    Beschreibung      TEXTANI.SDW
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::SetStartPos( BOOL bNewPos )
{
	bStartPos = bNewPos;

	ImpNew();
	ImpStart();
}

/*************************************************************************
|*
|*    TextAnimation::SetDirection()
|*
|*    Beschreibung      TEXTANI.SDW
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::SetDirection( BOOL bNewDirection )
{
	bDirection = bNewDirection;

	ImpNew();
	ImpStart();
}

/*************************************************************************
|*
|*    TextAnimation::SetVAlign()
|*
|*    Beschreibung      TEXTANI.SDW
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::SetVAlign( TextAnimationVAlign eNewVAlign )
{
	eVAlign = eNewVAlign;

	ImpNew();
	ImpStart();
}

/*************************************************************************
|*
|*    TextAnimation::SetMetaFile()
|*
|*    Beschreibung      TEXTANI.SDW
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::SetMetaFile( GDIMetaFile* pMetaFile, short nOrientation )
{
	pMtf = pMetaFile;
	nMtfOrient = nOrientation;
	if ( pMetaFile )
		ImpNewOrientation( nOrientation );
	else
		ImpNewOrientation( aFont.GetLineOrientation() );

	ImpNew();
	ImpStart();
}

/*************************************************************************
|*
|*    TextAnimation::SetText()
|*
|*    Beschreibung      TEXTANI.SDW
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::SetText( const ByteString& rText )
{
	aText = rText;

	ImpNew();
	ImpStart();
}

/*************************************************************************
|*
|*    TextAnimation::SetFont()
|*
|*    Beschreibung      TEXTANI.SDW
|*    Ersterstellung    TH 01.07.96
|*    Letzte Aenderung  TH 01.07.96
|*
*************************************************************************/

void TextAnimation::SetFont( const Font& rFont )
{
	aFont = rFont;
	aFont.SetTransparent( TRUE );
	aFont.SetAlign( ALIGN_TOP );
	short nOrientation = ImpNewOrientation( aFont.GetLineOrientation() );
	aFont.SetLineOrientation( nOrientation );
//     aFont.SetCharOrientation( 0 );
	if ( pMtf )
		ImpNewOrientation( nMtfOrient );

	ImpNew();
	ImpStart();
}

VirtualDevice* TextAnimation::GetFirstBackground()
{
	ImpTextAInfo* pItem = pInfoList->First();
	if( pItem )
		return &(pItem->aBackground);
	return NULL;
}

