/*************************************************************************
 *
 *  $RCSfile: agentdlg.cxx,v $
 *
 *  $Revision: 1.16.94.3 $
 *
 *  last change: $Author: vg $ $Date: 2004/04/15 14:24:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif

#ifndef _SV_GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif

#include <svtools/solar.hrc>

#include "main.hxx"
#include "agentdlg.hxx"
#include "environ.hxx"
#include "script.hxx"

#include "agentdlg.hrc"
#include "strings.hrc"

#define DEF_BUTTON_SPACE	20

#ifndef _TOOLS_RCID_H
#include <tools/rcid.h>
#endif

////////////////////////////////////////////////////////////////////////////////
// Model
//

Model::Model( USHORT nId, CreateFnc pCreateFnc )
{
	m_nId = nId;
	m_nProperty = PROP_NOTSET;
	m_pCreateFnc = pCreateFnc;
	m_bIsSmallPage = SMALL_PAGE;
}

Model::~Model()
{
	for( USHORT i = 0; i < m_aRules.Count(); ++i )
		delete m_aRules.GetObject(i);
}

Rule* Model::GetRuleFor( USHORT nRetVal )
{
	for( USHORT i = 0; i < m_aRules.Count(); ++i )
		if( m_aRules.GetObject(i)->m_nRetVal == nRetVal )
			return m_aRules.GetObject(i);
	return NULL;
}

void Model::InsertRule( USHORT nRetVal, USHORT nNextResId )
{
	Rule* pRule = GetRuleFor(nRetVal);
	if( pRule )
	{
		m_aRules.Remove(pRule);
		delete pRule;
	}

	if( !nNextResId )
		return ;

	pRule			 = new Rule;
	pRule->m_nRetVal = nRetVal;
	pRule->m_nResId	 = nNextResId;

	m_aRules.Insert( pRule, m_aRules.Count() );
}

USHORT Model::GetNext( USHORT nRetVal )
{
	Rule* pRule = GetRuleFor( nRetVal );

	if( !pRule && m_aRules.Count() >= 1 )
		pRule = m_aRules.GetObject(0);

	return pRule->m_nResId;
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
class SetupDummyDlg : public ModelessDialog
{
private:
    MultiLineEdit   m_aHelpEdit;
    FixedLine       m_aFLDelim;
    PushButton      m_aPBHelp;
    PushButton      m_aPBPrint;
    PushButton      m_aPBBack;
    PushButton      m_aPBNext;
    CancelButton   	m_aPBCancel;
    String          m_aStrNext;
    String          m_aStrBack;
    String          m_aStrFinal;
    String          m_aStrInstall;
    String          m_aStrUninstall;
    String          m_aStrRepair;
    String          m_aStrModify;
public:
                    SetupDummyDlg( ResMgr* pMgr );
                   ~SetupDummyDlg();

    String          GetCancelText() const { return m_aPBCancel.GetText(); }
    String          GetHelpText() const { return m_aPBHelp.GetText(); }
    String          GetPrintText() const { return m_aPBPrint.GetText(); }

    String          GetNextText() const { return m_aStrNext; }
    String          GetBackText() const { return m_aStrBack; }
    String          GetFinalText() const { return m_aStrFinal; }
    String          GetInstallText() const { return m_aStrInstall; }
    String          GetUninstallText() const { return m_aStrUninstall; }
    String          GetRepairText() const { return m_aStrRepair; }
    String          GetModifyText() const { return m_aStrModify; }
};

//------------------------------------------------------------------------------
SetupDummyDlg::SetupDummyDlg( ResMgr* pMgr ) :
	ModelessDialog	( NULL, ResId(RC_AGENTDLG, pMgr) ),
	m_aFLDelim		( this, ResId(RESID_DLG_AGENT_FL_DELIM, pMgr) ),
	m_aPBCancel		( this, ResId(RESID_DLG_AGENT_PB_CANCEL, pMgr) ),
	m_aPBNext		( this, ResId(RESID_DLG_AGENT_PB_NEXT, pMgr) ),
	m_aPBBack		( this, ResId(RESID_DLG_AGENT_PB_BACK, pMgr) ),
	m_aPBHelp		( this, ResId(RESID_DLG_AGENT_PB_HELP, pMgr) ),
	m_aPBPrint		( this, ResId(RESID_DLG_AGENT_PB_PRINT, pMgr) ),
	m_aHelpEdit		( this, ResId(RESID_DLG_AGENT_README, pMgr) ),
	m_aStrNext		( ResId(RESID_DLG_AGENT_STR_NEXT, pMgr) ),
	m_aStrBack		( ResId(RESID_DLG_AGENT_STR_BACK, pMgr) ),
	m_aStrFinal		( ResId(RESID_DLG_AGENT_STR_FINAL, pMgr) ),
	m_aStrInstall	( ResId(RESID_DLG_AGENT_STR_INSTALL, pMgr) ),
	m_aStrUninstall	( ResId(RESID_DLG_AGENT_STR_UNINSTALL, pMgr) ),
	m_aStrRepair	( ResId(RESID_DLG_AGENT_STR_REPAIR, pMgr) ),
	m_aStrModify	( ResId(RESID_DLG_AGENT_STR_MODIFY, pMgr) )
{
    FreeResource();
}

SetupDummyDlg::~SetupDummyDlg()
{}

////////////////////////////////////////////////////////////////////////////////
// SvAgentDlg
//

SvAgentDlg::SvAgentDlg( Window* pParent, ResMgr* pMgr,
                        SetupApp *pSetup, USHORT nLogoResId, BOOL bAnim ) :
	ModelessDialog	( pParent, ResId(RC_AGENTDLG, pMgr) ),
	m_aFLDelim		( this, ResId(RESID_DLG_AGENT_FL_DELIM, pMgr) ),
	m_aPBCancel		( this, ResId(RESID_DLG_AGENT_PB_CANCEL, pMgr) ),
	m_aPBNext		( this, ResId(RESID_DLG_AGENT_PB_NEXT, pMgr) ),
	m_aPBBack		( this, ResId(RESID_DLG_AGENT_PB_BACK, pMgr) ),
	m_aPBHelp		( this, ResId(RESID_DLG_AGENT_PB_HELP, pMgr) ),
	m_aPBPrint		( this, ResId(RESID_DLG_AGENT_PB_PRINT, pMgr) ),
	m_aHelpEdit		( this, ResId(RESID_DLG_AGENT_README, pMgr) ),
	m_aStrNext		( ResId(RESID_DLG_AGENT_STR_NEXT, pMgr) ),
	m_aStrBack		( ResId(RESID_DLG_AGENT_STR_BACK, pMgr) ),
	m_aStrFinal		( ResId(RESID_DLG_AGENT_STR_FINAL, pMgr) ),
	m_aStrInstall	( ResId(RESID_DLG_AGENT_STR_INSTALL, pMgr) ),
	m_aStrUninstall	( ResId(RESID_DLG_AGENT_STR_UNINSTALL, pMgr) ),
	m_aStrRepair	( ResId(RESID_DLG_AGENT_STR_REPAIR, pMgr) ),
	m_aStrModify	( ResId(RESID_DLG_AGENT_STR_MODIFY, pMgr) ),
	m_pFBLogo		( NULL ),
	pAnimCD			( NULL ),
	bAnimCD			( bAnim ),
	m_pSecondResMgr ( NULL ),
    m_pSetup        ( pSetup )
{
	FreeResource();

	m_pFBLogo = new FixedBitmap( this, ResId(nLogoResId, pMgr) );
	m_pFBLogo->Show();

	pResMgr			= pMgr;
	m_nStartId		= 0;
	m_nButtonState	= 0;
	m_pActivPage	= NULL;
	m_pActivModel	= NULL;
	m_pModel		= new ModelList;
	m_pUserPath		= new UserList;
	bInEndDialog	= FALSE;
	bInPerformNext	= FALSE;
	bInHelp			= FALSE;
	bHelpAvailable	= FALSE;

	m_aPBHelp.SetClickHdl( LINK(this, SvAgentDlg, ClickHdl) );
	m_aPBHelp.Hide();
	m_aHelpEdit.Hide();

	m_aPBPrint.SetClickHdl( LINK(this, SvAgentDlg, ClickHdl) );
	m_aPBPrint.Hide();

    m_aPBNext.SetClickHdl( LINK(this, SvAgentDlg, ClickHdl) );
	m_aPBBack.SetClickHdl( LINK(this, SvAgentDlg, ClickHdl) );
	m_aPBCancel.SetClickHdl( LINK(this, SvAgentDlg, ClickHdl) );

	m_aDefBackPos = m_aPBBack.GetPosPixel();
	m_aDefNextPos = m_aPBNext.GetPosPixel();
	m_aDefBackSz  = m_aPBBack.GetSizePixel();
	m_aDefNextSz  = m_aPBNext.GetSizePixel();

	Point aWinPos( LogicToPixel(Point(90, 7), MapMode(MAP_APPFONT)) );
	Size aWinSz( LogicToPixel(Size(205, 160), MapMode(MAP_APPFONT)) );
	Size aBmpSz( m_pFBLogo->GetSizePixel() );

	if( aWinPos.X() < aBmpSz.Width() + 5 )
		m_pFBLogo->SetSizePixel( Size(aWinPos.X() - 14, aBmpSz.Height() ));
	aBmpSz = m_pFBLogo->GetSizePixel();
	if( aWinSz.Height() < aBmpSz.Height() )
		m_pFBLogo->SetSizePixel( Size(aBmpSz.Width(), aWinSz.Height() ));

	Point aActBmpPos( m_pFBLogo->GetPosPixel() );
	Size aBmpArea( aWinPos.X() - aActBmpPos.X(), m_aFLDelim.GetPosPixel().Y() - aActBmpPos.Y());
	aBmpSz = m_pFBLogo->GetSizePixel();
	if( aBmpArea.Width() > aBmpSz.Width() )
		aActBmpPos.X() += ((aBmpArea.Width() - aBmpSz.Width()) / 2);
	if( aBmpArea.Height() > aBmpSz.Height() )
		aActBmpPos.Y() += ((aBmpArea.Height() - aBmpSz.Height()) / 2);
	m_pFBLogo->SetPosPixel(aActBmpPos);
}

SvAgentDlg::~SvAgentDlg()
{
	if( m_pActivPage )
		delete m_pActivPage;

	delete m_pModel;
	delete m_pUserPath;
	delete m_pFBLogo;
}

Model* SvAgentDlg::GetModel( USHORT nResId )
{
	Model* pReturn;
	for( USHORT i = 0; i < m_pModel->Count(); ++i )
		if( (pReturn = m_pModel->GetObject(i)) &&
			pReturn->GetId() == nResId )
			return pReturn;
	return NULL;
}

void SvAgentDlg::SetButtonState( USHORT nNewState )
{
	m_nButtonState = nNewState;
	UpdateButton();

	if( m_pActivModel->IsFinal() )
		m_aPBNext.SetText( m_aStrFinal );
	else
		m_aPBNext.SetText( m_aStrNext );
}

IMPL_LINK(SvAgentDlg, StartAnimHdl, void*, pEmpty)
{
	if( !bAnimCD )
		return 1;

	SvMemoryStream	aStrm;
	BinaryResLoader aLoader( aStrm, ResId(RESID_DLG_AGENT_ANIMATE_CD, pResMgr) );

	if( pAnimCD )
		delete pAnimCD;

	pAnimCD = new Graphic;
	aStrm.Seek( STREAM_SEEK_TO_BEGIN );

	BOOL bSucc = ImportGIF( aStrm, *pAnimCD, NULL );
	if( bSucc )
		pAnimCD->StartAnimation( m_pFBLogo, Point(3, 3) );

	return 1;
}

void SvAgentDlg::StartAnimCD()
{
	aStartAnimTimer.SetTimeout( 1500 );
	aStartAnimTimer.SetTimeoutHdl( LINK(this, SvAgentDlg, StartAnimHdl) );
	aStartAnimTimer.Start();
}

void SvAgentDlg::StopAnimCD()
{
	if( !bAnimCD )
		return ;
	if( pAnimCD )
	{
		pAnimCD->StopAnimation();
		delete pAnimCD;
		pAnimCD = NULL;
	}
}

void SvAgentDlg::UpdateButton()
{
	// default
	if( m_pActivModel->GetId() == m_nStartId )
	{
		m_aPBBack.Hide();
		m_aPBNext.GrabFocus();
	}
	else
		m_aPBBack.Show();
	
    m_aPBNext.Show();
	m_aPBCancel.Enable(TRUE);

	// uebersteuern
	if( m_nButtonState & BSTATE_SHOW_NEXT )
		m_aPBNext.Show();
	if( m_nButtonState & BSTATE_HIDE_NEXT )
	{
		m_aPBBack.GrabFocus();
		m_aPBNext.Hide();
	}
	if( m_nButtonState & BSTATE_ENABLE_NEXT )
		m_aPBNext.Enable();
	if( m_nButtonState & BSTATE_DISABLE_NEXT )
	{
		m_aPBBack.GrabFocus();
		m_aPBNext.Enable(FALSE);
	}

	if( m_nButtonState & BSTATE_SHOW_BACK )
		m_aPBBack.Show();
	if( m_nButtonState & BSTATE_HIDE_BACK )
	{
		m_aPBNext.GrabFocus();
		m_aPBBack.Hide();
	}

	if( m_nButtonState & BSTATE_ENABLE_BACK )
		m_aPBBack.Enable();
	if( m_nButtonState & BSTATE_DISABLE_BACK )
	{
		m_aPBNext.GrabFocus();
		m_aPBBack.Enable(FALSE);
	}

	if( m_nButtonState & BSTATE_ENABLE_CANCEL )
		m_aPBCancel.Enable();
	if( m_nButtonState & BSTATE_DISABLE_CANCEL )
	{
		m_aPBNext.GrabFocus();
		m_aPBCancel.Enable(FALSE);
	}

	if( m_nButtonState & BSTATE_SHOW_PRINT )
    {
        m_aPBHelp.Hide();
		m_aPBPrint.Show();
    }
	else if( m_nButtonState & BSTATE_HIDE_PRINT )
    {
		m_aPBPrint.Hide();

        if ( bHelpAvailable )
            m_aPBHelp.Show();
    }
}

void SvAgentDlg::SetPage( USHORT nResId )
{
	BOOL bPrevPageSmall = m_pActivModel? m_pActivModel->IsSmallPage() : FALSE;

	if( m_pActivPage )
	{
		m_pActivPage->Hide();
		if( m_pActivPage->HasChildPathFocus() )
			m_aPBNext.GrabFocus();
		delete m_pActivPage;
	}

	ResId aResId( nResId, pResMgr );

	m_pActivModel = GetModel( nResId );

	m_aPBNext.SetPosSizePixel( m_aDefNextPos, m_aDefNextSz );
	m_aPBBack.SetPosSizePixel( m_aDefBackPos, m_aDefBackSz );

	if( m_pActivModel->IsFinal() )
		m_aPBNext.SetText( m_aStrFinal );
	else
		m_aPBNext.SetText( m_aStrNext );
	m_aPBBack.SetText( m_aStrBack );

	if( m_pActivModel->IsSmallPage() )
	{
		if( !bPrevPageSmall )
		{
			m_pFBLogo->Show();
			StartAnimCD();
		}
	}
	else
	{
		m_pFBLogo->Hide();
		StopAnimCD();
	}

	SetText( UniString::CreateFromAscii("") );

	// Check if the TabPage is in the set_pp1*.res resource
	if (m_pSecondResMgr)
	{
		ResId aResId2( nResId, m_pSecondResMgr );
		
		aResId2.SetRT(RSC_TABPAGE);
		if (aResId2.GetResMgr()->IsAvailable(aResId2))
		{
			// found page in the patch resource, so take it.
			aResId.SetResMgr( m_pSecondResMgr );
		}
	}
	
	m_nButtonState	= 0;
	m_pActivPage 	= m_pActivModel->GetCreateFnc()( this, aResId );
	bHelpAvailable	= FALSE;

	UpdateButton();
	// formatiert die Button's
	SetNextText(UniString::CreateFromAscii(""));
	SetBackText(UniString::CreateFromAscii(""));

	m_pActivPage->InitProperty( m_pActivModel->GetProperty() );

	if( m_aInitLink.IsSet() )
		m_aInitLink.Call(m_pActivPage);

	if( !bHelpAvailable )
		m_aPBHelp.Hide();

	if( m_pActivModel->IsFinal() )
		m_aPBNext.GrabFocus();

	m_pActivPage->Show();
}

void SvAgentDlg::StartAgentDlg()
{
	DBG_ASSERT( m_nStartId != 0, "Agent: StartPageId wurde nicht gesetzt!" );
	SetPage( m_nStartId );
}

void SvAgentDlg::AddAllPages()
{
}

void SvAgentDlg::SetHelpAvailable(const String& rHelpText)
{
	if( !m_pActivPage )
		return ;

    // We cant dislay the help and the print button at the same time
    if ( m_aPBPrint.IsVisible() )
        return;

    bHelpAvailable = TRUE;
	aHelpText = rHelpText;

	m_aPBHelp.Show();
}

void SvAgentDlg::InsertPage( USHORT nResId, CreateFnc pCreateFnc,
							 BOOL bIsSmall, BOOL bStartPage )
{
	Model* pNew = new Model( nResId, pCreateFnc );
	if( bIsSmall )
		pNew->SetSmallPage( SMALL_PAGE );
	else
		pNew->SetSmallPage( LARGE_PAGE );
	m_pModel->Insert( pNew, m_pModel->Count() );

	if( bStartPage )
	{
		DBG_ASSERT(m_nStartId == 0, "Agent: StartPageId wurde schon gesetzt!" );
		m_nStartId = nResId;
	}
}

void SvAgentDlg::RuleIf( USHORT nResId, USHORT nRetVal, USHORT nNextResId )
{
	Model* pModel = GetModel( nResId );
	DBG_ASSERT( pModel, "Agent: TabPageModel nicht gefunden!" );

	pModel->InsertRule( nRetVal, nNextResId );
}

void SvAgentDlg::Rule( USHORT nResId, USHORT nNextResId )
{
	Model* pModel = GetModel( nResId );
	DBG_ASSERT( pModel, "Agent: TabPageModel nicht gefunden!" );
	pModel->InsertRule( USHRT_MAX, nNextResId );
}

void SvAgentDlg::PerformNext()
{
	bInPerformNext = TRUE;
	m_aPBNext.Click();
}

void SvAgentDlg::PerformBack()
{
	bInPerformNext = TRUE;
	m_aPBBack.Click();
}

void SvAgentDlg::SetNextText(const String& rText)
{
	String aBtnText = rText.Len()? rText : m_aPBNext.GetText();

	long nWidth = m_aPBNext.GetTextWidth( aBtnText );
	long nHeight = m_aPBNext.GetTextHeight();

	nWidth += DEF_BUTTON_SPACE;
	if( nWidth > m_aPBNext.GetSizePixel().Width() )
	{
		Point aNewPos( m_aDefNextPos );
		aNewPos.X() -= nWidth - m_aDefNextSz.Width();
		m_aPBNext.SetPosSizePixel(aNewPos, Size(nWidth, m_aPBNext.GetSizePixel().Height()));
	}
	m_aPBNext.SetText( aBtnText );

	if( m_aDefBackPos.X() + m_aPBBack.GetSizePixel().Width() > m_aPBBack.GetPosPixel().X() )
	{
		m_aPBBack.SetPosPixel( Point(m_aPBNext.GetPosPixel().X() - m_aPBBack.GetSizePixel().Width(),
			m_aPBBack.GetPosPixel().Y()) );
	}
}

void SvAgentDlg::SetBackText(const String& rText)
{
	String aBtnText = rText.Len()? rText : m_aPBBack.GetText();

	long nWidth = m_aPBBack.GetTextWidth( aBtnText );

	nWidth += DEF_BUTTON_SPACE;
	if( nWidth > m_aPBBack.GetSizePixel().Width() )
	{
		// immer erst den NextText setzten, dann den BackText,
		// damit hier richtig angeordnet wird
		Point aNewPos( m_aPBNext.GetPosPixel() );
		aNewPos.X() -= nWidth;
		m_aPBBack.SetPosSizePixel(aNewPos, Size(nWidth, m_aPBBack.GetSizePixel().Height()));
	}
	m_aPBBack.SetText( aBtnText );
}

void SvAgentDlg::SetCancelText( const String& rText,
                                BOOL bShrink )
{
	// No text? Nothing to do!
    if ( !rText.Len() )
        return;

	long nWidth = m_aPBCancel.GetTextWidth( rText );
	Size aSize= m_aPBCancel.GetSizePixel();

	nWidth += DEF_BUTTON_SPACE;
	
    if( ( nWidth > aSize.Width() ) || bShrink )
	{
        if ( bShrink )
        {
            Size aNextSize = m_aDefNextSz;
            if ( nWidth < aNextSize.Width() )
                nWidth = aNextSize.Width();
        }

        // move the cancel button by the diff to the left and resize it
        long nDiff = nWidth - aSize.Width();
        Point aOldPos = m_aPBCancel.GetPosPixel();

        aOldPos.X() -= nDiff;
        aSize.Width() = nWidth;
        m_aPBCancel.SetPosSizePixel( aOldPos, aSize );

        // now move the back and next button to the left, too
        aOldPos = m_aPBNext.GetPosPixel();
        aOldPos.X() -= nDiff;
        m_aPBNext.SetPosPixel( aOldPos );

        aOldPos = m_aPBBack.GetPosPixel();
        aOldPos.X() -= nDiff;
        m_aPBBack.SetPosPixel( aOldPos );
	}

    m_aPBCancel.SetText( rText );
}

void SvAgentDlg::ShowHelp()
{
	bInHelp = TRUE;

	m_aPBCancel.Hide();
	m_aPBHelp.Hide();
	m_aPBNext.Hide();

	m_aPBBack.Show();
	m_aPBBack.Enable( TRUE );
	m_aPBBack.SetPosPixel( m_aPBHelp.GetPosPixel() );

	m_pActivPage->Hide();
	if( m_pActivModel->IsSmallPage() )
		m_pFBLogo->Hide();

	m_aHelpEdit.SetText( aHelpText );
	m_aHelpEdit.Show();

	m_aPBBack.GrabFocus();
}

void SvAgentDlg::HideHelp()
{
	bInHelp = FALSE;

	m_aPBHelp.Show();
	m_aPBCancel.Show();
	m_aHelpEdit.Hide();

	m_pActivPage->Show();
	if( m_pActivModel->IsSmallPage() )
	{
		m_pFBLogo->Show();
		StartAnimCD();
	}

	m_aPBNext.SetPosSizePixel( m_aDefNextPos, m_aDefNextSz );
	m_aPBBack.SetPosSizePixel( m_aDefBackPos, m_aDefBackSz );

	UpdateButton();
}

BOOL SvAgentDlg::Close()
{
    BOOL bRet = EndAgentDlg( FALSE );
    return bRet;
}

IMPL_LINK(SvAgentDlg, ClickHdl, Control*, pCtrl)
{
	if( pCtrl == &m_aPBHelp )
	{
		ShowHelp();
		return 0;
	}
	else if( pCtrl == &m_aPBBack && bInHelp )
	{
		HideHelp();
		return 0;
	}
	else if( pCtrl == &m_aPBPrint )
	{
		m_aPrintLink.Call( m_pActivPage );
		return 0;
	}

	if( !bInPerformNext &&
		((m_nButtonState & BSTATE_HIDE_NEXT ||
		 m_nButtonState & BSTATE_DISABLE_NEXT) &&
		(m_nButtonState & BSTATE_HIDE_BACK ||
		 m_nButtonState & BSTATE_DISABLE_BACK) &&
		 m_nButtonState & BSTATE_DISABLE_CANCEL) )
		 return 0;
	bInPerformNext = FALSE;

	if( bInEndDialog )
		return 1;

	if( pCtrl == &m_aPBNext )
	{
		if( m_pActivModel->IsFinal() )
		{
			if( m_pActivPage->AllowNext() )
			{
				m_pActivPage->NotifyNext();
				m_pActivPage->GetReturnVal();
				m_pActivPage->GetProperty();
				bInEndDialog = TRUE;
				EndAgentDlg(TRUE);
			}
			return 1;
		}
		if( m_pActivPage->AllowNext() )
		{
			USHORT nNextId = m_pActivModel->GetNext(m_pActivPage->
							 GetReturnVal());
			if( m_pActivPage->NotifyNext() )
			{
				m_pActivModel->SetProperty( m_pActivPage->GetProperty() );
				m_pUserPath->Insert( m_pActivModel->GetId(), m_pUserPath->Count() );
				SetPage( nNextId );
			}
		}
	}
	else if( pCtrl == &m_aPBBack )
	{
		USHORT nNextId = (USHORT) m_pUserPath->GetObject(m_pUserPath->Count()-1);
		if( m_pActivPage->NotifyBack() )
		{
			m_pActivModel->SetProperty( m_pActivPage->GetProperty() );
			m_pUserPath->Remove(m_pUserPath->Count()-1);
			SetPage( nNextId );
		}
	}
	else if( pCtrl == &m_aPBCancel )
	{
		if( !(GetButtonState() & BSTATE_DISABLE_CANCEL) )
		{
			bInEndDialog = TRUE;
			bInEndDialog = EndAgentDlg(FALSE);
		}
		return 1;
	}
	return 1;
}

//------------------------------------------------------------------------------
LanguageType SvAgentDlg::Lang2LangType( USHORT nLang )
{
    switch ( nLang )
    {
        case 01: return LANGUAGE_ENGLISH_US;
        case 02: return LANGUAGE_FRENCH_CANADIAN;
        case 03: return LANGUAGE_PORTUGUESE;
        case 07: return LANGUAGE_RUSSIAN;
        case 30: return LANGUAGE_GREEK;
        case 31: return LANGUAGE_DUTCH;
        case 33: return LANGUAGE_FRENCH;
        case 34: return LANGUAGE_SPANISH;
        case 35: return LANGUAGE_FINNISH;
        case 36: return LANGUAGE_HUNGARIAN;
        case 37: return LANGUAGE_CATALAN;
        case 39: return LANGUAGE_ITALIAN;
        case 42: return LANGUAGE_CZECH;
        case 43: return LANGUAGE_SLOVAK;
        case 44: return LANGUAGE_ENGLISH;
        case 45: return LANGUAGE_DANISH;
        case 46: return LANGUAGE_SWEDISH;
        case 47: return LANGUAGE_NORWEGIAN;
        case 48: return LANGUAGE_POLISH;
        case 49: return LANGUAGE_GERMAN;
        case 50: return LANGUAGE_SLOVENIAN;
        case 55: return LANGUAGE_PORTUGUESE_BRAZILIAN;
        case 61: return LANGUAGE_ENGLISH_AUS;
        case 66: return LANGUAGE_THAI;
        case 77: return LANGUAGE_ESTONIAN;
		case 79: return LANGUAGE_NORWEGIAN_NYNORSK;
        case 81: return LANGUAGE_JAPANESE;
        case 82: return LANGUAGE_KOREAN;
        case 86: return LANGUAGE_CHINESE_SIMPLIFIED;
        case 88: return LANGUAGE_CHINESE_TRADITIONAL;
        case 90: return LANGUAGE_TURKISH;
        case 91: return LANGUAGE_HINDI;
        case 96: return LANGUAGE_ARABIC;
		case 97: return LANGUAGE_HEBREW;
        case 99: return LANGUAGE_USER1;
    }
    DBG_ERRORFILE( "Unknown language!" );
    return GetSystemUILanguage();
}

//------------------------------------------------------------------------------
void SvAgentDlg::SwitchLanguage( USHORT nNewLang )
{
    if ( !m_pSetup )
        return;

    USHORT nOldLang = m_pSetup->GetLanguage();

    if ( nNewLang == nOldLang )
        return;

    LanguageType nOldType = Lang2LangType( nOldLang );
    LanguageType nNewType = Lang2LangType( nNewLang );

    if ( nOldType == nNewType )
        return;

    ByteString aMgrName( "set" );
    aMgrName += ByteString::CreateFromInt32( SOLARUPD );

    LanguageType    nType = nNewType;
    ResMgr*         pNewResMgr = ResMgr::SearchCreateResMgr( aMgrName.GetBuffer(), nType );

    if ( ( nType != nNewType ) || !pNewResMgr )
    {
        delete pNewResMgr;
        return;
    }

	// try to load the allready found language also for the product patch version.
    ByteString aMgrName2( "set_pp1" );
    aMgrName2 += ByteString::CreateFromInt32( SOLARUPD );
	ResMgr* pSecondResMgr = ResMgr::SearchCreateResMgr( aMgrName2.GetBuffer(), nType );

    // get Product Patch Brand Name from resources
    if( pSecondResMgr )
    {
        ResId aResId( STR_PRODUCTPATCH );
        ResId aResId2( STR_PRODUCTPATCH, pSecondResMgr );

        aResId2.SetRT( RSC_STRING );

        if( aResId2.GetResMgr()->IsAvailable( aResId2 ) )
            aResId.SetResMgr( pSecondResMgr );

        String aName = String( aResId );
        String aLevel;

        if ( m_pSetup->GetCScript() && 
             m_pSetup->GetCScript()->GetInstallation() )
        {
            aLevel = String::CreateFromInt32( m_pSetup->GetCScript()->GetInstallation()->GetPatchLevel() );
        }

        aName.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTPATCHLEVEL"), aLevel );
        m_pSetup->SetProductPatchName( aName );
	}

	delete pResMgr;
    delete m_pSecondResMgr;
    
    pResMgr = pNewResMgr;
	m_pSecondResMgr = pSecondResMgr;

    m_pSetup->SetResManager( pNewResMgr );
    m_pSetup->SetSecondResManager( pSecondResMgr );

    Resource::SetResManager( pNewResMgr );
    AllSettings aSettings = Application::GetSettings();
    aSettings.SetUILanguage( nNewType );
    Application::SetSettings( aSettings );

    m_pSetup->SetLanguage( nNewLang );
    
    SiEnvironment *pEnv = m_pSetup->GetEnvironment();
    if ( pEnv )
        pEnv->SetUILanguage( nNewLang );

    // Reload the strings
    SetupDummyDlg *pDummy = new SetupDummyDlg( pNewResMgr );

    m_aPBCancel.SetText( pDummy->GetCancelText() );
    m_aPBHelp.SetText( pDummy->GetHelpText() );
    m_aPBPrint.SetText( pDummy->GetPrintText() );

    m_aStrNext      = pDummy->GetNextText();
    m_aStrBack      = pDummy->GetBackText();
    m_aStrFinal     = pDummy->GetFinalText();
    m_aStrInstall   = pDummy->GetInstallText();
    m_aStrUninstall = pDummy->GetUninstallText();
    m_aStrRepair    = pDummy->GetRepairText();
    m_aStrModify    = pDummy->GetModifyText();

    delete pDummy;
}

////////////////////////////////////////////////////////////////////////////////
//	BinaryResLoader()

BinaryResLoader::BinaryResLoader( SvMemoryStream& rStrm, const ResId& rId )
	: Resource ( rId )
{
	char*  pStr;
	USHORT nStrLen;
	USHORT nBytesLeft;

	nStrLen = *((USHORT*)GetClassRes());
	IncrementRes( sizeof( short ) );

	nBytesLeft = GetRemainSizeRes();

	while( nBytesLeft )
	{
		USHORT nOut = Min( nStrLen, nBytesLeft );
		USHORT nInc = Min( (USHORT)(nStrLen+2), nBytesLeft );

		pStr = (char*)GetClassRes();
		rStrm.Write( pStr, nOut );
		IncrementRes( nInc );
		nBytesLeft = (nInc != nBytesLeft) ? GetRemainSizeRes() : 0;
	}
}

