#! /bin/sh

# should only be run local to the install directory
cd `dirname $0`

# Set the Defaults Here
oo_version="OpenOffice.org 1.1.3"
oo_home=OpenOffice.org1.1.3
oo_default_prefix=/usr/local
oo_default_netflg=-net
oo_default_interact=no


# these are the actual variables
prefix=$oo_default_prefix
netflg=$oo_default_netflg
interact=$oo_default_interact
installtype=INSTALL_NETWORK

# now parse the command line and interpret the options
oo_prev=
for oo_option
do

  # If the previous option needs an argument, assign it.
  if test -n "$oo_prev"; then
    eval "$oo_prev=\$oo_option"
    oo_prev=
    continue
  fi

  case "$oo_option" in
  -*=*) oo_optarg=`echo "$oo_option" | sed 's/[-_a-zA-Z0-9]*=//'` ;;
  *) oo_optarg= ;;
  esac

  case "$oo_option" in

  -? | -help | --help | --hel | --he)
    cat << EOF
Usage: install [options]
Options: [defaults in brackets after descriptions]
Configuration:
  --help                  print help message (this message)
  --version               print the version of OpenOffice.org to be installed
  --prefix=PREFIX         install OpenOffice.org into PREFIX [$oo_default_prefix]
  --single                install single user version of OpenOffice.org
  --interactive           install OpenOffice.org using interactive mode

EOF
    exit 0 ;;

  -prefix | --prefix | --prefi | --pref | --pre | --pr | --p)
    oo_prev=prefix ;;
  -prefix=* | --prefix=* | --prefi=* | --pref=* | --pre=* | --pr=* | --p=*)
    prefix="$oo_optarg" ;;

  -s | -single | --single | --singl | --singl | --sin | --si | --s)
    netflag= 
    installtype=INSTALL_NORMAL ;;

  -i | -interactive | --interactive | --interact | --intera | --inter)
    interact=yes ;;

  -version | --version | --versio | --versi | --vers)
    echo "$oo_version"
    exit 0 ;;

  -*) { echo "configure: error: $oo_option: invalid option; use --help to show usage" 1>&2; exit 1; }
    ;;

  esac
done

if test -n "$oo_prev"; then
  { echo "configure: error: missing argument to --`echo $oo_prev | sed 's/_/-/g'`" 1>&2; exit 1; }
fi

# now for the actual installation

# if a single user install
if test "$installtype" = INSTALL_NORMAL; then

# Remove previous .sversionrc to prevent problems with previous versions
oo_versionrc="$HOME/.sversionrc"
#if [ -f "$oo_versionrc" ]; then
#  rm -f $oo_versionrc
#fi

# what should we do about prefix setting here if is was not set on the command 
# line (ie still the default of /usr/local change it to $HOME)
# perhaps change it to home directory? 
if test "$prefix" = /usr/local ; then
    prefix=$HOME
fi

fi


# create the proper autoresponse file
# we need to be careful of races in creating root files in /tmp
# for security reasons. 

# for more information, please see:
# www.dwheeler.com/secure-programs/Secure-Programs-HOWTO/avoid-race.html

TMPFILE=`mktemp -q /tmp/$0.XXXXXX`
if [ $? -ne 0 ]; then
     echo "$0: Can't create temp file, exiting..."
     exit 1
fi
                                                              
cat << EOF >> ${TMPFILE} 
[ENVIRONMENT]
INSTALLATIONMODE=$installtype
INSTALLATIONTYPE=STANDARD
DESTINATIONPATH=$prefix/$oo_home
OUTERPATH=
LOGFILE=
LANGUAGELIST=<LANGUAGE>

[JAVA]
JavaSupport=preinstalled_or_none

EOF

# echo something to be patient
echo "Installation starting, please be patient ..."

# if interactive simply run setup with proper flags
# otherwise use the autoresponse file
case "$interact" in
  yes) 
      ./setup ${netflg} 
      ;;
  no) 
      ./setup -v -nogui -r:${TMPFILE}
      ;;
esac

# now clean up autoresponse file 
rm -f ${TMPFILE}

# finish up
echo " "
echo "Installation Completed"
