/*************************************************************************
 *
 *  $RCSfile: frmhtml.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dv $ $Date: 2001/07/03 12:01:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _FRMHTML_HXX
#define _FRMHTML_HXX

#include <frmdescr.hxx>
#include "sfxhtml.hxx"

class SfxFrameHTMLParser;
class SfxDocumentInfo;
class _SfxFrameHTMLContexts;
class SfxFrameSetObjectShell;
class SvULongs;
class SfxMedium;
namespace svtools { class AsynchronLink; }


class _SfxFrameHTMLContext
{
	friend class SfxFrameHTMLParser;
	friend class _SfxFrameHTMLContexts;

	USHORT nLine;
	USHORT nFrame;
	SfxFrameSetDescriptor *pFrameSet;

	_SfxFrameHTMLContext( const SfxFrameHTMLParser *pParser );
	~_SfxFrameHTMLContext();
};

SV_DECL_PTRARR_DEL( _SfxFrameHTMLContexts, _SfxFrameHTMLContext*, 1, 1 )

// Der SfxFrameHTMLParser kennt zwei Modi:
// 1. wenn pDocFSet==0, wird der Parse-Vorgang abgebrochen, sobald sich
//    entscheiden laesst, ob das Dokument Frames enthaelt oder nicht. Es
//    werden jedoch keine FrameSet-Descriptoren gefuellt.
// 2. wenn pDocFSet!=0 wird der uebergebene FrameSet-Descriptor gefuellt.
//    Es findet kein Check mehr statt, ob das Dokument Frames enthaelt
//    und diese auch angezeigt wuerden!

class SfxFrameHTMLParser : public SfxHTMLParser
{
	friend class _SfxFrameHTMLContext;

	SfxFrameSetObjectShell*	pDoc;				// Dokument
	SfxFrameSetDescriptor*	pFrameSet;			// aktuelles FrameSet
	SfxFrameSetDescriptor*	pDocFrameSet;		// Dokument-FrameSet
	String 					aScriptSource;
	HTMLScriptLanguage 		eScriptType;
	_SfxFrameHTMLContexts 	aContextStack;		// Kontext-Stack

	USHORT 					nLine;				// aktuelle Line
	USHORT 					nFrame;				// aktueller Frame

	BOOL 					bIsFrameDoc : 1;	// ist es ein Frames Dokument
	BOOL 					bInNoFrames : 1;	// wir sind in einem NoFrames
	BOOL					bIgnoreRawData : 1;
	BOOL					bParseScriptAgain : 1;
    svtools::AsynchronLink*	pDeleteLink;
	String					aBaseURL;

	// einen FrameSet-Kontext ...
	void 					SaveContext();		// ... speichern
												// ... initialisieren
	void 					InitContext( SfxFrameSetDescriptor * );
	void 					RestoreContext();	// ... restaurieren

	// den aktuelle Frame holen (kann 0 sein, wenn Frameset voll ist!)
	SfxFrameDescriptor*		GetCurrentFrame() const;

	// zum naechsten Frame gehen
	void 					IncFramePos();

	// parsen einer ROW/COL-Spezifikation
	void 					ParseSizeSpec( const String& rSpec, SvULongs& rSizes,
								SvUShorts& rAttrs ) const;

	// Auswerten einzelner Tags
	void 					InsertTitle();		// <TITLE> ... </TITLE>
	void 					NewFrameSet();		// <FRAMESET>
	void 					EndFrameSet();		// </FRAMESET>
	void 					InsertFrame();		// <FRAME>
	SfxDocumentInfo*		GetDocInfo();

	DECL_STATIC_LINK(		SfxFrameHTMLParser, Delete_Impl, void* );

protected:
	// wird fuer jedes Token gerufen, das in CallParser erkannt wird
	virtual void 			NextToken( int nToken );
	virtual void			Continue( int nToken );
	void					NewScript();
	void					EndScript();

public:
							SfxFrameHTMLParser( SvStream& rStream,
									SfxFrameSetObjectShell* _pDoc=0 );
							SfxFrameHTMLParser( SfxMedium& rMedium,
									SfxFrameSetObjectShell* _pDoc=0 );
							~SfxFrameHTMLParser();

	virtual SvParserState 	CallParser();   // Aufruf des Parsers
	void					EndParser();	// Parser asynchron deleten

	BOOL 					IsFrameDoc() const
							{ return bIsFrameDoc; }

	// Diese Methoden koennen auch von anderen Parsern benutzt werden
	static void 			ParseFrameOptions(SfxFrameDescriptor*,
													const HTMLOptions*);
};



#endif


