/*************************************************************************
 *
 *  $RCSfile: JavaSystemMonitor.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package stardiv.controller;

import java.awt.*;
import java.awt.event.*;

//----------------------------------------------------------------------------------------------------
public class JavaSystemMonitor
{
	static Dialog rDialog = null;

	static MemoryMonitor rMemMon;
	static BusyMonitor rBusyMon;

	// keine default Instanziierung!
	private JavaSystemMonitor()			{}
	
	public static void main( String[] args )
	{
		if (rDialog==null)
		{
			rDialog		= new Dialog( new Frame(), "Java System Monitor" );
			
			rDialog.setBackground( Color.lightGray );
			rDialog.setLayout( new BorderLayout() );
			rDialog.add( "West", rMemMon = new MemoryMonitor() );
			rDialog.add( "East", rBusyMon = new BusyMonitor() );
			rDialog.pack();
			rDialog.setResizable( false );
			
			rDialog.addWindowListener( new WindowAdapter()
				{
					public void windowClosing( WindowEvent evt )
					{
						rDialog.setVisible( false );
						rBusyMon.suspend();
						rMemMon.suspend();
					}
				} );
			
		}
		else if (! rDialog.isVisible())
		{
			rBusyMon.resume();
			rMemMon.resume();
		}

		rDialog.setVisible( true );
	}
}
	
	
//----------------------------------------------------------------------------------------------------
class MemoryMonitor extends Canvas implements Runnable
{
	static Runtime runtime				= Runtime.getRuntime();
	static final int sleepTime			= 100;
	static final Color totalColor		= Color.blue;
	static final Color usedColor		= Color.yellow;
	static final Color totalShadowColor	= totalColor.darker().darker();
	static final Color usedShadowColor	= usedColor.darker().darker();
	Font labelfont						= new Font( "Courier", Font.PLAIN, 10 );
	Image offscreen;

	int gap				= 5;
	int border			= 2;
	int grafW			= 115;
	int grafH			= 115;
	int shadowDepth		= 10;
	
	Thread monitor;
	
    public MemoryMonitor()
	{
        setFont(labelfont);
        setSize( getPreferredSize() );

        monitor = new Thread(this);
        monitor.setDaemon( true );
        monitor.start();
    }

	public void suspend()
	{
		monitor.suspend();
	}

	public void resume()
	{
		monitor.resume();
	}
		
    public void setFont(Font f)
	{
		super.setFont(f);
		labelfont = f;
	}
	
//    MessageBox delayedMessage;
//    long dialogOpenedAt;
//    long dialogDelay = 500;

    public void removeNotify()
	{
        super.removeNotify(); 
        if (offscreen != null)
		{
			offscreen.flush();
			offscreen = null;
		}
    }

    public void run()
	{
        while (true)
		{
            updateMemoryMonitor();
/*            if (delayedMessage != null && System.currentTimeMillis()-dialogOpenedAt > dialogDelay) {
                delayedMessage.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "Close"));
                delayedMessage = null;
		}
*/
            try { Thread.sleep(sleepTime); } catch(Exception e) {}
        }
    }

    char[] label = new char[32];
    int labelcount = 0;
    char[] suffixes = "bKMGTP".toCharArray();
    char[] buf = new char[32];

//
    void memstring(long amt) {
        int order = 0;
        while (amt >= 8192) {
            amt += 512;
            amt >>= 10;
            ++order;
        }
        int i = (int) amt;
        int len = 0;
        while (i >= 10) {
            buf[len++] = (char) ('0' + i % 10);
            i /= 10;
        }  buf[len++] = (char) ('0' + i % 10);
        
        for (int j=len-1; j>=0; j--) 
            label[labelcount++] = buf[j];
        label[labelcount++] = suffixes[order];
    }
    void buildLabel(long free, long total) { 
        labelcount = 0;
        memstring(total-free);
        label[labelcount++] = '/';
        memstring(total);
    }
//

    Dimension size;
    Color fg, bg;
    FontMetrics fm;
    int[] widths;

    void updateMemoryMonitor()
	{
        if (offscreen == null)
		{
            Dimension sz = getPreferredSize();
            offscreen = createImage(sz.width, sz.height);
            if (offscreen == null) return;
            size = getSize();
            bg = getBackground();
            fg = getForeground();
            fm = getFontMetrics(labelfont);
            widths = fm.getWidths();
        }
		
        Graphics imagegraphic = offscreen.getGraphics();
		
        if (imagegraphic != null)
			try
			{
				imagegraphic.setColor(bg);
				imagegraphic.clearRect(0,0, size.width, size.height);
				
				long total = runtime.totalMemory();
				long free  = runtime.freeMemory();
				int arc = (int) (360 * (total-free) / total);
				int x = border+gap;
				int y = border+gap;
				imagegraphic.setColor(totalShadowColor);
				imagegraphic.fillOval(x+shadowDepth, y+shadowDepth, grafW, grafH);
				imagegraphic.setColor( usedShadowColor);
				imagegraphic.fillArc(x+shadowDepth, y+shadowDepth, grafW, grafH, 90, -arc);
				imagegraphic.setColor(totalColor);
				imagegraphic.fillOval(x, y, grafW, grafH);
				imagegraphic.setColor(usedColor);
				imagegraphic.fillArc(x, y, grafW, grafH, 90, -arc);
            
				y += gap + grafH + shadowDepth;
				x += shadowDepth / 2;

				// ***** draw the label centered in the button
				if(labelfont != null)
				{
					buildLabel(free, total);
					imagegraphic.setColor(fg);
					
					int txtW = 0;
					for (int i=0; i<labelcount; i++) 
						txtW += widths[label[i]];
					
					x += grafW/2 - txtW/2;
					imagegraphic.drawChars(	label,0,labelcount,	x, y + fm.getMaxAscent());
				}
				
				Graphics screengraphic = getGraphics();
				
				if (screengraphic != null) try
				{
					screengraphic.drawImage(offscreen, 0, 0, null);
				}
				finally
				{ 
					screengraphic.dispose();
				}
			}
			finally
			{
				imagegraphic.dispose();
			}
    }

    public Dimension getPreferredSize()
	{
        int w = grafW + shadowDepth + 2*border + 2*gap;
        int h = grafH + shadowDepth + 2*border + 3*gap;
		
        if (getFont() != null)
		{
            FontMetrics fm = getFontMetrics(getFont());
            w = Math.max(w, fm.stringWidth("XXXK / XXXM")+2*border + 2*gap);
            h += fm.getHeight();
        }
		
        return new Dimension(w, h);
    }

    public void update(Graphics g)
	{
		paint(g);
	}

    public void  paint(Graphics g)
	{
        Dimension size = getSize();
        g.setColor(getBackground());
        g.clearRect(0,0, size.width, size.height);
    }
}


//###############################################################################################
//###############################################################################################
//###############################################################################################


class BusyMonitor extends Canvas implements Runnable
{

	static final int sleepTime	 = 100;
	static final Color green     = Color.green;
	static final Color yellow	 = Color.yellow;
	static final Color red		 = Color.red;
	static final Color darkGray  = Color.darkGray;
	Font labelfont				 = new Font( "Courier", Font.PLAIN, 10 );
	
	public static int prioMin  	 = Thread.MIN_PRIORITY;
	public static int prioMax	 = Thread.MAX_PRIORITY;
             
	MonitorThread[] threads;

	Image   offscreen;

	public BusyMonitor()
	{
        setFont(labelfont);
        setSize(getPreferredSize());
		
        threads = new MonitorThread[prioMax-prioMin+1];
        for (int pri=prioMin, ix=0; pri<=prioMax; pri++, ix++)
		{
            threads[ix] = new MonitorThread(pri);
            threads[ix].start();
        }
        Thread monitor = new Thread(this);
        monitor.setDaemon(true);
        monitor.start();
    }

	public void suspend()
	{
		for ( int nPos = threads.length; nPos-- !=0; )
			((Thread)threads[nPos]).suspend();
	}
	
	public void resume()
	{
		for ( int nPos = threads.length; nPos-- !=0; )
			((Thread)threads[nPos]).resume();
	}
			
    public void run()
	{
        while (true)
		{
            updateThreadMonitors();
            try
			{
				Thread.sleep(sleepTime);
			}
			catch(Exception e) {}
        }
    }

    void updateThreadMonitors()
	{
        if (offscreen == null)
		{
            Dimension sz = getPreferredSize();
            offscreen = createImage(sz.width, sz.height);
            if (offscreen == null) return;
        }
		
        int x = border + gap;
        int y = border + gap;
        Graphics g = offscreen.getGraphics();
		
        if (g != null)
			try
			{
				Dimension size = getSize();
				g.setColor(getBackground());
				g.clearRect(0,0, size.width, size.height);
				
				for (int i=0; i<threads.length; i++)
				{
					MonitorThread thread = threads[i];
					int slack = (int) thread.slack();
					if (slack > 1000) slack = 1000;
					int len = barLen * (1000-slack) / 1000;
					Color color = (slack<=333)? green: (slack<=667)? yellow: red;
					g.setColor(darkGray);
					g.fillRect(x, y, barLen, barWid);
					g.setColor(color);
					g.fillRect(x, y, len, barWid);
					
					y += barWid + gap;
				}

				FontMetrics fm = getFontMetrics( getFont() );
				g.setColor( getForeground() );
				g.drawString( "Responsibility", x, y + getFontMetrics(getFont()).getMaxAscent() );
				
				Graphics screen = getGraphics(); 
				if (screen != null) try {
					screen.drawImage(offscreen, 0, 0, null);
				}
				finally
				{
					screen.dispose();
				}
			}
			finally
			{
				g.dispose();
			}
    }
	
    int threadCount()
	{
		return prioMax - prioMin + 1;
	}

    int gap = 4;
    int border = 2;
    int barLen = 64;
    int barWid = 9;
	
    public Dimension getPreferredSize()
	{
        int n = threadCount();
        int w = barLen + 2*border + 2*gap;
        int h = barWid*n + 2*border + (n+1)*gap;

        if (getFont() != null)
		{
            FontMetrics fm = getFontMetrics(getFont());
            w = Math.max(w, fm.stringWidth("Responsibility")+2*border + 2*gap);
            h += fm.getHeight();
        }
		
        return new Dimension(w, h);
    }
	
    public void update(Graphics g)
	{
		paint(g);
	}
	
    public void  paint(Graphics g)
	{
        Dimension size = getSize();
        g.setColor(getBackground());
        g.clearRect(0,0, size.width, size.height);
    }

    class MonitorThread extends Thread
	{
        final int sleepTime = 10;
        long lastUpdated = -1;
        int priority = Thread.NORM_PRIORITY;

        MonitorThread(int priority)
		{
            this.priority = priority; 
            setDaemon(true);
            setPriority(priority);
            setName("PerfCheck " + priority);
        }
		
        int slack()
		{
			return (int) (System.currentTimeMillis()-lastUpdated);
		}

        public void run()
		{
            while (true)
			{
                lastUpdated = System.currentTimeMillis();
                try
				{
					sleep(sleepTime);
				}
				catch(Exception e) {}
			}
		}
	}
}

