/*************************************************************************
 *
 *  $RCSfile: factory.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/24 13:59:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <string.h>
#include <stdio.h>


#ifndef _SVGEN_HXX //autogen
#include <vcl/config.hxx>
#endif
#ifdef OS2
#include <tools/svpm.h>
#include <vcl/sysdep.hxx>
#endif

#include <factory.hxx>

#include <vcl/timer.hxx>
#include <vcl/svapp.hxx>
#include <svtools/sbxfac.hxx>
#include <svtools/sbxprop.hxx>
#include <svtools/sbxmeth.hxx>
#include <svtools/solar.hrc>

#include <binddata.hxx>

#include <soimpl.hxx>
#include <svstor.hxx>
#include <embobj.hxx>
#include <ipclient.hxx>
#include <ipobj.hxx>
#include <outplace.hxx>
#include <ipenv.hxx>
#include <protocol.hxx>
#include <plugin.hxx>
#include <applet.hxx>
#include <soerr.hxx>
#include <clsids.hxx>
#include <insdlg.hxx>

#pragma hdrstop
#include <sot/formats.hxx>

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::datatransfer;

/************** class SoDll *********************************************/
/*************************************************************************
|*    SoDll::SoDll
|*
|*    Beschreibung
*************************************************************************/
SoDll::SoDll()
	: nAliveCount( 0 )
	, bInit( FALSE )
	, bSelfInit( FALSE )
	, pReleaseList( NULL )
	, pUIShowIPEnv( NULL )
	, pIEOPDflt( NULL )
	, aSvInterface( 0xB34BB240L, 0x4BD8, 0x101C, 0x8D, 0x86,
					0x4A, 0x04, 0x12, 0x94, 0x26, 0x0D )
	, pSvObjectFactory( NULL )
	, pSvStorageStreamFactory( NULL )
	, pSvStorageFactory( NULL )
	, pSvEmbeddedObjectFactory( NULL )
	, pSvEmbeddedClientFactory( NULL )
	, pSvInPlaceObjectFactory( NULL )
	, pSvPlugInObjectFactory( NULL )
	, pSvAppletObjectFactory( NULL )
	, pSvInPlaceClientFactory( NULL )
	, pSvPersistFactory( NULL )
	, pSvPseudoObjectFactory( NULL )
	, pSvSimplePersistFactory( NULL )
	, pSvFactory_ImplFactory( NULL )
	, pDfltPlugInFactory( NULL )
	, pDfltAppletFactory( NULL )
	, pIPActiveClientList( NULL )
	, pIPActiveObjectList( NULL )
	, pContEnvList( NULL )
	, pResMgr( NULL )
	, pDeathTimer( NULL )
	, pPlugInVerbList( NULL )
	, nPlugInDocFormat( 0 )
	, pAppletVerbList( NULL )
	, nAppletDocFormat( 0 )
	, pBindingData( 0 )
	, pConvTable( NULL )
	, nConvTableEntries( 0 )

{
}


SoDll::~SoDll()
{
	delete pIPActiveClientList;
	delete pIPActiveObjectList;
	delete pContEnvList;
	SvEditObjectProtocol::Imp_DeleteDefault();
	delete pResMgr;
	delete pDeathTimer;
	delete pPlugInVerbList;
	delete pAppletVerbList;

	SvBindingData::Delete();
	delete [] pConvTable;
}


ResMgr * SoDll::GetResMgr()
{
	// Resourcen sind im Default ResMgr ( OFA )
	return NULL;
}

//=========================================================================
//==================class SvFactory_Impl===================================
//=========================================================================
//=========================================================================
SV_OLE_FACTORY(SvFactory_ImplFactory)
	{
	}
};
TYPEINIT1(SvFactory_ImplFactory,SvOleFactory);
SO2_IMPL_CLASS1_DLL(SvFactory_Impl,SvFactory_ImplFactory,SvObject,
				SvGlobalName( 0x4ebc5c0, 0x8df8, 0x11cf,
							 0x89,0xca,0x0,0x80,0x29,0xe4,0xb0,0xb1 ) )

//=========================================================================
SvFactory_Impl::SvFactory_Impl()
/*  [Beschreibung]

	Konstruktor der Klasse SvFactory_Impl.
	Factories z"ahlen nicht zum Objekt-Count, deswegen
	wird <SvObject::IncSvObjectCount> im Konstruktor r"uckg"angig
	gemacht. Das Objekt locked sich selbst, und kann nur mit
	delete freigegeben werden.
*/
	: pFact( NULL )
{
	AddNextRef();
	SvFactory::DecSvObjectCount( this );
	DBG_ERROR( "SvFactory_Impl::SvFactory_Impl() not impl" )
}

//=========================================================================
SvFactory_Impl::SvFactory_Impl( SvFactory * p )
/*  [Beschreibung]

	Konstruktor der Klasse SvFactory_Impl.
	Factories z"ahlen nicht zum Objekt-Count, deswegen
	wird <SvObject::IncSvObjectCount> im Konstruktor r"uckg"angig
	gemacht. Das Objekt locked sich selbst, und kann nur mit
	delete freigegeben werden.
*/
	: pFact( p )
{
	AddNextRef();
	SvFactory::DecSvObjectCount( this );
}

//=========================================================================
SvFactory_Impl::~SvFactory_Impl()
/*  [Beschreibung]

	Destruktor der Klasse SvFactory_Impl.
	Factories z"ahlen nicht zum Objekt-Count, deswegen
	wird <SvObject::DecSvObjectCount> im Destruktor r"uckg"angig
	gemacht.
*/
{
	SvFactory::IncSvObjectCount( this );
}

//=========================================================================
IUnknown * SvFactory_Impl::GetMemberInterface( const SvGlobalName & )
/*  [Beschreibung]

	Jede Klasse mu eine Abfrage auf die Ole-Interfaces unterst"utzen.
	Es d"urfen nur die eigenen Ole-Interfaces und nicht die der
	Super-Klassen abgefragt werden. Siehe <So Ole-Unterst"utzung>.
*/
{
	return NULL;
}

//=========================================================================
void SvFactory_Impl::TestMemberObjRef( BOOL /*bFree*/ )
/*  [Beschreibung]

	Siehe <So Debugging>.
*/
{
}

//=========================================================================
#ifdef TEST_INVARIANT
void SvFactory_Impl::TestMemberInvariant( BOOL bPrint )
/*  [Beschreibung]

	Siehe <So Debugging>.
*/
{
#ifdef DBG_UTIL
	if( bPrint )
	{
		DBG_TRACE( "SvFactory_Impl::Invariant:" )
	}
#endif
}
#endif

/************** class SvFactory *****************************************/
/*************************************************************************
|*    SvFactory::SvFactory()
|*
|*    Beschreibung
*************************************************************************/
TYPEINIT0(SvFactory);

SvFactory::SvFactory( const SvGlobalName & rName,
					  const String & rClassName,
					  CreateInstanceType pCreateFuncP )
	: SotFactory( rName, rClassName, pCreateFuncP )
	, nRegisterId   ( 0 )
	, pImp          ( NULL )
{
}


//=========================================================================
SvFactory::~SvFactory()
{
	delete pImp;
}


//=========================================================================
void SvFactory::IncAliveCount()
/*  [Beschreibung]

	Der AliveCount wird erh"oht. Ein eventuell laufender Timer, der
	den AliveHdl rufen soll, wir gestoppt.
	[Querverweise]

	<SvFactory::DecAliveCount>, <SvFactory::GetAliveCount>
*/
{
	SoDll * pSoApp = SOAPP;
	pSoApp->nAliveCount++;
	delete pSoApp->pDeathTimer;
	pSoApp->pDeathTimer = NULL;
}

//=========================================================================
class Impl_DeathTimer : public Timer
{
protected:
	void    Timeout();
public:
			Impl_DeathTimer() { Start(); }
};

void Impl_DeathTimer::Timeout()
{
	SoDll * pSoApp = SOAPP;
	DBG_ASSERT( this == pSoApp->pDeathTimer, "unknown death timer" )
	if( Application::IsInModalMode() )
	{
		SetTimeout( 0 );
		Start();
		return;
	}

	delete this;
	pSoApp->pDeathTimer = NULL;
	if( !pSoApp->nAliveCount )
		pSoApp->aAliveHdl.Call( NULL );
}

void SvFactory::DecAliveCount
(
	BOOL bImmediate /* Gibt an, wie lange der Timer laufen soll, wenn der
					   AliveCount auf 0 geht. */
)
/*  [Beschreibung]

	Geht der Z"ahler auf 0, dann wird ein Timer gestartet.
	Ist bImmediate == TRUE, hat er eine Laufzeit von 0, sonst 15s.
	Befindet sich die Applikation im Zustand <Application::IsInModalMode>,
	dann wird der AliveHdl (siehe SvFactory::SetAliveHdl> erst nach dem
	beenden dieses Modus gerufen.

	[Anmerkung]

	Der AliveHdl wird nur gerufen, wenn zu dem Zeitpunkt, an dem der Timer
	zuschl"agt, der AliveCount 0 ist.

	[Querverweise]

	<SvFactory::IncAliveCount>, <SvFactory::GetAliveCount>
*/
{
	SoDll * pSoApp = SOAPP;
	DBG_ASSERT( pSoApp->nAliveCount, "SvFactory::DecAliveCount(): count underflow" )
	pSoApp->nAliveCount--;
	if( !pSoApp->nAliveCount )
	{
		DBG_ASSERT( !pSoApp->pDeathTimer, "death timer exist" )
		pSoApp->pDeathTimer = new Impl_DeathTimer();
		if( !bImmediate )
			pSoApp->pDeathTimer->SetTimeout( 15000 );
	}
}

//=========================================================================
UINT32 SvFactory::GetAliveCount()
/*  [Beschreibung]

	Gibt an, wie oft die Applikation gelocked ist.

	[R"uckgabewert]

	UINT32,     Anzahl der Locks.

	[Querverweise]

	<SvFactory::IncAliveCount>, <SvFactory::DecAliveCount>
*/
{
	return SOAPP->nAliveCount;
}


void SvFactory::SetAliveHdl( const Link & rAliveHdlP )
{
	SOAPP->aAliveHdl = rAliveHdlP;
}


/*************************************************************************
|*    SvFactory::InsertInReleaseList()
|*    SvFactory::ClearReleaseList()
|*
|*    Beschreibung
*************************************************************************/
class ReleaseTimer : public Timer
{
			~ReleaseTimer() {};
public:
			ReleaseTimer()
			{
				//ChangeTimeout( 1000 );
				Start();
			}
	void    Timeout()
			{
				delete this;
				SvFactory::ClearReleaseList();
			}
};

void SvFactory::InsertInReleaseList( SvObject * pReleaseObj )
{
	if( pReleaseObj )
	{
		SoDll * pSoApp = SOAPP;
		if( !pSoApp->pReleaseList )
		{
			pSoApp->pReleaseList = new SvObjectList();
			new ReleaseTimer();
		}
		// nicht loeschen sicherstellen
		pReleaseObj->AddRef();
		pSoApp->pReleaseList->Insert( pReleaseObj, LIST_APPEND );
	}
}

void SvFactory::ClearReleaseList()
{
	SoDll * pSoApp = SOAPP;
	if( pSoApp->pReleaseList )
	{
		DBG_TRACE( "SvFactory::ClearReleaseList()" );
		// Fuer denn Fall, das beim ReleaseRef InsertInReleaseList
		// gerufen wird
		SvObjectList aList( *pSoApp->pReleaseList );
		delete pSoApp->pReleaseList;
		pSoApp->pReleaseList = NULL;
		SvObject * pObj = aList.First();
		while( pObj )
		{
			pObj->ReleaseRef();
			pObj = aList.Next();
		}
	}
}



/*************************************************************************
|*    SvFactory::Init()
|*
|*    Beschreibung
*************************************************************************/
#ifdef OWN_MALLOC
static ImpMalloc * pTaskMalloc = NULL;
#endif


BOOL SvFactory::Init
(
)
/*  [Beschreibung]

	Mit dieser Methode wird So2 initialisiert. Sie muss aufgerufen werden
	bevor So2 benutzt wird.

	[R"uckgabewert]

	BOOL    TRUE,   es konnte initialisiert werden. So2 darf benutzt werden.
			FALSE,  es konnte nicht initialisiert werden.
					So2 darf nicht benutzt werden.

	[Querverweise]

	<SvSO>
*/
{
	SoDll** ppSoApp = (SoDll**)GetAppData( SHL_SO2 );
	if( !*ppSoApp )
		*ppSoApp = new SoDll();
	SoDll * pSoApp = *ppSoApp;

	pSoApp->bInit = TRUE;
	pSoApp->bSelfInit   = TRUE;
	if( pSoApp->bSelfInit )
	{
		// Lokal anmelden
		pSoApp->aInfoClassMgr.SV_CLASS_REGISTER( SvEmbeddedInfoObject );
		pSoApp->aInfoClassMgr.SV_CLASS_REGISTER( SvInfoObject );
		// Factory im System bekanntgeben und als Default anmelden
		pSoApp->pDfltPlugInFactory = SvPlugInObject::ClassFactory();
		pSoApp->pDfltAppletFactory = SvAppletObject::ClassFactory();
		SvOutPlaceObject::ClassFactory();
	}

	return pSoApp->bInit;
}


/*************************************************************************
|*    SvFactory::ClearDemandObjects()
|*
|*    Beschreibung
*************************************************************************/
void SvFactory::ClearDemandObjects()
{
	// Alle Objekte in der Release-Liste freigeben
	ClearReleaseList();
}


/*************************************************************************
|*    SvFactory::DeInit()
|*
|*    Beschreibung
*************************************************************************/
void SvFactory::DeInit()
{
	ClearDemandObjects();

	SoDll * pSoApp = SOAPP;
	// Notwendig um die Referenzzaehler auf 0 zu bringen
	const SotFactoryList * pFL = GetFactoryList();
	if( pFL )
		for( ULONG i = 0; i < pFL->Count(); i++ )
		{
			SvFactory * pF = PTR_CAST( SvFactory, pFL->GetObject( i ) );
			if( pF )
				pF->Revoke();
		}

#if (SUPD < 503)

	if (pSoApp->pBindingData)
	{
		DeleteSvBindData (pSoApp->pBindingData);
		pSoApp->pBindingData = NULL;
	}

#else

	SvBindingData::Delete();

#endif /* (SUPD < 503) */

	SotFactory::DeInit();
	if( GetSvObjectCount() )
		return;

	pSoApp->bInit = pSoApp->bSelfInit = FALSE;
	delete pSoApp;
	SOAPP = NULL;
}



/*************************************************************************
|*    SvFactory::GetInfoClassManager();
|*
|*    Beschreibung
*************************************************************************/
SvClassManager & SvFactory::GetInfoClassManager()
{
	return SOAPP->aInfoClassMgr;
}

//=========================================================================
void SvFactory::SetDefaultPlugInFactory
(
	SvFactory * pFact   /* die neue Default-Factory f"ur PlugIns */
)
/*  [Beschreibung]

	Die standardm"assige Factory f"ur PlugIn-Objekte ist
	<SvPlugInObject::ClassFactory>. Diese kann durch aufrufen dieser
	Methode umgesetzt werden.

	[Querverweise]

	<SvFactory::GetDefaultPlugInFactory()>
*/
{
	SoDll * pSoApp = SOAPP;
	pSoApp->pDfltPlugInFactory = pFact;
}

//=========================================================================
SvFactory * SvFactory::GetDefaultPlugInFactory()
/*  [Beschreibung]

	Die standardm"assige Factory f"ur PlugIn-Objekte ist
	<SvPlugInObject::ClassFactory>.

	[R"uckgabewert]

	SvFactory *     Die mit SetDefaultPlugInFactory eingestellte wird
					zur"uckgegeben.

	[Querverweise]

	<SvFactory::SetDefaultPlugInFactory()>
*/
{
	SoDll * pSoApp = SOAPP;
	return (SvFactory *)pSoApp->pDfltPlugInFactory;
}

//=========================================================================
void SvFactory::SetDefaultAppletFactory
(
	SvFactory * pFact   /* die neue Default-Factory f"ur Applets */
)
/*  [Beschreibung]

	Die standardm"assige Factory f"ur Applet-Objekte ist
	<SvAppletObject::ClassFactory>. Diese kann durch aufrufen dieser
	Methode umgesetzt werden.

	[Querverweise]

	<SvFactory::GetDefaultAppletFactory()>
*/
{
	SoDll * pSoApp = SOAPP;
	pSoApp->pDfltAppletFactory = pFact;
}

//=========================================================================
SvFactory * SvFactory::GetDefaultAppletFactory()
/*  [Beschreibung]

	Die standardm"assige Factory f"ur Applet-Objekte ist
	<SvAppletObject::ClassFactory>.

	[R"uckgabewert]

	SvFactory *     Die mit SetDefaultAppletFactory eingestellte wird
					zur"uckgegeben.

	[Querverweise]

	<SvFactory::SetDefaultAppletFactory()>
*/
{
	SoDll * pSoApp = SOAPP;
	return (SvFactory *)pSoApp->pDfltAppletFactory;
}

/*************************************************************************
|*    SvFactory::GetConfigFileName()
|*
|*    Beschreibung
*************************************************************************/
String SvFactory::GetConfigFileName()
{
#if defined WNT
	String aIniName( String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "so.ini") ) );
	// so sollten es alle machen
#else
	String aIniName = Config::GetConfigName( Config::GetDefDirectory(), String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "so" ) ) );
#endif
	return aIniName;
}


/*************************************************************************
|*    SvFactory::Create()
|*
|*    Beschreibung
*************************************************************************/
SvObjectRef SvFactory::Create( const SvGlobalName & rSvClassName,
							   const SvGlobalName & rOleClassName )
{
	const SvFactory * pFact = PTR_CAST( SvFactory, Find( rSvClassName ) );
	if( pFact )
		return pFact->Create( rOleClassName );
	return SvObjectRef();
}


/*************************************************************************
|*    SvFactory::Create()
|*
|*    Beschreibung
*************************************************************************/
SvObjectRef SvFactory::Create( const SvGlobalName & rClassName ) const
{
	const SvFactory * pFact;
	if( rClassName == *this )
		pFact = this;
	else
		pFact = PTR_CAST( SvFactory, Find( rClassName ) );

	SotObject * pBasicObj;
	if( pFact )
		pFact->CreateInstance( &pBasicObj );
	else if( (SotFactory *)this == SvEmbeddedObject::ClassFactory()
	  || (SotFactory *)this == (SotFactory *)SvInPlaceObject::ClassFactory() )
	{
		SvOutPlaceObject::ClassFactory()->CreateInstance( &pBasicObj );
	}
	else
		CreateInstance( &pBasicObj );
	SvObjectRef aObj( pBasicObj );
	return aObj;
}


/*************************************************************************
|*    SvFactory::Create()
|*
|*    Beschreibung
*************************************************************************/
SvObjectRef SvFactory::CreateAndLoad( SvStorage * pStor, BOOL ) const
{
	// Storage sichern
	SvStorageRef aStor = pStor;

	SvGlobalName aClassName = pStor->GetClassName();
	aClassName = GetAutoConvertTo( aClassName );

	/*SvObject * pBasicObj;
	CreateInstance( &pBasicObj );
	SvPersistRef aPObj( pBasicObj );
	SvSoIPCClient * pCl = new SvSoIPCClient( aClassName, aPObj );
	pCl->EnableAutolock( TRUE );
	 */

	const SvObjectServer* pInternalServer = SvOutPlaceObject::GetInternalServer_Impl( aClassName );
	if ( pInternalServer )
	{
		// this is a StarOffice 6.1 embedded object
		SotStorageStreamRef xEmbStm = pStor->OpenSotStream(
												String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "package_stream" ) ),
												STREAM_STD_READ );

		if( !xEmbStm->GetError() )
		{
			SvStorageRef xEmbStor = new SvStorage( *xEmbStm );
			if( !xEmbStor->GetError() )
			{
				SvPersistRef aPObj( &Create( pInternalServer->GetClassName() ) );
				if( aPObj.Is() && aPObj->DoLoad( xEmbStor ) )
					return &aPObj;
			}
		}
	}
	else
	{
		SvPersistRef aPObj( &Create( aClassName ) );
		if( aPObj.Is() && aPObj->DoLoad( pStor ) )
			return &aPObj;
	}

	return SvObjectRef();
}


//=========================================================================
SvObjectRef SvFactory::CreateAndLoad
(
	SvStream & rStm,    /* Der Stream aus dem das Objekt erzeugt werden
						   soll */
	ULONG * pLen        /* Die genaue L"ange des Objektes einschliesslich
						   der L"angenangabe selbst. Eine L"ange von Null
						   bedeutet, kein Objekt. Wenn pLen == NULL ist,
						   dann muss eventuell anstatt eines Teils
						   der ganze Stream kopiert werden. */
) const
/*  [Beschreibung]

	Aus dem Stream wird die ClassId gelesen. Damit wird eine lokale
	Faktory gesucht. Wird keine gefunden, dann handelt es sich
	um ein externes Objekt. Das Objekt wird dann erzeugt und geladen.

	[R"uckgabewert]

	SvObjectRef Konnte ein Objekt erzeugt und geladen werden, dann wird es
				zur"uckgegeben.
*/
{
	DBG_ERROR( "not impl" )
	return SvObjectRef();
}

/*************************************************************************
|*    SvFactory::CreateAndInit()
|*
|*    Beschreibung
*************************************************************************/
SvObjectRef SvFactory::CreateAndInit( const SvGlobalName & rClassName,
									  SvStorage * pStor ) const
{
	// Storage sichern
	SvStorageRef aStor = pStor;

	const SvFactory * pFact = this;

	if( pFact )
	{
		/*SvObject * pBasicObj;
		pFact->CreateInstance( &pBasicObj );
		SvEmbeddedObjectRef aEObj( pBasicObj );
		SvSoIPCClient * pCl = new SvSoIPCClient( rClassName, aEObj );
		pCl->EnableAutolock( TRUE );
		*/
		SvEmbeddedObjectRef aEObj( &pFact->Create( rClassName ) );
		if( aEObj.Is() && aEObj->DoInitNew( pStor ) )
			return &aEObj;
	}

	return SvObjectRef();
}

SvObjectRef SvFactory::CreateAndInit( const ::com::sun::star::uno::Reference<
							   ::com::sun::star::datatransfer::XTransferable>& xTrans,
							   SvStorage* pStor, BOOL bLink, BOOL bStorFilled) const
{
	return CreateAndInit( xTrans, pStor);
}

/*
  param  xTrans - the data object, from which the object is to create
  param pStor -   Diesen Storage bekommt das Objekt mit der
  						   Methode <SvPersist::DoInitNew> "ubergeben
 */
SvObjectRef SvFactory::CreateAndInit( const ::com::sun::star::uno::Reference<
							   ::com::sun::star::datatransfer::XTransferable>& xTrans,
							   SvStorage* pStor) const

{
#ifdef WNT
	if( !Find( GetAutoConvertTo( pStor->GetClassName() ) ) )
	{
		return SvOutPlaceObject::CreateFromData( xTrans, pStor );
	}
#endif
	return SvObjectRef();
}



/*************************************************************************
|*    SvFactory::SvObjectRef()
|*
|*    Beschreibung
*************************************************************************/
SvObjectRef SvFactory::CreateAndInit( const String & rFileNameP,
									  SvStorage * pStor, BOOL bLink ) const
{
	//if( SvStorage::IsStorageFile( rFileName ) )
	// Storage sichern
	SvObjectRef xObj;

	if( !rFileNameP.Len() )
		return xObj;

	String aAbsFileName = rFileNameP;

	SvStorageRef aStor = pStor;
	if ( pStor->IsOLEStorage() )
	{
		SvGlobalName aOLECLSID = SvOutPlaceObject::GetCLSID( aAbsFileName );
		if( aOLECLSID == SvGlobalName() || !Find( GetAutoConvertTo( aOLECLSID ) ) )
		{
			//keine eigenes Objekt
			xObj = SvOutPlaceObject::CreateFromFile( pStor, aAbsFileName );
			if( xObj.Is() )
				return xObj;
		}
	}

	SvStorageRef xFileStor( new SvStorage( aAbsFileName, STREAM_STD_READ ) );
	if( xFileStor->GetError() == SVSTREAM_OK )
	{
		if( xFileStor->CopyTo( pStor ) )
		{
			xObj = CreateAndLoad( pStor, bLink );
			return xObj;
		}
	}
	return xObj;
}


/*************************************************************************
|*    SvFactory::Register()
|*    SvFactory::Revoke()
|*
|*    Beschreibung
*************************************************************************/
void SvFactory::Register()
{
	DBG_ASSERT( !IsRegistered(), "SvFactory::Register: register twice" );
	if( !IsRegistered() )
	{
		nRegisterId = 1; // Wert ist unwichtig, aber != 0
		DBG_ASSERT( IsRegistered(), "SvFactory::Register: cannot register" )
	}
}


void SvFactory::Revoke()
{
	if( IsRegistered() )
	{
		nRegisterId = 0;
	}
}


//=========================================================================
void SvFactory::SetAutoTreatAs
(
	const SvGlobalName & rOldClass,     /* alte KlassenId   */
	const String & rOldFullUserTypeName,/* alter TypName    */
	const SvGlobalName & rNewClass      /* neue KlassenId   */
)
/*  [Beschreibung]

	Diese Methode installiert f"ur das gesammte System (User) eine
	Emulation der Klasse rOldClass durch die Klasse rNewClass. Diese
	Installation ist permanent.
	Diese Methode wirkt nur auf noch nicht im Server geladenen
	Objekte.

	[Beispiel]
	// StarWriter 3.0 durch 3.1 emulieren
	SvFactory::SetAutoTreatAs( OldGlobalName,
								"StarDivision Writer 3.0 Dokument",
							   NeuerGlobalName );

	[Querverweise]

	<SvFactory::Find>, <SvPersist::Load>, <SvFactory::GetAutoTreatAs>,
	<SvFactory::SetAutoConvertTo>
*/
{
	// Wenn RegDb geht
	// aClass += "\\TreatAs";
	// pClass.GetEntry( "TreatAs", TRUE, rNewClass.GetRegDbName() );
	DBG_WARNING( "SvFactory::SetAutoTreatAs not implemented" )
}

//=========================================================================
SvGlobalName SvFactory::GetAutoTreatAs
(
	const SvGlobalName & rClass
)
/*  [Beschreibung]

	Ist f"ur diese KlassenId eine Emulation installiert, dann wird
	die emulierende Klasse zur"uckgegeben. Ansonsten wird rClass
	zur"ueckgegeben.

	[R"uckgabewert]

	SvGlobalName    Die KlassenId, die statt der "ubergebenen benutzt
					werden soll.

	[Querverweise]

	<SvFactory::SetAutoConvertTo>,
*/
{
	SvGlobalName aRet = rClass;
	DBG_WARNING( "SvFactory::GetAutoTreatAs not implemented" )
	return aRet;
}

//=========================================================================
void SvFactory::SetAutoConvertTo
(
	const SvGlobalName & rOldClass,     /* alte KlassenId   */
	const String & rOldFullUserTypeName,/* alter TypName    */
	const SvGlobalName & rNewClass      /* neue KlassenId   */
)
/*  [Beschreibung]

	Diese Methode installiert f"ur das gesammte System (User) eine
	Konvertierund der Klasse rOldClass durch die Klasse rNewClass. Diese
	Installation ist permanent.
	Diese Methode wirkt nur auf noch nicht im Server geladenen
	Objekte.

	[Beispiel]
	// StarWriter 3.0 durch 3.1 emulieren
	SvFactory::SetAutoConvertTo( OldGlobalName,
								"StarDivision Writer 3.0 Dokument",
								NeuerGlobalName );

	[Querverweise]

	<SvFactory::Find>, <SvPersist::Load>, <SvFactory::GetAutoConvertTo>,
	<SvFactory::SetAutoTreatAs>
*/
{
	// Wenn RegDb geht
	// aClass += "\\AutoConvertTo";
	// pClass.GetEntry( "AutoConvertTo", TRUE, rNewClass.GetRegDbName() );
	DBG_WARNING( "SvFactory::SetAutoConvertTo not implemented" )
}

//=========================================================================
ConvertTo_Impl (* SetupConvertTable_Impl( USHORT * pCount )) [SO3_OFFICE_VERSIONS]
{
	// Die alten Eintr"age m"ussen vor den neueren stehen, damit der
	// Algorithmus besser "uber mehrere Konvertierungsstufen laufen kann.
	// Neue Eintr"age d"urfen nur angeh"angt werden. Sonst m"ussen alle
	// Vorg"anger und Nachfolger Indizes "uberarbeitet werden.
	SoDll * pSoApp = SOAPP;
	if( !pSoApp->pConvTable )
	{
		pSoApp->nConvTableEntries = 8;
		pSoApp->pConvTable = new ConvertTo_Impl[8][SO3_OFFICE_VERSIONS];

		pSoApp->pConvTable[0][0] = ConvertTo_Impl
		(// StarWiter 3.0
		  SvGlobalName( 0xDC5C7E40L, 0xB35C, 0x101B, 0x99, 0x61, 0x04, 0x02, 0x1C, 0x00, 0x70,0x02 ),
		  *SvInPlaceObject::ClassFactory(),
		  SOT_FORMATSTR_ID_STARWRITER_30
		);
		pSoApp->pConvTable[0][1] = ConvertTo_Impl
		(// StarWiter 4.0
		  SvGlobalName( 0x8b04e9b0L, 0x420e, 0x11d0, 0xa4, 0x5e, 0x0,  0xa0, 0x24, 0x9d, 0x57, 0xb1 ),
		  SOT_FORMATSTR_ID_STARWRITER_40
		);
		pSoApp->pConvTable[0][2] = ConvertTo_Impl
		(// StarWiter 5.0
		  SvGlobalName( SO3_SW_CLASSID_50 ),
		  SOT_FORMATSTR_ID_STARWRITER_50
		);
		pSoApp->pConvTable[0][3] = ConvertTo_Impl
		(// StarWiter
		  SvGlobalName( SO3_SW_CLASSID_60 ),
		  SOT_FORMATSTR_ID_STARWRITER_60
		);
		pSoApp->pConvTable[0][4] = ConvertTo_Impl
		(// StarWiter
		  SvGlobalName( SO3_SW_CLASSID ),
		  SOT_FORMATSTR_ID_STARWRITER_60
		);

		pSoApp->pConvTable[1][0] = ConvertTo_Impl
		(// StarDraw 3.0
		  SvGlobalName( 0xAF10AAE0L, 0xB36D, 0x101B, 0x99, 0x61, 0x04, 0x02, 0x1C, 0x00, 0x70, 0x02 ),
		  *SvInPlaceObject::ClassFactory(),
		  SOT_FORMATSTR_ID_STARDRAW
		);
		pSoApp->pConvTable[1][1] = ConvertTo_Impl
		(// StarDraw 4.0
		  SvGlobalName( 0x012d3cc0L, 0x4216, 0x11d0, 0x89, 0xcb, 0x00, 0x80, 0x29, 0xe4, 0xb0, 0xb1 ),
		  SOT_FORMATSTR_ID_STARDRAW_40
		);
		pSoApp->pConvTable[1][2] = ConvertTo_Impl
		(// StarImpress 5.0
		  SvGlobalName( SO3_SIMPRESS_CLASSID_50 ),
		  SOT_FORMATSTR_ID_STARIMPRESS_50
		);
		pSoApp->pConvTable[1][3] = ConvertTo_Impl
		(// StarImpress
		  SvGlobalName( SO3_SIMPRESS_CLASSID_60 ),
		  SOT_FORMATSTR_ID_STARIMPRESS_60
		);
		pSoApp->pConvTable[1][4] = ConvertTo_Impl
		(// StarImpress
		  SvGlobalName( SO3_SIMPRESS_CLASSID ),
		  SOT_FORMATSTR_ID_STARIMPRESS_60
		);

		pSoApp->pConvTable[2][0] = ConvertTo_Impl
		(// StarChart 3.0
		  SvGlobalName( 0xFB9C99E0L, 0x2C6D, 0x101C, 0x8E, 0x2C, 0x00, 0x00, 0x1B, 0x4C, 0xC7, 0x11 ),
		  SOT_FORMATSTR_ID_STARCHART
		);
		pSoApp->pConvTable[2][1] = ConvertTo_Impl
		(// StarChart 4.0
		  SvGlobalName( 0x02b3b7e0L, 0x4225, 0x11d0, 0x89, 0xca, 0x00, 0x80, 0x29, 0xe4, 0xb0, 0xb1 ),
		  SOT_FORMATSTR_ID_STARCHART_40
		);
		pSoApp->pConvTable[2][2] = ConvertTo_Impl
		(// StarChart 5.0
		  SvGlobalName( SO3_SCH_CLASSID_50 ),
		  SOT_FORMATSTR_ID_STARCHART_50
		);
		pSoApp->pConvTable[2][3] = ConvertTo_Impl
		(// StarChart
		  SvGlobalName( SO3_SCH_CLASSID_60 ),
		  SOT_FORMATSTR_ID_STARCHART_60
		);
		pSoApp->pConvTable[2][4] = ConvertTo_Impl
		(// StarChart
		  SvGlobalName( SO3_SCH_CLASSID ),
		  SOT_FORMATSTR_ID_STARCHART_60
		);

		pSoApp->pConvTable[3][0] = ConvertTo_Impl
		(// StarMath 3.0
		  SvGlobalName( 0xD4590460L, 0x35FD, 0x101C, 0xB1, 0x2A, 0x04, 0x02, 0x1C, 0x00, 0x70, 0x02 ),
		  SOT_FORMATSTR_ID_STARMATH
		);
		pSoApp->pConvTable[3][1] = ConvertTo_Impl
		(// StarMath 4.0
		  SvGlobalName( 0x02b3b7e1L, 0x4225, 0x11d0, 0x89, 0xca, 0x00, 0x80, 0x29, 0xe4, 0xb0, 0xb1 ),
		  SOT_FORMATSTR_ID_STARMATH_40
		);
		pSoApp->pConvTable[3][2] = ConvertTo_Impl
		(// StarMath 5.0
		  SvGlobalName( SO3_SM_CLASSID_50 ),
		  SOT_FORMATSTR_ID_STARMATH_50
		);
		pSoApp->pConvTable[3][3] = ConvertTo_Impl
		(// StarMath
		  SvGlobalName( SO3_SM_CLASSID_60 ),
		  SOT_FORMATSTR_ID_STARMATH_60
		);
		pSoApp->pConvTable[3][4] = ConvertTo_Impl
		(// StarMath
		  SvGlobalName( SO3_SM_CLASSID ),
		  SOT_FORMATSTR_ID_STARMATH_60
		);

		pSoApp->pConvTable[4][0] = ConvertTo_Impl
		(// StarCalc 3.0
		  SvGlobalName( 0x3F543FA0L, 0xB6A6, 0x101B, 0x99, 0x61, 0x04, 0x02, 0x1C, 0x00, 0x70, 0x02 ),
		  *SvInPlaceObject::ClassFactory(),
		  SOT_FORMATSTR_ID_STARCALC
		);
		pSoApp->pConvTable[4][1] = ConvertTo_Impl
		(// StarCalc 4.0
		  SvGlobalName( 0x6361d441L, 0x4235, 0x11d0, 0x89, 0xcb, 0x00, 0x80, 0x29, 0xe4, 0xb0, 0xb1 ),
		  SOT_FORMATSTR_ID_STARCALC_40
		);
		pSoApp->pConvTable[4][2] = ConvertTo_Impl
		(// StarCalc 5.0
		  SvGlobalName( SO3_SC_CLASSID_50 ),
		  SOT_FORMATSTR_ID_STARCALC_50
		);
		pSoApp->pConvTable[4][3] = ConvertTo_Impl
		(// StarCalc
		  SvGlobalName( SO3_SC_CLASSID_60 ),
		  SOT_FORMATSTR_ID_STARCALC_60
		);
		pSoApp->pConvTable[4][4] = ConvertTo_Impl
		(// StarCalc
		  SvGlobalName( SO3_SC_CLASSID ),
		  SOT_FORMATSTR_ID_STARCALC_60
		);

		pSoApp->pConvTable[5][0] = ConvertTo_Impl
		(// StarDraw 3.0
		  SvGlobalName( 0xAF10AAE0L, 0xB36D, 0x101B, 0x99, 0x61, 0x04, 0x02, 0x1C, 0x00, 0x70, 0x02 ),
		  *SvInPlaceObject::ClassFactory(),
		  SOT_FORMATSTR_ID_STARDRAW
		);
		pSoApp->pConvTable[5][1] = ConvertTo_Impl
		(// StarDraw 4.0
		  SvGlobalName( 0x012d3cc0L, 0x4216, 0x11d0, 0x89, 0xcb, 0x00, 0x80, 0x29, 0xe4, 0xb0, 0xb1 ),
		  SOT_FORMATSTR_ID_STARDRAW_40
		);
		pSoApp->pConvTable[5][2] = ConvertTo_Impl
		(// StarDraw 5.0
		  SvGlobalName( SO3_SDRAW_CLASSID_50 ),
		  SOT_FORMATSTR_ID_STARDRAW_50
		);
		pSoApp->pConvTable[5][3] = ConvertTo_Impl
		(// StarDraw
		  SvGlobalName( SO3_SDRAW_CLASSID_60 ),
		  SOT_FORMATSTR_ID_STARDRAW_60
		);
		pSoApp->pConvTable[5][4] = ConvertTo_Impl
		(// StarDraw
		  SvGlobalName( SO3_SDRAW_CLASSID ),
		  SOT_FORMATSTR_ID_STARDRAW_60
		);

		pSoApp->pConvTable[6][0] = ConvertTo_Impl
		(// StarWiter 3.0
		  SvGlobalName( 0xDC5C7E40L, 0xB35C, 0x101B, 0x99, 0x61, 0x04, 0x02, 0x1C, 0x00, 0x70,0x02 ),
		  *SvInPlaceObject::ClassFactory(),
		  SOT_FORMATSTR_ID_STARWRITER_30
		);
		pSoApp->pConvTable[6][1] = ConvertTo_Impl
		(// StarWiter 4.0
		  SvGlobalName( SO3_SWWEB_CLASSID_40 ),
		  SOT_FORMATSTR_ID_STARWRITERWEB_40
		);
		pSoApp->pConvTable[6][2] = ConvertTo_Impl
		(// StarWiter 5.0
		  SvGlobalName( SO3_SWWEB_CLASSID_50 ),
		  SOT_FORMATSTR_ID_STARWRITERWEB_50
		);
		pSoApp->pConvTable[6][3] = ConvertTo_Impl
		(// StarWiter
		  SvGlobalName( SO3_SWWEB_CLASSID_60 ),
		  SOT_FORMATSTR_ID_STARWRITERWEB_60
		);
		pSoApp->pConvTable[6][4] = ConvertTo_Impl
		(// StarWiter
		  SvGlobalName( SO3_SWWEB_CLASSID ),
		  SOT_FORMATSTR_ID_STARWRITERWEB_60
		);

		pSoApp->pConvTable[7][0] = ConvertTo_Impl
		(// StarWiter 3.0
		  SvGlobalName( 0xDC5C7E40L, 0xB35C, 0x101B, 0x99, 0x61, 0x04, 0x02, 0x1C, 0x00, 0x70,0x02 ),
		  *SvInPlaceObject::ClassFactory(),
		  SOT_FORMATSTR_ID_STARWRITER_30
		);
		pSoApp->pConvTable[7][1] = ConvertTo_Impl
		(// StarWiter 4.0
		  SvGlobalName( SO3_SWGLOB_CLASSID_40 ),
		  SOT_FORMATSTR_ID_STARWRITERGLOB_40
		);
		pSoApp->pConvTable[7][2] = ConvertTo_Impl
		(// StarWiter 5.0
		  SvGlobalName( SO3_SWGLOB_CLASSID_50 ),
		  SOT_FORMATSTR_ID_STARWRITERGLOB_50
		);
		pSoApp->pConvTable[7][3] = ConvertTo_Impl
		(// StarWiter
		  SvGlobalName( SO3_SWGLOB_CLASSID_60 ),
		  SOT_FORMATSTR_ID_STARWRITERGLOB_60
		);
		pSoApp->pConvTable[7][4] = ConvertTo_Impl
		(// StarWiter
		  SvGlobalName( SO3_SWGLOB_CLASSID ),
		  SOT_FORMATSTR_ID_STARWRITERGLOB_60
		);

#if 0
		// obselete, because Image has been removed
		pSoApp->pConvTable[2][0] = ConvertTo_Impl
		(// StarImage 3.0
		  SvGlobalName( 0xEA60C941L, 0x2C6C, 0x101C, 0x8E, 0x2C, 0x00, 0x00, 0x1B, 0x4C, 0xC7, 0x11 ),
		  SOT_FORMATSTR_ID_STARIMAGE
		);
		pSoApp->pConvTable[2][1] = ConvertTo_Impl
		(// StarImage 4.0
		  SvGlobalName( 0x447BB8A0L, 0x41FB, 0x11D0, 0x89, 0xCA, 0x00, 0x80, 0x29, 0xE4, 0xB0, 0xB1 ),
		  SOT_FORMATSTR_ID_STARIMAGE_40
		);
		pSoApp->pConvTable[2][2] = ConvertTo_Impl
		(// StarImage 5.0
		  SvGlobalName( SO3_SIM_CLASSID_50 ),
		  SOT_FORMATSTR_ID_STARIMAGE_50
		);
		pSoApp->pConvTable[2][3] = ConvertTo_Impl
		(// StarImage 5.0
		  SvGlobalName( SO3_SIM_CLASSID ),
		  SOT_FORMATSTR_ID_STARIMAGE_50
		);
		pSoApp->pConvTable[2][4] = ConvertTo_Impl
		(// StarImage 5.0
		  SvGlobalName( SO3_SIM_CLASSID ),
		  SOT_FORMATSTR_ID_STARIMAGE_50
		);
#endif
	}
	*pCount = pSoApp->nConvTableEntries;
	return pSoApp->pConvTable;
}

//=========================================================================
SvGlobalName SvFactory::GetAutoConvertTo
(
	const SvGlobalName & rClass
)
/*  [Beschreibung]

	Ist f"ur diese KlassenId eine Konvertierung installiert, dann wird
	die Klasse, in die Konvertiert werden soll, zur"uckgegeben.
	Ansonsten wird rClass zur"ueckgegeben.

	[R"uckgabewert]

	SvGlobalName    Die KlassenId, die statt der "ubergebenen benutzt
					werden soll.

	[Querverweise]

	<SvFactory::SetAutoConvertTo>,
*/
{
	SvGlobalName aRet = rClass;

	USHORT nCount;
	ConvertTo_Impl (* pTable)[SO3_OFFICE_VERSIONS] = SetupConvertTable_Impl( &nCount );
	for( USHORT i = 0; i < nCount; i++ )
	{
		for( USHORT n = 0; n < SO3_OFFICE_VERSIONS; n++ )
		{
			if( pTable[i][n].aName == aRet )
				return pTable[i][SO3_OFFICE_VERSIONS -1].aName;
		}
	}
	return aRet;
}

//=========================================================================
SvGlobalName SvFactory::GetSvClass
(
	long nFileFormat,
	const SvGlobalName & rClass
)
/*  [Beschreibung]

	Die So2 Klasse die dieses Objekt in der nFileFormat Version serven soll.

	[R"uckgabewert]

	SvGlobalName    Die KlassenId, die statt der "ubergebenen benutzt
					werden soll.

	[Querverweise]

	<SvFactory::SetAutoConvertTo>,
*/
{
	SvGlobalName aRet = rClass;

	USHORT nCount;
	ConvertTo_Impl (*pTable)[SO3_OFFICE_VERSIONS] = SetupConvertTable_Impl( &nCount );
	for( USHORT i = 0; i < nCount; i++ )
	{
		for( USHORT n = 0; n < SO3_OFFICE_VERSIONS; n++ )
		{
			if( pTable[i][n].aName == aRet )
			{
				if( nFileFormat <= SOFFICE_FILEFORMAT_31 )
					return pTable[i][0].aSvName;
				else if( nFileFormat <= SOFFICE_FILEFORMAT_40 )
					return pTable[i][1].aSvName;
				else if( nFileFormat <= SOFFICE_FILEFORMAT_50 )
					return pTable[i][2].aSvName;
				else if( nFileFormat <= SOFFICE_FILEFORMAT_60 )
					return pTable[i][3].aSvName;
				else
					return aRet;
				/*
				for( USHORT m = 0; m < SO3_OFFICE_VERSIONS; m++ )
				{
					if( pTable[i][m].aFormat == nFileFormat )
						return pTable[i][m].aSvName;
				}
				return aRet;
				*/
			}
		}
	}
	return aRet;
}

//=========================================================================
SvGlobalName SvFactory::GetSvClass31
(
	const SvGlobalName & rClass
)
/*  [Beschreibung]

	Die So2 Klasse die dieses Objekt in der 3.1 serven soll.

	[R"uckgabewert]

	SvGlobalName    Die KlassenId, die statt der "ubergebenen benutzt
					werden soll.

	[Querverweise]

	<SvFactory::SetAutoConvertTo>,
*/
{
	return GetSvClass( SOFFICE_FILEFORMAT_31, rClass );
}

//=========================================================================
BOOL SvFactory::IsIntern31
(
	const SvGlobalName & rClass
)
/*  [Beschreibung]

	Ist es in der 31 Version ein internes Objekt.

	[R"uckgabewert]

	BOOL            TRUE, es ist 31 intern.

	[Querverweise]

	<SvFactory::SetAutoConvertTo>,
*/
{
	SvGlobalName aRet = rClass;

	USHORT nCount;
	ConvertTo_Impl (*pTable)[SO3_OFFICE_VERSIONS] = SetupConvertTable_Impl( &nCount );
	for( USHORT i = 0; i < nCount; i++ )
	{
		for( USHORT n = 0; n < SO3_OFFICE_VERSIONS; n++ )
		{
			if( pTable[i][n].aName == aRet )
				// Wenn es ein InPlace-Objekt ist, mu es extern sein
				return *SvInPlaceObject::ClassFactory()	!= pTable[i][0].aSvName;
		}
	}
	return FALSE;
}
//=========================================================================
BOOL SvFactory::IsIntern
(
	const SvGlobalName & rClass,
 	long *pFileFormat
)
/*  [Description]

	Is it an internal object

	[Return Value]

	BOOL            TRUE, if it is an internal object

	[Cross reference]

	<SvFactory::SetAutoConvertTo>,
*/
{
	SvGlobalName aRet = rClass;

	USHORT nCount;
	ConvertTo_Impl (*pTable)[SO3_OFFICE_VERSIONS] = SetupConvertTable_Impl( &nCount );
	for( USHORT i = 0; i < nCount; i++ )
	{
		for( USHORT n = 0; n < SO3_OFFICE_VERSIONS; n++ )
		{
			if( pTable[i][n].aName == aRet )
			{
				if( pFileFormat )
				{
					switch( n )
					{
					case 0: *pFileFormat = SOFFICE_FILEFORMAT_31; break;
					case 1: *pFileFormat = SOFFICE_FILEFORMAT_40; break;
					case 2: *pFileFormat = SOFFICE_FILEFORMAT_50; break;
					case 3: *pFileFormat = SOFFICE_FILEFORMAT_60; break;
					default:
							DBG_ERROR( "unexepected class id" );
							break;
					}
				}
				return TRUE;
			}
		}
	}
	return FALSE;
}

SvGlobalName SvFactory::GetServerName( long nStorageFormat )
{
	SvGlobalName aRet;

	USHORT nCount;
	ConvertTo_Impl (*pTable)[SO3_OFFICE_VERSIONS] = SetupConvertTable_Impl( &nCount );
	for( USHORT i = 0; i < nCount; i++ )
	{
		for( USHORT n = 0; n < SO3_OFFICE_VERSIONS; n++ )
		{
			if( pTable[i][n].aFormat == nStorageFormat )
				return pTable[i][n].aName;
		}
	}
	return aRet;
}


/************************************************************************/
/************** S v O l e F a c t o r y *********************************/
/*************************************************************************
|*    SvOleFactory::SvOleFactory()
|*
|*    Beschreibung
*************************************************************************/
SvOleFactory::SvOleFactory( const SvGlobalName & rName,
							const String & rClassName,
							CreateInstanceType pCreateFuncP )
	: SvFactory( rName, rClassName, pCreateFuncP )
{
}

TYPEINIT1(SvOleFactory,SvFactory);

/************************************************************************/
/************** S v O n e I n s a n c e F a c t o r y *******************/
/*************************************************************************
|*    SvOneInstanceFactory::SvOneInstanceFactory()
|*
|*    Beschreibung
*************************************************************************/
SvOneInstanceFactory::SvOneInstanceFactory( const SvGlobalName & rName,
											const String & rClassName,
											CreateInstanceType pCreateFuncP )
	: SvFactory( rName, rClassName, pCreateFuncP )
	, pObj( NULL )
	, nRegId( 0 )
{
}

TYPEINIT1(SvOneInstanceFactory,SvFactory);

/*************************************************************************
|*    SvOneInstanceFactory::CreateInstance()
|*
|*    Beschreibung
*************************************************************************/
void * SvOneInstanceFactory::CreateInstance( SotObject ** ppObj ) const
{
	void * pRet;
	if( pObj )
	{
		// nur so bekomme ich den richtigen void *
		pRet = pObj->Cast( this );
	}
	else
	{
		SotObject * pObj;
		pRet = SvFactory::CreateInstance( &pObj );
		if( !pObj )
			// nur setzen, wenn dies nicht im ctor geschehen ist
			((SvOneInstanceFactory *)this)->SetObject( pObj );
	}
	if( ppObj )
		*ppObj = pObj;
	return pRet;
}


/*************************************************************************
|*    SvOneInstanceFactory::SetObject()
|*
|*    Beschreibung
*************************************************************************/
void  SvOneInstanceFactory::SetObject( SotObject * pObjP )
{
	DBG_ASSERT( pObjP, "zero Parameter" )
	DBG_ASSERT( !pObj, "instance is set" )
	pObj = pObjP;
}


/*************************************************************************
|*    SvOneInstanceFactory::Remove()
|*
|*    Beschreibung
*************************************************************************/
void  SvOneInstanceFactory::RemoveObject()
{
	pObj = NULL;
}




