/*************************************************************************
 *
 *  $RCSfile: custritm.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 14:36:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_CUSTRITM_HXX
#define _SVTOOLS_CUSTRITM_HXX

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _SFXPOOLITEM_HXX
#include <poolitem.hxx>
#endif

//============================================================================
DBG_NAMEEX(CntUnencodedStringItem);

class CntUnencodedStringItem: public SfxPoolItem
{
	XubString m_aValue;

public:
	TYPEINFO();

	CntUnencodedStringItem(USHORT nWhich = 0): SfxPoolItem(nWhich)
	{ DBG_CTOR(CntUnencodedStringItem, 0); }

	CntUnencodedStringItem(USHORT nWhich, const XubString & rTheValue):
		SfxPoolItem(nWhich), m_aValue(rTheValue)
	{ DBG_CTOR(CntUnencodedStringItem, 0); }

	CntUnencodedStringItem(const CntUnencodedStringItem & rItem):
		SfxPoolItem(rItem), m_aValue(rItem.m_aValue)
	{ DBG_CTOR(CntUnencodedStringItem, 0); }

	virtual ~CntUnencodedStringItem() { DBG_DTOR(CntUnencodedStringItem, 0); }

	virtual int operator ==(const SfxPoolItem & rItem) const;

	virtual int Compare(const SfxPoolItem & rWith) const;

	virtual int Compare(SfxPoolItem const & rWith,
                        IntlWrapper const & rIntlWrapper) const;

	virtual SfxItemPresentation GetPresentation(SfxItemPresentation,
												SfxMapUnit, SfxMapUnit,
												XubString & rText,
                                                const IntlWrapper * = 0)
		const;

	virtual	BOOL QueryValue(com::sun::star::uno::Any& rVal,
							BYTE nMemberId = 0) const;

	virtual	BOOL PutValue(const com::sun::star::uno::Any& rVal,
						  BYTE nMemberId = 0);

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const;

	const XubString & GetValue() const { return m_aValue; }

	inline void SetValue(const XubString & rTheValue);
};

inline void CntUnencodedStringItem::SetValue(const XubString & rTheValue)
{
	DBG_ASSERT(GetRefCount() == 0,
			   "CntUnencodedStringItem::SetValue(): Pooled item");
	m_aValue = rTheValue;
}

#endif //  _SVTOOLS_CUSTRITM_HXX

