/*************************************************************************
 *
 *  $RCSfile: roadmap.hxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: bc $ $Date: 2003/09/15 11:33:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef SVTOOLS_ROADMAP_HXX
#define SVTOOLS_ROADMAP_HXX

#ifndef _SV_CTRL_HXX
#include <vcl/ctrl.hxx>
#endif

class Bitmap;
//.........................................................................
namespace svt
{
//.........................................................................

	class RoadmapImpl;
	//=====================================================================
	//= Roadmap
	//=====================================================================
	class Roadmap : public Control
	{
	protected:
		RoadmapImpl*		m_pImpl;

	public:
		Roadmap( Window* _pParent, const ResId& _rId );
		Roadmap( Window* _pParent, WinBits _nWinStyle = 0 );
		~Roadmap( );

	public:
		/**	sets the bitmap to be used
			@param	_rBmp
				the new bitmap
			@param	_bInvalidate
				if <TRUE/>, the control will be invalidated and thus repainted
		*/
		void			setHeaderBitmap( const Bitmap& _rBmp, sal_Bool _bInvalidate = sal_True );

		/** returns the bitmap currently used
		*/
		const Bitmap&	getHeaderBitmap( ) const;

		/** sets the text to be displayed
			<p>In a wizard, you usually change the text with ever page change.</p>
			@param	_rText
				the new text
			@param	_bInvalidate
				if <TRUE/>, the control will be invalidated and thus repainted
		*/
		void			setHeaderText( const String& _rText, sal_Bool _bInvalidate = sal_True );

		/** returns the text currently used
		*/
		const String&	getHeaderText( ) const;

	protected:
		// Window overridables
		void			Paint( const Rectangle& _rRect );

	private:
		void implInit();
	};

//.........................................................................
}	// namespace svt
//.........................................................................

#endif // SVTOOLS_WIZARDHEADER_HXX

