/*************************************************************************
 *
 *  $RCSfile: whranges.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:25:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
// INCLUDE ---------------------------------------------------------------
#include <svarray.hxx>

#pragma hdrstop

#include "whranges.hxx"

DBG_NAME(SfxWhichRanges);


// -----------------------------------------------------------------------


void SfxWhichRanges::InitRanges(va_list pArgs, USHORT nWh1)
{
	DBG_CHKTHIS(SfxWhichRanges, 0);

	USHORT nSize = 0, nCnt = 0;
	USHORT nIns = 0;
	aUShorts.Insert( nCnt++, nWh1 );
	while( 0 != ( nIns = va_arg( pArgs, USHORT ) ) )
	{
		aUShorts.Insert( nCnt++, nIns );
		if( 0 == (nCnt & 1) )		// 4,6,8, usw.
		{
			DBG_ASSERT( aUShorts[ nCnt-2 ] <= nIns, "Ungueltier Bereich" );
#ifndef PRODUCT
			// falls der Bereich ungueltig ist, swappen !
			if( nIns < aUShorts[ nCnt-2 ] )
			{
				aUShorts[ nCnt-1 ] = aUShorts[ nCnt-2 ];
				aUShorts[ nCnt-2 ] = nIns;
				nIns = aUShorts[ nCnt-1 ];
			}
#endif
			nSize += nIns - aUShorts[ nCnt-2 ] + 1;
		}
	}
	va_end( pArgs );

	DBG_ASSERT( 0 == (nCnt & 1), "ungerade Anzahl von Which-Paaren!" );
#ifndef PRODUCT
	if( 0 != (nCnt & 1) )		// ungerade Anzahl von Paaren !!
	{
		DBG_ASSERT( FALSE, "ungerade Anzahl von Which-Paaren!" );
		nIns = aUShorts[ nCnt-1 ];
		aUShorts.Insert( nCnt++, nIns );
		++nSize;
	}
#endif
}

// -----------------------------------------------------------------------


SfxWhichRanges::SfxWhichRanges( const USHORT *pIniRanges ):
	aUShorts( 8, 8 )
{
	DBG_CTOR(SfxWhichRanges, 0);

	const USHORT *p = pIniRanges;
	for ( USHORT nCount = 1; *p; ++nCount )
		++p;

	aUShorts.InitData(pIniRanges, nCount);
}

// -----------------------------------------------------------------------


SfxWhichRanges::SfxWhichRanges( USHORT nFrom, USHORT nTo ):
	aUShorts( 8, 8 )
{
	DBG_CTOR(SfxWhichRanges, 0);
	DBG_ASSERT( nFrom <= nTo, "Ungueltiger Bereich" );
#ifndef PRODUCT
	if( nFrom > nTo )					// falls der Bereich ungueltig ist
		nFrom ^= nTo ^= nFrom ^= nTo;	// swappen
#endif

	aUShorts.Insert( 0, nFrom );
	aUShorts.Insert( 1, nTo );
	aUShorts.Insert( 2, (USHORT) 0 );
}

// -----------------------------------------------------------------------


SfxWhichRanges::SfxWhichRanges( USHORT nFrom, USHORT nTo, USHORT nNull, ... ):
	aUShorts( 8, 8 )
{
	DBG_CTOR(SfxWhichRanges, 0);
	DBG_ASSERT( nFrom <= nTo, "Ungueltiger Bereich" );
	DBG_ASSERT( nNull, "bitte den anderen Ctor nehmen" );
#ifndef PRODUCT
	if( nFrom > nTo )					// falls der Bereich ungueltig ist
		nFrom ^= nTo ^= nFrom ^= nTo;	// swappen
#endif
	va_list pArgs;
	va_start( pArgs, nFrom );
	InitRanges(pArgs, nFrom );
}

// -----------------------------------------------------------------------


SfxWhichRanges& SfxWhichRanges::operator= ( const SfxWhichRanges &rRanges )
{
	aUShorts = rRanges.aUShorts;
	return *this;
}

// -----------------------------------------------------------------------


SfxWhichRanges& SfxWhichRanges::operator+=( const SfxWhichRanges &rRanges )
{
	if ( !rRanges.aUShorts.GetSize() )
		return *this;

	operator+=( rRanges.aUShorts.GetStart() );

	return *this;
}

// -----------------------------------------------------------------------


SfxWhichRanges& SfxWhichRanges::operator+=( USHORT nWhich )
{
	if ( !aUShorts.GetSize() )
	{
		aUShorts.Insert(0, nWhich);
		aUShorts.Insert(1, nWhich);
		aUShorts.Insert(2, (USHORT) 0);
	}
	else
	{
		// Position suchen
		for ( USHORT nOfs = 0; aUShorts[nOfs]; nOfs += 2 )
		{
			if ( nWhich < aUShorts[nOfs] - 1 )
			{
				// neuen Range davor
				USHORT aNewRange[2];
				aNewRange[0] = nWhich;
				aNewRange[1] = nWhich;
				aUShorts.Insert( nOfs, aNewRange, 2 );
				return *this;
			}
			else if ( nWhich == aUShorts[nOfs] - 1 )
			{
				// diesen Range nach unten erweitern
				aUShorts[nOfs] = nWhich;
				return *this;
			}
			else if ( nWhich == aUShorts[nOfs+1] + 1 )
			{
				if ( aUShorts[nOfs+2] != 0 && aUShorts[nOfs+2] == nWhich + 1 )
				{
					// mit dem naechsten Bereich mergen
					aUShorts[nOfs+1] = aUShorts[nOfs+3];
					aUShorts.Delete( nOfs+2, 2 );
				}
				else
					// diesen Range nach oben erweitern
					aUShorts[nOfs+1] = nWhich;
				return *this;
			}
		}

		// einen Range hinten anhaengen
		USHORT aNewRange[2];
		aNewRange[0] = nWhich;
		aNewRange[1] = nWhich;
		aUShorts.Insert( aUShorts.GetSize()-1, aNewRange, 2 );
	}

	return *this;
}

// -----------------------------------------------------------------------


SfxWhichRanges& SfxWhichRanges::operator+=( const USHORT *pAddRanges )
{
	DBG_CHKTHIS( SfxWhichRanges, 0 );

	//! to be optimized
	for ( const USHORT *pPair = pAddRanges; *pPair; pPair += 2 )
		for ( USHORT nWhich = *pPair; nWhich <= *(pPair+1); ++nWhich )
			operator+=( nWhich );
	return *this;
}

