/*************************************************************************
 *
 *  $RCSfile: svdvmark.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "svdvmark.hxx"
#include "xpoly.hxx"
#include "svdxout.hxx"
#include "svdobj.hxx"
#include "svdpagv.hxx"
#include "svdpntv.hxx"

#ifndef _SV_POLY_HXX //autogen
#include <vcl/poly.hxx>
#endif
#ifndef NOOLDSV //autogen
#include <vcl/system.hxx>
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////

SdrViewUserMarker::SdrViewUserMarker(SdrPaintView* pView_)
:	pView(pView_),
	pForcedOutDev(NULL),
	pPoint(NULL),
	pRect(NULL),
	pPoly(NULL),
	pPolyPoly(NULL),
	pXPoly(NULL),
	pXPolyPoly(NULL),
	eAlign(SDRMARKER_ALIGNCENTER),
	nPixelDistance(0),
	nLineWdt(0),
	nCrossSize(0),
	bLineWdtLog(FALSE),
	bCrossSizeLog(FALSE),
	bSolidArea(FALSE),
	bDashed(FALSE),
	bCrossHair(FALSE),
	bStripes(FALSE),
	bEllipse(FALSE),
	bPolyLine(FALSE),
	bAnimate(FALSE),
	bVisible(FALSE),
	nAnimateDelay(0),
	nAnimateSpeed(0),
	nAnimateAnz(0),
	bAnimateBwd(FALSE),
	bAnimateToggle(FALSE),
	nAnimateDelayCountDown(0),
	nAnimateSpeedCountDown(0),
	nAnimateNum(0),
	bHasPointer(FALSE),
	bMouseMovable(FALSE)
{
	if (pView!=NULL) pView->ImpInsertUserMarker(this);
	bAnimateToggle=TRUE;
}

SdrViewUserMarker::~SdrViewUserMarker()
{
	if (bVisible) Hide();
	if (pView!=NULL) pView->ImpRemoveUserMarker(this);
	ImpDelGeometrics();
}

void SdrViewUserMarker::ImpDelGeometrics()
{
	if (pPoint    !=NULL) { delete pPoint    ; pPoint    =NULL; }
	if (pRect     !=NULL) { delete pRect     ; pRect     =NULL; }
	if (pPoly     !=NULL) { delete pPoly     ; pPoly     =NULL; }
	if (pPolyPoly !=NULL) { delete pPolyPoly ; pPolyPoly =NULL; }
	if (pXPoly    !=NULL) { delete pXPoly    ; pXPoly    =NULL; }
	if (pXPolyPoly!=NULL) { delete pXPolyPoly; pXPolyPoly=NULL; }
}

void SdrViewUserMarker::SetView(SdrPaintView* pView_)
{
	if (pView_==pView) return;
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	pView=pView_;
	if (bVis) Show();
}

void SdrViewUserMarker::SetPoint(const Point& rPoint)
{
	if (pPoint!=NULL && rPoint==*pPoint) return;
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	if (pPoint==NULL) {
		ImpDelGeometrics();
		pPoint=new Point(rPoint);
	} else {
		*pPoint=rPoint;
	}
	if (bVis) Show();
}

void SdrViewUserMarker::SetRectangle(const Rectangle& rRect)
{
	if (pRect!=NULL && rRect==*pRect) return;
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	if (pRect==NULL) {
		ImpDelGeometrics();
		pRect=new Rectangle(rRect);
	} else {
		*pRect=rRect;
	}
	if (bVis) Show();
}

void SdrViewUserMarker::SetRectangle(const SdrObject* pObj, const SdrPageView* pPV)
{
	if (pObj!=NULL) {
		Rectangle aR(pObj->GetBoundRect());
		if (pPV!=NULL) {
			aR.Move(pPV->GetOffset().X(),pPV->GetOffset().Y());
		}
		SetRectangle(aR);
	}
}

void SdrViewUserMarker::SetPolygon(const Polygon& rPoly)
{
	if (pPoly!=NULL && rPoly==*pPoly) return;
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	if (pPoly==NULL) {
		ImpDelGeometrics();
		pPoly=new Polygon(rPoly);
	} else {
		*pPoly=rPoly;
	}
	if (bVis) Show();
}

void SdrViewUserMarker::SetPolyPolygon(const PolyPolygon& rPolyPoly)
{
	if (pPolyPoly!=NULL && rPolyPoly==*pPolyPoly) return;
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	if (pPolyPoly==NULL) {
		ImpDelGeometrics();
		pPolyPoly=new PolyPolygon(rPolyPoly);
	} else {
		*pPolyPoly=rPolyPoly;
	}
	if (bVis) Show();
}

void SdrViewUserMarker::SetXPolygon(const XPolygon& rXPoly)
{
	if (pXPoly!=NULL && rXPoly==*pXPoly) return;
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	if (pXPoly==NULL) {
		ImpDelGeometrics();
		pXPoly=new XPolygon(rXPoly);
	} else {
		*pXPoly=rXPoly;
	}
	if (bVis) Show();
}

void SdrViewUserMarker::SetXPolyPolygon(const XPolyPolygon& rXPolyPoly)
{
	if (pXPolyPoly!=NULL && rXPolyPoly==*pXPolyPoly) return;
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	if (pXPolyPoly==NULL) {
		ImpDelGeometrics();
		pXPolyPoly=new XPolyPolygon(rXPolyPoly);
	} else {
		*pXPolyPoly=rXPolyPoly;
	}
	if (bVis) Show();
}

void SdrViewUserMarker::SetXPolyPolygon(const SdrObject* pObj, const SdrPageView* pPV)
{
	if (pObj!=NULL) {
		XPolyPolygon aXPP;
		pObj->TakeXorPoly(aXPP,TRUE);
		if (pPV!=NULL) {
			aXPP.Move(pPV->GetOffset().X(),pPV->GetOffset().Y());
		}
		FASTBOOL bChg=!bSolidArea && !bPolyLine;
		FASTBOOL bVis=bVisible;
		if (bVis && bChg) Hide();
		SetXPolyPolygon(aXPP);
		if (bChg) bPolyLine=TRUE;
		if (bVis && bChg) Show();
	}
}

void SdrViewUserMarker::SetCrossHair(FASTBOOL bOn)
{
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	bCrossHair=bOn;
	if (bVis) Show();
}

void SdrViewUserMarker::SetStripes(FASTBOOL bOn)
{
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	bStripes=bOn;
	if (bOn) { bSolidArea=FALSE; bEllipse=FALSE; }
	if (bVis) Show();
}

void SdrViewUserMarker::SetEllipse(FASTBOOL bOn)
{
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	bEllipse=bOn;
	if (bVis) Show();
}

void SdrViewUserMarker::SetPolyLine(FASTBOOL bOn)
{
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	bPolyLine=bOn;
	if (bOn) { bSolidArea=FALSE; }
	if (bVis) Show();
}

void SdrViewUserMarker::SetSolidArea(FASTBOOL bOn)
{
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	bSolidArea=bOn;
	if (bOn) { bStripes=FALSE; bPolyLine=FALSE; }
	if (bVis) Show();
}

void SdrViewUserMarker::SetDashed(FASTBOOL bOn)
{
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	bDashed=bOn;
	if (bVis) Show();
}

void SdrViewUserMarker::SetAnimate(FASTBOOL bOn)
{
	FASTBOOL bFlag=IsAnimate();
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	bAnimate=bOn;
	if (bVis) Show();
	if (bFlag!=IsAnimate() && pView!=NULL) pView->ImpCheckMarkerAnimator();
}

void SdrViewUserMarker::SetPixelDistance(USHORT nDistance)
{
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	nPixelDistance=nDistance;
	if (bVis) Show();
}

void SdrViewUserMarker::SetLineWidth(USHORT nWdt)
{
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	nLineWdt=nWdt;
	if (bVis) Show();
}

void SdrViewUserMarker::SetLineWidthIsLogic(FASTBOOL bOn)
{
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	bLineWdtLog=bOn;
	if (bVis) Show();
}

void SdrViewUserMarker::SetCrossHairSize(USHORT nSize)
{
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	nCrossSize=nSize;
	if (bVis) Show();
}

void SdrViewUserMarker::SetCrossSizeIsLogic(FASTBOOL bOn)
{
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	bCrossSizeLog=bOn;
	if (bVis) Show();
}

void SdrViewUserMarker::Move(long nXMove, long nYMove)
{
	if (nXMove==0 && nYMove==0) return;
	FASTBOOL bVis=bVisible;
	if (bVis) Hide();
	if (pPoint    !=NULL) { pPoint    ->Move(nXMove,nYMove); }
	if (pRect     !=NULL) { pRect     ->Move(nXMove,nYMove); }
	if (pPoly     !=NULL) { pPoly     ->Move(nXMove,nYMove); }
	if (pPolyPoly !=NULL) { pPolyPoly ->Move(nXMove,nYMove); }
	if (pXPoly    !=NULL) { pXPoly    ->Move(nXMove,nYMove); }
	if (pXPolyPoly!=NULL) { pXPolyPoly->Move(nXMove,nYMove); }
	if (bVis) Show();
}

void SdrViewUserMarker::Show()
{
	if (!bVisible) {
		nAnimateDelayCountDown=nAnimateDelay;
		if (nAnimateDelay!=0) {
			if (bAnimateToggle) bAnimateBwd=FALSE;
			nAnimateNum=0;
		}
		nAnimateSpeedCountDown=nAnimateSpeed;
		ImpDraw(FALSE,FALSE);
		bVisible=TRUE;
	}
}

void SdrViewUserMarker::Hide()
{
	if (bVisible) {
		ImpDraw(TRUE,FALSE);
		bVisible=FALSE;
	}
}

void SdrViewUserMarker::ImpDraw(FASTBOOL bHiding, FASTBOOL bNoSaveDC)
{
	if (pView==NULL) return;
	if (pForcedOutDev!=NULL) {
		Draw(pForcedOutDev,bHiding,bNoSaveDC);
	} else {
		USHORT nAnz=pView->GetWinCount();
		for (USHORT nNum=0; nNum<nAnz; nNum++) {
			SdrViewWinRec& rWinRec = pView->GetWinRec(nNum);
			OutputDevice* pO=pView->GetWin(nNum);
			if (pO->GetOutDevType()==OUTDEV_WINDOW) {
				Draw(pO,bHiding,bNoSaveDC);
				if(!bHiding)
					rWinRec.bXorVisible = TRUE;
			}
		}
	}
}

void SdrViewUserMarker::Draw(OutputDevice* pOut1, FASTBOOL bHiding, FASTBOOL bNoSaveDC)
{
	if (pOut1==NULL) 
		return;

	RasterOp eRop0=pOut1->GetRasterOp();
	FASTBOOL bMap0=pOut1->IsMapModeEnabled();
	pOut1->SetRasterOp(ROP_INVERT);

	FASTBOOL bFill=IsSolidArea();

	Color aLineColorMerk( pOut1->GetLineColor() );
	Color aFillColorMerk( pOut1->GetFillColor() );

	Color aLineColor( bFill ? COL_TRANSPARENT : COL_BLACK );
	Color aFillColor( bFill ? COL_BLACK : COL_TRANSPARENT );
	
	USHORT nLWdt=nLineWdt;
	
	if (nLWdt==0) 
		nLWdt=1;
	if (bAnimate && !bDashed) 
		nLWdt+=nAnimateNum;

	// Point und Rect werden in Pixel ausgegeben
	Point aPoint;
	Rectangle aRect;
	if (pPoint!=NULL) 
		aPoint=pOut1->LogicToPixel(*pPoint);
	if (pRect!=NULL)  
		aRect =pOut1->LogicToPixel(*pRect);

	long nLWdt1=0,nLWdt2=0;
	if (pPoint!=NULL || pRect!=NULL) 
	{
		nLWdt1=nLWdt;
		if (bLineWdtLog) nLWdt1=pOut1->PixelToLogic(Size(nLWdt1,0)).Width();
		nLWdt2=nLWdt1;
		if (nLWdt1>0) {
			nLWdt1=(nLWdt1-1)/2;
			nLWdt2/=2;
		}
	}

	Size aCrSiz(nCrossSize,nCrossSize);
	long nOutMaxX=0,nOutMaxY=0;
	
	if ((pPoint!=NULL && bCrossHair) || (pRect!=NULL && bStripes)) 
	{
		if (nCrossSize!=0) 
		{
			if (bCrossSizeLog) 
				aCrSiz=pOut1->LogicToPixel(aCrSiz);
		} 
		else 
		{ // Stripes/CrossHair ueber den vollen Bildschirm
			Size aSiz(pOut1->GetOutputSizePixel());
			nOutMaxX=aSiz.Width();
			nOutMaxY=aSiz.Height();
		}
		aCrSiz.Width()/=2;  
		aCrSiz.Height()/=2; 
		if (aCrSiz.Width()<=0) 
			aCrSiz.Width()=1;
		if (aCrSiz.Height()<=0) 
			aCrSiz.Height()=1;
	}
	if (pPoint!=NULL) 
	{
		pOut1->EnableMapMode(FALSE);
		pOut1->SetLineColor( aLineColor );
		if (bCrossHair) 
		{
			long xl=nCrossSize==0 ? 0        : aPoint.X()-aCrSiz.Width();
			long xr=nCrossSize==0 ? nOutMaxX : aPoint.X()+aCrSiz.Width();
			long yo=nCrossSize==0 ? 0        : aPoint.Y()-aCrSiz.Height();
			long yu=nCrossSize==0 ? nOutMaxY : aPoint.Y()+aCrSiz.Height();
			pOut1->DrawLine(Point(aPoint.X(),yo),Point(aPoint.X(),yu));
			pOut1->DrawLine(Point(xl,aPoint.Y()),Point(xr,aPoint.Y()));
		} 
		else 
		{
			Rectangle aRect(aPoint,aPoint);
			long nDist1=nLWdt1+nPixelDistance; // Strichstaerke und
			long nDist2=nLWdt2+nPixelDistance; // Pixelabstand noch dazu
			aRect.Left()-=nDist1; 
			aRect.Top()-=nDist1; 
			aRect.Right()+=nDist2; 
			aRect.Bottom()+=nDist2;
			
			pOut1->SetFillColor( aFillColor );
			
			if (bEllipse) 
				pOut1->DrawEllipse(aRect);
			else
				pOut1->DrawRect(aRect);
		}
	}
	if (pRect!=NULL) 
	{
		pOut1->EnableMapMode(FALSE);
		pOut1->SetLineColor( aLineColor );
		long nDist1=nLWdt1+nPixelDistance; // Strichstaerke und
		long nDist2=nLWdt2+nPixelDistance; // Pixelabstand noch dazu
		aRect.Left()-=nDist1; 
		aRect.Top()-=nDist1; 
		aRect.Right()+=nDist2; 
		aRect.Bottom()+=nDist2;
		
		if (bStripes) 
		{
			long xl=aCrSiz.Width ()==0 ? 0        : aRect.Left  ()-aCrSiz.Width();
			long xr=aCrSiz.Width ()==0 ? nOutMaxX : aRect.Right ()+aCrSiz.Width();
			long yo=aCrSiz.Height()==0 ? 0        : aRect.Top   ()-aCrSiz.Height();
			long yu=aCrSiz.Height()==0 ? nOutMaxY : aRect.Bottom()+aCrSiz.Height();
		
			pOut1->DrawLine(Point(xl,aRect.Top   ()),aRect.TopLeft   ());
			pOut1->DrawLine(Point(xl,aRect.Bottom()),aRect.BottomLeft());
			pOut1->DrawLine(aRect.TopRight   (),Point(xr,aRect.Top())   );
			pOut1->DrawLine(aRect.BottomRight(),Point(xr,aRect.Bottom()));
			pOut1->DrawLine(Point(aRect.Left (),yo),aRect.TopLeft ());
			pOut1->DrawLine(Point(aRect.Right(),yo),aRect.TopRight());
			pOut1->DrawLine(aRect.TopLeft (),Point(aRect.Left (),yu));
			pOut1->DrawLine(aRect.TopRight(),Point(aRect.Right(),yu));
		} 
		else 
		{
			pOut1->SetFillColor( aFillColor );

			if (bEllipse)
				pOut1->DrawEllipse(aRect);
			else
			{
				if (pOut1->GetOutDevType() == OUTDEV_WINDOW)
				{
					((Window*) pOut1)->InvertTracking(aRect, SHOWTRACK_OBJECT | SHOWTRACK_WINDOW);
				}
				else
				{
					pOut1->DrawRect(aRect);
				}
			}
		}
	}
	if (pPoly!=NULL) 
	{
		pOut1->SetLineColor( aLineColor );
	
		if (bPolyLine)
			pOut1->DrawPolyLine(*pPoly);
		else 
		{
			pOut1->SetFillColor( aFillColor );

			if (pOut1->GetOutDevType() == OUTDEV_WINDOW)
			{
				((Window*) pOut1)->InvertTracking(*pPoly, SHOWTRACK_WINDOW);
			}
			else
			{
				pOut1->DrawPolygon(*pPoly);
			}
		}
	}
	if (pPolyPoly!=NULL) 
	{
		pOut1->SetLineColor( aLineColor);
	
		if (bPolyLine) 
		{
			USHORT nAnz=pPolyPoly->Count();
			for (USHORT nNum=0; nNum<nAnz; nNum++)
				pOut1->DrawPolyLine((*pPolyPoly)[nNum]);
		} 
		else 
		{
			pOut1->SetFillColor( aFillColor );
			pOut1->DrawPolyPolygon(*pPolyPoly);
		}
	}
	if ((pXPoly!=NULL || pXPolyPoly!=NULL) && pView!=NULL) 
	{
		ExtOutputDevice* pXOut=pView->pXOut;
		pXOut->SetOutDev(pOut1);

		pXOut->OverrideLineColor( aLineColor);
	
		if (pXPoly!=NULL) 
		{
			if (bPolyLine) 
				pXOut->DrawXPolyLine(*pXPoly);
			else 
			{
				pXOut->OverrideFillColor( aFillColor );

				if (pOut1->GetOutDevType() == OUTDEV_WINDOW)
				{
					const Polygon aPolygon( XOutCreatePolygon(*pXPoly, pOut1) );
					((Window*) pOut1)->InvertTracking(aPolygon, SHOWTRACK_WINDOW);
				}
				else
				{
					pXOut->DrawXPolygon(*pXPoly);
				}
			}
		}
		if (pXPolyPoly!=NULL) 
		{
			if (bPolyLine) 
			{
				USHORT nAnz=pXPolyPoly->Count();
				for (USHORT nNum=0; nNum<nAnz; nNum++)
				{
					if (pOut1->GetOutDevType() == OUTDEV_WINDOW)
					{
						const Polygon aPolygon( XOutCreatePolygon((*pXPolyPoly)[nNum], pOut1) );
						((Window*) pOut1)->InvertTracking(aPolygon, SHOWTRACK_WINDOW);
					}
					else
					{
						pXOut->DrawXPolyLine((*pXPolyPoly)[nNum]);
					}
				}
			} 
			else 
			{
				pXOut->OverrideFillColor( aFillColor );
				pXOut->DrawXPolyPolygon(*pXPolyPoly);
			}
		}
	}
	if (!bNoSaveDC) 
	{
		pOut1->SetLineColor( aLineColorMerk );
	
		if ( aFillColorMerk != pOut1->GetFillColor() )  
			pOut1->SetFillColor( aFillColorMerk );
	}
	pOut1->SetRasterOp(eRop0);
	pOut1->EnableMapMode(bMap0);
}

FASTBOOL SdrViewUserMarker::IncAnimateCounters()
{
	if (nAnimateDelayCountDown>0) {
		nAnimateDelayCountDown--;
	} else {
		if (nAnimateSpeedCountDown>0) {
			nAnimateSpeedCountDown--;
		} else {
			nAnimateSpeedCountDown=nAnimateSpeed; // SpeedCounter zurueksetzen
			if (nAnimateNum==0 && bAnimateBwd) {
				if (bAnimateToggle) {
					bAnimateBwd=FALSE;
					nAnimateNum++;
				} else {
					nAnimateNum=nAnimateAnz-1;
				}
			} else if (nAnimateNum>=nAnimateAnz-1 && !bAnimateBwd) {
				if (bAnimateToggle) {
					bAnimateBwd=TRUE;
					nAnimateNum--;
				} else {
					nAnimateNum=0;
				}
			} else if (bAnimateBwd) {
				nAnimateNum--;
			} else {
				nAnimateNum++;
			}
			return TRUE;
		}
	}
	return FALSE;
}

void SdrViewUserMarker::DoAnimateOneStep()
{
	USHORT nMerk1=nAnimateNum;
	if (bVisible && IncAnimateCounters()) {
		USHORT nMerk2=nAnimateNum;
		nAnimateNum=nMerk1;
		ImpDraw(TRUE,FALSE);
		nAnimateNum=nMerk2;
		ImpDraw(FALSE,FALSE);
	}
}

FASTBOOL SdrViewUserMarker::IsHit(const Point& rPnt, short nTol) const
{
	return FALSE;
}

Pointer SdrViewUserMarker::GetPointer() const
{
	return Pointer(POINTER_ARROW);
}

