/*************************************************************************
 *
 *  $RCSfile: outltest.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdlib.h>
#include <svgen.hxx>
#include <svdlg.hxx>
#include <svctrl2.hxx>
#include <svsound.hxx>
#include <tlstream.hxx>
#include <editdll.hxx>

#define ITEMID_FONT 			0
#define ITEMID_POSTURE			0
#define ITEMID_WEIGHT			0
#define ITEMID_SHADOWED			0
#define ITEMID_CONTOUR			0
#define ITEMID_CROSSEDOUT		0
#define ITEMID_UNDERLINE		0
#define ITEMID_FONTHEIGHT		0
#define ITEMID_FONTWIDTH 		0
#define ITEMID_COLOR 			0
#define ITEMID_ADJUST			0
#define ITEMID_LINESPACING		0
#define ITEMID_TABSTOP			0
#define ITEMID_LRSPACE			0
#define ITEMID_ULSPACE			0
#define ITEMID_AUTOKERN			0
#define ITEMID_KERNING			0
#define ITEMID_ESCAPEMENT		0
#define ITEMID_WORDLINEMODE		0
#define ITEMID_FIELD 			0
#include <bulitem.hxx>
#include <textitem.hxx>
#include <paraitem.hxx>
#include <frmitems.hxx>
#include <svxfont.hxx>
#include <editeng.hxx>
#include <editdata.hxx>
#include <outliner.hxx>
#include <outl2.hxx>
#include <outltest.hrc>

#ifndef MAC
#define BINFILTER "*.bin"
#define RTFFILTER "*.rtf"
#define TXTFILTER "*.txt"
#else
#define BINFILTER "bin"
#define RTFFILTER "rtf"
#define TXTFILTER "txt"
#endif


#define STAT_PARAS	1
#define STAT_PAGES	2

#define STYLE_REQ 		0x0001
#define REMOVE_PAGES    0x0002
#define INDENT_PAGES 	0x0004
#define INSERT_PARA 	0x0008
#define REMOVE_PARA 	0x0010

static ULONG GetHumanReadableErrcode( ULONG nSfxErr )
{
	ULONG nHuman = nSfxErr;
	nHuman &= ~(ERRCODE_CLASS_MASK);
	nHuman &= ~(ERRCODE_AREA_IO);
	return nHuman;
}

// --- class OutlinerApp -------------------------------------------------

class OutlinerApp : public Application
{
public:
	virtual void Main( int, char*[] );
};

// --- class AppWindow --------------------------------------------

class OutlinerWindow : public Window
{
private:
	Outliner		aOutliner;
	OutlinerView*	pOutlinerView;
	USHORT			nNotifyMask;

	void	ShowInfo();
	void	CheckNumbering( Outliner& rOutl, OutlinerView* pView );
	virtual void Command( const CommandEvent& rCEvt );
	DECL_LINK( IndentingPages, OutlinerView * );
	DECL_LINK( RemovingPages, OutlinerView * );
	DECL_LINK( StyleRequestHdl, StyleRequestData * );
	DECL_LINK( PortionsHdl, DrawPortionInfo* );

	String GetFileName( String aMask, String aTitle, BOOL bOpen );

protected:
	void 	Paint( const Rectangle& );
	void	Resize();
	void	KeyInput( const KeyEvent& rKeyEvt );
	void	MouseMove( const MouseEvent& rMEvt );
	void	MouseButtonDown( const MouseEvent& rMEvt );
	void	MouseButtonUp( const MouseEvent& rMEvt );
	BOOL	QueryDrop( const DropEvent& );
	BOOL	Drop( const DropEvent& );

public:
					OutlinerWindow( Window* pParent );
					~OutlinerWindow();

	Outliner& 		GetOutliner() 		{ return aOutliner; }
	OutlinerView*	GetOutlinerView() 	{ return pOutlinerView; }


	void FileOpen( BOOL bAdd = FALSE );
	void Read(USHORT nFormat);
	void FileSave();
	void SaveSelection();
	void SetText( const String&);
	void Undo();
	void Redo();
	void Cut();
	void Copy();
	void Paste();
	void Clear();
	void ClearAndAdd();
	void ToOutlineMode( BOOL bOutl );
	void SetScale( double, double );
	void SetOrigin( long, long );
	void ToggleUndo();
	void Left();
	void Right();
	void Up();
	void Down();
	String GetUndoText();
	String GetRedoText();
	void ToggleNotify( USHORT nMask );
	USHORT GetNotifyMask() const { return nNotifyMask; }
	void CollapseAll() {pOutlinerView->CollapseAll(); }
	void ExpandAll() { pOutlinerView->ExpandAll(); }
	void ToggleAttr();
};

OutlinerWindow::~OutlinerWindow()
{
	delete pOutlinerView;
}

void __EXPORT OutlinerWindow::Command( const CommandEvent& rCEvt )
{
	pOutlinerView->Command( rCEvt );
}

OutlinerWindow::OutlinerWindow( Window* pParent ) :
	Window( pParent, WB_SVLOOK | WB_CLIPCHILDREN ),
	aOutliner( OL_ADJUSTLEFT )
{
	nNotifyMask = 0;
	Color aColor(COL_WHITE);
	Brush aBrush( aColor );
	SetBackgroundBrush( aBrush );

	MapMode aMapMode( GetMapMode());
	aMapMode.SetMapUnit( MAP_100TH_MM );
	SetMapMode( aMapMode );
	aOutliner.SetRefMapMode( aMapMode );
	aOutliner.EnableUndo( FALSE );
	pOutlinerView = new OutlinerView( &aOutliner, this );
	pOutlinerView->SetBackgroundBrush( aBrush );
	aOutliner.SetRemovingPagesHdl( LINK(this,OutlinerWindow,RemovingPages));
	aOutliner.SetIndentingPagesHdl( LINK(this,OutlinerWindow,IndentingPages));
	aOutliner.SetStyleRequestHdl( LINK(this,OutlinerWindow,StyleRequestHdl));
	aOutliner.SetDrawPortionHdl( LINK(this,OutlinerWindow,PortionsHdl));
	aOutliner.InsertView( pOutlinerView, LIST_APPEND );
	pOutlinerView->ShowCursor();
}

void __EXPORT OutlinerWindow::Resize()
{
	Point aPoint;
	Size aSize( GetOutputSizePixel() );
	aSize = PixelToLogic( aSize );
	pOutlinerView->SetOutputArea( Rectangle(aPoint,aSize) );
}

void OutlinerWindow::ToggleAttr()
{
	OutlinerBits nStyle = aOutliner.GetStyle();
	if( nStyle & OL_NOATTRS )
		nStyle &= (~OL_NOATTRS);
	else
		nStyle |= OL_NOATTRS;
	aOutliner.SetStyle( nStyle );
}

IMPL_LINK( OutlinerWindow, PortionsHdl, DrawPortionInfo*, pInfo )
{
	String aInfoStr( "Abs/Ind:\t" );
	aInfoStr += pInfo->nPara;
	aInfoStr += '/';
	aInfoStr += pInfo->nIndex;
	aInfoStr += "\nPos:\t";
	aInfoStr += pInfo->rStartPos.X();
	aInfoStr += ',';
	aInfoStr += pInfo->rStartPos.Y();
	aInfoStr += "\n\nFont:\t";
	aInfoStr += pInfo->rFont.GetName();
	aInfoStr += "\n\t";
	aInfoStr += pInfo->rFont.GetSize().Height();
	aInfoStr += "\n\nText:\t";
	aInfoStr += pInfo->rText;
	aInfoStr += "\n\nArray:\t";
	for ( USHORT n = 0; n < pInfo->rText.Len(); n++ )
	{
		aInfoStr += pInfo->pDXArray[n];
		if ( n < pInfo->rText.Len()-1 )
			aInfoStr += ',';
		if ( ((n+1) % 8) == 0 )
			aInfoStr += "\n\t";
	}
	InfoBox aInfoBox( this, aInfoStr );
	aInfoBox.SetText( "Portion-Info" );
	aInfoBox.Execute();
	return 0;
}

IMPL_LINK( OutlinerWindow, IndentingPages, OutlinerView *, EMPTYARG )
{
	if( nNotifyMask & INDENT_PAGES )
	{
		String aStr("Indenting pages from ");
		aStr += aOutliner.GetFirstSelPage();
		aStr += " page count:";
		aStr += aOutliner.GetSelPageCount();
		InfoBox(this,aStr).Execute();
	}
	return 1;
}

IMPL_LINK( OutlinerWindow, RemovingPages, OutlinerView *, EMPTYARG )
{
	if( nNotifyMask & REMOVE_PAGES )
	{
		String aStr("Removing pages from ");
		aStr += aOutliner.GetFirstSelPage();
		aStr += " page count:";
		aStr += aOutliner.GetSelPageCount();
		InfoBox(this,aStr).Execute();
	}
	return 1;
}

IMPL_LINK( OutlinerWindow, StyleRequestHdl, StyleRequestData *, pReq )
{
	if( nNotifyMask & STYLE_REQ )
	{
		String aStr("Style request para ");
		aStr += pReq->nPara;
		aStr += " for depth ";
		aStr += pReq->nDepth;
		InfoBox( this, aStr ).Execute();
	}
	return 0;
}

void OutlinerWindow::ToggleNotify( USHORT nMask )
{
	if( nNotifyMask & nMask )
		nNotifyMask &= (~nMask);
	else
		nNotifyMask |= nMask;
}


String OutlinerWindow::GetUndoText()
{
	SfxUndoManager&	rMgr = aOutliner.GetUndoManager();
	String aStr;
	if( rMgr.GetUndoActionCount() )
		aStr = rMgr.GetUndoActionComment();
	else
		aStr = "Nada";
	return aStr;
}

String OutlinerWindow::GetRedoText()
{
	SfxUndoManager&	rMgr = aOutliner.GetUndoManager();
	String aStr;
	if( rMgr.GetRedoActionCount() )
		aStr = rMgr.GetRedoActionComment();
	else
		aStr = "Nada";
	return aStr;
}


void OutlinerWindow::CheckNumbering( Outliner& rOutl, OutlinerView* pView )
{
	rOutl.Clear();
	SfxItemSet aSet( rOutl.GetParaAttribs(0) );
	Font aFont;
	SvxBulletItem* pItem = new SvxBulletItem( BS_123, aFont, 1,
		EE_PARA_BULLET );
	aSet.Put( *pItem );
//	pView->SetAttribs( aSet );
	rOutl.SetParaAttribs( 0, aSet );
}


void __EXPORT OutlinerWindow::Paint( const Rectangle& rRec )
{
	pOutlinerView->Paint( rRec );
}

void OutlinerWindow::FileOpen( BOOL bAdd )
{
	String aFileName( GetFileName(BINFILTER,"ffnen/Anhngen", TRUE));
	if( aFileName.Len())
	{
		SvFileStream aFile( aFileName, STREAM_READ );
		if( !aFile.GetError() )
		{
			OutlinerParaObject* pPObj = OutlinerParaObject::Create(aFile);
			if( !bAdd )
				aOutliner.SetText( *pPObj );
			else
				aOutliner.AddText( *pPObj );
			delete pPObj;
		}
		else
			InfoBox(this,"Cannot open").Execute();
	}
}

void OutlinerWindow::Read( USHORT nFormat )
{
	String aMask;
	if( nFormat == EE_FORMAT_RTF )
		aMask = RTFFILTER;
	else
		aMask = TXTFILTER;
	String aFileName( GetFileName(aMask,"Import",TRUE));
	if( aFileName.Len())
	{
		SvFileStream aFile( aFileName, STREAM_READ );
		if( !aFile.GetError() )
		{
			ULONG nRet = aOutliner.Read( aFile, nFormat );
			if( !nRet )
				InfoBox(this,"Cannot import").Execute();
		}
		else
			InfoBox(this,"Cannot open").Execute();
	}
}

void OutlinerWindow::FileSave()
{
	String aFileName( GetFileName(BINFILTER,"Speichern",FALSE));
	if( aFileName.Len())
	{
		SvFileStream aFile(aFileName,STREAM_WRITE|STREAM_TRUNC);
		OutlinerParaObject* pPObj = aOutliner.CreateParaObject(
			aOutliner.First(), aOutliner.GetParagraphCount() );
		pPObj->Store( aFile );
		delete pPObj;
		if( aFile.GetError() )
		{
			ULONG nSfxErr = aFile.GetErrorCode();
			ULONG nHuman = GetHumanReadableErrcode( nSfxErr );
			// InfoBox(this,"Failed!").Execute();
		}
	}
}

void OutlinerWindow::SaveSelection()
{
	ESelection aSel = pOutlinerView->GetSelection();
	aSel.Adjust();
	if( aSel.nStartPara != aSel.nEndPara )
	{
		String aFileName( GetFileName(BINFILTER,"Selektion speichern",FALSE));
		if( aFileName.Len())
		{
			SvFileStream aFile(aFileName,STREAM_WRITE|STREAM_TRUNC);
			Paragraph* pFirst = aOutliner.GetParagraph( aSel.nStartPara );
			ULONG nCount = aSel.nEndPara- aSel.nStartPara + 1;
			OutlinerParaObject* pPObj= aOutliner.CreateParaObject(pFirst,nCount);
			pPObj->Store( aFile );
			delete pPObj;
			// if( aFile.GetError() )
			//	InfoBox(this,"Failed!").Execute();
		}

	}
}

void OutlinerWindow::SetText( const String& rText )
{
	aOutliner.Clear();
	aOutliner.SetText( rText, aOutliner.First() );
}

void OutlinerWindow::ToggleUndo()
{
	if( aOutliner.IsUndoEnabled() )
		aOutliner.EnableUndo( FALSE );
	else
		aOutliner.EnableUndo( TRUE );
}

void OutlinerWindow::Undo()
{
	pOutlinerView->Undo();
}

void OutlinerWindow::Redo()
{
	pOutlinerView->Redo();
}

void OutlinerWindow::Cut()
{
	pOutlinerView->Cut();
}

void OutlinerWindow::Copy()
{
	pOutlinerView->Copy();
}

void OutlinerWindow::Paste()
{
	pOutlinerView->Paste();
}

void OutlinerWindow::Clear()
{
	aOutliner.Clear();
}

void OutlinerWindow::ClearAndAdd()
{
	aOutliner.Clear();
	SvFileStream aFile( "d:\\test.bin", STREAM_READ );
	if( !aFile.GetError() )
	{
		OutlinerParaObject* pPObj = OutlinerParaObject::Create(aFile);
		aOutliner.AddText( *pPObj );
	}
}


void OutlinerWindow::ToOutlineMode( BOOL bOutl )
{
	aOutliner.Clear();
	if( bOutl )
		aOutliner.SetStyle( 0 );
	else
		aOutliner.SetStyle( OL_EDITENGINE );
}

void OutlinerWindow::SetScale( double nX, double nY)
{
	MapMode aMapMode( GetMapMode() );
	aMapMode.SetScaleX(  Fraction( nX ));
	aMapMode.SetScaleY(  Fraction( nY ));
	SetMapMode( aMapMode );
	Invalidate();
}

void OutlinerWindow::SetOrigin( long nX, long nY )
{
	MapMode aMapMode( GetMapMode() );
	aMapMode.SetOrigin( Point( nX,nY ) );
	SetMapMode( aMapMode );
	Invalidate();
}

String OutlinerWindow::GetFileName( String aMask, String aTitle, BOOL bOpen )
{
	String aPath;
	WinBits nBits = WB_SVLOOK | WB_STDMODAL;
	if( bOpen )
		nBits |= WB_OPEN;
	FileDialog aFileDlg( this, nBits );
	aFileDlg.SetText( aTitle );
	aFileDlg.AddFilter( aMask, aMask );
	if( aFileDlg.Execute() )
		aPath = aFileDlg.GetPath();
	return aPath;
}

void OutlinerWindow::Left()
{
	pOutlinerView->AdjustDepth( -1 );
}

void OutlinerWindow::Right()
{
	pOutlinerView->AdjustDepth( 1 );
}

void OutlinerWindow::Up()
{
	pOutlinerView->AdjustHeight( -1 );
}

void OutlinerWindow::Down()
{
	pOutlinerView->AdjustHeight( 1 );
}

void __EXPORT OutlinerWindow::KeyInput( const KeyEvent& rKEvt )
{
	SvFileStream* pFile;
	OutlinerParaObject* pPObj;
	Paragraph* pPara;

	switch ( rKEvt.GetKeyCode().GetCode() )
	{
		case KEY_F5:
			{
			SfxItemSet aItemSet( aOutliner.GetEmptyItemSet() );
			SvxPostureItem aItalic( ITALIC_NONE, EE_CHAR_ITALIC);
			// aItalic.SetPosture( ITALIC_NORMAL );
			aItemSet.Put( aItalic );
			pOutlinerView->SetAttribs( aItemSet );
			}
			break;

		case KEY_F7:
			{
			pFile=new SvFileStream("d:\\test.bin",STREAM_WRITE|STREAM_TRUNC);
			String aStr( aOutliner.GetText(	aOutliner.First(),
				aOutliner.GetParagraphCount() ));
			pFile->WriteLine( aStr );
			delete pFile;
			}
			Sound::Beep();
			break;

		case KEY_F8:
			{
			SfxItemSet aSet( aOutliner.GetEmptyItemSet() );
			Font aFont;
			aFont.SetAlign( ALIGN_BOTTOM );
			aFont.SetFamily(FAMILY_ROMAN );
			aFont.SetName( "Times New Roman" );
			SvxBulletItem* pItem = new SvxBulletItem( BS_123, aFont, 1,
				EE_PARA_BULLET );
			pItem->SetScale( 100 );
			aSet.Put( *pItem );
			pOutlinerView->SetAttribs( aSet );
			}
			break;

		case KEY_F9:
			{
			SfxItemSet aSet( aOutliner.GetParaAttribs(0) );
			const SvxBulletItem& rBullet = (const SvxBulletItem&)aSet.Get( EE_PARA_BULLET );
			SvxBulletItem aItem( rBullet );
			aItem.SetScale( 50 );
			aSet.Put( aItem );
			aOutliner.SetParaAttribs( 0, aSet );
			}
			break;

		default:
		{
			if ( ( rKEvt.GetKeyCode().GetCode() == KEY_A) && rKEvt.GetKeyCode().IsMod2() )
			{
				SfxItemSet aCurSet = pOutlinerView->GetAttribs();
				XubString aDebStr( "Attribute in Selektion:" );
				aDebStr += "\nVorlage:";
				XubString aStyle; SfxStyleFamily eFam;
				pOutlinerView->GetStyleSheet( aStyle, eFam );
				aDebStr += aStyle;
				for ( USHORT nWhich = EE_ITEMS_START; nWhich <= EE_ITEMS_END; nWhich++)
				{
					SfxItemState eState = aCurSet.GetItemState( nWhich );
					aDebStr += "\n";
					aDebStr += nWhich;
					aDebStr += "\t";
					if ( eState == SFX_ITEM_OFF )
						aDebStr += "---";
					else if ( eState == SFX_ITEM_DONTCARE )
					{
						aDebStr += "DONT CARE";
						if ( nWhich == EE_PARA_BULLET )
						{
							aDebStr += ", ValidMask: ";
							const SfxPoolItem& rItem = aCurSet.Get( nWhich );
							aDebStr += ((SvxBulletItem&)rItem).GetValidMask();
						}
					}
					else if ( eState == SFX_ITEM_ON )
					{
						const SfxPoolItem& rItem = aCurSet.Get( nWhich );
						switch ( nWhich )
						{
							case EE_PARA_BULLET:
								aDebStr += "ValidMask: ";
								aDebStr += ((SvxBulletItem&)rItem).GetValidMask();
							break;
							case EE_PARA_LRSPACE:
								aDebStr += "FI=";
								aDebStr += ((SvxLRSpaceItem&)rItem).GetTxtFirstLineOfst();
								aDebStr += ", LI=";
								aDebStr += ((SvxLRSpaceItem&)rItem).GetTxtLeft();
								aDebStr += ", RI=";
								aDebStr += ((SvxLRSpaceItem&)rItem).GetRight();
							break;
							case EE_PARA_ULSPACE:
								aDebStr += "SB=";
								aDebStr += ((SvxULSpaceItem&)rItem).GetUpper();
								aDebStr += ", SA=";
								aDebStr += ((SvxULSpaceItem&)rItem).GetLower();
							break;
							case EE_PARA_SBL:
								aDebStr += "SBL=";
								aDebStr += ((SvxLineSpacingItem&)rItem).GetInterLineSpace();
							break;
							case EE_PARA_JUST:
								aDebStr += "SvxAdust=";
								aDebStr += (USHORT)((SvxAdjustItem&)rItem).GetAdjust();
							break;
							case EE_PARA_TABS:
								aDebStr += "Tabs = ?";
							break;
							case EE_CHAR_COLOR:
							{
								aDebStr += "Color= ";
								Color aColor( ((SvxColorItem&)rItem).GetValue() );
								aDebStr += aColor.GetRed();
								aDebStr += ", ";
								aDebStr += aColor.GetGreen();
								aDebStr += ", ";
								aDebStr += aColor.GetBlue();
							}
							break;
							case EE_CHAR_FONTINFO:
								aDebStr += "Font=";
								aDebStr += ((SvxFontItem&)rItem).GetFamilyName();
							break;
							case EE_CHAR_FONTHEIGHT:
								aDebStr += "Groesse=";
								aDebStr += ((SvxFontHeightItem&)rItem).GetHeight();
							break;
							case EE_CHAR_WEIGHT:
								aDebStr += "FontWeight=";
								aDebStr += (USHORT)((SvxWeightItem&)rItem).GetWeight();
							break;
							case EE_CHAR_UNDERLINE:
								aDebStr += "FontUnderline=";
								aDebStr += (USHORT)((SvxUnderlineItem&)rItem).GetUnderline();
							break;
							case EE_CHAR_WLM:
								aDebStr += "WordLineMode=";
								aDebStr += (USHORT)((SvxWordLineModeItem&)rItem).GetValue();
							break;
							case EE_CHAR_STRIKEOUT:
								aDebStr += "FontStrikeout=";
								aDebStr += (USHORT)((SvxCrossedOutItem&)rItem).GetStrikeout();
							break;
							case EE_CHAR_ITALIC:
								aDebStr += "FontPosture=";
								aDebStr += (USHORT)((SvxPostureItem&)rItem).GetPosture();
							break;
							case EE_CHAR_OUTLINE:
								aDebStr += "FontOutline=";
								aDebStr += (USHORT)((SvxContourItem&)rItem).GetValue();
							break;
							case EE_CHAR_SHADOW:
								aDebStr += "FontShadowed=";
								aDebStr += (USHORT)((SvxShadowedItem&)rItem).GetValue();
							break;
							default:
								aDebStr += "ON";
							break;
						}
					}
					else
						aDebStr += "?";
				}
				InfoBox( 0, aDebStr ).Execute();

			}
			if ( pOutlinerView->PostKeyEvent( rKEvt ) == FALSE )
				Window::KeyInput( rKEvt );
		}
	}
}

void __EXPORT OutlinerWindow::MouseMove( const MouseEvent& rMEvt )
{
	pOutlinerView->MouseMove( rMEvt );
}

void __EXPORT OutlinerWindow::MouseButtonDown( const MouseEvent& rMEvt )
{
	GrabFocus();
	pOutlinerView->MouseButtonDown( rMEvt );
}

void __EXPORT OutlinerWindow::MouseButtonUp( const MouseEvent& rMEvt )
{
	pOutlinerView->MouseButtonUp( rMEvt );
}

BOOL __EXPORT OutlinerWindow::QueryDrop( const DropEvent& rDEvt )
{
	return pOutlinerView->QueryDrop( (DropEvent(rDEvt)) );
}

BOOL __EXPORT OutlinerWindow::Drop( const DropEvent& rDEvt )
{
	return pOutlinerView->Drop( rDEvt );
}

void OutlinerWindow::ShowInfo()
{
	String aStr("Absaetze:");
	aStr += aOutliner.GetParagraphCount();
	InfoBox( this, aStr ).Execute();
}

class AppWindow : public WorkWindow
{
	StatusBar aStatusBar;
	OutlinerWindow aOutlinerWindow;
	USHORT nParas;
	USHORT nPages;

	DECL_LINK( ParaInserted, Outliner * );
	DECL_LINK( ParaRemoving, Outliner * );
	void SetStatusBar();

	virtual void Resize();
public:
	DECL_LINK( SelectHdl, Menu * );
	DECL_LINK( ActivateHdl, Menu * );
	AppWindow();
	~AppWindow();
};

AppWindow::AppWindow() :
	WorkWindow( NULL, WB_APP | WB_STDWORK | WB_SVLOOK | WB_CLIPCHILDREN ),
	aOutlinerWindow( this ),
	aStatusBar( this )
{
	pApp->EnableSVLook();
	nParas = 1;
	nPages = 1;

	aOutlinerWindow.GetOutliner().SetParaInsertedHdl( LINK(this,AppWindow,ParaInserted));
	aOutlinerWindow.GetOutliner().SetParaRemovingHdl( LINK(this,AppWindow,ParaRemoving));

	Color aColor(COL_RED);
	Brush aBrush( aColor );
	SetBackgroundBrush( aBrush );
	SetText( "Outliner-Test-Application" );
	SetPosSizePixel( Point(10,10), Size(400,300) );

	aStatusBar.InsertItem( STAT_PARAS, 60 );
	aStatusBar.InsertItem( STAT_PAGES, 60 );
	aStatusBar.ShowItem( STAT_PARAS );
	aStatusBar.ShowItem( STAT_PAGES );
	SetStatusBar();

	aStatusBar.Show();
	aOutlinerWindow.Show();
	Show();
}

AppWindow::~AppWindow()
{
}


void AppWindow::SetStatusBar()
{
	String aStr( "Paras:" );
	aStr += nParas;
	aStatusBar.SetItemText( STAT_PARAS, aStr );

	aStr = "Pages:";
	aStr += nPages;
	aStatusBar.SetItemText( STAT_PAGES, aStr );
}

IMPL_LINK_INLINE_START( AppWindow, ParaInserted, Outliner *, pOutl )
{
	if( aOutlinerWindow.GetNotifyMask() & INSERT_PARA )
		InfoBox( this, "Paragraph inserted").Execute();
	nParas++;
	SetStatusBar();
	return 0;
}
IMPL_LINK_INLINE_END( AppWindow, ParaInserted, Outliner *, pOutl )

IMPL_LINK_INLINE_START( AppWindow, ParaRemoving, Outliner *, EMPTYARG )
{
	if( aOutlinerWindow.GetNotifyMask() & REMOVE_PARA )
		InfoBox( this, "Removing paragraph").Execute();
	nParas--;
	SetStatusBar();
	return 0;
}
IMPL_LINK_INLINE_END( AppWindow, ParaRemoving, Outliner *, EMPTYARG )

void __EXPORT AppWindow::Resize()
{
	Point aPos;
	Size aSize( GetOutputSizePixel());
	Size aStatSize( aStatusBar.GetOutputSizePixel() );
	aStatSize.Width() = aSize.Width();
	aPos.Y() = aSize.Height()- aStatSize.Height();
	aStatusBar.SetPosSizePixel( aPos, aStatSize );

	aSize.Width() -= 20;
	aSize.Height() -= aStatSize.Height();
	aSize.Height() -= 20;
	aPos.X() = 10; aPos.Y() = 10;
	aOutlinerWindow.SetPosSizePixel( aPos, aSize );
}



IMPL_LINK( AppWindow, SelectHdl, Menu *, pMenu )
{
	switch ( pMenu->GetCurItemId() )
	{
		case MID_EXIT:
			pApp->Quit();
			break;

		case MID_FILEOPEN:
			aOutlinerWindow.FileOpen();
			nParas = aOutlinerWindow.GetOutliner().GetParagraphCount();
			nPages = 1;
			SetStatusBar();
			break;

		case MID_FILESAVE:
			aOutlinerWindow.FileSave();
			break;

		case MID_UNDO:
			aOutlinerWindow.Undo();
			nParas = aOutlinerWindow.GetOutliner().GetParagraphCount();
			break;

		case MID_REDO:
			aOutlinerWindow.Redo();
			nParas = aOutlinerWindow.GetOutliner().GetParagraphCount();
			break;

		case MID_CUT:
			aOutlinerWindow.Cut();
			break;

		case MID_COPY:
			aOutlinerWindow.Copy();
			break;

		case MID_PASTE:
			aOutlinerWindow.Paste();
			break;

		case MID_READRTF:
			aOutlinerWindow.Read(EE_FORMAT_RTF);
			break;

		case MID_READASCII:
			aOutlinerWindow.Read(EE_FORMAT_TEXT);
			break;

		case MID_FILEADD:
			aOutlinerWindow.FileOpen(TRUE);
			nParas = aOutlinerWindow.GetOutliner().GetParagraphCount();
			nPages = 1;
			break;

		case MID_CLEAR:
			nParas = 1; nPages = 1;
			SetStatusBar();
			aOutlinerWindow.Clear();
			break;

		case MID_CLR_ADD:
			aOutlinerWindow.ClearAndAdd();
			nParas = aOutlinerWindow.GetOutliner().GetParagraphCount();
			nPages = 1;
			break;

		case MID_OUTLMODE:
			nParas = 1; nPages = 1;
			SetStatusBar();
			aOutlinerWindow.ToOutlineMode( TRUE );
			break;

		case MID_EENGMODE:
			nParas = 1; nPages = 1;
			SetStatusBar();
			aOutlinerWindow.ToOutlineMode( FALSE );
			break;

		case MID_INSERTSTRING:
			aOutlinerWindow.SetText("Seite1\n\tEbene1\n\t\tEbene2\nSeite2");
			break;
		case MID_STRIPPORTIONS:
			aOutlinerWindow.GetOutliner().StripPortions();
			break;

		case MID_SCALE1:
			aOutlinerWindow.SetScale( 1.0,1.0 );
			break;
		case MID_SCALE2:
			aOutlinerWindow.SetScale( 2.0,2.0 );
			break;
		case MID_ORIGIN1:
			aOutlinerWindow.SetOrigin( 0,0 );
			break;
		case MID_ORIGIN2:
			aOutlinerWindow.SetOrigin( 1000, 1000 );
			break;
		case MID_SAVESEL:
			aOutlinerWindow.SaveSelection();
			break;
		case MID_UNDOON:
			aOutlinerWindow.ToggleUndo();
			break;
		case MID_LEFT:
			aOutlinerWindow.Left();
			break;
		case MID_RIGHT:
			aOutlinerWindow.Right();
			break;
		case MID_UP:
			aOutlinerWindow.Up();
			break;
		case MID_DOWN:
			aOutlinerWindow.Down();
			break;
		case MID_NOTIFY_STYLE:
			aOutlinerWindow.ToggleNotify( STYLE_REQ );
			break;
		case MID_NOTIFY_REMPAGES:
			aOutlinerWindow.ToggleNotify( REMOVE_PAGES );
			break;
		case MID_NOTIFY_INDPAGES:
			aOutlinerWindow.ToggleNotify( INDENT_PAGES );
			break;
		case MID_NOTIFY_INSPARA:
			aOutlinerWindow.ToggleNotify( INSERT_PARA );
			break;
		case MID_NOTIFY_REMPARA:
			aOutlinerWindow.ToggleNotify( REMOVE_PARA );
			break;
		case MID_ATTR_COLLAPSEALL:
			aOutlinerWindow.CollapseAll();
			break;
		case MID_ATTR_EXPANDALL:
			aOutlinerWindow.ExpandAll();
			break;
		case MID_ATTR_NO_ATTRS:
			aOutlinerWindow.ToggleAttr();
			break;
		case MID_ATTR_STANDARD:
			aOutlinerWindow.GetOutlinerView()->RemoveAttribs( TRUE );
			break;


	}
	return 0;
}

IMPL_LINK( AppWindow, ActivateHdl, Menu *, pMenu )
{
	String aStr( "Undo:");
	aStr += aOutlinerWindow.GetUndoText();
	pMenu->SetItemText( MID_UNDO, aStr );

	aStr = "Redo:";
	aStr += aOutlinerWindow.GetRedoText();
	pMenu->SetItemText( MID_REDO, aStr );
	return 0;
}

void OutlinerApp::Main( int, char*[] )
{
	MenuBar aMenuBar( ResId( RES_MENU));
	EnableSVLook();
	EditDLL aEditDLL;
	SetAppMenu( &aMenuBar );
	AppWindow aWindow;
	aMenuBar.PushSelectHdl(LINK(&aWindow, AppWindow, SelectHdl));
	PopupMenu* pMenu = aMenuBar.GetPopupMenu( MID_DOC );
	pMenu->PushActivateHdl(LINK(&aWindow,AppWindow,ActivateHdl));
	Execute();
}
OutlinerApp aOutlinerApp;


