/*************************************************************************
 *
 *  $RCSfile: sw3field.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: hr $ $Date: 2003/06/30 15:51:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#include <stdlib.h>

#include <stdio.h>
#include "hintids.hxx"

#ifndef _TOOLS_RESID_HXX
#include <tools/resid.hxx>
#endif
#ifndef _SFXMACITEM_HXX //autogen
#include <svtools/macitem.hxx>
#endif
#ifndef _ZFORLIST_HXX //autogen
#include <svtools/zforlist.hxx>
#endif
#ifndef _ZFORMAT_HXX //autogen
#include <svtools/zformat.hxx>
#endif
#ifndef SVTOOLS_URIHELPER_HXX
#include <svtools/urihelper.hxx>
#endif
#ifndef _LINKMGR_HXX
#include <so3/linkmgr.hxx>
#endif

#ifndef _SVSTDARR_USHORTS_DECL
#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>
#endif

#ifndef _FMTINFMT_HXX //autogen
#include <fmtinfmt.hxx>
#endif
#ifndef _FMTFLD_HXX //autogen
#include <fmtfld.hxx>
#endif

#include "doc.hxx"
#include "docary.hxx"
#include "sw3imp.hxx"
#include "sw3ids.hxx"
#include "fldbas.hxx"
#include "flddat.hxx"
#include "docufld.hxx"
#include "chpfld.hxx"
#include "ddefld.hxx"
#include "expfld.hxx"
#include "reffld.hxx"
#include "usrfld.hxx"
#include "dbfld.hxx"
#include "txtfld.hxx"
#ifndef _AUTHFLD_HXX
#include <authfld.hxx>
#endif
#include "ndtxt.hxx"

#include "poolfmt.hxx"		// fuer InSetExpField
#include "poolfmt.hrc"		// fuer InSetExpField

#if !defined(UNX) && !defined(MSC) && !defined(PPC) && !defined(CSET) && !defined(__MWERKS__) && !defined(WTC)

#define FIELDFNTAB_SIZE 37
#if FIELDFNTAB_SIZE != RES_FIELDS_END - RES_FIELDS_BEGIN
#error Feld-Tabelle ist ungueltigt. Wurden neue Hint-IDs zugefuegt ??
#endif

#endif

#define SWG_AUTHORITY_ENTRY_LCL	'E'

sal_Char __FAR_DATA sSW3IO_FixedField[] = "FixedExport";
sal_Char __FAR_DATA sSW3IO_AuthorityField[] = "AuthorityExport";
/* #108791# */
sal_Char __FAR_DATA sSW3IO_DropDownField[] = "DropDownExport";

struct OldFormats
{
	NfIndexTableOffset	eFormatIdx;
	USHORT				nOldFormat;
};

static OldFormats aOldDateFmt40[] =
{
	// Datumsfelder:
	NF_DATE_SYSTEM_SHORT,			DFF_SSYS,		// Kurzes Systemdatum
	NF_DATE_SYSTEM_LONG,			DFF_LSYS,		// Langes Systemdatum
	NF_DATE_SYS_DDMMYY,				DFF_DMY,        // 06.10.64
	NF_DATE_SYS_DDMMYYYY,			DFF_DMYY,		// 06.10.1964
	NF_DATE_SYS_DMMMYY,				DFF_DMMY,		// 06. Okt 64
	NF_DATE_SYS_DMMMYYYY,			DFF_DMMYY,		// 06. Okt 1964
	NF_DATE_DIN_DMMMMYYYY,			DFF_DMMMYY,		// 06. Oktober 1964
	NF_DATE_DIN_DMMMMYYYY,			DFF_DMMMY,		// 06. Oktober 64
	NF_DATE_SYS_NNDMMMYY,			DFF_DDMMY,		// Di, 06. Okt 64
	NF_DATE_SYS_NNDMMMMYYYY,		DFF_DDMMMY,		// Di, 06. Oktober 64
	NF_DATE_SYS_NNDMMMMYYYY,		DFF_DDMMMYY,	// Di, 06. Oktober 1964
	NF_DATE_SYS_NNNNDMMMMYYYY,		DFF_DDDMMMYY,	// Dienstag, 06. Oktober 1964
	NF_DATE_SYS_NNNNDMMMMYYYY,		DFF_DDDMMMY,	// Dienstag, 06. Oktober 64
	NF_DATE_SYS_MMYY,				DFF_MY,			// 10.64
	NF_DATE_DIN_MMDD,				DFF_MD,			// 10-06
	NF_DATE_DIN_YYMMDD,				DFF_YMD,		// 64-10-06
	NF_DATE_DIN_YYYYMMDD,			DFF_YYMD,		// 1964-10-06

	NF_NUMERIC_START,				0				// Tabellenende
};

static OldFormats aOldDateFmt30[] =
{
	// Datumsfelder:
	NF_DATE_SYSTEM_SHORT,			DFF_SSYS,		// Kurzes Systemdatum
	NF_DATE_SYSTEM_LONG,			DFF_LSYS,		// Langes Systemdatum
	NF_DATE_SYS_DDMMYY,				DFF_DMY,        // 06.10.64
	NF_DATE_SYS_DDMMYYYY,			DFF_DMYY,		// 06.10.1964
	NF_DATE_SYS_DMMMYY,				DFF_DMMY,		// 06. Okt 64
	NF_DATE_SYS_DMMMYYYY,			4 /*DFF_DMMYY*/,	// 06. Okt 1964
	NF_DATE_DIN_DMMMMYYYY,			5 /*DFF_DMMMYY*/,	// 06. Oktober 1964
	NF_DATE_DIN_DMMMMYYYY,			5 /*DFF_DMMMY*/,	// 06. Oktober 64
	NF_DATE_SYS_NNDMMMMYYYY,		6 /*DFF_DDMMMYY*/,	// Di, 06. Oktober 1964
	NF_DATE_SYS_NNDMMMYY,			6 /*DFF_DDMMY*/,	// Di, 06. Okt 64
	NF_DATE_SYS_NNDMMMMYYYY,		6 /*DFF_DDMMMY*/,	// Di, 06. Oktober 64
	NF_DATE_SYS_NNNNDMMMMYYYY,		7 /*DFF_DDDMMMYY*/,	// Dienstag, 06. Oktober 1964
	NF_DATE_SYS_NNNNDMMMMYYYY,		7 /*DFF_DDDMMMY*/,	// Dienstag, 06. Oktober 64
	NF_DATE_SYS_MMYY,				2 /*DFF_MY*/,		// 10.64
	NF_DATE_DIN_MMDD,				DFF_MD,			// 10-06
	NF_DATE_DIN_YYMMDD,				DFF_YMD,		// 64-10-06
	NF_DATE_DIN_YYYYMMDD,			DFF_YYMD,		// 1964-10-06

	NF_NUMERIC_START,				0				// Tabellenende
};

static OldFormats aOldTimeFmt[] =
{
	// Zeitfelder:
	NF_TIME_HHMMSS,					TF_SYSTEM,		// Systemzeit
	NF_TIME_HHMM,					TF_SSMM_24,		// 23:25
	NF_TIME_HHMMAMPM,				TF_SSMM_12,		// 11:25 PM

	NF_NUMERIC_START,				0				// Tabellenende
};

static OldFormats aOldGetSetExpFmt40[] =
{
	NF_TEXT,						VVF_CMD,		// Kommando anzeigen
	NF_TEXT,						VVF_INVISIBLE,	// unsichtbar
	NF_PERCENT_INT,					VVF_XXP,		// 1234%
	NF_PERCENT_DEC2,				VVF_XX_XXP,   	// 1.234,56%
	NF_TEXT,						VVF_CLEAR,		// ???

	NF_NUMBER_SYSTEM,				VVF_SYS, 		// Zahlenformat aus der
													// Systemeinstellung
	NF_NUMBER_INT,					VVF_X,			// 1234
	NF_NUMBER_DEC2,					VVF_X_X,   		// 1234,5
	NF_NUMBER_DEC2,					VVF_X_XX,   	// 1245,56
	NF_NUMBER_1000DEC2,				VVF_XX_XX,   	// 1.234,56
	NF_NUMBER_1000DEC2,				VVF_XX_X,   	// 1.234,5
	NF_NUMBER_1000DEC2,				VVF_XX_XXX,		// 1.234,567
	NF_CURRENCY_1000DEC2,			VVF_SYS_CUR,	// Whrungsformat aus der
													// Systemeinstellung
													// (1.234,00 DM)
	NF_CURRENCY_1000INT,			VVF_X_CUR,		// 1234 DM
	NF_CURRENCY_1000DEC2,			VVF_XX_XX_CUR,  // 1234,56 DM 1234,00 DM
	NF_CURRENCY_1000DEC2_DASHED,	VVF_XX_X0_CUR,  // 1234,56 DM 1234,-- DM
	NF_CURRENCY_1000INT,			VVF_CUR_X,   	// DM 1234
	NF_CURRENCY_1000DEC2,			VVF_CUR_XX_XX,  // DM 1234,56 DM 1234,00
	NF_CURRENCY_1000DEC2_DASHED,	VVF_CUR_XX_X0,  // DM 1234,56 DM 1234,--

	NF_NUMERIC_START, 				0				// Tabellenende
};

static OldFormats aOldGetSetExpFmt30[] =
{
	NF_TEXT,						VVF_CMD,		// Kommando anzeigen
	NF_TEXT,						VVF_INVISIBLE,	// unsichtbar
	NF_PERCENT_INT,					VVF_XXP,		// 1234%
	NF_PERCENT_DEC2,				VVF_XX_XXP,   	// 1.234,56%
	NF_TEXT,						VVF_CLEAR,		// ???

	NF_NUMBER_SYSTEM,				0x0020, 		// Zahlenformat aus der
													// Systemeinstellung
	NF_NUMBER_INT,					0x0080,			// 1234
	NF_NUMBER_1000DEC2,				0x0100,   		// 1.234,56
	NF_NUMBER_DEC2,					0x0100,   		// 1234,5
	NF_NUMBER_DEC2,					0x0100,  		// 1245,56
	NF_NUMBER_1000DEC2,				0x0100,   		// 1.234,5
	NF_NUMBER_1000DEC2,				0x0100,			// 1.234,567
	NF_CURRENCY_1000DEC2,			0x0200,			// Whrungsformat aus der
													// Systemeinstellung
													// (1.234,00 DM)
	NF_CURRENCY_1000INT,			0x1000,			// 1234 DM
	NF_CURRENCY_1000DEC2,			0x1000,  		// 1234,56 DM 1234,00 DM
	NF_CURRENCY_1000DEC2_DASHED,	0x1000,  		// 1234,56 DM 1234,-- DM
	NF_CURRENCY_1000INT,			0x1000,   		// DM 1234
	NF_CURRENCY_1000DEC2,			0x1000,  		// DM 1234,56 DM 1234,00
	NF_CURRENCY_1000DEC2_DASHED,	0x1000, 		// DM 1234,56 DM 1234,--

	NF_NUMERIC_START, 				0				// Tabellenende
};

void sw3io_ConvertFromOldField( SwDoc& rDoc, USHORT& rWhich,
								USHORT& rSubType, ULONG &rFmt,
								USHORT nVersion )
{
	const OldFormats *pOldFmt = 0L;

	switch( rWhich )
	{
		case RES_DATEFLD:
		case RES_FIXDATEFLD:
			if( nVersion < SWG_NEWFIELDS )
			{
				rSubType = DATEFLD;
				if( RES_FIXDATEFLD == rWhich )
					rSubType |= FIXEDFLD;
				rWhich = RES_DATETIMEFLD;
				pOldFmt = nVersion<SWG_INETBROWSER ? aOldDateFmt30
												   : aOldDateFmt40;
			}
			break;

		case RES_TIMEFLD:
		case RES_FIXTIMEFLD:
			if( nVersion < SWG_NEWFIELDS )
			{
				rSubType = TIMEFLD;
				if( RES_FIXTIMEFLD == rWhich )
					rSubType |= FIXEDFLD;
				rWhich = RES_DATETIMEFLD;
				pOldFmt = aOldTimeFmt;
			}
			break;

		case RES_DBFLD:
			if( nVersion < SWG_NEWFIELDS )
			{
				rSubType = SUB_OWN_FMT;
				pOldFmt = nVersion<SWG_INETBROWSER ? aOldGetSetExpFmt30
													: aOldGetSetExpFmt40;
			}
			break;

		case RES_TABLEFLD:
		case RES_GETEXPFLD:
		case RES_SETEXPFLD:
		case RES_USERFLD:
			if( nVersion < SWG_NEWFIELDS )
			{
				if( rFmt == VVF_INVISIBLE )
				{
					rSubType = SUB_INVISIBLE;
					rFmt = 0;
				}
				else if( rFmt == VVF_CMD )
				{
					rSubType = SUB_CMD;
					rFmt = 0;
				}
				else
				{
					// Kleiner Hack: Bei Numernkreisen wird das
					// unkonvertierte Format noch benoetigt. Wir merken es
					// uns voruebergehend mal im Subtyp, sofern es
					// ueberhaupt als entsprechendes Format in Frage kommt.
					if( RES_SETEXPFLD==rWhich &&
						rFmt >= (USHORT)SVX_NUM_CHARS_UPPER_LETTER &&
						rFmt <= (USHORT)SVX_NUM_BITMAP )
					{
						rSubType = (USHORT)rFmt;
					}
					pOldFmt = nVersion<SWG_INETBROWSER ? aOldGetSetExpFmt30
													   : aOldGetSetExpFmt40;
				}
			}
			break;
		case RES_DOCINFOFLD:
			if( nVersion < SWG_NEWFIELDS )
			{
				switch( rFmt )
				{
				case RF_AUTHOR:	rSubType = DI_SUB_AUTHOR;	break;
				case RF_TIME:	rSubType = DI_SUB_TIME;	break;
				case RF_DATE:	rSubType = DI_SUB_DATE;	break;
				case RF_ALL:	rSubType = DI_SUB_DATE;	break;
				}
				rFmt = 0;
			}
			break;
	}

	if( pOldFmt )
	{
		SvNumberFormatter *pFormatter = rDoc.GetNumberFormatter();
		USHORT i = 0;

		while( pOldFmt[i].eFormatIdx != NF_NUMERIC_START ||
			   pOldFmt[i].nOldFormat)
		{
			if( rFmt == pOldFmt[i].nOldFormat )
			{
				rFmt = pFormatter->GetFormatIndex(pOldFmt[i].eFormatIdx, LANGUAGE_SYSTEM);
				break;
			}
			i++;
		}
	}
}

void sw3io_ConvertToOldField( const SwField* pFld, USHORT& rWhich,
							  ULONG& rFmt, ULONG nFFVersion )
{
	const OldFormats *pOldFmt = 0L;
	ULONG nOldFmt = rFmt;

	switch( rWhich )
	{
		case RES_DOCINFOFLD:
			if( SOFFICE_FILEFORMAT_40 >= nFFVersion )
			{
				switch (pFld->GetSubType() & 0xff00)
				{
				case DI_SUB_AUTHOR:	rFmt = RF_AUTHOR;	break;
				case DI_SUB_TIME:	rFmt = RF_TIME;		break;
				case DI_SUB_DATE:	rFmt = RF_DATE;		break;
				}
			}
			break;

		case RES_DATETIMEFLD:
			if( SOFFICE_FILEFORMAT_40 >= nFFVersion )
			{
				USHORT nSubType = ((SwDateTimeField*) pFld)->GetSubType();
				switch( nSubType )
				{
				case DATEFLD:			rWhich = RES_DATEFLD;		break;
				case TIMEFLD:			rWhich = RES_TIMEFLD;		break;
				case DATEFLD|FIXEDFLD: 	rWhich = RES_FIXDATEFLD;	break;
				case TIMEFLD|FIXEDFLD:	rWhich = RES_FIXTIMEFLD;	break;
				}

				if( nSubType & DATEFLD )
				{
					rFmt = DFF_DMY;
					pOldFmt = aOldDateFmt40;
				}
				else
				{
					rFmt = TF_SYSTEM;
					pOldFmt = aOldTimeFmt;
				}
			}
			break;

		case RES_DBFLD:
		case RES_TABLEFLD:
		case RES_GETEXPFLD:
		case RES_SETEXPFLD:
		case RES_USERFLD:
			if( SOFFICE_FILEFORMAT_40 >= nFFVersion )
			{
				USHORT nSubType = pFld->GetSubType();

				if (nSubType & SUB_INVISIBLE)
					rFmt = VVF_INVISIBLE;
				else if (nSubType & SUB_CMD)
					rFmt = VVF_CMD;
				else if( !(GSE_SEQ & nSubType) )
				{
					pOldFmt = aOldGetSetExpFmt40;
					rFmt = VVF_SYS;
				}
			}
			break;

		case RES_GETREFFLD:
			if( SOFFICE_FILEFORMAT_31 == nFFVersion )
			{
				switch( rFmt )
				{
				case REF_PAGE:
				case REF_CHAPTER:
				case REF_CONTENT:
					break;

				default:
				// case REF_UPDOWN:
				// case REF_PAGE_PGDESC:
					rFmt = REF_PAGE;
					break;
				}
			}
			break;
	}

	if( pOldFmt && nOldFmt )
	{
		USHORT i = 0;

		SvNumberFormatter *pFormatter = ((SwValueField*)pFld)->GetDoc()->GetNumberFormatter();
		const SvNumberformat* pEntry = pFormatter->GetEntry( nOldFmt );

		if( pEntry )
		{
			while( pOldFmt[i].eFormatIdx != NF_NUMERIC_START ||
				   pOldFmt[i].nOldFormat )
			{
				ULONG nKey = pFormatter->GetFormatIndex(
							pOldFmt[i].eFormatIdx, pEntry->GetLanguage() );

				if( nOldFmt == nKey )
				{
					rFmt = pOldFmt[i].nOldFormat;
					break;
				}
				i++;
			}
		}
	}
}

void lcl_sw3io_FillSetExpFieldName( Sw3IoImp& rIo, USHORT nStrId,
									String& rName )
{
	USHORT nPoolId = rIo.aStringPool.FindPoolId( nStrId );
	USHORT nResId = USHRT_MAX;
	switch( nPoolId )
	{
	case RES_POOLCOLL_LABEL_ABB:
		nResId = STR_POOLCOLL_LABEL_ABB;
		break;
	case RES_POOLCOLL_LABEL_TABLE:
		nResId = STR_POOLCOLL_LABEL_TABLE;
		break;
	case RES_POOLCOLL_LABEL_FRAME:
		nResId = STR_POOLCOLL_LABEL_FRAME;
		break;
	case RES_POOLCOLL_LABEL_DRAWING:
		nResId = STR_POOLCOLL_LABEL_DRAWING;
		break;
	}
	if( nResId != USHRT_MAX )
		rName = SW_RESSTR( nResId );
	else
		rName = rIo.aStringPool.Find( nStrId );
}

USHORT lcl_sw3io_GetSetExpFieldPoolId( const String& rName )
{
	if( rName == String( SW_RES(STR_POOLCOLL_LABEL_ABB) ) )
		return RES_POOLCOLL_LABEL_ABB;
	else if( rName == String( SW_RES(STR_POOLCOLL_LABEL_TABLE) ) )
		return RES_POOLCOLL_LABEL_TABLE;
	else if( rName == String( SW_RES(STR_POOLCOLL_LABEL_FRAME) ) )
		return RES_POOLCOLL_LABEL_FRAME;
	else if( rName == String( SW_RES(STR_POOLCOLL_LABEL_DRAWING) ) )
		return RES_POOLCOLL_LABEL_DRAWING;
	else
		return USHRT_MAX;
}

/*  */

//////////////////////////////////////////////////////////////////////////////

// Ausgabe der Feldtypen

SwDBFieldType* lcl_sw3io_InDBFieldType( Sw3IoImp& rIo )
{
	String aText, aDBName;

	if( rIo.nVersion < SWG_SHORTFIELDS )
		rIo.InString( *rIo.pStrm, aText );
	else
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;
		aText = rIo.aStringPool.Find( nPoolId );
		if( rIo.IsVersion( SWG_MULTIDB, SWG_EXPORT31, SWG_DESKTOP40 ) )
		{
			*rIo.pStrm >> nPoolId;
			aDBName = rIo.aStringPool.Find( nPoolId );
		}
	}
	if( !aText.Len() && !aDBName.Len() )
	{
		rIo.Warning();
		return NULL;
	}

	SwDBData aData;
	aData.sDataSource = aDBName.GetToken(0, DB_DELIM);
	aData.sCommand = aDBName.GetToken(1, DB_DELIM);
	SwDBFieldType aType( rIo.pDoc, aText, aData );
	return (SwDBFieldType*) rIo.pDoc->InsertFldType( aType );
}

void lcl_sw3io_OutDBFieldType( Sw3IoImp& rIo, SwDBFieldType* pType )
{
	*rIo.pStrm << (UINT16) rIo.aStringPool.Find( pType->GetColumnName(), USHRT_MAX );

	if( !rIo.IsSw31Export() )
	{
		SwDBData aData = pType->GetDBData();
		String sDBName(aData.sDataSource);
		sDBName += DB_DELIM;
		sDBName += (String)aData.sCommand;
		*rIo.pStrm << (UINT16) rIo.aStringPool.Find( sDBName, IDX_NOCONV_FF );
	}
}

/*  */

SwUserFieldType* lcl_sw3io_InUserFieldType40( Sw3IoImp& rIo )
{
	String aName, aContent, aValue;
	UINT16 nType;

	if( rIo.nVersion < SWG_SHORTFIELDS )
		rIo.InString( *rIo.pStrm, aName );
	else
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;
		aName = rIo.aStringPool.Find( nPoolId );
		if( !aName.Len() )
		{
			rIo.Warning();
			return NULL;
		}
	}

	rIo.InString( *rIo.pStrm, aContent );
	rIo.InString( *rIo.pStrm, aValue );
	*rIo.pStrm >> nType;
	SwUserFieldType* p = (SwUserFieldType*) rIo.pDoc->InsertFldType(
											SwUserFieldType( rIo.pDoc, aName ) );
	//JP 07.04.97: beim Einfuegen darf an bestehenden FeldType nichts
	//				veraendert werden
	if( rIo.bInsert && p->GetDepends() )
		return p;

	p->SetContent( aContent );
	sal_Char* dummy;
	ByteString sTmp( aValue, RTL_TEXTENCODING_ASCII_US );
	p->SetValue( strtod( sTmp.GetBuffer(), &dummy ) );
	if( !nType )
		nType = GSE_STRING;
	p->SetType( nType );
	return p;
}

SwUserFieldType* lcl_sw3io_InUserFieldType( Sw3IoImp& rIo )
{
	String aName, aContent;
	double dVal;
	UINT16 nType;

	USHORT nPoolId;
	*rIo.pStrm >> nPoolId;
	aName = rIo.aStringPool.Find( nPoolId );
	if( !aName.Len() )
	{
		rIo.Warning();
		return NULL;
	}

	rIo.InString( *rIo.pStrm, aContent );
	*rIo.pStrm >> dVal >> nType;
	SwUserFieldType* p = (SwUserFieldType*) rIo.pDoc->InsertFldType(
											SwUserFieldType( rIo.pDoc, aName ) );
	//JP 07.04.97: beim Einfuegen darf an bestehenden FeldType nichts
	//				veraendert werden
	if( rIo.bInsert && p->GetDepends() )
		return p;

	p->SetContent( aContent );
	p->SetValue( dVal );
	if( !nType )
		nType = GSE_STRING;
	p->SetType( nType );
	return p;
}

void lcl_sw3io_OutUserFieldType40( Sw3IoImp& rIo, SwUserFieldType* pType )
{
    String aValue(String::CreateFromDouble(pType->GetValue()));
	*rIo.pStrm << (UINT16) rIo.aStringPool.Find( pType->GetName(), USHRT_MAX );
   	rIo.OutString( *rIo.pStrm, pType->GetContent() );
   	rIo.OutString( *rIo.pStrm, aValue );
	*rIo.pStrm << (UINT16) pType->GetType();
}

void lcl_sw3io_OutUserFieldType( Sw3IoImp& rIo, SwUserFieldType* pType )
{
	*rIo.pStrm << (UINT16) rIo.aStringPool.Find( pType->GetName(), USHRT_MAX );
   	rIo.OutString( *rIo.pStrm, pType->GetContent() );
	*rIo.pStrm << (double)pType->GetValue()
			   << (UINT16) pType->GetType();
}

/*  */

SwDDEFieldType* lcl_sw3io_InDDEFieldType( Sw3IoImp& rIo )
{
	UINT16 nType;
	String aName, aCmd;

	*rIo.pStrm >> nType;

	if( rIo.nVersion < SWG_SHORTFIELDS )
		rIo.InString( *rIo.pStrm, aName );
	else
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;
		aName = rIo.aStringPool.Find( nPoolId );
		if( !aName.Len() )
		{
			rIo.Warning();
			return NULL;
		}
	}

	ByteString s8;
	rIo.pStrm->ReadByteString( s8 );
    sal_Char cSrch = rIo.nVersion < SWG_DDESEP ? ' ' : so3::cTokenSeperator;

	{
		// die ersten beiden Blanks gegen den neuen Trenner austauschen
		xub_StrLen nFnd = s8.Search( cSrch );
		aCmd = String( s8, 0, nFnd, rIo.eSrcSet );
		if( STRING_NOTFOUND != nFnd++ )
		{
			xub_StrLen nFnd2 = s8.Search( cSrch, nFnd );
            ( aCmd += so3::cTokenSeperator) +=
				String( s8, nFnd, nFnd2 - nFnd, rIo.eSrcSet );
			if( STRING_NOTFOUND != nFnd2++ )
                ( aCmd += so3::cTokenSeperator) +=
					String( s8, nFnd2, aCmd.Len() - nFnd2, rIo.eSrcSet );
		}
	}

	// JP 15.08.00: our dialog have set the wrong format id's
    if( so3::LINKUPDATE_ALWAYS != nType && so3::LINKUPDATE_ONCALL != nType )
        nType = so3::LINKUPDATE_ONCALL;

	SwDDEFieldType aType( aName, aCmd, nType );
	return (SwDDEFieldType*) rIo.pDoc->InsertFldType( aType );
}

void lcl_sw3io_OutDDEFieldType( Sw3IoImp& rIo, SwDDEFieldType* pType )
{
	*rIo.pStrm << (USHORT) pType->GetType()
			   << (UINT16) rIo.aStringPool.Find( pType->GetName(), USHRT_MAX );
    ByteString s8 = rIo.ConvertStringNoDelim( pType->GetCmd(),
                        so3::cTokenSeperator, '\xff', rIo.eSrcSet );
	rIo.pStrm->WriteByteString( s8 );
}

/*  */

SwSetExpFieldType* lcl_sw3io_InSetExpFieldType( Sw3IoImp& rIo )
{
	UINT16 nType;
	String aName;

	*rIo.pStrm >> nType;

	if( rIo.nVersion < SWG_SHORTFIELDS )
		rIo.InString( *rIo.pStrm, aName );
	else
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;
		lcl_sw3io_FillSetExpFieldName( rIo, nPoolId, aName );
		if( !aName.Len() )
		{
			rIo.Warning();
			return NULL;
		}
	}

	USHORT nFldTypeCount = rIo.pDoc->GetFldTypes()->Count();
	SwSetExpFieldType* pFldType = (SwSetExpFieldType*) rIo.pDoc->
			InsertFldType( SwSetExpFieldType( rIo.pDoc, aName, nType ));

	if( SWG_SETEXPFLDCHG <= rIo.nVersion && GSE_SEQ & nType )
	{
		BYTE cDelim, nLevel;
		*rIo.pStrm >> cDelim >> nLevel;

		//JP 17.06.98: nicht setzen, wenn es ein Standard FeldType ist und
		//				man am Einfuegen ist.
		if( !rIo.bInsert ||
			nFldTypeCount != rIo.pDoc->GetFldTypes()->Count() )
		{
			pFldType->SetDelimiter( ByteString::ConvertToUnicode( cDelim,
																  rIo.eSrcSet));
			pFldType->SetOutlineLvl( nLevel );
		}
	}
	return pFldType;
}

void lcl_sw3io_OutSetExpFieldType( Sw3IoImp& rIo, SwSetExpFieldType* pType )
{
	const String& rNm = pType->GetSetRefName();

	*rIo.pStrm << (UINT16) pType->GetType()
			   << (UINT16) rIo.aStringPool.Find( rNm,
								lcl_sw3io_GetSetExpFieldPoolId( rNm ) );

	if( !rIo.IsSw31Or40Export() && GSE_SEQ & pType->GetType() )
	{
		sal_Char cDelim = ByteString::ConvertFromUnicode( pType->GetDelimiter(),
														  rIo.eSrcSet );
		*rIo.pStrm  << (BYTE)cDelim
					<< (BYTE)pType->GetOutlineLvl();
	}
}

/*  */

SwAuthorityFieldType* lcl_sw3io_InAuthorityFieldType( Sw3IoImp& rIo )
{
	SwAuthorityFieldType* pFldType = (SwAuthorityFieldType*) rIo.pDoc->
			InsertFldType( SwAuthorityFieldType(rIo.pDoc) );

	UINT16 nCount, nSortCount;
	BYTE cPrefix, cSuffix;
	BYTE cFlags = rIo.OpenFlagRec();
	*rIo.pStrm	>> nCount
				>> cPrefix
				>> cSuffix
				>> nSortCount;
	rIo.CloseFlagRec();
	if( 0 == pFldType->GetEntryCount() || (rIo.bNormal && !rIo.bInsert) )
	{
		pFldType->SetPreSuffix( ByteString::ConvertToUnicode( cPrefix,
															  rIo.eSrcSet ),
								ByteString::ConvertToUnicode( cSuffix,
															  rIo.eSrcSet ) );
		pFldType->SetSequence( (cFlags & 0x10) != 0 );
		pFldType->SetSortByDocument( (cFlags & 0x20) != 0);
	}

	ASSERT( !rIo.pAuthorityMap, "authority map is already existing" );
	if( nCount > 0 )
		rIo.pAuthorityMap = new SvUShorts;

	USHORT i;
	for( i=0; i<nCount; i++ )
	{
		rIo.OpenRec( SWG_AUTHORITY_ENTRY_LCL );

		SwAuthEntry aEntry;

		while( rIo.BytesLeft() )
		{
			UINT16 nPos;
			String sEntry;
			*rIo.pStrm	>> nPos;
			rIo.InString( *rIo.pStrm, sEntry );

			aEntry.SetAuthorField( (ToxAuthorityField)nPos, sEntry );
		}

		USHORT nNewPos = pFldType->AppendField( aEntry );
		ASSERT( !rIo.bNormal || rIo.bInsert || nNewPos == i,
				"unexpected authority entry position" );
		rIo.pAuthorityMap->Insert( nNewPos, rIo.pAuthorityMap->Count() );

		rIo.CloseRec( SWG_AUTHORITY_ENTRY_LCL );
	}
	SwTOXSortKey* pSortKeys = nSortCount ? new SwTOXSortKey[nSortCount] : 0;
	for( i=0; i<nSortCount; i++ )
	{
		BYTE cFlag;
		UINT16 nType;
		*rIo.pStrm	>> cFlag
					>> nType;
		pSortKeys[i].bSortAscending = 0 != (cFlag & 0x01);
		pSortKeys[i].eField = (ToxAuthorityField)nType;
	}
	pFldType->SetSortKeys(nSortCount, pSortKeys);
	delete pSortKeys;

	return pFldType;
}

void lcl_sw3io_OutAuthorityFieldType( Sw3IoImp& rIo,
									  SwAuthorityFieldType *pType )
{
	BYTE cFlags = 0x06;
	if( pType->IsSequence() )
		cFlags |= 0x10;
	if( pType->IsSortByDocument() )
		cFlags|= 0x20;

	USHORT nCount = pType->GetEntryCount();
	*rIo.pStrm  << cFlags
				<< (UINT16)nCount
				<< (BYTE)ByteString::ConvertFromUnicode( pType->GetPrefix(),
														 rIo.eSrcSet )
				<< (BYTE)ByteString::ConvertFromUnicode( pType->GetSuffix(),
														 rIo.eSrcSet )
				<< (UINT16)pType->GetSortKeyCount();

	USHORT i;
	for( i=0; i<nCount; i++ )
	{
		const SwAuthEntry *pEntry =	pType->GetEntryByPosition( i );
		rIo.OpenRec( SWG_AUTHORITY_ENTRY_LCL );

		USHORT nPos = 0;
		String sEntry;
		BOOL bHasEntry = pEntry->GetFirstAuthorField( nPos, sEntry );
		while( bHasEntry )
		{
			*rIo.pStrm  << (UINT16)nPos;
			rIo.OutString(*rIo.pStrm, sEntry );
			bHasEntry = pEntry->GetNextAuthorField( nPos, sEntry );
		}

		rIo.CloseRec( SWG_AUTHORITY_ENTRY_LCL );
	}
	for( i=0; i < pType->GetSortKeyCount(); i++ )
	{
		const SwTOXSortKey*	pKey = pType->GetSortKey(i);
		*rIo.pStrm  << (BYTE)(pKey->bSortAscending ? 0X01 : 0x00)
					<< (UINT16)pKey->eField;
	}
}

/*  */

SwField* lcl_sw3io_InDBField40( Sw3IoImp& rIo, SwFieldType* pType,
								USHORT nSubType, ULONG& rFmt )
{
	pType = 0;
	String aName;
	if( rIo.nVersion < SWG_SHORTFIELDS )
		pType = lcl_sw3io_InDBFieldType( rIo );
	else
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;
		aName = rIo.aStringPool.Find(nPoolId);
	}

	String aExpand;
	rIo.InString( *rIo.pStrm, aExpand );
	BYTE cFlag = 0;
	if( rIo.nVersion >= SWG_SHORTFIELDS )
		*rIo.pStrm >> cFlag;

	if( rIo.IsVersion( SWG_MULTIDB, SWG_EXPORT31, SWG_DESKTOP40 ) )
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;
		String aDBName( rIo.aStringPool.Find( nPoolId ) );
		if (aDBName.Len())
		{
			aDBName += DB_DELIM;
			aDBName += aName;
			aName = aDBName;
		}
	}

	if( aName.Len() )
		pType = rIo.pDoc->GetFldType( RES_DBFLD, aName);

	if( !pType )
	{
		rIo.Warning();
		return NULL;
	}

	SwDBField* pFld = new SwDBField( (SwDBFieldType *)pType, rFmt );
	pFld->SetSubType(nSubType);

	if( rIo.nVersion >= SWG_SHORTFIELDS && (0x01 & cFlag) )
	{
		sal_Char* dummy;
		ByteString sTmp( aExpand, RTL_TEXTENCODING_ASCII_US );
		pFld->ChgValue( strtod( sTmp.GetBuffer(), &dummy ), TRUE );
	}
	else
		pFld->InitContent( aExpand );

	return pFld;
}

SwField* lcl_sw3io_InDBField( Sw3IoImp& rIo, SwFieldType* pType,
							  USHORT nSubType, ULONG& rFmt )
{
	pType = 0;
	String aExpand;
	UINT16 nColNamePoolId, nDBNamePoolId;
	BYTE cFlag;
	*rIo.pStrm >> cFlag >> nColNamePoolId >> nDBNamePoolId;

	String aColName( rIo.aStringPool.Find( nColNamePoolId ) );
	String aDBName( rIo.aStringPool.Find( nDBNamePoolId ) );
	if (aDBName.Len())
	{
		aDBName += DB_DELIM;
		aDBName += aColName;
		aColName = aDBName;
	}

	if( aColName.Len() )
		pType = rIo.pDoc->GetFldType( RES_DBFLD, aColName );

	if( !pType )
	{
		rIo.Warning();
		return NULL;
	}

	SwDBField* pFld = new SwDBField( (SwDBFieldType *)pType, rFmt );
	pFld->SetSubType(nSubType);

	if( 0x01 & cFlag )
	{
		double dVal;
		*rIo.pStrm >> dVal;
		pFld->ChgValue( dVal, TRUE );
	}
	else
	{
		String aExpand;
		rIo.InString( *rIo.pStrm, aExpand );
		pFld->InitContent( aExpand );
	}

	return pFld;
}

void lcl_sw3io_OutDBField40( Sw3IoImp& rIo, SwField* pFld )
{
	BYTE cFlag = 0;
	String sTxt( ((SwDBField *)pFld)->GetOldContent() );
	if( ((SwDBField *)pFld)->IsValidValue() )
	{
		cFlag = 0x01;
        ByteString sValue(ByteString::CreateFromDouble(((SwDBField *)pFld)->GetValue()));
        sTxt.AssignAscii( sValue.GetBuffer() );
	}
	*rIo.pStrm << (UINT16)rIo.aStringPool.Find( ((SwDBFieldType *)pFld->GetTyp())->GetColumnName(), USHRT_MAX );
	rIo.OutString( *rIo.pStrm, sTxt );
	*rIo.pStrm  << cFlag;

	if( !rIo.IsSw31Export() )
	{
		SwDBData aData = ((SwDBFieldType *)pFld->GetTyp())->GetDBData();
		String sDBName;
		if(aData.sDataSource.getLength() || aData.sCommand.getLength())
		{
			sDBName = aData.sDataSource;
			sDBName += DB_DELIM;
			sDBName += (String)aData.sCommand;
		}
		*rIo.pStrm << (UINT16)rIo.aStringPool.Find( sDBName, IDX_NOCONV_FF );
	}
}

void lcl_sw3io_OutDBField( Sw3IoImp& rIo, SwField* pFld )
{
	BYTE cFlag = ((SwDBField *)pFld)->IsValidValue() ? 0x01 : 0x00;
	SwDBData aData = ((SwDBFieldType *)pFld->GetTyp())->GetDBData();
	String sDBName;
	if(aData.sDataSource.getLength() || aData.sCommand.getLength())
	{
		sDBName = aData.sDataSource;
		sDBName += DB_DELIM;
		sDBName += (String)aData.sCommand;
	}

	*rIo.pStrm << cFlag
			   << (UINT16)rIo.aStringPool.Find(
						((SwDBFieldType *)pFld->GetTyp())->GetColumnName(),
						USHRT_MAX )
			   << (UINT16)rIo.aStringPool.Find(
						sDBName,
						IDX_NOCONV_FF );

	if( ((SwDBField *)pFld)->IsValidValue() )
	{
		*rIo.pStrm << (double)((SwDBField *)pFld)->GetValue();
	}
	else
	{
		rIo.OutString( *rIo.pStrm, ((SwDBField *)pFld)->GetOldContent() );
	}
}

/*  */

SwField* lcl_sw3io_InFileNameField( Sw3IoImp& rIo, SwFieldType* pType,
									USHORT, ULONG& rFmt )
{
	// Das fixe Feld gibt es erst in der 5.1. Da das Fileformat zur 5.0
	// kompatibel geblieben ist und die 5.0 das Fixed-Flag nicht loescht,
	// kann es auch mal in einer aelteren Datei gesetzt sein.
	if( !rIo.IsVersion(SWG_FIXEDFNFLD) && (rFmt & FF_FIXED) != 0 )
		rFmt = (rFmt & ~FF_FIXED);

	SwFileNameField *pFld =
		new SwFileNameField( (SwFileNameFieldType *)pType );
	if( (rFmt & FF_FIXED) != 0 )
	{
		String aContent;
		rIo.InString( *rIo.pStrm, aContent );
		pFld->SetExpansion( aContent );
	}

	return pFld;
}

// Wird for 4.0-Export gar nicht erst aufgerufen!
void lcl_sw3io_OutFileNameField( Sw3IoImp& rIo, SwField* pFld )
{
	if( ((SwFileNameField *)pFld)->IsFixed() )
		rIo.OutString( *rIo.pStrm, ((SwFileNameField *)pFld)->GetContent() );
}

/*  */

SwField* lcl_sw3io_InDBNameField( Sw3IoImp& rIo, SwFieldType* pType,
								  USHORT, ULONG& )
{
	String aDBName;
	if( rIo.IsVersion( SWG_MULTIDB, SWG_EXPORT31, SWG_DESKTOP40 ) )
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;
		aDBName = rIo.aStringPool.Find( nPoolId );
	}

	SwDBData aData;
	aData.sDataSource = aDBName.GetToken(0, DB_DELIM);
	aData.sCommand = aDBName.GetToken(1, DB_DELIM);
	return new SwDBNameField( (SwDBNameFieldType *)pType, aData );
}



void lcl_sw3io_OutDBNameField( Sw3IoImp& rIo, SwField* pFld )
{
	if( !rIo.IsSw31Export() )
	{
		SwDBData aData(((SwDBNameField*)pFld)->GetRealDBData());
		String sDBName(aData.sDataSource);
		sDBName += DB_DELIM;
		sDBName += (String)aData.sCommand;
		*rIo.pStrm << (UINT16)rIo.aStringPool.Find( sDBName, IDX_NOCONV_FF );
	}
}

/*  */

SwField* lcl_sw3io_InDateField40( Sw3IoImp& rIo, SwFieldType* pType,
								  USHORT nSubType, ULONG& )
{
	SwDateTimeField* pFld =
		new SwDateTimeField( (SwDateTimeFieldType *)pType, DATEFLD );
	pFld->SetSubType(nSubType);

	return pFld;
}

/*  */

SwField* lcl_sw3io_InTimeField40( Sw3IoImp& rIo, SwFieldType* pType,
								  USHORT nSubType, ULONG& )
{
	SwDateTimeField* pFld =
		new SwDateTimeField( (SwDateTimeFieldType*)pType, TIMEFLD );
	pFld->SetSubType(nSubType);

	return pFld;
}

/*  */

SwField* lcl_sw3io_InPageNumberField40( Sw3IoImp& rIo, SwFieldType* pType,
										USHORT, ULONG& rFmt )
{
	INT16 nOff;
	UINT16 nSub;
	*rIo.pStrm >> nOff >> nSub;
	String sUserStr;
	if( rIo.nVersion >= SWG_OLENAME )
	{
		rIo.InString( *rIo.pStrm, sUserStr );
		if( rIo.IsVersion( SWG_NEXTPREVPAGE, SWG_EXPORT31 ) &&
			( PG_NEXT == nSub || PG_PREV == nSub ))
			*rIo.pStrm >> nOff;
	}

	SwPageNumberField* pFld =
		new SwPageNumberField( (SwPageNumberFieldType*)pType, nSub, rFmt, nOff );
	if( sUserStr.Len() )
		pFld->SetUserString( sUserStr );
	return pFld;
}

SwField* lcl_sw3io_InPageNumberField( Sw3IoImp& rIo, SwFieldType* pType,
									  USHORT nSubType, ULONG& rFmt )
{
	INT16 nOff;
	String sUserStr;
	*rIo.pStrm >> nOff;
	rIo.InString( *rIo.pStrm, sUserStr );

	SwPageNumberField* pFld =
		new SwPageNumberField( (SwPageNumberFieldType*)pType, nSubType,
							   rFmt, (short)nOff );
	if( sUserStr.Len() )
		pFld->SetUserString( sUserStr );
	return pFld;
}

void lcl_sw3io_OutPageNumberField40( Sw3IoImp& rIo, SwField* pFld )
{
	INT16 nOff = (INT16)pFld->GetPar2().ToInt32();
	UINT16 nSub = pFld->GetSubType();

	if( rIo.IsSw31Export() )
	{
		if( PG_NEXT == nSub )
			nOff = 1;
		else if( PG_PREV == nSub )
			nOff = -1;
	}

	*rIo.pStrm << nOff
			   << nSub;
	rIo.OutString( *rIo.pStrm, ((SwPageNumberField*)pFld)->GetUserString() );
}

void lcl_sw3io_OutPageNumberField( Sw3IoImp& rIo, SwField* pFld )
{
	// nur Offset, deshalb kein long noetig!
	INT16 nOff = (INT16)pFld->GetPar2().ToInt32();
	*rIo.pStrm << nOff;
	rIo.OutString( *rIo.pStrm, ((SwPageNumberField*)pFld)->GetUserString() );
}


/*  */

SwField* lcl_sw3io_InUserField40( Sw3IoImp& rIo, SwFieldType *pType,
								  USHORT nSubType, ULONG& rFmt )
{
	pType = 0;
	if( rIo.nVersion < SWG_SHORTFIELDS )
		pType = lcl_sw3io_InUserFieldType40( rIo );
	else
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;
		pType = rIo.pDoc->GetFldType( RES_USERFLD,
									  rIo.aStringPool.Find(nPoolId));
		if( !pType )
		{
			rIo.Warning();
			return NULL;
		}
	}
	SwUserField* pFld = new SwUserField( (SwUserFieldType *)pType );

	USHORT nType = ((SwUserFieldType *)pType)->GetType();
	nSubType |= nType;
	if( UF_STRING & nType )
		rFmt = 0;	// Warum auch immer!

	pFld->SetSubType(nSubType);

	return pFld;
}

SwField* lcl_sw3io_InUserField( Sw3IoImp& rIo, SwFieldType* pType,
								USHORT nSubType, ULONG& )
{
	pType = 0;

	USHORT nPoolId;
	*rIo.pStrm >> nPoolId;
	pType = rIo.pDoc->GetFldType( RES_USERFLD,
								  rIo.aStringPool.Find(nPoolId));
	if( !pType )
	{
		rIo.Warning();
		return NULL;
	}

	SwUserField* pFld = new SwUserField( (SwUserFieldType *)pType );
	pFld->SetSubType( nSubType );

	return pFld;
}

void lcl_sw3io_OutUserField( Sw3IoImp& rIo, SwField* pFld )
{
	*rIo.pStrm << (UINT16)rIo.aStringPool.Find(
					((SwUserField*)pFld)->GetTyp()->GetName(), USHRT_MAX );
}

/*  */

SwField* lcl_sw3io_InGetRefField40( Sw3IoImp& rIo, SwFieldType* pType,
									USHORT, ULONG& rFmt )
{
	String aName, aExpand;
	UINT16 nFmt16 = 0, nSubType, nSeqNo;

	rIo.InString( *rIo.pStrm, aName );
	rIo.InString( *rIo.pStrm, aExpand );
	if( rIo.IsVersion( SWG_FMTGETREFFLD, SWG_EXPORT31 ) )
	{
#if 0
// JP 05.11.96: es gab mal ein Zwischenversion der Felder, wo Seqence-Refs
// 				ueber eine 255 unterschieden wurden
		xub_StrLen nPos = aName.Search( (sal_Unicode)0xff );
		if( nPos != STRING_NOTFOUND )
		{
			nSeqNo = (aName.Cut( nPos )).Copy( 1 );
			*rIo.pStrm >> nFmt;
			nSubType = REF_SEQUENCEFLD;
		}
		else
#endif
		*rIo.pStrm >> nFmt16 >> nSubType >> nSeqNo;
		rFmt = nFmt16;
	}
	else if( rIo.IsVersion( SWG_DESKTOP40 ) )
	{
		*rIo.pStrm >> nSubType >> nSeqNo;
	}
	else
		nSubType = nSeqNo = 0;

	SwGetRefField* pFld = new SwGetRefField( (SwGetRefFieldType*)pType,
												aName, nSubType,
												nSeqNo, rFmt );
	pFld->SetExpand( aExpand );
	return pFld;
}

SwField* lcl_sw3io_InGetRefField( Sw3IoImp& rIo, SwFieldType* pType,
								  USHORT nSubType, ULONG& )
{
	String aName, aExpand;
	UINT16 nFmt = 0, nSeqNo;

	rIo.InString( *rIo.pStrm, aName );
	rIo.InString( *rIo.pStrm, aExpand );
	*rIo.pStrm >> nSeqNo;

	SwGetRefField* pFld = new SwGetRefField( (SwGetRefFieldType*)pType,
												aName, nSubType,
												nSeqNo, nFmt );
	pFld->SetExpand( aExpand );
	return pFld;
}

void lcl_sw3io_OutGetRefField40( Sw3IoImp& rIo, SwField* pFld )
{
	rIo.OutString( *rIo.pStrm, ((SwGetRefField*)pFld)->GetSetRefName() );
	rIo.OutString( *rIo.pStrm, pFld->Expand() );

	if( !rIo.IsSw31Export() )
	{
		*rIo.pStrm << (UINT16)pFld->GetSubType()
				   << (UINT16)((SwGetRefField*)pFld)->GetSeqNo();
	}
}

void lcl_sw3io_OutGetRefField( Sw3IoImp& rIo, SwField* pFld )
{
	rIo.OutString( *rIo.pStrm, ((SwGetRefField*)pFld)->GetSetRefName() );
	rIo.OutString( *rIo.pStrm, pFld->Expand() );
	*rIo.pStrm << (UINT16)((SwGetRefField*)pFld)->GetSeqNo();
}

/*  */

void lcl_sw3io_ChkHiddenExp( String& rCond )
{
	// die Expression wurde bei 4.0 Export einmal gedreht, beim erneuten
	// Einlesen sollte diese nicht noch mal gedreht werden.
	xub_StrLen nLen = rCond.Len(), nPos = nLen, nCnt = 1;
	if( 3 < nPos-- && ')' == rCond.GetChar( nPos ) &&
		'!' == rCond.GetChar( nPos = 0 ) && '(' == rCond.GetChar( ++nPos ))
	{
		// dann teste mal ob es dann eine komplette Klammerung ist
		--nLen; ++nPos;
		nCnt = 0;
		while( nPos < nLen )
			switch( rCond.GetChar( nPos++ ) )
			{
			case '(':		++nCnt;		break;
			case ')':		if( !nCnt-- )
								nPos = nLen;
							break;
			}
	}

	if( !nCnt )
		rCond = rCond.Copy( 2, rCond.Len() - 3);
	else
		rCond.InsertAscii( "!(", 0 ) += ')';
}

SwField* lcl_sw3io_InHiddenTxtField40( Sw3IoImp& rIo, SwFieldType* pType,
									   USHORT, ULONG& )
{
	BYTE cFlags;
	USHORT nSubType;
	String aText, aCond;
	*rIo.pStrm >> cFlags;
	rIo.InString( *rIo.pStrm, aText );
	rIo.InString( *rIo.pStrm, aCond );
	*rIo.pStrm >> nSubType;
	BOOL bCond = BOOL( ( cFlags & 0x20 ) != 0 );
	BOOL bIsHidden = BOOL( ( cFlags & 0x10 ) != 0 );

	if( bCond && TYP_CONDTXTFLD != nSubType )
	{
		lcl_sw3io_ChkHiddenExp( aCond );
		bIsHidden = !bIsHidden;
	}
	SwHiddenTxtField* pFld = new SwHiddenTxtField( (SwHiddenTxtFieldType*)pType,
				bCond,
				aEmptyStr, aText,
				bIsHidden, nSubType );
	pFld->SetPar1( aCond );
	return pFld;
}

SwField* lcl_sw3io_InHiddenTxtField( Sw3IoImp& rIo, SwFieldType* pType,
									 USHORT nSubType, ULONG& )
{
	BYTE cFlags;
	String aText, aCond;
	*rIo.pStrm >> cFlags;
	rIo.InString( *rIo.pStrm, aText );
	rIo.InString( *rIo.pStrm, aCond );
	BOOL bCond = BOOL( ( cFlags & 0x20 ) != 0 );

	SwHiddenTxtField* pFld = new SwHiddenTxtField( (SwHiddenTxtFieldType*)pType,
				bCond,
				aEmptyStr, aText,
				BOOL( ( cFlags & 0x10 ) != 0 ), nSubType );
	pFld->SetPar1( aCond );
	return pFld;
}

void lcl_sw3io_OutHiddenTxtField40( Sw3IoImp& rIo, SwField* pFld )
{
	String aText(pFld->GetPar2());
	BYTE cFlags = ((SwHiddenTxtField*)pFld)->GetValue() ? 0x10 : 0;

	if( ((SwHiddenTxtField*)pFld)->IsValid() )
	{
		if( !rIo.IsSw31Export() )
		{
			aText = pFld->GetPar2();
			aText += '|';
			aText += ((SwHiddenTxtField*)pFld)->GetCntnt();
		}
		else
		{
			if (((SwHiddenTxtField*)pFld)->GetValue())
			{
				aText = ((SwHiddenTxtField*)pFld)->GetPar2().GetToken(0, '|');
				aText += '|';
				aText += ((SwHiddenTxtField*)pFld)->GetCntnt();
			}
			else
			{
				aText = ((SwHiddenTxtField*)pFld)->GetCntnt();
				aText += '|';
				aText += pFld->GetPar2().GetToken(1, '|');
			}
		}
	}
	else
		aText = pFld->GetPar2();

	if( ((SwHiddenTxtField*)pFld)->IsConditional() )
		cFlags |= 0x20;

	String sCond( pFld->GetPar1() );
	USHORT nSubType = pFld->GetSubType();
	if( 0x20 & cFlags && TYP_CONDTXTFLD != nSubType )
	{
		lcl_sw3io_ChkHiddenExp( sCond );
		if( 0x10 & cFlags )
			cFlags &= ~0x10;
		else
			cFlags |= 0x10;
	}

	*rIo.pStrm << cFlags;
	rIo.OutString( *rIo.pStrm, aText );	// text
	rIo.OutString( *rIo.pStrm, sCond );	// condition
	*rIo.pStrm << nSubType;
}

void lcl_sw3io_OutHiddenTxtField( Sw3IoImp& rIo, SwField* pFld )
{
	String aText(pFld->GetPar2());
	BYTE cFlags = ((SwHiddenTxtField*)pFld)->GetValue() ? 0x10 : 0;

	if( ((SwHiddenTxtField*)pFld)->IsValid() )
	{
		aText = pFld->GetPar2();
		aText += '|';
		aText += ((SwHiddenTxtField*)pFld)->GetCntnt();
	}
	else
		aText = pFld->GetPar2();

	if( ((SwHiddenTxtField*)pFld)->IsConditional() )
		cFlags |= 0x20;
	*rIo.pStrm << cFlags;
	rIo.OutString( *rIo.pStrm, aText );	// text
	rIo.OutString( *rIo.pStrm, pFld->GetPar1() ); 	// condition
}

/*  */

SwField* lcl_sw3io_InPostItField( Sw3IoImp& rIo, SwFieldType* pType,
								  USHORT, ULONG& )
{
	INT32 nDate;
	String aAuthor, aText;
	*rIo.pStrm >> nDate;
	rIo.InString( *rIo.pStrm, aAuthor );
	rIo.InString( *rIo.pStrm, aText );
	return new SwPostItField( (SwPostItFieldType*)pType, aAuthor, aText, Date( nDate ) );
}

void lcl_sw3io_OutPostItField( Sw3IoImp& rIo, SwField* pFld )
{
	Date aDate = ((SwPostItField*)pFld)->GetDate();
	*rIo.pStrm << (INT32) aDate.GetDate();
	rIo.OutString( *rIo.pStrm, pFld->GetPar1() );    // Author
	rIo.OutString( *rIo.pStrm, pFld->GetPar2() );	  // Text
}

/*  */

SwField* lcl_sw3io_InDateTimeField( Sw3IoImp& rIo, SwFieldType* pType,
									USHORT nSubType, ULONG& )
{
	double	fVal;

	*rIo.pStrm >> fVal;

	SwDateTimeField* pFld = new SwDateTimeField( (SwDateTimeFieldType*)pType, nSubType );
	pFld->SetValue( fVal );

	if (rIo.IsVersion(SWG_DATEOFFSET))
	{
		INT32 nOffset;

		*rIo.pStrm >> nOffset;
		pFld->SetOffset(nOffset);
	}

	return pFld;
}

void lcl_sw3io_OutDateTimeField( Sw3IoImp& rIo, SwField* pFld )
{
	*rIo.pStrm	<< ((SwDateTimeField*)pFld)->GetValue()
				<< (INT32)((SwDateTimeField*)pFld)->GetOffset();
}

/*  */

SwField* lcl_sw3io_InFixDateField40( Sw3IoImp& rIo, SwFieldType* pType,
									 USHORT, ULONG& )
{
	INT32 nVal;
	*rIo.pStrm >> nVal;
	SwDateTimeField* pFld = new SwDateTimeField( (SwDateTimeFieldType*)pType, DATEFLD|FIXEDFLD );
    Time aTmpTime; 
    Date aTmpDate(nVal);
    DateTime aDT(aTmpDate, aTmpTime);
    pFld->SetDateTime( aDT );
	return pFld;
}

void lcl_sw3io_OutFixDateField40( Sw3IoImp& rIo, SwField* pFld )
{
    *rIo.pStrm << (INT32) ((SwDateTimeField*)pFld)->GetDate(TRUE).GetDate();
}

/*  */

SwField* lcl_sw3io_InFixTimeField40( Sw3IoImp& rIo, SwFieldType* pType,
									 USHORT, ULONG& )
{
	INT32 nVal;
	*rIo.pStrm >> nVal;
	SwDateTimeField* pFld = new SwDateTimeField( (SwDateTimeFieldType*)pType, TIMEFLD|FIXEDFLD );
    Date aTmpDate;
	DateTime aDT(aTmpDate, Time(nVal));
    pFld->SetDateTime( aDT );
	return pFld;
}

void lcl_sw3io_OutFixTimeField40( Sw3IoImp& rIo, SwField* pFld )
{
    *rIo.pStrm << (INT32)((SwDateTimeField*)pFld)->GetTime(TRUE).GetTime();
}

/*  */

SwField* lcl_sw3io_InAuthorField( Sw3IoImp& rIo, SwFieldType* pType,
								  USHORT, ULONG& )
{
	SwAuthorField *pFld =
		new SwAuthorField( (SwAuthorFieldType*)pType );

	if( rIo.IsVersion( SWG_FIXEDFLDS ) )
	{
		String aExpand;
		rIo.InString( *rIo.pStrm, aExpand );
		pFld->SetExpansion( aExpand );
	}

	return pFld;
}

// Wird for 4.0-Export gar nicht erst aufgerufen!
void lcl_sw3io_OutAuthorField( Sw3IoImp& rIo, SwField* pFld )
{
	rIo.OutString( *rIo.pStrm, ((SwAuthorField *)pFld)->GetContent() );
}

/*  */

SwField* lcl_sw3io_InChapterField( Sw3IoImp& rIo, SwFieldType* pType,
								   USHORT, ULONG& )
{
	SwChapterField* pFld = new SwChapterField( (SwChapterFieldType*)pType );
	if( rIo.nVersion >= SWG_OLENAME )
	{
		BYTE cLvl;
		*rIo.pStrm >> cLvl;
		if( cLvl >= MAXLEVEL )
			cLvl = MAXLEVEL - 1;
		pFld->SetLevel( cLvl );
	}
	return pFld;
}

void lcl_sw3io_OutChapterField( Sw3IoImp& rIo, SwField* pFld )
{
	BYTE cLvl = ((SwChapterField*)pFld)->GetLevel();
	if( rIo.IsSw31Or40Export() && cLvl >= OLD_MAXLEVEL)
		cLvl = OLD_MAXLEVEL - 1;

	*rIo.pStrm << cLvl;
}

/*  */

SwField* lcl_sw3io_InDocStatField40( Sw3IoImp& rIo, SwFieldType* pType,
									 USHORT, ULONG& rFmt )
{
	UINT16 nSubType;
	*rIo.pStrm >> nSubType;
	return new SwDocStatField( (SwDocStatFieldType*)pType, nSubType, rFmt );
}

SwField* lcl_sw3io_InDocStatField( Sw3IoImp& rIo, SwFieldType* pType,
								   USHORT nSubType, ULONG& rFmt )
{
	return new SwDocStatField( (SwDocStatFieldType*)pType, nSubType, rFmt );
}

void lcl_sw3io_OutDocStatField40( Sw3IoImp& rIo, SwField* pFld )
{
	*rIo.pStrm << (UINT16) pFld->GetSubType();
}

// Im 5.0-Format bleibt nix, was geschrieben werden muesste.

/*  */

SwField* lcl_sw3io_InDDEField( Sw3IoImp& rIo, SwFieldType* pType,
							   USHORT, ULONG& )
{
	pType = 0;
	if( rIo.nVersion < SWG_SHORTFIELDS )
		pType = lcl_sw3io_InDDEFieldType( rIo );
	else
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;
		pType = rIo.pDoc->GetFldType( RES_DDEFLD,
											rIo.aStringPool.Find(nPoolId));
		if( !pType )
		{
			rIo.Warning();
			return NULL;
		}
	}
	return new SwDDEField( (SwDDEFieldType*)pType );
}

void lcl_sw3io_OutDDEField( Sw3IoImp& rIo, SwField* pFld )
{
	*rIo.pStrm << (UINT16)rIo.aStringPool.Find( ((SwDDEField*)pFld)->GetTyp()->GetName(), USHRT_MAX );
	rIo.nFileFlags |= SWGF_HAS_DDELNK;
}

/*  */

SwField* lcl_sw3io_InInputField40( Sw3IoImp& rIo, SwFieldType* pType,
								 USHORT, ULONG& )
{
	String aContent, aPrompt;
	UINT16 nSubType;
	rIo.InString( *rIo.pStrm, aContent );
	rIo.InString( *rIo.pStrm, aPrompt );
	*rIo.pStrm >> nSubType;
	return new SwInputField( (SwInputFieldType*)pType, aContent, aPrompt, nSubType );
}

SwField* lcl_sw3io_InInputField( Sw3IoImp& rIo, SwFieldType* pType,
								 USHORT nSubType, ULONG& )
{
	String aContent, aPrompt;
	rIo.InString( *rIo.pStrm, aContent );
	rIo.InString( *rIo.pStrm, aPrompt );
	return new SwInputField( (SwInputFieldType*)pType, aContent, aPrompt, nSubType );
}

void lcl_sw3io_OutInputField40( Sw3IoImp& rIo, SwField* pFld )
{
	rIo.OutString( *rIo.pStrm, pFld->GetPar1() );// Content oder SwUserFieldName
	rIo.OutString( *rIo.pStrm, pFld->GetPar2() );// PromptText
	*rIo.pStrm << (UINT16) pFld->GetSubType();
}

void lcl_sw3io_OutInputField( Sw3IoImp& rIo, SwField* pFld )
{
	rIo.OutString( *rIo.pStrm, pFld->GetPar1() );// Content oder SwUserFieldName
	rIo.OutString( *rIo.pStrm, pFld->GetPar2() );// PromptText
}

/*  */

SwField* lcl_sw3io_InMacroField( Sw3IoImp& rIo, SwFieldType* pType,
								 USHORT, ULONG& )
{
	String aName;
	String aText;
	rIo.InString( *rIo.pStrm, aName );
	rIo.InString( *rIo.pStrm, aText );
	return new SwMacroField( (SwMacroFieldType*)pType, aName, aText );
}

void lcl_sw3io_OutMacroField( Sw3IoImp& rIo, SwField* pFld )
{
	rIo.OutString( *rIo.pStrm, pFld->GetPar1() );
	rIo.OutString( *rIo.pStrm, pFld->GetPar2() );
}

/*  */

SwField* lcl_sw3io_InTblField( Sw3IoImp& rIo, SwFieldType* pType,
							   USHORT nSubType, ULONG& )
{
	String aFormula, aText;
	UINT16 nSub = 0;
	rIo.InString( *rIo.pStrm, aFormula );
	rIo.InString( *rIo.pStrm, aText );
	if( !rIo.IsVersion(SWG_NEWERFIELDS) )
	{
		*rIo.pStrm >> nSub;
		if( !rIo.IsVersion(SWG_NEWFIELDS) )
			nSubType |= nSub;
	}
	SwTblField* pFld = new SwTblField( (SwTblFieldType*)pType,
									   aFormula, nSubType );


	pFld->ChgExpStr( aText );
	return pFld;
}

// Die Variable rIo.pCurTbl wird in Sw3IoImp::OutTable()
// besetzt und enthaelt die zur Zeit ausgegebene Tabelle

void lcl_sw3io_OutTblField( Sw3IoImp& rIo, SwField* pFld )
{
	if( rIo.pCurTbl )
		((SwTblField*)pFld)->PtrToBoxNm( rIo.pCurTbl );
	rIo.OutString( *rIo.pStrm, pFld->GetPar2() );
	rIo.OutString( *rIo.pStrm, ((SwTblField*)pFld)->GetExpStr() );
	if( rIo.IsSw31Or40Export() )
		*rIo.pStrm << (UINT16) ((SwTblField*)pFld)->GetSubType();
}

/*  */

SwField *lcl_sw3io_InGetExpField40( Sw3IoImp& rIo, SwFieldType *pType,
									USHORT nSubType, ULONG& rFmt )
{
	String aText, aExpand;
	UINT16 nSub;
	rIo.InString( *rIo.pStrm, aText );
	rIo.InString( *rIo.pStrm, aExpand );
	*rIo.pStrm >> nSub;

	SwGetExpField* pFld =
		new SwGetExpField( (SwGetExpFieldType *)pType, aText );
	pFld->ChgExpStr( aExpand );
	pFld->SetSubType( nSub | nSubType );

	if( GSE_STRING & nSub )
		rFmt = 0;	// Warum auch immer!

	return pFld;
}

SwField* lcl_sw3io_InGetExpField( Sw3IoImp& rIo, SwFieldType *pType,
								  USHORT nSubType, ULONG& )
{
	String aText, aExpand;
	rIo.InString( *rIo.pStrm, aText );
	rIo.InString( *rIo.pStrm, aExpand );

	SwGetExpField* pFld =
		new SwGetExpField( (SwGetExpFieldType *)pType, aText );
	pFld->ChgExpStr( aExpand );
	pFld->SetSubType( nSubType );

	return pFld;
}

void lcl_sw3io_OutGetExpField40( Sw3IoImp& rIo, SwField* pFld )
{
	rIo.OutString( *rIo.pStrm, ((SwGetExpField*)pFld)->GetFormula() );
	rIo.OutString( *rIo.pStrm, ((SwGetExpField*)pFld)->GetExpStr() );
	*rIo.pStrm << (UINT16) pFld->GetSubType();
}

void lcl_sw3io_OutGetExpField( Sw3IoImp& rIo, SwField* pFld )
{
	rIo.OutString( *rIo.pStrm, ((SwGetExpField*)pFld)->GetFormula() );
	rIo.OutString( *rIo.pStrm, ((SwGetExpField*)pFld)->GetExpStr() );
}

/*  */

SwField* lcl_sw3io_InSetExpField40( Sw3IoImp& rIo, SwFieldType *pType,
									USHORT nSubType, ULONG& rFmt )
{
	pType = 0;
	if( rIo.nVersion < SWG_SHORTFIELDS )
		pType = lcl_sw3io_InSetExpFieldType( rIo );
	else
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;

		// fix #26064#: Namen der 3 Label-Numernkreise: Hier wird die
		// Pool-Id des dazugehoerigen Formats aus dem Str-Pool geholt
		String aName;
		lcl_sw3io_FillSetExpFieldName( rIo, nPoolId, aName );

		pType = rIo.pDoc->GetFldType( RES_SETEXPFLD, aName );
		if( !pType )
		{
			rIo.Warning();
			return NULL;
		}
	}

	UINT16 nSeqNo;
	BYTE cFlags;
	String aFormula, aExpand, aPrompt;
	*rIo.pStrm >> cFlags;
	rIo.InString( *rIo.pStrm, aFormula );
	rIo.InString( *rIo.pStrm, aExpand );
	if( (cFlags & 0x10) && rIo.nVersion >= SWG_SHORTFIELDS )
		rIo.InString( *rIo.pStrm, aPrompt );
	if( cFlags & 0x20 )
		*rIo.pStrm >> nSeqNo;

	SwSetExpField* pFld =
		new SwSetExpField( (SwSetExpFieldType *)pType, aFormula, rFmt );

	if( cFlags & 0x10 )
	{
		pFld->SetInputFlag( TRUE );
		pFld->SetPromptText( aPrompt );
	}

	USHORT nType = ((SwSetExpFieldType *)pType)->GetType();
	// Hack: fuer Seq-Felder wurde das Original-Format im Subtyp uebergeben,
	// aber nur, wenn es auch als entsprechendes Format in Frage kommt.
	// (SUB_VISIBLE und SUB_CMD sind disjunkt).
	if( nSubType >= (USHORT)SVX_NUM_CHARS_UPPER_LETTER &&
		nSubType <= (USHORT)SVX_NUM_BITMAP )
	{
		if( GSE_SEQ & nType )
			rFmt = nSubType;
		nSubType = 0;
	}

	nSubType |= nType;
	pFld->SetSubType( nSubType );

	if( GSE_STRING & nType )
		rFmt = 0;	// Warum auch immer!

	if( GSE_SEQ & nType )
	{
		sal_Char* dummy;
		ByteString sTmp( aExpand, RTL_TEXTENCODING_ASCII_US );
		pFld->SetValue( strtod( sTmp.GetBuffer(), &dummy ) );

		USHORT n = (USHORT)pFld->GetValue();

		aExpand = ::FormatNumber( n, rFmt );

		if( cFlags & 0x20 )
			pFld->SetSeqNumber( nSeqNo );
	}
	pFld->ChgExpStr( aExpand );

	return pFld;
}

SwField* lcl_sw3io_InSetExpField( Sw3IoImp& rIo, SwFieldType *pType,
								  USHORT nSubType, ULONG& rFmt )
{
	pType = 0;

	BYTE cFlags;
	UINT16 nPoolId, nSeqNo=0, nSeqVal=0;
	String aFormula, aPrompt, aExpand;
	*rIo.pStrm  >> cFlags >> nPoolId;
	rIo.InString( *rIo.pStrm, aFormula );

	// fix #26064#: Namen der 3 Label-Numernkreise: Hier wird die
	// Pool-Id des dazugehoerigen Formats aus dem Str-Pool geholt
	String aName;
	lcl_sw3io_FillSetExpFieldName( rIo, nPoolId, aName );
	pType = rIo.pDoc->GetFldType( RES_SETEXPFLD, aName );

	if( !pType )
	{
		rIo.Warning();
		return NULL;
	}

	if( cFlags & 0x10 )
		rIo.InString( *rIo.pStrm, aPrompt );

	if( cFlags & 0x20 )
		*rIo.pStrm >> nSeqVal >> nSeqNo;

	if( cFlags & 0x40 || !(cFlags & 0x20) )
		rIo.InString( *rIo.pStrm, aExpand );

	SwSetExpField* pFld =
		new SwSetExpField( (SwSetExpFieldType *)pType, aFormula, rFmt );

	if( cFlags & 0x10 )
	{
		pFld->SetInputFlag( TRUE );
		pFld->SetPromptText( aPrompt );
	}

	pFld->SetSubType( nSubType );

	if( cFlags & 0x20 )
	{
		ASSERT( GSE_SEQ & ((SwSetExpFieldType *)pType)->GetType(),
				"Kein Sequence-Number-Feld" );

		pFld->SetValue( nSeqVal );
		if( !(cFlags & 0x40) )
			aExpand = ::FormatNumber( nSeqVal, rFmt );

		pFld->SetSeqNumber( nSeqNo );
	}

	pFld->ChgExpStr( aExpand );

	return pFld;
}


void lcl_sw3io_OutSetExpField40( Sw3IoImp& rIo, SwField *pFld)
{
	USHORT nPoolId = USHRT_MAX;
	const String& rName = ((SwSetExpField *)pFld)->GetTyp()->GetName();
	if( GSE_SEQ & ((SwSetExpFieldType *)pFld->GetTyp())->GetType() )
		nPoolId = lcl_sw3io_GetSetExpFieldPoolId( rName );

	*rIo.pStrm << (UINT16)rIo.aStringPool.Find( rName, nPoolId );

	BYTE cFlags = ((SwSetExpField *)pFld)->GetInputFlag() ? 0x10 : 0;
	String sStr( ((SwSetExpField *)pFld)->GetExpStr() );

	if( GSE_SEQ & ((SwSetExpFieldType *)pFld->GetTyp())->GetType() )
	{
		USHORT n = (USHORT)((SwSetExpField*)pFld)->GetValue();
		sStr = ::FormatNumber( n, SVX_NUM_ARABIC );
		if( !rIo.IsSw31Export() )
			cFlags |= 0x20;
	}

	*rIo.pStrm << cFlags;
	rIo.OutString( *rIo.pStrm, ((SwSetExpField*)pFld)->GetFormula() );
	rIo.OutString( *rIo.pStrm, sStr );

	if( cFlags & 0x10 )
		rIo.OutString( *rIo.pStrm, ((SwSetExpField *)pFld)->GetPromptText() );
	if( cFlags & 0x20 )
		*rIo.pStrm << (UINT16)((SwSetExpField *)pFld)->GetSeqNumber();
}

void lcl_sw3io_OutSetExpField( Sw3IoImp& rIo, SwField *pFld )
{
	USHORT nPoolId = USHRT_MAX;
	BYTE cFlags = ((SwSetExpField *)pFld)->GetInputFlag() ? 0x10 : 0;

	const String& rName = ((SwSetExpField *)pFld)->GetTyp()->GetName();
	if( ((SwSetExpField *)pFld)->IsSequenceFld() )
	{
		nPoolId = lcl_sw3io_GetSetExpFieldPoolId( rName );
		cFlags |= 0x20;
		if( MAXLEVEL > ((SwSetExpFieldType *)pFld->GetTyp())->GetOutlineLvl() )
			cFlags |= 0x40;
	}

	*rIo.pStrm << cFlags
			   << (UINT16)rIo.aStringPool.Find( rName, nPoolId );
	rIo.OutString( *rIo.pStrm, ((SwSetExpField*)pFld)->GetFormula() );

	if( cFlags & 0x10 )
		rIo.OutString( *rIo.pStrm, ((SwSetExpField *)pFld)->GetPromptText() );
	if( cFlags & 0x20 )
		*rIo.pStrm << (UINT16)((SwSetExpField*)pFld)->GetValue()
				   << (UINT16)((SwSetExpField *)pFld)->GetSeqNumber();

	if( cFlags & 0x40 || !(cFlags & 0x20) )
		rIo.OutString( *rIo.pStrm, ((SwSetExpField *)pFld)->GetExpStr() );
}

/*  */

SwField* lcl_sw3io_InHiddenParaField( Sw3IoImp& rIo, SwFieldType* pType,
									  USHORT, ULONG& )
{
	BYTE bHidden;
	String aCond;
	*rIo.pStrm >> bHidden;
	rIo.InString( *rIo.pStrm, aCond );
	SwHiddenParaField* pFld = new SwHiddenParaField( (SwHiddenParaFieldType*)pType, aCond );
	pFld->SetHidden( (BOOL) bHidden );
	return pFld;
}

void lcl_sw3io_OutHiddenParaField( Sw3IoImp& rIo, SwField* pFld )
{
	*rIo.pStrm << (BYTE)((SwHiddenParaField*)pFld)->IsHidden();
	rIo.OutString( *rIo.pStrm, pFld->GetPar1() );
}

/*  */

SwField* lcl_sw3io_InDocInfoField40( Sw3IoImp& rIo, SwFieldType* pType,
									 USHORT nSubType, ULONG& rFmt )
{
	UINT16 nSub;
	*rIo.pStrm >> nSub;
	nSubType |= nSub;

	SwDocInfoField *pFld = new SwDocInfoField( (SwDocInfoFieldType*)pType,
											   nSubType, rFmt );
	return pFld;
}

SwField* lcl_sw3io_InDocInfoField( Sw3IoImp& rIo, SwFieldType* pType,
								   USHORT nSubType, ULONG& rFmt )
{
	BYTE cFlags;
	SwDocInfoField *pFld = new SwDocInfoField( (SwDocInfoFieldType*)pType,
											   nSubType, rFmt );

	String aContent;
	*rIo.pStrm >> cFlags;
	rIo.InString( *rIo.pStrm, aContent );
	pFld->SetExpansion(aContent);
	if( cFlags & 0x01 )
	{
		double dVal;
		*rIo.pStrm >> dVal;
		pFld->SetValue( dVal );
	}

	return pFld;
}

void lcl_sw3io_OutDocInfoField40( Sw3IoImp& rIo, SwField* pFld )
{
	UINT16 nSubType = pFld->GetSubType();
	nSubType &= 0x00ff;

	*rIo.pStrm << nSubType;
}

void lcl_sw3io_OutDocInfoField( Sw3IoImp& rIo, SwField* pFld )
{
	BYTE cFlags = 0x00;
	if( ((SwDocInfoField*)pFld)->IsFixed() )
	{
		USHORT nSub = pFld->GetSubType();
		switch( nSub & 0x00ff )
		{
		case DI_EDIT:
			cFlags = 0x01;
			break;
		case DI_CREATE:
		case DI_CHANGE:
		case DI_PRINT:
			switch( nSub & ~(DI_SUB_FIXED|0x00ff) )
			{
			case DI_SUB_TIME:
			case DI_SUB_DATE:
				cFlags = 0x01;
				break;
			}
			break;
		}
	}
	*rIo.pStrm << cFlags;
	rIo.OutString( *rIo.pStrm, pFld->Expand() );
	if( cFlags & 0x01 )
		*rIo.pStrm << ((SwDocInfoField*)pFld)->GetValue();
}

/*  */

SwField* lcl_sw3io_InTemplNameField( Sw3IoImp& rIo, SwFieldType* pType,
									 USHORT, ULONG& rFmt )
{
	return new SwTemplNameField( (SwTemplNameFieldType*)pType, rFmt );
}

/*  */

SwField* lcl_sw3io_InDBNextSetField( Sw3IoImp& rIo, SwFieldType* pType,
									 USHORT, ULONG& )
{
	String aName, aCond, aDBName;
	rIo.InString( *rIo.pStrm, aCond );
	rIo.InString( *rIo.pStrm, aName );
	if( rIo.IsVersion( SWG_MULTIDB, SWG_EXPORT31, SWG_DESKTOP40 ) )
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;
		aDBName = rIo.aStringPool.Find( nPoolId );
	}
	SwDBData aData;
	aData.sDataSource = aDBName.GetToken(0, DB_DELIM);
	aData.sCommand = aDBName.GetToken(1, DB_DELIM);
	return new SwDBNextSetField( (SwDBNextSetFieldType*)pType, aCond, aName, aData );
}

void lcl_sw3io_OutDBNextSetField( Sw3IoImp& rIo, SwField* pFld )
{
	rIo.OutString( *rIo.pStrm, pFld->GetPar1() );
	rIo.OutString( *rIo.pStrm, pFld->GetPar2() );

	if( !rIo.IsSw31Export() )
	{
		SwDBData aData(((SwDBNextSetField*)pFld)->GetRealDBData());
		String sDBName(aData.sDataSource);
		sDBName += DB_DELIM;
		sDBName += (String)aData.sCommand;
		*rIo.pStrm << (UINT16)rIo.aStringPool.Find( sDBName, IDX_NOCONV_FF );
	}
}

/*  */

// der 3.1-Writer hat beim Einlesen Condition und Number vertauscht.
// Deshalb exportieren wir diese beiden Werte vertauscht und lesen sie
// in der exportierten Version auch verkehrt herum wieder ein.

SwField* lcl_sw3io_InDBNumSetField( Sw3IoImp& rIo, SwFieldType* pType,
									USHORT, ULONG& )
{
	String aNumber, aCond, aDBName;

	if( rIo.IsVersion( SWG_EXPORT31, SWG_DESKTOP40 ) )
	{
		rIo.InString( *rIo.pStrm, aNumber );
		rIo.InString( *rIo.pStrm, aCond );
	}
	else
	{
		rIo.InString( *rIo.pStrm, aCond );
		rIo.InString( *rIo.pStrm, aNumber );
	}

	if( rIo.IsVersion( SWG_MULTIDB, SWG_EXPORT31, SWG_DESKTOP40 ) )
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;
		aDBName = rIo.aStringPool.Find( nPoolId );
	}
	SwDBData aData;
	aData.sDataSource = aDBName.GetToken(0, DB_DELIM);
	aData.sCommand = aDBName.GetToken(1, DB_DELIM);
	return new SwDBNumSetField( (SwDBNumSetFieldType*)pType, aCond, aNumber, aData );
}

void lcl_sw3io_OutDBNumSetField( Sw3IoImp& rIo, SwField* pFld )
{
	if( rIo.IsSw31Export() )
	{
		rIo.OutString( *rIo.pStrm, pFld->GetPar2() );
		rIo.OutString( *rIo.pStrm, pFld->GetPar1() );
	}
	else
	{
		rIo.OutString( *rIo.pStrm, pFld->GetPar1() );
		rIo.OutString( *rIo.pStrm, pFld->GetPar2() );
	}

	if( !rIo.IsSw31Export() )
	{
		SwDBData aData(((SwDBNumSetField*)pFld)->GetRealDBData());
		String sDBName(aData.sDataSource);
		sDBName += DB_DELIM;
		sDBName += (String)aData.sCommand;
		*rIo.pStrm << (UINT16)rIo.aStringPool.Find( sDBName, IDX_NOCONV_FF );
	}
}

/*  */

SwField* lcl_sw3io_InDBSetNumberField( Sw3IoImp& rIo, SwFieldType* pType,
									   USHORT, ULONG& )
{
	String aDBName;
	INT32 n;
	*rIo.pStrm >> n;
	if( rIo.IsVersion( SWG_MULTIDB, SWG_EXPORT31, SWG_DESKTOP40 ) )
	{
		USHORT nPoolId;
		*rIo.pStrm >> nPoolId;
		aDBName = rIo.aStringPool.Find( nPoolId );
	}
	SwDBData aData;
	aData.sDataSource = aDBName.GetToken(0, DB_DELIM);
	aData.sCommand = aDBName.GetToken(1, DB_DELIM);
	SwDBSetNumberField* pFld = new SwDBSetNumberField( (SwDBSetNumberFieldType*)pType, aData );
	pFld->SetSetNumber( n );
	return pFld;
}

void lcl_sw3io_OutDBSetNumberField( Sw3IoImp& rIo, SwField* pFld )
{
	*rIo.pStrm << (INT32) ((SwDBSetNumberField*)pFld)->GetSetNumber();

	if( !rIo.IsSw31Export() )
	{
		SwDBData aData(((SwDBSetNumberField*)pFld)->GetRealDBData());
		String sDBName(aData.sDataSource);
		sDBName += DB_DELIM;
		sDBName += (String)aData.sCommand;
		*rIo.pStrm<< (UINT16)rIo.aStringPool.Find( sDBName, IDX_NOCONV_FF );
	}
}

/*  */

SwField* lcl_sw3io_InExtUserField40( Sw3IoImp& rIo, SwFieldType* pType,
									 USHORT, ULONG& )
{
	String aData;
	UINT16 nSubType;
	rIo.InString( *rIo.pStrm, aData );
	*rIo.pStrm >> nSubType;
	SwExtUserField* pFld = new SwExtUserField( (SwExtUserFieldType*)pType, nSubType );
	((SwExtUserFieldType*)pType)->SetData( aData );
	return pFld;
}

SwField* lcl_sw3io_InExtUserField( Sw3IoImp& rIo, SwFieldType* pType,
								   USHORT nSubType, ULONG& )
{
	String aData;
	rIo.InString( *rIo.pStrm, aData );

	SwExtUserField* pFld = new SwExtUserField( (SwExtUserFieldType*)pType, nSubType );
	((SwExtUserFieldType*)pType)->SetData( aData );

	if( rIo.IsVersion( SWG_FIXEDFLDS ) )
	{
		String aExpand;
		rIo.InString( *rIo.pStrm, aExpand );
		pFld->SetExpansion( aExpand );
	}

	return pFld;
}

void lcl_sw3io_OutExtUserField40( Sw3IoImp& rIo, SwField* pFld )
{
	SwExtUserFieldType* pType = (SwExtUserFieldType*) pFld->GetTyp();
	rIo.OutString( *rIo.pStrm, pType->GetData() );
	*rIo.pStrm << (UINT16) pFld->GetSubType();
}

void lcl_sw3io_OutExtUserField( Sw3IoImp& rIo, SwField* pFld )
{
	SwExtUserFieldType* pType = (SwExtUserFieldType*) pFld->GetTyp();
	rIo.OutString( *rIo.pStrm, pType->GetData() );
	rIo.OutString( *rIo.pStrm, ((SwExtUserField *)pFld)->GetContent() );
}

/*  */

SwField* lcl_sw3io_InRefPageSetField( Sw3IoImp& rIo, SwFieldType* pType,
									  USHORT, ULONG& )
{
	INT16 nOffset;
	BYTE cIsOn;
	*rIo.pStrm >> nOffset >> cIsOn;
	return new SwRefPageSetField( (SwRefPageSetFieldType*)pType, nOffset, cIsOn!=0 );
}

void lcl_sw3io_OutRefPageSetField( Sw3IoImp& rIo, SwField* pFld )
{
	*rIo.pStrm << (INT16)((SwRefPageSetField*)pFld)->GetOffset()
			   << (BYTE)((SwRefPageSetField*)pFld)->IsOn();
}

/*  */

SwField* lcl_sw3io_InRefPageGetField( Sw3IoImp& rIo, SwFieldType* pType,
									  USHORT, ULONG& )
{
	String aString;
	SwRefPageGetField *pFld = new SwRefPageGetField( (SwRefPageGetFieldType*)pType, 0 );
	rIo.InString( *rIo.pStrm, aString );
	pFld->SetText( aString );
	return pFld;
}

void lcl_sw3io_OutRefPageGetField( Sw3IoImp& rIo, SwField* pFld )
{
	rIo.OutString( *rIo.pStrm, ((SwRefPageGetField*)pFld)->GetText() );
}

/*  */

SwField *lcl_sw3io_InINetField31( Sw3IoImp& rIo, SwFieldType *, USHORT, ULONG& )
{
	ASSERT( !(rIo.pFmtINetFmt || rIo.aINetFldText.Len()),
			"Da sind noch Rest-Infos vom INet-Feld!" );

	String aURL, aText;
	rIo.InString( *rIo.pStrm, aURL );
	rIo.InString( *rIo.pStrm, rIo.aINetFldText );

	// JP 10.04.96: aus rel. URLs wieder absolute machen!
	aURL = URIHelper::SmartRelToAbs( aURL );

	String sTarget;
	if( rIo.IsVersion( SWG_TARGETFRAME, SWG_EXPORT31 ) )
	{
		rIo.InString( *rIo.pStrm, sTarget );
	}

	rIo.pFmtINetFmt = new SwFmtINetFmt( aURL, sTarget );

	if( rIo.IsVersion( SWG_INETMACROTAB, SWG_EXPORT31 ) )
	{
		USHORT nCnt;
		*rIo.pStrm >> nCnt;

		while( nCnt-- )
		{
			USHORT nCurKey;
			String aLibName, aMacName;
			*rIo.pStrm >> nCurKey;
			rIo.InString( *rIo.pStrm, aLibName );
			rIo.InString( *rIo.pStrm, aMacName );
			rIo.pFmtINetFmt->SetMacro( nCurKey, SvxMacro( aMacName, aLibName, STARBASIC ) );
		}
	}

	return 0;
}

/*  */

SwField* lcl_sw3io_InJumpEditField( Sw3IoImp& rIo, SwFieldType* pType,
									USHORT, ULONG& )
{
	String aText, aHelp;
	rIo.InString( *rIo.pStrm, aText );
	rIo.InString( *rIo.pStrm, aHelp );
	SwJumpEditField *pFld = new SwJumpEditField( (SwJumpEditFieldType*)pType, 0, aText, aHelp );
	return pFld;
}

void lcl_sw3io_OutJumpEditField( Sw3IoImp& rIo, SwField* pFld )
{
	rIo.OutString( *rIo.pStrm, pFld->GetPar1() );
	rIo.OutString( *rIo.pStrm, pFld->GetPar2() );
}

/*  */

SwField* lcl_sw3io_InScriptField40( Sw3IoImp& rIo, SwFieldType* pType,
									USHORT, ULONG& )
{
	String aType, aCode;
	BYTE cFlags = 0;
	rIo.InString( *rIo.pStrm, aType );
	rIo.InString( *rIo.pStrm, aCode );

	// Hier gab es mal eine Version SWG_SCRIPTURLS (0x0121), die jedoch
	// so gut wie keiner benutuzt hat, erst recht nicht mit Script-Feldern.
	// Deshalb wurde die geknickt.
	if( rIo.IsVersion( SWG_NEWFIELDS ) )
		*rIo.pStrm >> cFlags;
	else if( aCode.CompareIgnoreCaseToAscii( "// @url: ", 9 ) == COMPARE_EQUAL )
	{
		// HACK fuer die 363 (4.0 fixpack 2): Script-Links wurden
		// als spezieller Kommentar rausgeschrieben, weil es kein Flag zu
		// Unterscheidung von normalem Code gab.
		aCode.Erase( 0, 9 );
		cFlags = 0x01;
	}
	if( (cFlags & 0x01) != 0 )
		aCode = URIHelper::SmartRelToAbs( aCode );

	SwScriptField *pFld = new SwScriptField( (SwScriptFieldType*)pType, aType, aCode,
											 (cFlags & 0x01) != 0 );
	return pFld;
}

SwField* lcl_sw3io_InScriptField( Sw3IoImp& rIo, SwFieldType* pType,
								  USHORT, ULONG& )
{
	String aType, aCode;
	BYTE cFlags = 0;
	rIo.InString( *rIo.pStrm, aType );
	rIo.InString( *rIo.pStrm, aCode );
	*rIo.pStrm >> cFlags;

	if( (cFlags & 0x01) != 0 )
		aCode = URIHelper::SmartRelToAbs( aCode );

	SwScriptField *pFld = new SwScriptField( (SwScriptFieldType*)pType, aType, aCode,
											 (cFlags & 0x01) != 0 );
	return pFld;
}

void lcl_sw3io_OutScriptField40( Sw3IoImp& rIo, SwField* pFld )
{
	ASSERT( !rIo.IsSw31Export(),
			"Wer will denn da ein Script-Feld exportieren" );

	BYTE cFlags = ((SwScriptField*)pFld)->IsCodeURL() ? 0x01 : 0x00;

	String aCode;
	if( ((SwScriptField*)pFld)->IsCodeURL() )
	{
		aCode.AssignAscii( "// @url: " );
		aCode += INetURLObject::AbsToRel( ((SwScriptField*)pFld)->GetCode() );
	}
	else
		aCode = ((SwScriptField*)pFld)->GetCode();

	rIo.OutString( *rIo.pStrm, pFld->GetPar1() );
	rIo.OutString( *rIo.pStrm, aCode );
}

void lcl_sw3io_OutScriptField( Sw3IoImp& rIo, SwField* pFld )
{
	ASSERT( !rIo.IsSw31Export(),
			"Wer will denn da ein Script-Feld exportieren" );

	BYTE cFlags = ((SwScriptField*)pFld)->IsCodeURL() ? 0x01 : 0x00;

	String aCode;
	if( ((SwScriptField*)pFld)->IsCodeURL() )
		aCode = INetURLObject::AbsToRel( ((SwScriptField*)pFld)->GetCode() );
	else
		aCode = ((SwScriptField*)pFld)->GetCode();

	rIo.OutString( *rIo.pStrm, pFld->GetPar1() );
	rIo.OutString( *rIo.pStrm, aCode );
	*rIo.pStrm << cFlags;
}

/*  */

SwField* lcl_sw3io_InAuthorityField( Sw3IoImp& rIo, SwFieldType*,
								  USHORT, ULONG& )
{
	rIo.OpenFlagRec();

	UINT16 nPos;
	*rIo.pStrm >> nPos;

	rIo.CloseFlagRec();

	if( rIo.pAuthorityMap && nPos < rIo.pAuthorityMap->Count() )
		nPos = (*rIo.pAuthorityMap)[nPos];

	SwField *pFld = 0;
	SwFieldType* pType = rIo.pDoc->GetFldType( RES_AUTHORITY, aEmptyStr );
	ASSERT( pType, "missing authority field type" );
	if( pType )
	{
		long nHandle = ((SwAuthorityFieldType *)pType)->GetHandle( nPos );
		pFld = new SwAuthorityField( (SwAuthorityFieldType *)pType, nHandle );
	}

	return pFld;
}

void lcl_sw3io_OutAuthorityField( Sw3IoImp& rIo, SwField* pFld )
{
	BYTE cFlags = 0x02;
	*rIo.pStrm	<< cFlags
				<< (UINT16)((SwAuthorityField *)pFld)->GetHandlePosition();
}

/*  */

//////////////////////////////////////////////////////////////////////////////

// Die Beta-1-Version hatte noch eine eigene Kapselung fuer das Feld.
// Da dieser Inhalt als Teil eines SWG_ATTRIBUTE-Records vorkommt,ist
// dies reine Platzverschwendung und wurde geknickt.

#define	SWG_FIELD 'y'

typedef SwField *(*Sw3InFieldFn)( Sw3IoImp&, SwFieldType*, USHORT, ULONG& );

static Sw3InFieldFn aInFieldFnTbl40[] =
{
	&lcl_sw3io_InDBField40,        // RES_DBFLD
	&lcl_sw3io_InUserField40,      // RES_USERFLD
	&lcl_sw3io_InFileNameField,    // RES_FILENAMEFLD
	&lcl_sw3io_InDBNameField,      // RES_DBNAMEFLD
	&lcl_sw3io_InDateField40,      // RES_DATEFLD
	&lcl_sw3io_InTimeField40,      // RES_TIMEFLD
	&lcl_sw3io_InPageNumberField40,// RES_PAGENUMBERFLD
	&lcl_sw3io_InAuthorField,      // RES_AUTHORFLD
	&lcl_sw3io_InChapterField,     // RES_CHAPTERFLD
	&lcl_sw3io_InDocStatField40,   // RES_DOCSTATFLD
	&lcl_sw3io_InGetExpField40,    // RES_GETEXPFLD
	&lcl_sw3io_InSetExpField40,    // RES_SETEXPFLD
	&lcl_sw3io_InGetRefField40,    // RES_GETREFFLD
	&lcl_sw3io_InHiddenTxtField40, // RES_HIDDENTXTFLD
	&lcl_sw3io_InPostItField,      // RES_POSTITFLD
	&lcl_sw3io_InFixDateField40,   // RES_FIXDATEFLD
	&lcl_sw3io_InFixTimeField40,   // RES_FIXTIMEFLD
	0						,      // RES_REGFLD
	0						,      // RES_VARREGFLD
	0						,      // RES_SETREFFLD
	&lcl_sw3io_InInputField40,     // RES_INPUTFLD
	&lcl_sw3io_InMacroField,       // RES_MACROFLD
	&lcl_sw3io_InDDEField,         // RES_DDEFLD
	&lcl_sw3io_InTblField,         // RES_TABLEFLD
	&lcl_sw3io_InHiddenParaField,  // RES_HIDDENPARAFLD
	&lcl_sw3io_InDocInfoField40,   // RES_DOCINFOFLD
	&lcl_sw3io_InTemplNameField,   // RES_TEMPLNAMEFLD
	&lcl_sw3io_InDBNextSetField,   // RES_DBNEXTSETFLD
	&lcl_sw3io_InDBNumSetField,    // RES_DBNUMSETFLD
	&lcl_sw3io_InDBSetNumberField, // RES_DBSETNUMBERFLD
	&lcl_sw3io_InExtUserField40,   // RES_EXTUSERFLD
	&lcl_sw3io_InRefPageSetField,  // RES_REFPAGESETFLD
	&lcl_sw3io_InRefPageGetField,  // RES_REFPAGEGETFLD
	&lcl_sw3io_InINetField31,      // RES_INTERNETFLD
	&lcl_sw3io_InJumpEditField,    // RES_JUMPEDITFLD
	&lcl_sw3io_InScriptField40,    // RES_SCRIPTFLD
	0,                              // RES_DATETIMEFLD
	0,                             	// RES_AUTHORITY
	0,								// RES_COMBINED_CHARS
	0								// RES_DROPDOWN #108791#
};

static Sw3InFieldFn aInFieldFnTbl[] =
{
	&lcl_sw3io_InDBField,		   	// RES_DBFLD			   	 OK (3.1?)
	&lcl_sw3io_InUserField,	   		// RES_USERFLD			  	 OK (3.1?)
	&lcl_sw3io_InFileNameField,  	// RES_FILENAMEFLD		  	 unv.
	&lcl_sw3io_InDBNameField,	   	// RES_DBNAMEFLD		   	 unv.
	0,						   		// RES_DATEFLD			  	 OK (3.1?)
	0,                           	// RES_TIMEFLD			     OK (3.1?)
	&lcl_sw3io_InPageNumberField,	// RES_PAGENUMBERFLD	     OK (3.1?)
	&lcl_sw3io_InAuthorField,	   	// RES_AUTHORFLD		   	 unv.
	&lcl_sw3io_InChapterField,   	// RES_CHAPTERFLD		  	 unv.
	&lcl_sw3io_InDocStatField,   	// RES_DOCSTATFLD		  	 OK
	&lcl_sw3io_InGetExpField,   	// RES_GETEXPFLD		   	 OK (3.1?)
	&lcl_sw3io_InSetExpField,	   	// RES_SETEXPFLD		   	 OK (3.1?)
	&lcl_sw3io_InGetRefField,	   	// RES_GETREFFLD		   	 OK (3.1?)
	&lcl_sw3io_InHiddenTxtField, 	// RES_HIDDENTXTFLD		  	 OK
	&lcl_sw3io_InPostItField,	   	// RES_POSTITFLD		   	 unv.
	0,                           	// RES_FIXDATEFLD		     OK (3.1?)
	0,                           	// RES_FIXTIMEFLD		     OK (3.1?)
	0,							   	// RES_REGFLD			  	 ---
	0,							   	// RES_VARREGFLD 		  	 ---
	0,						    	// RES_SETREFFLD 		     ---
	&lcl_sw3io_InInputField,	   	// RES_INPUTFLD			  	 OK
	&lcl_sw3io_InMacroField,	  	// RES_MACROFLD			  	 unv.
	&lcl_sw3io_InDDEField,	   		// RES_DDEFLD			  	 unv.
	&lcl_sw3io_InTblField,	   		// RES_TABLEFLD              OK (3.1?)
	&lcl_sw3io_InHiddenParaField,	// RES_HIDDENPARAFLD	   	 unv.
	&lcl_sw3io_InDocInfoField,   	// RES_DOCINFOFLD		  	 OK
	&lcl_sw3io_InTemplNameField, 	// RES_TEMPLNAMEFLD		  	 unv.
	&lcl_sw3io_InDBNextSetField, 	// RES_DBNEXTSETFLD		  	 unv.
	&lcl_sw3io_InDBNumSetField,  	// RES_DBNUMSETFLD		  	 unv.
	&lcl_sw3io_InDBSetNumberField,	// RES_DBSETNUMBERFLD	     unv.
	&lcl_sw3io_InExtUserField,   	// RES_EXTUSERFLD		  	 OK
	&lcl_sw3io_InRefPageSetField,	// RES_REFPAGESETFLD	   	 unv.
	&lcl_sw3io_InRefPageGetField,	// RES_REFPAGEGETFLD	   	 unv.
	0,						   		// RES_INTERNETFLD		  	 unv.
	&lcl_sw3io_InJumpEditField,  	// RES_JUMPEDITFLD		  	 unv.
	&lcl_sw3io_InScriptField,	   	// RES_SCRIPTFLD		   	 OK
	&lcl_sw3io_InDateTimeField,  	// RES_DATETIMEFLD		     OK (3.1?)
	&lcl_sw3io_InAuthorityField,	// RES_AUTHORITY
	0,								// RES_COMBINED_CHARS
	0								// RES_DROPDOWN #108791#
};

SwField* Sw3IoImp::InField()
{
	ASSERT( RES_FIELDS_END-RES_FIELDS_BEGIN ==
						sizeof(aInFieldFnTbl) / sizeof(Sw3InFieldFn),
			"Neues Feld? Und tschuess..." );
	ASSERT( RES_FIELDS_END-RES_FIELDS_BEGIN ==
						sizeof(aInFieldFnTbl40) / sizeof(Sw3InFieldFn),
			"Neues Feld? Und tschuess..." );

	BYTE cType = Peek();
	if( cType == SWG_FIELD )
		OpenRec( cType );
	UINT16  nWhich;
	UINT32  nFldFmt;
	USHORT nSubType = 0;

	*pStrm >> nWhich;
	if( IsVersion(SWG_NEWERFIELDS) )
	{
		// 5.0
		*pStrm >> nFldFmt >> nSubType;
	}
	else if( IsVersion(SWG_NEWFIELDS) )
	{
		// spaete 4.0 und 5.0 vor Umbau
		*pStrm >> nFldFmt;
	}
	else
	{
		// 3.1 und 4.0
		UINT16 nOldFldFmt;
		*pStrm >> nOldFldFmt;
		nFldFmt = nOldFldFmt;
	}

	nWhich += RES_FIELDS_BEGIN;

	// Beim Import aelter Dokumente wird jetzt erstmal kraeftig
	// an allem geschraubt.
	UINT16 nRealWhich = nWhich;
	if( !IsVersion(SWG_NEWFIELDS) )
		sw3io_ConvertFromOldField( *pDoc, nRealWhich, nSubType, nFldFmt, nVersion );

	SwField* pFld = NULL;
	SwFieldType* pType = pDoc->GetSysFldType( (const RES_FIELDS)nRealWhich );

	Sw3InFieldFn *pFnTbl;
	if( IsVersion(SWG_NEWERFIELDS) )
		pFnTbl = aInFieldFnTbl;
	else
		pFnTbl = aInFieldFnTbl40;
	Sw3InFieldFn pFn =
		(nWhich < RES_FIELDS_END) ? pFnTbl[nWhich-RES_FIELDS_BEGIN] : 0;

	ASSERT( pFn, "unbekannte Feld-Which-Id" );
	if( pFn )
		pFld = (*pFn)( *this, pType, nSubType, nFldFmt );
	else
		Warning();

	if( cType == SWG_FIELD )
		CloseRec( cType );
	if( pFld )
		pFld->ChangeFormat( nFldFmt );

	if( (bOrganizer || bPageDescs) && pFld && pFld->IsFixed() )
	{
		switch( nWhich )
		{
		case RES_DATETIMEFLD:
            ((SwDateTimeField*)pFld)->SetDateTime( DateTime() );
			break;

		case RES_EXTUSERFLD:
			{
				SwExtUserField* pExtUserFld = (SwExtUserField*)pFld;
				pExtUserFld->SetExpansion( ((SwExtUserFieldType*)pType)->Expand(
											pExtUserFld->GetSubType(),
											pExtUserFld->GetFormat() ) );
			}
			break;

		case RES_AUTHORFLD:
			{
				SwAuthorField* pAuthorFld = (SwAuthorField*)pFld;
				pAuthorFld->SetExpansion( ((SwAuthorFieldType*)pType)->Expand(
											pAuthorFld->GetFormat() ) );
			}
			break;

		case RES_FILENAMEFLD:
			{
				SwFileNameField* pFileNameFld = (SwFileNameField*)pFld;
				pFileNameFld->SetExpansion( ((SwFileNameFieldType*)pType)->Expand(
											pFileNameFld->GetFormat() ) );
			}
			break;

		case RES_DOCINFOFLD:
			{
				SwDocInfoField* pDocInfFld = (SwDocInfoField*)pFld;
				pDocInfFld->SetExpansion( ((SwDocInfoFieldType*)pType)->Expand(
											pDocInfFld->GetSubType(),
											pDocInfFld->GetFormat(),
											pDocInfFld->GetLanguage() ) );
			}
			break;
		}
	}

	return pFld;
}

typedef void (*Sw3OutFieldFn)( Sw3IoImp&, SwField* );

static Sw3OutFieldFn aOutFieldFnTbl40[] =
{
	&lcl_sw3io_OutDBField40,		    // RES_DBFLD
	&lcl_sw3io_OutUserField,            // RES_USERFLD
	0,                                  // RES_FILENAMEFLD
	&lcl_sw3io_OutDBNameField,          // RES_DBNAMEFLD
	0,                                  // RES_DATEFLD
	0,                                  // RES_TIMEFLD
	&lcl_sw3io_OutPageNumberField40,    // RES_PAGENUMBERFLD
	0,                                  // RES_AUTHORFLD
	&lcl_sw3io_OutChapterField,         // RES_CHAPTERFLD
	&lcl_sw3io_OutDocStatField40,       // RES_DOCSTATFLD
	&lcl_sw3io_OutGetExpField40,        // RES_GETEXPFLD
	&lcl_sw3io_OutSetExpField40,        // RES_SETEXPFLD
	&lcl_sw3io_OutGetRefField40,        // RES_GETREFFLD
	&lcl_sw3io_OutHiddenTxtField40,     // RES_HIDDENTXTFLD
	&lcl_sw3io_OutPostItField,          // RES_POSTITFLD
	&lcl_sw3io_OutFixDateField40,       // RES_FIXDATEFLD
	&lcl_sw3io_OutFixTimeField40,       // RES_FIXTIMEFLD
	0,         						    // RES_REGFLD
	0,         						    // RES_VARREGFLD
	0,         						    // RES_SETREFFLD
	&lcl_sw3io_OutInputField40,         // RES_INPUTFLD
	&lcl_sw3io_OutMacroField,           // RES_MACROFLD
	&lcl_sw3io_OutDDEField,             // RES_DDEFLD
	&lcl_sw3io_OutTblField,             // RES_TABLEFLD
	&lcl_sw3io_OutHiddenParaField,      // RES_HIDDENPARAFLD
	&lcl_sw3io_OutDocInfoField40,       // RES_DOCINFOFLD
	0,           						// RES_TEMPLNAMEFLD
	&lcl_sw3io_OutDBNextSetField,       // RES_DBNEXTSETFLD
	&lcl_sw3io_OutDBNumSetField,        // RES_DBNUMSETFLD
	&lcl_sw3io_OutDBSetNumberField,     // RES_DBSETNUMBERFLD
	&lcl_sw3io_OutExtUserField40,       // RES_EXTUSERFLD
	&lcl_sw3io_OutRefPageSetField,      // RES_REFPAGESETFLD
	&lcl_sw3io_OutRefPageGetField,      // RES_REFPAGEGETFLD
	0,         						    // RES_INTERNETFLD
	&lcl_sw3io_OutJumpEditField,        // RES_JUMPEDITFLD
	&lcl_sw3io_OutScriptField40,        // RES_SCRIPTFLD
	0,                              	// RES_DATETIMEFLD
	0,									// RES_AUTHORITY
	0,									// RES_COMBINED_CHARS
	0									// RES_DROPDOWN #108791#
};

static Sw3OutFieldFn aOutFieldFnTbl[] =
{
	&lcl_sw3io_OutDBField,              // RES_DBFLD
	&lcl_sw3io_OutUserField,            // RES_USERFLD
	&lcl_sw3io_OutFileNameField,        // RES_FILENAMEFLD
	&lcl_sw3io_OutDBNameField,          // RES_DBNAMEFLD
	0,                                  // RES_DATEFLD
	0,                                  // RES_TIMEFLD
	&lcl_sw3io_OutPageNumberField,      // RES_PAGENUMBERFLD
	&lcl_sw3io_OutAuthorField,          // RES_AUTHORFLD
	&lcl_sw3io_OutChapterField,         // RES_CHAPTERFLD
	0,                                  // RES_DOCSTATFLD
	&lcl_sw3io_OutGetExpField,          // RES_GETEXPFLD
	&lcl_sw3io_OutSetExpField,          // RES_SETEXPFLD
	&lcl_sw3io_OutGetRefField,          // RES_GETREFFLD
	&lcl_sw3io_OutHiddenTxtField,       // RES_HIDDENTXTFLD
	&lcl_sw3io_OutPostItField,          // RES_POSTITFLD
	0,                                  // RES_FIXDATEFLD
	0,                                  // RES_FIXTIMEFLD
	0,      						    // RES_REGFLD
	0,      						    // RES_VARREGFLD
	0,    						        // RES_SETREFFLD
	&lcl_sw3io_OutInputField,           // RES_INPUTFLD
	&lcl_sw3io_OutMacroField,           // RES_MACROFLD
	&lcl_sw3io_OutDDEField,             // RES_DDEFLD
	&lcl_sw3io_OutTblField,             // RES_TABLEFLD
	&lcl_sw3io_OutHiddenParaField,      // RES_HIDDENPARAFLD
	&lcl_sw3io_OutDocInfoField,         // RES_DOCINFOFLD
	0,						            // RES_TEMPLNAMEFLD
	&lcl_sw3io_OutDBNextSetField,       // RES_DBNEXTSETFLD
	&lcl_sw3io_OutDBNumSetField,        // RES_DBNUMSETFLD
	&lcl_sw3io_OutDBSetNumberField,     // RES_DBSETNUMBERFLD
	&lcl_sw3io_OutExtUserField,         // RES_EXTUSERFLD
	&lcl_sw3io_OutRefPageSetField,      // RES_REFPAGESETFLD
	&lcl_sw3io_OutRefPageGetField,      // RES_REFPAGEGETFLD
	0,      						    // RES_INTERNETFLD
	&lcl_sw3io_OutJumpEditField,        // RES_JUMPEDITFLD
	&lcl_sw3io_OutScriptField,          // RES_SCRIPTFLD
	&lcl_sw3io_OutDateTimeField,         // RES_DATETIMEFLD
	&lcl_sw3io_OutAuthorityField,		// RES_AUTHORITY
	0,									// RES_COMBINED_CHARS
	0									// RES_DROPDOWN #108791#
};


void lcl_sw3io_OutAnySetExpField40( Sw3IoImp& rIo, const sal_Char *pName,
									const String& rExpand )
{
	SwSetExpFieldType aType( rIo.pDoc, String::CreateFromAscii(pName),
							 GSE_STRING );
	SwSetExpField aFld( &aType, rExpand );
	aFld.ChgExpStr( rExpand );
	*rIo.pStrm << (UINT16) ( RES_SETEXPFLD - RES_FIELDS_BEGIN ); // Which
	*rIo.pStrm << (UINT16) 1; // Format: GSE_STRING
	lcl_sw3io_OutSetExpField40( rIo, &aFld );
}

/* #108791# */
void lcl_sw3io_OutAnySetExpField( Sw3IoImp& rIo, const sal_Char *pName,
									const String& rExpand )
{
	SwSetExpFieldType aType( rIo.pDoc, String::CreateFromAscii(pName),
							 GSE_STRING );
	SwSetExpField aFld( &aType, rExpand );
	aFld.ChgExpStr( rExpand );
	*rIo.pStrm << (UINT16) ( RES_SETEXPFLD - RES_FIELDS_BEGIN ) // Which
               << (UINT32) 1 // Format: GSE_STRING
			   << (UINT16)aFld.GetSubType();
	lcl_sw3io_OutSetExpField( rIo, &aFld );
}

void Sw3IoImp::OutField( const SwFmtFld& rAttr )
{
	ASSERT( RES_FIELDS_END-RES_FIELDS_BEGIN ==
						sizeof(aOutFieldFnTbl) / sizeof(Sw3OutFieldFn),
			"Neues Feld? Und tschuess..." );
	ASSERT( RES_FIELDS_END-RES_FIELDS_BEGIN ==
						sizeof(aOutFieldFnTbl40) / sizeof(Sw3OutFieldFn),
			"Neues Feld? Und tschuess..." );

	const SwField* pFld = rAttr.GetFld();
	ASSERT( pFld, "SWG-Writer: SwAttrFld-Hint ohne Inhalt!" );
	if( !pFld )
		return;

	SwFieldType* pType = pFld->GetTyp();
	if( !pType )
		return;

	UINT16 nWhich = pType->Which();
	ULONG nFmt = pFld->GetFormat();

	if( SOFFICE_FILEFORMAT_40 >= pStrm->GetVersion() )
	{
		const sal_Char *pExportSetExpFld = 0;
		switch( nWhich )
		{
		case RES_DOCINFOFLD:
			if( ((SwDocInfoField*)pFld)->IsFixed() )
				pExportSetExpFld = sSW3IO_FixedField;
			break;
		case RES_AUTHORFLD:
			if( ((SwAuthorField*)pFld)->IsFixed() )
				pExportSetExpFld = sSW3IO_FixedField;
			break;
		case RES_EXTUSERFLD:
			if( ((SwExtUserField*)pFld)->IsFixed() )
				pExportSetExpFld = sSW3IO_FixedField;
			break;
		case RES_FILENAMEFLD:
			if( ((SwFileNameField*)pFld)->IsFixed() )
				pExportSetExpFld = sSW3IO_FixedField;
			break;
		case RES_AUTHORITY:
			pExportSetExpFld = sSW3IO_AuthorityField;
			break;

            /* #108791# */
		case RES_DROPDOWN:
			pExportSetExpFld = sSW3IO_DropDownField;
			break;
		}

		if( pExportSetExpFld )
		{
			lcl_sw3io_OutAnySetExpField40( *this, pExportSetExpFld,
				   						   pFld->Expand() );
			return;
		}

		 // Format wandeln
		sw3io_ConvertToOldField( pFld, nWhich, nFmt, pStrm->GetVersion() );
	}
    /* #108791# */
    else if (RES_DROPDOWN == nWhich)
    {
        lcl_sw3io_OutAnySetExpField( *this, sSW3IO_DropDownField,
                                     pFld->Expand() );

        return;        
    }

	// nField koennte von sw3io_GetOldFieldFormat geaendert worden sein
	*pStrm << (UINT16) ( nWhich - RES_FIELDS_BEGIN );

	if( SOFFICE_FILEFORMAT_40 >= pStrm->GetVersion() )
	{
		*pStrm << (UINT16) nFmt;
	}
	else
	{
		*pStrm << (UINT32) nFmt
			   << (UINT16)pFld->GetSubType();
	}

	Sw3OutFieldFn *pFnTbl;
	if( IsSw31Or40Export() )
		pFnTbl = aOutFieldFnTbl40;
	else
		pFnTbl = aOutFieldFnTbl;

	Sw3OutFieldFn pFn = pFnTbl[nWhich-RES_FIELDS_BEGIN];

	if( pFn )
		(*pFn)( *this, (SwField *)pFld );
}

// Ausgabe aller Feldtypen, die keine Systemtypen sind


BOOL lcl_sw3io_HasFixedFields40( Sw3IoImp& rIo, USHORT nWhich )
{
	SwFieldType* pFldType = rIo.pDoc->GetSysFldType( nWhich );

	SwClientIter aIter( *pFldType );
	for( SwFmtFld* pFmtFld = (SwFmtFld*)aIter.First( TYPE( SwFmtFld ));
		 pFmtFld;
		 pFmtFld = (SwFmtFld*)aIter.Next() )
	{
		const SwField *pFld = pFmtFld->GetFld();
		BOOL bFixed = FALSE;
		switch( nWhich )
		{
		case RES_DOCINFOFLD:
			bFixed = ((SwDocInfoField*)pFld)->IsFixed();
			break;
		case RES_AUTHORFLD:
			bFixed = ((SwAuthorField*)pFld)->IsFixed();
			break;
		case RES_EXTUSERFLD:
			bFixed = ((SwExtUserField*)pFld)->IsFixed();
			break;
		case RES_FILENAMEFLD:
			bFixed = ((SwFileNameField*)pFld)->IsFixed();
			break;
		}
		const SwTxtFld *pTxtFld = pFmtFld->GetTxtFld();
		if( bFixed && pTxtFld && pTxtFld->GetpTxtNode() &&
			pTxtFld->GetpTxtNode()->GetNodes().IsDocNodes() )
		{
			return TRUE;
		}
	}

	return FALSE;
}

void Sw3IoImp::OutFieldTypes()
{
	const SwFldTypes* p = pDoc->GetFldTypes();
	for( USHORT i=INIT_FLDTYPES-INIT_SEQ_FLDTYPES; i<p->Count(); ++i )
		if( !OutFieldType( *(*p)[ i ] ) )
			break;

	// Fixe DocInfo Author und ExtUser-Felder in SetExpFields wandeln
	String sFixedField( String::CreateFromAscii(sSW3IO_FixedField) );
	if( pStrm->GetVersion() <= SOFFICE_FILEFORMAT_40 &&
		!pDoc->GetFldType( RES_SETEXPFLD, sFixedField ) &&
		( lcl_sw3io_HasFixedFields40( *this, RES_DOCINFOFLD ) ||
		  lcl_sw3io_HasFixedFields40( *this, RES_AUTHORFLD ) ||
		  lcl_sw3io_HasFixedFields40( *this, RES_EXTUSERFLD ) ||
		  lcl_sw3io_HasFixedFields40( *this, RES_FILENAMEFLD ) ) )
	{
		SwSetExpFieldType aType( pDoc, sFixedField, GSE_STRING );
		OutFieldType( aType );
	}
	{
        /* #108791# */
        String sDropDown( String::CreateFromAscii(sSW3IO_DropDownField) );
		SwSetExpFieldType aType( pDoc, sDropDown, GSE_STRING );
		OutFieldType( aType );
	}
}


SwFieldType* Sw3IoImp::InFieldType()
{
	BYTE ch;
	SwFieldType* p = NULL;
	OpenRec( SWG_FIELDTYPE );
	*pStrm >> ch;
	ch += RES_FIELDS_BEGIN;
	switch( ch )
	{
		case RES_DBFLD:
			p = lcl_sw3io_InDBFieldType( *this ); break;
		case RES_USERFLD:
			if( IsVersion(SWG_NEWERFIELDS) )
				p = lcl_sw3io_InUserFieldType( *this );
			else
				p = lcl_sw3io_InUserFieldType40( *this );
			break;

		case RES_DDEFLD:
			p = lcl_sw3io_InDDEFieldType( *this ); break;
		case RES_SETEXPFLD:
			p = lcl_sw3io_InSetExpFieldType( *this ); break;
		case RES_AUTHORITY:
			p = lcl_sw3io_InAuthorityFieldType( *this ); break;
		default:
			Warning(); break;
	}
	CloseRec( SWG_FIELDTYPE );
	return p;
}

// Schreiben eines Feldtyps



BOOL Sw3IoImp::OutFieldType( const SwFieldType& rType )
{
	USHORT nFld = rType.Which();

	if( IsSw31Or40Export() && RES_AUTHORITY == nFld )
	{
		SwSetExpFieldType aType( pDoc,
								 String::CreateFromAscii(sSW3IO_AuthorityField),
								 GSE_STRING );
		return OutFieldType( aType );
	}
    /* #108791# */
    else if (RES_DROPDOWN == nFld)
    {
        SwSetExpFieldType aType( pDoc,
                                 String::CreateFromAscii(sSW3IO_DropDownField),
                                 GSE_STRING );
        return OutFieldType( aType );
    }

	OpenRec( SWG_FIELDTYPE );

	*pStrm << (BYTE) ( nFld - RES_FIELDS_BEGIN );

	switch( nFld )
	{
		case RES_DBFLD:
			lcl_sw3io_OutDBFieldType( *this, (SwDBFieldType*) &rType );
			break;
		case RES_USERFLD:
			if( IsSw31Or40Export() )
				lcl_sw3io_OutUserFieldType40( *this, (SwUserFieldType*) &rType );
			else
				lcl_sw3io_OutUserFieldType( *this, (SwUserFieldType*) &rType );
			break;
		case RES_DDEFLD:
			lcl_sw3io_OutDDEFieldType( *this, (SwDDEFieldType*) &rType );
			nFileFlags |= SWGF_HAS_DDELNK;
			break;
		case RES_SETEXPFLD:
			lcl_sw3io_OutSetExpFieldType( *this, (SwSetExpFieldType*) &rType );
			break;
		case RES_AUTHORITY:
			lcl_sw3io_OutAuthorityFieldType( *this,
											(SwAuthorityFieldType *)&rType );
			break;
		default:
			ASSERT( !this, "Unbekannter Feldtyp" );
			CloseRec( SWG_FIELDTYPE );
			Error();
			return FALSE;
	}
	CloseRec( SWG_FIELDTYPE );
	return TRUE;
}

