/*************************************************************************
 *
 *  $RCSfile: hdftctrl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 15:36:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#ifndef _SV_MENU_HXX //autogen
#include <vcl/menu.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFX_OBJITEM_HXX //autogen
#include <sfx2/objitem.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX
#include <sfx2/bindings.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _SVX_ULSPITEM_HXX //autogen
#include <svx/ulspitem.hxx>
#endif
#ifndef _SVX_DIALMGR_HXX //autogen
#include <svx/dialmgr.hxx>
#endif
#ifndef _SVX_DIALOGS_HRC //autogen
#include <svx/dialogs.hrc>
#endif
#ifndef _SFXSTRITEM_HXX
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
#ifndef _FMTHDFT_HXX //autogen
#include <fmthdft.hxx>
#endif
#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
#ifndef _HDFTCTRL_HXX
#include <hdftctrl.hxx>
#endif
#ifndef _WDOCSH_HXX
#include <wdocsh.hxx>
#endif
#ifndef _VIEW_HXX
#include <view.hxx>
#endif
#ifndef _PAGEDESC_HXX
#include <pagedesc.hxx>
#endif
#ifndef _SHELLRES_HXX
#include <shellres.hxx>
#endif

#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _MISC_HRC
#include <misc.hrc>
#endif

#define _ALL_STYLES_MENU_ENTRY 100

SFX_IMPL_MENU_CONTROL( SwHeadFootMenuControl, SfxObjectItem );

SwHeadFootMenuControl::SwHeadFootMenuControl( USHORT nPos, Menu& rMenu,
											SfxBindings& rBindings )
	: SfxMenuControl( nPos, rBindings ), pParent( &rMenu ), nInsPos( nPos ),
    pDynMenu( 0 ), pShell( 0 ),
    aStyleNames(10)
{
}

SwHeadFootMenuControl::~SwHeadFootMenuControl()
{
	if( pDynMenu )
	{
		pParent->SetPopupMenu( nInsPos, 0 );
		delete pDynMenu;
	}
}

void SwHeadFootMenuControl::StateChanged( USHORT nSID, SfxItemState eState,
										  const SfxPoolItem* pState )
{
	if( pDynMenu )
	{
		if ( pParent )
			pParent->SetPopupMenu( nInsPos, 0 );
		delete pDynMenu, pDynMenu = 0;
	}

	SfxObjectItem* pItem = PTR_CAST( SfxObjectItem, pState );
	pShell = pItem ? PTR_CAST( SwDocShell, pItem->GetShell() ) : 0;
	if( pShell && pShell->GetWrtShell() )
	{
		SwWrtShell& rSh = *pShell->GetWrtShell();

		// Seitenvorlagen besorgen
		USHORT n, nCnt = rSh.GetPageDescCnt();
        aStyleNames.DeleteAndDestroy( 0, aStyleNames.Count() );
		SvBools aCheckArr( (BYTE)nCnt );
		BOOL bAllOneState = TRUE, bLastCheck;

		for( n = 0; n < nCnt; ++n )
		{
			const SwPageDesc& rDesc = rSh.GetPageDesc( n );
            StringPtr pNm = new String(rDesc.GetName());
			USHORT nIPos;
            aStyleNames.Insert( pNm, nIPos );

			BOOL bCheck = FN_INSERT_PAGEHEADER == nSID
							? rDesc.GetMaster().GetHeader().IsActive()
							: rDesc.GetMaster().GetFooter().IsActive();
			aCheckArr.Insert( bCheck, nIPos );
			if( bAllOneState && n && bCheck != bLastCheck )
				bAllOneState = FALSE;
			bLastCheck = bCheck;
		}

		// sollte keine "gueltige" Seitenvorlage existieren?
		// (sprich: haben schon alle Kopf/Fusszeilen?)
        nCnt = aStyleNames.Count();
		if( nCnt )
		{
			pDynMenu = new PopupMenu;
			for( n = 0; n < nCnt; ++n )
			{
                pDynMenu->InsertItem( _ALL_STYLES_MENU_ENTRY + 1 + n, *aStyleNames[ n ], MIB_CHECKABLE );
                pDynMenu->CheckItem( _ALL_STYLES_MENU_ENTRY + 1 + n, aCheckArr[ n ] );
			}

			// wenn mehrere Eintraege mit dem gleichen "CheckStatus"
			// existieren, dann auch den Menupunkt "Alle" anbieten
			if( 1 < nCnt && bAllOneState )
			{
                pDynMenu->InsertItem( _ALL_STYLES_MENU_ENTRY,  ViewShell::GetShellRes()->
									aStrAllPageHeadFoot, 0, 0 );
				pDynMenu->InsertSeparator( 1 );
			}

			pDynMenu->SetSelectHdl( LINK( this, SwHeadFootMenuControl, DynMenuPageSelect ));
		}
	}
	else
		pShell = 0;

	pParent->SetPopupMenu( nInsPos, pDynMenu );

	SfxMenuControl::StateChanged( nSID, eState, pState );
}


PopupMenu* SwHeadFootMenuControl::GetPopup() const
{
	return pDynMenu;
}


IMPL_LINK( SwHeadFootMenuControl, DynMenuPageSelect, Menu*, pMenu )
{
    USHORT nCurId = pMenu->GetCurItemId();
    String sSrchNm;
    BOOL bChecked;
    if( _ALL_STYLES_MENU_ENTRY == nCurId )
        bChecked = pMenu->IsItemChecked( 101 );
    else
    {
        sSrchNm = *aStyleNames[nCurId - _ALL_STYLES_MENU_ENTRY - 1 ];
        bChecked = pMenu->IsItemChecked( nCurId );
    }

    const SfxPoolItem* aItems[3];
    SfxStringItem aStyleName(GetId(), sSrchNm);
    SfxBoolItem aOn(FN_PARAM_1, !bChecked);
    aItems[0] = &aStyleName;
    aItems[1] = &aOn;
    aItems[2] = NULL;
    GetBindings().ExecuteSynchron(GetId(), aItems, 0L);
	return 0;
}



