/*************************************************************************
 *
 *  $RCSfile: wrkdlg.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:15:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <wrkdlg.hxx>
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif


/* -----------------27.05.98 08:38-------------------
 *
 * --------------------------------------------------*/
StyleDialog::StyleDialog(Window* pParent, XStyleFamiliesRef xRef ) :
	ModalDialog(pParent, WB_STDMODAL),
	xStyles(xRef),
	aOk(this),
	aCancel(this),
	aCharFT(this),
	aCharLB(this, WB_DROPDOWN),
	aParaFT(this),
	aParaLB(this, WB_DROPDOWN),
	aFrameFT(this),
	aFrameLB(this, WB_DROPDOWN),
	aPageFT(this),
	aPageLB(this, WB_DROPDOWN),
	aNumberFT(this),
	aNumberLB(this, WB_DROPDOWN),
	aCharPB	 (this),
	aParaPB	 (this),
	aFramePB (this),
	aPagePB  (this),
	aNumberPB(this)
{
	SetText("Style dialog");
	SetSizePixel(Size(300,200));
	aOk			.SetPosSizePixel(Point(240,10), Size(50,20));
	aCancel     .SetPosSizePixel(Point(240,30), Size(50,20));
	aCharFT     .SetPosSizePixel(Point(10, 10), Size(40,20));
	aCharLB     .SetPosSizePixel(Point(55, 10), Size(90, 90));
	aCharPB		.SetPosSizePixel(Point(150, 10), Size(40, 20));
	aParaFT		.SetPosSizePixel(Point(10, 35), Size(40, 20));
	aParaLB		.SetPosSizePixel(Point(55, 35), Size(90, 90));
	aParaPB		.SetPosSizePixel(Point(150, 35), Size(40, 20));
	aFrameFT	.SetPosSizePixel(Point(10, 60), Size(40, 20));
	aFrameLB	.SetPosSizePixel(Point(55, 60), Size(90, 90));
	aFramePB	.SetPosSizePixel(Point(150, 60), Size(40, 20));
	aPageFT		.SetPosSizePixel(Point(10, 85), Size(40, 20));
	aPageLB     .SetPosSizePixel(Point(55, 85), Size(90, 90));
	aPagePB		.SetPosSizePixel(Point(150,85 ), Size(40, 20));
	aNumberFT	.SetPosSizePixel(Point(10, 110), Size(40, 20));
	aNumberLB	.SetPosSizePixel(Point(55, 110), Size(90, 90));
	aNumberPB	.SetPosSizePixel(Point(150, 110), Size(40, 20));
	aCharFT	    .SetText("Char");
	aParaFT	    .SetText("Para");
	aFrameFT	.SetText("Frame");
	aPageFT   	.SetText("Page");
	aNumberFT 	.SetText("Number");

	aCharPB	    .SetText("Properties");
	aParaPB	    .SetText("Properties");
	aFramePB	.SetText("Properties");
	aPagePB   	.SetText("Properties");
	aNumberPB 	.SetText("Properties");

	aOk.	  	Show();
	aCancel.   	Show();
	aCharFT.    Show();
	aCharLB.    Show();
	aCharPB.    Show();
	aParaFT.    Show();
	aParaLB.    Show();
	aParaPB.    Show();
	aFrameFT.   Show();
	aFrameLB.   Show();
	aFramePB.   Show();
	aPageFT.    Show();
	aPageLB.    Show();
	aPagePB.    Show();
	aNumberFT.  Show();
	aNumberLB.  Show();
	aNumberPB.  Show();

	aOk.SetClickHdl(LINK(this, StyleDialog, OkHdl));
	Link aLk(LINK(this, StyleDialog, PropertyHdl));
	aCharPB.SetClickHdl(aLk);
	aParaPB.SetClickHdl(aLk);
	aFramePB.SetClickHdl(aLk);
	aPagePB.SetClickHdl(aLk);
	aNumberPB.SetClickHdl(aLk);

	XStyleFamilyRef xFam = xStyles->getStyleFamilyByType(STYLE_FAMILY_CHARACTER);
	XNameAccessRef xNames = (XNameAccess*)xFam->queryInterface(XNameAccess::getSmartUik());
	Sequence< UString > aNames = xNames->getElementNames();
	const UString* pArr = aNames.getConstArray();
	for(INT32 i = 0; i < aNames.getLen(); i++)
		aCharLB.InsertEntry(U2S(pArr[i]));


	xFam = xStyles->getStyleFamilyByType(STYLE_FAMILY_PARAGRAPH);
	xNames = (XNameAccess*)xFam->queryInterface(XNameAccess::getSmartUik());
	aNames = xNames->getElementNames();
	pArr = aNames.getConstArray();
	for(i = 0; i < aNames.getLen(); i++)
		aParaLB.InsertEntry(U2S(pArr[i]));

	xFam = xStyles->getStyleFamilyByType(STYLE_FAMILY_FRAME);
	xNames = (XNameAccess*)xFam->queryInterface(XNameAccess::getSmartUik());
	aNames = xNames->getElementNames();
	pArr = aNames.getConstArray();
	for(i = 0; i < aNames.getLen(); i++)
		aFrameLB.InsertEntry(U2S(pArr[i]));

	xFam = xStyles->getStyleFamilyByType(STYLE_FAMILY_PAGE);
	xNames = (XNameAccess*)xFam->queryInterface(XNameAccess::getSmartUik());
	aNames = xNames->getElementNames();
	pArr = aNames.getConstArray();
	for(i = 0; i < aNames.getLen(); i++)
		aPageLB.InsertEntry(U2S(pArr[i]));

	xFam = xStyles->getStyleFamilyByType(STYLE_FAMILY_NUMBERING);
	xNames = (XNameAccess*)xFam->queryInterface(XNameAccess::getSmartUik());
	aNames = xNames->getElementNames();
	pArr = aNames.getConstArray();
	for(i = 0; i < aNames.getLen(); i++)
		aNumberLB.InsertEntry(U2S(pArr[i]));

}

/* -----------------27.05.98 08:38-------------------
 *
 * --------------------------------------------------*/
IMPL_LINK(StyleDialog, OkHdl, PushButton*, pBtn)
{
	EndDialog(RET_OK);
	return TRUE;
}
/* -----------------27.05.98 08:38-------------------
 *
 * --------------------------------------------------*/
IMPL_LINK(StyleDialog, PropertyHdl, PushButton*, pButton)
{
	String sEntry;
	XStyleFamilyRef xFam;
	if(pButton == &aCharPB)
	{
		sEntry = aCharLB.GetSelectEntry();
		xFam = xStyles->getStyleFamilyByType(STYLE_FAMILY_CHARACTER);
	}
	else if(pButton == &aParaPB)
	{
		sEntry = aParaLB.GetSelectEntry();
		xFam = xStyles->getStyleFamilyByType(STYLE_FAMILY_PARAGRAPH);
	}
	else if(pButton == &aFramePB)
	{
		sEntry = aFrameLB.GetSelectEntry();
		xFam = xStyles->getStyleFamilyByType(STYLE_FAMILY_FRAME);
	}
	else if(pButton == &aPagePB)
	{
		sEntry = aPageLB.GetSelectEntry();
		xFam = xStyles->getStyleFamilyByType(STYLE_FAMILY_PAGE);
	}
	else
	{
		sEntry = aNumberLB.GetSelectEntry();
		xFam = xStyles->getStyleFamilyByType(STYLE_FAMILY_NUMBERING);
	}
	if(xFam.is() && sEntry.Len())
	{
		XStyleRef xStyle = xFam->getStyleByName(S2U(sEntry));
		if(xStyle.is())
		{
			XPropertySetRef xPrSet = (XPropertySet*)xStyle->queryInterface(XPropertySet::getSmartUik());
			PropertyDialog aDlg(pButton, xPrSet);
			aDlg.SetText(sEntry);
			aDlg.Execute();
		}
	}
	return 0;
}



