/*************************************************************************
 *
 *  $RCSfile: rmtimap.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:55:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCPRMT_RMTIMAP_HXX_
#include <rmtimap.hxx>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTY_HPP_
#include <com/sun/star/beans/Property.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_H_ 
#include <com/sun/star/uno/Any.h>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_ 
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_ 
#include <osl/diagnose.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _UCPRMT_RMTCONN_HXX_
#include <rmtconn.hxx>
#endif

using namespace com::sun;
using namespace com::sun::star;
using namespace ucprmt;

//============================================================================
//
//  ContentIdentifierMapping
//
//============================================================================

ContentIdentifierMapping::ContentIdentifierMapping(
    rtl::Reference< Connection > const & rTheConnection,
    uno::Sequence< beans::Property > const & rProperties):
    m_xConnection(rTheConnection)
{
    OSL_ASSERT(m_xConnection.is());

    //TODO! BAD HACK to fix #81715#:  In StarPortal, the hierarchy content
    // provider in the server side UCB can contain links to both client side
    // files (file URLs) and server side files (vnd.sun.star.wfs URLs).  If we
    // would map back the TargetURLs here, we would map both file URLs and
    // vnd.sun.star.wfs URLs to vnd.sun.star.wfs URLs, which is certainly not
    // what we want.  (Also, the getProperties command does not map back any
    // TargetURLs, either; that has to be fixed once a real solution for the
    // problem is found, and the following code is reactivated.)
#if 0
    beans::Property const * pBegin = rProperties.getConstArray();
    beans::Property const * pEnd = pBegin + rProperties.getLength();
    for (beans::Property const * p = pBegin; p != pEnd; ++p)
        if (p->Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("TargetURL")))
            m_aIndices.push_back(static_cast< sal_Int32 >(p - pBegin));
#endif // 0
}

//============================================================================
// virtual
uno::Any SAL_CALL ContentIdentifierMapping::queryInterface(uno::Type const &
                                                               rType)
    throw (uno::RuntimeException)
{
    uno::Any aRet(cppu::queryInterface(
                      rType,
                      static_cast< star::ucb::XContentIdentifierMapping * >(
                          this)));
    return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
// virtual
void SAL_CALL ContentIdentifierMapping::acquire() throw ()
{
    OWeakObject::acquire();
}

//============================================================================
// virtual
void SAL_CALL ContentIdentifierMapping::release() throw ()
{
    OWeakObject::release();
}

//============================================================================
// virtual
rtl::OUString SAL_CALL
ContentIdentifierMapping::mapContentIdentifierString(rtl::OUString const &
                                                         rSource)
    throw (uno::RuntimeException)
{
    return m_xConnection->mapToLocalURI(rSource);
}

//============================================================================
// virtual
uno::Reference< star::ucb::XContentIdentifier > SAL_CALL
ContentIdentifierMapping::mapContentIdentifier(
    uno::Reference< star::ucb::XContentIdentifier > const & rSource)
    throw (uno::RuntimeException)
{
    return m_xConnection->mapToLocalIdentifier(rSource);
}

//============================================================================
// virtual
uno::Reference< star::ucb::XContent > SAL_CALL
ContentIdentifierMapping::mapContent(
    uno::Reference< star::ucb::XContent > const & rSource)
    throw (uno::RuntimeException)
{
    return m_xConnection->mapToLocalContent(rSource);
}

//============================================================================
// virtual
sal_Bool SAL_CALL
ContentIdentifierMapping::mapRow(uno::Sequence< uno::Any > & rValue)
    throw (uno::RuntimeException)
{
    uno::Any * pArray = rValue.getArray();
    sal_Int32 nLength = rValue.getLength();

    Indices::const_iterator aEnd(m_aIndices.end());
    for (Indices::const_iterator aIt(m_aIndices.begin()); aIt != aEnd; ++aIt)
    {
        sal_Int32 nIndex = *aIt;
        if (nIndex < nLength)
        {
            uno::Any & rEntry = pArray[nIndex];
            rtl::OUString aURI;
            if (rEntry >>= aURI)
                rEntry <<= m_xConnection->mapToLocalURI(aURI);
        }
    }

    return !m_aIndices.empty();
}
