/*************************************************************************
 *
 *  $RCSfile: DAVResourceAccessThread.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/07/25 11:39:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _DAVRESOURCEACCESSTHREAD_HXX_
#include "DAVResourceAccessThread.hxx"
#endif
#ifndef _DAVAUTHLISTENERIMPL_HXX_
#include "DAVAuthListenerImpl.hxx"
#endif


using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::ucb;
using namespace com::sun::star::io;
using namespace webdav_ucp;


//=========================================================================
DAVResourceAccessThread::DAVResourceAccessThread(
    const Reference<XMultiServiceFactory>& rSMgr,
    rtl::Reference<DAVSessionFactory > const & rSessionFactory,
    const rtl::OUString & rURL,
    const Reference<XCommandEnvironment > & xEnv,
    bool bWithHeaders)
    throw(
        DAVException
    )
    : DownloadThread(xEnv),
      m_aException(DAVException::DAV_SESSION_CREATE),
      m_aURL( rURL ),
      m_xSMgr( rSMgr ),
      m_xSessionFactory( rSessionFactory ),
      m_aHeaderNames(),
      m_aResource(),
      m_bWithHeaders(bWithHeaders)
{    
    // call initialize here, because for the operations done it is not
    // necessary to start the thread.
    
    initialize();
}


std::vector< rtl::OUString >& 
DAVResourceAccessThread::getHeaderNames()
{
    return m_aHeaderNames;
}


DAVResource&
DAVResourceAccessThread::getResource()
{
    return m_aResource;
}

//=========================================================================
// DAVResourceAccessThread::DAVResourceAccessThread(
//     const Reference<XMultiServiceFactory > & rSMgr,
//     rtl::Reference<DAVSessionFactory > const & rSessionFactory,
//     const rtl::OUString & rURL,
//     const std::vector< rtl::OUString > & rHeaderNames,// empty == 'all'
//     DAVResource & rResource,
//     const Reference<XCommandEnvironment > & xEnv
// )
//     throw(
//         DAVException
//     )
//     : DownloadThread(xEnv),
//       m_aException(DAVException::DAV_SESSION_CREATE),
//       m_aURL( rURL ),
//       m_xSMgr( rSMgr ),
//       m_xSessionFactory( rSessionFactory ),
//       m_pHeaderNames(&rHeaderNames),
//       m_pResource(&rResource)
// {
//     // call initialize here, because for the operations done it is not
//     // necessary to start the thread.
    
//     initialize();
// }


//=========================================================================
void DAVResourceAccessThread::work()
{   
    sal_Bool bRetry;
    do
    {
        bRetry = sal_False;
        try
        {
            if(m_bWithHeaders)
                m_xSession->GET(
                    (void*)GetSink(),
                    getRequestURI(),
                    m_aHeaderNames,
                    m_aResource,
                    DAVRequestEnvironment(
                        getRequestURI(),
                        new DAVAuthListener_Impl(GetEnv())));
            else
                m_xSession->GET(
                    (void*)GetSink(),
                    getRequestURI(),
                    DAVRequestEnvironment(
                        getRequestURI(),
                        new DAVAuthListener_Impl(GetEnv())));
        }
        catch ( DAVException & e )
        {
            bRetry = handleException( e );
            if ( !bRetry ) {
                m_aException = e;
                OnAbort();
            }
        }
    }
    while ( bRetry );
}


//=========================================================================
void DAVResourceAccessThread::initialize()
    throw ( DAVException )
{
    if ( m_aPath.getLength() == 0 )
    {
        osl::Guard< osl::Mutex > aGuard( m_aMutex );
        if ( m_aPath.getLength() == 0 )
        {
            NeonUri aURI( m_aURL );
            rtl::OUString aPath( aURI.GetPath() );
            if ( !aPath.getLength() )
                throw DAVException( DAVException::DAV_INVALID_ARG );
            
            if ( !m_xSession.is() || !m_xSession->CanUse( m_aURL ) )
            {
                m_xSession.clear();

                // create new webdav session
                m_xSession
                    = m_xSessionFactory->createDAVSession(m_aURL,m_xSMgr);
                
                if ( !m_xSession.is() )
                    return;
            }
            
            // Own URI is needed for redirect cycle detection.
            m_aRedirectURIs.push_back( aURI );

            // Success.
            m_aPath = aPath;
        }
    }
}


//=========================================================================
const rtl::OUString & DAVResourceAccessThread::getRequestURI() const
{
    OSL_ENSURE( m_xSession.is(),
                "DAVResourceAccess::getRequestURI - Not initialized!" );

    // In case a proxy is used we have to use the absolute URI for a request.
    if ( m_xSession->UsesProxy() )
        return m_aURL;

    return m_aPath;
}


//=========================================================================
sal_Bool DAVResourceAccessThread::detectRedirectCycle(
    const rtl::OUString& rRedirectURL )
{
    osl::Guard< osl::Mutex > aGuard( m_aMutex );
    
    NeonUri aUri( rRedirectURL );
    
    std::vector< NeonUri >::const_iterator it  = m_aRedirectURIs.begin();
    std::vector< NeonUri >::const_iterator end = m_aRedirectURIs.end();
    
    while ( it != end )
    {
        if ( aUri == (*it) )
            return sal_True;
        
        it++;
    }
    
    return sal_False;
}


//=========================================================================
sal_Bool DAVResourceAccessThread::handleException( DAVException & e )
{
	switch ( e.getError() )
	{
    case DAVException::DAV_HTTP_REDIRECT:
        try
        {
            if ( !detectRedirectCycle( e.getData() ) )
            {
                // set new URL and path.
                setURL( e.getData() );
                initialize();
                return sal_True;
            }
        }
        catch( DAVException const & )
        {
        }
        return sal_False;
        
    default:
        return sal_False; // Abort
	}
}


void DAVResourceAccessThread::setURL( const rtl::OUString & rNewURL )
	throw( DAVException )
{
    osl::Guard< osl::Mutex > aGuard( m_aMutex );
    m_aURL  = rNewURL;
    m_aPath = rtl::OUString(); // Next initialize() will create new session.
}



DAVException DAVResourceAccessThread::GetException() const
{
    osl::Guard< osl::Mutex > aGuard( m_aMutex );
    return m_aException;
}
