 /*************************************************************************
 *
 *  $RCSfile: UNODialogs.java,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/06 10:45:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 */

package com.sun.star.wizards.common;

import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XScrollBar;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.awt.XMessageBox;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XMouseListener;
import com.sun.star.awt.XTextListener;
import com.sun.star.awt.XAdjustmentListener;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XVclWindowPeer;
import com.sun.star.awt.XWindowPeer;

import com.sun.star.frame.XController;
import com.sun.star.script.XInvocation;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XElementAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XNameContainer;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XMultiPropertySet;

import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XNamingService;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Any;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.lang.Locale;
import com.sun.star.lang.*;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.EventObject;
import com.sun.star.frame.XFrame;
import com.sun.star.accessibility.XAccessibleContext;


import java.io.*;
import java.util.*;


import com.sun.star.comp.servicemanager.ServiceManager;

import com.sun.star.uno.XInterface;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XNamingService;


public class UNODialogs {
    public XMultiServiceFactory xMSF;
    public XMultiServiceFactory MSFDialogModel;
    public XNameContainer xDlgNames;
    public XControlContainer xDlgContainer;
    public XNameAccess xDlgNameAccess;
    public XControl xControl;
    public XWindowPeer xWindowPeer;
    public XDialog xDialog;
    public XWindow xWindow;
    public XComponent xComponent;
    public XInterface xDialogModel;
    public XInterface xUNODialog;
    public Hashtable ControlList;

    public UNODialogs(XMultiServiceFactory xMSF, String[] PropertyNames, Object[] PropertyValues){
    try{
	this.xMSF = xMSF;
        ControlList = new Hashtable();
	xDialogModel = (XInterface) xMSF.createInstance("com.sun.star.awt.UnoControlDialogModel");
	XMultiPropertySet xMultiPSetDlg = (XMultiPropertySet) UnoRuntime.queryInterface(XMultiPropertySet.class, xDialogModel);
        xMultiPSetDlg.setPropertyValues(PropertyNames, PropertyValues);
	MSFDialogModel = (XMultiServiceFactory) UnoRuntime.queryInterface(XMultiServiceFactory.class, xDialogModel);
	xUNODialog = (XInterface) xMSF.createInstance("com.sun.star.awt.UnoControlDialog");
	xControl = (XControl) UnoRuntime.queryInterface(XControl.class, xUNODialog);
	XControlModel xControlModel = (XControlModel) UnoRuntime.queryInterface(XControlModel.class, xDialogModel);
        xControl.setModel(xControlModel);
	xDlgContainer = (XControlContainer) UnoRuntime.queryInterface(XControlContainer.class, xUNODialog);
        xDlgNames = (XNameContainer) UnoRuntime.queryInterface( XNameContainer.class, xDialogModel);
        xDlgNameAccess = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, xDialogModel);
	xComponent = (XComponent) UnoRuntime.queryInterface(XComponent.class, xUNODialog);
	xWindow = (XWindow) UnoRuntime.queryInterface(XWindow.class, xUNODialog);
    }
    catch(Exception exception)
    {
        exception.printStackTrace(System.out);
    }}


    public int getControlKey(Object EventObject, Hashtable ControlList){
	int iKey;
        XControl xControl = (XControl) UnoRuntime.queryInterface(XControl.class, EventObject);
        XControlModel xControlModel = xControl.getModel();
        XPropertySet xPSet = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, xControlModel);
        try{
            String sName = (String) xPSet.getPropertyValue("Name");
            Integer KeyObject = (Integer) ControlList.get(sName);
            iKey = KeyObject.intValue();
        }
        catch( Exception exception )
        {
	      exception.printStackTrace(System.out);
              iKey = 2000;
        }
        return iKey;
    }


    public void assignPropertyToDialogControl(String ControlName, String PropertyName, Object PropertyValue){
    try{
	if (PropertyValue != null){
	    if (xDlgNameAccess.hasByName(ControlName) == false)
		return;
	    Object xControlModel = xDlgNameAccess.getByName(ControlName);
	    XPropertySet xPSet = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, xControlModel);
	    if (xPSet.getPropertySetInfo().hasPropertyByName(PropertyName) == true)
		xPSet.setPropertyValue(PropertyName, PropertyValue);
	}
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
    }}


    public Object getPropertyOfDialogControl(String ControlName, String PropertyName){
    try{
	if (xDlgNameAccess.hasByName(ControlName)){
	    Object xControlModel = xDlgNameAccess.getByName(ControlName);
	    XPropertySet xPSet = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, xControlModel);
	    Object oPropValue = xPSet.getPropertyValue(PropertyName);
	    if (AnyConverter.isArray(oPropValue)) {
	        Object oPropList = AnyConverter.toArray(oPropValue);
	        return oPropList;
	    }
	    else
	        return oPropValue;
	}
	else 
	    throw new com.sun.star.uno.RuntimeException();
    }
    catch(Exception exception){				// com.sun.star.container.NoSuchElementException, com.sun.star.beans.UnknownPropertyException,
        exception.printStackTrace(System.out);		// com.sun.star.lang.WrappedTargetException, com.sun.star.beans.PropertyVetoException
	return null;					// com.sun.star.lang.IllegalArgumentException
    }}


    public void toggleListboxControls(XListBox xFieldsListBox, XListBox xSelFieldsListBox, Boolean BDoEnable){
        try{
            assignPropertyToDialogControl("lblFields", "Enabled", BDoEnable);
            assignPropertyToDialogControl("lblSelFields", "Enabled", BDoEnable);
            assignPropertyToDialogControl("lstFields", "Enabled", BDoEnable);
            assignPropertyToDialogControl("lstSelFields", "Enabled", BDoEnable);

            if (BDoEnable.booleanValue() == true)
                FormSetMoveRights(xFieldsListBox, xSelFieldsListBox, (short) -1, (short) -1);
	    else{
		assignPropertyToDialogControl("cmdRemoveAll", "Enabled", BDoEnable);
		assignPropertyToDialogControl("cmdRemoveSelected", "Enabled", BDoEnable);
		assignPropertyToDialogControl("cmdMoveAll", "Enabled", BDoEnable);
		assignPropertyToDialogControl("cmdMoveSelected", "Enabled", BDoEnable);
	    }}
            catch(Exception exception){
                exception.printStackTrace(System.out);
            }
        }

    // Enable or disable the buttons used for moving the available
    // fields between the two list boxes.
    public void FormSetMoveRights(XListBox xFieldsListBox, XListBox xSelFieldsListBox, short iFieldsSelIndex, short iSelFieldsSelIndex){
        try{
	    selectListBoxItem(xFieldsListBox, iFieldsSelIndex);
	    selectListBoxItem(xSelFieldsListBox, iSelFieldsSelIndex);
	    boolean bIsFieldSelected = (xFieldsListBox.getSelectedItems().length > 0);
            int FieldCount = xFieldsListBox.getItemCount();
            boolean bSelectSelected = (xSelFieldsListBox.getSelectedItems().length > 0);
            int SelectCount = xSelFieldsListBox.getItemCount();
            assignPropertyToDialogControl("cmdRemoveAll", "Enabled", new Boolean(SelectCount>=1));
            assignPropertyToDialogControl("cmdRemoveSelected", "Enabled", new Boolean(bSelectSelected));
            assignPropertyToDialogControl("cmdMoveAll", "Enabled", new Boolean(FieldCount >=1));
            assignPropertyToDialogControl("cmdMoveSelected", "Enabled", new Boolean(bIsFieldSelected));
            assignPropertyToDialogControl("cmdGoOn", "Enabled", new Boolean(SelectCount>=1));
	}
        catch(Exception exception){
            exception.printStackTrace(System.out);
        }
    }

    public void selectListBoxItem(XListBox xFieldsListBox, short iFieldsSelIndex){
    try{
	if (iFieldsSelIndex > -1){
	    int FieldCount = xFieldsListBox.getItemCount();
	    if (FieldCount > 0){
		if (iFieldsSelIndex < FieldCount)
		    xFieldsListBox.selectItemPos(iFieldsSelIndex, true);
		else
		    xFieldsListBox.selectItemPos((short) (iFieldsSelIndex-1), true);
	    }
	}
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
    }}


    public void emptyFieldsListBoxes(XListBox xFieldsListBox, XListBox xSelFieldsListBox){
        try{
            toggleListboxControls(xFieldsListBox, xSelFieldsListBox, new Boolean(false));
            xFieldsListBox.removeItems((short) 0, xFieldsListBox.getItemCount());
            xSelFieldsListBox.removeItems((short) 0, xSelFieldsListBox.getItemCount());
        }
        catch(Exception exception){
            exception.printStackTrace(System.out);
        }
    }


    public void mergeList(XListBox xFieldsListBox, XListBox xSelFieldsListBox, String[] OriginalList, String[] SecondList){
//        int MaxIndex = getListBoxlength(SourceListBox)-1
	int MaxIndex = SecondList.length;
//	OriginalList = (String[]) addListtoList((Object[]) OriginalList, (Object[]) SecondList);
        xFieldsListBox.addItems(OriginalList, (short) 0);
//        for(int i=0; i<=MaxIndex; i++){
//            addSingleItemtoListbox(xFieldsListBox, SecondList[i]), ;
//	}
        FormSetMoveRights(xFieldsListBox, xSelFieldsListBox, (short) -1, (short) -1);
    }

    // Note Boolean Parameter
    public void initializeListboxProcedures(XListBox xFieldsListBox, XListBox xSelFieldsListBox, String[] OriginalList){
	OriginalList = xFieldsListBox.getItems();
	if (xSelFieldsListBox.getItemCount() > 0)
	    xSelFieldsListBox.removeItems((short) 0, xSelFieldsListBox.getItemCount());
    }


    public void FormMoveAll(XListBox xFieldsListBox, XListBox xSelFieldsListBox, String[] OriginalList){
	xFieldsListBox.removeItems((short) 0, xFieldsListBox.getItemCount());
	xSelFieldsListBox.removeItems((short) 0, xSelFieldsListBox.getItemCount());
        xSelFieldsListBox.addItems(OriginalList, (short) 0);
        FormSetMoveRights(xFieldsListBox, xSelFieldsListBox, (short) -1, (short) 0);
//	oDialogModel.lstSelFields.Tag = true
    }


    public void MoveSelectedListBox(XListBox xFieldsListBox, XListBox xSelFieldsListBox){
        int CurIndex;
	short iFieldSelected = (short) -1;
	short iSelFieldSelected = (short) -1;
	int MaxCurTarget = xSelFieldsListBox.getItemCount();
	int MaxSourceSelected = xFieldsListBox.getSelectedItems().length;
        if (MaxSourceSelected > 0){
	    iFieldSelected = xFieldsListBox.getSelectedItemPos();
	    iSelFieldSelected = xSelFieldsListBox.getSelectedItemPos();
	    short[] SourceSelList = new short[xFieldsListBox.getSelectedItemsPos().length];
            SourceSelList = xFieldsListBox.getSelectedItemsPos();
            int iOldSourceSelect = SourceSelList[0];
            xSelFieldsListBox.addItems(xFieldsListBox.getSelectedItems(), xSelFieldsListBox.getItemCount());
            removeSelectedItems(xFieldsListBox);
            xSelFieldsListBox.selectItemPos((short) 0, xSelFieldsListBox.getSelectedItems().length > 0);
        }
        FormSetMoveRights(xFieldsListBox, xSelFieldsListBox, iFieldSelected, iSelFieldSelected);
    }


    public void MoveOrderedSelectedListBox(XListBox xFieldsListBox, XListBox xSelFieldsListBox, String[] OriginalList,  boolean bMoveAll){
        int m = 0;
        String SearchString;
	short iOldFieldSelected = xFieldsListBox.getSelectedItemPos();
	short iOldSelFieldSelected = xSelFieldsListBox.getSelectedItemPos();
        if(bMoveAll){
           xFieldsListBox.removeItems((short) 0, xFieldsListBox.getItemCount());
           xFieldsListBox.addItems(OriginalList,(short) 0);
           xSelFieldsListBox.removeItems((short) 0, xSelFieldsListBox.getItemCount());
        }
	else{
           int MaxOriginalCount = OriginalList.length;
           int MaxSelected =  xSelFieldsListBox.getSelectedItems().length;
           String[] TargetList = xSelFieldsListBox.getSelectedItems();
           String[] SelList = xFieldsListBox.getItems();
           String[] NewSourceList = new String[TargetList.length + SelList.length];
           for (int i=0; i<MaxOriginalCount; i++){
		SearchString = OriginalList[i];
		if (Tools.FieldInList(SelList, SearchString) != -1){
                     NewSourceList[m] =  SearchString;
                     m++;
                }
                else if (Tools.FieldInList(TargetList, SearchString) != -1){
                     NewSourceList[m] = SearchString;
                     m++;
               }
           }
           xFieldsListBox.removeItems((short)0, xFieldsListBox.getItemCount());
           xFieldsListBox.addItems(NewSourceList, (short) 0);
           removeSelectedItems(xSelFieldsListBox);
           // Todo: Die Selektierungen hinzufgen
       }
       FormSetMoveRights(xFieldsListBox, xSelFieldsListBox, iOldFieldSelected, iOldSelFieldSelected);
    }


    public void removeSelectedItems(XListBox xListBox){
        short[] SelList = xListBox.getSelectedItemsPos();
        int Sellen = SelList.length;
        for (int i=Sellen-1; i>=0; i--){
            xListBox.removeItems(SelList[i], (short) 1);
        }
    }


    public void addSingleItemtoListbox(XListBox xListBox, String ListItem, short iSelIndex){
	xListBox.addItem(ListItem, xListBox.getItemCount());
        if (iSelIndex != -1)
            xListBox.selectItemPos(iSelIndex, true);
    }

    
    public static int showMessageBox(XMultiServiceFactory xMSF, String WindowServiceName, int WindowAttribute, String MessageText){
    short iMessage = 0;
    try{
	if (MessageText == null)
	    return 0;
	XFrame xFrame = Tools.getActiveFrame(xMSF);
	XWindowPeer xWindowPeer = (XWindowPeer) UnoRuntime.queryInterface(XWindowPeer.class, xFrame.getComponentWindow());
	XInterface xAWTToolkit = (XInterface) xMSF.createInstance("com.sun.star.awt.Toolkit");
	XToolkit xToolkit = (XToolkit) UnoRuntime.queryInterface(XToolkit.class, xAWTToolkit);
	com.sun.star.awt.WindowDescriptor oDescriptor = new com.sun.star.awt.WindowDescriptor();
	oDescriptor.WindowServiceName = WindowServiceName;
	oDescriptor.Parent = xWindowPeer;
	oDescriptor.Type = com.sun.star.awt.WindowClass.MODALTOP;
	oDescriptor.WindowAttributes = WindowAttribute;
	XWindowPeer xMsgPeer = xToolkit.createWindow(oDescriptor);
	XMessageBox xMsgbox = (XMessageBox) UnoRuntime.queryInterface(XMessageBox.class, xMsgPeer);
	xMsgbox.setMessageText(MessageText);
	iMessage = xMsgbox.execute();
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
    }
    return iMessage;
    }


    public void insertButton(String sName, int iControlKey, XActionListener xActionListener, String[] sProperties, Object[] sValues)
        throws com.sun.star.uno.Exception{
           Object oButtonModel = insertControlModel("com.sun.star.awt.UnoControlButtonModel", sName, sProperties, sValues);
           XPropertySet xPSet = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, oButtonModel);
           xPSet.setPropertyValue("Name", sName);
           Object objectButton = xDlgContainer.getControl( new String(sName));
           XButton xButton = ( XButton ) UnoRuntime.queryInterface( XButton.class, objectButton );
           xButton.addActionListener(xActionListener);
           Integer ControlKey = new Integer(iControlKey);
	   if (ControlList != null)
		ControlList.put(sName, ControlKey);
        }


    public XScrollBar insertScrollBar(String sName, int iControlKey, XAdjustmentListener xAdjustmentListener, String[] sProperties, Object[] sValues){
    try{
	Object oScrollModel = insertControlModel("com.sun.star.awt.UnoControlScrollBarModel", sName, sProperties, sValues);
        XPropertySet xPSet = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, oScrollModel);
        xPSet.setPropertyValue("Name", sName);
        Object oScrollBar = xDlgContainer.getControl( new String(sName));
        XScrollBar xScrollBar = (XScrollBar) UnoRuntime.queryInterface( XScrollBar.class, oScrollBar);
        xScrollBar.addAdjustmentListener(xAdjustmentListener);
        Integer ControlKey = new Integer(iControlKey);
	if (ControlList != null)
	    ControlList.put(sName, ControlKey);
	return xScrollBar;
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
	return null;
    }}
    

    public XTextComponent insertTextField(String sName, int iControlKey, XTextListener xTextListener, String[] sProperties, Object[] sValues)
        throws com.sun.star.uno.Exception{
           XInterface xTextModel = insertControlModel("com.sun.star.awt.UnoControlEditModel", sName, sProperties, sValues);
           XPropertySet xPSet = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, xTextModel);
           xPSet.setPropertyValue("Name", sName);
           XControl xTextField = xDlgContainer.getControl(new String(sName));
           XTextComponent xTextBox = (XTextComponent) UnoRuntime.queryInterface(XTextComponent.class, xTextField);
	   xTextBox.addTextListener(xTextListener);
           Integer ControlKey = new Integer(iControlKey);
           ControlList.put(sName, ControlKey);
	   return xTextBox;
        }


    public XListBox insertListBox(String sName, int iControlKey, XActionListener xActionListener, XItemListener xItemListener,
                                           String[] sProperties, Object[] sValues)
        throws com.sun.star.uno.Exception{
            XInterface xListBoxModel = insertControlModel("com.sun.star.awt.UnoControlListBoxModel", sName, sProperties, sValues);
            XPropertySet xPSet = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, xListBoxModel);
            xPSet.setPropertyValue("Name", sName);
            XControl xControlListBox = xDlgContainer.getControl( new String(sName));
            com.sun.star.awt.XListBox xListBox = (com.sun.star.awt.XListBox) UnoRuntime.queryInterface(com.sun.star.awt.XListBox.class, xControlListBox);
	    if (xItemListener != null)
		xListBox.addItemListener(xItemListener);
	    if (xActionListener != null)
		xListBox.addActionListener(xActionListener);
            Integer ControlKey = new Integer(iControlKey);
            ControlList.put(sName, ControlKey);
            return xListBox;
       }


       public XButton insertRadioButton(String sName, int iControlKey, XActionListener xActionListener, String[] sProperties, Object[] sValues)
        throws com.sun.star.uno.Exception{
            XInterface oRadioButtonModel = insertControlModel("com.sun.star.awt.UnoControlRadioButtonModel", sName, sProperties, sValues);
            XPropertySet xPSet = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, oRadioButtonModel);
            xPSet.setPropertyValue("Name", sName);
            XControl xControlRadioButton = xDlgContainer.getControl( new String(sName));
            com.sun.star.awt.XButton xRadioButton = (com.sun.star.awt.XButton) UnoRuntime.queryInterface(com.sun.star.awt.XButton.class, xControlRadioButton);
	    xRadioButton.addActionListener(xActionListener);
            Integer ControlKey = new Integer(iControlKey);
            ControlList.put(sName, ControlKey);
            return xRadioButton;
       }

	// Note: The problem with this method is that you cannot make a control invisible if 
	// if this control is on an other step than on the current. Therefor the problem is
       // solved with a hack: just place the control on a step far far away meanwhile
	public void setControlVisible(String ControlName, boolean bisVisible, int iStep){
	try{
	    if (bisVisible)
		assignPropertyToDialogControl(ControlName, "Step", new Integer(iStep));
	    else
		assignPropertyToDialogControl(ControlName, "Step", new Integer(87));
/*	    XControl xControl = xDlgContainer.getControl(ControlName);
	    XWindow xWindow = (XWindow) UnoRuntime.queryInterface(XWindow.class, xControl);
	    xWindow.setVisible(bisVisible); */
	}
	catch(Exception exception)
	{
            exception.printStackTrace(System.out);
        }}
	
	
        public XInterface insertControlModel(String ServiceName, String sName, String[] sProperties, Object[] sValues)
        throws com.sun.star.uno.Exception{
           XInterface xControlModel = (XInterface) MSFDialogModel.createInstance(ServiceName);
           Tools.setUNOPropertyValues(xControlModel, sProperties, sValues);
	   xDlgNames.insertByName(sName, xControlModel);
	   return xControlModel;
        }

	
	public void setFocus(String ControlName){
	    Object oFocusControl = xDlgContainer.getControl(ControlName);
	    XWindow xWindow = (XWindow) UnoRuntime.queryInterface(XWindow.class, oFocusControl);
	xWindow.setFocus();
	}
	
	public static String[] combineListboxList(String sFirstEntry, String[] MainList){
	try{
	    String[] FirstList = new String[] {sFirstEntry};
	    String[] ResultList = new String[MainList.length + 1];
	    System.arraycopy(FirstList, 0, ResultList, 0, 1);
	    System.arraycopy(MainList, 0, ResultList, 1, MainList.length);
	    return ResultList;
	}
	catch(java.lang.Exception jexception ){
	    jexception.printStackTrace(System.out);
	    return null;
	}}
	
	
	public void calculateDialogPosition(Rectangle FramePosSize){
	try{
	    // Todo: check if it would be useful or possible to create a dialog peer, that can be used for the messageboxes to 
	    // maintain modality when they pop up.
	    xWindowPeer = xControl.getPeer();
	    Rectangle CurPosSize = xWindow.getPosSize();
	    int WindowHeight = FramePosSize.Height;
	    int WindowWidth = FramePosSize.Width;
	    int DialogWidth = CurPosSize.Width;
	    int DialogHeight = CurPosSize.Height;	    
	    int iXPos = ((WindowWidth/2) - (DialogWidth/2));
	    int iYPos = ((WindowHeight/2) - (DialogHeight/2));
	    xWindow.setPosSize(iXPos, iYPos, DialogWidth, DialogHeight, com.sun.star.awt.PosSize.POS);	
	}
	catch(Exception exception)
	{
            exception.printStackTrace(System.out);
        }}


	public short executeDialog(Rectangle FramePosSize){
	try{
	    calculateDialogPosition(FramePosSize);
//	    XVclWindowPeer xVclWindowPeer = (XVclWindowPeer) UnoRuntime.queryInterface(XVclWindowPeer.class, xWindowPeer);
//	    xVclWindowPeer.setProperty("AutoMnemonics", new Boolean(true));
            xDialog = (XDialog) UnoRuntime.queryInterface(XDialog.class, xUNODialog);
	    return xDialog.execute();
	}
	catch(Exception exception)
	{
            exception.printStackTrace(System.out);
	    return 0;
        }}

	
	public void setAutoMnemonic(String ControlName, boolean bValue){
	    Object oControl = xDlgContainer.getControl(ControlName);
	    xControl = (XControl) UnoRuntime.queryInterface(XControl.class, oControl);
	    XWindowPeer xWindowPeer = xControl.getPeer();
	    XVclWindowPeer xVclWindowPeer = (XVclWindowPeer) UnoRuntime.queryInterface(XVclWindowPeer.class, xWindowPeer);
	    xVclWindowPeer.setProperty("AutoMnemonics", new Boolean(bValue));
	}
	
	
	public void modifyFontWeight(String ControlName, float FontWeight){
	try{
	    com.sun.star.awt.FontDescriptor oFontDesc = new com.sun.star.awt.FontDescriptor();
	    oFontDesc.Weight = FontWeight;
            assignPropertyToDialogControl(ControlName, "FontDescriptor", oFontDesc);
	}
	catch(Exception exception){
	    exception.printStackTrace(System.out);
	}}
	
	
	public void createWindowPeer(XWindowPeer xWindowPeer){
	try{
	    xWindow.setVisible(false);
	    XInterface xAWTToolkit = (XInterface) xMSF.createInstance("com.sun.star.awt.Toolkit");
	    XToolkit xToolkit = (XToolkit) UnoRuntime.queryInterface(XToolkit.class, xAWTToolkit);
	    xControl.createPeer(xToolkit, xWindowPeer);
	}
	catch(Exception exception){
	    exception.printStackTrace(System.out);
	}}
	
	
	// deletes the first entry when this is equal to "DelEntryName"
	// returns true when a new item is selected
	public void deletefirstListboxEntry(String ListBoxName, String DelEntryName){ //, boolean[] bSelectItem){
	try{
	    XControl xListControl  = xDlgContainer.getControl(ListBoxName);
	    XListBox xListBox = (XListBox) UnoRuntime.queryInterface(XListBox.class, xListControl);
	    String FirstItem = xListBox.getItem((short) 0);
	    if (FirstItem.equals(DelEntryName)){
		short SelPos = xListBox.getSelectedItemPos();
		    xListBox.removeItems((short) 0, (short) 1);
		    if (SelPos > 0){		
//			bSelectItem[0] = true;
			assignPropertyToDialogControl(ListBoxName, "SelectedItems", new short[SelPos]);
			xListBox.selectItemPos((short) (SelPos-1), true);
		    }
	    }
//	    bSelectItem[0] = true;
	}
	catch (Exception exception){
	    exception.printStackTrace(System.out);
	}}
	
	
	public void setPeerProperty(String ControlName, String PropertyName, Object PropertyValue){
	try{
	    Object oControl = xDlgContainer.getControl(ControlName);
	    XControl xControl = (XControl) UnoRuntime.queryInterface(XControl.class, oControl);
	    XWindowPeer xControlPeer = xControl.getPeer();
	    XVclWindowPeer xVclWindowPeer = (XVclWindowPeer) UnoRuntime.queryInterface(XVclWindowPeer.class, xControlPeer);
	    xVclWindowPeer.setProperty(PropertyName, PropertyValue);
	}
	catch(Exception exception){
	    exception.printStackTrace(System.out);
	}}
}
