
/**
 * Title:        Help Content Provider<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Andreas Bille ( abi )<p>
 * Company:      Sun Microsystems. Inc<p>
 * @author Andreas Bille ( abi )
 * @version 1.0
 */
package com.sun.star.help;

import java.net.*;

public final class HelpURLStreamHandlerFactory implements URLStreamHandlerFactory
{
	protected static byte[] _doc = null;
	private String _HelpURLHandler;

	public HelpURLStreamHandlerFactory( String HelpURLHandler )
	{
		_HelpURLHandler = HelpURLHandler;
  		_doc = null;
	}
	
	protected static byte[] getData()
	{
		return _doc;
	}

 	protected static void setMode( byte[] doc )
  	{
		_doc = doc;
   	}

	public URLStreamHandler createURLStreamHandler( String protocol )
 	{
		try
		{
			if( "vnd.sun.star.help".equals( protocol ) )
			{
				if( "with-jars".equals( _HelpURLHandler ) )
				{
					return new HelpURLStreamHandlerWithJars();
				}
				else if( "with-files".equals( _HelpURLHandler ) )
				{
					return new HelpURLStreamHandler();
				}
				else return null;
			}
			else
			{
				Class handlerClass = Class.forName("sun.net.www.protocol." + protocol + ".Handler");
				return (URLStreamHandler) handlerClass.newInstance();
			}
		}
		catch (Exception e)
		{
			System.err.println(e);
			return null;
		}
	}
}

