/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: BlockManagerParameters.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:20:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

import java.io.File;

class BlockManagerParameters extends DBPartParameters {
  private File _file;
  private int _blockSize;
  protected int _root;

  public BlockManagerParameters(Schema schema, String partName)
    throws Exception {
      super(schema, partName);
      _file = schema.indexFile(partName);
      readState();
  }
  
  public boolean readState() {
    if (parametersKnown()) {
      _blockSize = integerParameter("bs");
      _root = integerParameter("rt");
      return true;
    }
    else
      return false;
  }

  public void updateSchema(String params) {
    super.updateSchema("bs="+_blockSize+" rt="+_root+" fl=-1 " + params);
  }

  public BlockManagerParameters(File file, int blockSize, int root) {
    _file = file;
    _blockSize = blockSize;
    _root = root;
  }

  public File getFile() {
    return _file;
  }

  public int getBlockSize() {
    return _blockSize;
  }

  public void setBlockSize(int size) {
    _blockSize = size;
  }

  public int getRootPosition() {
    return _root;
  }

  public void setRoot(int root) {
    _root = root;
  }
}
