/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Schema.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:25:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

import java.io.*;
import java.util.Vector;
import java.util.Hashtable;
import java.util.StringTokenizer;
import com.sun.xmlsearch.util.*;

public final class Schema extends IndexAccessor {
    private static final String PartName = "SCHEMA";
    private boolean _update;
    private Vector _lines = new Vector();

    public Schema(IndexAccessor index, boolean update) throws IOException {
	super(index);
	try {
	    read();
	}
	catch (FileNotFoundException e) {
	    // System.out.println("no existing index found");
	}
	_update = update;
    }
  
    public void update(String partName, String parameters) {
	for (int i = 0; i < _lines.size(); i++)
	    if (((String)_lines.elementAt(i)).startsWith(partName))
		_lines.removeElementAt(i);
	_lines.addElement(partName + " " + parameters);
    }

    public String parametersAsString(String name) {
	for (int i = 0; i < _lines.size(); i++)
	    if (((String)_lines.elementAt(i)).startsWith(name))
		return ((String)_lines.elementAt(i)).substring(name.length() + 1);
	return null;
    }

    public Hashtable parameters(String name) {
	for (int i = 0; i < _lines.size(); i++)
	    if (((String)_lines.elementAt(i)).startsWith(name)) {
		Hashtable result = new Hashtable();
		StringTokenizer tokens =
		    new StringTokenizer((String)_lines.elementAt(i), " =");
		tokens.nextToken();		// skip name
		while (tokens.hasMoreTokens())
		    result.put(tokens.nextToken(), tokens.nextToken());
		return result;
	    }
	return null;
    }

    public FileWriter makeSchemaWriter() throws IOException {
	return makeFileWriter(PartName);
    }

    public void save() {
	if (_update) {
	    try {
		FileWriter out = makeSchemaWriter();
		out.write("JavaSearch 1.0\n");
		for (int i = 0; i < _lines.size(); i++) {
		    out.write((String)_lines.elementAt(i));
		    out.write('\n');
		}
		out.close();
	    }
	    catch (IOException e) {
		System.err.println("SCHEMA save failed " + e);
	    }
	}
    }

    public LineInput getSchemaLineInput() throws FileNotFoundException {
	return getLineInput(PartName);
    }
  
    private void read() throws IOException {
	LineInput in = getSchemaLineInput();
	// This needs to be replaced with our XML Parser
	String line;
	while ((line = in.readLine()) != null)
	    _lines.addElement(line);
	in.close();
    }
}
