/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ConceptData2.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:54:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.xml.ContextTables;

/** ConceptData2 is ConceptData that implements field searching
  with constrained parent type
 */
final class ConceptData2 extends ConceptData {
    private final int _fieldCode;
    private final int _parentCode;
  
    public ConceptData2(int id, int role, double score, int queryNo,
			int nColumns, ContextTables ctxInfo,
			int code, int parentCode) {
	super(id, role, score, queryNo, nColumns, ctxInfo);
	_fieldCode = code;
	_parentCode = parentCode;
    }
  
    public void generateFillers(RoleFiller[] array, final int pos) {
	if (array[_queryNo] != RoleFiller.STOP) {// not 'prohibited'
	    int ancestor = _ctx.firstParentWithCode2(pos,
						     _fieldCode,
						     _parentCode);
	    if (ancestor != -1)
		(new RoleFiller(_nColumns,
				this,
				_role,
				pos,
				ancestor,
				pos + _proximity)).use(array, _queryNo);
	}
	if (_next != null)
	    _next.generateFillers(array, pos);
    }
}
