/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: codeinfo.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:21:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_INFO_CODEINFO_HXX
#define ARY_INFO_CODEINFO_HXX



// USED SERVICES
	// BASE CLASSES
#include <ary/docu.hxx>
	// COMPONENTS
	// PARAMETERS
#include <ary/ids.hxx>
#include <ary/info/inftypes.hxx>
#include <ary/ary_disp.hxx>


namespace ary
{
namespace info
{

class AtTag;

class CodeInfo : public ary::Documentation
{
  public:
	typedef std::vector< DYN AtTag * >	TagList;

	// LIFECYCLE
						CodeInfo();
	virtual				~CodeInfo();

	virtual AtTag *		Create_StdTag(
							E_AtTagId			i_eId );
	virtual AtTag *		CheckIn_BaseTag();
	virtual AtTag *		CheckIn_ExceptionTag();
	virtual AtTag *		Create_ImplementsTag();
	virtual AtTag *		Create_KeywordTag();
	virtual AtTag *		CheckIn_ParameterTag();
	virtual AtTag *		CheckIn_SeeTag();
	virtual AtTag *		CheckIn_TemplateTag();
	virtual AtTag *		Create_LabelTag();
	virtual AtTag *		Create_DefaultTag();
	virtual AtTag *		Create_SinceTag();          /// @return always the first one created.

    virtual void        Replace_AtShort_By_AtDescr();

	virtual void		Set_Obsolete();
	virtual void		Set_Internal();
	virtual void		Set_Interface()         { bIsInterface = true; }

  // INQUIRY
	const TagList &		Tags() const			{ return aTags; }
    const AtTag &       Short() const;
	bool				IsObsolete() const	    { return bIsObsolete; }
    virtual bool        IsInternal() const;
    virtual bool        IsInterface() const;

	static const CodeInfo &
						Null_();
  private:
    // Interface Documentation
	virtual void	   	do_StoreAt(
							Display &			o_rDisplay ) const;
	virtual void		do_Store2(
							info::DocuStore &   o_rDocuStore );

    // DATA
	unsigned char       nTags[C_eAtTag_NrOfClasses];

    /** Creates a new AtTag at the end of aTags.
        The index of this new AtTag is inserted in nTags at position
        i_nIndex.
    */
	AtTag * &			NewTag(
							UINT8				i_nIndex );
    /** Returns the Tag with the position nTags[i_nIndex]
        in aTags.
    */
    AtTag &             GetTag(
							UINT8				i_nIndex );

	TagList				aTags;
	bool				bIsObsolete;
	bool				bIsInternal;
	bool				bIsInterface;
};



// IMPLEMENTATION


}
}

#endif

