/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: undgrgri.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:28:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//svdraw.hxx
//#define _SVDRAW_HXX
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
//#define _SDR_NOOBJECTS
//#define _SDR_NOVIEWS
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV

#pragma hdrstop

#include "schdll.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "undgrgri.hxx"

TYPEINIT1(SchUndoDiagramGrid, SchUndoAttr);


/*************************************************************************
|*
|*
|*
\************************************************************************/

SchUndoDiagramGrid::SchUndoDiagramGrid(ChartModel& rChDoc,
									   UINT16            nId,
									   const SfxItemSet& rOldXMainAttr,
									   const SfxItemSet& rOldYMainAttr,
									   const SfxItemSet& rOldZMainAttr,
									   const SfxItemSet& rOldXHelpAttr,
									   const SfxItemSet& rOldYHelpAttr,
									   const SfxItemSet& rOldZHelpAttr,
									   const SfxItemSet& rOldAttr,
									   const SfxItemSet& rNewAttr) :
	SchUndoAttr(rChDoc, rOldAttr, rNewAttr),
	nGridId(nId),
	pOldXMainAttr (new SfxItemSet (rOldXMainAttr)),
	pOldYMainAttr (new SfxItemSet (rOldYMainAttr)),
	pOldZMainAttr (new SfxItemSet (rOldZMainAttr)),
	pOldXHelpAttr (new SfxItemSet (rOldXHelpAttr)),
	pOldYHelpAttr (new SfxItemSet (rOldYHelpAttr)),
	pOldZHelpAttr (new SfxItemSet (rOldZHelpAttr))
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

SchUndoDiagramGrid::~SchUndoDiagramGrid()
{
	delete pOldXMainAttr;
	delete pOldYMainAttr;
	delete pOldZMainAttr;
	delete pOldXHelpAttr;
	delete pOldYHelpAttr;
	delete pOldZHelpAttr;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoDiagramGrid::Undo()
{
	switch (nGridId)
	{
		case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP :
			rDoc.ChangeGridAttr(*pOldXMainAttr, rDoc.GetChartObj(nGridId), FALSE);
			break;

		case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP :
			rDoc.ChangeGridAttr(*pOldYMainAttr, rDoc.GetChartObj(nGridId), FALSE);
			break;

		case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP :
			rDoc.ChangeGridAttr(*pOldZMainAttr, rDoc.GetChartObj(nGridId), FALSE);
			break;

		case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP :
			rDoc.ChangeGridAttr(*pOldXHelpAttr, rDoc.GetChartObj(nGridId), FALSE);
			break;

		case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP :
			rDoc.ChangeGridAttr(*pOldYHelpAttr, rDoc.GetChartObj(nGridId), FALSE);
			break;

		case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP :
			rDoc.ChangeGridAttr(*pOldZHelpAttr, rDoc.GetChartObj(nGridId), FALSE);
			break;
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoDiagramGrid::Redo()
{
	rDoc.ChangeGridAttr(*pNewAttr, rDoc.GetChartObj(nGridId));
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SchUndoDiagramGrid::CanRepeat(SfxRepeatTarget& rView) const
{
	return FALSE;
}



