/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: salsound.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 11:23:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_SALSOUND_HXX
#define _SV_SALSOUND_HXX

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _VCL_DLLAPI_H
#include "dllapi.h"
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _SV_SALSTYPE_HXX
#include <salstype.hxx>
#endif

class VCL_DLLPUBLIC SalSound
{
	// for notification
	void*					m_pInst;
	SALSOUNDPROC			m_aPROC;
public:
    SalSound() : m_pInst( NULL ), m_aPROC( NULL ) {}
    virtual ~SalSound();
    
    // checks whether sound system is ready for input and hence
    // SalSound can be initialized
    virtual bool		IsValid() = 0;
    // initialize with sound file name, returns success and // FIXME: rSoundLen ?
    virtual bool		Init( const String&	rSoundName,
                              ULONG&		rSoundLen ) = 0;
    // play the sound, start at nStartTime (ms), play for nPlayTime (ms),
	// loop = true/false
   	virtual void		Play( ULONG nStartTime, ULONG nPlayTime, bool bLoop ) = 0;
    // stop playing
	virtual void		Stop() = 0;
    // pause playing
	virtual void		Pause() = 0;
    // continue a paused play
	virtual void		Continue() = 0;
    // is looping ?
    virtual bool		IsLoopMode() const = 0;
    // is playing ?
	virtual bool		IsPlaying() const = 0;
    // is paused ?
    virtual bool		IsPaused() const = 0;

    // register a callback to be called when state changes
	void		SetNotifyProc( void* pInst, SALSOUNDPROC pProc )
    { m_pInst = pInst; m_aPROC = pProc; }
    void		CallNotifyProc( SoundNotification eNotification, ULONG nError )
    {
        if( m_aPROC )
            m_aPROC( m_pInst, eNotification, nError );
    }
};

#endif
