/*
 * TutorialCreator.java
 *
 * Created on 27. M?rz 2003, 10:42
 */
package com.sun.star.wizards.tutorial.creator.frame;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

/**
 * Tutorial creator takes a data vector and creates a macro based on this data vector.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public class TutorialCreator extends JFrame {
    private Framework m_frameWork;
    private String m_tutorialName;
    private JTextArea m_stepTextArea;
    private String m_ident;

    /**
     * Creates a new TutorialCreator object.
     *
     * @param frameWork
     * @param name
     */
    public TutorialCreator(Framework frameWork, String name) {
        m_frameWork = frameWork;
        m_tutorialName = name;
        m_ident = "    ";
        init();
    }

    /**
     * Initilization for the TutorialCreator frame.
     */
    private void init() {
        JPanel contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(15, 15, 1, 15));
        setBounds(200, 70, 600, 600);
        setTitle("TutorialCreator");

        m_stepTextArea = new JTextArea();
        m_stepTextArea.setBackground(new Color(255, 250, 240));
        m_stepTextArea.setEditable(false);

        JScrollPane messageScrollPane = new JScrollPane(m_stepTextArea);
        TitledBorder titel = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), "Tutorial macro");
        messageScrollPane.setBorder(titel);

        JButton create = new JButton("Create");
        JButton cancel = new JButton("Cancel");
        create.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                create();
            }
        });
        cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                cancel();
            }
        });

        JPanel actionPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        actionPanel.add(cancel);
        actionPanel.add(create);

        contentPane.add(messageScrollPane, BorderLayout.CENTER);
        contentPane.add(actionPanel, BorderLayout.SOUTH);
        setTutorialText();
        setVisible(true);
    }

    /**
     * The main purpose consists in closing of the window.
     *
     * @param e e
     */
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);

        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            dispose();
            m_frameWork.showStepFrame(getBounds());
        }
    }

    /**
     * Creates a macro.
     */
    private void create() {
        String result = m_frameWork.createDocumentMacro(this, "Standard", m_tutorialName, m_stepTextArea.getText(), false);
        JOptionPane.showMessageDialog(this, result, "Create Result", JOptionPane.INFORMATION_MESSAGE);
        cancel();
    }

    /**
     * Disposing and finishing.
     */
    private void cancel() {
        dispose();
        m_frameWork.showStepFrame(getBounds());
    }

    /**
     * Sets tutorial text.
     */
    private void setTutorialText() {
        Vector data = m_frameWork.getStepFrame().getModel().getDataVector();

        if (!data.isEmpty()) {
            setMacroHeader();
            setLibraryLoader();
            setMacroProperties();

            Hashtable actions = setMacroText(data);
            setStepActionCheck(actions);
            setMacroActionHeader(actions);

            for (Enumeration e = actions.keys(); e.hasMoreElements();) {
                String key = (String) e.nextElement();
                Vector action = (Vector) actions.get(key);
                setMacroAction(action, key);
            }
        }
    }

    /**
     * Sets macro header.
     */
    private void setMacroHeader() {
        String typ = m_frameWork.getConnectedDocumentTyp();

        //macro header
        String temp = "Sub Main" + m_tutorialName + "\n" + m_ident + "isLoaded()\n" + m_ident + "LoadTutorialDialog(" + m_tutorialName + ", " + '"' + typ + '"' + ")\n" + "End Sub\n";
        m_stepTextArea.append(temp);
    }

    /**
     * Sets macro library.
     */
    private void setLibraryLoader() {
        String temp = "Sub isLoaded()\n" + m_ident + "If GlobalScope.BasicLibraries.isLibraryLoaded(" + '"' + "Tutorials" + '"' + ") = " + '"' + "False" + '"' + " Then\n" + m_ident + m_ident + "GlobalScope.BasicLibraries.LoadLibrary(" + '"' + "Tutorials" + '"' + ")\n" + m_ident + "End If\n" + "End Sub\n";
        m_stepTextArea.append(temp);
    }

    /**
     * Sets macro properties (macro body).
     */
    private void setMacroProperties() {
        //macro header
        String temp = "Function GetProperties() As com.sun.star.beans.NamedValue\n" + m_ident + "Dim properties(3) As new com.sun.star.beans.NamedValue\n" + m_ident + "properties(0).Name = " + '"' + "MacroName" + '"' + "\n" + m_ident + "properties(0).Value = " + '"' + m_tutorialName + '"' + "\n" + m_ident + "properties(1).Name = " + '"' + "ExecuteForm" + '"' + "\n" + m_ident + "properties(1).Value = " + '"' + "Name" + '"' + "\n" + m_ident + "properties(2).Name = " + '"' + "Debug" + '"' + "\n" + m_ident + "properties(2).Value = " + '"' + "False" + '"' + "\n" + m_ident + "properties(3).Name = " + '"' + "Localisation" + '"' + "\n" + m_ident + "properties(3).Value = " + '"' + "False" + '"' + "\n" + m_ident + "GetProperties = properties()\n" + "End Function\n";
        m_stepTextArea.append(temp);
    }

    /**
     * Sets macro text (macro body).
     *
     * @param data
     *
     * @return hashtable
     */
    private Hashtable setMacroText(Vector data) {
        Hashtable tempStepsActions = new Hashtable();

        if (!data.isEmpty()) {
            //macro text
            int size = data.size();
            String temp = "Function LoadText()\n" + m_ident + "Dim LocTutorText(" + (size - 1) + ") as String\n";
            m_stepTextArea.append(temp);

            for (int i = 0; i < size; i++) {
                Vector step = (Vector) data.get(i);
                String stepText = (String) step.get(1);
                Vector actions = (Vector) step.get(2);

                if ((actions != null) && !actions.isEmpty()) {
                    String key = "" + i;
                    tempStepsActions.put(key, actions);
                }

                StringTokenizer st = new StringTokenizer(stepText);
                temp = "";

                while (st.hasMoreTokens()) {
                    if (temp.equals("")) {
                        temp = m_ident + "LocTutorText(" + i + ") = ";
                    } else {
                        temp = m_ident + "LocTutorText(" + i + ") = LocTutorText(" + i + ") & ";
                    }

                    temp += ('"' + st.nextToken("\n") + '"' + " & CHR(13) & CHR(13)\n");
                    m_stepTextArea.append(temp);
                }
            }

            temp = m_ident + "LoadText() = LocTutorText()\n" + "End Function\n";
            m_stepTextArea.append(temp);
        }

        return tempStepsActions;
    }

    /**
     * Sets step actions.
     *
     * @param actions
     */
    private void setStepActionCheck(Hashtable actions) {
        //macro action header
        String temp = "Function ContainsStepAction()\n" + m_ident + "Dim result As Boolean\n" + m_ident + "result = False\n";
        m_stepTextArea.append(temp);

        if (!actions.isEmpty()) {
            temp = m_ident + "Select Case TutorStep\n" + m_ident + m_ident + "Case";

            for (Enumeration e = actions.keys(); e.hasMoreElements();) {
                String key = (String) e.nextElement();
                temp += (" " + key + ",");
            }

            temp = temp.substring(0, temp.length() - 1);
            temp += ("\n" + m_ident + m_ident + m_ident + "result = True\n" + m_ident + "End Select\n");

            m_stepTextArea.append(temp);
        }

        temp = m_ident + "ContainsStepAction = result\n" + "End Function\n";
        m_stepTextArea.append(temp);
    }

    /**
     * Sets macro action headers.
     *
     * @param actions
     */
    private void setMacroActionHeader(Hashtable actions) {
        //macro action header
        String temp = "Sub Action()\n" + m_ident + "Select Case TutorStep\n";
        m_stepTextArea.append(temp);

        for (Enumeration e = actions.keys(); e.hasMoreElements();) {
            String key = (String) e.nextElement();
            temp = m_ident + m_ident + "Case " + key + "\n" + m_ident + m_ident + m_ident + "Step_" + key + "_Action()\n";
            m_stepTextArea.append(temp);
        }

        temp = m_ident + "End Select\n" + "End Sub\n";
        m_stepTextArea.append(temp);
    }

    /**
     * Parses method params.
     *
     * @param params
     *
     * @return parsed params
     */
    private Vector parsParam(String params) {
        Vector vParams = new Vector();
        StringTokenizer st = new StringTokenizer(params);
        String temp;

        while (params.indexOf("/>") > 0) {
            int index = params.indexOf("/>");
            temp = params.substring(1, index);
            vParams.add(temp);
            params = params.substring(index + 2);
        }

        if (!vParams.isEmpty()) {
            temp = (String) vParams.get(0);

            if (temp.indexOf("Path=") == 0) {
                temp = temp.substring(("Path=".length()));

                Vector path = new Vector();
                st = new StringTokenizer(temp);

                while (st.hasMoreTokens()) {
                    temp = st.nextToken(";");
                    path.add(temp);
                }

                vParams.remove(0);
                vParams.add(0, path);
            }
        }

        return vParams;
    }

    /**
     * Sets the action for steps.
     *
     * @param actions
     * @param stepAction
     */
    private void setMacroAction(Vector actions, String stepAction) {
        if (!actions.isEmpty()) {
            String temp = "Sub Step_" + stepAction + "_Action()\n";
            m_stepTextArea.append(temp);

            temp = m_ident + "isLoaded()\n" + m_ident + "Dim commands(" + actions.size() + ") As new com.sun.star.beans.NamedValue\n";
            m_stepTextArea.append(temp);

            //pars actions
            int commandsCount = 0;
            int pathCount = 0;

            temp = m_ident + "commands(0).Name = " + '"' + "Properties" + '"' + "\n" + m_ident + "commands(0).Value = GetProperties()\n";

            m_stepTextArea.append(temp);
            commandsCount = 1; //2

            for (int i = 0; i < actions.size(); i++) {
                Vector action = (Vector) actions.get(i);
                String documentType = (String) action.get(0);
                String methodName = (String) action.get(1);
                String params = (String) action.get(2);

                Vector vParams = parsParam(params);

                //macro actions
                temp = m_ident + "Dim commands" + commandsCount + "(" + (1 + vParams.size()) + ") As new com.sun.star.beans.NamedValue\n" + m_ident + "commands" + commandsCount + "(0).Name = " + '"' + "DocumentTYP" + '"' + "\n" + m_ident + "commands" + commandsCount + "(0).Value = " + '"' + documentType + '"' + "\n" + m_ident + "commands" + commandsCount + "(1).Name = " + '"' + "MethodName" + '"' + "\n" + m_ident + "commands" + commandsCount + "(1).Value = " + '"' + methodName + '"' + "\n";
                m_stepTextArea.append(temp);

                if (!vParams.isEmpty()) {
                    for (int j = 0; j < vParams.size(); j++) {
                        Object obj = vParams.get(j);

                        if (obj instanceof Vector) {
                            Vector path = (Vector) obj;
                            int size = path.size();
                            temp = m_ident + "Dim path" + pathCount + "(" + (size - 1) + ") As String\n";

                            for (int z = 0; z < path.size(); z++) {
                                temp += (m_ident + "path" + pathCount + "(" + z + ") = " + '"' + (String) path.get(z) + '"' + "\n");
                            }

                            temp += (m_ident + "CheckPath(path" + pathCount + "())\n" + m_ident + "commands" + commandsCount + "(" + (j + 2) + ").Name = " + '"' + "Path" + '"' + "\n" + m_ident + "commands" + commandsCount + "(" + (j + 2) + ").Value = path" + pathCount + "()\n");
                            pathCount++;
                        } else {
                            temp = m_ident + "commands" + commandsCount + "(" + (j + 2) + ").Name = " + '"' + "Param" + '"' + "\n" + m_ident + "commands" + commandsCount + "(" + (j + 2) + ").Value = " + '"' + (String) obj + '"' + "\n";
                        }

                        m_stepTextArea.append(temp);
                    }

                    temp = m_ident + "commands(" + commandsCount + ").Name = " + '"' + "commands" + commandsCount + "()" + '"' + "\n" + m_ident + "commands(" + commandsCount + ").Value = commands" + commandsCount + "()\n";

                    m_stepTextArea.append(temp);
                    commandsCount++;
                } else {
                    temp = m_ident + "commands(" + commandsCount + ").Name = " + '"' + "commands" + commandsCount + "()" + '"' + "\n" + m_ident + "commands(" + commandsCount + ").Value = commands" + commandsCount + "()\n";

                    m_stepTextArea.append(temp);
                    commandsCount++;
                }
            }

            temp = m_ident + "Init()\n" + m_ident + "myTutorial.execute(commands())\n";
            m_stepTextArea.append(temp);
            temp = "End Sub\n";
            m_stepTextArea.append(temp);
        }
    }
}
