/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: HelpKeyword.java,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/01/16 12:37:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.star.help;

import java.util.Enumeration;
import java.util.Hashtable;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;

/**
 * @author ab106281
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class HelpKeyword {
	private Hashtable _hash = new Hashtable();

	class Data {
		int pos = 0;
		String[] _idList = new String[5];

		void append(String id) {
			if (pos == _idList.length) {
				String[] buff = _idList;
				_idList = new String[pos + 5];
				for (int i = 0; i < buff.length; ++i)
					_idList[i] = buff[i];
				buff = null;
			}
			_idList[pos++] = id;
		}

		int getLength() {
			return pos;
		}

		String getString() {
			String ret = new String();
			for (int i = 0; i < pos; ++i) {
				ret += (_idList[i] + ";");
			}
			return ret;
		}
	} // end class data

	public void insert(String key, String id) {
		Data data = (Data) _hash.get(key);
		if (data == null) {
			data = new Data();
			_hash.put(key, data);
		}
		data.append(id);
	}

	void dump(Db table) {
		Enumeration enumer = _hash.keys();
		int j = 0;
		String[] list = new String[_hash.size()];
		while (enumer.hasMoreElements()) {
			list[j++] = (String) enumer.nextElement();
		}

		for (int i = 0; i < list.length; ++i) {
			Data data = (Data) _hash.get(list[i]);
			StringDbt key = new StringDbt(list[i]);
			StringDbt value = new StringDbt(data.getString());
			try {
				table.put(null, key, value, 0);
			} catch (DbException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
}
