/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_tplabel.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:21:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// header for SfxItemSet
#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif
// header for SfxInt32Item
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
// header for SfxBoolItem
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif

#include "schattr.hxx"
#define ITEMID_CHARTTEXTORDER	SCHATTR_TEXT_ORDER
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
// header for SvxChartTextOrientItem / SvxChartTextOrderItem
#ifndef _SVX_CHRTITEM_HXX
#include <bf_svx/chrtitem.hxx>
#endif

#include "chtmodel.hxx"
#include "schresid.hxx"
#include "app.hrc"

#include "tplabel.hxx"
#include "tplabel.hrc"
namespace binfilter {

//  #include "strings.hrc"
//  #include "schmod.hxx"

// ====================
// class SchAxisLabelTabPage
// ====================

//STRIP001 SchAxisLabelTabPage::SchAxisLabelTabPage( Window* pParent, const SfxItemSet& rInAttrs ) :
//STRIP001 		SfxTabPage( pParent, SchResId( TP_AXIS_LABEL ), rInAttrs ),
//STRIP001 
//STRIP001 		aCbShowDescription( this, SchResId( CB_AXIS_LABEL_SCHOW_DESCR ) ),
//STRIP001 
//STRIP001 		aWOAngle( this,
//STRIP001 				  SchResId( CT_AXIS_LABEL_DIAL ),
//STRIP001 				  SchResId( PB_AXIS_LABEL_TEXTSTACKED ),
//STRIP001 				  SchResId( FT_AXIS_LABEL_DEGREES ),
//STRIP001 				  SchResId( NF_AXIS_LABEL_ORIENT ),
//STRIP001 				  SchResId( FT_UNUSED ),
//STRIP001 				  SchResId( CT_UNUSED ),
//STRIP001 				  SchResId( FL_AXIS_LABEL_ORIENTATION ) ),
//STRIP001 
//STRIP001 		aFlTextFlow( this, SchResId( FL_AXIS_LABEL_TEXTFLOW ) ),
//STRIP001 		aCbTextOverlap( this, SchResId( CB_AXIS_LABEL_TEXTOVERLAP ) ),
//STRIP001 		aCbTextBreak( this, SchResId( CB_AXIS_LABEL_TEXTBREAK ) ),
//STRIP001 
//STRIP001 		aFlOrder( this, SchResId( FL_AXIS_LABEL_ORDER ) ),
//STRIP001 		aRbSideBySide( this, SchResId( RB_AXIS_LABEL_SIDEBYSIDE ) ),
//STRIP001 		aRbUpDown( this, SchResId( RB_AXIS_LABEL_UPDOWN ) ),
//STRIP001 		aRbDownUp( this, SchResId( RB_AXIS_LABEL_DOWNUP ) ),
//STRIP001 		aRbAuto( this, SchResId( RB_AXIS_LABEL_AUTOORDER ) ),
//STRIP001 
//STRIP001    		aFlSeparator( this, SchResId( FL_SEPARATOR ) ),
//STRIP001 
//STRIP001 		eOrderMode( CHORDMODE_X_AXIS ),
//STRIP001 		bAllowTextOverlap( TRUE ),
//STRIP001 
//STRIP001         m_nInitialDegrees( 0 ),
//STRIP001         m_bInitialStacking( FALSE )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aCbShowDescription.SetClickHdl( LINK( this, SchAxisLabelTabPage, ToggleShowLabel ) );
//STRIP001 
//STRIP001     //	Make the fixed line separator vertical.    
//STRIP001     aFlSeparator.SetStyle (aFlSeparator.GetStyle() | WB_VERT);
//STRIP001 
//STRIP001 	Construct();
//STRIP001 }
//STRIP001 
//STRIP001 SchAxisLabelTabPage::~SchAxisLabelTabPage()
//STRIP001 {}
//STRIP001 
//STRIP001 void SchAxisLabelTabPage::Construct()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 SfxTabPage* SchAxisLabelTabPage::Create( Window* pParent, const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	return new SchAxisLabelTabPage( pParent, rAttrs );
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SchAxisLabelTabPage::FillItemSet( SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	SvxChartTextOrient eOrient;
//STRIP001 	long nDegrees = aWOAngle.GetDegrees() * 100L;
//STRIP001 
//STRIP001     if( nDegrees != m_nInitialDegrees )
//STRIP001     {
//STRIP001         rOutAttrs.Put( SfxInt32Item( SCHATTR_TEXT_DEGREES, nDegrees ) );
//STRIP001     }
//STRIP001 
//STRIP001     BOOL bStacked = aWOAngle.IsStackedTxt();
//STRIP001     if( bStacked != m_bInitialStacking )
//STRIP001     {
//STRIP001         if( aWOAngle.IsStackedTxt() )
//STRIP001         {
//STRIP001             eOrient = CHTXTORIENT_STACKED;
//STRIP001             rOutAttrs.Put( SfxInt32Item( SCHATTR_TEXT_DEGREES, 0 ) );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     if( eOrient != CHTXTORIENT_STACKED )
//STRIP001 	{
//STRIP001 		if( nDegrees == 0L )
//STRIP001 			eOrient = CHTXTORIENT_STANDARD;
//STRIP001 		else if( nDegrees <= 18000L )
//STRIP001 			eOrient = CHTXTORIENT_BOTTOMTOP;
//STRIP001 		else
//STRIP001 			eOrient = CHTXTORIENT_TOPBOTTOM;
//STRIP001 	}
//STRIP001 
//STRIP001 	rOutAttrs.Put( SvxChartTextOrientItem( eOrient ) );
//STRIP001 
//STRIP001 	if( eOrderMode != CHORDMODE_NONE )
//STRIP001 	{
//STRIP001 		SvxChartTextOrder eOrder;
//STRIP001         bool bRadioButtonChecked = true;
//STRIP001 
//STRIP001 		if( aRbUpDown.IsChecked())
//STRIP001 			eOrder = CHTXTORDER_UPDOWN;
//STRIP001 		else if( aRbDownUp.IsChecked())
//STRIP001 			eOrder = CHTXTORDER_DOWNUP;
//STRIP001 		else if( aRbAuto.IsChecked())
//STRIP001 			eOrder = CHTXTORDER_AUTO;
//STRIP001 		else if( aRbSideBySide.IsChecked())
//STRIP001             eOrder = CHTXTORDER_SIDEBYSIDE;
//STRIP001         else
//STRIP001             bRadioButtonChecked = false;
//STRIP001 
//STRIP001         if( bRadioButtonChecked )
//STRIP001             rOutAttrs.Put( SvxChartTextOrderItem( eOrder ));
//STRIP001 	}
//STRIP001 
//STRIP001     if( aCbTextOverlap.GetState() != STATE_DONTKNOW )
//STRIP001         rOutAttrs.Put( SfxBoolItem( SCHATTR_TEXT_OVERLAP, aCbTextOverlap.IsChecked() ) );
//STRIP001     if( aCbTextBreak.GetState() != STATE_DONTKNOW )
//STRIP001         rOutAttrs.Put( SfxBoolItem( SID_TEXTBREAK, aCbTextBreak.IsChecked() ) );
//STRIP001     if( aCbShowDescription.GetState() != STATE_DONTKNOW )
//STRIP001         rOutAttrs.Put( SfxBoolItem( SCHATTR_AXIS_SHOWDESCR, aCbShowDescription.IsChecked() ) );
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 void SchAxisLabelTabPage::Reset( const SfxItemSet& rInAttrs )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pPoolItem = NULL;
//STRIP001     SfxItemState aState = SFX_ITEM_UNKNOWN;
//STRIP001 
//STRIP001     // show description ----------
//STRIP001     aState = rInAttrs.GetItemState( SCHATTR_AXIS_SHOWDESCR, FALSE, &pPoolItem );
//STRIP001     if( aState == SFX_ITEM_DONTCARE )
//STRIP001     {
//STRIP001         aCbShowDescription.EnableTriState( TRUE );
//STRIP001         aCbShowDescription.SetState( STATE_DONTKNOW );
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         aCbShowDescription.EnableTriState( FALSE );
//STRIP001         BOOL bCheck = FALSE;
//STRIP001         if( aState == SFX_ITEM_SET )
//STRIP001             bCheck = static_cast< const SfxBoolItem * >( pPoolItem )->GetValue();
//STRIP001         aCbShowDescription.Check( bCheck );
//STRIP001 
//STRIP001         if( ( aState & SFX_ITEM_DEFAULT ) == 0 )
//STRIP001             aCbShowDescription.Hide();
//STRIP001     }
//STRIP001 
//STRIP001     // Rotation as orient item or in degrees ----------
//STRIP001     BOOL bStacked = FALSE;
//STRIP001     short nDegrees = 0;
//STRIP001 
//STRIP001     // check new degree item
//STRIP001     aState = rInAttrs.GetItemState( SCHATTR_TEXT_DEGREES, FALSE, &pPoolItem );
//STRIP001     if( aState == SFX_ITEM_DONTCARE )
//STRIP001     {
//STRIP001         // tristate for SvxWinOrientation missing
//STRIP001         nDegrees = 0;
//STRIP001     }
//STRIP001     else if( aState == SFX_ITEM_SET )
//STRIP001     {
//STRIP001         nDegrees = static_cast< short >( static_cast< const SfxInt32Item * >( pPoolItem )->GetValue() / 100L );
//STRIP001     }
//STRIP001 
//STRIP001     // check old orientation item
//STRIP001     if( rInAttrs.GetItemState( SCHATTR_TEXT_ORIENT, TRUE, &pPoolItem ) == SFX_ITEM_SET )
//STRIP001 	{
//STRIP001 		SvxChartTextOrient eOrient = static_cast< const SvxChartTextOrientItem * >( pPoolItem )->GetValue();
//STRIP001 		switch( eOrient )
//STRIP001 		{
//STRIP001 			case CHTXTORIENT_AUTOMATIC:
//STRIP001 			case CHTXTORIENT_STANDARD:
//STRIP001 				break;
//STRIP001 			case CHTXTORIENT_TOPBOTTOM:
//STRIP001 				if( !nDegrees )
//STRIP001                     nDegrees = 270;
//STRIP001 				break;
//STRIP001 			case CHTXTORIENT_BOTTOMTOP:
//STRIP001 				if( !nDegrees )
//STRIP001                     nDegrees = 90;
//STRIP001 				break;
//STRIP001 			case CHTXTORIENT_STACKED:
//STRIP001                 bStacked = TRUE;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     aWOAngle.SetDegrees( nDegrees );
//STRIP001     aWOAngle.SetStackedTxt( bStacked );
//STRIP001     m_nInitialDegrees = nDegrees;
//STRIP001     m_bInitialStacking = bStacked;
//STRIP001 
//STRIP001     // Text overlap ----------
//STRIP001     aState = rInAttrs.GetItemState( SCHATTR_TEXT_OVERLAP, FALSE, &pPoolItem );
//STRIP001     if( aState == SFX_ITEM_DONTCARE )
//STRIP001     {
//STRIP001         aCbTextOverlap.EnableTriState( TRUE );
//STRIP001         aCbTextOverlap.SetState( STATE_DONTKNOW );
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         aCbTextOverlap.EnableTriState( FALSE );
//STRIP001         BOOL bCheck = FALSE;
//STRIP001         if( aState == SFX_ITEM_SET )
//STRIP001             bCheck = static_cast< const SfxBoolItem * >( pPoolItem )->GetValue();
//STRIP001         aCbTextOverlap.Check( bCheck );
//STRIP001 
//STRIP001         if( ( aState & SFX_ITEM_DEFAULT ) == 0 )
//STRIP001             aCbTextOverlap.Hide();
//STRIP001     }
//STRIP001 
//STRIP001     // text break ----------
//STRIP001     aState = rInAttrs.GetItemState( SID_TEXTBREAK, FALSE, &pPoolItem );
//STRIP001     if( aState == SFX_ITEM_DONTCARE )
//STRIP001     {
//STRIP001         aCbTextBreak.EnableTriState( TRUE );
//STRIP001         aCbTextBreak.SetState( STATE_DONTKNOW );
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         aCbTextBreak.EnableTriState( FALSE );
//STRIP001         BOOL bCheck = FALSE;
//STRIP001         if( aState == SFX_ITEM_SET )
//STRIP001             bCheck = static_cast< const SfxBoolItem * >( pPoolItem )->GetValue();
//STRIP001         aCbTextBreak.Check( bCheck );
//STRIP001 
//STRIP001         if( ( aState & SFX_ITEM_DEFAULT ) == 0 )
//STRIP001         {
//STRIP001             aCbTextBreak.Hide();
//STRIP001             if( ! aCbTextOverlap.IsVisible() )
//STRIP001                 aFlTextFlow.Hide();
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     // text order ----------
//STRIP001     if( eOrderMode != CHORDMODE_NONE )
//STRIP001     {
//STRIP001         aState = rInAttrs.GetItemState( SCHATTR_TEXT_ORDER, FALSE, &pPoolItem );
//STRIP001         if( aState == SFX_ITEM_SET )
//STRIP001         {
//STRIP001             SvxChartTextOrder eOrder = static_cast< const SvxChartTextOrderItem * >( pPoolItem )->GetValue();
//STRIP001 
//STRIP001             switch( eOrder )
//STRIP001             {
//STRIP001                 case CHTXTORDER_SIDEBYSIDE:
//STRIP001                     aRbSideBySide.Check();
//STRIP001                     break;
//STRIP001                 case CHTXTORDER_UPDOWN:
//STRIP001                     aRbUpDown.Check();
//STRIP001                     break;
//STRIP001                 case CHTXTORDER_DOWNUP:
//STRIP001                     aRbDownUp.Check();
//STRIP001                     break;
//STRIP001                 case CHTXTORDER_AUTO:
//STRIP001                     aRbAuto.Check();
//STRIP001                     break;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     ToggleShowLabel( (void*)0 );	
//STRIP001 }
//STRIP001 
//STRIP001 void SchAxisLabelTabPage::SetOrderMode( OrderMode eMode )
//STRIP001 {
//STRIP001 	eOrderMode = eMode;
//STRIP001 
//STRIP001 	if (eOrderMode == CHORDMODE_NONE)
//STRIP001 	{
//STRIP001 		aRbSideBySide.Hide();
//STRIP001 		aRbUpDown.Hide();
//STRIP001 		aRbDownUp.Hide();
//STRIP001 		aRbAuto.Hide();
//STRIP001 		aFlOrder.Hide();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // event handling routines
//STRIP001 // -----------------------
//STRIP001 
//STRIP001 IMPL_LINK ( SchAxisLabelTabPage, ToggleShowLabel, void *, EMPTYARG )
//STRIP001 {
//STRIP001     BOOL bEnable = ( aCbShowDescription.GetState() != STATE_NOCHECK );
//STRIP001 
//STRIP001 	if( bEnable )
//STRIP001 		aWOAngle.Enable();
//STRIP001 	else
//STRIP001 		aWOAngle.Disable();
//STRIP001 
//STRIP001 	aFlOrder.Enable( bEnable );
//STRIP001 	aRbSideBySide.Enable( bEnable );
//STRIP001 	aRbUpDown.Enable( bEnable );
//STRIP001 	aRbDownUp.Enable( bEnable );
//STRIP001 	aRbAuto.Enable( bEnable );
//STRIP001 
//STRIP001 	aFlTextFlow.Enable( bEnable );
//STRIP001 	aCbTextOverlap.Enable( bEnable );
//STRIP001 	aCbTextBreak.Enable( bEnable );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
}
