/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drawview.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:34:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif

// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTYLE_HXX //autogen
// auto strip #include <svtools/style.hxx>
// auto strip #endif
// auto strip #ifndef _OUTLINER_HXX //autogen
// auto strip #include <bf_svx/outliner.hxx>
// auto strip #endif
// auto strip #ifndef _VIEW3D_HXX //autogen
// auto strip #include <bf_svx/view3d.hxx>
// auto strip #endif
#ifndef _SVXIDS_HRC //autogen
#include <bf_svx/svxids.hrc>
#endif
// auto strip #ifndef _XOUTX_HXX
// auto strip #include <bf_svx/xoutx.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOTEXT_HXX //autogen
// auto strip #include <bf_svx/svdotext.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRAF_HXX //autogen
// auto strip #include <bf_svx/svdograf.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRP_HXX //autogen
// auto strip #include <bf_svx/svdogrp.hxx>
// auto strip #endif
// auto strip #ifndef _SVDORECT_HXX //autogen
// auto strip #include <bf_svx/svdorect.hxx>
// auto strip #endif
// auto strip #ifndef _SFXPOOLITEM_HXX //autogen
// auto strip #include <svtools/poolitem.hxx>
// auto strip #endif
// auto strip #ifndef _EEITEM_HXX //autogen
// auto strip #include <bf_svx/eeitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_BULITEM_HXX //autogen
// auto strip #include <bf_svx/bulitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXITEMPOOL_HXX //autogen
// auto strip #include <svtools/itempool.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_NUMITEM_HXX //autogen
// auto strip #include <bf_svx/numitem.hxx>
// auto strip #endif

// auto strip #ifndef _SFX_WHITER_HXX
// auto strip #include <svtools/whiter.hxx>
// auto strip #endif

#ifndef _SD_STLSHEET_HXX
#include "stlsheet.hxx"
#endif

// auto strip #include <bf_svx/svdoutl.hxx>

#include "glob.hrc"
#include "strings.hrc"

// auto strip #include "sdview.hxx"
// auto strip #include "sdattr.hxx"
#include "drawview.hxx"
#include "drawdoc.hxx"
#include "docshell.hxx"
#include "sdpage.hxx"
#include "drviewsh.hxx"
// auto strip #include "pres.hxx"
// auto strip #include "sdresid.hxx"
// auto strip #include "sdwindow.hxx"
// auto strip #include "unchss.hxx"
// auto strip #include "frmview.hxx"
// auto strip #include "anminfo.hxx"
// auto strip #include "fuslshow.hxx"
//STRIP001 #include "preview.hxx"
// auto strip #include "prevchld.hxx"
namespace binfilter {

using namespace ::com::sun::star;

TYPEINIT1( SdDrawView, SdView );

/*************************************************************************
|*
|* Konstruktor
|* zeigt die erste Seite des Dokuments auf Position 0,0 an;
|* falls noch keine Seite vorhanden ist, wird eine erzeugt
|*
\************************************************************************/

/*N*/ SdDrawView::SdDrawView(SdDrawDocShell* pDocSh, OutputDevice* pOutDev,
/*N*/ 					   SdDrawViewShell* pShell) :
/*N*/ 					   SdView(pDocSh->GetDoc(), pOutDev, pShell),
/*N*/ 					   pDrawViewShell(pShell),
/*N*/ 					   pDocShell(pDocSh),
/*N*/ 					   nPOCHSmph(0),
/*N*/ 					   nPresPaintSmph(0),
/*N*/ 					   pVDev(NULL),
/*N*/ 					   bPixelMode(FALSE),
/*N*/ 					   pSlideShow(NULL),
/*N*/ 					   nMagic(SDDRAWVIEW_MAGIC),
/*N*/ 					   bInAnimation(FALSE),
/*N*/ 					   bActionMode(TRUE)
/*N*/ {
/*N*/ 	SetCurrentObj(OBJ_RECT, SdrInventor);
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SdDrawView::~SdDrawView()
/*N*/ {
/*N*/ 	nMagic = 0;
/*N*/ 	delete pVDev;
/*N*/ 
/*N*/ 	if( pSlideShow )
			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		pSlideShow->Destroy();
/*N*/ }

/*************************************************************************
|*
|* virtuelle Methode von SdrView, wird bei Selektionsaenderung gerufen
|*
\************************************************************************/

/*N*/ void SdDrawView::MarkListHasChanged()
/*N*/ {
/*N*/ 	SdView::MarkListHasChanged();
/*N*/ 
/*N*/ 	if (pDrawViewShell)
/*N*/ 		pDrawViewShell->SelectionHasChanged();
/*N*/ }

/*************************************************************************
|*
|* virtuelle Methode von SdrView, wird bei Modelaenderung gerufen
|*
\************************************************************************/

/*N*/ void SdDrawView::ModelHasChanged()
/*N*/ {
/*N*/ 	SdView::ModelHasChanged();
/*N*/ 
/*N*/ 	// den Gestalter zur Neudarstellung zwingen
/*N*/ 	SfxStyleSheetBasePool* pSSPool = pDoc->GetStyleSheetPool();
/*N*/ 	pSSPool->Broadcast(SfxStyleSheetPoolHint(SFX_STYLESHEETPOOL_CHANGES));
/*N*/ 
/*N*/ 	if (pViewSh)
/*N*/ 	{
/*N*/ 		// falls wir in der Diashow sind und das Gliederungstextobjekt selektiert
/*N*/ 		// ist wird der Gliederungsclone der Diashow aktualisiert
/*N*/ 		FuSlideShow* pFuSlideShow = pSlideShow;
/*N*/ 
/*N*/ 		if (!pFuSlideShow)
/*N*/ 		{
/*N*/ 			pFuSlideShow = pViewSh->GetSlideShow();
/*N*/ 		}
/*N*/ 
/*N*/ 		if (pFuSlideShow)
/*N*/ 		{
				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			SdrRectObj* pLayoutText = pFuSlideShow->GetLayoutText();
//STRIP001 /*?*/ 			if (pLayoutText)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				const SdrMarkList& rMarkList  = GetMarkList();
//STRIP001 /*?*/ 				ULONG			   nMarkCount = rMarkList.GetMarkCount();
//STRIP001 /*?*/ 				ULONG			   nMark;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				for (nMark = 0; nMark < nMarkCount; nMark++ )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SdrObject* pObject = rMarkList.GetMark(nMark)->GetObj();
//STRIP001 /*?*/ 					if (pObject == pLayoutText)
//STRIP001 /*?*/ 						break;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (nMark < nMarkCount) 	// gefunden?
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pFuSlideShow->CreateLayoutClone();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
/*?*/ 		}

/*N*/ 		pDrawViewShell->ModelHasChanged();
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Attribute auf Titel- und Gliederungtext und Hintergrundrechteck einer
|* Masterpage in Vorlagen umlenken, sonst an Basisklasse weitergeben
|*
\************************************************************************/

//STRIP001 BOOL SdDrawView::SetAttributes(const SfxItemSet& rSet,
//STRIP001 											BOOL bReplaceAll)
//STRIP001 {
//STRIP001 	BOOL bOk = FALSE;
//STRIP001 
//STRIP001 	// wird eine Masterpage bearbeitet?
//STRIP001 	if ( pDrawViewShell && pDrawViewShell->GetEditMode() == EM_MASTERPAGE )
//STRIP001 	{
//STRIP001 		SfxStyleSheetBasePool* pStShPool = pDoc->GetStyleSheetPool();
//STRIP001 		SdPage* pPage = (SdPage*)pDrawViewShell->GetActualPage()->GetMasterPage(0);
//STRIP001 		String aLayoutName = pPage->GetName();
//STRIP001 		SdrTextObj* pObject = (SdrTextObj*)GetTextEditObject();
//STRIP001 
//STRIP001 		if (pObject)
//STRIP001 		{
//STRIP001 			// Textedit
//STRIP001 			String aTemplateName(aLayoutName);
//STRIP001 
//STRIP001 			UINT32 nInv = pObject->GetObjInventor();
//STRIP001 
//STRIP001 			if (nInv == SdrInventor)
//STRIP001 			{
//STRIP001 				UINT16 eObjKind = pObject->GetObjIdentifier();
//STRIP001 				PresObjKind ePresObjKind = pPage->GetPresObjKind(pObject);
//STRIP001 
//STRIP001 				if ( ePresObjKind == PRESOBJ_TITLE ||
//STRIP001 				     ePresObjKind == PRESOBJ_NOTES )
//STRIP001 				{
//STRIP001 					// Presentation object (except outline)
//STRIP001 					SfxStyleSheet* pSheet = pPage->GetStyleSheetForPresObj( ePresObjKind );
//STRIP001 					DBG_ASSERT(pSheet, "StyleSheet nicht gefunden");
//STRIP001 
//STRIP001 					SfxItemSet aTempSet( pSheet->GetItemSet() );
//STRIP001 					aTempSet.Put( rSet );
//STRIP001 					aTempSet.ClearInvalidItems();
//STRIP001 
//STRIP001 					// Undo-Action
//STRIP001 					StyleSheetUndoAction* pAction = new StyleSheetUndoAction(pDoc, pSheet, &aTempSet);
//STRIP001 					pDocSh->GetUndoManager()->AddUndoAction(pAction);
//STRIP001 
//STRIP001 					pSheet->GetItemSet().Put(aTempSet);
//STRIP001 					pSheet->Broadcast(SfxSimpleHint(SFX_HINT_DATACHANGED));
//STRIP001 					bOk = TRUE;
//STRIP001 				}
//STRIP001 				else if (eObjKind == OBJ_OUTLINETEXT)
//STRIP001 				{
//STRIP001 					// Presentation object outline
//STRIP001 					OutlinerView* pOV	= GetTextEditOutlinerView();
//STRIP001 					Outliner* pOutliner = pOV->GetOutliner();
//STRIP001 					List*		  pList = (List*)pOV->CreateSelectionList();
//STRIP001 					aTemplateName += String(SdResId(STR_LAYOUT_OUTLINE));
//STRIP001 
//STRIP001 					pOutliner->SetUpdateMode(FALSE);
//STRIP001 					pDocSh->SetWaitCursor( TRUE );
//STRIP001 
//STRIP001 					// Platzhalter durch Vorlagennamen ersetzen
//STRIP001 					String aComment(SdResId(STR_UNDO_CHANGE_PRES_OBJECT));
//STRIP001 					xub_StrLen nPos = aComment.Search( (sal_Unicode)'$' );
//STRIP001 					aComment.Erase(nPos, 1);
//STRIP001 					aComment.Insert( String((SdResId(STR_PSEUDOSHEET_OUTLINE))), nPos);
//STRIP001 					pDocSh->GetUndoManager()->EnterListAction( aComment, String() );
//STRIP001 
//STRIP001 					Paragraph* pPara = (Paragraph*)pList->Last();
//STRIP001 					while (pPara)
//STRIP001 					{
//STRIP001 						ULONG nParaPos = pOutliner->GetAbsPos( pPara );
//STRIP001 						USHORT nDepth = pOutliner->GetDepth( (USHORT) nParaPos );
//STRIP001 						String aName(pPage->GetLayoutName());
//STRIP001 						aName += (sal_Unicode)(' ');
//STRIP001 						aName += String::CreateFromInt32( (sal_Int32)nDepth );
//STRIP001 						SfxStyleSheet* pSheet = (SfxStyleSheet*)pStShPool->Find(aName, SD_LT_FAMILY);
//STRIP001 						DBG_ASSERT(pSheet, "StyleSheet nicht gefunden");
//STRIP001 
//STRIP001 						SfxItemSet aTempSet( pSheet->GetItemSet() );
//STRIP001 						aTempSet.Put( rSet );
//STRIP001 						aTempSet.ClearInvalidItems();
//STRIP001 
//STRIP001 						if( nDepth > 1 && aTempSet.GetItemState( EE_PARA_NUMBULLET ) == SFX_ITEM_ON )
//STRIP001 						{
//STRIP001 							// Kein SvxNumBulletItem in Gliederungsebenen 2 bis 9!
//STRIP001 							aTempSet.ClearItem( EE_PARA_NUMBULLET );
//STRIP001 						}
//STRIP001 
//STRIP001 						// Undo-Action
//STRIP001 						StyleSheetUndoAction* pAction = new StyleSheetUndoAction(pDoc, pSheet, &aTempSet);
//STRIP001 						pDocSh->GetUndoManager()->AddUndoAction(pAction);
//STRIP001 
//STRIP001 						pSheet->GetItemSet().Put(aTempSet);
//STRIP001 						pSheet->Broadcast(SfxSimpleHint(SFX_HINT_DATACHANGED));
//STRIP001 
//STRIP001 						// now also broadcast any child sheets
//STRIP001 						USHORT nChild;
//STRIP001 						for( nChild = nDepth + 1; nChild < 10; nChild++ )
//STRIP001 						{
//STRIP001 							String aName(pPage->GetLayoutName());
//STRIP001 							aName += (sal_Unicode)(' ');
//STRIP001 							aName += String::CreateFromInt32( (sal_Int32)nChild );
//STRIP001 							SfxStyleSheet* pSheet = (SfxStyleSheet*)pStShPool->Find(aName, SD_LT_FAMILY);
//STRIP001 
//STRIP001 							if( pSheet )
//STRIP001 								pSheet->Broadcast(SfxSimpleHint(SFX_HINT_DATACHANGED));
//STRIP001 						}
//STRIP001 
//STRIP001 						pPara = (Paragraph*)pList->Prev();
//STRIP001 
//STRIP001 						if( !pPara && nDepth > 1 &&  rSet.GetItemState( EE_PARA_NUMBULLET ) == SFX_ITEM_ON &&
//STRIP001 						    pOutliner->GetDepth( (USHORT) pOutliner->GetAbsPos( (Paragraph*) pList->First() ) ) > 1 )
//STRIP001 							pPara = pOutliner->GetParagraph( 0 );  // Put NumBulletItem in outline level 1
//STRIP001 					}
//STRIP001 
//STRIP001 					pDocSh->SetWaitCursor( FALSE );
//STRIP001 					pOV->GetOutliner()->SetUpdateMode(TRUE);
//STRIP001 
//STRIP001 					pDocSh->GetUndoManager()->LeaveListAction();
//STRIP001 
//STRIP001 					delete pList;
//STRIP001 					bOk = TRUE;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					bOk = SdView::SetAttributes(rSet, bReplaceAll);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Selection
//STRIP001 			const SdrMarkList& rList = GetMarkList();
//STRIP001 			ULONG nMarkCount		 = rList.GetMarkCount();
//STRIP001 			SdrObject* pObject = NULL;
//STRIP001 			for (ULONG nMark = 0; nMark < nMarkCount; nMark++)
//STRIP001 			{
//STRIP001 				pObject = rList.GetMark(nMark)->GetObj();
//STRIP001 				UINT32 nInv = pObject->GetObjInventor();
//STRIP001 
//STRIP001 				if (nInv == SdrInventor)
//STRIP001 				{
//STRIP001 					UINT16 eObjKind = pObject->GetObjIdentifier();
//STRIP001 					PresObjKind ePresObjKind = pPage->GetPresObjKind(pObject);
//STRIP001 					String aTemplateName(aLayoutName);
//STRIP001 
//STRIP001 					if (ePresObjKind == PRESOBJ_TITLE ||
//STRIP001 						ePresObjKind == PRESOBJ_NOTES ||
//STRIP001 					    ePresObjKind == PRESOBJ_BACKGROUND)
//STRIP001 					{
//STRIP001 						// Presentation object (except outline)
//STRIP001 						SfxStyleSheet* pSheet = pPage->GetStyleSheetForPresObj( ePresObjKind );
//STRIP001 						DBG_ASSERT(pSheet, "StyleSheet not found");
//STRIP001 
//STRIP001 						SfxItemSet aTempSet( pSheet->GetItemSet() );
//STRIP001 						aTempSet.Put( rSet );
//STRIP001 						aTempSet.ClearInvalidItems();
//STRIP001 
//STRIP001 						// Undo-Action
//STRIP001 						StyleSheetUndoAction* pAction = new StyleSheetUndoAction(pDoc, pSheet, &aTempSet);
//STRIP001 						pDocSh->GetUndoManager()->AddUndoAction(pAction);
//STRIP001 
//STRIP001 						pSheet->GetItemSet().Put(aTempSet);
//STRIP001 						pSheet->Broadcast(SfxSimpleHint(SFX_HINT_DATACHANGED));
//STRIP001 						bOk = TRUE;
//STRIP001 					}
//STRIP001 					else if (eObjKind == OBJ_OUTLINETEXT)
//STRIP001 					{
//STRIP001 						// Presentation object outline
//STRIP001 						aTemplateName += String(SdResId(STR_LAYOUT_OUTLINE));
//STRIP001 						for (USHORT nLevel = 9; nLevel > 0; nLevel--)
//STRIP001 						{
//STRIP001 							String aName(pPage->GetLayoutName());
//STRIP001 							aName += (sal_Unicode)(' ');
//STRIP001 							aName += String::CreateFromInt32( (sal_Int32)nLevel );
//STRIP001 							SfxStyleSheet* pSheet = (SfxStyleSheet*)pStShPool->
//STRIP001 												Find(aName, SD_LT_FAMILY);
//STRIP001 							DBG_ASSERT(pSheet, "StyleSheet nicht gefunden");
//STRIP001 
//STRIP001 							SfxItemSet aTempSet( pSheet->GetItemSet() );
//STRIP001 
//STRIP001 							if( nLevel > 1 )
//STRIP001 							{
//STRIP001 								// for all levels over 1, clear all items that will be
//STRIP001 								// hard set to level 1
//STRIP001 								SfxWhichIter aWhichIter(rSet);
//STRIP001 								sal_uInt16 nWhich(aWhichIter.FirstWhich());
//STRIP001 								while( nWhich )
//STRIP001 								{
//STRIP001 									if( SFX_ITEM_ON == rSet.GetItemState( nWhich ) )
//STRIP001 										aTempSet.ClearItem( nWhich );
//STRIP001 									nWhich = aWhichIter.NextWhich();
//STRIP001 								}
//STRIP001 
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								// put the items hard into level one
//STRIP001 								aTempSet.Put( rSet );
//STRIP001 							}
//STRIP001 
//STRIP001 							aTempSet.ClearInvalidItems();
//STRIP001 
//STRIP001 							// Undo-Action
//STRIP001 							StyleSheetUndoAction* pAction = new StyleSheetUndoAction(pDoc, pSheet, &aTempSet);
//STRIP001 							pDocSh->GetUndoManager()->AddUndoAction(pAction);
//STRIP001 
//STRIP001 							pSheet->GetItemSet().Set(aTempSet,false);
//STRIP001 							pSheet->Broadcast(SfxSimpleHint(SFX_HINT_DATACHANGED));
//STRIP001 						}
//STRIP001 
//STRIP001 						// remove all hard set items from shape that are now set in style
//STRIP001 						SfxWhichIter aWhichIter(rSet);
//STRIP001 						sal_uInt16 nWhich(aWhichIter.FirstWhich());
//STRIP001 						while( nWhich )
//STRIP001 						{
//STRIP001 							if( SFX_ITEM_ON == rSet.GetItemState( nWhich ) )
//STRIP001 								pObject->ClearItem( nWhich );
//STRIP001 							nWhich = aWhichIter.NextWhich();
//STRIP001 						}
//STRIP001 
//STRIP001 						bOk = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if(!bOk)
//STRIP001 				bOk = SdView::SetAttributes(rSet, bReplaceAll);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else	// nicht auf der Masterpage
//STRIP001 	{
//STRIP001 		bOk = SdView::SetAttributes(rSet, bReplaceAll);
//STRIP001 	}
//STRIP001 
//STRIP001 	return (bOk);
//STRIP001 }

/*************************************************************************
|*
|* Notify fuer Aenderung der Seitenanordnung
|*
\************************************************************************/

/*N*/ void SdDrawView::SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType,
/*N*/ 								 const SfxHint& rHint, const TypeId& rHintType)
/*N*/ {
/*N*/ 	if ( pDrawViewShell && rHint.ISA(SdrHint) )
/*N*/ 	{
/*N*/ 		SdrHintKind eHintKind = ( (SdrHint&) rHint).GetKind();
/*N*/ 
/*N*/ 		if ( nPOCHSmph == 0 && eHintKind == HINT_PAGEORDERCHG )
/*N*/ 		{
/*N*/ 			pDrawViewShell->ResetActualPage();
/*N*/ 		}
/*N*/ 		else if ( eHintKind == HINT_LAYERCHG || eHintKind == HINT_LAYERORDERCHG )
/*N*/ 		{
/*N*/ 			pDrawViewShell->ResetActualLayer();
/*N*/ 		}
/*N*/ 
/*N*/ 		// #94278# switch to that page when it's not a master page
/*N*/ 		if(HINT_SWITCHTOPAGE == eHintKind)
/*N*/ 		{
/*?*/ 			const SdrPage* pPage = ((const SdrHint&)rHint).GetPage();
/*?*/ 
/*?*/ 			if(pPage && !pPage->IsMasterPage())
/*?*/ 			{
/*?*/ 				if(pDrawViewShell->GetActualPage() != pPage)
/*?*/ 				{
/*?*/ 					sal_uInt16 nPageNum = (pPage->GetPageNum() - 1) / 2; // Sdr --> Sd
/*?*/ 					pDrawViewShell->SwitchPage(nPageNum);
/*?*/ 				}
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	SdView::SFX_NOTIFY(rBC, rBCType, rHint, rHintType);
/*N*/ }

/*************************************************************************
|*
|* PageOrderChangedHint blockieren/freigeben
|*
\************************************************************************/

//STRIP001 void SdDrawView::BlockPageOrderChangedHint(BOOL bBlock)
//STRIP001 {
//STRIP001 	if (bBlock)
//STRIP001 		nPOCHSmph++;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ASSERT(nPOCHSmph, "Zaehlerunterlauf");
//STRIP001 		nPOCHSmph--;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* StyleSheet-Setzen auf der Masterpage abfangen, wenn Praesentationsobjekte
|* selektiert sind
|*
\************************************************************************/

//STRIP001 BOOL SdDrawView::SetStyleSheet(SfxStyleSheet* pStyleSheet, BOOL bDontRemoveHardAttr)
//STRIP001 {
//STRIP001 	BOOL bResult = TRUE;
//STRIP001 
//STRIP001 	// wird eine Masterpage bearbeitet?
//STRIP001 	if (pDrawViewShell && pDrawViewShell->GetEditMode() == EM_MASTERPAGE)
//STRIP001 	{
//STRIP001 		if (IsPresObjSelected(FALSE, TRUE))
//STRIP001 		{
//STRIP001 
//STRIP001 			InfoBox(pDrawViewShell->GetActiveWindow(),
//STRIP001 					String(SdResId(STR_ACTION_NOTPOSSIBLE))).Execute();
//STRIP001 			bResult = FALSE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bResult = SdView::SetStyleSheet(pStyleSheet, bDontRemoveHardAttr);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bResult = SdView::SetStyleSheet(pStyleSheet, bDontRemoveHardAttr);
//STRIP001 	}
//STRIP001 	return bResult;
//STRIP001 }

/*************************************************************************
|*
|* Paint-Methode: das Ereignis wird an die View weitergeleitet
|*
\************************************************************************/

//STRIP001 void SdDrawView::InitRedraw(OutputDevice* pOutDev, const Region& rReg)
//STRIP001 {
//STRIP001 
//STRIP001 	BOOL bMPCache = FALSE;
//STRIP001 
//STRIP001 	if (pViewSh && pViewSh == (SdViewShell*) SfxViewShell::Current() &&
//STRIP001 		pViewSh->GetFrameView()->IsMasterPagePaintCaching() &&
//STRIP001 		pOutDev->GetOutDevType() != OUTDEV_PRINTER)
//STRIP001 	{
//STRIP001 		// Aktive ViewShell
//STRIP001 		bMPCache = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bMPCache )
//STRIP001 	{
//STRIP001 		if( !IsMasterPagePaintCaching() )
//STRIP001 		{
//STRIP001 			SetMasterPagePaintCaching( TRUE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if( IsMasterPagePaintCaching() )
//STRIP001 		{
//STRIP001 			ReleaseMasterPagePaintCache();
//STRIP001 			SetMasterPagePaintCaching( FALSE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bPixelMode)
//STRIP001 	{
//STRIP001 		if (!pVDev)
//STRIP001 		{
//STRIP001 			/******************************************************************
//STRIP001 			* VDev erzeugen
//STRIP001 			******************************************************************/
//STRIP001 			delete pVDev;
//STRIP001 			pVDev = new VirtualDevice(*pOutDev);
//STRIP001 			MapMode aMM(pOutDev->GetMapMode().GetMapUnit());
//STRIP001 			aMM.SetOrigin(Point(0, 0));
//STRIP001 			pVDev->SetMapMode(aMM);
//STRIP001 		}
//STRIP001 
//STRIP001 		/**********************************************************************
//STRIP001 		* Groesse des VDevs auf Seitengroesse setzen
//STRIP001 		**********************************************************************/
//STRIP001 		SdPage* pPage = pDrawViewShell->GetActualPage();
//STRIP001 		Size aPgSize(pPage->GetSize());
//STRIP001 		aPgSize.Width()  -= pPage->GetLftBorder();
//STRIP001 		aPgSize.Width()  -= pPage->GetRgtBorder();
//STRIP001 		aPgSize.Height() -= pPage->GetUppBorder();
//STRIP001 		aPgSize.Height() -= pPage->GetLwrBorder();
//STRIP001 
//STRIP001 		if (aPgSize != pVDev->GetOutputSize())
//STRIP001 		{
//STRIP001 			BOOL bAbort = !pVDev->SetOutputSize(aPgSize);
//STRIP001 			DBG_ASSERT(!bAbort, "VDev nicht korrekt erzeugt");
//STRIP001 
//STRIP001 			if (bAbort)
//STRIP001 			{
//STRIP001 				delete pVDev;
//STRIP001 				pVDev = NULL;
//STRIP001 				SetPixelMode(FALSE);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if (!bPixelMode && pVDev)
//STRIP001 	{
//STRIP001 		delete pVDev;
//STRIP001 		pVDev = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bStandardPaint = TRUE;
//STRIP001 
//STRIP001 	SdDrawDocument* pDoc = pDocShell->GetDoc();
//STRIP001 	if(pDoc && pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS)
//STRIP001 	{
//STRIP001 		/*******************************************************************
//STRIP001 		|* Paint-Event fuer eine Praesentation?
//STRIP001 		\******************************************************************/
//STRIP001 		FuSlideShow* pFuSlideShow = pSlideShow;
//STRIP001 
//STRIP001 		// Paint-Event fuer eine Praesentation im Vollbildmodus oder Fenster?
//STRIP001 		if (!pFuSlideShow && pViewSh)
//STRIP001 		{
//STRIP001 			pFuSlideShow = pViewSh->GetSlideShow();
//STRIP001 		}
//STRIP001 		// Paint-Event fuer das Preview-Fenster?
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SfxViewFrame*	pViewFrm = pDrawViewShell ? pDrawViewShell->GetViewFrame() : NULL;
//STRIP001 			SfxChildWindow* pPreviewChildWindow = pViewFrm ?
//STRIP001 				pViewFrm->GetChildWindow(SdPreviewChildWindow::GetChildWindowId()) : NULL;
//STRIP001 			if (pPreviewChildWindow)
//STRIP001 			{
//STRIP001 				SdPreviewWin* pPreviewWin =
//STRIP001 					(SdPreviewWin*)pPreviewChildWindow->GetWindow();
//STRIP001 				if (pPreviewWin && pPreviewWin->GetDoc() == pDoc)
//STRIP001 					pFuSlideShow = pPreviewWin->GetSlideShow();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if (pFuSlideShow)
//STRIP001 		{
//STRIP001 			OutputDevice* pShowWindow = (OutputDevice*)pFuSlideShow->GetShowWindow();
//STRIP001 			if (pShowWindow == pOutDev ||
//STRIP001 				pFuSlideShow->GetAnimationMode() == ANIMATIONMODE_VIEW)
//STRIP001 			{
//STRIP001 				PresPaint(rReg);
//STRIP001 				bStandardPaint = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	if (bStandardPaint)
//STRIP001 	{
//STRIP001 		if (!bPixelMode)
//STRIP001 		{
//STRIP001 			SdView::InitRedraw(pOutDev, rReg);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			/******************************************************************
//STRIP001 			* Pixelmodus
//STRIP001 			******************************************************************/
//STRIP001 			// Objekte ins VDev zeichnen
//STRIP001 			SdView::InitRedraw(pVDev, rReg);
//STRIP001 
//STRIP001 			// VDev auf Window ausgeben
//STRIP001 			pOutDev->DrawOutDev(Point(), pVDev->GetOutputSize(),
//STRIP001 								Point(), pVDev->GetOutputSize(), *pVDev);
//STRIP001 
//STRIP001 			if (IsShownXorVisible(pOutDev))
//STRIP001 			{
//STRIP001 				// Handles auf Window ausgeben
//STRIP001 				ToggleShownXor(pOutDev, &rReg);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* PaintEvents waehrend der Praesentation erlauben oder auch nicht.
|*
\************************************************************************/

//STRIP001 void  SdDrawView::AllowPresPaint(BOOL bAllowed)
//STRIP001 {
//STRIP001 	if (bAllowed)
//STRIP001 	{
//STRIP001 		DBG_ASSERT(nPresPaintSmph != 0, "Unterlauf im PaintSemaphor");
//STRIP001 		nPresPaintSmph--;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ASSERT(nPresPaintSmph + 1 != 0, "Ueberlauf im PaintSemaphor");
//STRIP001 		nPresPaintSmph++;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Paint-Event waehrend der Praesenation
|*
\************************************************************************/

//STRIP001 void SdDrawView::PresPaint(const Region& rRegion)
//STRIP001 {
//STRIP001 	if (nPresPaintSmph == 0)
//STRIP001 	{
//STRIP001 		FuSlideShow* pFuSlideShow = pSlideShow;
//STRIP001 
//STRIP001 		// Paint-Event fuer eine Praesentation im Vollbildmodus oder Fenster?
//STRIP001 		if (!pFuSlideShow && pViewSh)
//STRIP001 		{
//STRIP001 			pFuSlideShow = pViewSh->GetSlideShow();
//STRIP001 		}
//STRIP001 		// Paint-Event fuer das Preview-Fenster?
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SfxViewFrame*	pViewFrm = pDrawViewShell ? pDrawViewShell->GetViewFrame() : NULL;
//STRIP001 			SfxChildWindow* pPreviewChildWindow = pViewFrm ?
//STRIP001 				pViewFrm->GetChildWindow(SdPreviewChildWindow::GetChildWindowId()) : NULL;
//STRIP001 			if (pPreviewChildWindow)
//STRIP001 			{
//STRIP001 				SdPreviewWin* pPreviewWin =
//STRIP001 					(SdPreviewWin*)pPreviewChildWindow->GetWindow();
//STRIP001 				if (pPreviewWin && pPreviewWin->GetDoc() == pDoc )
//STRIP001 					pFuSlideShow = pPreviewWin->GetSlideShow();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		SdWindow* pWindow = (SdWindow*)GetWin(0);
//STRIP001 
//STRIP001 		BOOL bLivePresentation = FALSE;
//STRIP001 
//STRIP001 		if (pFuSlideShow)
//STRIP001 		{
//STRIP001 			const ULONG nFuslCacheMode = pFuSlideShow->GetMasterPageCacheMode();
//STRIP001 
//STRIP001 			bLivePresentation = pFuSlideShow->IsLivePresentation();
//STRIP001 
//STRIP001 			if( IsMasterPagePaintCaching() && ( nFuslCacheMode != GetMasterPagePaintCacheMode() ) )
//STRIP001 			{
//STRIP001 				if( nFuslCacheMode == SDR_MASTERPAGECACHE_NONE )
//STRIP001 				{
//STRIP001 					ReleaseMasterPagePaintCache();
//STRIP001 					SetMasterPagePaintCaching( FALSE );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					SetMasterPagePaintCaching( TRUE, nFuslCacheMode );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!bLivePresentation || IsShownXorVisible(pWindow))
//STRIP001 		{
//STRIP001 			// Selektionsdarstellung ausblenden
//STRIP001 			HideShownXor(pWindow);
//STRIP001 		}
//STRIP001 
//STRIP001 		if (pFuSlideShow &&
//STRIP001 			(pFuSlideShow->GetAnimationMode() == ANIMATIONMODE_SHOW ||
//STRIP001 			 pFuSlideShow->GetAnimationMode() == ANIMATIONMODE_PREVIEW))
//STRIP001 		{
//STRIP001 			// Schwarzer Hintergrund
//STRIP001 			Point       aPos(pWindow->PixelToLogic(Point(0,0)));
//STRIP001 			Size        aSize(pWindow->GetOutputSize());
//STRIP001 			Rectangle   aRect(aPos, aSize);
//STRIP001 			const Color aBlack(COL_BLACK);
//STRIP001 			const Color aOldColor( pWindow->GetFillColor() );
//STRIP001 			const ULONG nOldDrawMode( pWindow->GetDrawMode() );
//STRIP001 
//STRIP001 			pWindow->SetDrawMode( DRAWMODE_DEFAULT );
//STRIP001 			pWindow->SetFillColor( aBlack );
//STRIP001 			
//STRIP001             pWindow->DrawRect( aRect );
//STRIP001 			
//STRIP001             pWindow->SetFillColor( aOldColor );
//STRIP001 			pWindow->SetDrawMode( nOldDrawMode );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Clipping auf angezeigten Seitenbereich
//STRIP001 		SdrPageView* pPageView = GetPageViewPvNum( 0 );
//STRIP001 
//STRIP001         if( pPageView )
//STRIP001         {
//STRIP001 			// #110325#
//STRIP001 			// in the case that the first page is not yet displayed and there
//STRIP001 			// is a fade effect set on the first page, we don't want to redraw
//STRIP001 			// the page before it is faded in. An indicator that no page is
//STRIP001 			// faded in yet is that GetActualPage() from the slideshow return
//STRIP001 			// null. In that case and if the first page contain a fade effect
//STRIP001 			// we only display the black background and not the page. This
//STRIP001 			// will fade in from the presentation later.
//STRIP001 			bool bAllowPaint = true;
//STRIP001 
//STRIP001 			if( pFuSlideShow && (pFuSlideShow->GetActualPage() == NULL) )
//STRIP001 			{
//STRIP001 				const USHORT nCurPage = pFuSlideShow->GetCurrentPage();
//STRIP001 				SdPage* pCurPage = pDoc->GetSdPage( nCurPage, PK_STANDARD );
//STRIP001 				bAllowPaint = pCurPage && pCurPage->GetFadeEffect() == ::com::sun::star::presentation::FadeEffect_NONE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bAllowPaint )
//STRIP001 			{
//STRIP001 				SdrOutliner& rOutl=pDoc->GetDrawOutliner(NULL);
//STRIP001 				rOutl.SetBackgroundColor( pPageView->GetPage()->GetBackgroundColor(pPageView) );
//STRIP001 
//STRIP001 				const Link aPaintProcLink( LINK( this, SdDrawView, PaintProc ) );
//STRIP001 
//STRIP001 				pWindow->Push( PUSH_CLIPREGION );
//STRIP001 				pWindow->IntersectClipRegion( pPageView->GetPageRect() );
//STRIP001 
//STRIP001 				pPageView->InitRedraw( (USHORT) 0, rRegion, 0, &aPaintProcLink );
//STRIP001 
//STRIP001 				pWindow->Pop();
//STRIP001 			}
//STRIP001 
//STRIP001 		    if( ( bLivePresentation && !IsShownXorVisible( pWindow ) ) || pSlideShow )
//STRIP001 			    ShowShownXor( pWindow );
//STRIP001         }
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Paint-Proc filtert fuer die Praesentation Objekte heraus, die unsichtbar
|* sind oder anders dargestellt werden muessen.
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SdDrawView, PaintProc, SdrPaintProcRec *, pRecord )
//STRIP001 {
//STRIP001 	SdAnimationInfo*    pInfo = pDoc->GetAnimationInfo(pRecord->pObj);
//STRIP001     const ULONG         nOldAntialiasing = pRecord->rOut.GetOutDev()->GetAntialiasing();
//STRIP001 
//STRIP001 	if( !pRecord->pObj->IsEmptyPresObj() )
//STRIP001 	{
//STRIP001 		FuSlideShow* pFuSlideShow = pSlideShow;
//STRIP001 
//STRIP001 		// Paint-Event fuer eine Praesentation im Vollbildmodus oder Fenster?
//STRIP001 		if( !pFuSlideShow && pViewSh )
//STRIP001 			pFuSlideShow = pViewSh->GetSlideShow();
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Paint-Event fuer das Preview-Fenster?
//STRIP001 			SfxViewFrame*	pViewFrm = pDrawViewShell ? pDrawViewShell->GetViewFrame() : NULL;
//STRIP001 			SfxChildWindow* pPreviewChildWindow = pViewFrm ?
//STRIP001 				pViewFrm->GetChildWindow(SdPreviewChildWindow::GetChildWindowId()) : NULL;
//STRIP001 			if (pPreviewChildWindow)
//STRIP001 			{
//STRIP001 				SdPreviewWin* pPreviewWin =
//STRIP001 					(SdPreviewWin*)pPreviewChildWindow->GetWindow();
//STRIP001 				if (pPreviewWin && pPreviewWin->GetDoc() == pDoc)
//STRIP001 					pFuSlideShow = pPreviewWin->GetSlideShow();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		const BOOL	bPreview = pFuSlideShow->GetAnimationMode() == ANIMATIONMODE_PREVIEW;
//STRIP001 		BOOL		bDrawn = FALSE;
//STRIP001 
//STRIP001 		if( bPreview && ( !pInfo || pInfo->bIsShown ) )
//STRIP001 			pFuSlideShow->StopTextOrGraphicAnimation( pRecord->pObj, TRUE );
//STRIP001 
//STRIP001 		if( pInfo && ( pInfo->bInvisibleInPresentation || !pInfo->bIsShown ) )
//STRIP001 			bDrawn = TRUE;
//STRIP001 		else if( pInfo && pInfo->bIsShown )
//STRIP001 		{
//STRIP001 			const BOOL      bLive = pFuSlideShow->IsLivePresentation();
//STRIP001 			const BOOL      bDimmed = pInfo->bDimmed;
//STRIP001 			
//STRIP001 			// in case of a move effect we have to disable antialiasing
//STRIP001 			// (we don't want to use alpha masks for performance reasons)
//STRIP001 			switch( pInfo->eEffect )
//STRIP001 			{
//STRIP001                 case presentation::AnimationEffect_MOVE_FROM_LEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_UPPERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_TOP:
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_RIGHT :
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_BOTTOM:
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_LOWERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_TOP:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_LEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_UPPERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_TOP:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_UPPERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_RIGHT :
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_LOWERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_BOTTOM:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_LOWERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_LEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_UPPERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_TOP:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_UPPERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_RIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_LOWERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_BOTTOM:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_LOWERLEFT:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_LEFT:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_TOP:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_RIGHT:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_BOTTOM:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT:
//STRIP001 				case presentation::AnimationEffect_HORIZONTAL_STRETCH:
//STRIP001 				case presentation::AnimationEffect_VERTICAL_STRETCH:
//STRIP001 				case presentation::AnimationEffect_HORIZONTAL_ROTATE:
//STRIP001 				case presentation::AnimationEffect_VERTICAL_ROTATE:
//STRIP001 				case presentation::AnimationEffect_PATH:
//STRIP001 			    case presentation::AnimationEffect_LASER_FROM_LEFT:
//STRIP001 			    case presentation::AnimationEffect_LASER_FROM_UPPERLEFT:
//STRIP001 			    case presentation::AnimationEffect_LASER_FROM_TOP:
//STRIP001 			    case presentation::AnimationEffect_LASER_FROM_UPPERRIGHT:
//STRIP001 			    case presentation::AnimationEffect_LASER_FROM_RIGHT:
//STRIP001 			    case presentation::AnimationEffect_LASER_FROM_LOWERRIGHT:
//STRIP001 			    case presentation::AnimationEffect_LASER_FROM_BOTTOM:
//STRIP001 			    case presentation::AnimationEffect_LASER_FROM_LOWERLEFT:
//STRIP001 			    {
//STRIP001                 	pRecord->rOut.GetOutDev()->SetAntialiasing( ANTIALIASING_DISABLE_TEXT );
//STRIP001 			    }
//STRIP001 			}
//STRIP001 
//STRIP001 			switch( pInfo->eTextEffect )
//STRIP001 			{
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_LEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_UPPERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_TOP:
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_RIGHT :
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_BOTTOM:
//STRIP001 				case presentation::AnimationEffect_MOVE_FROM_LOWERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_TOP:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_LEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_UPPERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_TOP:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_UPPERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_RIGHT :
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_LOWERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_BOTTOM:
//STRIP001 				case presentation::AnimationEffect_MOVE_TO_LOWERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_LEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_UPPERLEFT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_TOP:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_UPPERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_RIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_LOWERRIGHT:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_BOTTOM:
//STRIP001 				case presentation::AnimationEffect_MOVE_SHORT_TO_LOWERLEFT:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_LEFT:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_TOP:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_RIGHT:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_BOTTOM:
//STRIP001 				case presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT:
//STRIP001 				case presentation::AnimationEffect_HORIZONTAL_STRETCH:
//STRIP001 				case presentation::AnimationEffect_VERTICAL_STRETCH:
//STRIP001 				case presentation::AnimationEffect_HORIZONTAL_ROTATE:
//STRIP001 				case presentation::AnimationEffect_VERTICAL_ROTATE:
//STRIP001 				case presentation::AnimationEffect_PATH:
//STRIP001 		        case presentation::AnimationEffect_LASER_FROM_LEFT:
//STRIP001 		        case presentation::AnimationEffect_LASER_FROM_UPPERLEFT:
//STRIP001 		        case presentation::AnimationEffect_LASER_FROM_TOP:
//STRIP001 		        case presentation::AnimationEffect_LASER_FROM_UPPERRIGHT:
//STRIP001 		        case presentation::AnimationEffect_LASER_FROM_RIGHT:
//STRIP001 		        case presentation::AnimationEffect_LASER_FROM_LOWERRIGHT:
//STRIP001 		        case presentation::AnimationEffect_LASER_FROM_BOTTOM:
//STRIP001 		        case presentation::AnimationEffect_LASER_FROM_LOWERLEFT:
//STRIP001 			    {
//STRIP001                 	pRecord->rOut.GetOutDev()->SetAntialiasing( ANTIALIASING_DISABLE_TEXT );
//STRIP001 			    }
//STRIP001 			}
//STRIP001 			
//STRIP001 			if( pRecord->pObj == pFuSlideShow->GetLayoutText() )
//STRIP001 			{
//STRIP001 				pFuSlideShow->PaintLayoutClone(pRecord->rOut.GetOutDev());
//STRIP001 				bDrawn = TRUE;
//STRIP001 			}
//STRIP001 			else if( pInfo->bIsMovie )
//STRIP001 			{
//STRIP001 				if( bDimmed )
//STRIP001 				{
//STRIP001 					if( !bLive )
//STRIP001 						pFuSlideShow->PaintDimmedObject(((SdrAttrObj*) pRecord->pObj), pRecord->rOut.GetOutDev(), pInfo->aDimColor, TRUE );
//STRIP001 					else
//STRIP001 					   pRecord->pObj->Paint(pRecord->rOut, pRecord->rInfoRec);
//STRIP001 				}
//STRIP001 				else if( bLive )
//STRIP001 				   pRecord->pObj->Paint(pRecord->rOut, pRecord->rInfoRec);
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// nur das letzte Bild
//STRIP001 					SdrObjList* pObjList = ((SdrObjGroup*)pRecord->pObj)->GetSubList();
//STRIP001 					SdrObject* pLast = (SdrObject*)pObjList->GetObj(pObjList->GetObjCount() - 1);
//STRIP001 					pLast->Paint(pRecord->rOut, pRecord->rInfoRec);
//STRIP001 				}
//STRIP001 
//STRIP001 				bDrawn = TRUE;
//STRIP001 			}
//STRIP001 			else if( bDimmed )
//STRIP001 			{
//STRIP001 				pFuSlideShow->PaintDimmedObject(((SdrAttrObj*)pRecord->pObj), pRecord->rOut.GetOutDev(), pInfo->aDimColor, TRUE );
//STRIP001 				bDrawn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !bDrawn )
//STRIP001 		{
//STRIP001 			const BOOL bGrafAnim = OBJIS_GRAFANIM( pRecord->pObj );
//STRIP001 			const BOOL bTextAnim = OBJIS_TEXTANIM( pRecord->pObj );
//STRIP001 
//STRIP001 			// falls es sich um ein animiertes Objekt handelt,
//STRIP001 			// das nicht animiert dargestellt werden soll, muessen
//STRIP001 			// wir ein nicht animiertes Clone-Objekt ausgeben
//STRIP001 			if( !pFuSlideShow->IsAnimationAllowed() && ( bGrafAnim || bTextAnim ) )
//STRIP001 			{
//STRIP001 				SdrObject* pClone = pRecord->pObj->Clone();
//STRIP001 
//STRIP001 				if( bGrafAnim )
//STRIP001 					( (SdrGrafObj*) pClone )->SetGraphic( ( (SdrGrafObj*) pRecord->pObj )->GetTransformedGraphic().GetBitmapEx() );
//STRIP001 
//STRIP001 				if( bTextAnim )
//STRIP001 				{
//STRIP001 					SfxItemSet aTempAttr( pDoc->GetPool(), SDRATTR_TEXT_ANIKIND, SDRATTR_TEXT_ANIKIND );
//STRIP001 					aTempAttr.InvalidateItem( SDRATTR_TEXT_ANIKIND );
//STRIP001 					aTempAttr.Put( SdrTextAniKindItem() );
//STRIP001 
//STRIP001 //-/					pClone->NbcSetAttributes( aTempAttr, FALSE );
//STRIP001 					pClone->SetItemSet(aTempAttr);
//STRIP001 				}
//STRIP001 
//STRIP001 				pClone->Paint( pRecord->rOut, pRecord->rInfoRec );
//STRIP001 				delete pClone;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pRecord->pObj->Paint( pRecord->rOut, pRecord->rInfoRec );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	// das Hintergrundrechteck gibt sich faelschlicherweise als EmptyPresObj
//STRIP001 	// aus, das kann auch nicht geaendert werden, da es sonst von anderen
//STRIP001 	// Methoden nicht erkannt wird und neue Hintergrundrechtecke erzeugt
//STRIP001 	// werden --> sieht aus wie n-faches Redraw des Hintergrunds
//STRIP001 	// (siehe auch FuSlideShow::PaintProc)
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SdPage* pPage = (SdPage*)pRecord->pObj->GetPage();
//STRIP001 
//STRIP001 		if( ( pPage->GetPresObj(PRESOBJ_BACKGROUND) == pRecord->pObj ) ||
//STRIP001             ( ANIMATIONMODE_PREVIEW == eAnimationMode ) )
//STRIP001         {
//STRIP001 	        pRecord->pObj->Paint(pRecord->rOut, pRecord->rInfoRec);
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001     pRecord->rOut.GetOutDev()->SetAntialiasing( nOldAntialiasing );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|* entscheidet, ob ein Objekt markiert werden kann (z. B. noch nicht
|* erschienene Animationsobjekte in der Diashow)
\************************************************************************/

//STRIP001 BOOL SdDrawView::IsObjMarkable(SdrObject* pObj, SdrPageView* pPV) const
//STRIP001 {
//STRIP001 	// erstmal die DrawingEngine pruefen lassen (gesperrter oder unsichtbarer
//STRIP001 	// Layer usw.)
//STRIP001 	BOOL bResult = FmFormView::IsObjMarkable(pObj, pPV);
//STRIP001 
//STRIP001 	// wenn die DrawingEngine ihr OK gibt, pruefen wir noch nach weiteren
//STRIP001 	// Kriterien, die sie nicht kennen kann;
//STRIP001 	// dies ist nur fuer die Praesentation interessant (pViewSh != NULL);
//STRIP001 	// in der Preview kann sowieso niemand selektieren
//STRIP001 	if (bResult && pViewSh)
//STRIP001 	{
//STRIP001 		FuSlideShow* pFuSlideShow = pSlideShow;
//STRIP001 
//STRIP001 		// Paint-Event fuer eine Praesentation im Vollbildmodus oder Fenster?
//STRIP001 		if (!pFuSlideShow && pViewSh)
//STRIP001 		{
//STRIP001 			pFuSlideShow = pViewSh->GetSlideShow();
//STRIP001 		}
//STRIP001 
//STRIP001 		if (pFuSlideShow)
//STRIP001 		{
//STRIP001 			SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObj);
//STRIP001 			if (pInfo)
//STRIP001 			{
//STRIP001 				if (!pInfo->bIsShown)
//STRIP001 					bResult = FALSE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if (pObj->IsEmptyPresObj())
//STRIP001 					bResult = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bResult;
//STRIP001 }

/*************************************************************************
|*
|* Pixelmodus ein- oder ausschalten
|*
\************************************************************************/

//STRIP001 void SdDrawView::SetPixelMode(BOOL bOn)
//STRIP001 {
//STRIP001 	if (bPixelMode != bOn)
//STRIP001 	{
//STRIP001 		bPixelMode = bOn;
//STRIP001 
//STRIP001 		// Sollte der Pixelmode mal aktiv werden, sollte die FieldUnit nicht
//STRIP001 		// mehr von der SFX_APP sondern mit SD_MOD()->GetOptions()->GetMetric()
//STRIP001 		// besorgt werden (SOLL 364 i) !!!
//STRIP001 
//STRIP001 		/**********************************************************************
//STRIP001 		* Default-Units
//STRIP001 		**********************************************************************/
//STRIP001 		MapUnit eMapUnit = MAP_100TH_MM;
//STRIP001 		FieldUnit eFieldUnit = FUNIT_100TH_MM;
//STRIP001 		SfxMapUnit eSfxMapUnit = SFX_MAPUNIT_100TH_MM;
//STRIP001 
//STRIP001 		if (bPixelMode)
//STRIP001 		{
//STRIP001 			/******************************************************************
//STRIP001 			* Units fuer Pixelmodus
//STRIP001 			******************************************************************/
//STRIP001 			eMapUnit = MAP_PIXEL;
//STRIP001 			eFieldUnit = FUNIT_CUSTOM;      // Pixel gibt es noch nicht
//STRIP001 			eSfxMapUnit = SFX_MAPUNIT_PIXEL;
//STRIP001 		}
//STRIP001 
//STRIP001 		/**********************************************************************
//STRIP001 		* Units setzen
//STRIP001 		**********************************************************************/
//STRIP001 		pDoc->SetScaleUnit(eMapUnit);
//STRIP001 		pDoc->SetUIUnit(eFieldUnit);
//STRIP001 		pDoc->GetItemPool().SetDefaultMetric(eSfxMapUnit);
//STRIP001 
//STRIP001 		MapMode aMapMode = pDocSh->GetFrame()->GetWindow().GetMapMode();
//STRIP001 		aMapMode.SetMapUnit(eMapUnit);
//STRIP001 		pDocSh->GetFrame()->GetWindow().SetMapMode(aMapMode);
//STRIP001 
//STRIP001 		for (USHORT nWin = 0; nWin < GetWinCount(); nWin++)
//STRIP001 		{
//STRIP001 			OutputDevice* pOutDev = GetWin(nWin);
//STRIP001 
//STRIP001 			if (pOutDev && pOutDev->GetOutDevType() == OUTDEV_WINDOW)
//STRIP001 			{
//STRIP001 				MapMode aSrcMapMode = pOutDev->GetMapMode();
//STRIP001 //                MapUnit aSrcMapUnit = aSrcMapMode.GetMapUnit();
//STRIP001 //
//STRIP001 //                Point aOrigin = pOutDev->LogicToLogic(aSrcMapMode.GetOrigin(),
//STRIP001 //                                                      aSrcMapUnit, eMapUnit);
//STRIP001 //                Fraction aScaleX = pOutDev->LogicToLogic(aSrcMapMode.GetScaleX(),
//STRIP001 //                                                         aSrcMapUnit, eMapUnit);
//STRIP001 //                Fraction aScaleY = pOutDev->LogicToLogic(aSrcMapMode.GetScaleY(),
//STRIP001 //                                                         aSrcMapUnit, eMapUnit);
//STRIP001 //                aSrcMapMode.SetOrigin(aOrigin);
//STRIP001 //                aSrcMapMode.SetScaleX(aScaleX);
//STRIP001 //                aSrcMapMode.SetScaleY(aScaleY);
//STRIP001 
//STRIP001 				aSrcMapMode.SetMapUnit(eMapUnit);
//STRIP001 				pOutDev->SetMapMode(aSrcMapMode);
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		/**********************************************************************
//STRIP001 		* Windows initialisieren und auf Seitengoesse zoomen
//STRIP001 		**********************************************************************/
//STRIP001 		Size aPageSize = pDrawViewShell->GetActualPage()->GetSize();
//STRIP001 		Point aPageOrg = Point(aPageSize.Width(), aPageSize.Height() / 2);
//STRIP001 		Size aViewSize = Size(aPageSize.Width() * 3, aPageSize.Height() * 2);
//STRIP001 		pViewSh->InitWindows(aPageOrg, aViewSize, Point(-1, -1));
//STRIP001 		pViewSh->GetViewFrame()->GetDispatcher()->Execute(SID_SIZE_PAGE);
//STRIP001 	}
//STRIP001 }



/*************************************************************************
|*
|* Uebergebenen Bereich sichtbar machen (es wird ggf. gescrollt)
|*
\************************************************************************/

//STRIP001 void SdDrawView::MakeVisible(const Rectangle& rRect, Window& rWin)
//STRIP001 {
//STRIP001 	if (!rRect.IsEmpty())
//STRIP001 	{
//STRIP001 		pDrawViewShell->MakeVisible(rRect, rWin);
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Animations-Modus starten
|*
\************************************************************************/

//STRIP001 void SdDrawView::SetAnimationMode(BOOL bStart)
//STRIP001 {
//STRIP001 	if (!pSlideShow || !bStart || pDrawViewShell->GetEditMode() != EM_MASTERPAGE)
//STRIP001 	{
//STRIP001 		// Verhindern, dass im EM_MASTERPAGE die Show mehrfach gestartet wird
//STRIP001 
//STRIP001 		if( pSlideShow )
//STRIP001 		{
//STRIP001 			SdWindow*       pWindow = (SdWindow*) GetWin( 0 );
//STRIP001 			const MapMode   aMapMode( pWindow->GetMapMode() );
//STRIP001 
//STRIP001 			pSlideShow->Destroy();
//STRIP001 			pSlideShow = NULL;
//STRIP001 			
//STRIP001             pWindow->SetMapMode( aMapMode );
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bStart)
//STRIP001 		{
//STRIP001 			// Aktuelle Einstellungen merken
//STRIP001 			pViewSh->WriteFrameViewData();
//STRIP001 
//STRIP001 			// SlideShow erzeugen
//STRIP001 			SfxAllItemSet aSet(pDoc->GetItemPool());
//STRIP001 			{
//STRIP001 			SfxBoolItem aBitem(ATTR_PRESENT_ALL, FALSE);
//STRIP001 			aSet.Put(aBitem, aBitem.Which());
//STRIP001 			}
//STRIP001 			SdPage* pPage = (SdPage*) GetPageViewPvNum(0)->GetPage();
//STRIP001 			SfxStringItem aSitem(ATTR_PRESENT_DIANAME, pPage->GetName());
//STRIP001 			aSet.Put(aSitem, aSitem.Which());
//STRIP001 			{
//STRIP001 			SfxBoolItem aBitem(ATTR_PRESENT_ENDLESS, FALSE);
//STRIP001 			aSet.Put(aBitem, aBitem.Which());
//STRIP001 			}
//STRIP001 			{
//STRIP001 			SfxBoolItem aBitem(ATTR_PRESENT_MANUEL, TRUE);
//STRIP001 			aSet.Put(aBitem, aBitem.Which());
//STRIP001 			}
//STRIP001 			{
//STRIP001 			SfxBoolItem aBitem(ATTR_PRESENT_MOUSE, TRUE);
//STRIP001 			aSet.Put(aBitem, aBitem.Which());
//STRIP001 			}
//STRIP001 			{
//STRIP001 			SfxBoolItem aBitem(ATTR_PRESENT_PEN, FALSE);
//STRIP001 			aSet.Put(aBitem, aBitem.Which());
//STRIP001 			}
//STRIP001 			{
//STRIP001 			SfxBoolItem aBitem(ATTR_PRESENT_NAVIGATOR, FALSE);
//STRIP001 			aSet.Put(aBitem, aBitem.Which());
//STRIP001 			}
//STRIP001 			{
//STRIP001 			SfxBoolItem aBitem(ATTR_PRESENT_CHANGE_PAGE, TRUE);
//STRIP001 			aSet.Put(aBitem, aBitem.Which());
//STRIP001 			}
//STRIP001 			{
//STRIP001 			SfxBoolItem aBitem(ATTR_PRESENT_ALWAYS_ON_TOP, FALSE);
//STRIP001 			aSet.Put(aBitem, aBitem.Which());
//STRIP001 			}
//STRIP001 			{
//STRIP001 			SfxBoolItem aBitem(ATTR_PRESENT_FULLSCREEN, FALSE);
//STRIP001 			aSet.Put(aBitem, aBitem.Which());
//STRIP001 			}
//STRIP001 			{
//STRIP001 			SfxBoolItem aBitem(ATTR_PRESENT_ANIMATION_ALLOWED, TRUE);
//STRIP001 			aSet.Put(aBitem, aBitem.Which());
//STRIP001 			}
//STRIP001 			{
//STRIP001 			SfxUInt32Item aUInt32Item(ATTR_PRESENT_PAUSE_TIMEOUT, 0);
//STRIP001 			aSet.Put(aUInt32Item, aUInt32Item.Which());
//STRIP001 			}
//STRIP001 			{
//STRIP001 			SfxBoolItem aBitem(ATTR_PRESENT_SHOW_PAUSELOGO, FALSE);
//STRIP001 			aSet.Put(aBitem, aBitem.Which());
//STRIP001 			}
//STRIP001 
//STRIP001 			SfxRequest aReq(SID_PRESENTATION, 0, aSet);
//STRIP001 			pSlideShow = new FuSlideShow(NULL, NULL, this, pDoc, aReq);
//STRIP001 
//STRIP001 			// SlideShow starten und aktuellen MapMode setzen
//STRIP001 			SdWindow* pWindow = (SdWindow*) GetWin(0);
//STRIP001 			MapMode aMapMode = pWindow->GetMapMode();
//STRIP001 			pSlideShow->SetAnimationMode(ANIMATIONMODE_VIEW, (SdShowWindow*) pWindow);  // CAST IST FALSCH!
//STRIP001 			pSlideShow->StartShow();
//STRIP001             pSlideShow->Resize( pWindow->GetOutputSizePixel() );
//STRIP001 			pWindow->SetMapMode(aMapMode);
//STRIP001 		}
//STRIP001 		else if (pViewSh)
//STRIP001 		{
//STRIP001 			// Einstellungen restaurieren
//STRIP001 			pViewSh->ReadFrameViewData(pViewSh->GetFrameView());
//STRIP001 		}
//STRIP001 
//STRIP001 		SdWindow* pWindow = (SdWindow*) GetWin(0);
//STRIP001 		pWindow->Invalidate();
//STRIP001 		pWindow->Update();
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Objekt animieren
|*
\************************************************************************/

//STRIP001 void SdDrawView::HideAndAnimateObject(SdrObject* pObj)
//STRIP001 {
//STRIP001 	if (pSlideShow && !bInAnimation)
//STRIP001 	{
//STRIP001 		bInAnimation = TRUE;
//STRIP001 		SetAnimationEnabled(FALSE);
//STRIP001 
//STRIP001 		pSlideShow->HideAndAnimateObject(pObj);
//STRIP001 
//STRIP001 		// im Reschedule des Effekts zerstoert?
//STRIP001 		if (nMagic != SDDRAWVIEW_MAGIC)
//STRIP001 		{
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 		SetAnimationEnabled(TRUE);
//STRIP001 		bInAnimation = FALSE;
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Seite animieren
|*
\************************************************************************/

//STRIP001 void SdDrawView::AnimatePage()
//STRIP001 {
//STRIP001 	if (pSlideShow && !bInAnimation)
//STRIP001 	{
//STRIP001 		bInAnimation = TRUE;
//STRIP001 		SetAnimationEnabled(FALSE);
//STRIP001 
//STRIP001 		pSlideShow->AnimatePage();
//STRIP001 
//STRIP001 		// im Reschedule des Effekts zerstoert?
//STRIP001 		if (nMagic != SDDRAWVIEW_MAGIC)
//STRIP001 		{
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 		SetAnimationEnabled(TRUE);
//STRIP001 		bInAnimation = FALSE;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Seite wird gehided
|*
\************************************************************************/

/*N*/ void SdDrawView::HidePage(SdrPageView* pPV)
/*N*/ {
/*N*/ 	if (pDrawViewShell)
/*N*/ 	{
/*N*/ 		pDrawViewShell->HidePage(pPV);
/*N*/ 	}
/*N*/ 
/*N*/ 	SdView::HidePage(pPV);
/*N*/ }

//STRIP001 SdrObject* SdDrawView::GetMaxToBtmObj(SdrObject* pObj) const
//STRIP001 {
//STRIP001 	if( pObj )
//STRIP001 	{
//STRIP001 		SdPage* pPage = (SdPage*)pObj->GetPage();
//STRIP001 		if( pPage && pPage->IsMasterPage() )
//STRIP001 			return pPage->GetPresObj( PRESOBJ_BACKGROUND ) ;
//STRIP001 	}
//STRIP001 	return NULL;
//STRIP001 }


}
