/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_tabcontr.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:46:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SVDLAYER_HXX
// auto strip #include <bf_svx/svdlayer.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif

#pragma hdrstop

// auto strip #include "sdattr.hxx"
// auto strip #include "app.hxx"
// auto strip #include "tabcontr.hxx"
#include "app.hrc"
#include "glob.hrc"
#include "res_bmp.hrc"
// auto strip #include "drviewsh.hxx"
#include "grviewsh.hxx"
#include "helpids.h"
// auto strip #include "sdview.hxx"
// auto strip #include "sdpage.hxx"
// auto strip #include "drawdoc.hxx"
// auto strip #include "sdwindow.hxx"
// auto strip #include "unmodpg.hxx"
// auto strip #include "docshell.hxx"
// auto strip #include "sdresid.hxx"
namespace binfilter {


#define SWITCH_TIMEOUT	20

// -----------------------------------------
// - SdTabControl::SdPageObjsTransferable -
// -----------------------------------------

//STRIP001 SdTabControl::SdTabControlTransferable::~SdTabControlTransferable()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdTabControl::SdTabControlTransferable::AddSupportedFormats()
//STRIP001 {
//STRIP001 	AddFormat( SOT_FORMATSTR_ID_STARDRAW_TABBAR );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 sal_Bool SdTabControl::SdTabControlTransferable::GetData( const ::com::sun::star::datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001 	return sal_False;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdTabControl::SdTabControlTransferable::DragFinished( sal_Int8 nDropAction )
//STRIP001 {
//STRIP001 	mrParent.DragFinished( nDropAction );
//STRIP001 }

/*************************************************************************
|*
|* Standard-Konstruktor
|*
\************************************************************************/

/*N*/ SdTabControl::SdTabControl(SdDrawViewShell* pViewSh, Window* pParent) :
/*N*/ 	TabBar( pParent, WinBits( WB_BORDER | WB_3DLOOK | WB_SCROLL | WB_SIZEABLE | WB_DRAG) ),
/*N*/ 	DragSourceHelper( this ),
/*N*/ 	DropTargetHelper( this ),
/*N*/ 	pDrViewSh(pViewSh),
/*N*/ 	bInternalMove(FALSE)
/*N*/ {
/*N*/ 	EnableEditMode();
/*N*/ 	SetSizePixel(Size(0, 0));
/*N*/ 	SetMaxPageWidth( 150 );
/*N*/     SetHelpId( HID_SD_TABBAR_PAGES );
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SdTabControl::~SdTabControl()
/*N*/ {
/*N*/ }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SdTabControl::Select()
//STRIP001 {
//STRIP001 	SfxDispatcher* pDispatcher = pDrViewSh->GetViewFrame()->GetDispatcher();
//STRIP001 	pDispatcher->Execute(SID_SWITCHPAGE, SFX_CALLMODE_ASYNCHRON |
//STRIP001 							SFX_CALLMODE_RECORD);
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void  SdTabControl::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	// eine saubere linke Maustaste ohne verwaessernde Modifier (damit koennte
//STRIP001 	//ja das Kontextmenue gemeint sein)
//STRIP001 	if ( rMEvt.IsLeft() && !rMEvt.IsMod1() && !rMEvt.IsMod2() && !rMEvt.IsShift())
//STRIP001 	{
//STRIP001 		Point aPos = PixelToLogic( rMEvt.GetPosPixel() );
//STRIP001 		USHORT aPageId = GetPageId(aPos);
//STRIP001 
//STRIP001 		if (aPageId == 0)
//STRIP001 		{
//STRIP001 			SfxDispatcher* pDispatcher = pDrViewSh->GetViewFrame()->GetDispatcher();
//STRIP001 
//STRIP001 			pDispatcher->Execute(SID_INSERTPAGE_QUICK,
//STRIP001 								SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     // A single left click with pressed control key on a tab page first
//STRIP001     // switches to that page before the usual handling (copying with drag
//STRIP001     // and drop) takes place.
//STRIP001 	else if (rMEvt.IsLeft() && rMEvt.IsMod1() && !rMEvt.IsMod2() && !rMEvt.IsShift())
//STRIP001     {
//STRIP001         pDrViewSh->SwitchPage (GetPageId (rMEvt.GetPosPixel()) - 1);
//STRIP001     }
//STRIP001 
//STRIP001 
//STRIP001 	TabBar::MouseButtonDown(rMEvt);
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SdTabControl::DoubleClick()
//STRIP001 {
//STRIP001 	if (GetCurPageId() != 0)
//STRIP001 	{
//STRIP001 		SfxDispatcher* pDispatcher = pDrViewSh->GetViewFrame()->GetDispatcher();
//STRIP001 		pDispatcher->Execute( SID_MODIFYPAGE,
//STRIP001 						SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* StartDrag-Request
|*
\************************************************************************/

//STRIP001 void SdTabControl::StartDrag( sal_Int8 nAction, const Point& rPosPixel )
//STRIP001 {
//STRIP001 	bInternalMove = TRUE;
//STRIP001 
//STRIP001 	// object is delete by reference mechanismn
//STRIP001 	( new SdTabControl::SdTabControlTransferable( *this ) )->StartDrag( this, DND_ACTION_COPYMOVE );
//STRIP001 }

/*************************************************************************
|*
|* DragFinished
|*
\************************************************************************/

//STRIP001 void SdTabControl::DragFinished( sal_Int8 nDropAction )
//STRIP001 {
//STRIP001 	bInternalMove = FALSE;
//STRIP001 }

/*************************************************************************
|*
|* AcceptDrop-Event
|*
\************************************************************************/

//STRIP001 sal_Int8 SdTabControl::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( rEvt.mbLeaving )
//STRIP001 		EndSwitchPage();
//STRIP001 
//STRIP001 	if( !pDrViewSh->GetDocSh()->IsReadOnly() )
//STRIP001 	{
//STRIP001 		SdDrawDocument* pDoc = pDrViewSh->GetDoc();
//STRIP001 		Point			aPos( rEvt.maPosPixel );
//STRIP001 
//STRIP001 		if( bInternalMove )
//STRIP001 		{
//STRIP001 			if( rEvt.mbLeaving || ( pDrViewSh->GetEditMode() == EM_MASTERPAGE ) )
//STRIP001 				HideDropPos();
//STRIP001 			else
//STRIP001 			{
//STRIP001 				ShowDropPos( aPos );
//STRIP001 				nRet = rEvt.mnAction;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			HideDropPos();
//STRIP001 
//STRIP001 			USHORT nPageId = GetPageId( aPos ) - 1;
//STRIP001 
//STRIP001 			if( ( nPageId >= 0 ) && pDoc->GetPage( nPageId ) )
//STRIP001 			{
//STRIP001 				SdWindow* pWindow = NULL;
//STRIP001 
//STRIP001 				nRet = pDrViewSh->AcceptDrop( rEvt, *this, NULL, nPageId, SDRLAYER_NOTFOUND );
//STRIP001 				SwitchPage( aPos );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

/*************************************************************************
|*
|* ExecuteDrop-Event
|*
\************************************************************************/

//STRIP001 sal_Int8 SdTabControl::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	SdDrawDocument* pDoc = pDrViewSh->GetDoc();
//STRIP001 	Point			aPos( rEvt.maPosPixel );
//STRIP001 	sal_Int8		nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( bInternalMove )
//STRIP001 	{
//STRIP001 		USHORT nPageId = ShowDropPos( aPos ) - 1;
//STRIP001 
//STRIP001         switch (rEvt.mnAction)
//STRIP001         {
//STRIP001             case DND_ACTION_MOVE:
//STRIP001                 if( pDrViewSh->IsSwitchPageAllowed() && pDoc->MovePages( nPageId ) )
//STRIP001                 {
//STRIP001                     SfxDispatcher* pDispatcher = pDrViewSh->GetViewFrame()->GetDispatcher();
//STRIP001                     pDispatcher->Execute(SID_SWITCHPAGE, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001                 }
//STRIP001                 break;
//STRIP001                 
//STRIP001             case DND_ACTION_COPY:
//STRIP001             {
//STRIP001                 // Copying the selected page to the place that rEvt points
//STRIP001                 // takes place in three steps:
//STRIP001                 // 1. Create a copy of the selected page.  This copy will
//STRIP001                 // lie directly behind the selected page.
//STRIP001                 // 2. Move the copy to the desired place.
//STRIP001                 // 3. Select the copy.
//STRIP001                 if (pDrViewSh->IsSwitchPageAllowed())
//STRIP001                 {
//STRIP001                     // 1. Create a copy.
//STRIP001                     USHORT nPageNumOfCopy = pDoc->DuplicatePage (GetCurPageId() - 1);
//STRIP001                     // 2. Move page.  For this first switch to the copy:
//STRIP001                     // MovePages operates on the currently selected page(s).
//STRIP001                     pDrViewSh->SwitchPage (nPageNumOfCopy);
//STRIP001                     // Adapt target page id when necessary, i.e. page copy
//STRIP001                     // has been inserted in front of the target page.
//STRIP001                     USHORT nPageNum = nPageId;
//STRIP001                     if ((nPageNumOfCopy <= nPageNum) && (nPageNum != (USHORT)-1))
//STRIP001                         nPageNum += 1;
//STRIP001                     if (pDoc->MovePages(nPageNum))
//STRIP001                     {
//STRIP001                         // 3. Switch to the copy that has been moved to its
//STRIP001                         // final destination.  Use an asynchron slot call to
//STRIP001                         // be executed after the still pending ones.
//STRIP001                         if (nPageNumOfCopy >= nPageNum || (nPageNum == (USHORT)-1))
//STRIP001                             nPageNum += 1;
//STRIP001                         SetCurPageId (GetPageId(nPageNum));
//STRIP001                         SfxDispatcher* pDispatcher = pDrViewSh->GetViewFrame()->GetDispatcher();
//STRIP001                         pDispatcher->Execute(SID_SWITCHPAGE,
//STRIP001                             SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001                     }
//STRIP001                 }
//STRIP001 
//STRIP001                 break;
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001 		nRet = rEvt.mnAction;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		USHORT nPageId = GetPageId( aPos ) - 1;
//STRIP001 
//STRIP001 		if( ( nPageId >= 0 ) && pDoc->GetPage( nPageId ) )
//STRIP001 		{
//STRIP001 			nRet = pDrViewSh->ExecuteDrop( rEvt, *this, NULL, nPageId, SDRLAYER_NOTFOUND );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	HideDropPos();
//STRIP001 	EndSwitchPage();
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SdTabControl::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	USHORT nCmd = rCEvt.GetCommand();
//STRIP001 
//STRIP001 	if ( nCmd == COMMAND_CONTEXTMENU )
//STRIP001 	{
//STRIP001 		BOOL bGraphicShell = pDrViewSh->ISA( SdGraphicViewShell );
//STRIP001 		USHORT nResId = bGraphicShell ? RID_GRAPHIC_PAGETAB_POPUP :
//STRIP001 										RID_DRAW_PAGETAB_POPUP;
//STRIP001 		SfxDispatcher* pDispatcher = pDrViewSh->GetViewFrame()->GetDispatcher();
//STRIP001 		pDispatcher->ExecutePopup( SdResId( nResId ) );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 long SdTabControl::StartRenaming()
//STRIP001 {
//STRIP001 	BOOL bOK = FALSE;
//STRIP001 
//STRIP001 	if (pDrViewSh->GetPageKind() == PK_STANDARD)
//STRIP001 	{
//STRIP001 		bOK = TRUE;
//STRIP001 
//STRIP001 		SdView* pView = pDrViewSh->GetView();
//STRIP001 
//STRIP001 		if ( pView->IsTextEdit() )
//STRIP001 			pView->EndTextEdit();
//STRIP001 	}
//STRIP001 
//STRIP001 	return( bOK );
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 long SdTabControl::AllowRenaming()
//STRIP001 {
//STRIP001 	BOOL bOK = TRUE;
//STRIP001 
//STRIP001 	String aNewName( GetEditText() );
//STRIP001 	String aCompareName( GetPageText( GetEditPageId() ) );
//STRIP001 
//STRIP001 	if( aCompareName != aNewName )
//STRIP001 	{
//STRIP001         // Seite umbenennen
//STRIP001         if( pDrViewSh->GetDocSh()->CheckPageName( this, aNewName ) )
//STRIP001         {
//STRIP001             SetEditText( aNewName );
//STRIP001             EndRenaming();
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             bOK = FALSE;
//STRIP001         }
//STRIP001 	}
//STRIP001 	return( bOK );
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SdTabControl::EndRenaming()
//STRIP001 {
//STRIP001 	if( !IsEditModeCanceled() )
//STRIP001         pDrViewSh->RenameSlide( GetEditPageId(), GetEditText() );
//STRIP001 }


/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SdTabControl::ActivatePage()
//STRIP001 {
//STRIP001 	if ( /*IsInSwitching && */ pDrViewSh->IsSwitchPageAllowed() )
//STRIP001 	{
//STRIP001 		SfxDispatcher* pDispatcher = pDrViewSh->GetViewFrame()->GetDispatcher();
//STRIP001 		pDispatcher->Execute(SID_SWITCHPAGE,
//STRIP001 							 SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
\************************************************************************/

//STRIP001 long SdTabControl::DeactivatePage()
//STRIP001 {
//STRIP001 	return pDrViewSh->IsSwitchPageAllowed();
//STRIP001 }




//STRIP001 void SdTabControl::SendActivatePageEvent (void)
//STRIP001 {
//STRIP001     CallEventListeners (VCLEVENT_TABBAR_PAGEACTIVATED,
//STRIP001         reinterpret_cast<void*>(GetCurPageId()));
//STRIP001 }




//STRIP001 void SdTabControl::SendDeactivatePageEvent (void)
//STRIP001 {
//STRIP001 	CallEventListeners (VCLEVENT_TABBAR_PAGEDEACTIVATED,
//STRIP001         reinterpret_cast<void*>(GetCurPageId()));
//STRIP001 }
}
