/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_xmlnamespaces.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:57:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #include "xmlnamespaces.hxx"
//STRIP001 
//STRIP001 using namespace ::rtl;
//STRIP001 using namespace ::com::sun::star::xml::sax;
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 
//STRIP001 const OUString aXMLAttributeNamespace( RTL_CONSTASCII_USTRINGPARAM( "xmlns" ));
//STRIP001 
//STRIP001 XMLNamespaces::XMLNamespaces()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 XMLNamespaces::XMLNamespaces( const XMLNamespaces& aXMLNamespaces )
//STRIP001 {
//STRIP001 	m_aDefaultNamespace = aXMLNamespaces.m_aDefaultNamespace;
//STRIP001 	m_aNamespaceMap = aXMLNamespaces.m_aNamespaceMap;
//STRIP001 }
//STRIP001 
//STRIP001 XMLNamespaces::~XMLNamespaces()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void XMLNamespaces::addNamespace( const OUString& aName, const OUString& aValue ) throw( SAXException )
//STRIP001 {
//STRIP001 	NamespaceMap::iterator p;
//STRIP001 	OUString aNamespaceName( aName );
//STRIP001 	sal_Int32 nXMLNamespaceLength = aXMLAttributeNamespace.getLength();
//STRIP001 
//STRIP001 	// delete preceding "xmlns"
//STRIP001 	if ( aNamespaceName.compareTo( aXMLAttributeNamespace, nXMLNamespaceLength ) == 0 )
//STRIP001 	{
//STRIP001 		if ( aNamespaceName.getLength() == nXMLNamespaceLength )
//STRIP001 		{
//STRIP001 			aNamespaceName = OUString();
//STRIP001 		}
//STRIP001 		else if ( aNamespaceName.getLength() >= nXMLNamespaceLength+2 )
//STRIP001 		{	
//STRIP001 			aNamespaceName = aNamespaceName.copy( nXMLNamespaceLength+1 );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// a xml namespace without name is not allowed (e.g. "xmlns:" )
//STRIP001 			OUString aErrorMessage( RTL_CONSTASCII_USTRINGPARAM( "A xml namespace without name is not allowed!" ));
//STRIP001 			throw SAXException( aErrorMessage, Reference< XInterface >(), Any() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aValue.getLength() == 0 && aNamespaceName.getLength() > 0 )
//STRIP001 	{
//STRIP001 		// namespace should be reseted - as xml draft states this is only allowed
//STRIP001 		// for the default namespace - check and throw exception if check fails
//STRIP001 		OUString aErrorMessage( RTL_CONSTASCII_USTRINGPARAM( "Clearing xml namespace only allowed for default namespace!" ));
//STRIP001 		throw SAXException( aErrorMessage, Reference< XInterface >(), Any() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( aNamespaceName.getLength() == 0 )
//STRIP001 			m_aDefaultNamespace = aValue;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			p = m_aNamespaceMap.find( aNamespaceName );
//STRIP001 			if ( p != m_aNamespaceMap.end() )
//STRIP001 			{
//STRIP001 				// replace current namespace definition
//STRIP001 				m_aNamespaceMap.erase( p );
//STRIP001 				m_aNamespaceMap.insert( NamespaceMap::value_type( aNamespaceName, aValue ));
//STRIP001 			}	
//STRIP001 			else
//STRIP001 			{
//STRIP001 				m_aNamespaceMap.insert( NamespaceMap::value_type( aNamespaceName, aValue ));
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 OUString XMLNamespaces::applyNSToAttributeName( const OUString& aName ) const throw( SAXException )
//STRIP001 {
//STRIP001 	// xml draft: there is no default namespace for attributes!
//STRIP001 
//STRIP001 	int	index;
//STRIP001 	if (( index = aName.indexOf( ':' )) > 0 )
//STRIP001 	{
//STRIP001 		if ( aName.getLength() > index+1 )
//STRIP001 		{
//STRIP001 			OUString aAttributeName = getNamespaceValue( aName.copy( 0, index ) );
//STRIP001 			aAttributeName += OUString::createFromAscii( "^" );
//STRIP001 			aAttributeName += aName.copy( index+1 );
//STRIP001 			return aAttributeName;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// attribute with namespace but without name "namespace:" is not allowed!!
//STRIP001 			OUString aErrorMessage( RTL_CONSTASCII_USTRINGPARAM( "Attribute has no name only preceding namespace!" ));
//STRIP001 			throw SAXException( aErrorMessage, Reference< XInterface >(), Any() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return aName;
//STRIP001 }
//STRIP001 
//STRIP001 OUString XMLNamespaces::applyNSToElementName( const OUString& aName ) const	throw( SAXException )
//STRIP001 {
//STRIP001 	// xml draft: element names can have a default namespace
//STRIP001 
//STRIP001 	int			index = aName.indexOf( ':' );
//STRIP001 	OUString	aNamespace;
//STRIP001 	OUString	aElementName = aName;
//STRIP001 
//STRIP001 	if ( index > 0 )
//STRIP001 		aNamespace = getNamespaceValue( aName.copy( 0, index ) );
//STRIP001 	else
//STRIP001 		aNamespace = m_aDefaultNamespace;
//STRIP001 
//STRIP001 	if ( aNamespace.getLength() > 0 )
//STRIP001 	{
//STRIP001 		aElementName = aNamespace;
//STRIP001 		aElementName += OUString::createFromAscii( "^" );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return aName;
//STRIP001 
//STRIP001 	if ( index > 0 )
//STRIP001 	{
//STRIP001 		if ( aName.getLength() > index+1 )
//STRIP001 			aElementName += aName.copy( index+1 );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// attribute with namespace but without a name is not allowed (e.g. "cfg:" )
//STRIP001 			OUString aErrorMessage( RTL_CONSTASCII_USTRINGPARAM( "Attribute has no name only preceding namespace!" ));
//STRIP001 			throw SAXException( aErrorMessage, Reference< XInterface >(), Any() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aElementName += aName;
//STRIP001 			
//STRIP001 	return aElementName;
//STRIP001 }
//STRIP001 
//STRIP001 OUString XMLNamespaces::getNamespaceValue( const OUString& aNamespace ) const throw( SAXException )
//STRIP001 {
//STRIP001 	if ( aNamespace.getLength() == 0 )
//STRIP001 		return m_aDefaultNamespace;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		NamespaceMap::const_iterator p;
//STRIP001 		p = m_aNamespaceMap.find( aNamespace );
//STRIP001 		if ( p != m_aNamespaceMap.end() )
//STRIP001 			return p->second;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// namespace not defined => throw exception!
//STRIP001 			OUString aErrorMessage( RTL_CONSTASCII_USTRINGPARAM( "XML namespace used but not defined!" ));
//STRIP001 			throw SAXException( aErrorMessage, Reference< XInterface >(), Any() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
}
