/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_mailmodel.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:58:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// includes --------------------------------------------------------------

#ifndef  _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef  _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef  _COM_SUN_STAR_IO_XACTIVEDATASINK_HPP_
#include <com/sun/star/io/XActiveDataSink.hpp>
#endif
#ifndef  _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef  _COM_SUN_STAR_MOZILLA_XPLUGININSTANCE_HPP_
#include <com/sun/star/mozilla/XPluginInstance.hpp>
#endif
#ifndef  _COM_SUN_STAR_UCB_XDATACONTAINER_HPP_
#include <com/sun/star/ucb/XDataContainer.hpp>
#endif
#ifndef  _COM_SUN_STAR_UCB_COMMANDABORTEDEXCEPTION_HPP_
#include <com/sun/star/ucb/CommandAbortedException.hpp>
#endif
#ifndef  _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef  _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif
#ifndef _COM_SUN_STAR_SYSTEM_XSIMPLEMAILCLIENTSUPPLIER_HPP_
#include <com/sun/star/system/XSimpleMailClientSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_SYSTEM_SIMPLEMAILCLIENTFLAGS_HPP_
#include <com/sun/star/system/SimpleMailClientFlags.hpp>
#endif

#ifndef _RTL_TEXTENC_H
#include <rtl/textench.h>
#endif
#ifndef _RTL_URI_H_
#include <rtl/uri.h>
#endif
#ifndef _RTL_URI_HXX_
#include <rtl/uri.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _UNOTOOLS_STREAMHELPER_HXX_
#include <unotools/streamhelper.hxx>
#endif
#ifndef _UTL_CONFIGITEM_HXX_
#include <unotools/configitem.hxx>
#endif
#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#include <mailmodel.hxx>
#include "bindings.hxx"
#include "dispatch.hxx"
#include "viewfrm.hxx"
#include "docfile.hxx"
#include "docfilt.hxx"
#include "docfac.hxx"
#include "fcontnr.hxx"
#include "objshimp.hxx"
#include "sfxtypes.hxx"
#include "sfxresid.hxx"

#include "sfxsids.hrc"
#include "mailwindow.hrc"
#include "dialog.hrc"

#include <unotools/tempfile.hxx>
#include <vcl/svapp.hxx>
#include <svtools/stritem.hxx>
#include <svtools/eitem.hxx>
#include <svtools/useroptions.hxx>
#include <comphelper/processfactory.hxx>
#include <comphelper/extract.hxx>
#include <ucbhelper/content.hxx>
#include <tools/urlobj.hxx>

#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

//STRIP001 extern sal_Bool GetPasswd_Impl( const SfxItemSet* pSet, String& rPasswd );
//STRIP001 
//STRIP001 // --------------------------------------------------------------
//STRIP001 using namespace ::com::sun::star::beans;
//STRIP001 using namespace ::com::sun::star::frame;
//STRIP001 using namespace ::com::sun::star::io;
//STRIP001 using namespace ::com::sun::star::lang;
//STRIP001 using namespace ::com::sun::star::mozilla;
//STRIP001 using namespace ::com::sun::star::ucb;
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::util;
//STRIP001 using namespace ::com::sun::star::system;
//STRIP001 using namespace ::rtl;
//STRIP001 
//STRIP001 
//STRIP001 // class OThread
//STRIP001 class OMailSendThread : public ::vos::OThread
//STRIP001 {
//STRIP001 	public:
//STRIP001 		OMailSendThread( 
//STRIP001 				Reference< XSimpleMailClient > xSimpleMailClient, 
//STRIP001 				Reference< XSimpleMailMessage > xSimpleMailMessage, 
//STRIP001 				long nSendFlags ) :
//STRIP001 			m_xSimpleMailClient( xSimpleMailClient ),
//STRIP001 			m_xSimpleMailMessage( xSimpleMailMessage ),
//STRIP001 			m_nSendFlags( nSendFlags ),
//STRIP001 			m_bSend( sal_False ) {}
//STRIP001 			
//STRIP001 		virtual ~OMailSendThread();
//STRIP001 
//STRIP001 		virtual void SAL_CALL run();
//STRIP001 		virtual void SAL_CALL onTerminated();
//STRIP001 
//STRIP001 	private:
//STRIP001 		long		m_nSendFlags;
//STRIP001 		sal_Bool	m_bSend;
//STRIP001 		Reference< XSimpleMailClient > m_xSimpleMailClient;
//STRIP001 		Reference< XSimpleMailMessage > m_xSimpleMailMessage;
//STRIP001 };
//STRIP001 
//STRIP001 OMailSendThread::~OMailSendThread()
//STRIP001 {	
//STRIP001 }
//STRIP001 
//STRIP001 void SAL_CALL OMailSendThread::run()
//STRIP001 {
//STRIP001 	try
//STRIP001 	{
//STRIP001 		m_xSimpleMailClient->sendSimpleMailMessage( m_xSimpleMailMessage, m_nSendFlags );
//STRIP001 		m_bSend = sal_True;
//STRIP001 	}
//STRIP001 	catch ( IllegalArgumentException& )
//STRIP001 	{
//STRIP001 		m_bSend = sal_False;
//STRIP001 	}
//STRIP001 	catch ( Exception& )
//STRIP001 	{
//STRIP001 		m_bSend = sal_False;
//STRIP001 	}
//STRIP001 	
//STRIP001 	if ( m_bSend == sal_False )
//STRIP001 	{
//STRIP001         ::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 		InfoBox aBox( SFX_APP()->GetTopWindow(), SfxResId( MSG_ERROR_SEND_MAIL ));
//STRIP001 		aBox.Execute();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SAL_CALL OMailSendThread::onTerminated()
//STRIP001 {
//STRIP001 	delete this;
//STRIP001 }
//STRIP001 
//STRIP001 // class DefaultMailer_Impl ------------------------------------------------
//STRIP001 
//STRIP001 class DefaultMailerConfig_Impl : public utl::ConfigItem
//STRIP001 {
//STRIP001 	public:
//STRIP001 		DefaultMailerConfig_Impl();
//STRIP001 		virtual ~DefaultMailerConfig_Impl();
//STRIP001 
//STRIP001 	sal_Bool	GetUseDefaultMailer();
//STRIP001 };
//STRIP001 
//STRIP001 DefaultMailerConfig_Impl::DefaultMailerConfig_Impl() : ConfigItem( String::CreateFromAscii( "Office.Common/ExternalMailer" ))
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 DefaultMailerConfig_Impl::~DefaultMailerConfig_Impl()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool DefaultMailerConfig_Impl::GetUseDefaultMailer()
//STRIP001 {
//STRIP001 #ifdef UNIX
//STRIP001     sal_Bool bUseDefaultMailer = sal_False;
//STRIP001 #else
//STRIP001     sal_Bool bUseDefaultMailer = sal_True;
//STRIP001 #endif
//STRIP001 
//STRIP001     Sequence< ::rtl::OUString > aPropertyNames( 1 );
//STRIP001     ::rtl::OUString* pPropertyNames = aPropertyNames.getArray();
//STRIP001     pPropertyNames[0] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "UseDefaultMailer" ));
//STRIP001     Sequence< Any > aPropertyValues = GetProperties( aPropertyNames );
//STRIP001 
//STRIP001     const Any* pPropertyValues = aPropertyValues.getConstArray();
//STRIP001     if ( aPropertyValues.getLength() == 1 &&
//STRIP001          pPropertyValues[0].hasValue() )
//STRIP001 	{
//STRIP001 
//STRIP001 		try
//STRIP001 		{
//STRIP001 			bUseDefaultMailer = ::cppu::any2bool(pPropertyValues[0]);
//STRIP001 		}
//STRIP001 		catch(const ::com::sun::star::lang::IllegalArgumentException&)
//STRIP001 		{
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     return bUseDefaultMailer;
//STRIP001 }
//STRIP001 
//STRIP001 // class AddressList_Impl ------------------------------------------------
//STRIP001 
//STRIP001 typedef String* AddressItemPtr_Impl;
//STRIP001 DECLARE_LIST( AddressList_Impl, AddressItemPtr_Impl )//STRIP008 ;
//STRIP001 
//STRIP001 // class SfxMailModel_Impl -----------------------------------------------
//STRIP001 
//STRIP001 void SfxMailModel_Impl::ClearList( AddressList_Impl* pList )
//STRIP001 {
//STRIP001 	if ( pList )
//STRIP001 	{
//STRIP001 		ULONG i, nCount = pList->Count();
//STRIP001 		for ( i = 0; i < nCount; ++i )
//STRIP001 			delete pList->GetObject(i);
//STRIP001 		pList->Clear();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SfxMailModel_Impl::MakeValueList( AddressList_Impl* pList, String& rValueList )
//STRIP001 {
//STRIP001 	rValueList.Erase();
//STRIP001 	if ( pList )
//STRIP001 	{
//STRIP001 		ULONG i, nCount = pList->Count();
//STRIP001 		for ( i = 0; i < nCount; ++i )
//STRIP001 		{
//STRIP001 			if ( rValueList.Len() > 0 )
//STRIP001 				rValueList += ',';
//STRIP001 			rValueList += *pList->GetObject(i);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 SfxMailModel_Impl::SaveResult SfxMailModel_Impl::SaveDocument( String& rFileName, String& rType )
//STRIP001 {
//STRIP001 	SaveResult			eRet = SAVE_CANCELLED;
//STRIP001 	SfxViewFrame*		pTopViewFrm = mpBindings->GetDispatcher_Impl()->GetFrame()->GetTopViewFrame();
//STRIP001 	SfxObjectShellRef	xDocShell = pTopViewFrm->GetObjectShell();
//STRIP001 
//STRIP001 	// save the document
//STRIP001 	if ( xDocShell.Is() && xDocShell->GetMedium() )
//STRIP001 	{
//STRIP001 		// save old settings
//STRIP001 		BOOL bOldDidDangerousSave = xDocShell->Get_Impl()->bDidDangerousSave;
//STRIP001 		BOOL bModified = xDocShell->IsModified();
//STRIP001 		// prepare for mail export
//STRIP001 		SfxDispatcher* pDisp = pTopViewFrm->GetDispatcher();
//STRIP001 		pDisp->Execute( SID_MAIL_PREPAREEXPORT, SFX_CALLMODE_SYNCHRON );
//STRIP001 		// detect filter
//STRIP001 		const SfxFilter* pFilter = xDocShell->GetMedium()->GetFilter();
//STRIP001 		sal_Bool bHasFilter = pFilter ? sal_True : sal_False;
//STRIP001 		if ( !pFilter )
//STRIP001 		{
//STRIP001         	SfxFilterMatcher aFilterMatcher( xDocShell->GetFactory().GetFilterContainer() );
//STRIP001 			pFilter = aFilterMatcher.GetDefaultFilter();
//STRIP001 		}
//STRIP001 
//STRIP001 		// create temp file name with leading chars and extension
//STRIP001 		sal_Bool	bHasName = xDocShell->HasName();
//STRIP001 		String		aLeadingStr;
//STRIP001 		String*		pExt = NULL;
//STRIP001 
//STRIP001 		if ( !bHasName )
//STRIP001 			aLeadingStr = String( DEFINE_CONST_UNICODE("noname") );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			INetURLObject aFileObj = xDocShell->GetMedium()->GetURLObject();
//STRIP001 			String aName;
//STRIP001 			if ( aFileObj.hasExtension() )
//STRIP001 			{
//STRIP001 				pExt = new String( String::CreateFromAscii( "." ) + aFileObj.getExtension() );
//STRIP001 				aFileObj.removeExtension();
//STRIP001 				aLeadingStr = aFileObj.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 				aLeadingStr += String::CreateFromAscii( "_" );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aLeadingStr = aFileObj.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 				aLeadingStr += String::CreateFromAscii( "_" );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pFilter && !pExt )
//STRIP001 		{
//STRIP001 			pExt = new String( pFilter->GetWildcard()().GetToken(0) );
//STRIP001 			// erase the '*' from the extension (e.g. "*.sdw")
//STRIP001 			pExt->Erase( 0, 1 );
//STRIP001 		}
//STRIP001 
//STRIP001         ::utl::TempFile aTempFile( aLeadingStr, pExt );
//STRIP001 
//STRIP001         delete pExt;
//STRIP001 
//STRIP001         rFileName = aTempFile.GetURL();
//STRIP001 		// save document to temp file
//STRIP001 		SfxStringItem aFileName( SID_FILE_NAME, rFileName );
//STRIP001 		SfxBoolItem aPicklist( SID_PICKLIST, FALSE );
//STRIP001 		SfxBoolItem aSaveTo( SID_SAVETO, TRUE );
//STRIP001 
//STRIP001 		SfxStringItem* pFilterName = NULL;
//STRIP001 		if ( pFilter && bHasFilter )
//STRIP001             pFilterName = new SfxStringItem( SID_FILTER_NAME, pFilter->GetFilterName() );
//STRIP001 		
//STRIP001 		SfxStringItem* pPassItem = NULL;
//STRIP001 		String aPasswd;
//STRIP001 		if ( GetPasswd_Impl( xDocShell->GetMedium()->GetItemSet(), aPasswd ) )
//STRIP001 			pPassItem = new SfxStringItem( SID_PASSWORD, aPasswd );
//STRIP001 		
//STRIP001 		const SfxBoolItem *pRet = (const SfxBoolItem*)pDisp->Execute( SID_SAVEASDOC, SFX_CALLMODE_SYNCHRON, &aFileName, &aPicklist, &aSaveTo,
//STRIP001 																		pFilterName ? pFilterName : pPassItem, 
//STRIP001 																		pFilterName ? pPassItem : 0L, 0L );
//STRIP001 		BOOL bRet = pRet ? pRet->GetValue() : FALSE;
//STRIP001 
//STRIP001         delete pFilterName;
//STRIP001 		if ( pFilter )
//STRIP001 		{
//STRIP001 			// detect content type and expand with the file name
//STRIP001 			rType = pFilter->GetMimeType();
//STRIP001 			rType += DEFINE_CONST_UNICODE("; name =\"");
//STRIP001 			INetURLObject aFileObj = xDocShell->GetMedium()->GetURLObject();
//STRIP001 			rType += aFileObj.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 			rType += '\"';
//STRIP001 		}
//STRIP001 		// restore old settings
//STRIP001 		if ( !bModified && xDocShell->IsEnableSetModified() )
//STRIP001 			xDocShell->SetModified( FALSE );
//STRIP001 		if ( !bOldDidDangerousSave )
//STRIP001 			xDocShell->Get_Impl()->bDidDangerousSave = sal_False;
//STRIP001 		eRet = bRet ? SAVE_SUCCESSFULL : SAVE_ERROR;
//STRIP001 	}
//STRIP001 	
//STRIP001 	return eRet;
//STRIP001 }
//STRIP001 
//STRIP001 SfxMailModel_Impl::SaveResult SfxMailModel_Impl::SaveDocAsPDF( String& rFileName, String& rType )
//STRIP001 {
//STRIP001 	SaveResult eRet = SAVE_CANCELLED;
//STRIP001 	SfxViewFrame* pTopViewFrm = mpBindings->GetDispatcher_Impl()->GetFrame()->GetTopViewFrame();
//STRIP001 	SfxObjectShellRef xDocShell = pTopViewFrm->GetObjectShell();
//STRIP001 
//STRIP001 	// save the document
//STRIP001 	if ( xDocShell.Is() && xDocShell->GetMedium() )
//STRIP001 	{
//STRIP001 		// save old settings
//STRIP001 		BOOL bOldDidDangerousSave = xDocShell->Get_Impl()->bDidDangerousSave;
//STRIP001 		BOOL bModified = xDocShell->IsModified();
//STRIP001 		// prepare for mail export
//STRIP001 		SfxDispatcher* pDisp = pTopViewFrm->GetDispatcher();
//STRIP001 		pDisp->Execute( SID_MAIL_PREPAREEXPORT, SFX_CALLMODE_SYNCHRON );
//STRIP001 
//STRIP001 		// Get PDF Filter from container
//STRIP001 		SfxFactoryFilterContainer* pFilterContainer = xDocShell->GetFactory().GetFilterContainer();
//STRIP001 		if ( pFilterContainer )
//STRIP001 		{
//STRIP001 			String aPDFExtension = String::CreateFromAscii( ".pdf" );
//STRIP001 
//STRIP001 			const SfxFilter*	pFilter		= pFilterContainer->GetFilter4Extension( aPDFExtension, SFX_FILTER_EXPORT );
//STRIP001 			sal_Bool			bHasFilter	= pFilter ? sal_True : sal_False;
//STRIP001 
//STRIP001 			// create temp file name with leading chars and extension
//STRIP001 			sal_Bool	bHasName = xDocShell->HasName();
//STRIP001 			String		aLeadingStr;
//STRIP001 			String*		pExt = NULL;
//STRIP001 
//STRIP001 			if ( !bHasName )
//STRIP001 				aLeadingStr = String( DEFINE_CONST_UNICODE("noname") );
//STRIP001 			else
//STRIP001 			{
//STRIP001 				INetURLObject aFileObj = xDocShell->GetMedium()->GetURLObject();
//STRIP001 				String aName;
//STRIP001 				if ( aFileObj.hasExtension() )
//STRIP001 				{
//STRIP001 					pExt = new String( aPDFExtension );
//STRIP001 					aFileObj.removeExtension();
//STRIP001 					aLeadingStr = aFileObj.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 					aLeadingStr += String::CreateFromAscii( "_" );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					aLeadingStr = aFileObj.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 					aLeadingStr += String::CreateFromAscii( "_" );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pFilter && !pExt )
//STRIP001 			{
//STRIP001 				pExt = new String( pFilter->GetWildcard()().GetToken(0) );
//STRIP001 				// erase the '*' from the extension (e.g. "*.sdw")
//STRIP001 				pExt->Erase( 0, 1 );
//STRIP001 			}
//STRIP001 
//STRIP001 			::utl::TempFile aTempFile( aLeadingStr, pExt );
//STRIP001 			delete pExt;
//STRIP001 
//STRIP001 			rFileName = aTempFile.GetURL();
//STRIP001 
//STRIP001 			// save document to temp file
//STRIP001 			SfxStringItem aFileName( SID_FILE_NAME, rFileName );
//STRIP001 			const SfxBoolItem *pRet = (const SfxBoolItem*)pDisp->Execute( SID_EXPORTDOCASPDF, SFX_CALLMODE_SYNCHRON, &aFileName, 0L );
//STRIP001 			BOOL bRet = pRet ? pRet->GetValue() : FALSE;
//STRIP001 			eRet = bRet ? SAVE_SUCCESSFULL : SAVE_CANCELLED;
//STRIP001 			
//STRIP001 			if ( pFilter )
//STRIP001 			{
//STRIP001 				// detect content type and expand with the file name
//STRIP001 				rType = pFilter->GetMimeType();
//STRIP001 				rType += DEFINE_CONST_UNICODE("; name =\"");
//STRIP001 				INetURLObject aFileObj = xDocShell->GetMedium()->GetURLObject();
//STRIP001 				rType += aFileObj.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 				rType += '\"';
//STRIP001 			}
//STRIP001 			
//STRIP001 			// restore old settings
//STRIP001 			if ( !bModified && xDocShell->IsEnableSetModified() )
//STRIP001 				xDocShell->SetModified( FALSE );
//STRIP001 			if ( !bOldDidDangerousSave )
//STRIP001 				xDocShell->Get_Impl()->bDidDangerousSave = sal_False;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	
//STRIP001 	return eRet;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SfxMailModel_Impl, DoneHdl, void*, EMPTYARG )
//STRIP001 {
//STRIP001 	mbLoadDone = sal_True;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SfxMailModel_Impl, DoneHdl, void*, EMPTYARG )
//STRIP001 
//STRIP001 SfxMailModel_Impl::SfxMailModel_Impl( SfxBindings* pBinds ) :
//STRIP001 
//STRIP001 	mpToList	( NULL ),
//STRIP001 	mpCcList	( NULL ),
//STRIP001 	mpBccList	( NULL ),
//STRIP001 	mpBindings	( pBinds ),
//STRIP001 	mePriority	( PRIO_NORMAL ),
//STRIP001 	mbLoadDone	( sal_True )
//STRIP001 
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 SfxMailModel_Impl::~SfxMailModel_Impl()
//STRIP001 {
//STRIP001 	ClearList( mpToList );
//STRIP001 	delete mpToList;
//STRIP001 	ClearList( mpCcList );
//STRIP001 	delete mpCcList;
//STRIP001 	ClearList( mpBccList );
//STRIP001 	delete mpBccList;
//STRIP001 }
//STRIP001 
//STRIP001 void SfxMailModel_Impl::AddAddress( const String& rAddress, AddressRole eRole )
//STRIP001 {
//STRIP001 	// don't add a empty address
//STRIP001 	if ( rAddress.Len() > 0 )
//STRIP001 	{
//STRIP001 		AddressList_Impl* pList = NULL;
//STRIP001 		if ( ROLE_TO == eRole )
//STRIP001 		{
//STRIP001 			if ( !mpToList )
//STRIP001 				// create the list
//STRIP001 				mpToList = new AddressList_Impl;
//STRIP001 			pList = mpToList;
//STRIP001 		}
//STRIP001 		else if ( ROLE_CC == eRole )
//STRIP001 		{
//STRIP001 			if ( !mpCcList )
//STRIP001 				// create the list
//STRIP001 				mpCcList = new AddressList_Impl;
//STRIP001 			pList = mpCcList;
//STRIP001 		}
//STRIP001 		else if ( ROLE_BCC == eRole )
//STRIP001 		{
//STRIP001 			if ( !mpBccList )
//STRIP001 				// create the list
//STRIP001 				mpBccList = new AddressList_Impl;
//STRIP001 			pList = mpBccList;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			DBG_ERRORFILE( "invalid address role" );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pList )
//STRIP001 		{
//STRIP001 			// add address to list
//STRIP001 			AddressItemPtr_Impl pAddress = new String( rAddress );
//STRIP001 			pList->Insert( pAddress, LIST_APPEND );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 SfxMailModel_Impl::SendMailResult SfxMailModel_Impl::Send( MailDocType eMailDocType )
//STRIP001 {
//STRIP001 	SaveResult		eSaveResult;
//STRIP001 	SendMailResult	eResult = SEND_MAIL_ERROR;
//STRIP001 	String aFileName, aContentType;
//STRIP001 
//STRIP001 	sal_Bool bSuccessfull = sal_False;
//STRIP001 	if ( eMailDocType == TYPE_SELF )
//STRIP001 		eSaveResult = SaveDocument( aFileName, aContentType );
//STRIP001 	else
//STRIP001 		eSaveResult = SaveDocAsPDF( aFileName, aContentType );
//STRIP001 
//STRIP001     if ( eSaveResult == SAVE_SUCCESSFULL )
//STRIP001 	{
//STRIP001     	SfxFrame* pViewFrm = mpBindings->GetDispatcher_Impl()->GetFrame()->GetFrame();
//STRIP001         Reference < XPluginInstance > xPlugin;
//STRIP001 
//STRIP001         if ( pViewFrm )
//STRIP001             xPlugin = Reference < XPluginInstance > ( pViewFrm->GetFrameInterface(), UNO_QUERY );
//STRIP001 
//STRIP001         if ( xPlugin.is() )
//STRIP001         {
//STRIP001             OUStringBuffer aURL(aFileName);
//STRIP001 
//STRIP001             // Create the parameter
//STRIP001 
//STRIP001             // Unencoded characters within the various values transported in
//STRIP001             // the URL are all RFC 2396/2732 <uric> characters, minus '&' and
//STRIP001             // '=' (used to delimit keys and values) and '+' (translated into
//STRIP001             // a space character by servlet containers):
//STRIP001             static sal_Bool const aCharClass[128]
//STRIP001                 = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
//STRIP001                     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
//STRIP001                     0,1,0,0,1,0,0,1,1,1,1,0,1,1,1,1, //  !"#$%&'()*+,-./
//STRIP001                     1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1, // 0123456789:;<=>?
//STRIP001                     1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, // @ABCDEFGHIJKLMNO
//STRIP001                     1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1, // PQRSTUVWXYZ[\]^_
//STRIP001                     0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, // `abcdefghijklmno
//STRIP001                     1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0};// pqrstuvwxyz{|}~
//STRIP001     		ULONG nCount;
//STRIP001             aURL.appendAscii(RTL_CONSTASCII_STRINGPARAM(
//STRIP001                                  "?cmd2.officeMail=1"));
//STRIP001 
//STRIP001             if ( maFromAddress.Len() || CreateFromAddress_Impl( maFromAddress ) )
//STRIP001             {
//STRIP001                 aURL.appendAscii(RTL_CONSTASCII_STRINGPARAM(
//STRIP001                                      "&MESSAGE_FROM="));
//STRIP001                 aURL.append(Uri::encode(maFromAddress,
//STRIP001                                         aCharClass,
//STRIP001                                         rtl_UriEncodeIgnoreEscapes,
//STRIP001                                         RTL_TEXTENCODING_UTF8));
//STRIP001             }
//STRIP001 
//STRIP001             nCount = mpToList ? mpToList->Count() : 0;
//STRIP001             if (nCount > 0)
//STRIP001             {
//STRIP001                 aURL.appendAscii(RTL_CONSTASCII_STRINGPARAM("&MESSAGE_TO="));
//STRIP001                 for (ULONG i = 0; i < nCount; ++i)
//STRIP001                 {
//STRIP001                     if (i > 0)
//STRIP001                         aURL.append(static_cast< sal_Unicode >(','));
//STRIP001                     aURL.append(Uri::encode(*mpToList->GetObject(i),
//STRIP001                                             aCharClass,
//STRIP001                                             rtl_UriEncodeIgnoreEscapes,
//STRIP001                                             RTL_TEXTENCODING_UTF8));
//STRIP001                 }
//STRIP001             }
//STRIP001 
//STRIP001             nCount = mpCcList ? mpCcList->Count() : 0;
//STRIP001             if (nCount > 0)
//STRIP001             {
//STRIP001                 aURL.appendAscii(RTL_CONSTASCII_STRINGPARAM("&MESSAGE_CC="));
//STRIP001                 for (ULONG i = 0; i < nCount; ++i)
//STRIP001                 {
//STRIP001                     if (i > 0)
//STRIP001                         aURL.append(static_cast< sal_Unicode >(','));
//STRIP001                     aURL.append(Uri::encode(*mpCcList->GetObject(i),
//STRIP001                                             aCharClass,
//STRIP001                                             rtl_UriEncodeIgnoreEscapes,
//STRIP001                                             RTL_TEXTENCODING_UTF8));
//STRIP001                 }
//STRIP001             }
//STRIP001 
//STRIP001             nCount = mpBccList ? mpBccList->Count() : 0;
//STRIP001             if (nCount > 0)
//STRIP001             {
//STRIP001                 aURL.appendAscii(RTL_CONSTASCII_STRINGPARAM("&MESSAGE_BCC="));
//STRIP001                 for (ULONG i = 0; i < nCount; ++i)
//STRIP001                 {
//STRIP001                     if (i > 0)
//STRIP001                         aURL.append(static_cast< sal_Unicode >(','));
//STRIP001                     aURL.append(Uri::encode(*mpBccList->GetObject(i),
//STRIP001                                             aCharClass,
//STRIP001                                             rtl_UriEncodeIgnoreEscapes,
//STRIP001                                             RTL_TEXTENCODING_UTF8));
//STRIP001                 }
//STRIP001             }
//STRIP001 
//STRIP001             if ( maSubject.Len() )
//STRIP001             {
//STRIP001                 aURL.appendAscii(RTL_CONSTASCII_STRINGPARAM(
//STRIP001                                      "&MESSAGE_SUBJECT="));
//STRIP001                 aURL.append(Uri::encode(maSubject,
//STRIP001                                         aCharClass,
//STRIP001                                         rtl_UriEncodeIgnoreEscapes,
//STRIP001                                         RTL_TEXTENCODING_UTF8));
//STRIP001             }
//STRIP001 
//STRIP001             aURL.appendAscii(RTL_CONSTASCII_STRINGPARAM("&file_1="));
//STRIP001             aURL.append(Uri::encode(aFileName,
//STRIP001                                     aCharClass,
//STRIP001                                     rtl_UriEncodeIgnoreEscapes,
//STRIP001                                     RTL_TEXTENCODING_UTF8));
//STRIP001 
//STRIP001             // now we dispatch the new created URL so the document will be send.
//STRIP001             URL aTargetURL;
//STRIP001             aTargetURL.Complete = aURL.makeStringAndClear();
//STRIP001             Reference < XURLTransformer > xTrans( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance( OUString::createFromAscii("com.sun.star.util.URLTransformer" )), UNO_QUERY );
//STRIP001             xTrans->parseStrict( aTargetURL );
//STRIP001 
//STRIP001             Reference < XDispatchProvider > xProv( xPlugin, UNO_QUERY );
//STRIP001             Reference < XDispatch > xDisp;
//STRIP001             if ( xProv.is() )
//STRIP001                 xDisp = xProv->queryDispatch( aTargetURL, OUString(), 0 );
//STRIP001 
//STRIP001             if ( xDisp.is() )
//STRIP001             {
//STRIP001                 Sequence < PropertyValue > aArgs;
//STRIP001                 xDisp->dispatch( aTargetURL, aArgs );
//STRIP001                 eResult = SEND_MAIL_OK;
//STRIP001             }
//STRIP001         }
//STRIP001         else
//STRIP001 		{
//STRIP001 			Reference < XMultiServiceFactory > xMgr = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001 			if ( xMgr.is() )
//STRIP001 			{
//STRIP001 				// read configuration to choose between "SimpleCommandMail" or "SimpleSystemMail"!
//STRIP001 				DefaultMailerConfig_Impl				aMailConfig;
//STRIP001 				Reference< XSimpleMailClientSupplier >	xSimpleMailClientSupplier;
//STRIP001 
//STRIP001 				if ( aMailConfig.GetUseDefaultMailer() )
//STRIP001 					xSimpleMailClientSupplier = Reference< XSimpleMailClientSupplier >(
//STRIP001 														xMgr->createInstance( OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.system.SimpleSystemMail" ))),
//STRIP001 													UNO_QUERY );
//STRIP001 				else
//STRIP001 					xSimpleMailClientSupplier = Reference< XSimpleMailClientSupplier >(
//STRIP001 														xMgr->createInstance( OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.system.SimpleCommandMail" ))),
//STRIP001 													UNO_QUERY );
//STRIP001 
//STRIP001 				if ( xSimpleMailClientSupplier.is() )
//STRIP001 				{
//STRIP001 					Reference< XSimpleMailClient > xSimpleMailClient = xSimpleMailClientSupplier->querySimpleMailClient();
//STRIP001 
//STRIP001 					if ( !xSimpleMailClient.is() )
//STRIP001 					{
//STRIP001 						// no mail client support => message box!
//STRIP001 						return SEND_MAIL_ERROR;
//STRIP001 					}
//STRIP001 
//STRIP001 					// we have a simple mail client
//STRIP001 					Reference< XSimpleMailMessage > xSimpleMailMessage = xSimpleMailClient->createSimpleMailMessage();
//STRIP001 					if ( xSimpleMailMessage.is() )
//STRIP001 					{
//STRIP001 						sal_Int32 nSendFlags = SimpleMailClientFlags::DEFAULTS;
//STRIP001 						if ( maFromAddress.Len() == 0 )
//STRIP001 						{
//STRIP001 							// from address not set, try figure out users e-mail address
//STRIP001 							CreateFromAddress_Impl( maFromAddress );
//STRIP001 						}
//STRIP001 						xSimpleMailMessage->setOriginator( maFromAddress );
//STRIP001 						
//STRIP001 						sal_Int32 nToCount		= mpToList ? mpToList->Count() : 0;
//STRIP001 						sal_Int32 nCcCount		= mpCcList ? mpCcList->Count() : 0;
//STRIP001 						sal_Int32 nCcSeqCount	= nCcCount;
//STRIP001 						
//STRIP001 						// set recipient (only one) for this simple mail server!!
//STRIP001 						if ( nToCount > 1 )
//STRIP001 						{
//STRIP001 							nCcSeqCount = nToCount - 1 + nCcCount;
//STRIP001 							xSimpleMailMessage->setRecipient( *mpToList->GetObject( 0 ));
//STRIP001 							nSendFlags = SimpleMailClientFlags::NO_USER_INTERFACE;
//STRIP001 						}
//STRIP001 						else if ( nToCount == 1 )
//STRIP001 						{
//STRIP001 							xSimpleMailMessage->setRecipient( *mpToList->GetObject( 0 ));
//STRIP001 							nSendFlags = SimpleMailClientFlags::NO_USER_INTERFACE;
//STRIP001 						}
//STRIP001 
//STRIP001 						// all other recipient must be handled with CC recipients!
//STRIP001 						if ( nCcSeqCount > 0 )
//STRIP001 						{
//STRIP001 							sal_Int32				nIndex = 0;
//STRIP001 							Sequence< OUString >	aCcRecipientSeq;
//STRIP001 							
//STRIP001 							aCcRecipientSeq.realloc( nCcSeqCount );
//STRIP001 							if ( nCcSeqCount > nCcCount )
//STRIP001     						{
//STRIP001 								for ( sal_Int32 i = 1; i < nToCount; ++i )
//STRIP001 								{
//STRIP001 									aCcRecipientSeq[nIndex++] = *mpToList->GetObject(i);
//STRIP001 								}
//STRIP001 							}
//STRIP001 							
//STRIP001 							for ( sal_Int32 i = 0; i < nCcCount; i++ )
//STRIP001 							{
//STRIP001 								aCcRecipientSeq[nIndex++] = *mpCcList->GetObject(i);
//STRIP001 							}
//STRIP001 							xSimpleMailMessage->setCcRecipient( aCcRecipientSeq );
//STRIP001 						}
//STRIP001 						
//STRIP001 						sal_Int32 nBccCount = mpBccList ? mpBccList->Count() : 0;
//STRIP001 						if ( nBccCount > 0 )
//STRIP001 						{
//STRIP001 	    					Sequence< OUString > aBccRecipientSeq( nBccCount );
//STRIP001 							for ( sal_Int32 i = 0; i < nBccCount; ++i )
//STRIP001 							{
//STRIP001 								aBccRecipientSeq[i] = *mpBccList->GetObject(i);
//STRIP001 							}
//STRIP001 							xSimpleMailMessage->setBccRecipient( aBccRecipientSeq );
//STRIP001 						}
//STRIP001 
//STRIP001 						Sequence< OUString > aAttachmentSeq( 1 );
//STRIP001 						aAttachmentSeq[0] = aFileName;
//STRIP001 
//STRIP001 						xSimpleMailMessage->setSubject( maSubject );
//STRIP001 						xSimpleMailMessage->setAttachement( aAttachmentSeq );
//STRIP001 						
//STRIP001 						// Bugfix: #95743#
//STRIP001 						// Due to the current clipboard implementation we cannot stop the main thread
//STRIP001 						// because the clipboard implementation calls the main thread from another thread
//STRIP001 						// and this would result in a deadlock!
//STRIP001 						// Currently we create a thread to send a message and process all remaining error
//STRIP001 						// handling in this thread!!
//STRIP001 
//STRIP001 						OMailSendThread* pMailSendThread = new OMailSendThread( xSimpleMailClient, xSimpleMailMessage, nSendFlags );
//STRIP001 						pMailSendThread->create();
//STRIP001 						
//STRIP001 						// Return always true as the real error handling occurss in the OMailSendThread-implementation!
//STRIP001 						eResult = SEND_MAIL_OK;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( eSaveResult == SAVE_CANCELLED )
//STRIP001 		eResult = SEND_MAIL_CANCELLED;
//STRIP001 
//STRIP001 	return eResult;
//STRIP001 }
//STRIP001 
//STRIP001 // functions -------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL CreateFromAddress_Impl( String& rFrom )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Diese Funktion versucht mit Hilfe des IniManagers eine From-Adresse
//STRIP001 	zu erzeugen. daf"ur werden die Felder 'Vorname', 'Name' und 'EMail'
//STRIP001 	aus der Applikations-Ini-Datei ausgelesen. Sollten diese Felder
//STRIP001 	nicht gesetzt sein, wird FALSE zur"uckgegeben.
//STRIP001 
//STRIP001 	[R"uckgabewert]
//STRIP001 
//STRIP001 	TRUE:	Adresse konnte erzeugt werden.
//STRIP001 	FALSE:	Adresse konnte nicht erzeugt werden.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 #if SUPD<613//MUSTINI
//STRIP001 	SfxIniManager* pIni = SFX_INIMANAGER();
//STRIP001 	String aName = pIni->Get( SFX_KEY_USER_NAME );
//STRIP001 	String aFirstName = pIni->Get( SFX_KEY_USER_FIRSTNAME );
//STRIP001 #else
//STRIP001 	SvtUserOptions aUserCFG;
//STRIP001 	String aName		= aUserCFG.GetLastName	();
//STRIP001 	String aFirstName	= aUserCFG.GetFirstName	();
//STRIP001 #endif
//STRIP001 	if ( aFirstName.Len() || aName.Len() )
//STRIP001 	{
//STRIP001 		if ( aFirstName.Len() )
//STRIP001 		{
//STRIP001 			rFrom = TRIM( aFirstName );
//STRIP001 
//STRIP001 			if ( aName.Len() )
//STRIP001 				rFrom += ' ';
//STRIP001 		}
//STRIP001 		rFrom += TRIM( aName );
//STRIP001 		// unerlaubte Zeichen entfernen
//STRIP001 		rFrom.EraseAllChars( '<' );
//STRIP001 		rFrom.EraseAllChars( '>' );
//STRIP001 		rFrom.EraseAllChars( '@' );
//STRIP001 	}
//STRIP001 #if SUPD<613//MUSTINI
//STRIP001 	String aEmailName = pIni->GetAddressToken( ADDRESS_EMAIL );
//STRIP001 #else
//STRIP001 	String aEmailName = aUserCFG.GetEmail();
//STRIP001 #endif
//STRIP001 	// unerlaubte Zeichen entfernen
//STRIP001 	aEmailName.EraseAllChars( '<' );
//STRIP001 	aEmailName.EraseAllChars( '>' );
//STRIP001 
//STRIP001 	if ( aEmailName.Len() )
//STRIP001 	{
//STRIP001 		if ( rFrom.Len() )
//STRIP001 			rFrom += ' ';
//STRIP001 		( ( rFrom += '<' ) += TRIM( aEmailName ) ) += '>';
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rFrom.Erase();
//STRIP001 	return ( rFrom.Len() > 0 );
//STRIP001 }

}
