/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_tbxmgr.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: kz $ $Date: 2006/01/05 17:52:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

// auto strip #include <vcl/taskpanelist.hxx>
#include <svtools/miscopt.hxx>
// auto strip #include <comphelper/processfactory.hxx>

#ifndef __FRAMEWORK_CLASSES_ADDONSOPTIONS_HXX_
#include <framework/addonsoptions.hxx>
#endif

// auto strip #ifndef __FRAMEWORK_CLASSES_MENUCONFIGURATION_HXX_
// auto strip #include <framework/menuconfiguration.hxx>
// auto strip #endif

#ifndef __FRAMEWORK_CLASSES_ADDONMENU_HXX_
#include <framework/addonmenu.hxx>
#endif

// auto strip #ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
// auto strip #include <com/sun/star/lang/XServiceInfo.hpp>
// auto strip #endif

#pragma hdrstop

// auto strip #include "imagemgr.hxx"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxmgr.hxx"
#include "dispatch.hxx"
#include "tbxctrl.hxx"
// auto strip #include "resmgr.hxx"
// auto strip #include "app.hxx"
// auto strip #include "request.hxx"
#include "sfxtypes.hxx"
// auto strip #include "bindings.hxx"
#include "toolbox.hrc"
// auto strip #include "imgmgr.hxx"
// auto strip #include "viewfrm.hxx"
#include "sfxresid.hxx"
#include "msgpool.hxx"
// auto strip #include "macrconf.hxx"

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#include "statcach.hxx"
// auto strip #include "workwin.hxx"
#include "ipfrm.hxx"
#include "ipenv.hxx"
#include "tbxchild.hxx"
#include "tbxconf.hxx"
// auto strip #include "arrdecl.hxx"
// auto strip #include "cfgmgr.hxx"
#include "sfxsids.hrc"
namespace binfilter {

static const USHORT nVersion = 13;

// ID's for AddOns toolbox buttons
static const USHORT nAddOnsStartID	= 2000;
static const USHORT nAddOnsEndID	= 2500;

static const char   TOOLBOXITEM_SEPARATOR_STR[] = "private:separator";
static const USHORT TOOLBOXITEM_SEPARATOR_STR_LEN = sizeof( TOOLBOXITEM_SEPARATOR_STR )-1;

using namespace ::framework;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;

//====================================================================

/*?*/ DECL_PTRARRAY(SfxToolBoxControlArr_Impl, SfxToolBoxControl*, 8, 8 )//STRIP008 ;

//---------------------------------------------------------------------------
// Da SV den Customize-Handler nur an der Source-ToolBox aufruft, SFX aber
// auch der TargetBox etwas ausf"uhren mu\s (z.B. Controllererzeugung), stellt
// diese Klasse den public-Zugriff auf die protected-Methode Customize her.

/*?*/ class TbAccess_Impl : public SfxToolbox
/*?*/ {
/*?*/ public :
/*?*/ 
/*?*/ 	TbAccess_Impl ( SfxToolBoxManager &rMgr, Window *pParent, WinBits nBits )
/*?*/ 	  : SfxToolbox(rMgr,pParent,nBits)
/*?*/ 	{}
/*?*/ 
/*?*/ 	inline void CustomizeToolBox (const ToolBoxCustomizeEvent& rCEvt)
/*?*/ 		{ Customize(rCEvt); }
/*?*/ };

// static array to define all runtime item ID's which should not be stored
// nor be configurable
/*?*/ USHORT SfxToolBoxManager::nRuntimeIDs[SFXTOOLBOX_RUNTIMEITEM_COUNT] =
/*?*/ {
/*?*/ 	SID_ADDONS
/*?*/ };

// Structure to hold additional information about a runtime toolbox item
struct TbRuntimeItemData
{
	::rtl::OUString	aImageId;
	::rtl::OUString	aTarget;
};

//====================================================================
/*?*/ SfxToolBoxManager::SfxToolBoxManager( SfxConfigManager* pMgr, USHORT nId )
/*?*/ 	: SfxConfigItem( nId, pMgr ),
/*?*/ 	pParent(0),
/*?*/ 	pBox(0),
/*?*/ 	pControls(0),
/*?*/ 	eSymbolsSize(SFX_SYMBOLS_SIZE_SMALL),
/*?*/ 	nIteratorPos(0),
/*?*/ 	pResMgr(0),
/*?*/ 	pBindings(0),
/*?*/ 	pFrame(0),
/*?*/     pIFace(0),
/*?*/     bInternal(FALSE),
/*?*/ 	bHiContrast(FALSE),
/*?*/ 	bConfigMode(FALSE)
/*?*/ {
/*?*/ }

// ctor for non-objectbars
// they are NOT configurable and so they are not inserted into the configmanager

/*?*/ SfxToolBoxManager::SfxToolBoxManager( Window* _pParent,
/*?*/ 									  SfxBindings &rBindings,
/*?*/ 									  const ResId& rResId  ) :
/*?*/     SfxConfigItem(rResId.GetId(), /*rBindings.GetConfigManager( rResId.GetId() ) */ NULL ),
/*?*/ 	pParent(_pParent),
/*?*/ 	pBox(0),
/*?*/ 	pControls(0),
/*?*/ 	eSymbolsSize(SFX_SYMBOLS_SIZE_SMALL),
/*?*/ 	nIteratorPos(0),
/*?*/ 	pResMgr(rResId.GetResMgr()),
/*?*/ 	pBindings(&rBindings),
/*?*/ 	pFrame(0),
/*?*/     pIFace(0),
/*?*/     bInternal(TRUE),
/*?*/ 	bHiContrast(FALSE),
/*?*/ 	bConfigMode(FALSE)
/*?*/ {
/*?*/ 	DBG_MEMTEST();
/*?*/ 
/*?*/ 	// Dieser ctor ist f"ur nicht konfigurierbare Toolboxen; alle Daten
/*?*/ 	// werden aus der Resource geladen und k"onnen nicht ver"andert werden
/*?*/ }

//--------------------------------------------------------------------

/*N*/ SfxToolBoxManager::SfxToolBoxManager( Window* _pParent,
/*N*/ 									  SfxBindings &rBindings,
/*N*/ 									  const ResId& rResId,
/*N*/ 									  SfxInterface *pInterFace,
/*N*/ 									  USHORT nPos, SfxShell* pTask )
/*
	Beschreibung
	ctor f"ur Objectbars; diese merken sich das Modul, aus dem sie erzeugt
	wurden.
*/

/*N*/     : SfxConfigItem(rResId.GetId(), rBindings.GetConfigManager( rResId.GetId() ) ),
/*N*/ 	pParent(_pParent),
/*N*/ 	pBox(0),
/*N*/ 	pControls(0),
/*N*/ 	eSymbolsSize(SFX_SYMBOLS_SIZE_SMALL),
/*N*/ 	nIteratorPos(0),
/*N*/ 	pResMgr(rResId.GetResMgr()),
/*N*/ 	pBindings(&rBindings),
/*N*/ 	pFrame(0),
/*N*/     pIFace(pInterFace),
/*N*/     bInternal(FALSE),
/*N*/ 	bHiContrast(FALSE),
/*N*/ 	bConfigMode(FALSE)
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 SfxToolBoxManager::SfxToolBoxManager( Window* _pParent,
//STRIP001 									  SfxBindings &rBindings,
//STRIP001 									  const ResId& rResId,
//STRIP001 									  SfxInterface *pInterFace,
//STRIP001 									  USHORT nPos, SfxShell* pTask,
//STRIP001 									  BOOL bConfigurationMode )
//STRIP001 /*
//STRIP001 	Beschreibung
//STRIP001 	ctor f"ur Objectbars; diese merken sich das Modul, aus dem sie erzeugt
//STRIP001 	wurden.
//STRIP001 */
//STRIP001 
//STRIP001     : SfxConfigItem(rResId.GetId(), rBindings.GetConfigManager( rResId.GetId() ) ),
//STRIP001 	pParent(_pParent),
//STRIP001 	pBox(0),
//STRIP001 	pControls(0),
//STRIP001 	eSymbolsSize(SFX_SYMBOLS_SIZE_SMALL),
//STRIP001 	nIteratorPos(0),
//STRIP001 	pResMgr(rResId.GetResMgr()),
//STRIP001 	pBindings(&rBindings),
//STRIP001 	pFrame(0),
//STRIP001     pIFace(pInterFace),
//STRIP001     bInternal(FALSE),
//STRIP001 	bHiContrast(FALSE),
//STRIP001 	bConfigMode(bConfigurationMode)
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 }

//-------------------------------------------------------------------------

/*?*/ SfxToolBoxManager::SfxToolBoxManager( const ResId& rResId,
/*?*/ 		SfxInterface *pInterFace,
/*?*/ 		const String& rName, SfxToolBoxManager *pTbx, SfxShell *pTask)
/*?*/     : SfxConfigItem(rResId.GetId(), pTbx->pBindings->GetConfigManager( rResId.GetId() ) ),
/*?*/ 	pParent(pTbx->pParent),
/*?*/ 	pBox(pTbx->pBox),
/*?*/ 	pControls(pTbx->pControls),
/*?*/ 	eSymbolsSize(pTbx->eSymbolsSize),
/*?*/ 	nIteratorPos(0),
/*?*/ 	pResMgr(rResId.GetResMgr()),
/*?*/ 	pBindings(pTbx->pBindings),
/*?*/ 	pFrame(0),
/*?*/     pIFace(pInterFace),
/*?*/     bInternal(FALSE),
/*?*/ 	bHiContrast(FALSE),
/*?*/ 	bConfigMode(FALSE)

/*
	Beschreibung
	copy-ctor f"ur Objectbars; diese merken sich das Modul, aus dem sie erzeugt
	wurden.
*/

/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//--------------------------------------------------------------------

/*N*/ SfxToolBoxManager::~SfxToolBoxManager()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	// unregister bindings
/*N*/ 	Clear();
/*N*/ 	if (pBox)
/*N*/ 	{
/*N*/ 		Hide();
/*N*/ 
/*N*/         SfxImageManager* pImgMgr = pBindings->GetImageManager();
/*N*/         if ( pImgMgr )
/*N*/             pImgMgr->ReleaseToolBox(pBox);
/*N*/ 
/*N*/ 		// Remove runtime information
/*N*/ 		USHORT nCount = pBox->GetItemCount();
/*N*/ 		for ( USHORT nPos=0; nPos < nCount; nPos++ )
/*N*/ 		{
/*N*/ 			USHORT nId = pBox->GetItemId( nPos );
/*N*/ 			if (( pBox->GetItemType(nPos) == TOOLBOXITEM_BUTTON ) && IsRuntimeItem( nId ))
/*N*/ 			{
/*?*/ 				TbRuntimeItemData* pRuntimeItemData = (TbRuntimeItemData*)pBox->GetItemData( nId );
/*?*/ 				if ( pRuntimeItemData )
/*?*/ 					delete pRuntimeItemData;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		delete pBox;
/*N*/ 		pBox = 0;
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::Construct()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	// set the handlers
/*N*/ 	pBox->SetSelectHdl( LINK(this, SfxToolBoxManager, Select) );
/*N*/ 	pBox->SetActivateHdl( LINK(this, SfxToolBoxManager, Activate) );
/*N*/ 	pBox->SetDeactivateHdl( LINK(this, SfxToolBoxManager, Deactivate) );
/*N*/ 
/*N*/ 	// Nach dem Umkonfigurieren m"ussen die Hilfetexte neu geholt werden
/*N*/ 	((SfxToolbox*)pBox)->bHelpInitialized = FALSE;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::CreateFromSVToolBox()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	if (pBox->GetItemCount() == 0)
/*N*/ 	{
/*?*/ 										// SV austricksen, damit die Groesse
/*?*/ 										// stimmt
/*?*/ 		((SfxToolbox*)pBox)->SetEmpty(TRUE);
/*?*/ 		USHORT nId = SID_NEWDOC;
/*?*/ 		pBox->InsertItem( nId, String());
/*?*/         pBox->SetItemImage(nId, pBindings->GetImageManager()->GetImage(nId, pIFace ? pIFace->GetModule() : 0));
/*?*/ 		pBox->HideItem(nId);
/*N*/ 	}
/*N*/ 
/*N*/ 	// reflect the StarView toolbox in a bindings table
/*N*/ 	if (!pControls)
/*N*/ 		pControls = new SfxToolBoxControlArr_Impl;
/*N*/ 	SfxSlotPool& rSlotPool = pIFace && pIFace->GetModule() ? *pIFace->GetModule()->GetSlotPool() : SFX_APP()->GetSlotPool();
/*N*/ 	((SfxToolbox*)pBox)->ClearItemText_Impl();
/*N*/ 	pBindings->ENTERREGISTRATIONS();
/*N*/ 	for ( USHORT nPos = 0; nPos < pBox->GetItemCount(); ++nPos )
/*N*/ 	{
/*N*/ 		if ( pBox->GetItemType(nPos) == TOOLBOXITEM_BUTTON )
/*N*/ 		{
/*N*/ 			// register binding
/*N*/ 			USHORT nId = pBox->GetItemId(nPos);
/*N*/ 
/*N*/ #ifdef DBG_UTIL
/*N*/ 			const SfxSlot *pSlot = rSlotPool.GetSlot( nId );
/*N*/ 			if ( pSlot && !pSlot->IsMode( SFX_SLOT_TOOLBOXCONFIG ) )
/*N*/ 			{
/*?*/ 				ByteString aStr( "Slot " );
/*?*/ 				aStr += ByteString::CreateFromInt32( nId );
/*?*/ 				aStr += ByteString( " : ToolboxConfig fehlt!" );
/*?*/ 				DBG_ERROR( aStr.GetBuffer() );
/*N*/ 			}
/*N*/ #endif
/*N*/             if ( !pBox->GetHelpId( nId ) )
/*N*/                 pBox->SetHelpId( nId, (ULONG) nId );
/*N*/ 			if ( !pBox->GetItemText(nId).Len() )
/*N*/ 				pBox->SetItemText( nId, rSlotPool.GetSlotName_Impl( nId ) );
/*N*/ 			else
/*N*/ 				((SfxToolbox*)pBox)->SetItemText_Impl( nId, TRUE );
/*N*/ 
/*N*/ 			SfxToolBoxControl *pControl;
/*N*/ 			if ( pBox->GetItemCommand( nId ).CompareToAscii(".uno:", 5 ) == COMPARE_EQUAL )
/*N*/ 				pBox->SetItemCommand( nId, String() );	// Remove .uno commands to be compatible with 6.0/src641
/*N*/ 
/*N*/             if ( pBox->GetItemCommand( nId ).Len() )
/*?*/             {DBG_BF_ASSERT(0, "STRIP"); }//STRIP001     pControl = SfxToolBoxControl::CreateControl( pBox->GetItemCommand( nId ), nId, pBox, *pBindings );
/*N*/ 			else
/*N*/                 pControl = SfxToolBoxControl::CreateControl( nId, pBox, *pBindings, pIFace ? pIFace->GetModule() : 0 );
/*N*/ 
/*N*/ 			pControls->Append( pControl );
/*N*/ 			Window *pItemWin = pControl->CreateItemWindow(pBox);
/*N*/ 			if ( pItemWin )
/*N*/             {
/*N*/                 WindowType nType = pItemWin->GetType();
/*N*/                 if ( nType == WINDOW_LISTBOX || nType == WINDOW_MULTILISTBOX || nType == WINDOW_COMBOBOX )
/*N*/                     pItemWin->SetAccessibleName( pBox->GetItemText( nId ) );
/*N*/ 				pBox->SetItemWindow( nId, pItemWin );
/*N*/             }
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( !bConfigMode )
/*N*/ 		CreateRuntimeItems();
/*N*/ 
/*N*/ 	pBindings->LEAVEREGISTRATIONS();
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::CreateRuntimeItems()
/*N*/ {
/*N*/ 	if ( GetType() == 560 )
/*N*/ 	{
/*N*/ 		if ( framework::AddonsOptions().HasAddonsMenu() &&
/*N*/ 			 pBox->GetItemPos( SID_ADDONS) == TOOLBOX_ITEM_NOTFOUND )
/*?*/ 		{
/*?*/ 		    Reference< ::com::sun::star::frame::XFrame > xFrame;
/*?*/ 		    SfxDispatcher* pDisp = pBindings->GetDispatcher_Impl();
/*?*/ 		    if ( pDisp )
/*?*/ 			    xFrame = pDisp->GetFrame()->GetFrame()->GetFrameInterface();
/*?*/ 
/*?*/             PopupMenu* pMenu = framework::AddonMenuManager::CreateAddonMenu( xFrame );
/*?*/             
/*?*/             // Check if there is at least one menu item for our addon menu. Due to context info
/*?*/             // given in the configuration we can have an empty menu and then we shouldn't display
/*?*/             // the addon menu button at all!
/*?*/             if ( pMenu && pMenu->GetItemCount() > 0 )
/*?*/             {
/*?*/ 			    // Special handling for functionbar. Create a addons button for accessing the addons popup menu
/*?*/ 			    SfxToolBoxControl *pControl;
/*?*/ 			    String aAddonTbxString( SfxResId( STR_ADDONSBUTTONTEXT ));
/*?*/ 
/*?*/ 			    // We need a separator before the Add-On button if there is none
/*?*/ 			    USHORT nCount = pBox->GetItemCount();
/*?*/ 			    if ( nCount > 0 && pBox->GetItemType( nCount-1 ) != TOOLBOXITEM_SEPARATOR )
/*?*/ 				    pBox->InsertSeparator();
/*?*/ 
/*?*/ 			    pBox->InsertItem( SID_ADDONS, aAddonTbxString );
/*?*/ 			    pBox->SetItemImage( SID_ADDONS, pBindings->GetImageManager()->GetImage( SID_ADDONS, pBox->GetBackground().GetColor().IsDark(), pIFace ? pIFace->GetModule() : 0 ));
/*?*/ 			    pBox->SetHelpId( SID_ADDONS, SID_ADDONS );
/*?*/ 			    pControl = SfxToolBoxControl::CreateControl( SID_ADDONS, pBox, *pBindings, pIFace ? pIFace->GetModule() : 0 );
/*?*/ 			    pControls->Append( pControl );
/*?*/ 			}
/*?*/ 			delete pMenu;
/*?*/ 		}
/*N*/ 
/*N*/ 		// Append Add-Ons toolbox items
/*N*/ 		AppendAddOnsItems();
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 static BOOL IsCorrectContext( Reference< ::com::sun::star::frame::XModel >& rModel, const ::rtl::OUString& aContextList )
//STRIP001 {
//STRIP001 	if ( rModel.is() )
//STRIP001 	{
//STRIP001 		Reference< ::com::sun::star::lang::XServiceInfo > xServiceInfo( rModel, UNO_QUERY );
//STRIP001 		if ( xServiceInfo.is() )
//STRIP001 		{
//STRIP001 			sal_Int32 nIndex = 0;
//STRIP001 			do
//STRIP001 			{
//STRIP001 				::rtl::OUString aToken = aContextList.getToken( 0, ',', nIndex );
//STRIP001 
//STRIP001 				if ( xServiceInfo->supportsService( aToken ))
//STRIP001 					return TRUE;
//STRIP001 			}
//STRIP001 			while ( nIndex >= 0 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return ( aContextList.getLength() == 0 );
//STRIP001 }

//STRIP001 static Image RetrieveAddOnImage( Reference< ::com::sun::star::frame::XFrame >& rFrame,
//STRIP001 								 const ::rtl::OUString& aImageId,
//STRIP001 								 const ::rtl::OUString& aURL,
//STRIP001 								 BOOL bBigImage,
//STRIP001 								 BOOL bHiContrast )
//STRIP001 {
//STRIP001 	Image aImage;
//STRIP001 
//STRIP001 	if ( aImageId.getLength() > 0 )
//STRIP001 	{
//STRIP001 		aImage = GetImage( rFrame, aImageId, bBigImage, bHiContrast );
//STRIP001 		if ( !!aImage )
//STRIP001 			return aImage;
//STRIP001 	}
//STRIP001 
//STRIP001 	aImage = GetImage( rFrame, aURL, bBigImage, bHiContrast );
//STRIP001 	if ( !aImage )
//STRIP001 		aImage = framework::AddonsOptions().GetImageFromURL( aURL, bBigImage, bHiContrast );
//STRIP001 
//STRIP001 	return aImage;
//STRIP001 }

//--------------------------------------------------------------------

void SfxToolBoxManager::AppendAddOnsItems()
{
}

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::UseDefault()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/     SfxImageManager *pImgMgr = pBindings->GetImageManager();
/*N*/ 	if ( pBox && pBox->GetItemCount() )
/*N*/ 	{
/*N*/ 		// reconfigure toolbox
/*N*/ 		// remove controllers, item windows, items and item texts
/*?*/ 		Clear();
/*?*/ 		pBox->Clear();
/*?*/ 		((SfxToolbox*)pBox)->ClearItemText_Impl();
/*N*/ 	}
/*N*/ 
/*N*/ 	// ResId f"ur die ToolBox zusammenbasteln
/*N*/ 	// Wenn es keine passende Resource gibt, wird eine leere Toolbox erzeugt
/*N*/ 	// Dies ist der Fall bei UserDefined Toolboxen.
/*N*/ 	ResId aResId(GetType());
/*N*/ 	aResId.SetRT(RSC_TOOLBOX);
/*N*/ 	aResId.SetResMgr(pResMgr);
/*N*/ 
/*N*/ 	if ( Resource::GetResManager()->IsAvailable(aResId) )
/*N*/ 	{
/*N*/ 		BOOL bOwnImageList = FALSE;
/*N*/ 		if ( pBox )
/*N*/ 		{
/*N*/             pBindings->GetImageManager()->ReleaseToolBox( pBox );
/*N*/ 
/*N*/ 			// Konfigurierbare Toolboxen sind SFX-Objectbars; sie laden nur
/*N*/ 			// ihren Inhalt aus der Resource, der Rest kommt aus der
/*N*/ 			// SfxToolboxConfig
/*N*/ 			ToolBox *pTb = new ToolBox ( pParent, aResId );
/*N*/ 			if ( pTb->GetImageList().GetImageCount() )
/*N*/ 				bOwnImageList = TRUE;
/*N*/ 
/*N*/ 			pBox->EnableCustomize( !bOwnImageList );
/*N*/ 
/*N*/ 			pBox->CopyItems( *pTb );
/*N*/ 			pBox->SetHelpId( pTb->GetHelpId() );
/*N*/ 			pBox->SetHelpText( String() );
/*N*/ 			delete pTb;
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*?*/ 			// Nicht konfigurierbare Toolboxen werden komplett aus der
/*?*/ 			// Resource geladen
/*?*/ 			pBox = new SfxToolbox( *this, pParent, aResId );
/*?*/ 			pBox->SetUniqueId( aResId.GetId() );
/*?*/ 			if ( pBox->GetImageList().GetImageCount() )
/*?*/ 				bOwnImageList = TRUE;
/*?*/ 
/*?*/ 			pBox->EnableCustomize( FALSE );
/*?*/ 			pBox->SetButtonType( BUTTON_SYMBOL );
/*?*/             pBox->SetOutStyle( SvtMiscOptions().GetToolboxStyle() );
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( !bOwnImageList )
/*N*/ 		{
/*N*/ 			// Retrieve images and check for high contrast mode
/*N*/ 			pImgMgr->SetImages( *pBox, pIFace ? pIFace->GetModule() : 0, pBox->GetBackground().GetColor().IsDark() );
/*N*/             pImgMgr->RegisterToolBoxManager( this, 0xFFFF );
/*N*/ 		}
/*N*/ 		else
/*N*/             pImgMgr->RegisterToolBox( pBox, SFX_TOOLBOX_CHANGEOUTSTYLE );
/*N*/ 	}
/*N*/ 	else if ( !pBox )
/*N*/ 		DBG_ERROR( "Toolbox-Resource fehlt!" );
/*N*/ 
/*N*/ 	// Handler setzen
/*N*/ 	Construct();
/*N*/ 
/*N*/ 	// Controller und ItemWindows erzeugen
/*N*/ 	CreateFromSVToolBox();
/*N*/ 
/*N*/ 	// Gr"o\se berechnen
/*N*/ 	Align();
/*N*/ 	((SfxToolbox*)pBox)->SetConstructed(TRUE);
/*N*/ 
/*N*/ 	// StatusUpdate anwerfen
/*N*/ 	Activate(0);
/*N*/ 
/*N*/     SetDefault( TRUE );
/*N*/ }

//--------------------------------------------------------------------
/*?*/ int SfxToolBoxManager::Load( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return 0; //STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 
//STRIP001 	SotStorageStreamRef xStream =
//STRIP001             rStorage.OpenSotStream( GetStreamName(), STREAM_STD_READ );
//STRIP001 	if ( xStream->GetError() )
//STRIP001 		return ERR_READ;
//STRIP001 
//STRIP001 	if ( pBox->GetItemCount() )
//STRIP001 	{
//STRIP001 		// reconfigure toolbox
//STRIP001 		// remove controllers, item windows, items and item texts
//STRIP001 		Clear();
//STRIP001 		pBox->Clear();
//STRIP001 		((SfxToolbox*)pBox)->ClearItemText_Impl();
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxImageManager* pImgMgr = pBindings->GetImageManager();
//STRIP001 
//STRIP001 	ToolBoxDescriptor aItems;
//STRIP001     int nRet = ERR_OK;
//STRIP001     if ( !::framework::ToolBoxConfiguration::LoadToolBox( *xStream, aItems ) )
//STRIP001         return ERR_READ;
//STRIP001 
//STRIP001 	USHORT nPos;
//STRIP001 	for ( nPos = 0; nPos<aItems.Count(); )
//STRIP001 	{
//STRIP001 		// watch: index variable is incremented here to allow to decrement in case of wrong configuration entries
//STRIP001 		ToolBoxItemDescriptor *pItem = aItems[nPos++];
//STRIP001         if ( !pItem->nId && pItem->aURL.CompareToAscii("slot:",5) == COMPARE_EQUAL )
//STRIP001         {
//STRIP001 	        pItem->nId = (USHORT) pItem->aURL.Copy( 5 ).ToInt32();
//STRIP001             if ( SfxMacroConfig::IsMacroSlot( pItem->nId ) )
//STRIP001 			{
//STRIP001 				// wrong configuration
//STRIP001 				aItems.DeleteAndDestroy(nPos--);
//STRIP001 				continue;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 	            pItem->aURL.Erase();
//STRIP001 			}
//STRIP001         }
//STRIP001 		else if ( !pItem->nId && pItem->aURL.CompareToAscii(".uno:", 5 ) == COMPARE_EQUAL )
//STRIP001 		{
//STRIP001 			// Map .uno command to ID
//STRIP001             SfxShell *pShell=0;
//STRIP001             USHORT nIdx;
//STRIP001             for (nIdx=0; (pShell=pBindings->GetDispatcher_Impl()->GetShell(nIdx)); nIdx++)
//STRIP001             {
//STRIP001                 const SfxInterface *pIFace = pShell->GetInterface();
//STRIP001                 const SfxSlot* pSlot = pIFace->GetSlot( pItem->aURL );
//STRIP001                 if ( pSlot )
//STRIP001                 {
//STRIP001                     pItem->nId = pSlot->GetSlotId();
//STRIP001                     break;
//STRIP001                 }
//STRIP001             }
//STRIP001 			pItem->aURL.Erase(); // Remove .uno command to be compatible with 6.0/src641
//STRIP001 		}
//STRIP001         else if ( !pItem->nId && pItem->aURL.Len() /*pItem->aURL.CompareToAscii("macro:",6) == COMPARE_EQUAL*/ )
//STRIP001         {
//STRIP001             SfxMacroInfo aInfo( pItem->aURL );
//STRIP001             SFX_APP()->GetMacroConfig()->GetSlotId( &aInfo );
//STRIP001             pItem->nId = aInfo.GetSlotId();
//STRIP001         }
//STRIP001 
//STRIP001         if ( pItem->pBmp && !pImgMgr->IsUserDef_Impl( pItem->nId ) )
//STRIP001 		{
//STRIP001 //!MBA sollte jetzt nicht mehr passieren, da ja der ImageManager qualifiziert verwendet wird ?!
//STRIP001 			// Wenn es f"ur die SlotId noch keine Bitmap am Imagemanager
//STRIP001 			// gibt, wird die eingelesene Bitmap dort angmeldet.
//STRIP001 			// So wird beim Konfigurieren einer Toolbox auch gleichzeitig
//STRIP001 			// der ImageManager umkonfiguriert !
//STRIP001 			// Diese Toolbox wird am ImageManager kurzfristig abgemeldet,
//STRIP001 			// damit ReplaceImage nicht versucht, hier was auszutauschen
//STRIP001             pImgMgr->ReplaceImage( pItem->nId, pItem->pBmp );
//STRIP001 			DBG_ERROR("UserDef Bitmap added!");
//STRIP001 		}
//STRIP001 
//STRIP001 		// ToolBoxItem einf"ugen
//STRIP001 		switch ( (ToolBoxItemType) pItem->nItemType )
//STRIP001 		{
//STRIP001 			case TOOLBOXITEM_BUTTON:
//STRIP001 			{
//STRIP001 				pBox->InsertItem( pItem->nId, pItem->aItemText, pItem->nItemBits );
//STRIP001 				if ( pItem->aURL.Len() )
//STRIP001 					pBox->SetItemCommand( pItem->nId, pItem->aURL );
//STRIP001 				if ( pItem->aHelpId.CompareToAscii("helpid:",7) == COMPARE_EQUAL )
//STRIP001 					pBox->SetHelpId( pItem->nId, pItem->aHelpId.Copy( 7 ).ToInt32() );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			case TOOLBOXITEM_SEPARATOR:
//STRIP001 				pBox->InsertSeparator();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TOOLBOXITEM_SPACE:
//STRIP001 				pBox->InsertSpace();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TOOLBOXITEM_BREAK:
//STRIP001 				pBox->InsertBreak();
//STRIP001 				break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				DBG_ERROR( "invalid item-type in toolbox config" );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !pItem->nVisible )
//STRIP001 			pBox->HideItem( pItem->nId );
//STRIP001 	}
//STRIP001 
//STRIP001 	pImgMgr->ReleaseToolBox( pBox );
//STRIP001 	pImgMgr->RegisterToolBoxManager( this, 0xFFFF );
//STRIP001 
//STRIP001 	// Alle Images vom ImageManager holen
//STRIP001 	pImgMgr->SetImages( *pBox, pIFace ? pIFace->GetModule() : 0, pBox->GetBackground().GetColor().IsDark() );
//STRIP001 
//STRIP001 	// Handler setzen
//STRIP001 	Construct();
//STRIP001 
//STRIP001 	// Controller und ItemWindows anlegen
//STRIP001 	CreateFromSVToolBox();
//STRIP001 
//STRIP001 	USHORT nCount = pBox->GetItemCount();
//STRIP001 	for ( nPos = 0; nPos<nCount; ++nPos )
//STRIP001 	{
//STRIP001 		const USHORT nId = pBox->GetItemId(nPos);
//STRIP001 		if ( pBox->GetItemWindow( nId ) )
//STRIP001 		{
//STRIP001 			// Falls der Controller nur in einem anderen Context ein Itemwindow
//STRIP001 			// hat, kann es auch NULL sein !
//STRIP001 			USHORT nWidth = (USHORT)(ULONG) pBox->GetItemData( nId );
//STRIP001 			pBox->SetItemData( nId, (void*)NULL );
//STRIP001 			Size aSize = pBox->GetItemWindow(nId)->GetSizePixel();
//STRIP001 			aSize.Width() = aItems[nPos]->nWidth;
//STRIP001 			pBox->GetItemWindow(nId)->SetSizePixel(aSize);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Gr"o\se berechnen
//STRIP001 	Align();
//STRIP001 	((SfxToolbox*) pBox)->SetConstructed(TRUE);
//STRIP001 	SetDefault( FALSE );
//STRIP001 
//STRIP001 	// StatusUpdate anwerfen
//STRIP001 	Activate(0);
//STRIP001 	return SfxConfigItem::ERR_OK;
/*?*/ }

//--------------------------------------------------------------------

/*?*/ BOOL SfxToolBoxManager::Store( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 
//STRIP001 	SotStorageStreamRef xStream =
//STRIP001             rStorage.OpenSotStream( GetStreamName(), STREAM_STD_READWRITE | STREAM_TRUNC );
//STRIP001 	if ( !xStream->GetError() )
//STRIP001 	{
//STRIP001 		ToolBoxDescriptor aItems;
//STRIP001 		if ( pBox && !((SfxToolbox*)pBox)->IsEmpty() )
//STRIP001 		{
//STRIP001 			USHORT          nPos, nCount = pBox->GetItemCount();
//STRIP001             ToolBoxItemType nSepToInsert = TOOLBOXITEM_DONTKNOW;
//STRIP001 			for ( nPos = 0; nPos < nCount; ++nPos )
//STRIP001 			{
//STRIP001 				USHORT          nId     = pBox->GetItemId(nPos);
//STRIP001 				ToolBoxItemType nType   = pBox->GetItemType(nPos);
//STRIP001 
//STRIP001                 if ( nType != TOOLBOXITEM_BUTTON )
//STRIP001                     nSepToInsert = nType;
//STRIP001                 else
//STRIP001                 {
//STRIP001 				    // Remove runtime toolbox items from the store/load process					    
//STRIP001 				    if ( !IsRuntimeItem( nId ) )
//STRIP001 				    {
//STRIP001                         // Insert separator before real item
//STRIP001 					    if ( nSepToInsert != TOOLBOXITEM_DONTKNOW )
//STRIP001 					    {
//STRIP001 					        ToolBoxItemDescriptor* pItem = new ToolBoxItemDescriptor;
//STRIP001 					        pItem->nItemType = nSepToInsert;
//STRIP001 					        aItems.Insert( pItem, aItems.Count() );
//STRIP001 					        nSepToInsert = TOOLBOXITEM_DONTKNOW;
//STRIP001 					    }
//STRIP001 					    
//STRIP001 					    ToolBoxItemDescriptor* pItem = new ToolBoxItemDescriptor;
//STRIP001 					    pItem->nId = nId;
//STRIP001 					    aItems.Insert( pItem, aItems.Count() );
//STRIP001 					    Window* pWindow = pBox->GetItemWindow( nId );
//STRIP001 					    if ( pWindow )
//STRIP001 						    pItem->nWidth = (USHORT) pWindow->GetSizePixel().Width();
//STRIP001 					    if ( ((SfxToolbox*)pBox)->HasItemText_Impl( nId ) )
//STRIP001 						    pItem->aItemText = pBox->GetItemText( nId );
//STRIP001 					    pItem->aURL = pBox->GetItemCommand( nId );
//STRIP001 					    if ( !pItem->aURL.Len() && nId )
//STRIP001 					    {
//STRIP001 						    pItem->aURL = String::CreateFromAscii("slot:");
//STRIP001 						    pItem->aURL += String::CreateFromInt32( nId );
//STRIP001 					    }
//STRIP001 
//STRIP001 					    if ( pBox->GetHelpId( nId ) != nId )
//STRIP001 					    {
//STRIP001 						    pItem->aHelpId = String::CreateFromAscii("helpid:");
//STRIP001 						    pItem->aHelpId += String::CreateFromInt32( pBox->GetHelpId( nId ) );
//STRIP001 					    }
//STRIP001 
//STRIP001 					    SfxImageManager* pImgMgr = GetBindings().GetImageManager();
//STRIP001 					    pItem->nUserDef = pImgMgr->IsUserDef_Impl(nId);
//STRIP001 					    if ( pItem->nUserDef )
//STRIP001 					    {
//STRIP001 						    pItem->pBmp = new Bitmap;
//STRIP001 						    (*pItem->pBmp) = pImgMgr->GetUserDefBitmap_Impl(nId);
//STRIP001 					    }
//STRIP001 
//STRIP001 					    pItem->nItemBits = pBox->GetItemBits( nId );
//STRIP001 					    pItem->nItemType = nType;
//STRIP001 					    pItem->nVisible = pBox->IsItemVisible( nId );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         return ::framework::ToolBoxConfiguration::StoreToolBox( *xStream, aItems );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return FALSE;
/*?*/ }

//--------------------------------------------------------------------

/*?*/ BOOL SfxToolBoxManager::Import( SvStream& rInStream, SvStream& rOutStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 	ToolBoxDescriptor aItems;
//STRIP001 
//STRIP001 	USHORT nFileVersion, nLanguage;
//STRIP001 	rInStream >> nFileVersion;
//STRIP001 	if ( nFileVersion < 9 )
//STRIP001 		return SfxConfigItem::WARNING_VERSION;
//STRIP001 
//STRIP001 	USHORT nCount;
//STRIP001 	rInStream >> nCount;
//STRIP001 
//STRIP001 	USHORT nPos;
//STRIP001     rtl_TextEncoding nEnc = osl_getThreadTextEncoding();
//STRIP001 	for ( nPos = 0; nPos < nCount; ++nPos )
//STRIP001 	{
//STRIP001 		ToolBoxItemDescriptor* pItem = new ToolBoxItemDescriptor;
//STRIP001 		aItems.Insert( pItem, aItems.Count() );
//STRIP001 		USHORT nUserDef;
//STRIP001 
//STRIP001 		rInStream >> pItem->nItemType >> pItem->nId;
//STRIP001         rInStream.ReadByteString( pItem->aItemText, nEnc );
//STRIP001 		rInStream >> nUserDef >> pItem->nItemBits;
//STRIP001 		if ( nFileVersion>12 )
//STRIP001 			rInStream >> pItem->nVisible;
//STRIP001 		else
//STRIP001 			pItem->nVisible = 1;
//STRIP001 
//STRIP001         if ( nUserDef && nFileVersion > 9 )
//STRIP001         {
//STRIP001             pItem->pBmp = new Bitmap;
//STRIP001             rInStream >> (*pItem->pBmp);
//STRIP001         }
//STRIP001 
//STRIP001 		if ( SfxMacroConfig::IsMacroSlot( pItem->nId ) )
//STRIP001 		{
//STRIP001 			// Die SlotId von Macros ist nicht fest; wir besorgen uns eine
//STRIP001 			SfxMacroInfo aInfo;
//STRIP001 			rInStream >> aInfo;
//STRIP001 //            pItem->nId = aInfo.GetSlotId();
//STRIP001 			pItem->aURL = aInfo.GetURL();
//STRIP001 		}
//STRIP001 		else if ( pItem->nId )
//STRIP001 		{
//STRIP001 			// Keine Itemtexte aus "alteren Versionen
//STRIP001 			pItem->aURL = String::CreateFromAscii("slot:");
//STRIP001 			pItem->aURL += String::CreateFromInt32( pItem->nId );
//STRIP001 			if ( nFileVersion<12 )
//STRIP001 				pItem->aItemText.Erase();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// ItemWindowbreiten einlesen
//STRIP001 	USHORT nWidth=0;
//STRIP001 	for ( nPos = 0; nPos<nCount; ++nPos )
//STRIP001 	{
//STRIP001 		ToolBoxItemDescriptor *pItem = aItems[nPos];
//STRIP001 		rInStream >> pItem->nWidth;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nFileVersion > 10 )
//STRIP001 		rInStream >> nLanguage;
//STRIP001 
//STRIP001     LanguageType eLangType = Application::GetSettings().GetUILanguage();
//STRIP001 
//STRIP001 	if ( eLangType != (LanguageType) nLanguage )
//STRIP001 	{
//STRIP001 		// language doesn't match to current settings; use default texts if available
//STRIP001 		for ( USHORT n=0; n<aItems.Count(); n++ )
//STRIP001 		{
//STRIP001 			ToolBoxItemDescriptor *pItem = aItems[n];
//STRIP001             if ( pItem->nItemType == TOOLBOXITEM_BUTTON && !SfxMacroConfig::IsMacroSlot( pItem->nId ) )
//STRIP001 				pItem->aItemText.Erase();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     return ::framework::ToolBoxConfiguration::StoreToolBox( rOutStream, aItems );
/*?*/ }

/*?*/ BOOL SfxToolBoxManager::Export( SvStream& rInStream, SvStream& rOutStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE; //STRIP001 
//STRIP001 	ToolBoxDescriptor aItems;
//STRIP001     if ( !::framework::ToolBoxConfiguration::LoadToolBox( rInStream, aItems ) )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	USHORT nCount = aItems.Count();
//STRIP001 	rOutStream 	<< (USHORT) nVersion
//STRIP001 				<< nCount;
//STRIP001 
//STRIP001 	USHORT nPos;
//STRIP001     rtl_TextEncoding nEnc = osl_getThreadTextEncoding();
//STRIP001 	SfxMacroConfig *pMC = SfxMacroConfig::GetOrCreate();
//STRIP001 	SvUShorts aMacroSlots;
//STRIP001 	for ( nPos = 0; nPos < nCount; ++nPos )
//STRIP001 	{
//STRIP001 		ToolBoxItemDescriptor *pItem = aItems[nPos];
//STRIP001         if ( !pItem->nId && pItem->aURL.CompareToAscii("slot:",5) == COMPARE_EQUAL )
//STRIP001         {
//STRIP001             pItem->nId = (USHORT) pItem->aURL.Copy( 5 ).ToInt32();
//STRIP001             pItem->aURL.Erase();
//STRIP001         }
//STRIP001         else if ( !pItem->nId && pItem->aURL.CompareToAscii("macro:",6) == COMPARE_EQUAL )
//STRIP001         {
//STRIP001             SfxMacroInfo aInfo( pItem->aURL );
//STRIP001             pMC->GetSlotId( &aInfo );
//STRIP001             pItem->nId = aInfo.GetSlotId();
//STRIP001 			aMacroSlots.Insert( pItem->nId, aMacroSlots.Count() );
//STRIP001         }
//STRIP001 
//STRIP001 		rOutStream 	<< pItem->nItemType
//STRIP001 					<< pItem->nId;
//STRIP001         rOutStream.WriteByteString( pItem->aItemText, nEnc );
//STRIP001 		rOutStream	<< pItem->nUserDef
//STRIP001 					<< pItem->nItemBits
//STRIP001 					<< pItem->nVisible;
//STRIP001 
//STRIP001         if ( pItem->pBmp )
//STRIP001         {
//STRIP001             DBG_ASSERT( !pItem->nUserDef, "Wrong configuration!" );
//STRIP001             rOutStream << (*pItem->pBmp);
//STRIP001         }
//STRIP001 
//STRIP001 		if ( SfxMacroConfig::IsMacroSlot( pItem->nId ) )
//STRIP001 			rOutStream << *pMC->GetMacroInfo( pItem->nId );
//STRIP001 	}
//STRIP001 
//STRIP001 	for ( nPos = 0; nPos < nCount; ++nPos )
//STRIP001 		rOutStream << aItems[nPos]->nWidth;
//STRIP001 
//STRIP001 	for ( USHORT n=0; n<aMacroSlots.Count(); n++ )
//STRIP001 		pMC->ReleaseSlotId( aMacroSlots[n] );
//STRIP001 
//STRIP001     LanguageType eLangType = Application::GetSettings().GetUILanguage();
//STRIP001 	rOutStream << (USHORT) eLangType;
//STRIP001 	return TRUE;
/*?*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::Align()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	if ( pBox->IsFloatingMode() )
/*N*/ 		return;
/*N*/ 
/*N*/ 	Size aOldSize = pBox->GetSizePixel();
/*N*/ 	Size aSize = pBox->CalcWindowSizePixel();
/*N*/     if ( !aSize.Width() )
/*N*/         aSize.Width() = aOldSize.Width();
/*N*/     else if ( !aSize.Height() )
/*N*/         aSize.Height() = aOldSize.Height();
/*N*/ 
/*N*/ 	if (aSize.Width() && aSize.Width() != pBox->GetSizePixel().Width() ||
/*N*/             aSize.Height() && aSize.Height() != pBox->GetSizePixel().Height())
/*N*/ 		pBox->SetPosSizePixel( pBox->GetPosPixel(), aSize );
/*N*/ }

//--------------------------------------------------------------------

/*?*/ void SfxToolBoxManager::RefreshImages_Impl()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     pBindings->GetImageManager()->SetImages( *pBox, pIFace ? pIFace->GetModule() : 0, bHiContrast );
//STRIP001 
//STRIP001 	Reference< ::com::sun::star::frame::XFrame > xFrame;
//STRIP001 	SfxDispatcher* pDisp = pBindings->GetDispatcher_Impl();
//STRIP001 	if ( pDisp )
//STRIP001 		xFrame = pDisp->GetFrame()->GetFrame()->GetFrameInterface();
//STRIP001 	BOOL bBigImages	= ( SfxImageManager::GetCurrentSymbolsSize() == SFX_SYMBOLS_SIZE_LARGE );
//STRIP001 
//STRIP001 	USHORT nCount = pBox->GetItemCount();
//STRIP001 	for ( USHORT nPos=0; nPos<nCount; nPos++ )
//STRIP001 	{
//STRIP001 		USHORT nId = pBox->GetItemId( nPos );
//STRIP001 		if ( pBox->GetItemType(nPos) == TOOLBOXITEM_BUTTON )
//STRIP001 		{
//STRIP001 			SfxStateCache *pCache = pBindings->GetStateCache( nId );
//STRIP001 			if ( pCache )
//STRIP001 				pCache->SetCachedState();
//STRIP001 			else if ( IsRuntimeItem( nId ))
//STRIP001 			{
//STRIP001 				// Runtime items can use different image managers
//STRIP001 				::rtl::OUString aImageId;
//STRIP001 
//STRIP001 				if ( pBox->GetItemData( nId ))
//STRIP001 					aImageId = ((TbRuntimeItemData*)pBox->GetItemData( nId ))->aImageId;
//STRIP001 
//STRIP001 				Image aImage = RetrieveAddOnImage( xFrame, aImageId, pBox->GetItemCommand( nId ), bBigImages, bHiContrast );
//STRIP001 				if ( !!aImage )
//STRIP001 					pBox->SetItemImage( nId, aImage );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::Clear()
/*N*/ {
/*N*/ 	if (pControls)
/*N*/ 	{
/*N*/ 		pBindings->ENTERREGISTRATIONS();
/*N*/ 		for ( USHORT n = 0; n < pControls->Count(); ++n )
/*N*/ 		{
/*N*/ 			SfxToolBoxControl *pControl = pControls->GetObject(n);
/*N*/ 			USHORT nId = pControl->GetId();
/*N*/ 			Window *pItemWin = pBox->GetItemWindow(nId);
/*N*/ 			if ( pItemWin )
/*N*/ 			{
/*N*/ 				pItemWin->Hide();
/*N*/ 				delete pItemWin;
/*N*/ 				pBox->SetItemWindow( nId, 0 );
/*N*/ 			}
/*N*/ 			delete pControl;
/*N*/ 		}
/*N*/ 		pControls->Clear();
/*N*/ 		DELETEZ(pControls);
/*N*/ 		pBindings->LEAVEREGISTRATIONS();
/*N*/ 	}
/*N*/ }


//--------------------------------------------------------------------

/*N*/ SfxToolBoxControl* SfxToolBoxManager::FindControl_Impl( USHORT nId ) const
/*N*/ {
/*N*/ 	for ( USHORT nPos = 0; nPos < pControls->Count(); ++nPos )
/*N*/ 		if ( pControls->GetObject(nPos)->GetId() == nId )
/*N*/ 			return pControls->GetObject(nPos);
/*N*/ 	return 0;
/*N*/ }

//--------------------------------------------------------------------

// updates all state-information

/*N*/ IMPL_LINK( SfxToolBoxManager, Activate, ToolBox *, pSVBox )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	SfxToolbox *pTbx = (SfxToolbox*) pBox;
/*N*/ 	SfxBindings *pBindinx = pBindings;
/*N*/ 
/*N*/ 	// Es kann passieren, da\s diese Toolbox im Verlauf des jetzt erzwungenen
/*N*/ 	// Updates ausgetauscht werden m"u\ste. Daher merken wir uns, da\s wir auf
/*N*/ 	// keinen Fall ausgetauscht oder gel"oscht werden wollen.
/*N*/ 	if ( pSVBox )
/*N*/ 		pTbx->bActivated = TRUE;
/*N*/ 
/*N*/ 	if ( !pBindinx->GetDispatcher_Impl()->IsLocked() && !pTbx->bReconfigure)
/*N*/ 	{
/*N*/ 		pBindinx->GetDispatcher_Impl()->Flush();
/*N*/ 		if (!pTbx->bDeleteToolBox)			// noch nicht versucht zu deleten
/*N*/ 		{
/*N*/ 			// update all states-information of each item in this menu
/*N*/ 			for ( short nPos = pTbx->GetItemCount(); nPos >= 0; --nPos )
/*N*/ 			{	USHORT nId = pTbx->GetItemId(nPos);
/*N*/ 				if ( nId != 0 )
/*N*/ 					pBindinx->Update( nId );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxStateCache *pCache = pBindinx->GetStateCache( SID_IMAGE_ORIENTATION );
/*N*/ 		if ( pCache )
/*N*/ 			pCache->SetCachedState();
/*N*/ 	}
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

//--------------------------------------------------------------------

// removes the context

/*N*/ IMPL_LINK( SfxToolBoxManager, Deactivate, ToolBox *, pToolBox )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	((SfxToolbox*)pBox)->bActivated = FALSE;
/*N*/ 	return 0;
/*N*/ }


//--------------------------------------------------------------------

// executes the selected function

/*N*/ IMPL_LINK( SfxToolBoxManager, Select, ToolBox *, pBox )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	// Wenn die ToolBox zum Deleten vorgemerkt ist, soll nichts mehr
/*N*/ 	// selektiert werden koennen.
/*N*/ 	if ( ((SfxToolbox*)pBox)->bDeleteToolBox )
/*N*/ 		return 0;
/*N*/ 
/*N*/ 	SfxToolBoxControl *pControl = FindControl_Impl( pBox->GetCurItemId() );
/*N*/ 	if ( pControl )
/*N*/ 	{
/*N*/ 		SfxToolbox *pTbx = (SfxToolbox*) pBox;
/*N*/ 		// Auch beim Select darf nicht zwischendurch die ToolBox oder das
/*N*/ 		// selektierte Item verschwinden; da Select erst nach Deactivate kommt,
/*N*/ 		// mu\s die ToolBox noch einmal "geblockt" werden.
/*N*/ 		pTbx->bActivated = 2;
/*N*/ 		pControl->Select( pBox->GetModifier() );
/*N*/ 		pTbx->bActivated = FALSE;
/*N*/ 	}
/*N*/ 	return 0;
/*N*/ }


//--------------------------------------------------------------------

// resets the item iterator, FALSE if none

/*?*/ BOOL SfxToolBoxManager::FirstItem()
/*?*/ {
/*?*/ 	nIteratorPos = 0;
/*?*/ 	return nIteratorPos < pBox->GetItemCount();
/*?*/ }


//--------------------------------------------------------------------

// skips to the next item, FALSE if no more

/*?*/ BOOL SfxToolBoxManager::NextItem()
/*?*/ {
/*?*/ 	++nIteratorPos;
/*?*/ 	return nIteratorPos < pBox->GetItemCount();
/*?*/ }


//--------------------------------------------------------------------

// TRUE if current item is a binding

//STRIP001 BOOL SfxToolBoxManager::IsBinding() const
//STRIP001 {
//STRIP001 	return pBox->GetItemType(nIteratorPos) == TOOLBOXITEM_BUTTON;
//STRIP001 }


//--------------------------------------------------------------------

// TRUE if current item is a separator

//STRIP001 BOOL SfxToolBoxManager::IsSeparator() const
//STRIP001 {
//STRIP001 	return pBox->GetItemType( pBox->GetItemId(nIteratorPos) ) ==
//STRIP001 		   TOOLBOXITEM_SEPARATOR;
//STRIP001 }


//--------------------------------------------------------------------

// id of current binding if IsBinding()

//STRIP001 USHORT SfxToolBoxManager::GetId() const
//STRIP001 {
//STRIP001 	return pBox->GetItemId( nIteratorPos );
//STRIP001 }

//--------------------------------------------------------------------

/*?*/ void SfxToolBoxManager::InsertItem( USHORT nId, Image& aImage, USHORT nTargetPos, USHORT nHelpId, String aItemText )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if (((SfxToolbox*)pBox)->IsEmpty())
//STRIP001 	{
//STRIP001 		// Das DummyItem in leeren ToolBoxen entfernen
//STRIP001 		pBox->RemoveItem(0);
//STRIP001 		((SfxToolbox*)pBox)->SetEmpty(FALSE);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Habe ich das Item noch nicht ?
//STRIP001 	if (pBox->GetItemPos(nId) == TOOLBOX_ITEM_NOTFOUND)
//STRIP001 	{
//STRIP001 		// Der SFX steckt die Source-Toolbox in die User-Daten
//STRIP001         pBox->InsertItem( nId, aImage, String(), 0, nTargetPos );
//STRIP001 		SetItemText( nId, aItemText );
//STRIP001 
//STRIP001 		// Macros m"u\sen einen Slot anfordern
//STRIP001 		if ( SfxMacroConfig::IsMacroSlot( nId ) )
//STRIP001         {
//STRIP001 			SFX_APP()->GetMacroConfig()->RegisterSlotId(nId);
//STRIP001             pBox->SetItemCommand( nId, SFX_APP()->GetMacroConfig()->GetMacroInfo(nId)->GetURL() );
//STRIP001         }
//STRIP001 
//STRIP001 		pBindings->ENTERREGISTRATIONS();
//STRIP001 
//STRIP001 		SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
//STRIP001 		pBox->SetHelpText( nId, rSlotPool.GetSlotHelpText_Impl(nId) );
//STRIP001 
//STRIP001 		SfxToolBoxControl *pControl =
//STRIP001 			SfxToolBoxControl::CreateControl( nId, pBox, *pBindings, pIFace ? pIFace->GetModule() : 0 );
//STRIP001 		pControls->Append( pControl );
//STRIP001 
//STRIP001 		Window *pItemWin = pControl->CreateItemWindow(pBox);
//STRIP001 		if ( pItemWin )
//STRIP001 			pBox->SetItemWindow( nId, pItemWin );
//STRIP001         pBox->SetHelpId( nId, nHelpId );
//STRIP001 
//STRIP001 		pBindings->LEAVEREGISTRATIONS();
//STRIP001 
//STRIP001 		SetDefault(FALSE);
//STRIP001 	}
//STRIP001 	else if( !pBox->IsItemVisible( nId ) )
//STRIP001 	{
//STRIP001 		pBox->ShowItem( nId );
//STRIP001 		pBox->MoveItem( nId, nTargetPos );
//STRIP001 
//STRIP001 		SetDefault(FALSE);
//STRIP001 	}
/*?*/ }

/*?*/ void SfxToolBoxManager::RemoveItem( USHORT nId, USHORT nSourcePos )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// Es wurde ein Item entfernt
//STRIP001 	SfxToolBoxControl *pControl=0;
//STRIP001 
//STRIP001 	USHORT nPos;
//STRIP001 	for ( nPos=0; nPos<pControls->Count(); ++nPos )
//STRIP001 		if ( pControls->GetObject(nPos)->GetId() == nId )
//STRIP001 	{
//STRIP001 		pControl = pControls->GetObject(nPos);
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pControl)
//STRIP001 	{
//STRIP001 		pBindings->ENTERREGISTRATIONS();
//STRIP001 
//STRIP001 		Window *pItemWin = pBox->GetItemWindow(nId);
//STRIP001 		if ( pItemWin )
//STRIP001 		{
//STRIP001 			pItemWin->Hide();
//STRIP001 			delete pItemWin;
//STRIP001 			pBox->SetItemWindow( nId, 0 );
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pControl;
//STRIP001 		pControls->Remove(nPos);
//STRIP001 
//STRIP001 		pBindings->LEAVEREGISTRATIONS();
//STRIP001 	}
//STRIP001 
//STRIP001 	pBox->RemoveItem( nSourcePos );
//STRIP001 
//STRIP001 	if ( (pBox->GetItemType( nSourcePos ) == TOOLBOXITEM_SEPARATOR) &&
//STRIP001 		 ((pBox->GetItemType( nSourcePos-1 ) == TOOLBOXITEM_SEPARATOR) ||
//STRIP001 		  (pBox->GetItemType( nSourcePos+1 ) == TOOLBOXITEM_SEPARATOR) ||
//STRIP001 		   pBox->GetItemCount() == 1 ) )
//STRIP001 		pBox->RemoveItem( nSourcePos );
//STRIP001 
//STRIP001 	if (pBox->GetItemCount() == 0)
//STRIP001 	{
//STRIP001 		// SV austricksen, damit die Gr"o\se stimmt
//STRIP001 		((SfxToolbox*)pBox)->SetEmpty(TRUE);
//STRIP001 		USHORT nId = SID_NEWDOC;
//STRIP001 		pBox->InsertItem( nId, String());
//STRIP001         pBox->SetItemImage(nId, pBindings->GetImageManager()->GetImage(nId, pIFace ? pIFace->GetModule() : 0));
//STRIP001 		pBox->HideItem(nId);
//STRIP001 	}
//STRIP001 
//STRIP001 	SetDefault(FALSE);
/*?*/ }

//--------------------------------------------------------------------

/*N*/ BOOL SfxToolBoxManager::IsRuntimeItem( USHORT nId )
/*N*/ {
/*N*/ 	// Return true for ID's which are created during runtime and shouldn't be stored nor
/*N*/ 	// accessible through the configuration dialogs!
/*N*/ 	if (( nId >= nAddOnsStartID ) && ( nAddOnsEndID > nId ))
/*N*/ 		return TRUE;
/*N*/ 	else
/*N*/ 	{
/*N*/ 		for ( USHORT n = 0; n < SFXTOOLBOX_RUNTIMEITEM_COUNT; n++ )
/*N*/ 			if ( nId == nRuntimeIDs[n] )
/*N*/ 				return TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	return FALSE;
/*N*/ }

//--------------------------------------------------------------------

/*?*/ void SfxToolBoxManager::Customize( const ToolBoxCustomizeEvent& rCEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	USHORT nSourcePos = pBox->GetItemPos( rCEvt.GetSourceId() );
//STRIP001 	USHORT nTargetPos = rCEvt.GetTargetPos();
//STRIP001 
//STRIP001 	// Ab SV303 : Customize-Handler wird auch beim Resizen der ItemWindows
//STRIP001 	// gerufen
//STRIP001 	if ( rCEvt.IsResized() )
//STRIP001 	{
//STRIP001 		// Merken, da\s umkonfiguriert wurde, die ItemWindowBreite wird beim
//STRIP001 		// Abspeichern vom ItemWindow direkt abgeholt
//STRIP001 		SetDefault(FALSE);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( rCEvt.GetTargetBox() == NULL )
//STRIP001 	{
//STRIP001 		// Es wurde ein Item entfernt
//STRIP001 		USHORT nId = rCEvt.GetSourceId();
//STRIP001 
//STRIP001 		if ( IsRuntimeItem( nId ))
//STRIP001 			return; // Don't enable configuration of runtime items
//STRIP001 
//STRIP001 		SfxToolBoxControl *pControl=0;
//STRIP001 
//STRIP001 		USHORT nPos;
//STRIP001 		for ( nPos=0; nPos<pControls->Count(); ++nPos )
//STRIP001 			if ( pControls->GetObject(nPos)->GetId() == nId )
//STRIP001 		{
//STRIP001 			pControl = pControls->GetObject(nPos);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (pControl)
//STRIP001 		{
//STRIP001 			pBindings->ENTERREGISTRATIONS();
//STRIP001 
//STRIP001 			Window *pItemWin = pBox->GetItemWindow(nId);
//STRIP001 			if ( pItemWin )
//STRIP001 			{
//STRIP001 				pItemWin->Hide();
//STRIP001 				delete pItemWin;
//STRIP001 				pBox->SetItemWindow( nId, 0 );
//STRIP001 			}
//STRIP001 
//STRIP001 			delete pControl;
//STRIP001 			pControls->Remove(nPos);
//STRIP001 
//STRIP001 			pBindings->LEAVEREGISTRATIONS();
//STRIP001 		}
//STRIP001 
//STRIP001 		pBox->RemoveItem( nSourcePos );
//STRIP001 	}
//STRIP001 	else if ( rCEvt.GetTargetBox() == pBox )
//STRIP001 	{
//STRIP001 		// Ich bin das Target.
//STRIP001 		// Achtung: diesen Aufruf generiert der SFX, nicht SV (s.u.) !!
//STRIP001 		if (rCEvt.GetData() != 0)
//STRIP001 		{
//STRIP001 			if (((SfxToolbox*)pBox)->IsEmpty())
//STRIP001 			{
//STRIP001 				// Das DummyItem in leeren ToolBoxen entfernen
//STRIP001 				pBox->RemoveItem(0);
//STRIP001 				((SfxToolbox*)pBox)->SetEmpty(FALSE);
//STRIP001 			}
//STRIP001 
//STRIP001 			USHORT nId = rCEvt.GetSourceId();
//STRIP001 
//STRIP001 			// Habe ich das Item noch nicht ?
//STRIP001 			if (pBox->GetItemPos(nId) == TOOLBOX_ITEM_NOTFOUND)
//STRIP001 			{
//STRIP001 				// Der SFX steckt die Source-Toolbox in die User-Daten
//STRIP001 				ToolBox *pSource = (ToolBox*) rCEvt.GetData();
//STRIP001 
//STRIP001 				pBox->InsertItem( nId, pBindings->GetImageManager()->GetAndLockImage_Impl( nId,
//STRIP001 						bHiContrast,
//STRIP001 						pIFace ? pIFace->GetModule() : 0), String(), 0, nTargetPos );
//STRIP001 
//STRIP001 				SetItemText( nId, pSource->GetItemText( nId ) );
//STRIP001 
//STRIP001 				// Macros m"u\sen einen Slot anfordern
//STRIP001 				if ( SfxMacroConfig::IsMacroSlot( nId ) )
//STRIP001                 {
//STRIP001 					SFX_APP()->GetMacroConfig()->RegisterSlotId(nId);
//STRIP001                     pBox->SetItemCommand( nId, SFX_APP()->GetMacroConfig()->GetMacroInfo(nId)->GetURL() );
//STRIP001                 }
//STRIP001 
//STRIP001 				pBindings->ENTERREGISTRATIONS();
//STRIP001 
//STRIP001 				SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
//STRIP001 				pBox->SetHelpText( nId, rSlotPool.GetSlotHelpText_Impl(nId) );
//STRIP001 
//STRIP001 				SfxToolBoxControl *pControl =
//STRIP001 					SfxToolBoxControl::CreateControl( nId, pBox, *pBindings, pIFace ? pIFace->GetModule() : 0 );
//STRIP001 				pControls->Append( pControl );
//STRIP001 
//STRIP001 				Window *pItemWin = pControl->CreateItemWindow(pBox);
//STRIP001 				if ( pItemWin )
//STRIP001 					pBox->SetItemWindow( nId, pItemWin );
//STRIP001                 pBox->SetHelpId( nId, pSource->GetHelpId( nId ) );
//STRIP001 
//STRIP001 				pBindings->LEAVEREGISTRATIONS();
//STRIP001 			}
//STRIP001 			else if( !pBox->IsItemVisible( nId ) )
//STRIP001 			{
//STRIP001 				pBox->ShowItem( nId );
//STRIP001 				pBox->MoveItem( nId, nTargetPos );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( nSourcePos+1 == nTargetPos )
//STRIP001 		{
//STRIP001 			if ( pBox->GetItemType( nSourcePos-1 ) == TOOLBOXITEM_BUTTON )
//STRIP001 				pBox->InsertSeparator( nSourcePos );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( (nSourcePos == nTargetPos)  &&
//STRIP001 				 (pBox->GetItemType( nSourcePos-1 ) == TOOLBOXITEM_SEPARATOR) )
//STRIP001 				pBox->RemoveItem( nSourcePos-1 );
//STRIP001 			else
//STRIP001 				pBox->MoveItem( rCEvt.GetSourceId(), nTargetPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Eines meiner Items wird in eine andere ToolBox kopiert; also rufe
//STRIP001 		// ich dort den CustomizeHandler auf
//STRIP001 		ToolBox* pTarget = rCEvt.GetTargetBox();
//STRIP001 		if ( pTarget )
//STRIP001 		{
//STRIP001 			USHORT nId = rCEvt.GetSourceId();
//STRIP001 
//STRIP001 			if ( IsRuntimeItem( nId ))
//STRIP001 				return; // Don't enable configuration of runtime items
//STRIP001 
//STRIP001 			// Der Zugriff auf eine protected method ...
//STRIP001 			ToolBoxCustomizeEvent aEvnt (pTarget, nId, nTargetPos, pBox);
//STRIP001 			((TbAccess_Impl*)pTarget)->CustomizeToolBox(aEvnt);
//STRIP001 		}
//STRIP001 
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( (pBox->GetItemType( nSourcePos ) == TOOLBOXITEM_SEPARATOR) &&
//STRIP001 		 ((pBox->GetItemType( nSourcePos-1 ) == TOOLBOXITEM_SEPARATOR) ||
//STRIP001 		  (pBox->GetItemType( nSourcePos+1 ) == TOOLBOXITEM_SEPARATOR) ||
//STRIP001 		   pBox->GetItemCount() == 1 ) )
//STRIP001 		pBox->RemoveItem( nSourcePos );
//STRIP001 
//STRIP001 	if (pBox->GetItemCount() == 0)
//STRIP001 	{
//STRIP001 		// SV austricksen, damit die Gr"o\se stimmt
//STRIP001 		((SfxToolbox*)pBox)->SetEmpty(TRUE);
//STRIP001 		USHORT nId = SID_NEWDOC;
//STRIP001 		pBox->InsertItem( nId, String());
//STRIP001         pBox->SetItemImage(nId, pBindings->GetImageManager()->GetImage(nId, pIFace ? pIFace->GetModule() : 0));
//STRIP001 		pBox->HideItem(nId);
//STRIP001 	}
//STRIP001 
//STRIP001 	SetDefault(FALSE);
//STRIP001 //    if ( !pBox->IsInCustomizeMode() )
//STRIP001 	SfxConfigManager* pCfgMgr = GetConfigManager();
//STRIP001 
//STRIP001 	pCfgMgr->StoreConfigItem( *this );
//STRIP001 	pCfgMgr->StoreConfiguration();
//STRIP001 	pCfgMgr->ReInitialize( GetType() );
//STRIP001 
//STRIP001 //	StoreConfig();
//STRIP001 //	ReInitialize(); // Notify all toolbox managers that the configuration has changed!
//STRIP001 
//STRIP001 	// Es k"onnte sein, da\s sich durch das neue Item die Gr"o\se der
//STRIP001 	// ToolBox ge"andert hat
//STRIP001 	SfxDispatcher* pDisp = GetBindings().GetDispatcher_Impl();
//STRIP001 	if ( pDisp )
//STRIP001 	{
//STRIP001 		SfxViewFrame  *pFrame  = pDisp->GetFrame();
//STRIP001 		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
//STRIP001 		pWorkWin->ConfigChild_Impl
//STRIP001 			( SFX_CHILDWIN_OBJECTBAR, SFX_ALIGNDOCKINGWINDOW, GetType() );
//STRIP001 	}
/*?*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::UpdateControls_Impl()

/*	Interne Methode zum erneuten Updaten aller SfxToolBoxContoller in
	diesem SfxToolBoxManager. Z.B. nach Umschaltung der Button-Art.
*/

/*N*/ {
/*N*/ 	for ( USHORT n = 0; n < pControls->Count(); ++n )
/*N*/ 	{
/*N*/ 		SfxToolBoxControl *pControl = pControls->GetObject(n);
/*N*/ 		if ( pControl->IsBound() )
/*N*/ 			pBindings->GetStateCache( pControl->GetId() )->SetCachedState();
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*?*/ void SfxToolBoxManager::Show()
/*?*/ {
//	  if (pBox->IsFloatingMode() == FALSE)
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pBox->Show();
/*?*/ }


//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::Hide()
/*N*/ {
/*N*/ //	  if (pBox->IsFloatingMode() == FALSE)
/*N*/ 		pBox->Hide();
/*N*/ }


// ------------------------------------------------------------------------

/*?*/ String SfxToolBoxManager::GetStreamName() const
/*?*/ {
/*
	if (pBox)
		return pBox->GetText();

	ResId aResId(GetType());
	aResId.SetRT(RSC_STRING);
	aResId.SetResMgr(pResMgr);
	if (Resource::GetResManager()->IsAvailable(aResId))
		return String(aResId);
	else
		return String();
*/
/*?*/     return SfxConfigItem::GetStreamName( GetType() );
/*?*/ }

/*?*/ BOOL SfxToolBoxManager::ReInitialize()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	SfxToolbox *pTbx = (SfxToolbox*) pBox;
//STRIP001 	pTbx->bReconfigure = TRUE;
//STRIP001     BOOL bRet = SfxConfigItem::ReInitialize();
//STRIP001 	pTbx->bReconfigure = FALSE;
//STRIP001 	const Link& aChangedListener = pTbx->GetChangedListener();
//STRIP001 	if ( aChangedListener.IsSet() )
//STRIP001 		aChangedListener.Call( this );
//STRIP001 	return bRet;
/*?*/ }

/*N*/ void SfxToolBoxManager::Reconfigure_Impl( SfxToolBoxConfig* pTbxCfg )
/*N*/ {
/*N*/ }

//---------------------------------------------------------------------------
// ObjectBars werden niemals direkt "uber den dtor, sondern nur "uber diese
// Methode gel"oscht. Falls diese Toolbox gerade aktiv ist, stehen wir mitten
// im SV und m"u\sen daher asynchron l"oschen.


/*?*/ void SfxToolBoxManager::Delete()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( ((SfxToolbox*)pBox)->bActivated || ((SfxToolbox*)pBox)->HasChildPathFocus() )
//STRIP001 	{
//STRIP001 		((SfxToolbox*)pBox)->bDeleteToolBox = TRUE;
//STRIP001         GetpApp()->PostUserEvent(LINK(pBox, SfxToolbox, Delete), (void*)0);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		delete this;
/*?*/ }

//-------------------------------------------------------------------------
// Diese statische Methode erkennt an der "ubergebenen Id, ob es sich um eine
// benutzerdefinierte Toolbox handelt.


/*?*/ BOOL SfxToolBoxManager::IsUserDefToolBox_Impl(USHORT nId)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	if ( nId >= RID_SFX_TOOLBOX_USERSTART && nId <= RID_SFX_TOOLBOX_USEREND )
//STRIP001 		return TRUE;
//STRIP001 	else
//STRIP001 		return FALSE;
/*?*/ }

//-------------------------------------------------------------------------
// Mit dieser statischen Methode kann eine f"ur die Lebensdauer der Toolbox
// g"ultige, eindeutige Id f"ur eine benutzerdefinierte ToolBox angefordert
// werden.


/*?*/ USHORT SfxToolBoxManager::GetUserDefToolBoxId_Impl()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	USHORT nRet=0;
//STRIP001 	for ( USHORT nId=RID_SFX_TOOLBOX_USERSTART;
//STRIP001 			nId <= RID_SFX_TOOLBOX_USEREND; nId++ )
//STRIP001 	{
//STRIP001 		for (SfxInterface *pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0;
//STRIP001 				pIFace = SFX_SLOTPOOL().NextInterface())
//STRIP001 		{
//STRIP001 			// Nur Interfaces mit Namen d"urfen welche bekommen
//STRIP001 			if ( pIFace->HasName())
//STRIP001 			{
//STRIP001 				if ( pIFace->HasObjectBar(nId) )
//STRIP001 					break;
//STRIP001 				else
//STRIP001 					nRet = nId;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Hurra, gefunden !
//STRIP001 		if ( nRet )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
/*?*/ }

//STRIP001 void SfxToolBoxManager::ReInitControllers_Impl()
//STRIP001 {
//STRIP001 	if ( IsDefault() )
//STRIP001 		return;
//STRIP001 	if (pControls)
//STRIP001 	{
//STRIP001 		pBindings->ENTERREGISTRATIONS();
//STRIP001 		for ( USHORT n = 0; n < pControls->Count(); ++n )
//STRIP001 		{
//STRIP001 			SfxToolBoxControl *pControl = pControls->GetObject(n);
//STRIP001 			if ( !pControl->IsBound() )
//STRIP001 				continue;
//STRIP001 			SfxToolBoxControl *pNew = pControl->ReInit_Impl();
//STRIP001 			if ( pNew != pControl )
//STRIP001 			{
//STRIP001 				USHORT nId = pNew->GetId();
//STRIP001 
//STRIP001 				Window *pNewItemWin = pNew->CreateItemWindow( pBox );
//STRIP001 
//STRIP001 				Window *pItemWin = pBox->GetItemWindow( nId );
//STRIP001 				if ( pItemWin )
//STRIP001 				{
//STRIP001 					pItemWin->Hide();
//STRIP001 					delete pItemWin;
//STRIP001 				}
//STRIP001 
//STRIP001 				pBox->SetItemWindow( nId, pNewItemWin );
//STRIP001 
//STRIP001 				pControls->GetObject(n) = pNew;
//STRIP001 				delete pControl;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		pBindings->LEAVEREGISTRATIONS();
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxToolBoxManager::NextToolBox()
//STRIP001 {
//STRIP001 	SfxDispatcher* pDisp = GetBindings().GetDispatcher_Impl();
//STRIP001 	if ( pDisp )
//STRIP001 		pDisp->ShowObjectBar( GetNextToolBox_Impl() );
//STRIP001 }

/*N*/ USHORT SfxToolBoxManager::GetNextToolBox_Impl( String *pStr )
/*N*/ {
/*N*/ 	SfxDispatcher* pDisp = GetBindings().GetDispatcher_Impl();
/*N*/ 	if ( pDisp )
/*N*/ 		return pDisp->GetNextToolBox_Impl( ((SfxToolbox*)pBox)->nPos, GetType(), pStr );
/*N*/ 	else
/*N*/ 		return 0;
/*N*/ }

/*?*/ void SfxToolBoxManager::SetItemText( USHORT nId, const String& rText )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( SfxMacroConfig::IsMacroSlot( nId ) )
//STRIP001 	{
//STRIP001 		( (SfxToolbox*)pBox )->SetItemText_Impl( nId, TRUE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxSlotPool& rSlotPool = pIFace && pIFace->GetModule()
//STRIP001 			? *pIFace->GetModule()->GetSlotPool() : SFX_APP()->GetSlotPool();
//STRIP001 		if ( rSlotPool.GetSlotName_Impl( nId ) != rText )
//STRIP001 			( (SfxToolbox*)pBox )->SetItemText_Impl( nId, TRUE );
//STRIP001 		else
//STRIP001 			( (SfxToolbox*)pBox )->SetItemText_Impl( nId, FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	pBox->SetItemText( nId, rText );
/*?*/ }

/*?*/ BOOL SfxToolBoxManager::IsInternal()
/*?*/ {
/*?*/     return bInternal;
/*?*/ }

/*?*/ void SfxToolBoxManager::CreateConfiguration( SfxConfigManager* pMgr, USHORT nId )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( !pMgr->HasConfigItem( nId ) )
//STRIP001 	{
//STRIP001 		SfxToolBoxManager* pTbx = new SfxToolBoxManager( pMgr, nId );
//STRIP001 		pTbx->SetDefault( FALSE );
//STRIP001 		pTbx->StoreConfig();
//STRIP001 		delete pTbx;
//STRIP001 	}
/*?*/ }

/*?*/ void SfxToolBoxManager::RemoveConfiguration( SfxConfigManager* pMgr, USHORT nId )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( pMgr->HasConfigItem( nId ) )
//STRIP001 	{
//STRIP001 		pMgr->RemovePersistentConfigItem( nId );
//STRIP001 	}
/*?*/ }
}
