/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tpcolor.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:10:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#ifndef _SV_COLRDLG_HXX
#include <svtools/colrdlg.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen wg. ErrorBox
#include <vcl/msgbox.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif
#pragma hdrstop

#define _SVX_TPCOLOR_CXX
#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE

#include "dialogs.hrc"
#include "helpid.hrc"

#include "xattr.hxx"
#include "xpool.hxx"
#include "xtable.hxx"
#include "drawitem.hxx"
#include "tabarea.hxx"
#include "tabarea.hrc"
#include "dlgname.hxx"
#include "dlgname.hrc"
#include "dialmgr.hxx"
namespace binfilter {

//STRIP001 #define DLGWIN GetParentDialog( this )
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Dialog zum Aendern und Definieren der Farben
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 static Window* GetParentDialog( Window* pWindow )
//STRIP001 {
//STRIP001 	while( pWindow )
//STRIP001 	{
//STRIP001 		if( pWindow->IsDialog() )
//STRIP001 			break;
//STRIP001 
//STRIP001 		pWindow = pWindow->GetParent();
//STRIP001 	}
//STRIP001 
//STRIP001 	return pWindow;
//STRIP001 }
//STRIP001 
//STRIP001 SvxColorTabPage::SvxColorTabPage
//STRIP001 (
//STRIP001 	Window* pParent,
//STRIP001 	const SfxItemSet& rInAttrs
//STRIP001 ) :
//STRIP001 
//STRIP001 	SfxTabPage			( pParent, SVX_RES( RID_SVXPAGE_COLOR ), rInAttrs ),
//STRIP001 
//STRIP001 	pXPool				( (XOutdevItemPool*) rInAttrs.GetPool() ),
//STRIP001 	XOutOld 			( &aCtlPreviewOld ),
//STRIP001 	XOutNew 			( &aCtlPreviewNew ),
//STRIP001 	aXFillAttr			( pXPool ),
//STRIP001 	rXFSet				( aXFillAttr.GetItemSet() ),
//STRIP001 
//STRIP001 	aXFStyleItem		( XFILL_SOLID ),
//STRIP001 	aXFillColorItem 	( String(), Color( COL_BLACK ) ),
//STRIP001 
//STRIP001     aFlProp             ( this, ResId( FL_PROP ) ),
//STRIP001     aValSetColorTable   ( this, ResId( CTL_COLORTABLE ) ),
//STRIP001 //    aGrpColorTable      ( this, ResId( GRP_COLORTABLE ) ),
//STRIP001     aTableNameFT        ( this, ResId( FT_TABLE_NAME ) ),
//STRIP001     aFtName             ( this, ResId( FT_NAME ) ),
//STRIP001 	aEdtName			( this, ResId( EDT_NAME ) ),
//STRIP001 	aFtColor			( this, ResId( FT_COLOR ) ),
//STRIP001 	aLbColor			( this, ResId( LB_COLOR ) ),
//STRIP001 	aLbColorModel		( this, ResId( LB_COLORMODEL ) ),
//STRIP001 	aFtColorModel1		( this, ResId( FT_1 ) ),
//STRIP001 	aMtrFldColorModel1	( this, ResId( MTR_FLD_1 ) ),
//STRIP001 	aFtColorModel2		( this, ResId( FT_2 ) ),
//STRIP001 	aMtrFldColorModel2	( this, ResId( MTR_FLD_2 ) ),
//STRIP001 	aFtColorModel3		( this, ResId( FT_3 ) ),
//STRIP001 	aMtrFldColorModel3	( this, ResId( MTR_FLD_3 ) ),
//STRIP001 	aFtColorModel4		( this, ResId( FT_4 ) ),
//STRIP001 	aMtrFldColorModel4	( this, ResId( MTR_FLD_4 ) ),
//STRIP001 //    aGrpColorModel      ( this, ResId( GRP_COLORMODEL ) ),
//STRIP001 	aBtnAdd 			( this, ResId( BTN_ADD ) ),
//STRIP001 	aBtnModify			( this, ResId( BTN_MODIFY ) ),
//STRIP001 	aBtnWorkOn			( this, ResId( BTN_WORK_ON ) ),
//STRIP001 	aBtnDelete			( this, ResId( BTN_DELETE ) ),
//STRIP001 	aCtlPreviewOld		( this, ResId( CTL_PREVIEW_OLD ), &XOutOld ),
//STRIP001 	aCtlPreviewNew		( this, ResId( CTL_PREVIEW_NEW ), &XOutNew ),
//STRIP001 //    aGrpPreview         ( this, ResId( GRP_PREVIEW ) ),
//STRIP001 	aBtnLoad			( this, ResId( BTN_LOAD ) ),
//STRIP001 	aBtnSave			( this, ResId( BTN_SAVE ) ),
//STRIP001 
//STRIP001 	rOutAttrs			( rInAttrs ),
//STRIP001 	bDeleteColorTable	( TRUE ),
//STRIP001 	eCM					( CM_RGB )
//STRIP001 
//STRIP001 {
//STRIP001 	aBtnLoad.SetModeImage( Image( ResId( RID_SVXIMG_LOAD_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 	aBtnSave.SetModeImage( Image( ResId( RID_SVXIMG_SAVE_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// Setzen des Output-Devices
//STRIP001 	rXFSet.Put( aXFStyleItem );
//STRIP001 	rXFSet.Put( aXFillColorItem );
//STRIP001 	XOutOld.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	XOutNew.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 	// Setzen der Linie auf None im OutputDevice
//STRIP001 	XLineAttrSetItem aXLineAttr( pXPool );
//STRIP001     aXLineAttr.GetItemSet().Put( XLineStyleItem( XLINE_SOLID ) );
//STRIP001     aXLineAttr.GetItemSet().Put( XLineWidthItem( 1 ));
//STRIP001 	XOutOld.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 	XOutNew.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001 	// Handler ueberladen
//STRIP001 	aLbColor.SetSelectHdl(
//STRIP001 		LINK( this, SvxColorTabPage, SelectColorLBHdl_Impl ) );
//STRIP001 	aValSetColorTable.SetSelectHdl(
//STRIP001 		LINK( this, SvxColorTabPage, SelectValSetHdl_Impl ) );
//STRIP001 	aLbColorModel.SetSelectHdl(
//STRIP001 		LINK( this, SvxColorTabPage, SelectColorModelHdl_Impl ) );
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SvxColorTabPage, ModifiedHdl_Impl );
//STRIP001 	aMtrFldColorModel1.SetModifyHdl( aLink );
//STRIP001 	aMtrFldColorModel2.SetModifyHdl( aLink );
//STRIP001 	aMtrFldColorModel3.SetModifyHdl( aLink );
//STRIP001 	aMtrFldColorModel4.SetModifyHdl( aLink );
//STRIP001 
//STRIP001 	aBtnAdd.SetClickHdl( LINK( this, SvxColorTabPage, ClickAddHdl_Impl ) );
//STRIP001 	aBtnModify.SetClickHdl(
//STRIP001 		LINK( this, SvxColorTabPage, ClickModifyHdl_Impl ) );
//STRIP001 	aBtnWorkOn.SetClickHdl(
//STRIP001 		LINK( this, SvxColorTabPage, ClickWorkOnHdl_Impl ) );
//STRIP001 	aBtnDelete.SetClickHdl(
//STRIP001 		LINK( this, SvxColorTabPage, ClickDeleteHdl_Impl ) );
//STRIP001 	aBtnLoad.SetClickHdl( LINK( this, SvxColorTabPage, ClickLoadHdl_Impl ) );
//STRIP001 	aBtnSave.SetClickHdl( LINK( this, SvxColorTabPage, ClickSaveHdl_Impl ) );
//STRIP001 
//STRIP001 	// ValueSet
//STRIP001 	aValSetColorTable.SetStyle( aValSetColorTable.GetStyle() | WB_VSCROLL | WB_ITEMBORDER );
//STRIP001 	aValSetColorTable.SetColCount( 8 );
//STRIP001 	aValSetColorTable.SetLineCount( 10 );
//STRIP001 	aValSetColorTable.SetExtraSpacing( 0 );
//STRIP001 	aValSetColorTable.Show();
//STRIP001 
//STRIP001 	pColorTab = NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxColorTabPage::Construct()
//STRIP001 {
//STRIP001 	aLbColor.Fill( pColorTab );
//STRIP001 	FillValueSet_Impl( aValSetColorTable );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxColorTabPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	if( *pDlgType == 0 ) // Flaechen-Dialog
//STRIP001 	{
//STRIP001 		*pbAreaTP = FALSE;
//STRIP001 
//STRIP001 		if( pColorTab )
//STRIP001 		{
//STRIP001 			if( *pPageType == PT_COLOR && *pPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			{
//STRIP001 				aLbColor.SelectEntryPos( *pPos );
//STRIP001 				aValSetColorTable.SelectItem( aLbColor.GetSelectEntryPos() + 1 );
//STRIP001 				aEdtName.SetText( aLbColor.GetSelectEntry() );
//STRIP001 
//STRIP001 				ChangeColorHdl_Impl( this );
//STRIP001 			}
//STRIP001 			else if( *pPageType == PT_COLOR && *pPos == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			{
//STRIP001 				const SfxPoolItem* pPoolItem = NULL;
//STRIP001 				if( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLCOLOR ), TRUE, &pPoolItem ) )
//STRIP001 				{
//STRIP001 					aLbColorModel.SelectEntryPos( CM_RGB );
//STRIP001 
//STRIP001 					aAktuellColor.SetColor ( ( ( const XFillColorItem* ) pPoolItem )->GetValue().GetColor() );
//STRIP001 
//STRIP001 					aEdtName.SetText( ( ( const XFillColorItem* ) pPoolItem )->GetName() );
//STRIP001 
//STRIP001 					aMtrFldColorModel1.SetValue( ColorToPercent_Impl( aAktuellColor.GetRed() ) );
//STRIP001 					aMtrFldColorModel2.SetValue( ColorToPercent_Impl( aAktuellColor.GetGreen() ) );
//STRIP001 					aMtrFldColorModel3.SetValue( ColorToPercent_Impl( aAktuellColor.GetBlue() ) );
//STRIP001 
//STRIP001 					// ItemSet fuellen und an XOut weiterleiten
//STRIP001 					rXFSet.Put( XFillColorItem( String(), aAktuellColor ) );
//STRIP001 					XOutOld.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 					XOutNew.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 					aCtlPreviewNew.Invalidate();
//STRIP001 					aCtlPreviewOld.Invalidate();
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 			// der GroupBox darstellen
//STRIP001 			String			aString( SVX_RES( RID_SVXSTR_TABLE ) ); aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 			INetURLObject	aURL( pColorTab->GetPath() );
//STRIP001 
//STRIP001 			aURL.Append( pColorTab->GetName() );
//STRIP001 			DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 			if ( aURL.getBase().Len() > 18 )
//STRIP001 			{
//STRIP001 				aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 				aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aString += aURL.getBase();
//STRIP001 
//STRIP001             aTableNameFT.SetText( aString );
//STRIP001 
//STRIP001 			// Damit evtl. geaenderte Farbe verworfen wird
//STRIP001 			SelectColorLBHdl_Impl( this );
//STRIP001 
//STRIP001 			*pPageType = PT_COLOR;
//STRIP001 			*pPos = LISTBOX_ENTRY_NOTFOUND;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Buttons werden gehided, weil Paletten z.Z. nur
//STRIP001 		// ueber den AreaDlg funktionieren!!!
//STRIP001 		// ActivatePage() muss von anderen Dialogen explizit
//STRIP001 		// gerufen werden, da ActivatePage() nicht gerufen wird,
//STRIP001 		// wenn Seite als Erste im Dialog angezeigt wird
//STRIP001 		aBtnLoad.Hide();
//STRIP001 		aBtnSave.Hide();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxColorTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( CheckChanges_Impl() == -1L )
//STRIP001 		return( KEEP_PAGE );
//STRIP001 
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return( LEAVE_PAGE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxColorTabPage::CheckChanges_Impl()
//STRIP001 {
//STRIP001 	// wird hier benutzt, um Aenderungen NICHT zu verlieren
//STRIP001 
//STRIP001 	Color aTmpColor (aAktuellColor);
//STRIP001 	if (eCM != CM_RGB)
//STRIP001 		ConvertColorValues (aTmpColor, CM_RGB);
//STRIP001 
//STRIP001 	USHORT nPos = aLbColor.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		Color aColor = pColorTab->Get( nPos )->GetColor();
//STRIP001 		String aString = aLbColor.GetSelectEntry();
//STRIP001 
//STRIP001 		// aNewColor, da COL_USER != COL_irgendwas, auch wenn RGB-Werte gleich
//STRIP001 		// Color aNewColor( aColor.GetRed(), aColor.GetGreen(), aColor.GetBlue() );
//STRIP001 
//STRIP001 		if( ColorToPercent_Impl( aTmpColor.GetRed() ) != ColorToPercent_Impl( aColor.GetRed() ) ||
//STRIP001 			ColorToPercent_Impl( aTmpColor.GetGreen() ) != ColorToPercent_Impl( aColor.GetGreen() ) ||
//STRIP001 			ColorToPercent_Impl( aTmpColor.GetBlue() ) != ColorToPercent_Impl( aColor.GetBlue() ) ||
//STRIP001 			aString != aEdtName.GetText() )
//STRIP001 		{
//STRIP001 			ResMgr* pMgr = DIALOG_MGR();
//STRIP001             Image aWarningBoxImage = WarningBox::GetStandardImage();
//STRIP001 			SvxMessDialog aMessDlg( DLGWIN,
//STRIP001 				String( ResId( RID_SVXSTR_COLOR, pMgr ) ),
//STRIP001 				String( ResId( RID_SVXSTR_ASK_CHANGE_COLOR, pMgr ) ),
//STRIP001 				&aWarningBoxImage );
//STRIP001 
//STRIP001 			aMessDlg.SetButtonText( MESS_BTN_1,
//STRIP001 									String( ResId( RID_SVXSTR_CHANGE, pMgr ) ) );
//STRIP001 			aMessDlg.SetButtonText( MESS_BTN_2,
//STRIP001 									String( ResId( RID_SVXSTR_ADD, pMgr ) ) );
//STRIP001 
//STRIP001 			short nRet = aMessDlg.Execute();
//STRIP001 
//STRIP001 			switch( nRet )
//STRIP001 			{
//STRIP001 				case RET_BTN_1: // Aendern
//STRIP001 				{
//STRIP001 					ClickModifyHdl_Impl( this );
//STRIP001 					aColor = pColorTab->Get( nPos )->GetColor();
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case RET_BTN_2: // Hinzufuegen
//STRIP001 				{
//STRIP001 					ClickAddHdl_Impl( this );
//STRIP001 					nPos = aLbColor.GetSelectEntryPos();
//STRIP001 					aColor = pColorTab->Get( nPos )->GetColor();
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case RET_CANCEL:
//STRIP001 					// return( -1L ); <-- wuerde die Seite nicht verlassen
//STRIP001 				break;
//STRIP001 				// return( TRUE ); // Abbruch
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( *pDlgType == 0 ) // Flaechen-Dialog
//STRIP001 	{
//STRIP001 		nPos = aLbColor.GetSelectEntryPos();
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		{
//STRIP001 			*pPos = nPos;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxColorTabPage::FillItemSet( SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	if( ( *pDlgType != 0 ) ||
//STRIP001 		( *pPageType == PT_COLOR && *pbAreaTP == FALSE ) )
//STRIP001 	{
//STRIP001 		String aString;
//STRIP001 		Color  aColor;
//STRIP001 
//STRIP001 		// CheckChanges_Impl(); <-- doppelte Abfrage ?
//STRIP001 
//STRIP001 		USHORT nPos = aLbColor.GetSelectEntryPos();
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		{
//STRIP001 			aColor	= pColorTab->Get( nPos )->GetColor();
//STRIP001 			aString = aLbColor.GetSelectEntry();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aColor.SetColor (aAktuellColor.GetColor());
//STRIP001 			if (eCM != CM_RGB)
//STRIP001 				ConvertColorValues (aColor, CM_RGB);
//STRIP001 		}
//STRIP001 		rOutAttrs.Put( XFillColorItem( aString, aColor ) );
//STRIP001 		rOutAttrs.Put( XFillStyleItem( XFILL_SOLID ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxColorTabPage::Reset( const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	USHORT nState = rOutAttrs.GetItemState( XATTR_FILLCOLOR );
//STRIP001 
//STRIP001 	if ( nState >= SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		XFillColorItem aColorItem( (const XFillColorItem&)rOutAttrs.Get( XATTR_FILLCOLOR ) );
//STRIP001 		aLbColor.SelectEntry( aColorItem.GetValue() );
//STRIP001 		aValSetColorTable.SelectItem( aLbColor.GetSelectEntryPos() + 1 );
//STRIP001 		aEdtName.SetText( aLbColor.GetSelectEntry() );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Farbmodell setzen
//STRIP001 	String aStr = GetUserData();
//STRIP001 	aLbColorModel.SelectEntryPos( (USHORT) aStr.ToInt32() );
//STRIP001 
//STRIP001 	ChangeColorHdl_Impl( this );
//STRIP001 	SelectColorModelHdl_Impl( this );
//STRIP001 
//STRIP001 	aCtlPreviewOld.Invalidate();
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( pColorTab->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnWorkOn.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnWorkOn.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxColorTabPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	return( new SvxColorTabPage( pWindow, rOutAttrs ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 //
//STRIP001 // Wird aufgerufen, wenn Inhalt der MtrFileds fr Farbwerte verndert wird
//STRIP001 //
//STRIP001 IMPL_LINK( SvxColorTabPage, ModifiedHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	// lese aktuelle MtrFields aus, wenn cmyk, dann k-Wert als Trans.-Farbe
//STRIP001 	aAktuellColor.SetColor ( Color( (UINT8)PercentToColor_Impl( (USHORT) aMtrFldColorModel4.GetValue() ),
//STRIP001 									(UINT8)PercentToColor_Impl( (USHORT) aMtrFldColorModel1.GetValue() ),
//STRIP001 									(UINT8)PercentToColor_Impl( (USHORT) aMtrFldColorModel2.GetValue() ),
//STRIP001 									(UINT8)PercentToColor_Impl( (USHORT) aMtrFldColorModel3.GetValue() ) ).GetColor() );
//STRIP001 
//STRIP001 	Color aTmpColor(aAktuellColor);
//STRIP001 	if (eCM != CM_RGB)
//STRIP001 		ConvertColorValues (aTmpColor, CM_RGB);
//STRIP001 
//STRIP001 	rXFSet.Put( XFillColorItem( String(), aTmpColor ) );
//STRIP001 	XOutNew.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 	aCtlPreviewNew.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 //
//STRIP001 // Button 'Hinzufgen'
//STRIP001 //
//STRIP001 IMPL_LINK( SvxColorTabPage, ClickAddHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	Window *pWindow = this;
//STRIP001 	bool bEnabled;
//STRIP001 	while( pWindow )
//STRIP001 	{
//STRIP001 		bEnabled = pWindow->IsEnabled();
//STRIP001 		pWindow = pWindow->GetParent();
//STRIP001 	}
//STRIP001 
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	String aDesc( ResId( RID_SVXSTR_DESC_COLOR, pMgr ) );
//STRIP001 	String aName( aEdtName.GetText() );
//STRIP001 	XColorEntry* pEntry;
//STRIP001 	long nCount = pColorTab->Count();
//STRIP001 	BOOL bDifferent = TRUE;
//STRIP001 
//STRIP001 	// Pruefen, ob Name schon vorhanden ist
//STRIP001 	for ( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 		if ( aName == pColorTab->Get( i )->GetName() )
//STRIP001 			bDifferent = FALSE;
//STRIP001 
//STRIP001 	// Wenn ja, wird wiederholt ein neuer Name angefordert
//STRIP001 	if ( !bDifferent )
//STRIP001 	{
//STRIP001 		WarningBox aWarningBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 			String( ResId( RID_SVXSTR_WARN_NAME_DUPLICATE, pMgr ) ) );
//STRIP001 		aWarningBox.SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 		aWarningBox.Execute();
//STRIP001 
//STRIP001 		SvxNameDialog* pDlg = new SvxNameDialog( DLGWIN, aName, aDesc );
//STRIP001 		BOOL bLoop = TRUE;
//STRIP001 
//STRIP001 		while ( !bDifferent && bLoop && pDlg->Execute() == RET_OK )
//STRIP001 		{
//STRIP001 			pDlg->GetName( aName );
//STRIP001 			bDifferent = TRUE;
//STRIP001 
//STRIP001 			for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			{
//STRIP001 				if( aName == pColorTab->Get( i )->GetName() )
//STRIP001 					bDifferent = FALSE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bDifferent )
//STRIP001 				bLoop = FALSE;
//STRIP001 			else
//STRIP001 				aWarningBox.Execute();
//STRIP001 		}
//STRIP001 		delete( pDlg );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Wenn nicht vorhanden, wird Eintrag aufgenommen
//STRIP001 	if( bDifferent )
//STRIP001 	{
//STRIP001 		if (eCM != CM_RGB)
//STRIP001 			ConvertColorValues (aAktuellColor, CM_RGB);
//STRIP001 		pEntry = new XColorEntry( aAktuellColor, aName );
//STRIP001 
//STRIP001 		pColorTab->Insert( pColorTab->Count(), pEntry );
//STRIP001 
//STRIP001 		aLbColor.Append( pEntry );
//STRIP001 		aValSetColorTable.InsertItem( aValSetColorTable.GetItemCount() + 1,
//STRIP001 				pEntry->GetColor(), pEntry->GetName() );
//STRIP001 
//STRIP001 		aLbColor.SelectEntryPos( aLbColor.GetEntryCount() - 1 );
//STRIP001 
//STRIP001 		// Flag fuer modifiziert setzen
//STRIP001 		*pnColorTableState |= CT_MODIFIED;
//STRIP001 
//STRIP001 		SelectColorLBHdl_Impl( this );
//STRIP001 	}
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( pColorTab->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnWorkOn.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 //
//STRIP001 // Button 'ndern'
//STRIP001 //
//STRIP001 IMPL_LINK( SvxColorTabPage, ClickModifyHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbColor.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		ResMgr* pMgr = DIALOG_MGR();
//STRIP001 		String aDesc( ResId( RID_SVXSTR_DESC_COLOR, pMgr ) );
//STRIP001 		String aName( aEdtName.GetText() );
//STRIP001 		long nCount = pColorTab->Count();
//STRIP001 		BOOL bDifferent = TRUE;
//STRIP001 
//STRIP001 		// Pruefen, ob Name schon vorhanden ist
//STRIP001 		for ( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			if ( aName == pColorTab->Get( i )->GetName() && nPos != i )
//STRIP001 				bDifferent = FALSE;
//STRIP001 
//STRIP001 		// Wenn ja, wird wiederholt ein neuer Name angefordert
//STRIP001 		if ( !bDifferent )
//STRIP001 		{
//STRIP001 			WarningBox aWarningBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 				String( ResId( RID_SVXSTR_WARN_NAME_DUPLICATE, pMgr ) ) );
//STRIP001 			aWarningBox.SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 			aWarningBox.Execute();
//STRIP001 
//STRIP001 			SvxNameDialog* pDlg = new SvxNameDialog( DLGWIN, aName, aDesc );
//STRIP001 			BOOL bLoop = TRUE;
//STRIP001 
//STRIP001 			while ( !bDifferent && bLoop && pDlg->Execute() == RET_OK )
//STRIP001 			{
//STRIP001 				pDlg->GetName( aName );
//STRIP001 				bDifferent = TRUE;
//STRIP001 
//STRIP001 				for ( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 					if( aName == pColorTab->Get( i )->GetName() &&	nPos != i )
//STRIP001 						bDifferent = FALSE;
//STRIP001 
//STRIP001 				if( bDifferent )
//STRIP001 					bLoop = FALSE;
//STRIP001 				else
//STRIP001 					aWarningBox.Execute();
//STRIP001 			}
//STRIP001 			delete( pDlg );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Wenn nicht vorhanden, wird Eintrag aufgenommen
//STRIP001 		if( bDifferent )
//STRIP001 		{
//STRIP001 			XColorEntry* pEntry = pColorTab->Get( nPos );
//STRIP001 
//STRIP001 			Color aTmpColor (aAktuellColor);
//STRIP001 			if (eCM != CM_RGB)
//STRIP001 				ConvertColorValues (aTmpColor, CM_RGB);
//STRIP001 
//STRIP001 			pEntry->SetColor( aTmpColor );
//STRIP001 			pEntry->SetName( aName );
//STRIP001 
//STRIP001 			aLbColor.Modify( pEntry, nPos );
//STRIP001 			aLbColor.SelectEntryPos( nPos );
//STRIP001 			/////
//STRIP001 			aValSetColorTable.SetItemColor( nPos + 1, pEntry->GetColor() );
//STRIP001 			aValSetColorTable.SetItemText( nPos + 1, pEntry->GetName() );
//STRIP001 			aEdtName.SetText( aName );
//STRIP001 
//STRIP001 			aCtlPreviewOld.Invalidate();
//STRIP001 
//STRIP001 			// Flag fuer modifiziert setzen
//STRIP001 			*pnColorTableState |= CT_MODIFIED;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 //
//STRIP001 // Button 'Bearbeiten'
//STRIP001 //
//STRIP001 IMPL_LINK( SvxColorTabPage, ClickWorkOnHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	SvColorDialog* pColorDlg = new SvColorDialog( DLGWIN );
//STRIP001 
//STRIP001 	Color aTmpColor (aAktuellColor);
//STRIP001 	if (eCM != CM_RGB)
//STRIP001 		ConvertColorValues (aTmpColor, CM_RGB);
//STRIP001 
//STRIP001 	pColorDlg->SetColor (aTmpColor);
//STRIP001 
//STRIP001 	if( pColorDlg->Execute() == RET_OK )
//STRIP001 	{
//STRIP001 		USHORT nK = 0;
//STRIP001 		Color aPreviewColor = pColorDlg->GetColor();
//STRIP001 		aAktuellColor = aPreviewColor;
//STRIP001 		if (eCM != CM_RGB)
//STRIP001 			ConvertColorValues (aAktuellColor, eCM);
//STRIP001 
//STRIP001 		aMtrFldColorModel1.SetValue( ColorToPercent_Impl( aAktuellColor.GetRed() ) );
//STRIP001 		aMtrFldColorModel2.SetValue( ColorToPercent_Impl( aAktuellColor.GetGreen() ) );
//STRIP001 		aMtrFldColorModel3.SetValue( ColorToPercent_Impl( aAktuellColor.GetBlue() ) );
//STRIP001 		aMtrFldColorModel4.SetValue( ColorToPercent_Impl( nK ) );
//STRIP001 
//STRIP001 		// ItemSet fuellen und an XOut weiterleiten
//STRIP001 		rXFSet.Put( XFillColorItem( String(), aPreviewColor ) );
//STRIP001 		//XOutOld.SetFillAttr( aXFillAttr );
//STRIP001 		XOutNew.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 		aCtlPreviewNew.Invalidate();
//STRIP001 	}
//STRIP001 	delete( pColorDlg );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 //
//STRIP001 // Button 'Loeschen'
//STRIP001 //
//STRIP001 IMPL_LINK( SvxColorTabPage, ClickDeleteHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbColor.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		QueryBox aQueryBox( DLGWIN, WinBits( WB_YES_NO | WB_DEF_NO ),
//STRIP001 			String( SVX_RES( RID_SVXSTR_ASK_DEL_COLOR ) ) );
//STRIP001 
//STRIP001 		if( aQueryBox.Execute() == RET_YES )
//STRIP001 		{
//STRIP001 			// Jetzt wird richtig geloescht
//STRIP001 			ULONG nCount = pColorTab->Count() - 1;
//STRIP001 			XColorEntry* pEntry;
//STRIP001 
//STRIP001 			pEntry = pColorTab->Remove( nPos );
//STRIP001 			DBG_ASSERT( pEntry, "ColorEntry nicht vorhanden (1) !" );
//STRIP001 			delete pEntry;
//STRIP001 
//STRIP001 			for( ULONG i = nPos; i < nCount; i++ )
//STRIP001 			{
//STRIP001 				pEntry = pColorTab->Remove( i + 1 );
//STRIP001 				DBG_ASSERT( pEntry, "ColorEntry nicht vorhanden (2) !" );
//STRIP001 				pColorTab->Insert( i, pEntry );
//STRIP001 			}
//STRIP001 
//STRIP001 			// Listbox und ValueSet aktualisieren
//STRIP001 			aLbColor.RemoveEntry( nPos );
//STRIP001 			aValSetColorTable.Clear();
//STRIP001 			FillValueSet_Impl( aValSetColorTable );
//STRIP001 
//STRIP001 			// Positionieren
//STRIP001 			aLbColor.SelectEntryPos( nPos );
//STRIP001 			SelectColorLBHdl_Impl( this );
//STRIP001 
//STRIP001 			aCtlPreviewOld.Invalidate();
//STRIP001 
//STRIP001 			// Flag fuer modifiziert setzen
//STRIP001 			*pnColorTableState |= CT_MODIFIED;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( !pColorTab->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnWorkOn.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 //
//STRIP001 // Button 'Farbtabelle laden'
//STRIP001 //
//STRIP001 IMPL_LINK( SvxColorTabPage, ClickLoadHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	USHORT nReturn = RET_YES;
//STRIP001 
//STRIP001 	if( *pnColorTableState & CT_MODIFIED )
//STRIP001 	{
//STRIP001 		nReturn = WarningBox( DLGWIN, WinBits( WB_YES_NO_CANCEL ),
//STRIP001 					String( ResId( RID_SVXSTR_WARN_TABLE_OVERWRITE, pMgr ) ) ).Execute();
//STRIP001 
//STRIP001 		if ( nReturn == RET_YES )
//STRIP001 			pColorTab->Save();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nReturn != RET_CANCEL )
//STRIP001 	{
//STRIP001     	::sfx2::FileDialogHelper aDlg( ::sfx2::FILEOPEN_SIMPLE, 0 );
//STRIP001 		String aStrFilterType( RTL_CONSTASCII_USTRINGPARAM( "*.soc" ) );
//STRIP001 		aDlg.AddFilter( aStrFilterType, aStrFilterType );
//STRIP001 		INetURLObject aFile( SvtPathOptions().GetPalettePath() );
//STRIP001 		aDlg.SetDisplayDirectory( aFile.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001     	if ( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 		{
//STRIP001 			INetURLObject aURL( aDlg.GetPath() );
//STRIP001 			INetURLObject aPathURL( aURL );
//STRIP001 
//STRIP001 			aPathURL.removeSegment();
//STRIP001 			aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 			// Tabelle speichern
//STRIP001 			XColorTable* pColTab = new XColorTable( aPathURL.GetMainURL( INetURLObject::NO_DECODE ), pXPool );
//STRIP001 			pColTab->SetName( aURL.getName() ); // XXX
//STRIP001 			if( pColTab->Load() )
//STRIP001 			{
//STRIP001 				if( pColTab )
//STRIP001 				{
//STRIP001 					// Pruefen, ob Tabelle geloescht werden darf:
//STRIP001 					if( pColorTab != ( (SvxAreaTabDialog*) DLGWIN )->GetColorTable() )
//STRIP001 					{
//STRIP001 						if( bDeleteColorTable )
//STRIP001 							delete pColorTab;
//STRIP001 						else
//STRIP001 							bDeleteColorTable = TRUE;
//STRIP001 					}
//STRIP001 
//STRIP001 					pColorTab = pColTab;
//STRIP001 					( (SvxAreaTabDialog*) DLGWIN )->SetNewColorTable( pColorTab );
//STRIP001 
//STRIP001 					aLbColor.Clear();
//STRIP001 					aValSetColorTable.Clear();
//STRIP001 					Construct();
//STRIP001 					Reset( rOutAttrs );
//STRIP001 
//STRIP001 					pColorTab->SetName( aURL.getName() );
//STRIP001 
//STRIP001 					// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 					// der GroupBox darstellen
//STRIP001 					String aString( ResId( RID_SVXSTR_TABLE, pMgr ) );
//STRIP001 					aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 					if ( aURL.getBase().Len() > 18 )
//STRIP001 					{
//STRIP001 						aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 						aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						aString += aURL.getBase();
//STRIP001 
//STRIP001                     aTableNameFT.SetText( aString );
//STRIP001 
//STRIP001 					// Flag fuer gewechselt setzen
//STRIP001 					*pnColorTableState |= CT_CHANGED;
//STRIP001 					// Flag fuer modifiziert entfernen
//STRIP001 					*pnColorTableState &= ~CT_MODIFIED;
//STRIP001 
//STRIP001 					if( aLbColor.GetSelectEntryPos() == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 						aLbColor.SelectEntryPos( 0 );
//STRIP001 					else
//STRIP001 						aLbColor.SelectEntryPos( aLbColor.GetSelectEntryPos() );
//STRIP001 
//STRIP001 					ChangeColorHdl_Impl( this );
//STRIP001 					SelectColorLBHdl_Impl( this );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				//aIStream.Close();
//STRIP001 				ErrorBox aErrorBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 					String( ResId( RID_SVXSTR_READ_DATA_ERROR, pMgr ) ) );
//STRIP001                 aErrorBox.Execute();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if ( pColorTab->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnWorkOn.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnWorkOn.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 //
//STRIP001 // Button 'Farbtabelle speichern'
//STRIP001 //
//STRIP001 IMPL_LINK( SvxColorTabPage, ClickSaveHdl_Impl, void *, p )
//STRIP001 {
//STRIP001    	::sfx2::FileDialogHelper aDlg( ::sfx2::FILESAVE_SIMPLE, 0 );
//STRIP001 	String aStrFilterType( RTL_CONSTASCII_USTRINGPARAM( "*.soc" ) );
//STRIP001 	aDlg.AddFilter( aStrFilterType, aStrFilterType );
//STRIP001 
//STRIP001 	INetURLObject aFile( SvtPathOptions().GetPalettePath() );
//STRIP001 	DBG_ASSERT( aFile.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	if( pColorTab->GetName().Len() )
//STRIP001 	{
//STRIP001 		aFile.Append( pColorTab->GetName() );
//STRIP001 
//STRIP001 		if( !aFile.getExtension().Len() )
//STRIP001 			aFile.SetExtension( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "soc" ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	aDlg.SetDisplayDirectory( aFile.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 	if ( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 	{
//STRIP001 		INetURLObject aURL( aDlg.GetPath() );
//STRIP001 		INetURLObject aPathURL( aURL );
//STRIP001 
//STRIP001 		aPathURL.removeSegment();
//STRIP001 		aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 		pColorTab->SetName( aURL.getName() );
//STRIP001 		pColorTab->SetPath( aPathURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 		if( pColorTab->Save() )
//STRIP001 		{
//STRIP001 			// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 			// der GroupBox darstellen
//STRIP001 			String aString( SVX_RES( RID_SVXSTR_TABLE ) );
//STRIP001 			aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 			if ( aURL.getBase().Len() > 18 )
//STRIP001 			{
//STRIP001 				aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 				aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aString += aURL.getBase();
//STRIP001             aTableNameFT.SetText( aString );
//STRIP001 
//STRIP001 			// Flag fuer gespeichert setzen
//STRIP001 			*pnColorTableState |= CT_SAVED;
//STRIP001 			// Flag fuer modifiziert entfernen
//STRIP001 			*pnColorTableState &= ~CT_MODIFIED;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ErrorBox aErrorBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 				String( SVX_RES( RID_SVXSTR_WRITE_DATA_ERROR ) ) );
//STRIP001             aErrorBox.Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxColorTabPage, SelectColorLBHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nPos = aLbColor.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		aValSetColorTable.SelectItem( nPos + 1 );
//STRIP001 		aEdtName.SetText( aLbColor.GetSelectEntry() );
//STRIP001 
//STRIP001 		rXFSet.Put( XFillColorItem( String(),
//STRIP001 									aLbColor.GetSelectEntryColor() ) );
//STRIP001 		XOutOld.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 		XOutNew.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 		aCtlPreviewOld.Invalidate();
//STRIP001 		aCtlPreviewNew.Invalidate();
//STRIP001 
//STRIP001 		ChangeColorHdl_Impl( this );
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxColorTabPage, SelectValSetHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nPos = aValSetColorTable.GetSelectItemId();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		aLbColor.SelectEntryPos( nPos - 1 );
//STRIP001 		aEdtName.SetText( aLbColor.GetSelectEntry() );
//STRIP001 
//STRIP001 		rXFSet.Put( XFillColorItem( String(),
//STRIP001 									aLbColor.GetSelectEntryColor() ) );
//STRIP001 		XOutOld.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 		XOutNew.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 		aCtlPreviewOld.Invalidate();
//STRIP001 		aCtlPreviewNew.Invalidate();
//STRIP001 
//STRIP001 		ChangeColorHdl_Impl( this );
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 //
//STRIP001 // Farbwerte je nach bergebenes Farbmodell umrechnen
//STRIP001 //
//STRIP001 void SvxColorTabPage::ConvertColorValues (Color& rColor, ColorModel eModell)
//STRIP001 {
//STRIP001 	switch (eModell)
//STRIP001 	{
//STRIP001 		case CM_RGB:
//STRIP001 		{
//STRIP001 			CmykToRgb_Impl (rColor, (USHORT)rColor.GetTransparency() );
//STRIP001 			rColor.SetTransparency ((UINT8) 0);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case CM_CMYK:
//STRIP001 		{
//STRIP001 			USHORT nK;
//STRIP001 			RgbToCmyk_Impl (rColor, nK );
//STRIP001 			rColor.SetTransparency ((UINT8) nK);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //
//STRIP001 // Auswahl Listbox 'Farbmodell' (RGB/CMY)
//STRIP001 //
//STRIP001 IMPL_LINK( SvxColorTabPage, SelectColorModelHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbColorModel.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		if (eCM != (ColorModel) nPos)
//STRIP001 		{
//STRIP001 			// wenn Farbmodell geaendert wurde, dann Werte umrechnen
//STRIP001 			ConvertColorValues (aAktuellColor, (ColorModel) nPos);
//STRIP001 		}
//STRIP001 
//STRIP001 		eCM = (ColorModel) nPos;
//STRIP001 
//STRIP001 		switch( eCM )
//STRIP001 		{
//STRIP001 			case CM_RGB:
//STRIP001 			{
//STRIP001 				String aStr( aLbColorModel.GetSelectEntry() );
//STRIP001 				String aColorStr( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "~X" ) ) );
//STRIP001 				xub_StrLen nIdx = 1;
//STRIP001 				aColorStr.SetChar( nIdx, aStr.GetChar( 0 ) );
//STRIP001 				aFtColorModel1.SetText( aColorStr );
//STRIP001 				aColorStr.SetChar( nIdx, aStr.GetChar( 1 ) );
//STRIP001 				aFtColorModel2.SetText( aColorStr );
//STRIP001 				aColorStr.SetChar( nIdx, aStr.GetChar( 2 ) );
//STRIP001 				aFtColorModel3.SetText( aColorStr );
//STRIP001 
//STRIP001 				aFtColorModel4.Hide();
//STRIP001 				aMtrFldColorModel4.Hide();
//STRIP001 				aMtrFldColorModel4.SetValue( 0L );
//STRIP001 
//STRIP001 				aMtrFldColorModel1.SetHelpId( HID_TPCOLOR_RGB_1 );
//STRIP001 				aMtrFldColorModel2.SetHelpId( HID_TPCOLOR_RGB_2 );
//STRIP001 				aMtrFldColorModel3.SetHelpId( HID_TPCOLOR_RGB_3 );
//STRIP001 
//STRIP001 				// Da der alte HelpText noch am Control steht wuerde
//STRIP001 				// ein Umsetzen der HelpID alleine nichts bewirken
//STRIP001 				aMtrFldColorModel1.SetHelpText( String() );
//STRIP001 				aMtrFldColorModel2.SetHelpText( String() );
//STRIP001 				aMtrFldColorModel3.SetHelpText( String() );
//STRIP001 
//STRIP001 				// RGB-Werte im Bereich 0..255 verarbeiten (nicht in %),
//STRIP001 				// dazu MetricField's entsprechend einstellen
//STRIP001 				aMtrFldColorModel1.SetUnit(FUNIT_NONE);
//STRIP001 				aMtrFldColorModel1.SetMin(0);
//STRIP001 				aMtrFldColorModel1.SetMax(255);
//STRIP001 				aMtrFldColorModel1.SetLast(255);
//STRIP001 
//STRIP001 				aMtrFldColorModel2.SetUnit(FUNIT_NONE);
//STRIP001 				aMtrFldColorModel2.SetMin(0);
//STRIP001 				aMtrFldColorModel2.SetMax(255);
//STRIP001 				aMtrFldColorModel2.SetLast(255);
//STRIP001 
//STRIP001 				aMtrFldColorModel3.SetUnit(FUNIT_NONE);
//STRIP001 				aMtrFldColorModel3.SetMin(0);
//STRIP001 				aMtrFldColorModel3.SetMax(255);
//STRIP001 				aMtrFldColorModel3.SetLast(255);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case CM_CMYK:
//STRIP001 			{
//STRIP001 				String aStr( aLbColorModel.GetSelectEntry() );
//STRIP001 				String aColorStr( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "~X" ) ) );
//STRIP001 				xub_StrLen nIdx = 1;
//STRIP001 				aColorStr.SetChar( nIdx, aStr.GetChar( 0 ) );
//STRIP001 				aFtColorModel1.SetText( aColorStr );
//STRIP001 				aColorStr.SetChar( nIdx, aStr.GetChar( 1 ) );
//STRIP001 				aFtColorModel2.SetText( aColorStr );
//STRIP001 				aColorStr.SetChar( nIdx,aStr.GetChar( 2 ) );
//STRIP001 				aFtColorModel3.SetText( aColorStr );
//STRIP001 				aColorStr.SetChar( nIdx,aStr.GetChar( 3 ) );
//STRIP001 				aFtColorModel4.SetText( aColorStr );
//STRIP001 
//STRIP001 				aFtColorModel4.Show();
//STRIP001 				aMtrFldColorModel4.Show();
//STRIP001 
//STRIP001 				aMtrFldColorModel1.SetHelpId( HID_TPCOLOR_CMYK_1 );
//STRIP001 				aMtrFldColorModel2.SetHelpId( HID_TPCOLOR_CMYK_2 );
//STRIP001 				aMtrFldColorModel3.SetHelpId( HID_TPCOLOR_CMYK_3 );
//STRIP001 
//STRIP001 				// s.o.
//STRIP001 				aMtrFldColorModel1.SetHelpText( String() );
//STRIP001 				aMtrFldColorModel2.SetHelpText( String() );
//STRIP001 				aMtrFldColorModel3.SetHelpText( String() );
//STRIP001 
//STRIP001 				// CMYK-Werte im Bereich 0..100% verarbeiten,
//STRIP001 				// dazu MetricField's entsprechend einstellen
//STRIP001 				String aStrUnit( RTL_CONSTASCII_USTRINGPARAM( " %" ) );
//STRIP001 
//STRIP001 				aMtrFldColorModel1.SetUnit(FUNIT_CUSTOM);
//STRIP001 				aMtrFldColorModel1.SetCustomUnitText( aStrUnit );
//STRIP001 				aMtrFldColorModel1.SetMin(0);
//STRIP001 				aMtrFldColorModel1.SetMax(100);
//STRIP001 				aMtrFldColorModel1.SetLast(100);
//STRIP001 
//STRIP001 				aMtrFldColorModel2.SetUnit(FUNIT_CUSTOM);
//STRIP001 				aMtrFldColorModel2.SetCustomUnitText( aStrUnit );
//STRIP001 				aMtrFldColorModel2.SetMin(0);
//STRIP001 				aMtrFldColorModel2.SetMax(100);
//STRIP001 				aMtrFldColorModel2.SetLast(100);
//STRIP001 
//STRIP001 				aMtrFldColorModel3.SetUnit(FUNIT_CUSTOM);
//STRIP001 				aMtrFldColorModel3.SetCustomUnitText( aStrUnit );
//STRIP001 				aMtrFldColorModel3.SetMin(0);
//STRIP001 				aMtrFldColorModel3.SetMax(100);
//STRIP001 				aMtrFldColorModel3.SetLast(100);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		aMtrFldColorModel1.SetValue( ColorToPercent_Impl( aAktuellColor.GetRed() ) );
//STRIP001 		aMtrFldColorModel2.SetValue( ColorToPercent_Impl( aAktuellColor.GetGreen() ) );
//STRIP001 		aMtrFldColorModel3.SetValue( ColorToPercent_Impl( aAktuellColor.GetBlue() ) );
//STRIP001 		aMtrFldColorModel4.SetValue( ColorToPercent_Impl( aAktuellColor.GetTransparency() ) );
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxColorTabPage::ChangeColorHdl_Impl( void* )
//STRIP001 {
//STRIP001 	int nPos = aLbColor.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		XColorEntry* pEntry = pColorTab->Get( nPos );
//STRIP001 
//STRIP001 		aAktuellColor.SetColor ( pEntry->GetColor().GetColor() );
//STRIP001 		if (eCM != CM_RGB)
//STRIP001 			ConvertColorValues (aAktuellColor, eCM);
//STRIP001 
//STRIP001 		aMtrFldColorModel1.SetValue( ColorToPercent_Impl( aAktuellColor.GetRed() ) );
//STRIP001 		aMtrFldColorModel2.SetValue( ColorToPercent_Impl( aAktuellColor.GetGreen() ) );
//STRIP001 		aMtrFldColorModel3.SetValue( ColorToPercent_Impl( aAktuellColor.GetBlue() ) );
//STRIP001 		aMtrFldColorModel4.SetValue( ColorToPercent_Impl( aAktuellColor.GetTransparency() ) );
//STRIP001 
//STRIP001 		// ItemSet fuellen und an XOut weiterleiten
//STRIP001 		rXFSet.Put( XFillColorItem( String(), pEntry->GetColor() ) );
//STRIP001 		XOutOld.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 		XOutNew.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 		aCtlPreviewNew.Invalidate();
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxColorTabPage::FillValueSet_Impl( ValueSet& rVs )
//STRIP001 {
//STRIP001 	long nCount = pColorTab->Count();
//STRIP001 	XColorEntry* pColorEntry;
//STRIP001 
//STRIP001 	for( long i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		pColorEntry = pColorTab->Get( i );
//STRIP001 		rVs.InsertItem( (USHORT) i + 1, pColorEntry->GetColor(), pColorEntry->GetName() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 // Ein RGB-Wert wird in einen CMYK-Wert konvertiert, wobei die Color-
//STRIP001 // Klasse vergewaltigt wird, da R in C, G in M und B in Y umgewandelt
//STRIP001 // wird. Der Wert K wird in einer Extra-Variablen gehalten.
//STRIP001 // Bei weiteren Farbmodellen sollte man hierfuer eigene Klassen entwickeln,
//STRIP001 // die dann auch entsprechende Casts enthalten.
//STRIP001 
//STRIP001 void SvxColorTabPage::RgbToCmyk_Impl( Color& rColor, USHORT& rK )
//STRIP001 {
//STRIP001 	USHORT nColor1, nColor2, nColor3;
//STRIP001 	USHORT nProzent; // nur temporaer !!!
//STRIP001 
//STRIP001 	nColor1 = 255 - rColor.GetRed();
//STRIP001 	nProzent = ColorToPercent_Impl( nColor1 );
//STRIP001 
//STRIP001 	nColor2 = 255 - rColor.GetGreen();
//STRIP001 	nProzent = ColorToPercent_Impl( nColor2 );
//STRIP001 
//STRIP001 	nColor3 = 255 - rColor.GetBlue();
//STRIP001 	nProzent = ColorToPercent_Impl( nColor3 );
//STRIP001 
//STRIP001 	rK = Min( Min( nColor1, nColor2 ), nColor3 );
//STRIP001 
//STRIP001 	rColor.SetRed( nColor1 - rK );
//STRIP001 	rColor.SetGreen( nColor2 - rK );
//STRIP001 	rColor.SetBlue( nColor3 - rK );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 // Umgekehrter Fall zu RgbToCmyk_Impl (s.o.)
//STRIP001 
//STRIP001 void SvxColorTabPage::CmykToRgb_Impl( Color& rColor, const USHORT nK )
//STRIP001 {
//STRIP001 	long lTemp;
//STRIP001 
//STRIP001 	lTemp = 255 - ( rColor.GetRed() + nK );
//STRIP001 
//STRIP001 	if( lTemp < 0L )
//STRIP001 		lTemp = 0L;
//STRIP001 	rColor.SetRed( (BYTE)lTemp );
//STRIP001 
//STRIP001 	lTemp = 255 - ( rColor.GetGreen() + nK );
//STRIP001 
//STRIP001 	if( lTemp < 0L )
//STRIP001 		lTemp = 0L;
//STRIP001 	rColor.SetGreen( (BYTE)lTemp );
//STRIP001 
//STRIP001 	lTemp = 255 - ( rColor.GetBlue() + nK );
//STRIP001 
//STRIP001 	if( lTemp < 0L )
//STRIP001 		lTemp = 0L;
//STRIP001 	rColor.SetBlue( (BYTE)lTemp );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SvxColorTabPage::ColorToPercent_Impl( USHORT nColor )
//STRIP001 {
//STRIP001 	USHORT nWert;
//STRIP001 
//STRIP001 	switch (eCM)
//STRIP001 	{
//STRIP001 		case CM_RGB :
//STRIP001 			nWert = nColor;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case CM_CMYK:
//STRIP001 			nWert = (USHORT) ( (double) nColor * 100.0 / 255.0 + 0.5 );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return ( nWert );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SvxColorTabPage::PercentToColor_Impl( USHORT nPercent )
//STRIP001 {
//STRIP001 	USHORT nWert;
//STRIP001 
//STRIP001 	switch (eCM)
//STRIP001 	{
//STRIP001 		case CM_RGB :
//STRIP001 			nWert = nPercent;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case CM_CMYK:
//STRIP001 			nWert = (USHORT) ( (double) nPercent * 255.0 / 100.0 + 0.5 );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return ( nWert );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxColorTabPage::FillUserData()
//STRIP001 {
//STRIP001 	// Das Farbmodell wird in der Ini-Datei festgehalten
//STRIP001 	SetUserData( UniString::CreateFromInt32( eCM ) );
//STRIP001 }


}
