/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fmsrcimp.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:46:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif

// auto strip #ifndef _MULTIPRO_HXX
// auto strip #include "multipro.hxx"
// auto strip #endif

// auto strip #ifndef _SVX_FMTOOLS_HXX
// auto strip #include "fmtools.hxx"
// auto strip #endif

// auto strip #ifndef _FMSRCCF_HXX_
// auto strip #include "fmsrccfg.hxx"
// auto strip #endif

// auto strip #ifndef _TOOLS_DEBUG_HXX //autogen
// auto strip #include <tools/debug.hxx>
// auto strip #endif

// auto strip #ifndef _WLDCRD_HXX //autogen
// auto strip #include <tools/wldcrd.hxx>
// auto strip #endif

// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif

// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_DIALMGR_HXX //autogen
// auto strip #include <dialmgr.hxx>
// auto strip #endif

// auto strip #ifndef _CPPUHELPER_SERVICEFACTORY_HXX_
// auto strip #include <cppuhelper/servicefactory.hxx>
// auto strip #endif

// auto strip #ifndef _SV_SVAPP_HXX //autogen
// auto strip #include <vcl/svapp.hxx>
// auto strip #endif

// auto strip #ifndef _UNOTOOLS_TEXTSEARCH_HXX
// auto strip #include <unotools/textsearch.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_SEARCHOPTIONS_HPP_
// auto strip #include <com/sun/star/util/SearchOptions.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_SEARCHALGORITHMS_HPP_
// auto strip #include <com/sun/star/util/SearchAlgorithms.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_SEARCHRESULT_HPP_
// auto strip #include <com/sun/star/util/SearchResult.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_SEARCHFLAGS_HPP_
// auto strip #include <com/sun/star/util/SearchFlags.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_LANG_LOCALE_HPP_
// auto strip #include <com/sun/star/lang/Locale.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULES_HPP_
// auto strip #include <com/sun/star/i18n/TransliterationModules.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_I18N_COLLATOROPTIONS_HPP_
// auto strip #include <com/sun/star/i18n/CollatorOptions.hpp>
// auto strip #endif

// auto strip #ifndef _ISOLANG_HXX
// auto strip #include <tools/isolang.hxx>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_SDDB_XCOLUMNSSUPPLIER_HPP_
// auto strip #include <com/sun/star/sdbcx/XColumnsSupplier.hpp>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATTER_HPP_
// auto strip #include <com/sun/star/util/XNumberFormatter.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_NUMBERFORMAT_HPP_
// auto strip #include <com/sun/star/util/NumberFormat.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATSSUPPLIER_HPP_
// auto strip #include <com/sun/star/util/XNumberFormatsSupplier.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATS_HPP_
// auto strip #include <com/sun/star/util/XNumberFormats.hpp>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif

#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif
// auto strip #ifndef _SVX_FMSERVS_HXX
// auto strip #include "fmservs.hxx"
// auto strip #endif

// auto strip #ifndef _FMSRCIMP_HXX
// auto strip #include "fmsrcimp.hxx"
// auto strip #endif

// auto strip #ifndef _FMSEARCH_HXX
// auto strip #include "fmsearch.hxx"
// auto strip #endif

#ifndef _FMSEARCH_HRC
#include "fmsearch.hrc"
#endif

// auto strip #ifndef _COMPHELPER_NUMBERS_HXX_
// auto strip #include <comphelper/numbers.hxx>
// auto strip #endif
// auto strip #ifndef INCLUDED_SVTOOLS_SYSLOCALE_HXX
// auto strip #include <svtools/syslocale.hxx>
// auto strip #endif
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {

//STRIP001 //#define COMPARE_BOOKMARKS(a, b) compareUsrAny(a, b)
//STRIP001 #define COMPARE_BOOKMARKS(a, b) ::comphelper::compare(a, b)
//STRIP001 
//STRIP001 // damit ich waehrend des Debuggings keine inline-Methoden habe ...
//STRIP001 #if (OSL_DEBUG_LEVEL > 1) || DBG_UTIL
//STRIP001 #define INLINE_METHOD
//STRIP001 #else
//STRIP001 #define INLINE_METHOD inline
//STRIP001 #endif // (OSL_DEBUG_LEVEL > 1) || DBG_UTIL
//STRIP001 
//STRIP001 #define IFACECAST(c)          ((const Reference< XInterface >&)c)
//STRIP001  // SUN C52 has some ambiguities without this cast ....
//STRIP001 
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::util;
//STRIP001 using namespace ::com::sun::star::lang;
//STRIP001 using namespace ::com::sun::star::sdbc;
//STRIP001 using namespace ::com::sun::star::i18n;
//STRIP001 using namespace ::com::sun::star::beans;
//STRIP001 using namespace ::svxform;
//STRIP001 
//STRIP001 // ***************************************************************************************************
//STRIP001 
//STRIP001 // ***************************************************************************************************
//STRIP001 
//STRIP001 SV_IMPL_OBJARR(SvInt32Array, sal_Int32);
//STRIP001 DECLARE_STL_VECTOR( Reference< XInterface > ,InterfaceArray);
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // = FmSearchThread
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchThread::run()
//STRIP001 {
//STRIP001     m_pEngine->SearchNextImpl();
//STRIP001 };
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchThread::onTerminated()
//STRIP001 {
//STRIP001     if (m_aTerminationHdl.IsSet())
//STRIP001         m_aTerminationHdl.Call(this);
//STRIP001     delete this;
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // = FmRecordCountListener
//STRIP001 
//STRIP001 //  SMART_UNO_IMPLEMENTATION(FmRecordCountListener, UsrObject);
//STRIP001 
//STRIP001 DBG_NAME(FmRecordCountListener)
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmRecordCountListener::FmRecordCountListener(const Reference< ::com::sun::star::sdbc::XResultSet > & dbcCursor)
//STRIP001 {
//STRIP001     DBG_CTOR(FmRecordCountListener,NULL);
//STRIP001 
//STRIP001     m_xListening = Reference< ::com::sun::star::beans::XPropertySet > (dbcCursor, UNO_QUERY);
//STRIP001     if (!m_xListening.is())
//STRIP001         return;
//STRIP001 
//STRIP001     if (::comphelper::getBOOL(m_xListening->getPropertyValue(FM_PROP_ROWCOUNTFINAL)))
//STRIP001     {
//STRIP001         m_xListening = NULL;
//STRIP001         // there's nothing to do as the record count is already known
//STRIP001         return;
//STRIP001     }
//STRIP001 
//STRIP001     m_xListening->addPropertyChangeListener(FM_PROP_ROWCOUNT, (::com::sun::star::beans::XPropertyChangeListener*)this);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 Link FmRecordCountListener::SetPropChangeHandler(const Link& lnk)
//STRIP001 {
//STRIP001     Link lnkReturn = m_lnkWhoWantsToKnow;
//STRIP001     m_lnkWhoWantsToKnow = lnk;
//STRIP001 
//STRIP001     if (m_xListening.is())
//STRIP001         NotifyCurrentCount();
//STRIP001 
//STRIP001     return lnkReturn;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmRecordCountListener::~FmRecordCountListener()
//STRIP001 {
//STRIP001 
//STRIP001     DBG_DTOR(FmRecordCountListener,NULL);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmRecordCountListener::DisConnect()
//STRIP001 {
//STRIP001     if(m_xListening.is())
//STRIP001         m_xListening->removePropertyChangeListener(FM_PROP_ROWCOUNT, (::com::sun::star::beans::XPropertyChangeListener*)this);
//STRIP001     m_xListening = NULL;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void SAL_CALL FmRecordCountListener::disposing(const ::com::sun::star::lang::EventObject& Source) throw( RuntimeException )
//STRIP001 {
//STRIP001     DBG_ASSERT(m_xListening.is(), "FmRecordCountListener::disposing should never have been called without a propset !");
//STRIP001     DisConnect();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmRecordCountListener::NotifyCurrentCount()
//STRIP001 {
//STRIP001     if (m_lnkWhoWantsToKnow.IsSet())
//STRIP001     {
//STRIP001         DBG_ASSERT(m_xListening.is(), "FmRecordCountListener::NotifyCurrentCount : I have no propset ... !?");
//STRIP001         void* pTheCount = (void*)::comphelper::getINT32(m_xListening->getPropertyValue(FM_PROP_ROWCOUNT));
//STRIP001         m_lnkWhoWantsToKnow.Call(pTheCount);
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmRecordCountListener::propertyChange(const  ::com::sun::star::beans::PropertyChangeEvent& evt) throw(::com::sun::star::uno::RuntimeException)
//STRIP001 {
//STRIP001     NotifyCurrentCount();
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // FmSearchEngine - local classes
//STRIP001 //------------------------------------------------------------------------
//STRIP001 SimpleTextWrapper::SimpleTextWrapper(const Reference< ::com::sun::star::awt::XTextComponent > & _xText)
//STRIP001     :ControlTextWrapper(_xText.get())
//STRIP001     ,m_xText(_xText)
//STRIP001 {
//STRIP001     DBG_ASSERT(m_xText.is(), "FmSearchEngine::SimpleTextWrapper::SimpleTextWrapper : invalid argument !");
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 ::rtl::OUString SimpleTextWrapper::getCurrentText() const
//STRIP001 {
//STRIP001     return m_xText->getText();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 ListBoxWrapper::ListBoxWrapper(const Reference< ::com::sun::star::awt::XListBox > & _xBox)
//STRIP001     :ControlTextWrapper(_xBox.get())
//STRIP001     ,m_xBox(_xBox)
//STRIP001 {
//STRIP001     DBG_ASSERT(m_xBox.is(), "FmSearchEngine::ListBoxWrapper::ListBoxWrapper : invalid argument !");
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 ::rtl::OUString ListBoxWrapper::getCurrentText() const
//STRIP001 {
//STRIP001     return m_xBox->getSelectedItem();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 CheckBoxWrapper::CheckBoxWrapper(const Reference< ::com::sun::star::awt::XCheckBox > & _xBox)
//STRIP001     :ControlTextWrapper(_xBox.get())
//STRIP001     ,m_xBox(_xBox)
//STRIP001 {
//STRIP001     DBG_ASSERT(m_xBox.is(), "FmSearchEngine::CheckBoxWrapper::CheckBoxWrapper : invalid argument !");
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 ::rtl::OUString CheckBoxWrapper::getCurrentText() const
//STRIP001 {
//STRIP001     switch ((TriState)m_xBox->getState())
//STRIP001     {
//STRIP001         case STATE_NOCHECK: return ::rtl::OUString::createFromAscii("0");
//STRIP001         case STATE_CHECK: return ::rtl::OUString::createFromAscii("1");
//STRIP001     }
//STRIP001     return ::rtl::OUString();
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // = FmSearchEngine
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_Bool FmSearchEngine::MoveCursor()
//STRIP001 {
//STRIP001     sal_Bool bSuccess = sal_True;
//STRIP001     try
//STRIP001     {
//STRIP001         if (m_bForward)
//STRIP001             if (m_xSearchCursor.isLast())
//STRIP001                 m_xSearchCursor.first();
//STRIP001             else
//STRIP001                 m_xSearchCursor.next();
//STRIP001         else
//STRIP001             if (m_xSearchCursor.isFirst())
//STRIP001             {
//STRIP001                 FmRecordCountListener* prclListener = new FmRecordCountListener(m_xSearchCursor);
//STRIP001                 prclListener->acquire();
//STRIP001                 prclListener->SetPropChangeHandler(LINK(this, FmSearchEngine, OnNewRecordCount));
//STRIP001 
//STRIP001                 m_xSearchCursor.last();
//STRIP001 
//STRIP001                 prclListener->DisConnect();
//STRIP001                 prclListener->release();
//STRIP001             }
//STRIP001             else
//STRIP001                 m_xSearchCursor.previous();
//STRIP001     }
//STRIP001 #if (OSL_DEBUG_LEVEL > 0) || DBG_UTIL
//STRIP001     catch(::com::sun::star::sdbc::SQLException  e)
//STRIP001     {
//STRIP001         String sDebugMessage;
//STRIP001         sDebugMessage.AssignAscii("FmSearchEngine::MoveCursor : catched a DatabaseException (");
//STRIP001         sDebugMessage += (const sal_Unicode*)e.SQLState;
//STRIP001         sDebugMessage.AppendAscii(") !");
//STRIP001         DBG_ERROR(ByteString(sDebugMessage, RTL_TEXTENCODING_ASCII_US).GetBuffer());
//STRIP001 
//STRIP001         bSuccess = sal_False;
//STRIP001     }
//STRIP001     catch(Exception  e)
//STRIP001     {
//STRIP001         UniString sDebugMessage;
//STRIP001         sDebugMessage.AssignAscii("FmSearchEngine::MoveCursor : catched an Exception (");
//STRIP001         sDebugMessage += (const sal_Unicode*)e.Message;
//STRIP001         sDebugMessage.AppendAscii(") !");
//STRIP001         DBG_ERROR(ByteString(sDebugMessage, RTL_TEXTENCODING_ASCII_US).GetBuffer());
//STRIP001 
//STRIP001         bSuccess = sal_False;
//STRIP001     }
//STRIP001 #endif // (OSL_DEBUG_LEVEL > 0) || DBG_UTIL
//STRIP001     catch(...)
//STRIP001     {
//STRIP001         DBG_ERROR("FmSearchEngine::MoveCursor : catched an unknown Exception !");
//STRIP001         bSuccess = sal_False;
//STRIP001     }
//STRIP001 
//STRIP001 
//STRIP001     return bSuccess;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 INLINE_METHOD sal_Bool FmSearchEngine::MoveField(sal_Int32& nPos, FieldCollectionIterator& iter, const FieldCollectionIterator& iterBegin, const FieldCollectionIterator& iterEnd)
//STRIP001 {
//STRIP001     sal_Bool bSuccess(sal_True);
//STRIP001     if (m_bForward)
//STRIP001     {
//STRIP001         ++iter;
//STRIP001         ++nPos;
//STRIP001         if (iter == iterEnd)
//STRIP001         {
//STRIP001             bSuccess = MoveCursor();
//STRIP001             iter = iterBegin;
//STRIP001             nPos = 0;
//STRIP001         }
//STRIP001     } else
//STRIP001     {
//STRIP001         if (iter == iterBegin)
//STRIP001         {
//STRIP001             bSuccess = MoveCursor();
//STRIP001             iter = iterEnd;
//STRIP001             nPos = iter-iterBegin;
//STRIP001         }
//STRIP001         --iter;
//STRIP001         --nPos;
//STRIP001     }
//STRIP001     return bSuccess;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::BuildAndInsertFieldInfo(const Reference< ::com::sun::star::container::XIndexAccess > & xAllFields, sal_Int32 nField)
//STRIP001 {
//STRIP001 	DBG_ASSERT( xAllFields.is() && ( nField >= 0 ) && ( nField < xAllFields->getCount() ),
//STRIP001 		"FmSearchEngine::BuildAndInsertFieldInfo: invalid field descriptor!" );
//STRIP001 
//STRIP001 	// das Feld selber
//STRIP001     Reference< XInterface > xCurrentField;
//STRIP001     xAllFields->getByIndex(nField) >>= xCurrentField;
//STRIP001 
//STRIP001     // von dem weiss ich jetzt, dass es den DatabaseRecord-Service unterstuetzt (hoffe ich)
//STRIP001     // fuer den FormatKey und den Typ brauche ich das PropertySet
//STRIP001     Reference< ::com::sun::star::beans::XPropertySet >  xProperties(xCurrentField, UNO_QUERY);
//STRIP001 
//STRIP001     // die FieldInfo dazu aufbauen
//STRIP001     FieldInfo fiCurrent;
//STRIP001     fiCurrent.xContents = Reference< ::com::sun::star::sdb::XColumn > (xCurrentField, UNO_QUERY);
//STRIP001     fiCurrent.nFormatKey = ::comphelper::getINT32(xProperties->getPropertyValue(FM_PROP_FORMATKEY));
//STRIP001     fiCurrent.bDoubleHandling = sal_False;
//STRIP001     if (m_xFormatSupplier.is())
//STRIP001     {
//STRIP001         Reference< ::com::sun::star::util::XNumberFormats >  xNumberFormats(m_xFormatSupplier->getNumberFormats());
//STRIP001 
//STRIP001         sal_Int16 nFormatType = ::comphelper::getNumberFormatType(xNumberFormats, fiCurrent.nFormatKey) & ~((sal_Int16)::com::sun::star::util::NumberFormat::DEFINED);
//STRIP001         fiCurrent.bDoubleHandling = (nFormatType != ::com::sun::star::util::NumberFormat::TEXT);
//STRIP001     }
//STRIP001 
//STRIP001     // und merken
//STRIP001     m_arrUsedFields.insert(m_arrUsedFields.end(), fiCurrent);
//STRIP001 
//STRIP001 }
//STRIP001 //------------------------------------------------------------------------
//STRIP001 INLINE_METHOD ::rtl::OUString FmSearchEngine::FormatField(const FieldInfo& rField)
//STRIP001 {
//STRIP001     DBG_ASSERT(!m_bUsingTextComponents, "FmSearchEngine::FormatField : im UsingTextComponents-Mode bitte FormatField(sal_Int32) benutzen !");
//STRIP001 
//STRIP001     if (!m_xFormatter.is())
//STRIP001         return ::rtl::OUString();
//STRIP001     // sonst werden Datumsflder zum Beispiel zu irgendeinem Default-Wert formatiert
//STRIP001 
//STRIP001     ::rtl::OUString sReturn;
//STRIP001     try
//STRIP001     {
//STRIP001         if (rField.bDoubleHandling)
//STRIP001         {
//STRIP001             double fValue = rField.xContents->getDouble();
//STRIP001             if (!rField.xContents->wasNull())
//STRIP001                 sReturn = m_xFormatter->convertNumberToString(rField.nFormatKey, fValue);
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             ::rtl::OUString sValue = rField.xContents->getString();
//STRIP001             if (!rField.xContents->wasNull())
//STRIP001                 sReturn = m_xFormatter->formatString(rField.nFormatKey, sValue);
//STRIP001         }
//STRIP001     }
//STRIP001     catch(...)
//STRIP001     {
//STRIP001     }
//STRIP001 
//STRIP001 
//STRIP001     return sReturn;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 ::rtl::OUString FmSearchEngine::FormatField(sal_Int32 nWhich)
//STRIP001 {
//STRIP001     if (m_bUsingTextComponents)
//STRIP001     {
//STRIP001         DBG_ASSERT((sal_uInt32)nWhich < m_aControlTexts.size(), "FmSearchEngine::FormatField(sal_Int32) : invalid position !");
//STRIP001         DBG_ASSERT(m_aControlTexts[nWhich] != NULL, "FmSearchEngine::FormatField(sal_Int32) : invalid object in array !");
//STRIP001         DBG_ASSERT(m_aControlTexts[nWhich]->getControl().is(), "FmSearchEngine::FormatField : invalid control !");
//STRIP001 
//STRIP001         if (m_nCurrentFieldIndex != -1)
//STRIP001         {
//STRIP001             DBG_ASSERT((nWhich == 0) || (nWhich == m_nCurrentFieldIndex), "FmSearchEngine::FormatField : Parameter nWhich ist ungueltig");
//STRIP001             // analoge Situation wie unten
//STRIP001             nWhich = m_nCurrentFieldIndex;
//STRIP001         }
//STRIP001 
//STRIP001         DBG_ASSERT((nWhich >= 0) && ((sal_uInt32)nWhich < m_aControlTexts.size()),
//STRIP001             "FmSearchEngine::FormatField : invalid argument nWhich !");
//STRIP001         return m_aControlTexts[m_nCurrentFieldIndex == -1 ? nWhich : m_nCurrentFieldIndex]->getCurrentText();
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         if (m_nCurrentFieldIndex != -1)
//STRIP001         {
//STRIP001             DBG_ASSERT((nWhich == 0) || (nWhich == m_nCurrentFieldIndex), "FmSearchEngine::FormatField : Parameter nWhich ist ungueltig");
//STRIP001             // ich bin im single-field-modus, da ist auch die richtige Feld-Nummer erlaubt, obwohl dann der richtige ::com::sun::star::sdbcx::Index
//STRIP001             // fuer meinen Array-Zugriff natuerlich 0 ist
//STRIP001             nWhich = 0;
//STRIP001         }
//STRIP001 
//STRIP001         DBG_ASSERT((nWhich>=0) && (nWhich < (m_arrUsedFields.end() - m_arrUsedFields.begin())),
//STRIP001             "FmSearchEngine::FormatField : Parameter nWhich ist ungueltig");
//STRIP001         return FormatField(m_arrUsedFields[nWhich]);
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 INLINE_METHOD FmSearchEngine::SEARCH_RESULT FmSearchEngine::SearchSpecial(sal_Bool _bSearchForNull, sal_Int32& nFieldPos,
//STRIP001     FieldCollectionIterator& iterFieldLoop, const FieldCollectionIterator& iterBegin, const FieldCollectionIterator& iterEnd)
//STRIP001 {
//STRIP001     // die Startposition merken
//STRIP001     Any aStartMark = m_xSearchCursor.getBookmark();
//STRIP001     FieldCollectionIterator iterInitialField = iterFieldLoop;
//STRIP001 
//STRIP001     // --------------------------------------------------------------
//STRIP001     sal_Bool bFound(sal_False);
//STRIP001     sal_Bool bMovedAround(sal_False);
//STRIP001     do
//STRIP001     {
//STRIP001         if (m_eMode == FmSearchDialog::SM_ALLOWSCHEDULE)
//STRIP001         {
//STRIP001             Application::Reschedule();
//STRIP001             Application::Reschedule();
//STRIP001             // do 2 reschedules because of #70226# : some things done within this loop's body may cause an user event
//STRIP001             // to be posted (deep within vcl), and these user events will be handled before any keyinput or paintings
//STRIP001             // or anything like that. So within each loop we create one user event and handle one user event (and no
//STRIP001             // paintings and these), so the office seems to be frozen while searching.
//STRIP001             // FS - 70226 - 02.12.99
//STRIP001         }
//STRIP001 
//STRIP001         // der aktuell zu vergleichende Inhalt
//STRIP001         iterFieldLoop->xContents->getString();  // needed for wasNull
//STRIP001         bFound = _bSearchForNull == iterFieldLoop->xContents->wasNull();
//STRIP001         if (bFound)
//STRIP001             break;
//STRIP001 
//STRIP001         // naechstes Feld (implizit naechster Datensatz, wenn noetig)
//STRIP001         if (!MoveField(nFieldPos, iterFieldLoop, iterBegin, iterEnd))
//STRIP001         {   // beim Bewegen auf das naechste Feld ging was schief ... weitermachen ist nicht drin, da das naechste Mal genau
//STRIP001             // das selbe bestimmt wieder schief geht, also Abbruch
//STRIP001             // vorher aber noch, damit das Weitersuchen an der aktuellen Position weitermacht :
//STRIP001             m_aPreviousLocBookmark = m_xSearchCursor.getBookmark();
//STRIP001             m_iterPreviousLocField = iterFieldLoop;
//STRIP001             // und wech
//STRIP001             return SR_ERROR;
//STRIP001         }
//STRIP001 
//STRIP001         bMovedAround = COMPARE_BOOKMARKS(aStartMark, m_xSearchCursor.getBookmark()) && (iterFieldLoop == iterInitialField);
//STRIP001 
//STRIP001         if (nFieldPos == 0)
//STRIP001             // das heisst, ich habe mich auf einen neuen Datensatz bewegt
//STRIP001             PropagateProgress(bMovedAround);
//STRIP001                 // if we moved to the starting position we don't have to propagate an 'overflow' message
//STRIP001                 // FS - 07.12.99 - 68530
//STRIP001 
//STRIP001         // abbrechen gefordert ?
//STRIP001         if (CancelRequested())
//STRIP001             return SR_CANCELED;
//STRIP001 
//STRIP001     } while (!bMovedAround);
//STRIP001 
//STRIP001     return bFound ? SR_FOUND : SR_NOTFOUND;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 INLINE_METHOD FmSearchEngine::SEARCH_RESULT FmSearchEngine::SearchWildcard(const ::rtl::OUString& strExpression, sal_Int32& nFieldPos,
//STRIP001     FieldCollectionIterator& iterFieldLoop, const FieldCollectionIterator& iterBegin, const FieldCollectionIterator& iterEnd)
//STRIP001 {
//STRIP001     // die Startposition merken
//STRIP001     Any aStartMark = m_xSearchCursor.getBookmark();
//STRIP001     FieldCollectionIterator iterInitialField = iterFieldLoop;
//STRIP001 
//STRIP001     WildCard aSearchExpression(strExpression);
//STRIP001 
//STRIP001     // --------------------------------------------------------------
//STRIP001     sal_Bool bFound(sal_False);
//STRIP001     sal_Bool bMovedAround(sal_False);
//STRIP001 	::rtl::OUString sCurrentCheck;
//STRIP001     do
//STRIP001     {
//STRIP001         if (m_eMode == FmSearchDialog::SM_ALLOWSCHEDULE)
//STRIP001         {
//STRIP001             Application::Reschedule();
//STRIP001             Application::Reschedule();
//STRIP001             // do 2 reschedules because of #70226# : some things done within this loop's body may cause an user event
//STRIP001             // to be posted (deep within vcl), and these user events will be handled before any keyinput or paintings
//STRIP001             // or anything like that. So within each loop we create one user event and hanel one user event (and no
//STRIP001             // paintings and these), so the office seems to be frozen while searching.
//STRIP001             // FS - 70226 - 02.12.99
//STRIP001         }
//STRIP001 
//STRIP001         // der aktuell zu vergleichende Inhalt
//STRIP001         ::rtl::OUString sCurrentCheck;
//STRIP001         if (m_bFormatter)
//STRIP001             sCurrentCheck = FormatField(nFieldPos);
//STRIP001         else
//STRIP001             sCurrentCheck = iterFieldLoop->xContents->getString();
//STRIP001 
//STRIP001         if (!GetCaseSensitive())
//STRIP001 			// norm the string
//STRIP001 			m_aCharacterClassficator.toLower_rtl(sCurrentCheck);
//STRIP001 
//STRIP001         // jetzt ist der Test einfach ...
//STRIP001         bFound = aSearchExpression.Matches(sCurrentCheck);
//STRIP001 
//STRIP001         if (bFound)
//STRIP001             break;
//STRIP001 
//STRIP001         // naechstes Feld (implizit naechster Datensatz, wenn noetig)
//STRIP001         if (!MoveField(nFieldPos, iterFieldLoop, iterBegin, iterEnd))
//STRIP001         {   // beim Bewegen auf das naechste Feld ging was schief ... weitermachen ist nicht drin, da das naechste Mal genau
//STRIP001             // das selbe bestimmt wieder schief geht, also Abbruch
//STRIP001             // vorher aber noch, damit das Weitersuchen an der aktuellen Position weitermacht :
//STRIP001             m_aPreviousLocBookmark = m_xSearchCursor.getBookmark();
//STRIP001             m_iterPreviousLocField = iterFieldLoop;
//STRIP001             // und wech
//STRIP001             return SR_ERROR;
//STRIP001         }
//STRIP001 
//STRIP001         bMovedAround = COMPARE_BOOKMARKS(aStartMark, m_xSearchCursor.getBookmark()) && (iterFieldLoop == iterInitialField);
//STRIP001 
//STRIP001         if (nFieldPos == 0)
//STRIP001             // das heisst, ich habe mich auf einen neuen Datensatz bewegt
//STRIP001             PropagateProgress(bMovedAround);
//STRIP001                 // if we moved to the starting position we don't have to propagate an 'overflow' message
//STRIP001                 // FS - 07.12.99 - 68530
//STRIP001 
//STRIP001         // abbrechen gefordert ?
//STRIP001         if (CancelRequested())
//STRIP001             return SR_CANCELED;
//STRIP001 
//STRIP001     } while (!bMovedAround);
//STRIP001 
//STRIP001     return bFound ? SR_FOUND : SR_NOTFOUND;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 INLINE_METHOD FmSearchEngine::SEARCH_RESULT FmSearchEngine::SearchRegularApprox(const ::rtl::OUString& strExpression, sal_Int32& nFieldPos,
//STRIP001     FieldCollectionIterator& iterFieldLoop, const FieldCollectionIterator& iterBegin, const FieldCollectionIterator& iterEnd)
//STRIP001 {
//STRIP001     DBG_ASSERT(m_bLevenshtein || m_bRegular,
//STRIP001         "FmSearchEngine::SearchRegularApprox : ungueltiger Suchmodus !");
//STRIP001     DBG_ASSERT(!m_bLevenshtein || !m_bRegular,
//STRIP001         "FmSearchEngine::SearchRegularApprox : kann nicht nach regulaeren Ausdruecken und nach Aehnlichkeiten gleichzeitig suchen !");
//STRIP001 
//STRIP001     // Startposition merken
//STRIP001     Any aStartMark = m_xSearchCursor.getBookmark();
//STRIP001     FieldCollectionIterator iterInitialField = iterFieldLoop;
//STRIP001 
//STRIP001     // Parameter sammeln
//STRIP001     SearchOptions aParam;
//STRIP001     aParam.algorithmType = m_bRegular ? SearchAlgorithms_REGEXP : SearchAlgorithms_APPROXIMATE;
//STRIP001     aParam.searchFlag = 0;
//STRIP001     aParam.transliterateFlags = GetTransliterationFlags();
//STRIP001 	if ( !GetTransliteration() )
//STRIP001 	{	// if transliteration is not enabled, the only flags which matter are IGNORE_CASE and IGNORE_WIDTH
//STRIP001 		aParam.transliterateFlags &= TransliterationModules_IGNORE_CASE | TransliterationModules_IGNORE_WIDTH;
//STRIP001 	}
//STRIP001     if (m_bLevenshtein)
//STRIP001     {
//STRIP001         if (m_bLevRelaxed)
//STRIP001             aParam.searchFlag |= SearchFlags::LEV_RELAXED;
//STRIP001         aParam.changedChars = m_nLevOther;
//STRIP001         aParam.deletedChars = m_nLevShorter;
//STRIP001         aParam.insertedChars = m_nLevLonger;
//STRIP001     }
//STRIP001     aParam.searchString = strExpression;
//STRIP001 	aParam.Locale = SvtSysLocale().GetLocaleData().getLocale();
//STRIP001     ::utl::TextSearch aLocalEngine(aParam);
//STRIP001 
//STRIP001     // --------------------------------------------------------------
//STRIP001     sal_Bool bFound(sal_False);
//STRIP001     sal_Bool bMovedAround(sal_False);
//STRIP001     do
//STRIP001     {
//STRIP001         if (m_eMode == FmSearchDialog::SM_ALLOWSCHEDULE)
//STRIP001         {
//STRIP001             Application::Reschedule();
//STRIP001             Application::Reschedule();
//STRIP001             // do 2 reschedules because of #70226# : some things done within this loop's body may cause an user event
//STRIP001             // to be posted (deep within vcl), and these user events will be handled before any keyinput or paintings
//STRIP001             // or anything like that. So within each loop we create one user event and handle one user event (and no
//STRIP001             // paintings and these), so the office seems to be frozen while searching.
//STRIP001             // FS - 70226 - 02.12.99
//STRIP001         }
//STRIP001 
//STRIP001         // der aktuell zu vergleichende Inhalt
//STRIP001         ::rtl::OUString sCurrentCheck;
//STRIP001         if (m_bFormatter)
//STRIP001             sCurrentCheck = FormatField(nFieldPos);
//STRIP001         else
//STRIP001             sCurrentCheck = iterFieldLoop->xContents->getString();
//STRIP001 
//STRIP001         // (don't care about case here, this is done by the TextSearch object, 'cause we passed our case parameter to it)
//STRIP001 
//STRIP001         xub_StrLen nStart = 0, nEnd = (xub_StrLen)sCurrentCheck.getLength();
//STRIP001         bFound = aLocalEngine.SearchFrwrd(sCurrentCheck, &nStart, &nEnd);
//STRIP001             // das heisst hier 'forward' aber das bezieht sich nur auf die Suche innerhalb von sCurrentCheck, hat also mit
//STRIP001             // der Richtung meines Datensatz-Durchwanderns nix zu tun (darum kuemmert sich MoveField)
//STRIP001 
//STRIP001         // checken, ob die Position stimmt
//STRIP001         if (bFound)
//STRIP001         {
//STRIP001             switch (m_nPosition)
//STRIP001             {
//STRIP001                 case MATCHING_WHOLETEXT :
//STRIP001                     if (nEnd != sCurrentCheck.getLength())
//STRIP001                     {
//STRIP001                         bFound = sal_False;
//STRIP001                         break;
//STRIP001                     }
//STRIP001                     // laeuft in den naechsten Case rein !
//STRIP001                 case MATCHING_BEGINNING :
//STRIP001                     if (nStart != 0)
//STRIP001                         bFound = sal_False;
//STRIP001                     break;
//STRIP001                 case MATCHING_END :
//STRIP001                     if (nEnd != sCurrentCheck.getLength())
//STRIP001                         bFound = sal_False;
//STRIP001                     break;
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         if (bFound) // immer noch ?
//STRIP001             break;
//STRIP001 
//STRIP001         // naechstes Feld (implizit naechster Datensatz, wenn noetig)
//STRIP001         if (!MoveField(nFieldPos, iterFieldLoop, iterBegin, iterEnd))
//STRIP001         {   // beim Bewegen auf das naechste Feld ging was schief ... weitermachen ist nicht drin, da das naechste Mal genau
//STRIP001             // das selbe bestimmt wieder schief geht, also Abbruch (ohne Fehlermeldung, von der erwarte ich, dass sie im Move
//STRIP001             // angezeigt wurde)
//STRIP001             // vorher aber noch, damit das Weitersuchen an der aktuellen Position weitermacht :
//STRIP001             m_aPreviousLocBookmark = m_xSearchCursor.getBookmark();
//STRIP001             m_iterPreviousLocField = iterFieldLoop;
//STRIP001             // und wech
//STRIP001             return SR_ERROR;
//STRIP001         }
//STRIP001 
//STRIP001         bMovedAround = COMPARE_BOOKMARKS(aStartMark, m_xSearchCursor.getBookmark()) && (iterFieldLoop == iterInitialField);
//STRIP001 
//STRIP001         if (nFieldPos == 0)
//STRIP001             // das heisst, ich habe mich auf einen neuen Datensatz bewegt
//STRIP001             PropagateProgress(bMovedAround);
//STRIP001                 // if we moved to the starting position we don't have to propagate an 'overflow' message
//STRIP001                 // FS - 07.12.99 - 68530
//STRIP001 
//STRIP001         // abbrechen gefordert ?
//STRIP001         if (CancelRequested())
//STRIP001             return SR_CANCELED;
//STRIP001 
//STRIP001     } while (!bMovedAround);
//STRIP001 
//STRIP001     return bFound ? SR_FOUND : SR_NOTFOUND;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 DBG_NAME(FmSearchEngine)
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmSearchEngine::FmSearchEngine(const Reference< XMultiServiceFactory >& _rxORB,
//STRIP001 			const Reference< XResultSet > & xCursor, const ::rtl::OUString& sVisibleFields,
//STRIP001 			const Reference< XNumberFormatsSupplier > & xFormatSupplier, FmSearchDialog::SEARCH_MODE eMode)
//STRIP001     :m_xSearchCursor(xCursor)
//STRIP001     ,m_xFormatSupplier(xFormatSupplier)
//STRIP001     ,m_bUsingTextComponents(sal_False)
//STRIP001     ,m_bFormatter(sal_False)
//STRIP001     ,m_bForward(sal_False)
//STRIP001     ,m_nPosition(MATCHING_ANYWHERE)
//STRIP001     ,m_nTransliterationFlags(0)
//STRIP001     ,m_bTransliteration(sal_False)
//STRIP001     ,m_nCurrentFieldIndex(-2)   // -1 hat schon eine Bedeutung, also nehme ich -2 fuer 'ungueltig'
//STRIP001     ,m_eMode(eMode)
//STRIP001     ,m_bCancelAsynchRequest(sal_False)
//STRIP001     ,m_bSearchingCurrently(sal_False)
//STRIP001 	,m_aCharacterClassficator( _rxORB, SvtSysLocale().GetLocaleData().getLocale() )
//STRIP001 	,m_aStringCompare( _rxORB )
//STRIP001 {
//STRIP001     DBG_CTOR(FmSearchEngine,NULL);
//STRIP001 
//STRIP001     m_xFormatter = Reference< ::com::sun::star::util::XNumberFormatter > (::legacy_binfilters::getLegacyProcessServiceFactory()
//STRIP001                     ->createInstance(FM_NUMBER_FORMATTER), UNO_QUERY);
//STRIP001     if (m_xFormatter.is())
//STRIP001         m_xFormatter->attachNumberFormatsSupplier(m_xFormatSupplier);
//STRIP001 
//STRIP001     Init(sVisibleFields);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmSearchEngine::FmSearchEngine(const Reference< XMultiServiceFactory >& _rxORB,
//STRIP001 		const Reference< XResultSet > & xCursor, const ::rtl::OUString& sVisibleFields,
//STRIP001 		const InterfaceArray& arrFields, FmSearchDialog::SEARCH_MODE eMode)
//STRIP001     :m_xSearchCursor(xCursor)
//STRIP001     ,m_xOriginalIterator(xCursor)
//STRIP001     ,m_xClonedIterator(m_xOriginalIterator, sal_True)
//STRIP001     ,m_bUsingTextComponents(sal_True)
//STRIP001     ,m_bFormatter(sal_True)     // das muss konsistent sein mit m_xSearchCursor, der i.A. == m_xOriginalIterator ist
//STRIP001     ,m_bForward(sal_False)
//STRIP001     ,m_nPosition(MATCHING_ANYWHERE)
//STRIP001     ,m_nTransliterationFlags(0)
//STRIP001     ,m_bTransliteration(sal_False)
//STRIP001     ,m_nCurrentFieldIndex(-2)
//STRIP001     ,m_eMode(eMode)
//STRIP001     ,m_bCancelAsynchRequest(sal_False)
//STRIP001     ,m_bSearchingCurrently(sal_False)
//STRIP001 	,m_aCharacterClassficator( _rxORB, SvtSysLocale().GetLocaleData().getLocale() )
//STRIP001 	,m_aStringCompare( _rxORB )
//STRIP001 {
//STRIP001     DBG_CTOR(FmSearchEngine,NULL);
//STRIP001 
//STRIP001     fillControlTexts(arrFields);
//STRIP001     Init(sVisibleFields);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmSearchEngine::~FmSearchEngine()
//STRIP001 {
//STRIP001     clearControlTexts();
//STRIP001 
//STRIP001     DBG_DTOR(FmSearchEngine,NULL);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::SetIgnoreWidthCJK(sal_Bool bSet)
//STRIP001 {
//STRIP001     if (bSet)
//STRIP001         m_nTransliterationFlags |= TransliterationModules_IGNORE_WIDTH;
//STRIP001     else
//STRIP001         m_nTransliterationFlags &= ~TransliterationModules_IGNORE_WIDTH;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_Bool FmSearchEngine::GetIgnoreWidthCJK() const
//STRIP001 {
//STRIP001     return 0 != (m_nTransliterationFlags & TransliterationModules_IGNORE_WIDTH);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::SetCaseSensitive(sal_Bool bSet)
//STRIP001 {
//STRIP001     if (bSet)
//STRIP001         m_nTransliterationFlags &= ~TransliterationModules_IGNORE_CASE;
//STRIP001     else
//STRIP001         m_nTransliterationFlags |= TransliterationModules_IGNORE_CASE;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_Bool FmSearchEngine::GetCaseSensitive() const
//STRIP001 {
//STRIP001     return 0 == (m_nTransliterationFlags & TransliterationModules_IGNORE_CASE);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::clearControlTexts()
//STRIP001 {
//STRIP001     for (   ControlTextSuppliersIterator aIter = m_aControlTexts.begin();
//STRIP001             aIter < m_aControlTexts.end();
//STRIP001             ++aIter
//STRIP001         )
//STRIP001     {
//STRIP001         delete *aIter;
//STRIP001     }
//STRIP001     m_aControlTexts.clear();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::fillControlTexts(const InterfaceArray& arrFields)
//STRIP001 {
//STRIP001     clearControlTexts();
//STRIP001     Reference< XInterface >  xCurrent;
//STRIP001     for (sal_uInt32 i=0; i<arrFields.size(); ++i)
//STRIP001     {
//STRIP001         xCurrent = arrFields.at(i);
//STRIP001         DBG_ASSERT(xCurrent.is(), "FmSearchEngine::fillControlTexts : invalid field interface !");
//STRIP001         // check which type of control this is
//STRIP001         Reference< ::com::sun::star::awt::XTextComponent >  xAsText(xCurrent, UNO_QUERY);
//STRIP001         if (xAsText.is())
//STRIP001         {
//STRIP001             m_aControlTexts.insert(m_aControlTexts.end(), new SimpleTextWrapper(xAsText));
//STRIP001             continue;
//STRIP001         }
//STRIP001 
//STRIP001         Reference< ::com::sun::star::awt::XListBox >  xAsListBox(xCurrent, UNO_QUERY);
//STRIP001         if (xAsListBox.is())
//STRIP001         {
//STRIP001             m_aControlTexts.insert(m_aControlTexts.end(), new ListBoxWrapper(xAsListBox));
//STRIP001             continue;
//STRIP001         }
//STRIP001 
//STRIP001         Reference< ::com::sun::star::awt::XCheckBox >  xAsCheckBox(xCurrent, UNO_QUERY);
//STRIP001         DBG_ASSERT(xAsCheckBox.is(), "FmSearchEngine::fillControlTexts : invalid field interface (no supported type) !");
//STRIP001             // we don't have any more options ...
//STRIP001         m_aControlTexts.insert(m_aControlTexts.end(), new CheckBoxWrapper(xAsCheckBox));
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::Init(const ::rtl::OUString& sVisibleFields)
//STRIP001 {
//STRIP001 	// analyze the fields
//STRIP001 	// additionally, create the mapping: because the list of used columns can be shorter than the list
//STRIP001 	// of columns of the cursor, we need a mapping: "used column numer n" -> "cursor column m"
//STRIP001     m_arrFieldMapping.Remove(0, m_arrFieldMapping.Count());
//STRIP001 
//STRIP001 	// important: The case of the columns does not need to be exact - for instance:
//STRIP001 	// - a user created a form which works on a table, for which the driver returns a column name "COLUMN"
//STRIP001 	// - the driver itself works case-insensitve with column names
//STRIP001 	// - a control in the form is bound to "column" - not the different case
//STRIP001 	// In such a scenario, the form and the field would work okay, but we here need to case for the different case
//STRIP001 	// explicitly
//STRIP001 	// 2003-01-09 - #i8755# - fs@openoffice.org
//STRIP001 
//STRIP001 	// so first of all, check if the database handles identifiers case sensitive
//STRIP001 	Reference< XConnection > xConn;
//STRIP001 	Reference< XDatabaseMetaData > xMeta;
//STRIP001 	Reference< XPropertySet > xCursorProps( IFACECAST( m_xSearchCursor ), UNO_QUERY );
//STRIP001 	if ( xCursorProps.is() )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			xCursorProps->getPropertyValue( FM_PROP_ACTIVE_CONNECTION ) >>= xConn;
//STRIP001 		}
//STRIP001 		catch( Exception& ) { /* silent this - will be asserted below */ }
//STRIP001 	}
//STRIP001 	if ( xConn.is() )
//STRIP001 		xMeta = xConn->getMetaData();
//STRIP001 	OSL_ENSURE( xMeta.is(), "FmSearchEngine::Init: very strange cursor (could not derive connection meta data from it)!" );
//STRIP001 
//STRIP001 	sal_Bool bCaseSensitiveIdentifiers = sal_True;	// assume case sensivity
//STRIP001 	if ( xMeta.is() )
//STRIP001 		bCaseSensitiveIdentifiers = xMeta->supportsMixedCaseQuotedIdentifiers();
//STRIP001 
//STRIP001 	// now that we have this information, we need a collator which is able to case (in)sentively compare strings
//STRIP001 	m_aStringCompare.loadDefaultCollator( SvtSysLocale().GetLocaleData().getLocale(),
//STRIP001 		bCaseSensitiveIdentifiers ? 0 : ::com::sun::star::i18n::CollatorOptions::CollatorOptions_IGNORE_CASE );
//STRIP001 
//STRIP001     try
//STRIP001     {
//STRIP001         // der Cursor kann mir einen Record (als PropertySet) liefern, dieser unterstuetzt den DatabaseRecord-Service
//STRIP001         Reference< ::com::sun::star::sdbcx::XColumnsSupplier >  xSupplyCols(IFACECAST(m_xSearchCursor), UNO_QUERY);
//STRIP001         DBG_ASSERT(xSupplyCols.is(), "FmSearchEngine::Init : invalid cursor (no columns supplier) !");
//STRIP001         Reference< ::com::sun::star::container::XNameAccess >       xAllFieldNames = xSupplyCols->getColumns();
//STRIP001         Sequence< ::rtl::OUString > seqFieldNames = xAllFieldNames->getElementNames();
//STRIP001         ::rtl::OUString*            pFieldNames = seqFieldNames.getArray();
//STRIP001 
//STRIP001 
//STRIP001         ::rtl::OUString sCurrentField;
//STRIP001         UniString sVis(sVisibleFields.getStr());
//STRIP001         xub_StrLen nLen = sVis.GetTokenCount();
//STRIP001         for (xub_StrLen i=0; i<nLen; ++i)
//STRIP001         {
//STRIP001             sCurrentField = sVis.GetToken(i);
//STRIP001 
//STRIP001             // in der Feld-Sammlung suchen
//STRIP001             sal_Int32 nFoundIndex = -1;
//STRIP001             for (sal_Int32 j=0; j<seqFieldNames.getLength(); ++j, ++pFieldNames)
//STRIP001             {
//STRIP001 				if ( 0 == m_aStringCompare.compareString( *pFieldNames, sCurrentField ) )
//STRIP001                 {
//STRIP001                     nFoundIndex = j;
//STRIP001                     break;
//STRIP001                 }
//STRIP001             }
//STRIP001             // set the field selection back to the first
//STRIP001             pFieldNames = seqFieldNames.getArray();;
//STRIP001             DBG_ASSERT(nFoundIndex != -1, "FmSearchEngine::Init : Es wurden ungueltige Feldnamen angegeben !");
//STRIP001             m_arrFieldMapping.Insert(nFoundIndex, m_arrFieldMapping.Count());
//STRIP001         }
//STRIP001     }
//STRIP001     catch(Exception&)
//STRIP001     {
//STRIP001         DBG_ERROR("Exception occured!");
//STRIP001     }
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::SetFormatterUsing(sal_Bool bSet)
//STRIP001 {
//STRIP001     if (m_bFormatter == bSet)
//STRIP001         return;
//STRIP001     m_bFormatter = bSet;
//STRIP001 
//STRIP001     if (m_bUsingTextComponents)
//STRIP001     {
//STRIP001         // ich benutzte keinen Formatter, sondern TextComponents -> der SearchIterator muss angepasst werden
//STRIP001         if (m_bFormatter)
//STRIP001         {
//STRIP001             DBG_ASSERT(m_xSearchCursor == m_xClonedIterator, "FmSearchEngine::SetFormatterUsing : inkonsistenter Zustand !");
//STRIP001             m_xSearchCursor = m_xOriginalIterator;
//STRIP001             m_xSearchCursor.moveToBookmark(m_xClonedIterator.getBookmark());
//STRIP001                 // damit ich mit dem neuen Iterator wirklich dort weitermache, wo ich vorher aufgehoert habe
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             DBG_ASSERT(m_xSearchCursor == m_xOriginalIterator, "FmSearchEngine::SetFormatterUsing : inkonsistenter Zustand !");
//STRIP001             m_xSearchCursor = m_xClonedIterator;
//STRIP001             m_xSearchCursor.moveToBookmark(m_xOriginalIterator.getBookmark());
//STRIP001         }
//STRIP001 
//STRIP001         // ich muss die Fields neu binden, da der Textaustausch eventuell ueber diese Fields erfolgt und sich der unterliegende Cursor
//STRIP001         // geaendert hat
//STRIP001         RebuildUsedFields(m_nCurrentFieldIndex, sal_True);
//STRIP001     }
//STRIP001     else
//STRIP001         InvalidatePreviousLoc();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::PropagateProgress(sal_Bool _bDontPropagateOverflow)
//STRIP001 {
//STRIP001     if (m_aProgressHandler.IsSet())
//STRIP001     {
//STRIP001         FmSearchProgress aProgress;
//STRIP001         aProgress.aSearchState = FmSearchProgress::STATE_PROGRESS;
//STRIP001         aProgress.nCurrentRecord = m_xSearchCursor.getRow() - 1;
//STRIP001         if (m_bForward)
//STRIP001             aProgress.bOverflow = !_bDontPropagateOverflow && m_xSearchCursor.isFirst();
//STRIP001         else
//STRIP001             aProgress.bOverflow = !_bDontPropagateOverflow && m_xSearchCursor.isLast();
//STRIP001         m_aProgressHandler.Call(&aProgress);
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::SearchNextImpl()
//STRIP001 {
//STRIP001     DBG_ASSERT(!(m_bWildcard && m_bRegular) && !(m_bRegular && m_bLevenshtein) && !(m_bLevenshtein && m_bWildcard),
//STRIP001         "FmSearchEngine::SearchNextImpl : Suchparameter schliessen sich gegenseitig aus !");
//STRIP001 
//STRIP001     DBG_ASSERT(m_xSearchCursor.is(), "FmSearchEngine::SearchNextImpl : habe ungueltigen Iterator !");
//STRIP001 
//STRIP001     // die Parameter der Suche
//STRIP001     ::rtl::OUString strSearchExpression(m_strSearchExpression); // brauche ich non-const
//STRIP001     if (!GetCaseSensitive())
//STRIP001 		// norm the string
//STRIP001 		m_aCharacterClassficator.toLower_rtl(strSearchExpression);
//STRIP001 
//STRIP001     if (!m_bRegular && !m_bLevenshtein)
//STRIP001     {   // 'normale' Suche fuehre ich auf jeden Fall ueber WildCards durch, muss aber vorher je nach Modus den ::rtl::OUString anpassen
//STRIP001 
//STRIP001         if (!m_bWildcard)
//STRIP001         {   // da natuerlich in allen anderen Faellen auch * und ? im Suchstring erlaubt sind, aber nicht als WildCards zaehlen
//STRIP001             // sollen, muss ich normieren
//STRIP001             UniString aTmp(strSearchExpression.getStr());
//STRIP001             static const UniString s_sStar = UniString::CreateFromAscii("\\*");
//STRIP001             static const UniString s_sQuotation = UniString::CreateFromAscii("\\?");
//STRIP001             aTmp.SearchAndReplaceAll('*', s_sStar);
//STRIP001             aTmp.SearchAndReplaceAll('?', s_sQuotation);
//STRIP001             strSearchExpression = aTmp;
//STRIP001 
//STRIP001             switch (m_nPosition)
//STRIP001             {
//STRIP001                 case MATCHING_ANYWHERE :
//STRIP001                     strSearchExpression = ::rtl::OUString::createFromAscii("*") + strSearchExpression
//STRIP001                     + ::rtl::OUString::createFromAscii("*");
//STRIP001                     break;
//STRIP001                 case MATCHING_BEGINNING :
//STRIP001                     strSearchExpression = strSearchExpression + ::rtl::OUString::createFromAscii("*");
//STRIP001                     break;
//STRIP001                 case MATCHING_END :
//STRIP001                     strSearchExpression = ::rtl::OUString::createFromAscii("*") + strSearchExpression;
//STRIP001                     break;
//STRIP001                 case MATCHING_WHOLETEXT :
//STRIP001                     break;
//STRIP001                 default :
//STRIP001                     DBG_ERROR("FmSearchEngine::SearchNextImpl() : die Methoden-Listbox duerfte nur 4 Eintraege enthalten ...");
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     // fuer Arbeit auf Feldliste
//STRIP001     FieldCollectionIterator iterBegin = m_arrUsedFields.begin();
//STRIP001     FieldCollectionIterator iterEnd = m_arrUsedFields.end();
//STRIP001     FieldCollectionIterator iterFieldCheck;
//STRIP001 
//STRIP001     sal_Int32 nFieldPos;
//STRIP001 
//STRIP001     if (HasPreviousLoc())
//STRIP001     {
//STRIP001         DBG_ASSERT(COMPARE_BOOKMARKS(m_aPreviousLocBookmark, m_xSearchCursor.getBookmark()),
//STRIP001             "FmSearchEngine::SearchNextImpl : ungueltige Position !");
//STRIP001         iterFieldCheck = m_iterPreviousLocField;
//STRIP001         // im Feld nach (oder vor) der letzten Fundstelle weitermachen
//STRIP001         nFieldPos = iterFieldCheck - iterBegin;
//STRIP001         MoveField(nFieldPos, iterFieldCheck, iterBegin, iterEnd);
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         if (m_bForward)
//STRIP001             iterFieldCheck = iterBegin;
//STRIP001         else
//STRIP001         {
//STRIP001             iterFieldCheck = iterEnd;
//STRIP001             --iterFieldCheck;
//STRIP001         }
//STRIP001         nFieldPos = iterFieldCheck - iterBegin;
//STRIP001     }
//STRIP001 
//STRIP001     // ---------------------
//STRIP001     // die eigentliche Suche
//STRIP001 #ifndef NOOLDSV
//STRIP001     if (m_eMode == FmSearchDialog::SM_BRUTE)
//STRIP001         Application::EnterWait();
//STRIP001 #endif
//STRIP001 
//STRIP001     PropagateProgress(sal_True);
//STRIP001     SEARCH_RESULT srResult;
//STRIP001     if (m_eSearchForType != SEARCHFOR_STRING)
//STRIP001         srResult = SearchSpecial(m_eSearchForType == SEARCHFOR_NULL, nFieldPos, iterFieldCheck, iterBegin, iterEnd);
//STRIP001     else if (!m_bRegular && !m_bLevenshtein)
//STRIP001         srResult = SearchWildcard(strSearchExpression, nFieldPos, iterFieldCheck, iterBegin, iterEnd);
//STRIP001     else
//STRIP001         srResult = SearchRegularApprox(strSearchExpression, nFieldPos, iterFieldCheck, iterBegin, iterEnd);
//STRIP001 
//STRIP001 #ifndef NOOLDSV
//STRIP001     if (m_eMode == FmSearchDialog::SM_BRUTE)
//STRIP001         Application::LeaveWait();
//STRIP001 #endif
//STRIP001 
//STRIP001     // ---------------------
//STRIP001     m_srResult = srResult;
//STRIP001 
//STRIP001     if (SR_ERROR == m_srResult)
//STRIP001         return;
//STRIP001 
//STRIP001     // gefunden ?
//STRIP001     if (SR_FOUND == m_srResult)
//STRIP001     {
//STRIP001         // die Pos merken
//STRIP001         m_aPreviousLocBookmark = m_xSearchCursor.getBookmark();
//STRIP001         m_iterPreviousLocField = iterFieldCheck;
//STRIP001     }
//STRIP001     else
//STRIP001         // die "letzte Fundstelle" invalidieren
//STRIP001         InvalidatePreviousLoc();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmSearchEngine, OnSearchTerminated, FmSearchThread*, pThread)
//STRIP001 {
//STRIP001     if (!m_aProgressHandler.IsSet())
//STRIP001         return 0L;
//STRIP001 
//STRIP001     FmSearchProgress aProgress;
//STRIP001     switch (m_srResult)
//STRIP001     {
//STRIP001         case SR_ERROR :
//STRIP001             aProgress.aSearchState = FmSearchProgress::STATE_ERROR;
//STRIP001             break;
//STRIP001         case SR_FOUND :
//STRIP001             aProgress.aSearchState = FmSearchProgress::STATE_SUCCESSFULL;
//STRIP001             aProgress.aBookmark = m_aPreviousLocBookmark;
//STRIP001             aProgress.nFieldIndex = m_iterPreviousLocField - m_arrUsedFields.begin();
//STRIP001             break;
//STRIP001         case SR_NOTFOUND :
//STRIP001             aProgress.aSearchState = FmSearchProgress::STATE_NOTHINGFOUND;
//STRIP001             aProgress.aBookmark = m_xSearchCursor.getBookmark();
//STRIP001             break;
//STRIP001         case SR_CANCELED :
//STRIP001             aProgress.aSearchState = FmSearchProgress::STATE_CANCELED;
//STRIP001             aProgress.aBookmark = m_xSearchCursor.getBookmark();
//STRIP001             break;
//STRIP001     }
//STRIP001     aProgress.nCurrentRecord = m_xSearchCursor.getRow() - 1;
//STRIP001 
//STRIP001     // per definitionem muss der Link Thread-sicher sein (das verlange ich einfach), so dass ich mich um so etwas hier nicht kuemmern muss
//STRIP001     m_aProgressHandler.Call(&aProgress);
//STRIP001 
//STRIP001     m_bSearchingCurrently = sal_False;
//STRIP001     return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmSearchEngine, OnNewRecordCount, void*, pCounterAsVoid)
//STRIP001 {
//STRIP001     if (!m_aProgressHandler.IsSet())
//STRIP001         return 0L;
//STRIP001 
//STRIP001     FmSearchProgress aProgress;
//STRIP001     aProgress.nCurrentRecord = (sal_uInt32)pCounterAsVoid;
//STRIP001     aProgress.aSearchState = FmSearchProgress::STATE_PROGRESS_COUNTING;
//STRIP001     m_aProgressHandler.Call(&aProgress);
//STRIP001 
//STRIP001     return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_Bool FmSearchEngine::CancelRequested()
//STRIP001 {
//STRIP001     m_aCancelAsynchAccess.acquire();
//STRIP001     sal_Bool bReturn = m_bCancelAsynchRequest;
//STRIP001     m_aCancelAsynchAccess.release();
//STRIP001     return bReturn;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::CancelSearch()
//STRIP001 {
//STRIP001     m_aCancelAsynchAccess.acquire();
//STRIP001     m_bCancelAsynchRequest = sal_True;
//STRIP001     m_aCancelAsynchAccess.release();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_Bool FmSearchEngine::SwitchToContext(const Reference< ::com::sun::star::sdbc::XResultSet > & xCursor, const ::rtl::OUString& sVisibleFields, const InterfaceArray& arrFields,
//STRIP001     sal_Int32 nFieldIndex)
//STRIP001 {
//STRIP001     DBG_ASSERT(!m_bSearchingCurrently, "FmSearchEngine::SwitchToContext : please do not call while I'm searching !");
//STRIP001     if (m_bSearchingCurrently)
//STRIP001         return sal_False;
//STRIP001 
//STRIP001     m_xSearchCursor = xCursor;
//STRIP001     m_xOriginalIterator = xCursor;
//STRIP001     m_xClonedIterator = CursorWrapper(m_xOriginalIterator, sal_True);
//STRIP001     m_bUsingTextComponents = sal_True;
//STRIP001 
//STRIP001     fillControlTexts(arrFields);
//STRIP001 
//STRIP001     Init(sVisibleFields);
//STRIP001     RebuildUsedFields(nFieldIndex, sal_True);
//STRIP001 
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::ImplStartNextSearch()
//STRIP001 {
//STRIP001     m_bCancelAsynchRequest = sal_False;
//STRIP001     m_bSearchingCurrently = sal_True;
//STRIP001 
//STRIP001     if (m_eMode == FmSearchDialog::SM_USETHREAD)
//STRIP001     {
//STRIP001         FmSearchThread* pSearcher = new FmSearchThread(this);
//STRIP001             // der loescht sich nach Beendigung selber ...
//STRIP001         pSearcher->setTerminationHandler(LINK(this, FmSearchEngine, OnSearchTerminated));
//STRIP001 
//STRIP001         pSearcher->createSuspended();
//STRIP001         pSearcher->setPriority(::vos::OThread::TPriority_Lowest);
//STRIP001         pSearcher->resume();
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         SearchNextImpl();
//STRIP001         LINK(this, FmSearchEngine, OnSearchTerminated).Call(NULL);
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::SearchNext(const ::rtl::OUString& strExpression)
//STRIP001 {
//STRIP001     m_strSearchExpression = strExpression;
//STRIP001     m_eSearchForType = SEARCHFOR_STRING;
//STRIP001     ImplStartNextSearch();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::SearchNextSpecial(sal_Bool _bSearchForNull)
//STRIP001 {
//STRIP001     m_eSearchForType = _bSearchForNull ? SEARCHFOR_NULL : SEARCHFOR_NOTNULL;
//STRIP001     ImplStartNextSearch();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::StartOver(const ::rtl::OUString& strExpression)
//STRIP001 {
//STRIP001     if (m_bForward)
//STRIP001         m_xSearchCursor.first();
//STRIP001     else
//STRIP001         m_xSearchCursor.last();
//STRIP001 
//STRIP001     InvalidatePreviousLoc();
//STRIP001     SearchNext(strExpression);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::StartOverSpecial(sal_Bool _bSearchForNull)
//STRIP001 {
//STRIP001     if (m_bForward)
//STRIP001         m_xSearchCursor.first();
//STRIP001     else
//STRIP001         m_xSearchCursor.last();
//STRIP001 
//STRIP001     InvalidatePreviousLoc();
//STRIP001     SearchNextSpecial(_bSearchForNull);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::InvalidatePreviousLoc()
//STRIP001 {
//STRIP001     m_aPreviousLocBookmark.setValue(0,getVoidCppuType());
//STRIP001     m_iterPreviousLocField = m_arrUsedFields.end();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchEngine::RebuildUsedFields(sal_Int32 nFieldIndex, sal_Bool bForce)
//STRIP001 {
//STRIP001     if (!bForce && (nFieldIndex == m_nCurrentFieldIndex))
//STRIP001         return;
//STRIP001     // (da ich keinen Wechsel des Iterators von aussen zulasse, heisst selber ::com::sun::star::sdbcx::Index auch immer selbe Spalte, also habe ich nix zu tun)
//STRIP001 
//STRIP001     DBG_ASSERT((nFieldIndex >= -1) && (nFieldIndex<m_arrFieldMapping.Count()), "FmSearchEngine::RebuildUsedFields : nFieldIndex ist ungueltig !");
//STRIP001     // alle Felder, die ich durchsuchen muss, einsammeln
//STRIP001     m_arrUsedFields.clear();
//STRIP001     if (nFieldIndex == -1)
//STRIP001     {
//STRIP001         Reference< ::com::sun::star::container::XIndexAccess >  xFields;
//STRIP001         for (sal_uInt16 i=0; i<m_arrFieldMapping.Count(); ++i)
//STRIP001         {
//STRIP001             Reference< ::com::sun::star::sdbcx::XColumnsSupplier >  xSupplyCols(IFACECAST(m_xSearchCursor), UNO_QUERY);
//STRIP001             DBG_ASSERT(xSupplyCols.is(), "FmSearchEngine::RebuildUsedFields : invalid cursor (no columns supplier) !");
//STRIP001             xFields = Reference< ::com::sun::star::container::XIndexAccess > (xSupplyCols->getColumns(), UNO_QUERY);
//STRIP001             BuildAndInsertFieldInfo(xFields, m_arrFieldMapping.GetObject(i));
//STRIP001         }
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         Reference< ::com::sun::star::container::XIndexAccess >  xFields;
//STRIP001         Reference< ::com::sun::star::sdbcx::XColumnsSupplier >  xSupplyCols(IFACECAST(m_xSearchCursor), UNO_QUERY);
//STRIP001         DBG_ASSERT(xSupplyCols.is(), "FmSearchEngine::RebuildUsedFields : invalid cursor (no columns supplier) !");
//STRIP001         xFields = Reference< ::com::sun::star::container::XIndexAccess > (xSupplyCols->getColumns(), UNO_QUERY);
//STRIP001         BuildAndInsertFieldInfo(xFields, m_arrFieldMapping.GetObject((sal_uInt16)nFieldIndex));
//STRIP001     }
//STRIP001 
//STRIP001     m_nCurrentFieldIndex = nFieldIndex;
//STRIP001     // und natuerlich beginne ich die naechste Suche wieder jungfraeulich
//STRIP001     InvalidatePreviousLoc();
//STRIP001 }

}
