/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_countryid.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:25:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// ============================================================================

#ifndef INCLUDED_SVX_COUNTRYID_HXX
#include "countryid.hxx"
#endif

#include <algorithm>
namespace binfilter {

// ----------------------------------------------------------------------------

//STRIP001 namespace svx {
//STRIP001 
//STRIP001 // Mapping table ==============================================================
//STRIP001 
//STRIP001 namespace {
//STRIP001 
//STRIP001 // ----------------------------------------------------------------------------
//STRIP001 
//STRIP001 /** Table entry for Windows country ID <-> language type conversion.
//STRIP001 
//STRIP001     The first member is the Windows country ID, as defined in the header.
//STRIP001 
//STRIP001     The second member contains the corresponding language type for each country
//STRIP001     ID. This must be a full language, not only the primary language type.
//STRIP001 
//STRIP001     The last bool flag defines, if the sub language type should be evaluated to
//STRIP001     find the country ID from a language. If not set, all languages map to the
//STRIP001     country which contain the given primary language type.
//STRIP001 
//STRIP001     Example: The language entry (COUNTRY_USA,LANGUAGE_ENGLISH_US,false) maps
//STRIP001     the country ID for USA to the language LANGUAGE_ENGLISH_US. The clear sub
//STRIP001     language flag causes all english languages LANGUAGE_ENGLISH_*** to map to
//STRIP001     this country ID by default. To map the special case LANGUAGE_ENGLISH_EIRE
//STRIP001     to the country ID COUNTRY_IRELAND, the sub language flag must be set in the
//STRIP001     respective table entry, here (COUNTRY_IRELAND,LANGUAGE_ENGLISH_EIRE,true).
//STRIP001  */
//STRIP001 struct CountryEntry
//STRIP001 {
//STRIP001     CountryId                   meCountry;      /// Windows country ID.
//STRIP001     LanguageType                meLanguage;     /// Corresponding language type.
//STRIP001     bool                        mbUseSubLang;   /// false = Primary only, true = Primary and sub language.
//STRIP001 };
//STRIP001 
//STRIP001 // ----------------------------------------------------------------------------
//STRIP001 
//STRIP001 // Dhivehi not yet implemented -> #i11530#
//STRIP001 #ifndef LANGUAGE_DHIVEHI
//STRIP001 #define LANGUAGE_DHIVEHI 0x0465
//STRIP001 #endif
//STRIP001 
//STRIP001 /** Table for Windows country ID <-> language type conversion.
//STRIP001 
//STRIP001     To map the same language to different country IDs, some of the entries
//STRIP001     should contain a set sub language flag (see description of CountryEntry).
//STRIP001     All table entries with a set flag take priority over the entry with the
//STRIP001     same primary language, but cleared sub language flag, regardless of the
//STRIP001     position in the table.
//STRIP001 
//STRIP001     To map different languages to the same country ID, several entries with the
//STRIP001     same country ID may be inserted. In this case the conversion to a language
//STRIP001     is done with the first found entry (starting from top) containing the given
//STRIP001     country ID.
//STRIP001 
//STRIP001     For now all entries are sorted by country ID, but this is not required.
//STRIP001  */
//STRIP001 static const CountryEntry pTable[] =
//STRIP001 {
//STRIP001     { COUNTRY_USA,                  LANGUAGE_ENGLISH_US                             },
//STRIP001     { COUNTRY_DOMINICAN_REPUBLIC,   LANGUAGE_SPANISH_DOMINICAN_REPUBLIC,    true    },
//STRIP001     { COUNTRY_JAMAICA,              LANGUAGE_ENGLISH_JAMAICA,               true    },
//STRIP001     { COUNTRY_PUERTO_RICO,          LANGUAGE_SPANISH_PUERTO_RICO,           true    },
//STRIP001     { COUNTRY_TRINIDAD_Y_TOBAGO,    LANGUAGE_ENGLISH_TRINIDAD,              true    },
//STRIP001     { COUNTRY_CANADA,               LANGUAGE_ENGLISH_CAN,                   true    },
//STRIP001     { COUNTRY_CANADA,               LANGUAGE_FRENCH_CANADIAN,               true    },
//STRIP001     { COUNTRY_RUSSIA,               LANGUAGE_RUSSIAN                                },
//STRIP001     { COUNTRY_KAZAKHSTAN,           LANGUAGE_KAZAK                                  },
//STRIP001     { COUNTRY_TATARSTAN,            LANGUAGE_TATAR                                  },
//STRIP001     { COUNTRY_EGYPT,                LANGUAGE_ARABIC_EGYPT,                  true    },
//STRIP001     { COUNTRY_SOUTH_AFRICA,         LANGUAGE_AFRIKAANS                              },
//STRIP001     { COUNTRY_SOUTH_AFRICA,         LANGUAGE_ENGLISH_SAFRICA,               true    },
//STRIP001     { COUNTRY_SOUTH_AFRICA,         LANGUAGE_TSONGA                                 },
//STRIP001     { COUNTRY_SOUTH_AFRICA,         LANGUAGE_VENDA                                  },
//STRIP001     { COUNTRY_SOUTH_AFRICA,         LANGUAGE_XHOSA                                  },
//STRIP001     { COUNTRY_SOUTH_AFRICA,         LANGUAGE_ZULU                                   },
//STRIP001     { COUNTRY_GREECE,               LANGUAGE_GREEK                                  },
//STRIP001     { COUNTRY_NETHERLANDS,          LANGUAGE_DUTCH                                  },
//STRIP001     { COUNTRY_NETHERLANDS,          LANGUAGE_FRISIAN_NETHERLANDS                    },
//STRIP001     { COUNTRY_BELGIUM,              LANGUAGE_DUTCH_BELGIAN,                 true    },
//STRIP001     { COUNTRY_BELGIUM,              LANGUAGE_FRENCH_BELGIAN,                true    },
//STRIP001     { COUNTRY_FRANCE,               LANGUAGE_FRENCH                                 },
//STRIP001     { COUNTRY_SPAIN,                LANGUAGE_SPANISH                                },
//STRIP001     { COUNTRY_SPAIN,                LANGUAGE_CATALAN                                },
//STRIP001     { COUNTRY_SPAIN,                LANGUAGE_BASQUE                                 },
//STRIP001     { COUNTRY_SPAIN,                LANGUAGE_GALICIAN                               },
//STRIP001     { COUNTRY_HUNGARY,              LANGUAGE_HUNGARIAN                              },
//STRIP001     { COUNTRY_ITALY,                LANGUAGE_ITALIAN                                },
//STRIP001     { COUNTRY_ROMANIA,              LANGUAGE_ROMANIAN                               },
//STRIP001     { COUNTRY_SWITZERLAND,          LANGUAGE_GERMAN_SWISS,                  true    },
//STRIP001     { COUNTRY_SWITZERLAND,          LANGUAGE_FRENCH_SWISS,                  true    },
//STRIP001     { COUNTRY_SWITZERLAND,          LANGUAGE_ITALIAN_SWISS,                 true    },
//STRIP001     { COUNTRY_SWITZERLAND,          LANGUAGE_RHAETO_ROMAN                           },
//STRIP001     { COUNTRY_AUSTRIA,              LANGUAGE_GERMAN_AUSTRIAN,               true    },
//STRIP001     { COUNTRY_UNITED_KINGDOM,       LANGUAGE_ENGLISH_UK,                    true    },
//STRIP001     { COUNTRY_UNITED_KINGDOM,       LANGUAGE_GAELIC_SCOTLAND,               true    },
//STRIP001     { COUNTRY_UNITED_KINGDOM,       LANGUAGE_WELSH                                  },
//STRIP001     { COUNTRY_DENMARK,              LANGUAGE_DANISH                                 },
//STRIP001     { COUNTRY_SWEDEN,               LANGUAGE_SWEDISH                                },
//STRIP001     { COUNTRY_SWEDEN,               LANGUAGE_SAMI_LAPPISH                           },
//STRIP001     { COUNTRY_NORWAY,               LANGUAGE_NORWEGIAN_BOKMAL                       },
//STRIP001     { COUNTRY_POLAND,               LANGUAGE_POLISH                                 },
//STRIP001     { COUNTRY_GERMANY,              LANGUAGE_GERMAN                                 },
//STRIP001     { COUNTRY_GERMANY,              LANGUAGE_SORBIAN                                },
//STRIP001     { COUNTRY_PERU,                 LANGUAGE_SPANISH_PERU,                  true    },
//STRIP001     { COUNTRY_MEXICO,               LANGUAGE_SPANISH_MEXICAN,               true    },
//STRIP001     { COUNTRY_ARGENTINIA,           LANGUAGE_SPANISH_ARGENTINA,             true    },
//STRIP001     { COUNTRY_BRAZIL,               LANGUAGE_PORTUGUESE_BRAZILIAN,          true    },
//STRIP001     { COUNTRY_CHILE,                LANGUAGE_SPANISH_CHILE,                 true    },
//STRIP001     { COUNTRY_COLOMBIA,             LANGUAGE_SPANISH_COLOMBIA,              true    },
//STRIP001     { COUNTRY_VENEZUELA,            LANGUAGE_SPANISH_VENEZUELA,             true    },
//STRIP001     { COUNTRY_MALAYSIA,             LANGUAGE_MALAY_MALAYSIA                         },
//STRIP001     { COUNTRY_AUSTRALIA,            LANGUAGE_ENGLISH_AUS,                   true    },
//STRIP001     { COUNTRY_INDONESIA,            LANGUAGE_INDONESIAN                             },
//STRIP001     { COUNTRY_PHILIPPINES,          LANGUAGE_ENGLISH_PHILIPPINES,           true    },
//STRIP001     { COUNTRY_NEW_ZEALAND,          LANGUAGE_USER_MAORI                             },
//STRIP001     { COUNTRY_NEW_ZEALAND,          LANGUAGE_ENGLISH_NZ,                    true    },
//STRIP001     { COUNTRY_SINGAPORE,            LANGUAGE_CHINESE_SINGAPORE,             true    },
//STRIP001     { COUNTRY_THAILAND,             LANGUAGE_THAI                                   },
//STRIP001     { COUNTRY_JAPAN,                LANGUAGE_JAPANESE                               },
//STRIP001     { COUNTRY_SOUTH_KOREA,          LANGUAGE_KOREAN                                 },
//STRIP001     { COUNTRY_VIET_NAM,             LANGUAGE_VIETNAMESE                             },
//STRIP001     { COUNTRY_PR_CHINA,             LANGUAGE_CHINESE_SIMPLIFIED                     },
//STRIP001     { COUNTRY_TIBET,                LANGUAGE_TIBETAN                                },
//STRIP001     { COUNTRY_TURKEY,               LANGUAGE_TURKISH                                },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_HINDI                                  },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_URDU_INDIA,                    true    },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_PUNJABI                                },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_GUJARATI                               },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_ORIYA                                  },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_TAMIL                                  },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_TELUGU                                 },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_KANNADA                                },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_MALAYALAM                              },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_ASSAMESE                               },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_MARATHI                                },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_SANSKRIT                               },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_KONKANI                                },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_MANIPURI                               },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_SINDHI                                 },
//STRIP001     { COUNTRY_INDIA,                LANGUAGE_KASHMIRI                               },
//STRIP001     { COUNTRY_PAKISTAN,             LANGUAGE_URDU_PAKISTAN                          },
//STRIP001     { COUNTRY_MYANMAR,              LANGUAGE_BURMESE                                },
//STRIP001     { COUNTRY_MOROCCO,              LANGUAGE_ARABIC_MOROCCO,                true    },
//STRIP001     { COUNTRY_ALGERIA,              LANGUAGE_ARABIC_ALGERIA,                true    },
//STRIP001     { COUNTRY_TUNISIA,              LANGUAGE_ARABIC_TUNISIA,                true    },
//STRIP001     { COUNTRY_LIBYA,                LANGUAGE_ARABIC_LIBYA,                  true    },
//STRIP001     { COUNTRY_SENEGAL,              LANGUAGE_FRENCH_SENEGAL,                true    },
//STRIP001     { COUNTRY_MALI,                 LANGUAGE_FRENCH_MALI,                   true    },
//STRIP001     { COUNTRY_COTE_D_IVOIRE,        LANGUAGE_FRENCH_COTE_D_IVOIRE,          true    },
//STRIP001     { COUNTRY_CAMEROON,             LANGUAGE_FRENCH_CAMEROON,               true    },
//STRIP001     { COUNTRY_ZAIRE,                LANGUAGE_FRENCH_ZAIRE,                  true    },
//STRIP001     { COUNTRY_RWANDA,               LANGUAGE_USER_KINYARWANDA                       },
//STRIP001     { COUNTRY_KENYA,                LANGUAGE_SWAHILI                                },
//STRIP001     { COUNTRY_REUNION,              LANGUAGE_FRENCH_REUNION,                true    },
//STRIP001     { COUNTRY_ZIMBABWE,             LANGUAGE_ENGLISH_ZIMBABWE,              true    },
//STRIP001     { COUNTRY_LESOTHO,              LANGUAGE_SESOTHO                                },
//STRIP001     { COUNTRY_BOTSWANA,             LANGUAGE_TSWANA                                 },
//STRIP001     { COUNTRY_FAEROE_ISLANDS,       LANGUAGE_FAEROESE                               },
//STRIP001     { COUNTRY_PORTUGAL,             LANGUAGE_PORTUGUESE                             },
//STRIP001     { COUNTRY_LUXEMBOURG,           LANGUAGE_GERMAN_LUXEMBOURG,             true    },
//STRIP001     { COUNTRY_LUXEMBOURG,           LANGUAGE_FRENCH_LUXEMBOURG,             true    },
//STRIP001     { COUNTRY_IRELAND,              LANGUAGE_ENGLISH_EIRE,                  true    },
//STRIP001     { COUNTRY_IRELAND,              LANGUAGE_GAELIC_IRELAND,                true    },
//STRIP001     { COUNTRY_ICELAND,              LANGUAGE_ICELANDIC                              },
//STRIP001     { COUNTRY_ALBANIA,              LANGUAGE_ALBANIAN                               },
//STRIP001     { COUNTRY_MALTA,                LANGUAGE_MALTESE                                },
//STRIP001     { COUNTRY_FINLAND,              LANGUAGE_FINNISH                                },
//STRIP001     { COUNTRY_FINLAND,              LANGUAGE_SWEDISH_FINLAND,               true    },
//STRIP001     { COUNTRY_BULGARIA,             LANGUAGE_BULGARIAN                              },
//STRIP001     { COUNTRY_LITHUANIA,            LANGUAGE_LITHUANIAN                             },
//STRIP001     { COUNTRY_LATVIA,               LANGUAGE_LATVIAN                                },
//STRIP001     { COUNTRY_ESTONIA,              LANGUAGE_ESTONIAN                               },
//STRIP001     { COUNTRY_MOLDOVA,              LANGUAGE_ROMANIAN_MOLDOVA,              true    },
//STRIP001     { COUNTRY_MOLDOVA,              LANGUAGE_RUSSIAN_MOLDOVA,               true    },
//STRIP001     { COUNTRY_ARMENIA,              LANGUAGE_ARMENIAN                               },
//STRIP001     { COUNTRY_BELARUS,              LANGUAGE_BELARUSIAN                             },
//STRIP001     { COUNTRY_MONACO,               LANGUAGE_FRENCH_MONACO,                 true    },
//STRIP001     { COUNTRY_UKRAINE,              LANGUAGE_UKRAINIAN                              },
//STRIP001     { COUNTRY_SERBIA,               LANGUAGE_SERBIAN_LATIN                          },
//STRIP001     { COUNTRY_CROATIA,              LANGUAGE_CROATIAN,                      true    },  // sub type of LANGUAGE_SERBIAN
//STRIP001     { COUNTRY_SLOVENIA,             LANGUAGE_SLOVENIAN                              },
//STRIP001     { COUNTRY_MACEDONIA,            LANGUAGE_MACEDONIAN                             },
//STRIP001     { COUNTRY_CZECH,                LANGUAGE_CZECH                                  },
//STRIP001     { COUNTRY_SLOVAK,               LANGUAGE_SLOVAK                                 },
//STRIP001     { COUNTRY_LIECHTENSTEIN,        LANGUAGE_GERMAN_LIECHTENSTEIN,          true    },
//STRIP001     { COUNTRY_BELIZE,               LANGUAGE_ENGLISH_BELIZE,                true    },
//STRIP001     { COUNTRY_GUATEMALA,            LANGUAGE_SPANISH_GUATEMALA,             true    },
//STRIP001     { COUNTRY_EL_SALVADOR,          LANGUAGE_SPANISH_EL_SALVADOR,           true    },
//STRIP001     { COUNTRY_HONDURAS,             LANGUAGE_SPANISH_HONDURAS,              true    },
//STRIP001     { COUNTRY_NICARAGUA,            LANGUAGE_SPANISH_NICARAGUA,             true    },
//STRIP001     { COUNTRY_COSTA_RICA,           LANGUAGE_SPANISH_COSTARICA,             true    },
//STRIP001     { COUNTRY_PANAMA,               LANGUAGE_SPANISH_PANAMA,                true    },
//STRIP001     { COUNTRY_BOLIVIA,              LANGUAGE_SPANISH_BOLIVIA,               true    },
//STRIP001     { COUNTRY_ECUADOR,              LANGUAGE_SPANISH_ECUADOR,               true    },
//STRIP001     { COUNTRY_PARAGUAY,             LANGUAGE_SPANISH_PARAGUAY,              true    },
//STRIP001     { COUNTRY_URUGUAY,              LANGUAGE_SPANISH_URUGUAY,               true    },
//STRIP001     { COUNTRY_BRUNEI_DARUSSALAM,    LANGUAGE_MALAY_BRUNEI_DARUSSALAM,       true    },
//STRIP001     { COUNTRY_HONG_KONG,            LANGUAGE_CHINESE_HONGKONG,              true    },
//STRIP001     { COUNTRY_MACAU,                LANGUAGE_CHINESE_MACAU,                 true    },
//STRIP001     { COUNTRY_CAMBODIA,             LANGUAGE_KHMER                                  },
//STRIP001     { COUNTRY_LAOS,                 LANGUAGE_LAO                                    },
//STRIP001     { COUNTRY_BANGLADESH,           LANGUAGE_BENGALI                                },
//STRIP001     { COUNTRY_TAIWAN,               LANGUAGE_CHINESE_TRADITIONAL,           true    },
//STRIP001     { COUNTRY_MALDIVES,             LANGUAGE_DHIVEHI                                },
//STRIP001     { COUNTRY_LEBANON,              LANGUAGE_ARABIC_LEBANON,                true    },
//STRIP001     { COUNTRY_JORDAN,               LANGUAGE_ARABIC_JORDAN,                 true    },
//STRIP001     { COUNTRY_SYRIA,                LANGUAGE_ARABIC_SYRIA,                  true    },
//STRIP001     { COUNTRY_IRAQ,                 LANGUAGE_ARABIC_IRAQ,                   true    },
//STRIP001     { COUNTRY_KUWAIT,               LANGUAGE_ARABIC_KUWAIT,                 true    },
//STRIP001     { COUNTRY_SAUDI_ARABIA,         LANGUAGE_ARABIC_SAUDI_ARABIA,           true    },
//STRIP001     { COUNTRY_YEMEN,                LANGUAGE_ARABIC_YEMEN,                  true    },
//STRIP001     { COUNTRY_OMAN,                 LANGUAGE_ARABIC_OMAN,                   true    },
//STRIP001     { COUNTRY_UAE,                  LANGUAGE_ARABIC_UAE,                    true    },
//STRIP001     { COUNTRY_ISRAEL,               LANGUAGE_HEBREW                                 },
//STRIP001     { COUNTRY_BAHRAIN,              LANGUAGE_ARABIC_BAHRAIN,                true    },
//STRIP001     { COUNTRY_QATAR,                LANGUAGE_ARABIC_QATAR,                  true    },
//STRIP001     { COUNTRY_MONGOLIA,             LANGUAGE_MONGOLIAN                              },
//STRIP001     { COUNTRY_NEPAL,                LANGUAGE_NEPALI                                 },
//STRIP001     { COUNTRY_IRAN,                 LANGUAGE_FARSI                                  },
//STRIP001     { COUNTRY_TAJIKISTAN,           LANGUAGE_TAJIK                                  },
//STRIP001     { COUNTRY_TURKMENISTAN,         LANGUAGE_TURKMEN                                },
//STRIP001     { COUNTRY_AZERBAIJAN,           LANGUAGE_AZERI_LATIN                            },
//STRIP001     { COUNTRY_GEORGIA,              LANGUAGE_GEORGIAN                               },
//STRIP001     { COUNTRY_KYRGYZSTAN,           LANGUAGE_KIRGHIZ                                },
//STRIP001     { COUNTRY_UZBEKISTAN,           LANGUAGE_UZBEK                                  }
//STRIP001 };
//STRIP001 
//STRIP001 const CountryEntry * const pEnd = pTable + sizeof( pTable ) / sizeof( pTable[ 0 ] );
//STRIP001 
//STRIP001 // ----------------------------------------------------------------------------
//STRIP001 
//STRIP001 /** Predicate comparing a country ID with the member of a CountryEntry. */
//STRIP001 struct CountryEntryPred_Country
//STRIP001 {
//STRIP001     CountryId                   meCountry;
//STRIP001 
//STRIP001     inline explicit             CountryEntryPred_Country( CountryId eCountry ) :
//STRIP001                                     meCountry( eCountry ) {}
//STRIP001 
//STRIP001     inline bool                 operator()( const CountryEntry& rCmp ) const
//STRIP001                                     { return rCmp.meCountry == meCountry; }
//STRIP001 };
//STRIP001 
//STRIP001 // ----------------------------------------------------------------------------
//STRIP001 
//STRIP001 /** Predicate comparing a language type with the member of a CountryEntry.
//STRIP001 
//STRIP001     Compares by primary language only, if the passed CountryEntry allows it
//STRIP001     (the member mbUseSubLang is cleared), otherwise by full language type. */
//STRIP001 struct CountryEntryPred_Language
//STRIP001 {
//STRIP001     LanguageType                meLanguage;
//STRIP001 
//STRIP001     inline explicit             CountryEntryPred_Language( LanguageType eLanguage ) :
//STRIP001                                     meLanguage( eLanguage ) {}
//STRIP001 
//STRIP001     inline bool                 operator()( const CountryEntry& rCmp ) const;
//STRIP001 };
//STRIP001 
//STRIP001 inline bool CountryEntryPred_Language::operator()( const CountryEntry& rCmp ) const
//STRIP001 {
//STRIP001     //  rCmp.mbUseSubLang==true  -> compare full language type
//STRIP001     //  rCmp.mbUseSubLang==false -> compare primary language only
//STRIP001     return rCmp.mbUseSubLang ? (meLanguage == rCmp.meLanguage) :
//STRIP001                 ((meLanguage & 0x03FF) == (rCmp.meLanguage & 0x03FF));
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------------------------------------------------------------------
//STRIP001 
//STRIP001 } // namespace
//STRIP001 
//STRIP001 // Country ID <-> Language type conversion ====================================
//STRIP001 
//STRIP001 CountryId ConvertLanguageToCountry( LanguageType eLanguage )
//STRIP001 {
//STRIP001     // country of a found primary language type
//STRIP001     CountryId ePrimCountry = COUNTRY_DONTKNOW;
//STRIP001 
//STRIP001     // find an exact match and a primary-language-only match, in one pass
//STRIP001     const CountryEntry* pEntry = pTable;
//STRIP001     do
//STRIP001     {
//STRIP001         pEntry = std::find_if( pEntry, pEnd, CountryEntryPred_Language( eLanguage ) );
//STRIP001         if( pEntry != pEnd )
//STRIP001         {
//STRIP001             if( pEntry->mbUseSubLang )
//STRIP001                 return pEntry->meCountry;       // exact match found -> return
//STRIP001             if( ePrimCountry == COUNTRY_DONTKNOW )
//STRIP001                 ePrimCountry = pEntry->meCountry;
//STRIP001             ++pEntry;   // one entry forward for next find_if() call
//STRIP001         }
//STRIP001     }
//STRIP001     while( pEntry != pEnd );
//STRIP001 
//STRIP001     return ePrimCountry;
//STRIP001 }
//STRIP001 
//STRIP001 LanguageType ConvertCountryToLanguage( CountryId eCountry )
//STRIP001 {
//STRIP001     // just find the first occurance of eCountry and return the language type
//STRIP001     const CountryEntry* pEntry = std::find_if( pTable, pEnd, CountryEntryPred_Country( eCountry ) );
//STRIP001     return (pEntry != pEnd) ? pEntry->meLanguage : LANGUAGE_DONTKNOW;
//STRIP001 }
//STRIP001 
//STRIP001 // ============================================================================
//STRIP001 
//STRIP001 } // namespace svx

// ============================================================================

}
