/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_edlingu.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 09:00:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _COMCORE_HRC
#include <comcore.hrc>
#endif
#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

// auto strip #ifndef _OFF_APP_HXX //autogen wg. OFF_APP
// auto strip #include <bf_offmgr/app.hxx>
// auto strip #endif
// auto strip #ifndef _LINGUISTIC_LNGPROPS_HHX_
// auto strip #include <bf_linguistic/lngprops.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _UNO_LINGU_HXX
// auto strip #include <bf_svx/unolingu.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_LANGITEM_HXX //autogen
// auto strip #include <bf_svx/langitem.hxx>
// auto strip #endif

// auto strip #ifndef _FMTHBSH_HXX //autogen
// auto strip #include <fmthbsh.hxx>
// auto strip #endif
// auto strip #ifndef _CHARATR_HXX
// auto strip #include <charatr.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _EDITSH_HXX
// auto strip #include <editsh.hxx>
// auto strip #endif
// auto strip #ifndef _DOC_HXX
// auto strip #include <doc.hxx>
// auto strip #endif
#ifndef _ROOTFRM_HXX
#include <rootfrm.hxx>      // SwRootFrm
#endif
// auto strip #ifndef _PAM_HXX
// auto strip #include <pam.hxx>
// auto strip #endif
// auto strip #ifndef _SWUNDO_HXX
// auto strip #include <swundo.hxx>		// fuer die UndoIds
// auto strip #endif
// auto strip #ifndef _NDTXT_HXX
// auto strip #include <ndtxt.hxx>        // AdjHyphPos
// auto strip #endif
// auto strip #ifndef _VIEWOPT_HXX
// auto strip #include <viewopt.hxx>      // HyphStart/End
// auto strip #endif
// auto strip #ifndef _VISCRS_HXX
// auto strip #include <viscrs.hxx>		// SwShellCrsr
// auto strip #endif
// auto strip #ifndef _WRONG_HXX
// auto strip #include <wrong.hxx>		// SwWrongList
// auto strip #endif
// auto strip #ifndef _SWCRSR_HXX
// auto strip #include <swcrsr.hxx>		// SwCursor
// auto strip #endif
// auto strip #ifndef _MDIEXP_HXX
// auto strip #include <mdiexp.hxx>		// Statusanzeige
// auto strip #endif
#ifndef _STATSTR_HRC
#include <statstr.hrc>      // StatLine-String
#endif

#ifdef LINGU_STATISTIK
// auto strip #include <txtfrm.hxx>		// SwLinguStat.Flush()
#endif
namespace binfilter {

#ifndef S2U
#define S2U(rString) ::rtl::OUString::createFromAscii(rString)
#endif

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::linguistic2;

/*************************************************************************
 *					   class SwLinguIter
 *************************************************************************/

//STRIP001 class SwLinguIter
//STRIP001 {
//STRIP001 	SwEditShell *pSh;
//STRIP001 	SwPosition	*pStart;
//STRIP001 	SwPosition	*pEnd;
//STRIP001 	SwPosition	*pCurr;
//STRIP001 	SwPosition	*pCurrX;
//STRIP001 	sal_uInt16 nCrsrCnt;
//STRIP001 public:
//STRIP001 	SwLinguIter();
//STRIP001 
//STRIP001 	inline SwEditShell *GetSh() 			{ return pSh; }
//STRIP001 	inline const SwEditShell *GetSh() const { return pSh; }
//STRIP001 
//STRIP001 	inline const SwPosition *GetEnd() const { return pEnd; }
//STRIP001 	inline void SetEnd( SwPosition* pNew ){ delete pEnd; pEnd = pNew; }
//STRIP001 
//STRIP001 	inline const SwPosition *GetStart() const { return pStart; }
//STRIP001 	inline void SetStart( SwPosition* pNew ){ delete pStart; pStart = pNew; }
//STRIP001 
//STRIP001 	inline const SwPosition *GetCurr() const { return pCurr; }
//STRIP001 	inline void SetCurr( SwPosition* pNew ){ delete pCurr; pCurr = pNew; }
//STRIP001 
//STRIP001 	inline const SwPosition *GetCurrX() const { return pCurrX; }
//STRIP001 	inline void SetCurrX( SwPosition* pNew ){ delete pCurrX; pCurrX = pNew; }
//STRIP001 
//STRIP001 	inline sal_uInt16& GetCrsrCnt(){ return nCrsrCnt; }
//STRIP001 
//STRIP001 	// Der UI-Bauchladen:
//STRIP001 	void _Start( SwEditShell *pSh, SwDocPositions eStart,
//STRIP001 				SwDocPositions eEnd, sal_Bool bRev = sal_False );
//STRIP001 	void _End();
//STRIP001 };

/*************************************************************************
 *					   class SwSpellIter
 *************************************************************************/

//STRIP001 class SwSpellIter : public SwLinguIter
//STRIP001 {
//STRIP001 	uno::Reference< XSpellChecker1 > 	xSpeller;
//STRIP001 public:
//STRIP001 	SwSpellIter() {}
//STRIP001 
//STRIP001 	void Start( SwEditShell *pSh, SwDocPositions eStart, SwDocPositions eEnd );
//STRIP001 
 //STRIP001    uno::Any    Continue( sal_uInt16* pPageCnt, sal_uInt16* pPageSt );
//STRIP001 };

/*************************************************************************
 *                     class SwConvIter
 * used for text conversion
 *************************************************************************/

//STRIP001 class SwConvIter : public SwLinguIter
//STRIP001 {
//STRIP001 public:
//STRIP001     SwConvIter() {}
//STRIP001 
//STRIP001     void Start( SwEditShell *pSh, SwDocPositions eStart, SwDocPositions eEnd );
//STRIP001 
//STRIP001     uno::Any    Continue( sal_uInt16* pPageCnt, sal_uInt16* pPageSt );
//STRIP001 };

/*************************************************************************
 *					   class SwHyphIter
 *************************************************************************/

//STRIP001 class SwHyphIter : public SwLinguIter
//STRIP001 {
//STRIP001 	sal_Bool bOldIdle;
//STRIP001 	void DelSoftHyph( SwPaM &rPam );
//STRIP001 
//STRIP001 public:
//STRIP001 	SwHyphIter() : bOldIdle(sal_False) {}
//STRIP001 
//STRIP001 	void Start( SwEditShell *pSh, SwDocPositions eStart, SwDocPositions eEnd );
//STRIP001 	void End();
//STRIP001 
//STRIP001 	void Ignore();
//STRIP001 
//STRIP001     uno::Any    Continue( sal_uInt16* pPageCnt, sal_uInt16* pPageSt );
//STRIP001 
//STRIP001 	sal_Bool IsAuto();
//STRIP001 	void InsertSoftHyph( const xub_StrLen nHyphPos );
//STRIP001 	void ShowSelection();
//STRIP001 };

//STRIP001 static SwSpellIter*	pSpellIter = 0;
//STRIP001 static SwConvIter*  pConvIter = 0;
//STRIP001 static SwHyphIter*	pHyphIter = 0;

// Wir ersparen uns in Hyphenate ein GetFrm()
// Achtung: in txtedt.cxx stehen extern-Deklarationen auf diese Pointer!
//STRIP001 const SwTxtNode *pLinguNode;
//STRIP001 	  SwTxtFrm  *pLinguFrm;

/*************************************************************************
 *						SwLinguIter::SwLinguIter
 *************************************************************************/

//STRIP001 SwLinguIter::SwLinguIter()
//STRIP001 	: pSh( 0 ), pStart( 0 ), pEnd( 0 ), pCurr( 0 ), pCurrX( 0 )
//STRIP001 {
//STRIP001 	// @@@ es fehlt: Sicherstellen der Reentrance, ASSERTs etc.
//STRIP001 }

/*************************************************************************
 *						SwLinguIter::Start
 *************************************************************************/



//STRIP001 void SwLinguIter::_Start( SwEditShell *pShell, SwDocPositions eStart,
//STRIP001 							SwDocPositions eEnd, sal_Bool bRev )
//STRIP001 {
//STRIP001 	// es fehlt: Sicherstellen der Reentrance, Locking
//STRIP001 	if( pSh )
//STRIP001 		return;
//STRIP001 
//STRIP001 	sal_Bool bSetCurr;
//STRIP001 
//STRIP001 	pSh = pShell;
//STRIP001 
//STRIP001 	SET_CURR_SHELL( pSh );
//STRIP001 
//STRIP001 	ASSERT( !pEnd, "LinguStart ohne End?");
//STRIP001 
//STRIP001 	SwPaM *pCrsr = pSh->GetCrsr();
//STRIP001 
//STRIP001 	// pStk->SetCurCrsr();
//STRIP001 //	if( pCrsr->HasMark() || pCrsr != pCrsr->GetNext() )
//STRIP001 	if( pShell->HasSelection() || pCrsr != pCrsr->GetNext() )
//STRIP001 	{
//STRIP001 		bSetCurr = 0 != GetCurr();
//STRIP001 		nCrsrCnt = pSh->GetCrsrCnt();
//STRIP001 		if( pSh->IsTableMode() )
//STRIP001 			pSh->TblCrsrToCursor();
//STRIP001 
//STRIP001 		pSh->Push();
//STRIP001 		sal_uInt16 n;
//STRIP001 		for( n = 0; n < nCrsrCnt; ++n )
//STRIP001 		{
//STRIP001 			pSh->Push();
//STRIP001 			pSh->DestroyCrsr();
//STRIP001 		}
//STRIP001 		pSh->Pop( sal_False );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bSetCurr = sal_False;
//STRIP001 		nCrsrCnt = 1;
//STRIP001 		pSh->Push();
//STRIP001 		pSh->SetLinguRange( eStart, eEnd );
//STRIP001 	}
//STRIP001 
//STRIP001 	pCrsr = pSh->GetCrsr();
//STRIP001 	if ( *pCrsr->GetPoint() > *pCrsr->GetMark() )
//STRIP001 		pCrsr->Exchange();
//STRIP001 
//STRIP001 	pStart = new SwPosition( *pCrsr->GetPoint() );
//STRIP001 	pEnd = new SwPosition( *pCrsr->GetMark() );
//STRIP001 	if( bSetCurr )
//STRIP001 	{
//STRIP001 		SwPosition* pNew = new SwPosition( bRev ? *GetEnd() : *GetStart() );
//STRIP001 		SetCurr( pNew );
//STRIP001 		pNew = new SwPosition( *pNew );
//STRIP001 		SetCurrX( pNew );
//STRIP001 	}
//STRIP001 
//STRIP001 	pCrsr->SetMark();
//STRIP001 
//STRIP001 	pLinguFrm = 0;
//STRIP001 	pLinguNode = 0;
//STRIP001 }

/*************************************************************************
 *						SwLinguIter::End
 *************************************************************************/



//STRIP001 void SwLinguIter::_End()
//STRIP001 {
//STRIP001 	if( !pSh )
//STRIP001 		return;
//STRIP001 
//STRIP001 	ASSERT( pEnd, "SwEditShell::SpellEnd() ohne Start?");
//STRIP001 	while( nCrsrCnt-- )
//STRIP001 		pSh->Pop( sal_False );
//STRIP001 
//STRIP001 	pSh->KillPams();
//STRIP001 	pSh->ClearMark();
//STRIP001 	DELETEZ(pStart);
//STRIP001 	DELETEZ(pEnd);
//STRIP001 	DELETEZ(pCurr);
//STRIP001 	DELETEZ(pCurrX);
//STRIP001 
//STRIP001 	pSh = 0;
//STRIP001 
//STRIP001 #ifdef LINGU_STATISTIK
//STRIP001 	aSwLinguStat.Flush();
//STRIP001 #endif
//STRIP001 }

/*************************************************************************
 *				 virtual SwSpellIter::Start()
 *************************************************************************/



//STRIP001 void SwSpellIter::Start( SwEditShell *pShell, SwDocPositions eStart,
//STRIP001 						SwDocPositions eEnd )
//STRIP001 {
//STRIP001 	if( GetSh() )
//STRIP001 		return;
//STRIP001 
//STRIP001  	uno::Reference< beans::XPropertySet >  xProp( ::GetLinguPropertySet() );
//STRIP001 	sal_Bool bIsWrapReverse = xProp.is()
//STRIP001 				? *(sal_Bool*)xProp->getPropertyValue(
//STRIP001 									S2U(UPN_IS_WRAP_REVERSE) ).getValue()
//STRIP001 				: sal_False;
//STRIP001 
//STRIP001 	xSpeller = ::GetSpellChecker();
//STRIP001 	if ( xSpeller.is() )
//STRIP001 		_Start( pShell, eStart, eEnd, bIsWrapReverse );
//STRIP001 }

/*************************************************************************
 *					 SwSpellIter::Continue
 *************************************************************************/

// SwSpellIter::Continue ist das alte Original von
// SwEditShell::SpellContinue()

//STRIP001 uno::Any SwSpellIter::Continue( sal_uInt16* pPageCnt, sal_uInt16* pPageSt )
//STRIP001 {
//STRIP001     //!!
//STRIP001     //!! Please check SwConvIter also when modifying this
//STRIP001     //!!
//STRIP001     
//STRIP001     uno::Any    aSpellRet;
//STRIP001 	SwEditShell *pSh = GetSh();
//STRIP001 	if( !pSh )
//STRIP001         return aSpellRet;
//STRIP001 
//STRIP001 //	const SwPosition *pEnd = GetEnd();
//STRIP001 
//STRIP001 	ASSERT( GetEnd(), "SwEditShell::SpellContinue() ohne Start?");
//STRIP001 
//STRIP001     uno::Reference< uno::XInterface >  xSpellRet;
//STRIP001 	sal_Bool bGoOn = sal_True;
//STRIP001 	do {
//STRIP001 		SwPaM *pCrsr = pSh->GetCrsr();
//STRIP001 		if ( !pCrsr->HasMark() )
//STRIP001 			pCrsr->SetMark();
//STRIP001 
//STRIP001 		uno::Reference< beans::XPropertySet >  xProp( GetLinguPropertySet() );
//STRIP001 		sal_Bool bRev = xProp.is() ?
//STRIP001 			*(sal_Bool*)xProp->getPropertyValue( S2U(UPN_IS_WRAP_REVERSE) ).getValue() : sal_False;
//STRIP001 		if( bRev )
//STRIP001 		{
//STRIP001 			*pSh->GetCrsr()->GetPoint() = *GetCurrX();
//STRIP001 			*pSh->GetCrsr()->GetMark() = *GetStart();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			*pSh->GetCrsr()->GetPoint() = *GetCurr();
//STRIP001 			*pSh->GetCrsr()->GetMark() = *GetEnd();
//STRIP001 		}
//STRIP001         pSh->GetDoc()->Spell(*pSh->GetCrsr(),
//STRIP001                     xSpeller, pPageCnt, pPageSt ) >>= xSpellRet;
//STRIP001 		bGoOn = GetCrsrCnt() > 1;
//STRIP001 		if( xSpellRet.is() )
//STRIP001 		{
//STRIP001 			bGoOn = sal_False;
//STRIP001 			SwPosition* pNewPoint = new SwPosition( *pCrsr->GetPoint() );
//STRIP001 			SwPosition* pNewMark = new SwPosition( *pCrsr->GetMark() );
//STRIP001 			if( bRev )
//STRIP001 			{
//STRIP001 				SetCurr( pNewMark );
//STRIP001 				// Noch steht der sdbcx::Index zwar am Anfang des falschen Wortes,
//STRIP001 				// wenn dies ersetzt wird (Delete,Insert), ist der sdbcx::Index
//STRIP001 				// hinter diesem und das Wort wird erneut geprueft (51308)
//STRIP001 				if( pNewPoint->nContent.GetIndex() )
//STRIP001 					--pNewPoint->nContent;
//STRIP001 				SetCurrX( pNewPoint );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				SetCurr( pNewPoint );
//STRIP001 				SetCurrX( pNewMark );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if( bGoOn )
//STRIP001 		{
//STRIP001 			pSh->Pop( sal_False );
//STRIP001 			pCrsr = pSh->GetCrsr();
//STRIP001 			if ( *pCrsr->GetPoint() > *pCrsr->GetMark() )
//STRIP001 				pCrsr->Exchange();
//STRIP001 			SwPosition* pNew = new SwPosition( *pCrsr->GetPoint() );
//STRIP001 			SetStart( pNew );
//STRIP001 			pNew = new SwPosition( *pCrsr->GetMark() );
//STRIP001 			SetEnd( pNew );
//STRIP001 			pNew = new SwPosition( bRev ? *GetEnd() : *GetStart() );
//STRIP001 			SetCurr( pNew );
//STRIP001 			pNew = new SwPosition( *pNew );
//STRIP001 			SetCurrX( pNew );
//STRIP001 			pCrsr->SetMark();
//STRIP001 			--GetCrsrCnt();
//STRIP001 		}
//STRIP001 	}while ( bGoOn );
//STRIP001     aSpellRet <<= xSpellRet;
//STRIP001     return aSpellRet;
//STRIP001 }

/*************************************************************************
 *               virtual SwConvIter::Start()
 *************************************************************************/



//STRIP001 void SwConvIter::Start( SwEditShell *pShell, SwDocPositions eStart,
//STRIP001                         SwDocPositions eEnd )
//STRIP001 {
//STRIP001     if( GetSh() )
//STRIP001         return;
//STRIP001     _Start( pShell, eStart, eEnd, FALSE );
//STRIP001 }

/*************************************************************************
 *                   SwConvIter::Continue
 *************************************************************************/

//STRIP001 uno::Any SwConvIter::Continue( sal_uInt16* pPageCnt, sal_uInt16* pPageSt )
//STRIP001 {
//STRIP001     //!!
//STRIP001     //!! Please check SwSpellIter also when modifying this
//STRIP001     //!!
//STRIP001 
//STRIP001     uno::Any    aConvRet( makeAny( ::rtl::OUString() ) );
//STRIP001     SwEditShell *pSh = GetSh();
//STRIP001     if( !pSh )
//STRIP001         return aConvRet;
//STRIP001 
//STRIP001 //  const SwPosition *pEnd = GetEnd();
//STRIP001 
//STRIP001     ASSERT( GetEnd(), "SwConvIter::Continue() ohne Start?");
//STRIP001 
//STRIP001     ::rtl::OUString aConvText;
//STRIP001     sal_Bool bGoOn = sal_True;
//STRIP001     do {
//STRIP001         SwPaM *pCrsr = pSh->GetCrsr();
//STRIP001         if ( !pCrsr->HasMark() )
//STRIP001             pCrsr->SetMark();
//STRIP001 
//STRIP001         *pSh->GetCrsr()->GetPoint() = *GetCurr();
//STRIP001         *pSh->GetCrsr()->GetMark() = *GetEnd();
//STRIP001         
//STRIP001         // call function to find next text portion to be converted
//STRIP001         uno::Reference< linguistic2::XSpellChecker1 > xEmpty;
//STRIP001         pSh->GetDoc()->Spell( *pSh->GetCrsr(), 
//STRIP001                     xEmpty, pPageCnt, pPageSt, sal_True ) >>= aConvText;
//STRIP001 
//STRIP001         bGoOn = GetCrsrCnt() > 1;
//STRIP001         if( aConvText.getLength() )
//STRIP001         {
//STRIP001             bGoOn = sal_False;
//STRIP001             SwPosition* pNewPoint = new SwPosition( *pCrsr->GetPoint() );
//STRIP001             SwPosition* pNewMark = new SwPosition( *pCrsr->GetMark() );
//STRIP001 
//STRIP001             SetCurr( pNewPoint );
//STRIP001             SetCurrX( pNewMark );
//STRIP001         }
//STRIP001         if( bGoOn )
//STRIP001         {
//STRIP001             pSh->Pop( sal_False );
//STRIP001             pCrsr = pSh->GetCrsr();
//STRIP001             if ( *pCrsr->GetPoint() > *pCrsr->GetMark() )
//STRIP001                 pCrsr->Exchange();
//STRIP001             SwPosition* pNew = new SwPosition( *pCrsr->GetPoint() );
//STRIP001             SetStart( pNew );
//STRIP001             pNew = new SwPosition( *pCrsr->GetMark() );
//STRIP001             SetEnd( pNew );
//STRIP001             pNew = new SwPosition( *GetStart() );
//STRIP001             SetCurr( pNew );
//STRIP001             pNew = new SwPosition( *pNew );
//STRIP001             SetCurrX( pNew );
//STRIP001             pCrsr->SetMark();
//STRIP001             --GetCrsrCnt();
//STRIP001         }
//STRIP001     }while ( bGoOn );
//STRIP001     return makeAny( aConvText );
//STRIP001 }


/*************************************************************************
 *                   SwHyphIter
 *************************************************************************/


//STRIP001 sal_Bool SwHyphIter::IsAuto()
//STRIP001 {
//STRIP001 	uno::Reference< beans::XPropertySet >  xProp( ::GetLinguPropertySet() );
//STRIP001 	return xProp.is() ? *(sal_Bool*)xProp->getPropertyValue(
//STRIP001 								S2U(UPN_IS_HYPH_AUTO) ).getValue()
//STRIP001 					  : sal_False;
//STRIP001 }


//STRIP001 void SwHyphIter::ShowSelection()
//STRIP001 {
//STRIP001 	SwEditShell *pSh = GetSh();
//STRIP001 	if( pSh )
//STRIP001 	{
//STRIP001 		pSh->StartAction();
//STRIP001 		// Ganz fatal: durch das EndAction() werden Formatierungen
//STRIP001 		// angeregt, die dazu fuehren koennen, dass im Hyphenator
//STRIP001 		// neue Worte eingestellt werden. Deswegen sichern!
//STRIP001 		pSh->EndAction();
//STRIP001 	}
//STRIP001 }

/*************************************************************************
 *				 virtual SwHyphIter::Start()
 *************************************************************************/



//STRIP001 void SwHyphIter::Start( SwEditShell *pShell, SwDocPositions eStart, SwDocPositions eEnd )
//STRIP001 {
//STRIP001 	// robust
//STRIP001 	if( GetSh() || GetEnd() )
//STRIP001 	{
//STRIP001 		ASSERT( !GetSh(), "+SwEditShell::HyphStart: missing HyphEnd()" );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 // nothing to be done (at least not in the way as in the "else" part)
//STRIP001 	bOldIdle = pShell->GetViewOptions()->IsIdle();
//STRIP001 	((SwViewOption*)pShell->GetViewOptions())->SetIdle( sal_False );
//STRIP001 	_Start( pShell, eStart, eEnd );
//STRIP001 }

/*************************************************************************
 *				   virtual SwHyphIter::End
 *************************************************************************/

// Selektionen wiederherstellen



//STRIP001 void SwHyphIter::End()
//STRIP001 {
//STRIP001 	if( !GetSh() )
//STRIP001 		return;
//STRIP001 	((SwViewOption*)GetSh()->GetViewOptions())->SetIdle( bOldIdle );
//STRIP001 	_End();
//STRIP001 }

/*************************************************************************
 *					 SwHyphIter::Continue
 *************************************************************************/

//STRIP001 uno::Any SwHyphIter::Continue( sal_uInt16* pPageCnt, sal_uInt16* pPageSt )
//STRIP001 {
//STRIP001     uno::Any    aHyphRet;
//STRIP001 	SwEditShell *pSh = GetSh();
//STRIP001 	if( !pSh )
//STRIP001         return aHyphRet;
//STRIP001 
//STRIP001 	const sal_Bool bAuto = IsAuto();
//STRIP001 	 uno::Reference< XHyphenatedWord >  xHyphWord;
//STRIP001 	sal_uInt16 nRet;
//STRIP001 	sal_Bool bGoOn = sal_False;
//STRIP001 	do {
//STRIP001 		SwPaM *pCrsr;
//STRIP001 		do {
//STRIP001 			ASSERT( GetEnd(), "SwEditShell::SpellContinue() ohne Start?" );
//STRIP001 			pCrsr = pSh->GetCrsr();
//STRIP001 			if ( !pCrsr->HasMark() )
//STRIP001 				pCrsr->SetMark();
//STRIP001 			if ( *pCrsr->GetPoint() < *pCrsr->GetMark() )
//STRIP001 			{
//STRIP001 				pCrsr->Exchange();
//STRIP001 				pCrsr->SetMark();
//STRIP001 			}
//STRIP001 
//STRIP001 			// geraten BUG:
//STRIP001 			if ( *pCrsr->End() > *GetEnd() )
//STRIP001 				nRet = 0;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				*pCrsr->GetMark() = *GetEnd();
//STRIP001 
//STRIP001 				// Muss an der aktuellen Cursorpos das Wort getrennt werden ?
//STRIP001 				const Point aCrsrPos( pSh->GetCharRect().Pos() );
//STRIP001 				xHyphWord = pSh->GetDoc()->Hyphenate( pCrsr, aCrsrPos,
//STRIP001 						 							  pPageCnt, pPageSt );
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bAuto && xHyphWord.is() )
//STRIP001 			{
//STRIP001 				pSh->InsertSoftHyph( xHyphWord->getHyphenationPos() + 1);
//STRIP001 			}
//STRIP001 		} while( bAuto && xHyphWord.is() );	//end of do-while
//STRIP001 		bGoOn = !xHyphWord.is() && GetCrsrCnt() > 1;
//STRIP001 
//STRIP001 		if( bGoOn )
//STRIP001 		{
//STRIP001 			pSh->Pop( sal_False );
//STRIP001 			pCrsr = pSh->GetCrsr();
//STRIP001 			if ( *pCrsr->GetPoint() > *pCrsr->GetMark() )
//STRIP001 				pCrsr->Exchange();
//STRIP001 			SwPosition* pNew = new SwPosition(*pCrsr->End());
//STRIP001 			SetEnd( pNew );
//STRIP001 			pCrsr->SetMark();
//STRIP001 			--GetCrsrCnt();
//STRIP001 		}
//STRIP001 	} while ( bGoOn );
//STRIP001     aHyphRet <<= xHyphWord;
//STRIP001     return aHyphRet;
//STRIP001 }

/*************************************************************************
 *					SwHyphIter::HyphIgnore
 *************************************************************************/

// Beschreibung: Trennstelle ignorieren

//STRIP001 void SwHyphIter::Ignore()
//STRIP001 {
//STRIP001 	SwEditShell *pSh = GetSh();
//STRIP001 	SwPaM *pCrsr = pSh->GetCrsr();
//STRIP001 
//STRIP001 	// Alten SoftHyphen loeschen
//STRIP001 	DelSoftHyph( *pCrsr );
//STRIP001 
//STRIP001 	// und weiter
//STRIP001 	pCrsr->Start()->nContent = pCrsr->End()->nContent;
//STRIP001 	pCrsr->SetMark();
//STRIP001 }

/*************************************************************************
 *						  SwHyphIter::DelSoftHyph
 *************************************************************************/

//STRIP001 void SwHyphIter::DelSoftHyph( SwPaM &rPam )
//STRIP001 {
//STRIP001 	const SwPosition* pStt = rPam.Start();
//STRIP001 	const xub_StrLen nStart = pStt->nContent.GetIndex();
//STRIP001 	const xub_StrLen nEnd   = rPam.End()->nContent.GetIndex();
//STRIP001 	SwTxtNode *pNode = pStt->nNode.GetNode().GetTxtNode();
//STRIP001 	pNode->DelSoftHyph( nStart, nEnd );
//STRIP001 }

/*************************************************************************
 *					SwHyphIter::InsertSoftHyph
 *************************************************************************/


//STRIP001 void SwHyphIter::InsertSoftHyph( const xub_StrLen nHyphPos )
//STRIP001 {
//STRIP001 	SwEditShell *pSh = GetSh();
//STRIP001 	ASSERT( pSh,  "+SwEditShell::InsertSoftHyph: missing HyphStart()");
//STRIP001 	if( !pSh )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SwPaM *pCrsr = pSh->GetCrsr();
//STRIP001 	SwPosition *pStt = pCrsr->Start(), *pEnd = pCrsr->End();
//STRIP001 
//STRIP001 	xub_StrLen nLastHyphLen = GetEnd()->nContent.GetIndex() -
//STRIP001 						  pStt->nContent.GetIndex();
//STRIP001 
//STRIP001 	if( pStt->nNode != pEnd->nNode || !nLastHyphLen )
//STRIP001 	{
//STRIP001 		ASSERT( pStt->nNode == pEnd->nNode,
//STRIP001 				"+SwEditShell::InsertSoftHyph: node warp during hyphenation" );
//STRIP001 		ASSERT(nLastHyphLen, "+SwEditShell::InsertSoftHyph: missing HyphContinue()");
//STRIP001 		*pStt = *pEnd;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	pSh->StartAction();
//STRIP001 	{
//STRIP001 		SwDoc *pDoc = pSh->GetDoc();
//STRIP001 		DelSoftHyph( *pCrsr );
//STRIP001 		pStt->nContent += nHyphPos;
//STRIP001 		SwPaM aRg( *pStt );
//STRIP001 		pDoc->Insert( aRg, CHAR_SOFTHYPHEN );
//STRIP001 		// Durch das Einfuegen des SoftHyphs ist ein Zeichen hinzugekommen
//STRIP001 //JP 18.07.95: warum, ist doch ein SwIndex, dieser wird doch mitverschoben !!
//STRIP001 //        pStt->nContent++;
//STRIP001 	}
//STRIP001 	// Die Selektion wird wieder aufgehoben
//STRIP001 	pCrsr->DeleteMark();
//STRIP001 	pSh->EndAction();
//STRIP001 	pCrsr->SetMark();
//STRIP001 }

// --------------------- Methoden der SwEditShell ------------------------

/*************************************************************************
 *                      SwEditShell::HasSpellIter
 *************************************************************************/

//STRIP001 BOOL SwEditShell::HasSpellIter() const
//STRIP001 {
//STRIP001 	return 0 != pSpellIter;
//STRIP001 }

/*************************************************************************
 *                      SwEditShell::HasConvIter
 *************************************************************************/

//STRIP001 BOOL SwEditShell::HasConvIter() const
//STRIP001 {
//STRIP001     return 0 != pConvIter;
//STRIP001 }

/*************************************************************************
 *                      SwEditShell::HasHyphIter
 *************************************************************************/

//STRIP001 BOOL SwEditShell::HasHyphIter() const
//STRIP001 {
//STRIP001 	return 0 != pHyphIter;
//STRIP001 }

/*************************************************************************
 *                      SwEditShell::SetFindRange
 *************************************************************************/

//STRIP001 void SwEditShell::SetLinguRange( SwDocPositions eStart, SwDocPositions eEnd )
//STRIP001 {
//STRIP001 	SwPaM *pCrsr = GetCrsr();
//STRIP001 	MakeFindRange( eStart, eEnd, pCrsr );
//STRIP001 	if( *pCrsr->GetPoint() > *pCrsr->GetMark() )
//STRIP001 		pCrsr->Exchange();
//STRIP001 }

/*************************************************************************
 *                  SwEditShell::SpellStart
 *************************************************************************/

// Selektionen sichern
//STRIP001 void SwEditShell::SpellStart( 
//STRIP001         SwDocPositions eStart, SwDocPositions eEnd, SwDocPositions eCurr, 
//STRIP001         sal_Bool bIsConversion )
//STRIP001 {
//STRIP001     SwLinguIter *pLinguIter = 0;
//STRIP001 
//STRIP001 	// do not spell if interactive spelling is active elsewhere
//STRIP001     if (!bIsConversion && !pSpellIter)
//STRIP001 	{
//STRIP001 		ASSERT( !pSpellIter, "wer ist da schon am spellen?" );
//STRIP001 		pSpellIter = new SwSpellIter;
//STRIP001         pLinguIter = pSpellIter;
//STRIP001 	}
//STRIP001     // do not do text conversion if it is active elsewhere
//STRIP001     if (bIsConversion && !pConvIter)
//STRIP001     {
//STRIP001         ASSERT( !pConvIter, "text conversion already active!" );
//STRIP001         pConvIter = new SwConvIter;
//STRIP001         pLinguIter = pConvIter;
//STRIP001     }
//STRIP001 
//STRIP001     if (pLinguIter)
//STRIP001     {
//STRIP001         SwCursor* pSwCrsr = GetSwCrsr();
//STRIP001 
//STRIP001         SwPosition *pTmp = new SwPosition( *pSwCrsr->GetPoint() );
//STRIP001         pSwCrsr->FillFindPos( eCurr, *pTmp );
//STRIP001         pLinguIter->SetCurr( pTmp );
//STRIP001 
//STRIP001         pTmp = new SwPosition( *pTmp );
//STRIP001         pLinguIter->SetCurrX( pTmp );
//STRIP001     }
//STRIP001 
//STRIP001     if (!bIsConversion && pSpellIter)
//STRIP001         pSpellIter->Start( this, eStart, eEnd );
//STRIP001     if (bIsConversion && pConvIter)
//STRIP001         pConvIter->Start( this, eStart, eEnd );
//STRIP001 }

/*************************************************************************
 *                  SwEditShell::SpellEnd
 *************************************************************************/

// Selektionen wiederherstellen
//STRIP001 void SwEditShell::SpellEnd( sal_Bool bIsConversion )
//STRIP001 {
//STRIP001     if (!bIsConversion && pSpellIter->GetSh() == this)
//STRIP001 	{
//STRIP001 		ASSERT( pSpellIter, "wo ist mein Iterator?" );
//STRIP001 		pSpellIter->_End();
//STRIP001 		delete pSpellIter, pSpellIter = 0;
//STRIP001 	}
//STRIP001     if (bIsConversion && pConvIter && pConvIter->GetSh() == this)
//STRIP001     {
//STRIP001         ASSERT( pConvIter, "wo ist mein Iterator?" );
//STRIP001         pConvIter->_End();
//STRIP001         delete pConvIter, pConvIter = 0;
//STRIP001     }
//STRIP001 }

/*************************************************************************
 *                  SwEditShell::SpellContinue
 *************************************************************************/

// liefert Rueckgabewerte entsprechend SPL_ in splchk.hxx

//STRIP001 uno::Any SwEditShell::SpellContinue( 
//STRIP001         sal_uInt16* pPageCnt, sal_uInt16* pPageSt,
//STRIP001         sal_Bool bIsConversion )
//STRIP001 {
//STRIP001     uno::Any aRes;
//STRIP001     
//STRIP001     if ((!bIsConversion && pSpellIter->GetSh() != this) ||
//STRIP001         ( bIsConversion && pConvIter->GetSh() != this))
//STRIP001         return aRes;
//STRIP001 
//STRIP001 	if( pPageCnt && !*pPageCnt )
//STRIP001 	{
//STRIP001 		sal_uInt16 nEndPage = GetLayout()->GetPageNum();
//STRIP001 		nEndPage += nEndPage * 10 / 100;
//STRIP001 		*pPageCnt = nEndPage;
//STRIP001 		if( nEndPage )
//STRIP001 			::StartProgress( STR_STATSTR_SPELL, 0, nEndPage, GetDoc()->GetDocShell() );
//STRIP001 	}
//STRIP001 
//STRIP001     ASSERT(  bIsConversion || pSpellIter, "SpellIter missing" );
//STRIP001     ASSERT( !bIsConversion || pConvIter,  "ConvIter missing" );
//STRIP001 	//JP 18.07.95: verhinder bei Fehlermeldungen die Anzeige der Selektionen
//STRIP001 	//				KEIN StartAction, da damit auch die Paints abgeschaltet
//STRIP001 	//				werden !!!!!
//STRIP001 	++nStartAction;
//STRIP001     ::rtl::OUString aRet; 
//STRIP001     uno::Reference< uno::XInterface >  xRet;
//STRIP001     if (bIsConversion)
//STRIP001     {
//STRIP001         pConvIter->Continue( pPageCnt, pPageSt ) >>= aRet;
//STRIP001         aRes <<= aRet;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         pSpellIter->Continue( pPageCnt, pPageSt ) >>= xRet;
//STRIP001         aRes <<= xRet;
//STRIP001     }
//STRIP001 	--nStartAction;
//STRIP001 
//STRIP001     if( aRet.getLength() || xRet.is() )
//STRIP001 	{
//STRIP001 		// dann die awt::Selection sichtbar machen
//STRIP001 		StartAction();
//STRIP001 		EndAction();
//STRIP001 	}
//STRIP001     return aRes;
//STRIP001 }

/*************************************************************************
 *					SwEditShell::HyphStart
 *************************************************************************/

/* Interaktive Trennung, BP 10.03.93
 *
 * 1) HyphStart
 *    - Aufheben aller Selektionen
 *    - Sichern des aktuellen Cursors
 *	  - falls keine Selektion vorhanden:
 *		- neue Selektion bis zum Dokumentende
 * 2) HyphContinue
 *	  - nLastHyphLen wird auf den Selektionsstart addiert
 *	  - iteriert ueber alle selektierten Bereiche
 *		- pDoc->Hyphenate() iteriert ueber alle Nodes der Selektion
 *			- pTxtNode->Hyphenate() ruft das SwTxtFrm::Hyphenate zur EditShell
 *				- SwTxtFrm:Hyphenate() iteriert ueber die Zeilen des Pams
 *					- LineIter::Hyphenate() stellt den Hyphenator
 *					  und den Pam auf das zu trennende Wort ein.
 *	  - Es gibt nur zwei Returnwerte sal_True, wenn eine Trennstelle anliegt
 *		und sal_False, wenn der Pam abgearbeitet wurde.
 *	  - Bei sal_True wird das selektierte Wort zur Anzeige gebracht und
 *		nLastHyphLen gesetzt.
 *	  - Bei sal_False wird die aktuelle Selektion geloescht und die naechste
 *		zur aktuellen gewaehlt. Return HYPH_OK, wenn keine mehr vorhanden.
 * 3) InsertSoftHyph (wird ggf. von der UI gerufen)
 *	  - Der aktuelle Cursor wird plaziert und das Attribut eingefuegt.
 * 4) HyphEnd
 *	  - Wiederherstellen des alten Cursors, EndAction
 */



//STRIP001 void SwEditShell::HyphStart( SwDocPositions eStart, SwDocPositions eEnd )
//STRIP001 {
//STRIP001 	// do not hyphenate if interactive hyphenationg is active elsewhere
//STRIP001 	if (!pHyphIter)
//STRIP001 	{
//STRIP001 		ASSERT( !pHyphIter, "wer ist da schon am hyphinieren?" );
//STRIP001 		pHyphIter = new SwHyphIter;
//STRIP001 		pHyphIter->Start( this, eStart, eEnd );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
 *					SwEditShell::HyphEnd
 *************************************************************************/

// Selektionen wiederherstellen



//STRIP001 void SwEditShell::HyphEnd()
//STRIP001 {
//STRIP001 	if (pHyphIter->GetSh() == this)
//STRIP001 	{
//STRIP001 		ASSERT( pHyphIter, "wo ist mein Iterator?" );
//STRIP001 		pHyphIter->End();
//STRIP001 		delete pHyphIter, pHyphIter = 0;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
 *					SwEditShell::HyphContinue
 *************************************************************************/

// Returnwerte: (BP: ich wuerde es genau umdrehen, aber die UI wuenscht es so)
// HYPH_CONTINUE, wenn eine Trennstelle anliegt
// HYPH_OK, wenn der selektierte Bereich abgearbeitet wurde.


//STRIP001 uno::Reference< uno::XInterface >
//STRIP001 	SwEditShell::HyphContinue( sal_uInt16* pPageCnt, sal_uInt16* pPageSt )
//STRIP001 {
//STRIP001 	if (pHyphIter->GetSh() != this)
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	if( pPageCnt && !*pPageCnt && !*pPageSt )
//STRIP001 	{
//STRIP001 		sal_uInt16 nEndPage = GetLayout()->GetPageNum();
//STRIP001 		nEndPage += nEndPage * 10 / 100;
//STRIP001 		if( nEndPage > 14 )
//STRIP001 		{
//STRIP001 			*pPageCnt = nEndPage;
//STRIP001 			::StartProgress( STR_STATSTR_HYPHEN, 0, nEndPage, GetDoc()->GetDocShell());
//STRIP001 		}
//STRIP001 		else				// Hiermit unterdruecken wir ein fuer allemal
//STRIP001 			*pPageSt = 1;	// das StatLineStartPercent
//STRIP001 	}
//STRIP001 
//STRIP001 	ASSERT( pHyphIter, "wo ist mein Iterator?" );
//STRIP001 	//JP 18.07.95: verhinder bei Fehlermeldungen die Anzeige der Selektionen
//STRIP001 	//				KEIN StartAction, da damit auch die Paints abgeschaltet
//STRIP001 	//				werden !!!!!
//STRIP001 	++nStartAction;
//STRIP001     uno::Reference< uno::XInterface >  xRet;
//STRIP001     pHyphIter->Continue( pPageCnt, pPageSt ) >>= xRet;
//STRIP001 	--nStartAction;
//STRIP001 
//STRIP001 	if( xRet.is() )
//STRIP001 		pHyphIter->ShowSelection();
//STRIP001 
//STRIP001 	return xRet;
//STRIP001 }


/*************************************************************************
 *					SwEditShell::InsertSoftHyph
 *************************************************************************/

// Zum Einfuegen des SoftHyphens, Position ist der Offset
// innerhalb des getrennten Wortes.


//STRIP001 void SwEditShell::InsertSoftHyph( const xub_StrLen nHyphPos )
//STRIP001 {
//STRIP001 	ASSERT( pHyphIter, "wo ist mein Iterator?" );
//STRIP001 	pHyphIter->InsertSoftHyph( nHyphPos );
//STRIP001 }


/*************************************************************************
 *					SwEditShell::HyphIgnore
 *************************************************************************/

// Beschreibung: Trennstelle ignorieren

//STRIP001 void SwEditShell::HyphIgnore()
//STRIP001 {
//STRIP001 	ASSERT( pHyphIter, "wo ist mein Iterator?" );
//STRIP001 	//JP 18.07.95: verhinder bei Fehlermeldungen die Anzeige der Selektionen
//STRIP001 	//				KEIN StartAction, da damit auch die Paints abgeschaltet
//STRIP001 	//				werden !!!!!
//STRIP001 	++nStartAction;
//STRIP001 	pHyphIter->Ignore();
//STRIP001 	--nStartAction;
//STRIP001 
//STRIP001 	pHyphIter->ShowSelection();
//STRIP001 }

/*************************************************************************
 *					SwEditShell::GetCorrection()
 * liefert eine Liste von Vorschlaegen fuer falsch geschriebene Worte,
 * ein NULL-Pointer signalisiert, dass das Wort richtig geschrieben ist,
 * eine leere Liste, dass das Wort zwar unbekannt ist, aber keine Alternativen
 * geliefert werden koennen.
 *************************************************************************/


//STRIP001 uno::Reference< XSpellAlternatives >
//STRIP001 	SwEditShell::GetCorrection( const Point* pPt )
//STRIP001 {
//STRIP001  	uno::Reference< XSpellAlternatives >  xSpellAlt;
//STRIP001 
//STRIP001 	if( IsTableMode() )
//STRIP001 		return NULL;
//STRIP001 	SwPaM* pCrsr = GetCrsr();
//STRIP001 	SwPosition aPos( *pCrsr->GetPoint() );
//STRIP001  	Point aPt( *pPt );
//STRIP001 	SwCrsrMoveState eTmpState( MV_SETONLYTEXT );
//STRIP001 	SwTxtNode *pNode;
//STRIP001 	SwWrongList *pWrong;
//STRIP001 	if( GetLayout()->GetCrsrOfst( &aPos, aPt, &eTmpState ) &&
//STRIP001 		0 != (pNode = aPos.nNode.GetNode().GetTxtNode()) &&
//STRIP001 		0 != (pWrong = pNode->GetWrong()) &&
//STRIP001 		!pNode->IsInProtectSect() )
//STRIP001 	{
//STRIP001 		xub_StrLen nBegin = aPos.nContent.GetIndex();
//STRIP001 		xub_StrLen nLen = 1;
//STRIP001 		if(	pWrong->InWrongWord(nBegin,nLen) && !pNode->IsSymbol(nBegin) )
//STRIP001 		{
//STRIP001 			String aWord( pNode->GetTxt().Copy( nBegin, nLen ) );
//STRIP001 			aWord.EraseAllChars( CH_TXTATR_BREAKWORD ).EraseAllChars( CH_TXTATR_INWORD );
//STRIP001 
//STRIP001 			sal_Bool bSpell = sal_True;
//STRIP001 
//STRIP001 			uno::Reference< XSpellChecker1 >  xSpell( ::GetSpellChecker() );
//STRIP001 			if( xSpell.is() )
//STRIP001 			{
//STRIP001 				LanguageType eActLang = (LanguageType)pNode->GetLang(
//STRIP001 															nBegin, nLen );
//STRIP001 				if( xSpell->hasLanguage( eActLang ))
//STRIP001 					xSpellAlt = xSpell->spell( aWord, eActLang,
//STRIP001 											   Sequence< PropertyValue >() );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( xSpellAlt.is() )
//STRIP001 			{
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001 				pNode->GetWrong()->Invalidate( 0, STRING_LEN );
//STRIP001 				pNode->SetWrongDirty( sal_True );
//STRIP001 #endif
//STRIP001 				aPos.nContent = nBegin;
//STRIP001 				*pCrsr->GetPoint() = aPos;
//STRIP001 				pCrsr->SetMark();
//STRIP001 				ExtendSelection( sal_True, nLen );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return xSpellAlt;
//STRIP001 }




}
