/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: exchobj.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:16:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _EXCHOBJ_HXX
#define _EXCHOBJ_HXX

// includes *******************************************************************

#ifndef _DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#ifndef _SO2REF_HXX //autogen
#include <so3/so2ref.hxx>
#endif
namespace binfilter {

// forwards *******************************************************************

class SfxExchangeObject;

//*****************************************************************************
// SfxExchangeObjectRef
//*****************************************************************************

//STRIP001 SO2_DECL_REF( SfxExchangeObject )

//*****************************************************************************
// SfxDataObjectMemberList
//*****************************************************************************

/*
  [Beschreibung]
  Instanzen dieser Klasse halten Referenzen auf mehrere Instanzen der Klasse
  <SvDataObject>.
  */

SV_DECL_IMPL_REF_LIST( SvDataObject, SvDataObject* )

//*****************************************************************************
// SfxExchangeObject
//*****************************************************************************

/*
  [Beschreibung]
  Die Klasse erweitert die Basisklasse um die Moeglichkeit mehrere Instanzen
  der Klasse <SvDataObject> an einem Datenaustausch innerhalb einer Applikation
  zu beteiligen. Zu diesem Zwecke stellt sie Methoden zur Verfuegung, mit deren
  Hilfe die einzelnen Instanzen abgefragt werden koennen. Unterstuetzt ein
  Applikationsteil die Klasse nicht bzw. wird der Datenaustausch mit einem
  Bereich ausserhalb der Applikation durchgefuehrt, so werden alle Aufrufe an
  die Instanz auf ein Objekt aus dem Datenaustausch delegiert. Werden nur
  Instanzen verwendet, die das Format fuer den Austausche von Dateien
  unterstuetzen <FORMAT_FILE>, so generiert eine Instanz der Klasse
  <SfxExchangeObject> zusaetzlich das Format und die Daten fuer mehrere
  Dateien <FORMAT_FILE_LIST>.

  [Beispiel fuer eine Quelle]
  ...
  #include<sfxexch.hxx>
  ...
  // pSelection ist ein beliebiges Objekt, das eine Mehrfachselektion
  // repraesentiert
  SfxExchangeObjectRef xObj = new SfxExchangeObject();
  USHORT nPos = pSelection->Count();
  while ( nPos-- )
  {
	  // Daten in das Objekt einfuegen
	  xObj->Insert( pSelection->GetSelItem( nPos )->CreateDataObject() );
  }
  xObj->CopyClipboard();
  ...

  [Beispiel fuer ein Ziel]
  SfxExchangeObjectRef xObj = SfxExchangeObject::PasteClipboard();
  if ( xObj.Is() )
  {
	  // Iteration ueber alle am Datenaustausch beteiligten Objekte
	  ULONG nPos = xObj->Count();
	  while ( nPos-- )
	  {
		  SvDataObject* pItem = xObj->GetObject( nPos );
		  pItem->GetDataHere( .... );
		  ...
	  }
  }
  */

//STRIP001 class SfxExchangeObject : public SvDataObject
//STRIP001 {
//STRIP001 
//STRIP001 	SvDataObjectMemberList*       _pObjList;
//STRIP001 	SvDataTypeList*               _pTypeList;
//STRIP001 
//STRIP001 private:
//STRIP001 
//STRIP001 #if _SOLAR__PRIVATE
//STRIP001 	static SfxExchangeObjectRef   DetectObject_Impl( SvDataObject* pObj );
//STRIP001 
//STRIP001 	BOOL                          SetFileList_Impl( SvData* ) const;
//STRIP001 #endif
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 	SO2_DECL_BASIC_CLASS( SfxExchangeObject )
//STRIP001 
//STRIP001 								  SfxExchangeObject();
//STRIP001 								  SfxExchangeObject( SvDataObject* pExternal );
//STRIP001 	virtual                       ~SfxExchangeObject();
//STRIP001 
//STRIP001 	virtual const SvDataTypeList& GetTypeList() const;
//STRIP001 	virtual const SvDataTypeList& GetSetDataTypeList() const;
//STRIP001 
//STRIP001 	virtual BOOL	              SetData( SvData* pData );
//STRIP001 	virtual BOOL	              GetData( SvData* pData );
//STRIP001 	virtual BOOL	              GetDataHere( SvData* pData );
//STRIP001 	virtual BOOL	              QueryDataType( SvDataType& rInOutType );
//STRIP001 
//STRIP001 	inline void                   Insert( SvDataObject* pObj );
//STRIP001 	inline SvDataObject*          GetObject( ULONG nIndex ) const;
//STRIP001 	inline ULONG                  Count() const;
//STRIP001 
//STRIP001 	static SfxExchangeObjectRef   PasteClipboard();
//STRIP001 	static SfxExchangeObjectRef   PasteDragServer( const DropEvent& rEvt );
//STRIP001 
//STRIP001 };

// inlines ********************************************************************

//STRIP001 inline void SfxExchangeObject::Insert( SvDataObject* pObj )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pObj, "SfxExchangeObject:ungueltiges Objekt" );
//STRIP001 	_pObjList->Insert( pObj, LIST_APPEND );
//STRIP001 }

//STRIP001 inline SvDataObject* SfxExchangeObject::GetObject( ULONG nIndex ) const
//STRIP001 {
//STRIP001 	DBG_ASSERT( nIndex < Count(), "SfxExchangeObject:ungueltige Indizierung" );
//STRIP001 	return _pObjList->GetObject( nIndex );
//STRIP001 }

//STRIP001 inline ULONG SfxExchangeObject::Count() const
//STRIP001 {
//STRIP001 	return _pObjList->Count();
//STRIP001 }

//*****************************************************************************
// SfxExchangeObjectRef
//*****************************************************************************

//STRIP001 SO2_IMPL_REF( SfxExchangeObject )

}//end of namespace binfilter
#endif

