
/******************************************************************************
**
**  Copyright (C) 2001  - the shmoo group -
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/******************************************************************************
**
**    The Shmoo Group (TSG)
**
**    File:      filter_md5.c
**    Author:    Brian Wotring
**
**    Date:      March 14, 2002.
**    Project:   osiris
**
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include <sys/stat.h>
#include <openssl/x509.h>

#include "utilities.h"
#include "ssl_utilities.h"
#include "scan_record.h"
#include "filter.h"

osi_bool filter_md5( const char *file_path, FILTER_CONTEXT *context )
{
    char hash[64];

    if( ( file_path != NULL ) && ( context != NULL ) &&
        ( context->filter_argument != NULL ) )
    {
        /* we allow optional hex prefix here, skip */
        /* over it if there is one.                */

        if( strncmp( context->filter_argument, "0x", 2 ) == 0 )
        {
            context->filter_argument += 2;
        }

        hash_file_md5( file_path, context->file_handle, hash, sizeof( hash ) );

        if( strcmp( hash, context->filter_argument ) == 0 )
        {
            return TRUE;
        }
    }

    return FALSE;
}
