<?php
/**
*
* common [Português Brasileiro]
*
* @package language
* @version 1.0.4
* @author Suporte phpBB <contato@suportephpbb.com.br> http://www.suportephpbb.com.br/
* @copyright (c) 2005 phpBB Group, 2012 Suporte phpBB
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/** 
* DO NOT CHANGE 
*/ 
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang)) 
{ 
	$lang = array(); 
} 

// DEVELOPERS PLEASE NOTE 
// 
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
// 
// Placeholders can now contain order information, e.g. instead of 
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows 
// translators to re-order the output of data while ensuring it remains correct 
// 
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine 
// equally where a string contains only two placeholders which are used to wrap text 
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine 


$lang = array_merge($lang, array( 
	
	// Translation Info
	'TRANSLATION_INFO'	=> 'Traduzido por: <a href="http://www.suportephpbb.com.br">Suporte phpBB</a>', 
	
	'DIRECTION'			=> 'ltr', 
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled) 
	'USER_LANG'			=> 'pt-br', 

	'1_DAY'					=> '1 dia', 
	'1_MONTH'				=> '1 mês', 
	'1_YEAR'				=> '1 ano', 
	'2_WEEKS'				=> '2 semanas', 
	'3_MONTHS'				=> '3 meses', 
	'6_MONTHS'				=> '6 meses', 
	'7_DAYS'				=> '7 dias', 

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'O seu registro já foi ativado.',
	'ACCOUNT_DEACTIVATED'			=> 'O seu registro foi desativado manualmente e somente pode ser reativado por um administrador.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'O seu registro ainda não foi ativado.',
	'ACP'							=> 'Painel de Controle da Administração', 
	'ACTIVE'						=> 'Ativo', 
	'ACTIVE_ERROR'					=> 'Você especificou um nome de usuário inativo. Por favor, tente reativar o seu registro e tente novamente. Se você continuar tendo problemas, contate um administrador.',
	'ADMINISTRATOR'					=> 'Administrador', 
	'ADMINISTRATORS'				=> 'Administradores', 
	'AGE'							=> 'Idade',	 
	'AIM'							=> 'AIM',	 
	'ALLOWED'						=> 'Permitido', 
	'ALL_FILES'						=> 'Todos os arquivos',	 
	'ALL_FORUMS'					=> 'Todos os fóruns', 
	'ALL_MESSAGES'					=> 'Todas as mensagens', 
	'ALL_POSTS'						=> 'Todas as mensagens', 
	'ALL_TIMES'						=> 'Todos os horários são %1$s %2$s', 
	'ALL_TOPICS'					=> 'Todos os tópicos', 
	'AND'							=> 'E', 
	'ARE_WATCHING_FORUM'			=> 'Você optou por receber atualizações deste fórum.', 
	'ARE_WATCHING_TOPIC'			=> 'Você optou por receber atualizações deste tópico.', 
	'ASCENDING'						=> 'Crescente', 
	'ATTACHMENTS'					=> 'Anexos', 
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'O arquivo de imagem que você tentou anexar é inválido.',
	'AUTHOR'						=> 'Autor', 
	'AUTH_NO_PROFILE_CREATED'		=> 'Não foi possível criar o perfil do usuário.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'O envio foi rejeitado porque o anexo foi identificado como um possível vetor de ataque.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'A extensão %s não é permitida.', 
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Avatar não pôde ser enviado, por favor, tente enviar o arquivo manualmente.', 
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'O anexo selecionado encontra-se vazio.',
	'AVATAR_INVALID_FILENAME'		=> '%s é um nome inválido.', 
	'AVATAR_NOT_UPLOADED'			=> 'O avatar não pôde ser enviado.', 
	'AVATAR_NO_SIZE'				=> 'Não foi possível obter a largura e a altura do avatar, por favor, informe-os manualmente.', 
	'AVATAR_PARTIAL_UPLOAD'			=> 'O arquivo foi parcialmente enviado.',	 
	'AVATAR_PHP_SIZE_NA'			=> 'O tamanho do avatar é muito grande.<br />Não foi possível determinar o tamanho máximo definido pelo PHP no php.ini.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'O tamanho do avatar é muito grande. O tamanho máximo permitido é de %1$d %2$s.<br />Isto é fixo do PHP no php.ini e não pode ser substituído.',
	'AVATAR_URL_INVALID'			=> 'A URL que você especificou é inválida.', 
	'AVATAR_URL_NOT_FOUND'			=> 'O arquivo informado não foi encontrado.',	 
	'AVATAR_WRONG_FILESIZE'			=> 'O tamanho do avatar deve estar entre 0 e %1d %2s.', 
	'AVATAR_WRONG_SIZE'				=> 'O avatar enviado possui %5$d pixels de largura e %6$d pixels de altura. O avatar deve possuir no mínimo %1$d pixels de largura, %2$d pixels altura e no máximo %3$d pixels de largura e %4$d pixels de altura.',

	'BACK_TO_TOP'			=> 'Voltar ao topo', 
	'BACK_TO_PREV'			=> 'Voltar à página anterior', 
	'BAN_TRIGGERED_BY_EMAIL'=> 'O seu endereço de e-mail foi banido.',
	'BAN_TRIGGERED_BY_IP'	=> 'O seu endereço de IP foi banido.', 
	'BAN_TRIGGERED_BY_USER'	=> 'O seu nome de usuário foi banido.',		 
	'BBCODE_GUIDE'			=> 'Guia de BBCode', 
	'BCC'					=> 'BCC', 
	'BIRTHDAYS'				=> 'Aniversários', 
	'BOARD_BAN_PERM'		=> 'Você foi banido <b>permanentemente</b> deste fórum!<br /><br />Por favor, contate o %2$sadministrador%3$s para mais informações.', 
	'BOARD_BAN_REASON'		=> 'Razão para o banimento: <b>%s</b>', 
	'BOARD_BAN_TIME'		=> 'Você foi banido deste fórum até <b>%1$s</b>.<br /><br />Por favor, contate o %2$sadministrador%3$s para mais informações.', 
	'BOARD_DISABLE'			=> 'Este painel não se encontra disponível no momento. Por favor, tente novamente mais tarde.', 
	'BOARD_DISABLED'		=> 'Este painel não se encontra disponível no momento. Por favor, tente novamente mais tarde.',	 
	'BOARD_UNAVAILABLE'		=> 'Este painel não se encontra disponível no momento. Por favor, tente novamente mais tarde.',
	'BROWSING_FORUM'        => 'Usuários navegando neste fórum: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Usuários navegando neste fórum: %1$s e %2$d visitante', 
	'BROWSING_FORUM_GUESTS'	=> 'Usuários navegando neste fórum: %1$s e %2$d visitantes', 
	'BYTES'					=> 'Bytes', 

	'CANCEL'				=> 'Cancelar', 
	'CHANGE'				=> 'Alterar', 
	'CHANGE_FONT_SIZE'		=> 'Alterar o tamanho da fonte', 
	'CHANGING_PREFERENCES'	=> 'Alterando as preferências do fórum',
	'CHANGING_PROFILE'		=> 'Alterando as configurações de perfil',
	'CLICK_VIEW_PRIVMSG'	=> 'Clique %saqui%s para ir à caixa de entrada', 
	'COLLAPSE_VIEW'			=> 'Visão contraída',
	'CLOSE_WINDOW'			=> 'Fechar janela', 
	'COLOUR_SWATCH'			=> 'Palheta de cores', 
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination and secret yet-to-be-release style, use localised comma if appropiate, eg: Ideographic or Arabic		 
	'CONFIRM'				=> 'Confirmar', 
	'CONFIRM_CODE'			=> 'Código de confirmação', 
	'CONFIRM_CODE_EXPLAIN'	=> 'Digite o código exatamente como você o vê. Não há diferenciação de maiúsculas e minúsculas.',
	'CONFIRM_CODE_WRONG'	=> 'O código de confirmação enviado está incorreto.',	 
	'CONFIRM_OPERATION'		=> 'Você deseja realmente prosseguir com esta operação?',	 
	'CONGRATULATIONS'		=> 'Parabéns para', 
	'CONNECTION_FAILED'		=> 'A conexão falhou.', 
	'CONNECTION_SUCCESS'	=> 'A conexão foi efetuada com sucesso!', 
	'COOKIES_DELETED'		=> 'Todos os cookies foram excluídos com sucesso.', 
	'CURRENT_TIME'			=> 'Bem-vindo: %s', 

	'DAY'					=> 'Dia', 
	'DAYS'					=> 'Dias', 
	'DELETE'				=> 'Excluir', 
	'DELETE_ALL'			=> 'Excluir todos', 
	'DELETE_COOKIES'		=> 'Excluir todos os cookies deste painel', 
	'DELETE_MARKED'			=> 'Excluir selecionados', 
	'DELETE_POST'			=> 'Excluir mensagem', 
	'DELIMITER'				=> 'Delimitador', 
	'DESCENDING'			=> 'Decrescente', 
	'DISABLED'				=> 'Desativado', 
	'DISPLAY'				=> 'Exibir', 
	'DISPLAY_GUESTS'		=> 'Exibir visitantes', 
	'DISPLAY_MESSAGES'		=> 'Exibir mensagens anteriores', 
	'DISPLAY_POSTS'			=> 'Exibir mensagens anteriores', 
	'DISPLAY_TOPICS'		=> 'Mostrar tópicos anteriores', 
	'DOWNLOADED'			=> 'Baixado', 
	'DOWNLOADING_FILE'		=> 'Baixando arquivo', 
	'DOWNLOAD_COUNT'		=> 'Baixado %d vez', 
	'DOWNLOAD_COUNTS'		=> 'Baixado %d vezes', 
	'DOWNLOAD_COUNT_NONE'	=> 'Baixado 0 vezes',
	'VIEWED_COUNT'			=> 'Exibido %d vez',
	'VIEWED_COUNTS'			=> 'Exibido %d vezes',
	'VIEWED_COUNT_NONE'		=> 'Exibido 0 vezes',

	'EDIT_POST'							=> 'Editar mensagem', 
	'EMAIL'								=> 'E-mail', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Endereço de e-mail',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Ocorreu um problema ao enviar o e-mail na <strong>Linha %1$s</strong>. Erro: %2$s.',
	'EMPTY_SUBJECT'						=> 'Você deve especificar um título quando enviar um novo tópico.', 
	'EMPTY_MESSAGE_SUBJECT'				=> 'Você deve especificar um título quando compor uma nova mensagem.',
	'ENABLED'							=> 'Ativado', 
	'ENCLOSURE'							=> 'Documento anexo', 
	'ENTER_USERNAME'					=> 'Digite o nome de usuário',
	'ERR_CHANGING_DIRECTORY'			=> 'Não foi possível alterar o diretório.', 
	'ERR_CONNECTING_SERVER'				=> 'Erro ao conectar-se com o servidor.',
	'ERR_JAB_AUTH'                      => 'Não foi possível autenticar-se no servidor do jabber.',
    'ERR_JAB_CONNECT'                   => 'Não foi possível conectar-se ao servidor do jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'O seu nome de usuário está incorreto ou inativo ou a sua senha é inválida.',	 
	'ERR_UNWATCHING'					=> 'Um erro ocorreu durante o cancelamento da subscrição.',
	'ERR_WATCHING'						=> 'Um erro ocorreu durante a subscrição.',	
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'O local do script phpBB informado parece não ser válido.',
	'EXPAND_VIEW'						=> 'Visualização expandida', 
	'EXTENSION'							=> 'Extensão', 
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'O anexo não pode ser exibido, pois a extensão <b>%s</b> foi desativada pelo administrador.',

	'FAQ'					=> 'FAQ', 
	'FAQ_EXPLAIN'			=> 'Questões mais frequentes', 
	'FILENAME'				=> 'Nome do arquivo', 
	'FILESIZE'				=> 'Tamanho do arquivo', 
	'FILEDATE'				=> 'Data do arquivo', 
	'FILE_COMMENT'			=> 'Descrição do arquivo', 
	'FILE_NOT_FOUND'		=> 'O arquivo não foi encontrado.', 
	'FIND_USERNAME'			=> 'Procurar um usuário', 
	'FOLDER'				=> 'Pasta', 
	'FORGOT_PASS'			=> 'Esqueci a senha', 
	'FORM_INVALID'          => 'A forma submetida é inválida. Tente submeter novamente.',
	'FORUM'					=> 'Fórum', 
	'FORUMS'				=> 'Fóruns', 
	'FORUMS_MARKED'			=> 'Os fóruns selecionados foram assinalados como lidos.', 
	'FORUM_CAT'				=> 'Categoria do fórum',	 
	'FORUM_INDEX'			=> 'Índice do fórum', 
	'FORUM_LINK'			=> 'Endereço do fórum',	 
	'FORUM_LOCATION'		=> 'Local do fórum', 
	'FORUM_LOCKED'			=> 'Fórum trancado', 
	'FORUM_RULES'			=> 'Regras do fórum', 
	'FORUM_RULES_LINK'		=> 'Por favor, clique aqui para ver as regras do fórum',
	'FROM'					=> 'de', 
	'FSOCK_DISABLED'		=> 'Não foi possível concluir esta operação, porque a função <var>fsockopen</var> está desativada ou o servidor solicitado não foi encontrado.', 
	'FSOCK_TIMEOUT'			=> 'Um tempo de espera ocorreu durante a leitura do fluxo de rede.',
	 
	'FTP_FSOCK_HOST'				=> 'Servidor do FTP', 
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Servidor FTP utilizado para se conectar ao seu site.',
	'FTP_FSOCK_PASSWORD'			=> 'Senha do FTP', 
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Senha para o seu nome de usuário do FTP.',
	'FTP_FSOCK_PORT'				=> 'Porta do FTP', 
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Porta utilizada para se conectar ao seu servidor FTP.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Pasta do phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Local desde a raiz até o seu fórum phpBB.',
	'FTP_FSOCK_TIMEOUT'				=> 'Intervalo do FTP', 
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Tempo em segundos que o sistema irá aguardar por uma resposta de seu servidor.',
	'FTP_FSOCK_USERNAME'			=> 'Nome de usuário de FTP', 
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Nome de usuário utilizado para se conectar ao seu servidor.',
	 
	'FTP_HOST'					=> 'Servidor do FTP', 
	'FTP_HOST_EXPLAIN'			=> 'Servidor FTP utilizado para se conectar ao seu site.',
	'FTP_PASSWORD'				=> 'Senha do FTP', 
	'FTP_PASSWORD_EXPLAIN'		=> 'Senha para o seu nome de usuário do FTP.',
	'FTP_PORT'					=> 'Porta do FTP', 
	'FTP_PORT_EXPLAIN'			=> 'Porta utilizada para se conectar ao seu servidor FTP.',
	'FTP_ROOT_PATH'				=> 'Pasta do phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Local desde a raiz até o seu fórum phpBB.',
	'FTP_TIMEOUT'				=> 'Intervalo do FTP', 
	'FTP_TIMEOUT_EXPLAIN'		=> 'Tempo em segundos que o sistema irá aguardar por uma resposta de seu servidor.',
	'FTP_USERNAME'				=> 'Nome de usuário de FTP', 
	'FTP_USERNAME_EXPLAIN'		=> 'Nome de usuário utilizado para se conectar ao seu servidor.',

	'GENERAL_ERROR'				=> 'Erro Geral',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',	
	'GO'						=> 'Ir', 
	'GOTO_PAGE'					=> 'Ir para página', 
	'GROUP'						=> 'Grupo', 
	'GROUPS'					=> 'Grupos', 
	'GROUP_ERR_TYPE'			=> 'O tipo de grupo selecionado é inapropriado.', 
	'GROUP_ERR_USERNAME'		=> 'O nome do grupo não foi especificado.', 
	'GROUP_ERR_USER_LONG'		=> 'O nome do grupo não pode exceder 60 caracteres. O nome do grupo é muito longo.',
	'GUEST'						=> 'Visitante', 
	'GUEST_USERS_ONLINE'		=> 'Há %d visitantes online', 
	'GUEST_USERS_TOTAL'			=> '%d visitantes', 
	'GUEST_USERS_ZERO_ONLINE'	=> 'Não há visitantes online', 
	'GUEST_USERS_ZERO_TOTAL'	=> 'nenhum visitante', 
	'GUEST_USER_ONLINE'			=> 'Há %d visitante online', 
	'GUEST_USER_TOTAL'			=> '%d visitante', 
	'G_ADMINISTRATORS'			=> 'Administradores', 
	'G_BOTS'					=> 'BOTs', 
	'G_GUESTS'					=> 'Visitantes', 
	'G_REGISTERED'				=> 'Usuários registrados', 
	'G_REGISTERED_COPPA'		=> 'Usuários registrados da COPPA', 
	'G_GLOBAL_MODERATORS'		=> 'Moderadores globais',
	'G_NEWLY_REGISTERED'		=> 'Usuários registrados recentemente',	

	'HIDDEN_USERS_ONLINE'		=> '%d usuários invisíveis online', 
	'HIDDEN_USERS_TOTAL'		=> '%d invisíveis',
	'HIDDEN_USERS_TOTAL_AND'	=> '%d invisíveis e ',
	'HIDDEN_USERS_ZERO_ONLINE'	=> '0 usuários invisíveis online', 
	'HIDDEN_USERS_ZERO_TOTAL'	=> 'nenhum invisível',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> 'nenhum invisível e ',
	'HIDDEN_USER_ONLINE'		=> '%d usuário invisível online', 
	'HIDDEN_USER_TOTAL'			=> '%d invisível',
	'HIDDEN_USER_TOTAL_AND'		=> '%d invisível e ',
	'HIDE_GUESTS'				=> 'Ocultar visitantes', 
	'HIDE_ME'					=> 'Ocultar meus status nesta sessão', 
	'HOURS'						=> 'Horas', 
	'HOME'						=> 'Principal', 

	'ICQ'						=> 'ICQ', 
	'ICQ_STATUS'				=> 'Status do ICQ',
	'IF'						=> 'Se', 
	'IMAGE'						=> 'Imagem', 
	'IMAGE_FILETYPE_INVALID'	=> 'O formato da imagem %d não é suportado para a miniatura %s.', 
	'IMAGE_FILETYPE_MISMATCH'	=> 'O tipo de arquivo da imagem está em desacordo: A extensão esperada foi %1$s, mas a extensão informada foi %2$s.',	 
	'IN'						=> 'em', 
	'INDEX'						=> 'Índice', 
	'INFORMATION'				=> 'Informação', 
	'INTERESTS'					=> 'Interesses', 
	'INVALID_DIGEST_CHALLENGE'	=> 'O desafio de sumário é inválido.',
	'INVALID_EMAIL_LOG'			=> '<b>%s</b> é um possível endereço de e-mail inválido?', 
	'IP'						=> 'IP', 
	'IP_BLACKLISTED'			=> 'O seu endereço de IP %1$s foi banido porque está na lista negra. Para mais informações, por favor leia <a href="%2$s">%2$s</a>.',	 

	'JABBER'				=> 'Jabber', 
	'JOINED'				=> 'Registrado em', 
	'JUMP_PAGE'				=> 'Escreva o número da página a qual você deseja ir',
	'JUMP_TO'				=> 'Ir para', 
	'JUMP_TO_PAGE'			=> 'Clique para ir à página...', 

	'KB'				    => 'KB',
	'KIB'                   => 'KiB',

	'LAST_POST'							=> 'Última mensagem',
	'LAST_UPDATED'						=> 'Última atualização',
	'LAST_VISIT'						=> 'Última visita',
	'LDAP_NO_LDAP_EXTENSION'			=> 'A extensão LDAP não está disponível.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Não foi possível conectar-se ao servidor LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'Um erro ocorreu quando a busca estava sendo executada no diretório LDAP.',
	'LEGEND'							=> 'Legenda',
	'LOCATION'							=> 'Localização',
	'LOCK_POST'							=> 'Trancar mensagem',
	'LOCK_POST_EXPLAIN'					=> 'Prevenir a mensagem de sofrer possíveis alterações.',
	'LOCK_TOPIC'						=> 'Trancar tópico',
	'LOGIN'								=> 'Entrar',
	'LOGIN_CHECK_PM'					=> 'Entrar e ver mensagens particulares',
	'LOGIN_CONFIRMATION'				=> 'Confirmação de login',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Para prevenir ataques ao registro, o administrador exige o código de confirmação após sucessivas tentativas de login falhas. O código deverá ser exibido na imagem abaixo. Se você possui qualquer problema visual ou que possa impedir a sua confirmação, contate o %sadministrador%s do fórum para solicitar ajuda.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Você excedeu o número máximo de tentativas de login. Em adição ao seu nome de usuário e senha, você agora deverá resolver o CAPTCHA abaixo.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Você não foi autenticado pelo Apache.',	 
	'LOGIN_ERROR_PASSWORD'				=> 'Você especificou uma senha incorreta. Por favor, certifique-se de ter escrito uma senha correta e tente novamente. Se você continuar tendo problemas, por favor, contate o %sadministrador%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Não foi possível converter a sua senha ao atualizar este painel. Por favor, %ssolicite uma nova senha%s. Se continuar tendo problemas, contate o %sadministrador%s.',	 
	'LOGIN_ERROR_USERNAME'				=> 'Você especificou um nome de usuário incorreto. Por favor, certifique-se de seu nome de usuário e tente novamente. Se você continuar tendo problemas, por favor, contate o %sadministrador%s.', 
	'LOGIN_FORUM'						=> 'Para visualizar ou enviar mensagens neste fórum você deve informar uma senha.', 
	'LOGIN_INFO'						=> 'Para autenticar-se você precisa estar registrado. O registro leva apenas alguns segundos, mas aumenta as suas permissões. O administrador também pode conceder permissões adicionais a usuários registrados. Antes de autenticar-se esteja familiarizado com os nossos termos de uso e políticas relacionadas. Por favor, assegure-se de ler as regras do fórum enquanto navegar pela comunidade.', 
	'LOGIN_VIEWFORUM'					=> 'O administrador requer que você esteja registrado e autenticado para visualizar este fórum.', 
	'LOGIN_EXPLAIN_EDIT'				=> 'Para editar mensagens você precisa estar registrado e autenticado.',
   'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Você deve estar registrado e autenticado para ver a lista de usuários online.',
	'LOGOUT'							=> 'Sair',
	'LOGOUT_USER'						=> 'Sair [ %s ]', 
	'LOG_ME_IN'							=> 'Lembrar minhas informações', 

	'MARK'					=> 'Selecionar', 
	'MARK_ALL'				=> 'Selecionar todos', 
	'MARK_FORUMS_READ'		=> 'Assinalar todos os fóruns como lidos', 
	'MARK_SUBFORUMS_READ'	=> 'Assinalar sub-fóruns como lidos',
	'MB'					=> 'MB',
	'MIB'                   => 'MiB',
	'MCP'					=> 'Painel de Controle do Moderador', 
	'MEMBERLIST'			=> 'Membros', 
	'MEMBERLIST_EXPLAIN'	=> 'Aqui você pode ver a lista completa dos usuários registrados neste painel.', 
	'MERGE'					=> 'Fundir',
	'MERGE_POSTS'			=> 'Mover mensagens',
	'MERGE_TOPIC'			=> 'Fundir tópico', 
	'MESSAGE'				=> 'Mensagem', 
	'MESSAGES'				=> 'Mensagens',	 
	'MESSAGE_BODY'			=> 'Corpo da mensagem', 
	'MINUTES'				=> 'Minutos', 
	'MODERATE'				=> 'Moderado', 
	'MODERATOR'				=> 'Moderador', 
	'MODERATORS'			=> 'Moderadores', 
	'MONTH'					=> 'Mês', 
	'MOVE'					=> 'Mover', 
	'MSNM'					=> 'MSNM/WLM',		 

	'NA'						=> 'N/A', 
	'NEWEST_USER'				=> 'Novo usuário: <b>%s</b>',
	'NEW_MESSAGE'				=> 'Nova mensagem', 
	'NEW_MESSAGES'				=> 'Novas mensagens', 
	'NEW_PM'					=> '<strong>%d</strong> mensagem nova', 
	'NEW_PMS'					=> '<strong>%d</strong> mensagens novas', 
	'NEW_POST'					=> 'Nova mensagem',  // Not used anymore
	'NEW_POSTS'					=> 'Novas mensagens', // Not used anymore
	'NEXT'						=> 'Próximo',      // Used in pagination
	'NEXT_STEP'                 => 'Próximo',
	'NEVER'						=> 'Nunca',	 
	'NO'						=> 'Não', 
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Você não está autorizado a gerenciar este grupo.', 
	'NOT_AUTHORISED'			=> 'Você não está autorizado a acessar esta área.',		 
	'NOT_WATCHING_FORUM'		=> 'Você não está mais subscrito para receber atualizações deste fórum.', 
	'NOT_WATCHING_TOPIC'		=> 'Você não está mais subscrito para receber atualizações deste tópico.', 
	'NOTIFY_ADMIN'				=> 'Por favor, contate o administrador ou webmaster deste fórum.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Por favor, contate o administrador ou webmaster deste fórum: <a href="mailto:%1$s">%1$s</a>',		
	'NO_ACCESS_ATTACHMENT'		=> 'Você não está autorizado a acessar este arquivo.', 
	'NO_ACTION'					=> 'Nenhuma ação especificada.', 
	'NO_ADMINISTRATORS'			=> 'Não há administradores definidos para este painel.',	 
	'NO_AUTH_ADMIN'				=> 'Você não possui permissões administrativas, e então não pode acessar o painel de administração.', 
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Você não pode se reautenticar com outro nome de usuário.',				 
	'NO_AUTH_OPERATION'			=> 'Você não tem as permissões necessárias para concluir esta operação.', 
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Não foi possível conectar-se ao servidor SMTP : %s : %s',	 
	'NO_BIRTHDAYS'				=> 'Não há aniversários hoje', 
	'NO_EMAIL_MESSAGE'			=> 'O corpo da mensagem do e-mail estava em branco.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Não foi possível receber os códigos de erro do servidor de e-mail.',
	'NO_EMAIL_SUBJECT'			=> 'Não foi especificado um título para o e-mail.',
	'NO_FORUM'					=> 'O fórum selecionado não existe.', 
	'NO_FORUMS'					=> 'Este painel não possui fóruns.',
	'NO_GROUP'					=> 'O grupo selecionado não existe.', 
	'NO_GROUP_MEMBERS'			=> 'Este grupo atualmente não possui membros.',
	'NO_IPS_DEFINED'			=> 'Nenhum endereço de IP ou hostname definido',	 
	'NO_MEMBERS'				=> 'Nenhum usuário foi encontrado utilizando estes critérios.',
	'NO_MESSAGES'				=> 'Não há mensagens', 
	'NO_MODE'					=> 'Nenhum modo foi especificado.',	 
	'NO_MODERATORS'				=> 'Não há moderadores definidos para este painel.',	 
	'NO_NEW_MESSAGES'			=> 'Não há mensagens novas', 
	'NO_ONLINE_USERS'			=> 'Nenhum usuário registrado',	 
	'NO_NEW_PM'					=> '<strong>0</strong> mensagens novas', 
	'NO_NEW_POSTS'				=> 'Não há mensagens novas', 
	'NO_POSTS'					=> 'Não há mensagens',	// Not used anymore
	'NO_POSTS_TIME_FRAME'		=> 'Não existem mensagens neste tópico no período selecionado.',	 
	'NO_FEED_ENABLED'			=> 'Os feeds não estão disponíveis neste painel.',
	'NO_FEED'					=> 'O feed solicitado não está disponível.',
	'NO_SUBJECT'				=> 'Nenhum título foi especificado.',
	'NO_SUCH_SEARCH_MODULE'		=> 'O modo de pesquisa especificado não existe.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Nenhum método de autenticação suportado.',
	'NO_TOPIC'					=> 'O tópico selecionado não existe.', 
	'NO_TOPIC_FORUM'            => 'O tópico ou fórum selecionado já não existe mais.',	 
	'NO_TOPICS'					=> 'Não há mensagens neste fórum<br />Clique em <b>novo tópico</b> para adicionar uma mensagem nova.', 
	'NO_TOPICS_TIME_FRAME'		=> 'Não existem tópicos neste fórum no período selecionado.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> mensagens não lidas',
	'NO_UNREAD_POSTS'			=> 'Nenhuma mensagem não lida',
	'NO_UPLOAD_FORM_FOUND'		=> 'O envio do arquivo foi iniciado, mas nenhuma forma de envio válida foi encontrada.', 
	'NO_USER'					=> 'O usuário selecionado não existe.', 
	'NO_USERS'					=> 'Os usuários selecionados não existem.', 
	'NO_USER_SPECIFIED'			=> 'Nenhum nome de usuário foi especificado.',
	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Nenhuma mensagem na lista',		// 0
		1			=> '1 mensagem na lista',		// 1
		2			=> '%d mensagens na lista',		// 2+
	),	
	
	'OCCUPATION'				=> 'Ocupação', 
	'OFFLINE'					=> 'Offline', 
	'ONLINE'					=> 'Online', 
	'ONLINE_BUDDIES'			=> 'Amigos online', 
	'ONLINE_USERS_TOTAL'		=> 'No total, há <b>%d</b> usuários online :: ', 
	'ONLINE_USERS_ZERO_TOTAL'	=> 'No total, há <b>0</b> usuários online :: ', 
	'ONLINE_USER_TOTAL'			=> 'No total, há <b>%d</b> usuário online :: ', 
	'OPTIONS'					=> 'Opções', 

	'PAGE_OF'				=> 'Página <b>%1$d</b> de <b>%2$d</b>', 
	'PASSWORD'				=> 'Senha', 
	'PIXEL'					=> 'px',
	'PLAY_QUICKTIME_FILE'	=> 'Executar arquivo do Quicktime',	 
	'PM'					=> 'MP',
	'PM_REPORTED'			=> 'Clique para ver a notificação',
	'POSTING_MESSAGE'		=> 'Enviar mensagem para %s', 
	'POSTING_PRIVATE_MESSAGE'	=> 'Compondo mensagem particular',	 
	'POST'					=> 'Mensagem', 
	'POST_ANNOUNCEMENT'		=> 'Anúncio', 
	'POST_STICKY'			=> 'Fixo', 
	'POSTED'				=> 'Enviado', 
	'POSTED_IN_FORUM'		=> 'no', 
	'POSTED_ON_DATE'		=> 'em',	 
	'POSTS'					=> 'Mensagens', 
	'POSTS_UNAPPROVED'		=> 'Pelo menos uma mensagem neste tópico não foi aprovada.', 
	'POST_BY_AUTHOR'		=> 'por',		 
	'POST_BY_FOE'			=> 'Esta mensagem foi enviada por <b>%1$s</b> que está na sua lista de ignorados. %2$sExibir esta mensagem%3$s.', 
	'POST_DAY'				=> '%.2f mensagens por dia', 
	'POST_DETAILS'			=> 'Informações da mensagem', 
	'POST_NEW_TOPIC'		=> 'Criar novo tópico', 
	'POST_PCT'				=> '%.2f%% do total', 
	'POST_PCT_ACTIVE'		=> '%.2f%% das mensagens dos usuários', 
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% de suas mensagens',	 
	'POST_REPLY'			=> 'Responder',
	'POST_REPORTED'			=> 'Clique aqui para ver a denúncia', 
	'POST_SUBJECT'			=> 'Título', 
	'POST_TIME'				=> 'Data da mensagem', 
	'POST_TOPIC'			=> 'Criar um novo tópico',
	'POST_UNAPPROVED'		=> 'Clique aqui para aprovar a mensagem', 
	'PREVIEW'				=> 'Prever', 
	'PREVIOUS'				=> 'Anterior',      // Used in pagination
	'PREVIOUS_STEP'         => 'Anterior',
	'PRIVACY'				=> 'Políticas de privacidade', 
	'PRIVATE_MESSAGE'		=> 'Mensagem particular', 
	'PRIVATE_MESSAGES'		=> 'Mensagens particulares', 
	'PRIVATE_MESSAGING'		=> 'Enviando mensagem particular', 
	'PROFILE'				=> 'Painel de Controle do Usuário', 

	'READING_FORUM'				=> 'Visualizando tópicos em %s', 
	'READING_GLOBAL_ANNOUNCE'	=> 'Lendo anúncio global', 
	'READING_LINK'				=> 'Seguindo endereço do fórum %s',	 
	'READING_TOPIC'				=> 'Lendo tópico em %s', 
	'READ_PROFILE'				=> 'Perfil', 
	'REASON'					=> 'Razão', 
	'RECORD_ONLINE_USERS'		=> 'O recorde de usuários online foi de <b>%1$s</b> em %2$s', 
	'REDIRECT'					=> 'Redirecionar',	 
	'REDIRECTS'					=> 'Total de redirecionamentos', 
	'REGISTER'					=> 'Registrar', 
	'REGISTERED_USERS'			=> 'Usuários registrados:', 
	'REG_USERS_ONLINE'			=> 'Há %d usuários registrados e ', 
	'REG_USERS_TOTAL'			=> '%d usuários registrados, ', 
	'REG_USERS_TOTAL_AND'       => '%d usuários registrados e ',
	'REG_USERS_ZERO_ONLINE'		=> 'Não há usuários registrados e ', 
	'REG_USERS_ZERO_TOTAL'		=> '0 usuários registrados, ', 
	'REG_USERS_ZERO_TOTAL_AND'  => '0 usuários registrados e ',
	'REG_USER_ONLINE'			=> 'Há %d usuário registrado e ', 
	'REG_USER_TOTAL'			=> '%d usuário registrado, ', 
	'REG_USER_TOTAL_AND'        => '%d usuário registrado e ',
	'REMOVE'					=> 'Excluir', 
	'REMOVE_INSTALL'			=> 'Por favor, delete, mova ou renomeie o diretório de instalação antes de utilizar o seu painel. Se este diretório ainda estiver presente, apenas o painel de administração (ACP) estará acessível.',
	'REPLIES'					=> 'Respostas', 
	'REPLY_WITH_QUOTE'			=> 'Responder com citação', 
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Respondendo anúncio global', 
	'REPLYING_MESSAGE'			=> 'Respondendo mensagem em %s', 
	'REPORT_BY'					=> 'Denúncia de', 
	'REPORT_POST'				=> 'Denunciar esta mensagem', 
	'REPORTING_POST'			=> 'Denunciando mensagem', 
	'RESEND_ACTIVATION'			=> 'Reenviar e-mail de ativação',
	'RESET'						=> 'Resetar', 
	'RESTORE_PERMISSIONS'		=> 'Restaurar permissões',	 
	'RETURN_INDEX'				=> '%sClique aqui para voltar ao índice%s', 
	'RETURN_FORUM'				=> '%sClique aqui para voltar ao fórum%s', 
	'RETURN_PAGE'				=> '%sClique aqui para voltar à página anterior%s', 
	'RETURN_TOPIC'				=> '%sClique aqui para voltar ao tópico%s', 
	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'Notícias',
	'RETURN_TO'					=> 'Voltar para', 
	'FEED_TOPICS_ACTIVE'		=> 'Tópicos ativos',
	'FEED_TOPICS_NEW'			=> 'Novos tópicos',
	'RULES_ATTACH_CAN'			=> 'Enviar anexos: <b>Permitido</b>', 
	'RULES_ATTACH_CANNOT'		=> 'Enviar anexos: <b>Proibido</b>', 
	'RULES_DELETE_CAN'			=> 'Excluir mensagens: <b>Permitido</b>', 
	'RULES_DELETE_CANNOT'		=> 'Excluir mensagens: <b>Proibido</b>', 
	'RULES_DOWNLOAD_CAN'		=> 'Baixar anexos: <b>Permitido</b>', 
	'RULES_DOWNLOAD_CANNOT'		=> 'Baixar anexos: <b>Proibido</b>', 
	'RULES_EDIT_CAN'			=> 'Editar mensagens: <b>Permitido</b>', 
	'RULES_EDIT_CANNOT'			=> 'Editar mensagens: <b>Proibido</b>', 
	'RULES_LOCK_CAN'			=> 'Trancar tópicos: <b>Permitido</b>', 
	'RULES_LOCK_CANNOT'			=> 'Trancar tópicos: <b>Proibido</b>', 
	'RULES_POST_CAN'			=> 'Enviar mensagens: <b>Permitido</b>', 
	'RULES_POST_CANNOT'			=> 'Enviar mensagens: <b>Proibido</b>', 
	'RULES_REPLY_CAN'			=> 'Responder mensagens: <b>Permitido</b>', 
	'RULES_REPLY_CANNOT'		=> 'Responder mensagens: <b>Proibido</b>', 
	'RULES_VOTE_CAN'			=> 'Votar em enquetes: <b>Permitido</b>', 
	'RULES_VOTE_CANNOT'			=> 'Votar em enquetes: <b>Proibido</b>', 

	'SEARCH'					=> 'Pesquisar', 
	'SEARCH_MINI'				=> 'Pesquisar…',	 
	'SEARCH_ADV'				=> 'Pesquisa avançada', 
	'SEARCH_ADV_EXPLAIN'		=> 'Ver as opções da pesquisa avançada', 
	'SEARCH_KEYWORDS'			=> 'Pesquisar por palavras-chaves', 
	'SEARCHING_FORUMS'			=> 'Pesquisando nos fóruns', 
	'SELECT_DESTINATION_FORUM'	=> 'Selecione um fórum para destino', 
	'SEARCH_ACTIVE_TOPICS'		=> 'Pesquisar por tópicos ativos', 
	'SEARCH_FOR'				=> 'Procurar por', 
	'SEARCH_FORUM'				=> 'Pesquisar neste fórum…',		 
	'SEARCH_NEW'				=> 'Ver mensagens novas', 
	'SEARCH_POSTS_BY'			=> 'Pesquisar mensagens por',	 
	'SEARCH_SELF'				=> 'Ver as suas mensagens', 
	'SEARCH_TOPIC'				=> 'Pesquisar neste tópico…',	 
	'SEARCH_UNANSWERED'			=> 'Ler mensagens sem resposta', 
	'SEARCH_UNREAD'				=> 'Ver mensagens não lidas',
	'SEARCH_USER_POSTS'			=> 'Pesquisar mensagens do usuário',
	'SECONDS'					=> 'Segundos',	 
	'SELECT'					=> 'Selecionar', 
	'SELECT_ALL_CODE'			=> 'Selecionar todos',
	'SELECT_FORUM'				=> 'Selecione um fórum', 
	'SEND_EMAIL'				=> 'E-mail',			// Used for submit buttons
	'SEND_EMAIL_USER'           => 'E-mail',            // Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Enviar mensagem particular', 
	'SETTINGS'					=> 'Configurações',	 
	'SIGNATURE'					=> 'Assinatura', 
	'SKIP'						=> 'Pular para o conteúdo', 
	'SMTP_NO_AUTH_SUPPORT'		=> 'O servidor do SMTP não suporta autenticação.',
	'SORRY_AUTH_READ'			=> 'Você não está autorizado a visualizar este fórum.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Você não está autorizado a baixar este anexo.', 
	'SORT_BY'					=> 'Ordenar por', 
	'SORT_JOINED'				=> 'Data de registro', 
	'SORT_LOCATION'				=> 'Localização', 
	'SORT_RANK'					=> 'Rank', 
	'SORT_POSTS'				=> 'Mensagens',
	'SORT_TOPIC_TITLE'			=> 'Título do tópico', 
	'SORT_USERNAME'				=> 'Nome de usuário', 
	'SPLIT_TOPIC'				=> 'Dividir tópico', 
	'SQL_ERROR_OCCURRED'		=> 'Um erro SQL ocorreu enquanto processava está página. Contate o %sadministrador%s caso o problema persista.', 
	'STATISTICS'				=> 'Estatísticas', 
	'START_WATCHING_FORUM'		=> 'Subscrever fórum', 
	'START_WATCHING_TOPIC'		=> 'Subscrever tópico', 
	'STOP_WATCHING_FORUM'		=> 'Parar de visualizar este Fórum', 
	'STOP_WATCHING_TOPIC'		=> 'Parar de visualizar este Tópico', 
	'SUBFORUM'					=> 'Sub fórum', 
	'SUBFORUMS'					=> 'Sub fóruns', 
	'SUBJECT'					=> 'Título', 
	'SUBMIT'					=> 'Enviar', 

	'TERMS_USE'			=> 'Termos de uso', 
	'TEST_CONNECTION'	=> 'Testar conexão', 
	'THE_TEAM'			=> 'Equipe do fórum', 
	'TIME'				=> 'Tempo', 

	'TOO_LARGE'						=> 'O valor que você digitou é muito grande.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'O valor para o <strong>Número máximo de destinatários por mensagem privada</strong> que você digitou é muito grande.',

	'TOO_LONG'			=> 'O valor definido é muito longo.',
	'TOO_LONG_AIM'					=> 'O AIM escrito é muito grande.', 
	'TOO_LONG_CONFIRM_CODE'			=> 'O código de confirmação escrito é muito grande.', 
	'TOO_LONG_DATEFORMAT'           => 'O formato da data escrito é muito grande.',
	'TOO_LONG_ICQ'					=> 'O número de ICQ escrito é muito grande.', 
	'TOO_LONG_INTERESTS'			=> 'Os interesses escritos são muito grandes.', 
	'TOO_LONG_JABBER'				=> 'O nome de jabber escrito é muito grande.', 
	'TOO_LONG_LOCATION'				=> 'A localização escrita é muito grande.', 
	'TOO_LONG_MSN'					=> 'O MSNM/WLM escrito é muito grande.', 
	'TOO_LONG_NEW_PASSWORD'			=> 'A senha escrita é muito grande.', 
	'TOO_LONG_OCCUPATION'			=> 'A ocupação escrita é muito grande.', 
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'A confirmação da senha escrita é muito grande.', 
	'TOO_LONG_USER_PASSWORD'		=> 'A senha escrita é muito grande.', 
	'TOO_LONG_USERNAME'				=> 'O nome de usuário escrito é muito grande.', 
	'TOO_LONG_EMAIL'				=> 'O endereço de e-mail escrito é muito grande.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'A confirmação do endereço de e-mail escrita é muito grande.',
	'TOO_LONG_WEBSITE'				=> 'O website escrito é muito grande.', 
	'TOO_LONG_YIM'					=> 'O Yahoo! Messenger escrito é muito grande.', 
	 
	'TOO_MANY_VOTE_OPTIONS'			=> 'Você tentou votar em muitas opções.', 
	'TOO_SHORT'						=> 'O valor definido é muito curto.',
	
	'TOO_SHORT_AIM'					=> 'O AIM escrito é muito pequeno.', 
	'TOO_SHORT_CONFIRM_CODE'		=> 'O código de confirmação escrito é muito pequeno.', 
	'TOO_SHORT_DATEFORMAT'          => 'O formato da data escrito é muito pequeno.',
	'TOO_SHORT_ICQ'					=> 'O número de ICQ escrito é muito pequeno.', 
	'TOO_SHORT_INTERESTS'			=> 'Os interesses escritos são muito pequenos.', 
	'TOO_SHORT_JABBER'				=> 'O nome de jabber escrito é muito pequeno.', 
	'TOO_SHORT_LOCATION'			=> 'A localização escrita é muito pequena.', 
	'TOO_SHORT_MSN'					=> 'O MSNM/WLM escrito é muito pequeno.',	 
	'TOO_SHORT_NEW_PASSWORD'		=> 'A senha escrita é muito pequena.', 
	'TOO_SHORT_OCCUPATION'			=> 'A ocupação escrita é muito pequena.',	 
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'A confirmação da senha escrita é muito pequena.', 
	'TOO_SHORT_USER_PASSWORD'		=> 'A senha escrita é muito pequena.', 
	'TOO_SHORT_USERNAME'			=> 'O nome de usuário escrito é muito pequeno.', 
	'TOO_SHORT_EMAIL'				=> 'O endereço de e-mail escrito é muito pequeno.', 
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'A confirmação do endereço de e-mail escrita é muito pequena.', 
	'TOO_SHORT_WEBSITE'				=> 'O website escrito é muito pequeno.', 
	'TOO_SHORT_YIM'					=> 'O Yahoo! Messenger escrito é muito pequeno.', 
	 	
	'TOO_SMALL'						=> 'O valor que você digitou é muito pequeno.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'O valor para o <strong>Número máximo de destinatários por mensagem privada</strong> que você digitou é muito pequeno.',
	
	'TOPIC'				=> 'Tópico', 
	'TOPICS'			=> 'Tópicos', 
	'TOPICS_UNAPPROVED'	=> 'Pelo menos um tópico neste fórum ainda não foi aprovado.',
	'TOPIC_ICON'		=> 'Ícone do tópico', 
	'TOPIC_LOCKED'		=> 'Este tópico está trancado. Você não pode responder ou editar mensagens.', 
    'TOPIC_LOCKED_SHORT'=> 'Tópico trancado',
	'TOPIC_MOVED'		=> 'Tópico movido', 
	'TOPIC_REVIEW'		=> 'Revisão do tópico', 
	'TOPIC_TITLE'		=> 'Título do tópico', 
	'TOPIC_UNAPPROVED'	=> 'Este tópico não foi aprovado', 
	'TOTAL_ATTACHMENTS'	=> 'Anexo(s)', 
	'TOTAL_LOG'			=> '1 log', 
	'TOTAL_LOGS'		=> '%d logs', 
	'TOTAL_NO_PM'		=> '0 mensagens particulares no total',
	'TOTAL_PM'			=> '1 mensagem particular no total',
	'TOTAL_PMS'			=> '$d mensagens particulares no total',
	'TOTAL_POSTS'		=> 'Total de mensagens', 
	'TOTAL_POSTS_OTHER'	=> 'Total de mensagens <b>%d</b>', 
	'TOTAL_POSTS_ZERO'	=> 'Total de mensagens <b>0</b>', 
	'TOPIC_REPORTED'	=> 'Este tópico foi denunciado',	 
	'TOTAL_TOPICS_OTHER'=> 'Total de tópicos <b>%d</b>', 
	'TOTAL_TOPICS_ZERO'	=> 'Total de tópicos <b>0</b>', 
	'TOTAL_USERS_OTHER'	=> 'Total de membros <b>%d</b>', 
	'TOTAL_USERS_ZERO'	=> 'Total de membros <b>0</b>', 
	'TRACKED_PHP_ERROR'	=> 'Erros PHP encontrados: %s',	 

	'UNABLE_GET_IMAGE_SIZE'	=> 'Não foi possível determinar as dimensões da imagem.', 
	'UNABLE_TO_DELIVER_FILE'=> 'Incapaz de encaminhar arquivo.', 
	'UNKNOWN_BROWSER'		=> 'Navegador desconhecido', 
	'UNMARK_ALL'			=> 'Desselecionar todos', 
	'UNREAD_MESSAGES'		=> 'Mensagens não lidas', 
	'UNREAD_PM'				=> '<b>%d</b> mensagem não lida', 
	'UNREAD_PMS'			=> '<b>%d</b> mensagens não lidas',
	'UNREAD_POST'			=> 'Mensagem não lida',
	'UNREAD_POSTS'			=> 'Mensagens não lidas',
	'UNWATCH_FORUM_CONFIRM'		=> 'Você deseja realmente cancelar a subscrição deste fórum?',
	'UNWATCH_FORUM_DETAILED'	=> 'Você deseja realmente cancelar a subscrição do fórum “%s”?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Você deseja realmente cancelar a subscrição deste tópico?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Você deseja realmente cancelar a subscrição do tópico “%s”?',
	'UNWATCHED_FORUMS'		=> 'Você não está mais subscrito nos fóruns selecionados.',
	'UNWATCHED_TOPICS'		=> 'Você não está mais subscrito nos tópicos selecionados.',
	'UNWATCHED_FORUMS_TOPICS'   => 'Você não está mais subscrito às entradas selecionadas.',
	'UPDATE'				=> 'Atualizar',
	'UPLOAD_IN_PROGRESS'	=> 'O envio está atualmente em progresso.', 
	'URL_REDIRECT'			=> 'Se o seu navegador não suporta redirecionamentos, por favor, %sclique AQUI para ser redirecionado%s.',
	'USERGROUPS'			=> 'Grupos', 
	'USERNAME'				=> 'Nome de usuário', 
	'USERNAMES'				=> 'Nomes de usuários', 
	'USER_AVATAR'			=> 'Avatar do usuário', 
	'USER_CANNOT_READ'		=> 'Você não pode ler mensagens neste fórum.',
	'USER_POST'				=> '%d Mensagem', 
	'USER_POSTS'			=> '%d Mensagens', 
	'USERS'					=> 'Usuários', 
	'USE_PERMISSIONS'		=> 'Testar permissões do usuário',	 
	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Desculpe, mas você não está autorizado a usar este recurso. Você se registrou recentemente em nossos fóruns e precisa participar um pouco mais para poder utilizá-lo.',
	
	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Visto', 
	'VIEWING_FAQ'				=> 'Vendo FAQ - Questões mais frequentes', 
	'VIEWING_MEMBERS'			=> 'Vendo informações de usuário', 
	'VIEWING_ONLINE'			=> 'Vendo quem está online', 
	'VIEWING_MCP'				=> 'Vendo painel de moderação', 
	'VIEWING_MEMBER_PROFILE'	=> 'Visualizando perfil',		 
	'VIEWING_PRIVATE_MESSAGES'	=> 'Vendo mensagens particulares', 
	'VIEWING_REGISTER'			=> 'Registrando-se no fórum',	 
	'VIEWING_UCP'				=> 'Vendo painel de controle do usuário', 
	'VIEWS'						=> 'Exibições', 
	'VIEW_BOOKMARKS'			=> 'Ver favoritos', 
	'VIEW_FORUM_LOGS'			=> 'Vendo logs', 
	'VIEW_LATEST_POST'			=> 'Ver última mensagem',
	'VIEW_NEWEST_POST'			=> 'Ver mensagens novas',
	'VIEW_NOTES'				=> 'Ver notas do usuário', 
	'VIEW_ONLINE_TIME'			=> 'Esta informação é baseada em usuários ativos no último minuto', 
	'VIEW_ONLINE_TIMES'			=> 'Esta informação é baseada em usuários ativos nos últimos %d minutos', 
	'VIEW_TOPIC'				=> 'Exibir tópico', 
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Anúncio: ', 
	'VIEW_TOPIC_GLOBAL'			=> 'Anúncio Global: ',	 
	'VIEW_TOPIC_LOCKED'			=> 'Trancado: ', 
	'VIEW_TOPIC_LOGS'			=> 'Ver logs', 
	'VIEW_TOPIC_MOVED'			=> 'Movido: ', 
	'VIEW_TOPIC_POLL'			=> 'Enquete: ', 
	'VIEW_TOPIC_STICKY'			=> 'Tópico Fixo: ', 
	'VISIT_WEBSITE'				=> 'Visitar website do usuário',	 

	'WARNINGS'			=> 'Advertências', 
	'WARN_USER'			=> 'Advertir o usuário', 
	'WATCH_FORUM_CONFIRM'	=> 'Você deseja realmente subscrever este fórum?',
	'WATCH_FORUM_DETAILED'	=> 'Você deseja realmente subscrever o fórum “%s”?',
	'WATCH_TOPIC_CONFIRM'	=> 'Você deseja realmente subscrever este tópico?',
	'WATCH_TOPIC_DETAILED'	=> 'Você deseja realmente subscrever o tópico “%s”?',
	'WELCOME_SUBJECT'	=> 'Bem-vindo ao fórum %s', 
	'WEBSITE'			=> 'Website', 
	'WHOIS'				=> 'Quem', 
	'WHO_IS_ONLINE'		=> 'Quem está online', 
	'WRONG_PASSWORD'	=> 'Você escreveu uma senha incorreta.', 

	'WRONG_DATA_ICQ'			=> 'O número ICQ informado não é válido.', 
	'WRONG_DATA_JABBER'			=> 'O nome de jabber informado não é válido.', 
	'WRONG_DATA_LANG'			=> 'A linguagem informada não é válida.', 
	'WRONG_DATA_WEBSITE'		=> 'O endereço do website informado não é uma URL válida, incluindo o protocolo. Por exemplo, http://www.suportephpbb.com.br/.',
    'WROTE'						=> 'escreveu',

	'YEAR'				=> 'Ano', 
	'YEAR_MONTH_DAY'	=> '(DD-MM-YYYY)',	
	'YES'				=> 'Sim', 
	'YIM'				=> 'YIM',	 
	'YOU_LAST_VISIT'	=> 'A sua última visita foi em %s', 
	'YOU_NEW_PM'		=> 'Uma nova mensagem particular está lhe aguardando em sua caixa de entrada.',
	'YOU_NEW_PMS'		=> 'Novas mensagens particulares estão lhe aguardando em sua caixa de entrada.',
	'YOU_NO_NEW_PM'		=> 'Nenhuma mensagem particular está lhe aguardando em sua caixa de entrada.',

	'datetime'			=> array( 
		'TODAY'		=> 'Hoje',
		'TOMORROW'	=> 'Amanhã',
		'YESTERDAY'	=> 'Ontem', 

		'AGO'		=> array(
			0		=> 'menos de um minuto atrás',
			1		=> '%d minuto atrás',
			2		=> '%d minutos atrás',
			60		=> '1 hora atrás',
		),
		
		'Sunday'	=> 'Domingo', 
		'Monday'	=> 'Segunda-feira', 
		'Tuesday'	=> 'Terça-feira', 
		'Wednesday'	=> 'Quarta-feira', 
		'Thursday'	=> 'Quinta-feira', 
		'Friday'	=> 'Sexta-feira', 
		'Saturday'	=> 'Sábado', 

		'Sun'		=> 'Dom', 
		'Mon'		=> 'Seg', 
		'Tue'		=> 'Ter', 
		'Wed'		=> 'Qua', 
		'Thu'		=> 'Qui', 
		'Fri'		=> 'Sex', 
		'Sat'		=> 'Sáb', 

		'January'	=> 'Janeiro', 
		'February'	=> 'Fevereiro', 
		'March'		=> 'Março', 
		'April'		=> 'Abril', 
		'May'		=> 'Maio', 
		'June'		=> 'Junho', 
		'July'		=> 'Julho', 
		'August'	=> 'Agosto', 
		'September' => 'Setembro', 
		'October'	=> 'Outubro', 
		'November'	=> 'Novembro', 
		'December'	=> 'Dezembro', 

		'Jan'		=> 'Jan', 
		'Feb'		=> 'Fev', 
		'Mar'		=> 'Mar', 
		'Apr'		=> 'Abr', 
		'May_short'	=> 'Mai',	// Short representation of "May". May_short used because in english the short and long date are the same for May.		 
		'Jun'		=> 'Jun', 
		'Jul'		=> 'Jul', 
		'Aug'		=> 'Ago', 
		'Sep'		=> 'Set', 
		'Oct'		=> 'Out', 
		'Nov'		=> 'Nov', 
		'Dec'		=> 'Dez', 

	), 

	'tz'				=> array( 
		'-12'	=> 'GMT - 12 horas', 
		'-11'	=> 'GMT - 11 horas', 
		'-10'	=> 'GMT - 10 horas', 
		'-9'	=> 'GMT - 9 horas', 
		'-8'	=> 'GMT - 8 horas', 
		'-7'	=> 'GMT - 7 horas', 
		'-6'	=> 'GMT - 6 horas', 
		'-5'	=> 'GMT - 5 horas', 
		'-4.5'	=> 'GMT - 4.5 horas',
		'-4'	=> 'GMT - 4 horas', 
		'-3.5'	=> 'GMT - 3.5 horas', 
		'-3'	=> 'GMT - 3 horas', 
		'-2'	=> 'GMT - 2 horas', 
		'-1'	=> 'GMT - 1 hora', 
		'0'		=> 'GMT', 
		'1'		=> 'GMT + 1 hora', 
		'2'		=> 'GMT + 2 horas', 
		'3'		=> 'GMT + 3 horas', 
		'3.5'	=> 'GMT + 3.5 horas', 
		'4'		=> 'GMT + 4 horas', 
		'4.5'	=> 'GMT + 4.5 horas', 
		'5'		=> 'GMT + 5 horas', 
		'5.5'	=> 'GMT + 5.5 horas', 
		'6'		=> 'GMT + 6 horas', 
		'6.5'	=> 'GMT + 6.5 horas', 
		'7'		=> 'GMT + 7 horas', 
		'8'		=> 'GMT + 8 horas', 
		'9'		=> 'GMT + 9 horas', 
		'9.5'	=> 'GMT + 9.5 horas', 
		'10'	=> 'GMT + 10 horas', 
		'11'	=> 'GMT + 11 horas', 
		'12'	=> 'GMT + 12 horas', 
		'dst'	=> '[ <abbr title="Horário de verão">DST</abbr> ]', 
	), 

	'tz_zones'	=> array( 
		'-12'	=> '[GMT-12] Eniwetok, Kwaialein', 
		'-11'	=> '[GMT-11] Midway Island, Samoa', 
		'-10'	=> '[GMT-10] Hawaii, Honolulu', 
		'-9'	=> '[GMT-9] Alaska', 
		'-8'	=> '[GMT-8] Anchorage, Los Angeles, San Francisco, Seattle', 
		'-7'	=> '[GMT-7] Denver, Edmonton, Phoenix, Salt Lake City, Santa Fe', 
		'-6'	=> '[GMT-6] Chicago, Guatamala, Mexico City, Saskatchewan East', 
		'-5'	=> '[GMT-5] Bogota, Kingston, Lima, New York', 
		'-4.5'	=> '[GMT-4.5] Venezuela',
		'-4'	=> '[GMT-4] Caracas, Labrador, La Paz, Maritimes, Santiago', 
		'-3.5'	=> '[GMT-3.5] Standard Time [Canada], Newfoundland', 
		'-3'	=> '[GMT-3] Brasília, Buenos Aires, Georgetown, Rio de Janeiro', 
		'-2'	=> '[GMT-2] Mid-Atlantic', 
		'-1'	=> '[GMT-1] Azores, Cape Verde Is.', 
		'0'		=> '[GMT] Dublin, Edinburgh, Iceland, Lisbon, London, Casablanca', 
		'1'		=> '[GMT+1] Amsterdam, Berlin, Bern, Brussells, Madrid, Paris, Rome, Oslo, Vienna', 
		'2'		=> '[GMT+2] Athens, Bucharest, Harare, Helsinki, Israel, Istanbul', 
		'3'		=> '[GMT+3] Ankara, Baghdad, Bahrain, Beruit, Kuwait, Moscow, Nairobi, Riyadh', 
		'3.5'	=> '[GMT+3.5] Iran', 
		'4'		=> '[GMT+4] Abu Dhabi, Kabul, Muscat, Tbilisi, Volgograd', 
		'4.5'	=> '[GMT+4.5] Afghanistan', 
		'5'		=> '[GMT+5] Calcutta, Madras, New Dehli', 
		'5.5'	=> '[GMT+5.5] India', 
		'6'		=> '[GMT+6] Almaty, Dhakar, Kathmandu', 
		'6.5'	=> '[GMT+6.5] Rangoon', 
		'7'		=> '[GMT+7] Bangkok, Hanoi, Jakarta, Phnom Penh', 
		'8'		=> '[GMT+8] Beijing, Hong Kong, Kuala Lumpar, Manila, Perth, Singapore, Taipei', 
		'9'		=> '[GMT+9] Osaka, Sapporo, Seoul, Tokyo, Yakutsk', 
		'9.5'	=> '[GMT+9.5] Adelaide, Darwin', 
		'10'	=> '[GMT+10] Brisbane, Canberra, Guam, Hobart, Melbourne, Port Moresby, Sydney', 
		'11'	=> '[GMT+11] Magadan, New Caledonia, Solomon Is.', 
		'12'	=> '[GMT+12] Auckland, Fiji, Kamchatka, Marshall Is., Suva, Wellington' 
	), 

	// The value is only an example and will get replaced by the current time on view 
	'dateformats'	=> array( 
		'd M Y, H:i'			=> '01 Jan 2008, 17:37',
		'd M Y H:i'				=> '01 Jan 2008 17:37',
		'M jS, \'y, H:i'		=> 'Jan 1st, \'07, 17:37',
		'D M d, Y g:i a'		=> 'Seg Jan 01, 2008 5:37 pm',
		'F jS, Y, g:i a'		=> 'Janeiro 1st, 2008, 5:37 pm',
		'|d M Y|, H:i'			=> 'Hoje, 17:37 / 01 Jan 2008, 17:37',
		'|F jS, Y|, g:i a'		=> 'Hoje, 5:37 pm / Janeiro 1st, 2008, 5:37 pm'
	), 

	// The default dateformat which will be used on new installs in this language 
	// Translators should change this if a the usual date format is different 
	'default_dateformat'	=> 'D M d, Y h:i', // Mon Jan 01, 2008 5:37 pm 

)); 
?>