<?php
  /**************************************************************************\
  * phpGroupWare Application (Napster)                                       *
  * http://www.phpgroupware.org                                              *
  * Written by Mark Peters <mpeters@satx.rr.com>                             *
  * Based on WebNap Client copyright 2000                                    *
  * Written by Aakash Kambuj <aakash@idearing.com>                           *
  *            Kalpak Kothari <kalpak@idearing.com>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  * --------------------------------------------                             *
  * Napster is a registered trademark of Napster Inc  http://www.napster.com *
  \**************************************************************************/

  /* $Id: searchmp3.php,v 1.6 2001/09/28 22:46:41 milosch Exp $ */

	$GLOBALS['phpgw_info']['flags']['currentapp'] = 'napster';
	$GLOBALS['phpgw_info']['flags']['enable_network_class'] = True;
	include('../header.inc.php');

	function close_routine()
	{
		$GLOBALS['phpgw']->network->close_port();
	}

	$napserver  = $HTTP_POST_VARS['napserver'];
	$linespeed  = $HTTP_POST_VARS['linespeed'];
	$linktype   = $HTTP_POST_VARS['linktype'];
	$keywords   = $HTTP_POST_VARS['keywords'];
	$nofirewall = $HTTP_POST_VARS['nofirewall'];

	$browser = CreateObject('napster.browserdetector');
	$bd = $browser->isIEorMozilla();
	$bdlynx = $browser->isLynx();
	unset($browser);

	$napster = CreateObject('napster.napster');

	register_shutdown_function('close_routine');

	if(!isset($napserver))
	{
		$napster->napserver = $napster->servers['imperialfleet.com'];
	}
	else
	{
		$napster->napserver = urldecode($napserver);
	}

	if(!isset($linespeed))
	{
		$napster->linespeed = 'AT BEST';
	}
	else
	{
		$napster->linespeed = urldecode($linespeed);
	}

	if(!isset($linktype))
	{
		$napster->linktype = 10;
	}
	else
	{
		$napster->linktype = urldecode($linktype);
	}

	if(!isset($nofirewall))
	{
		$napster->nofirewall = 0;
	}
	else
	{
		$napster->nofirewall = $nofirewall;
	}

	if (isset($keywords))
	{
		$GLOBALS['phpgw']->template->set_file(array(
			'search_result_header'       => 'search_result_header.tpl',
			'search_result_table_header' => 'search_result_table_header.tpl',
			'search_form'                => 'search.tpl',
			'motd'                       => 'motd.tpl',
			'search_result_table_footer' => 'search_result_table_footer.tpl'
		));

		$GLOBALS['phpgw']->template->set_block('search_result_header','search_result_table_header','search_form','motd','search_result_table_footer');

		$GLOBALS['phpgw']->template->set_var('keywords',$keywords);
		$GLOBALS['phpgw']->template->set_var('napserver',$napster->get_key($napster->napserver,$napster->servers));
		$GLOBALS['phpgw']->template->parse('out','search_result_header',true);

		$GLOBALS['phpgw']->template->parse('out','search_result_table_header',true);

		if(!$napster->init_conn())
		{
//			$GLOBALS['phpgw']->template->p('out');
			$GLOBALS['phpgw']->template->parse('out','search_result_table_footer',true);
			$GLOBALS['phpgw']->common->phpgw_footer();
			$GLOBALS['phpgw']->common->phpgw_exit();
		}

		$GLOBALS['phpgw']->template->parse('out','search_result_table_header',true);

		$GLOBALS['phpgw']->template->set_var('action_url',$GLOBALS['phpgw']->link('/napster/searchmp3.php'));
		$GLOBALS['phpgw']->template->set_var('search_word',lang('Search'));
		$GLOBALS['phpgw']->template->set_var('help_url',$GLOBALS['phpgw']->link('/napster/help.php'));
		$GLOBALS['phpgw']->template->set_var('help_word',lang('Help'));
		$GLOBALS['phpgw']->template->set_var('queue_url',$GLOBALS['phpgw']->link('/napster/queue.php','list=1'));
		$GLOBALS['phpgw']->template->set_var('queue_word',lang('Queue'));
		$GLOBALS['phpgw']->template->set_var('charts_url',$GLOBALS['phpgw']->link('/napster/mp3chart.php','napserver='.$napster->napserver
			.'&linespeed='.$napster->linespeed.'&linktype='.$napster->linktype
			.'&nofirewall='.$napster->nofirewall));
		$GLOBALS['phpgw']->template->set_var('charts_word',lang('Charts'));
		$GLOBALS['phpgw']->template->set_var('keywords',$keywords);
		$GLOBALS['phpgw']->template->set_var('napserver_list',$napster->select_options($napster->napserver,$napster->servers,0));
		$GLOBALS['phpgw']->template->set_var('linespeed_list',$napster->select_options($napster->linespeed,$napster->comparators,0));
		$GLOBALS['phpgw']->template->set_var('linktype_list',$napster->select_options($napster->linktype,$napster->speeds,1));
		$GLOBALS['phpgw']->template->set_var('firewall_filter_word',lang('Firewall Filter'));
		$GLOBALS['phpgw']->template->set_var('slow_word',lang('Slow'));
		$GLOBALS['phpgw']->template->set_var('firewall_checked',($napster->nofirewall ? 'checked' : ''));
		$GLOBALS['phpgw']->template->set_var('go_word',lang('Go'));
		$GLOBALS['phpgw']->template->set_var('server_stat_url',$GLOBALS['phpgw']->link('/napster/servers.php','getstats=1'));
		$GLOBALS['phpgw']->template->parse('out','search_form',true);

		$GLOBALS['phpgw']->template->parse('out','search_result_table_footer',true);

		$GLOBALS['phpgw']->template->set_var('bgcolor',$GLOBALS['phpgw_info']['theme']['th_bg']);
		$GLOBALS['phpgw']->template->set_var('row_on_color',$GLOBALS['phpgw_info']['theme']['row_on']);
		$GLOBALS['phpgw']->template->set_var('motd_text',$napster->motd());
		$GLOBALS['phpgw']->template->parse('out','motd',true);
		$napster->in_motd=0;

		$GLOBALS['phpgw']->template->parse('out','search_result_table_footer',true);

		$GLOBALS['phpgw']->template->p('out');

		$napster->searchmp3($keywords, 0);
	}

	$GLOBALS['phpgw']->common->phpgw_footer();
?>

