<?php
/**
 * This file contains all of the administrative functions
 * for the calendar. It is included from calendar.php 
 * only when the admin is logged in.
 * 
 * 
 *
 * @module cal_functions
 * @modulegroup admin
 * @package Calendar
 * @author Matthew McNaney
 */
 
/**
 * Function that returns the admin to the menu
 */
function back_to_admin(){
global $tran;
	$stuff = "<div align=\"center\"><a href=\"calendar.php?op=mainmenu\">$tran[Return_to_calendar_admin]</a></div>";
	return $stuff;
}

/**
 * Displays the form screen to create a category.
 * 
 * This function handles both the creation and editing of
 * a category. The existence of the cat_id variable calls
 * editing portions. Uses globals instead of passing
 * variables as it was easier for its dual functionality
 * and error checking.
 *
 * @param cat_id: the unique id of the category. if present, user edits a category
 * @param category: the name of the category
 * @param description: description
 * @param image_name: file name of the image associated with category
 * @param email: contact email address for category
 * @param error: bool value signaling an error with the input
 * @param cat_error: bool value signaling missing category input
 * @param email_error: bool value signaling misentered email address
 * @param tran: array of translation text
 */
function cat_admin()
{
global $cat_id, $category, $description, $image_name, $email, $error, $cat_error, $email_error, $tran;

include ("header.php");
include ("config.php");
include ("plug-ins/calendar/calendar_config.php");

$content .= "
<form action=\"calendar.php\" method=\"post\" enctype=\"multipart/form-data\">
<input type=\"hidden\" name=\"op\" value=\"cat_action\" />";

if ($cat_id){
	$sql_result = mysql_query ("select * from mod_calendar_category where cat_id='$cat_id'");
	if (!$error) {
		if ($image_name)
			$image_name_temp = $image_name;
		$row = mysql_fetch_array($sql_result);
		extract($row);
		if ($image_name_temp)
			$image_name = $image_name_temp;
	}
	$content .=  "
	<input type=\"hidden\" name=\"cat_id\" value=\"$cat_id\" />";
}


if ($cat_id)
	$box_title = "$tran[Edit] $tran[cat_name]: $category";
else
	$box_title = "$tran[Add] $tran[cat_name]";


$content .=  "
<table cellspacing=\"0\" cellpadding=\"4\" border=\"0\" width=\"100%\">
<tr>
	<td valign=\"top\">Image:</td>
	<td>";
$content .= select_image($image_name);
$content .= "
	</td>
</tr>
<tr>
	<td";

if ($cat_error)
	$content .= " class=\"$error_color\"";

$content .= ">$tran[cat_name] $tran[Name]:
	</td>
	<td align=\"left\"";

if ($cat_error)
	$content .= " class=\"$error_color\"";

$content .= ">
	<input type=\"text\" name=\"category\" size=\"30\" maxlength=\"30\" value=\"$category\" />
	</td>
</tr>
<tr>
	<td valign=\"top\">$tran[Description]
	</td>
	<td align=\"left\">
	<textarea name=\"description\" rows=\"4\" cols=\"30\">".unparse_text($description)."</textarea>
	</td>
</tr>
<tr>
	<td";

if ($email_error)
	$content .= " class=\"$error_color\"";

$content .= ">
	$tran[Contact_Email_Address]:
	</td>
	<td align=\"left\"";

if ($email_error)
	$content .= " class=\"$error_color\"";

$content .= ">
	<input type=\"text\" name=\"email\" size=\"30\" value=\"$email\" />
	</td>
</tr>
<tr>
	<td colspan=\"2\" align=\"center\"";

if ($error)
	$content .= " class=\"$error_color\"> $tran[The_highlighted_field].";
else
	$content .= ">&nbsp;";

$content .= "</td>
</tr>
<tr>
	<td align=\"center\" colspan=\"2\">";

if ($cat_id)
	$content .= "
	<input type=\"submit\" value=\"$tran[Update]\" />";
else
	$content .= "
	<input type=\"submit\" value=\"$tran[Add]\" />";

$content .= "
	</td>
</tr>
</table>
</form>";

$error = $cat_error = $email_error = 0;
$content .= back_to_admin();

thememainbox ($box_title, $content);
## End of cat_admin ##
}

/**
 * Enters form data from cat_admin into database.
 * 
 * This function checks the validity of the form
 * data and returns a '1' with the $error along
 * with the component that caused the error.
 *
 * @param cat_id: the unique id of the category
 * @param category: the name of the category
 * @param description: description
 * @param image_name: file name of the image associated with category
 * @param email: contact email address for category
 * @param error: bool value signaling an error with the input
 * @param cat_error: bool value signaling missing category input
 * @param email_error: bool value signaling misentered email address
 */
function cat_action (){

global $category, $description, $image_name, $email, $error, $cat_error, $email_error, $cat_id, $tran;

include ("plug-ins/calendar/calendar_config.php");

if (!strlen($category) )
	$cat_error=1;
else
	$cat_error=0;

if ($email){
	$email_check = strstr($email, "@") ;
	if($email_check)
		$email_error=0;
	else
		$email_error=1;
}

if (!$cat_error && !$email_error)
	$error = 0;
else
	$error = 1;

$description = parse_text($description);

if ($error)
	cat_admin($cat_id);	
else {
	if($cat_id) {
		mysql_query ("	update mod_calendar_category 
				set category='$category', description='$description', 
				image_name='$image_name', email='$email' 
				where cat_id=$cat_id");
		$error=0;
		header("Location: ./calendar.php?op=mainmenu&note=$tran[cat_name]+successfully+updated.");
	} else {
		mysql_query ("	insert into mod_calendar_category 
				(category, description, email, image_name) values 
				('$category', '$description', '$email', '$image_name') 
				");
		$error=0;
		header("Location: ./calendar.php?op=mainmenu&note=$tran[cat_name]+successfully+created.");
	}
}

#End of cat_action

}
/**
 * Displays form for creation or editing of a subcategory
 * 
 * Works much like cat_admin. Editing based on the passing
 * of the $subcat_id otherwise it allows creation. Uses globals
 * as well.
 * 
 * @param cat_id: the id of the category the subcategory is under
 * @param subcat_id: the unique id of the subcategory. if present, user edits that subcat
 * @param subcat: the name of the subcategory
 * @param description: description
 * @param image_name: file name of the image associated with subcategory
 * @param email: contact email address for subcategory
 * @param error: bool value signaling an error with the input
 * @param subcat_error: bool value signaling missing subcategory input
 * @param email_error: bool value signaling mis-entered email address
 * @param tran: an array of translation text
 */

function subcat_admin()
{
include ("header.php");
include ("plug-ins/calendar/calendar_config.php");
global $subcat, $description, $image_name, $email, $error, $subcat_error, $email_error, $subcat_id, $cat_id, $tran;

if ($subcat_id && $error != 1) {
	$sql_result = mysql_query ("select * from mod_calendar_subcat where subcat_id=$subcat_id");
	$row = mysql_fetch_array($sql_result);
	if (!strlen($cat_id))
		$cat_id = $row[cat_id];
	$subcat = $row[subcat];
	$description = $row[description];
	if (!$image_name)
		$image_name = $row[image_name];
	$email = $row[email];
}


$sql_result = mysql_query("select category from mod_calendar_category where cat_id=$cat_id");
list($category) = mysql_fetch_row($sql_result);

if ($subcat_id)
	$box_title = "$category: $tran[Edit] $tran[subcat_name]";
else
	$box_title = "$category: $tran[Add] $tran[subcat_name]";


$content .= "
<form action=\"calendar.php\" method=\"post\" enctype=\"multipart/form-data\">
<input type=\"hidden\" name=\"op\" value=\"subcat_action\" />";

if ($subcat_id)
	$content .= "
<input type=\"hidden\" name=\"subcat_id\" value=\"$subcat_id\" />";

$content .= "
<input type=\"hidden\" name=\"cat_id\" value=\"$cat_id\">
<table cellspacing=\"0\" cellpadding=\"3\" border=\"0\" width=\"100%\">
<tr>
	<td>$tran[Image]:</td>
	<td>";
$content .= select_image($image_name);
$content .= "
	</td>
</tr>
<tr>
	<td";

if ($subcat_error)
	$content .= " class=\"$error_color\"";

$content .= ">$tran[subcat_name] $tran[name]:</td>
	<td";

if ($subcat_error)
	$content .= " class=\"$error_color\"";

$content .= 	">
	<input type=\"text\" name=\"subcat\" size=\"25\" maxlength=\"30\" value=\"$subcat\" />
	</td>
</tr>
<tr>
	<td valign=\"top\">
	$tran[Description]
	</td>
        <td>
	<textarea name=\"description\" rows=\"4\" cols=\"25\" wrap=\"soft\">".unparse_text($description)."</textarea>
	</td>
</tr>
<tr>
	<td";

if ($email_error)
	$content .= " class=\"$error_color\"";

$content .= 	">
	$tran[Contact_Email_Address]:
	</td>
	<td";

if ($email_error)
	$content .= " class=\"$error_color\"";

$content .= ">
	<input type=\"text\" name=\"email\" size=\"25\" maxlength=\"30\" value=\"$email\" />
	</td>
</tr>";

if ($error)
	$content .="
<tr>
	<td colspan=\"2\" class=\"$error_color\">
	$tran[The_highlighted_field].
	</td>
</tr>";

else
	$content .= "
<tr>
	<td colspan=\"2\">&nbsp;</td>
</tr>";

$content .= "
<tr>
	<td colspan=\"2\" align=\"center\">";

if ($subcat_id)
	$content .= "
	<input type=\"submit\" value=\"$tran[Edit] $tran[subcat_name]\" />";
else
	$content .= "
	<input type=\"submit\" value=\"$tran[Add] $tran[subcat_name]\" />";

$content .= "
	</td>
</tr>
</table
</form>
<br />";

$content .= back_to_admin();
thememainbox($box_title,$content);
##End of subcat_admin()
}

/**
 * Updates or adds subcategory to the database
 * 
 * Like cat_action, this file checks for errors and
 * returns them to subcat_admin. Otherwise, it
 * writes the database entry
 * 
 * @param cat_id: the id of the category the subcategory is under
 * @param subcat_id: the unique id of the subcategory
 * @param subcat: the name of the subcategory
 * @param description: description
 * @param image_name: file name of the image associated with subcategory
 * @param email: contact email address for subcategory
 * @param error: bool value signaling an error with the input
 * @param subcat_error: bool value signaling missing subcategory input
 * @param email_error: bool value signaling mis-entered email address
 * @param tran: an array of translation text
 */

function subcat_action ($subcat_id) {

global $subcat, $description, $image_name, $email, $error, $subcat_error, $email_error, $cat_id, $tran;

include ("plug-ins/calendar/calendar_config.php");

if (!strlen($subcat) )
	$subcat_error=1;
else
	$subcat_error=0;

if ($email){
	$email_check = strstr($email, "@") ;
	if(strlen ($email_check) > 0)
		$email_error=0;
	else
		$email_error=1;
}

if (!$subcat_error && !$email_error)
	$error = 0;
else
	$error = 1;
$description = parse_text($description);

if ($error)
	subcat_admin($subcat_id);

else {
	if ($subcat_id){
		mysql_query ("	update mod_calendar_subcat 
				set 
				subcat='$subcat', description='$description', email='$email', 
				image_name='$image_name', cat_id='$cat_id' where subcat_id=$subcat_id");

		header("Location: ./calendar.php?op=mainmenu&note=$tran[subcat_name]+successfully+updated.");
	} else {
		mysql_query 	("insert into mod_calendar_subcat 
				(subcat, description,  email, image_name, cat_id) 
				values 
				('$subcat', '$description', '$email', '$image_name', $cat_id) 
				");

		header("Location: ./calendar.php?op=mainmenu&note=$tran[subcat_name]+successfully+created");
	}
}


## End of subcat_action ##
}

/**
 * Creates or updates an event.
 *
 * The meat of the program happens in this file.
 * You enter in all the variables to the event including
 * what category/subcategory (or not) it is associated
 * with, where it takes place and when, etc. Note that this
 * function handles both adds and edits.
 * You can also choose to post the event to the article
 * section on a certain date.
 * At the bottom of the form you can cause the event
 * to repeat. This information is stored with the source
 * event (unlike the previous version).
 *
 * @param event_id: the unique id of the event. if present, it updates that event
 * @param allday: determines whether the event goes all day, continues after a start time, or has a beginning and an end.
 * @param image_name: file of the image attached to event
 * @param title: name of the event
 * @param description
 * @param event_date: date of the event
 * @param loc_id: unique id of the location
 * @param error: bool value determining whether an error exists
 * @param date_error: bool value showing a date error
 * @param title_error: bool value showing a missing title
 * @param time_error: bool value showing a mismatched time
 * @param associate: indicates whether event is associated with a category or subcat
 * @param starttime: starting time of event, blank in allday mode
 * @param endtime: ending time of event, blank if allday or no ending time indicated
 * @param edit_switch: bool value indicating the user is editing
 * @param repeat_event: bool value that allows usage of repeat choices
 * @param repeat_type: text value telling what type of repeat the event uses
 * @param rpt_sun: bool value indicating a sunday repeat
 * @param rpt_mon: bool value indicating a monday repeat
 * @param rpt_tue: bool value indicating a tuesday repeat
 * @param rpt_wed: bool value indicating a wednesday repeat
 * @param rpt_thu: bool value indicating a thursday repeat
 * @param rpt_fri: bool value indicating a friday repeat
 * @param rpt_sat: bool value indicating a saturday repeat
 * @param month_repeat_type: indicates whether to repeat on the event date or at the end of each month
 * @param repeat_week_error: bool value indicated an user did not enter a weekday to repeat
 * @param end_repeat_error: date to end repeating events
 * @param tran: array of translation text
 * @param post_start: day to post article
 * @param post_end: day to end article
 * @param post_event: switch to allow posting of event as article
 * @param post_error: bool value indictating the user entered faulty post dates
 * @param topic : topic number used to post articles
 */

function event_admin(){

include ("header.php");
include ("plug-ins/calendar/calendar_config.php");
include ("plug-ins/calendar/language.php");

$sql_result = mysql_query("select time_format from mod_calendar_settings");
list($time_format) = mysql_fetch_row($sql_result);

$date_order = format_date (NULL,"date_order");

/**
 * While not the cleanest way to handle all the variables, this was the easiest
 * for me. This allows graceful error recovery back at the form page
 *
 */

global 	$event_id, $allday, $cat_id, $subcat_id, $image_name, $title, $description, $event_date, $loc_id,
	$error, $date_error, $title_error, $time_error, $associate, $starttime, $endtime, $edit_switch, $repeat_event,
	$repeat_type, $rpt_sun, $rpt_mon, $rpt_tue, $rpt_wed, $rpt_thur, $rpt_fri, $rpt_sat, $month_repeat_type,
	$repeat_week_error, $end_repeat_error, $end_repeat, $tran, $post_start, $post_end, $post_event, $post_error, $topic;

/**
 * This checks to see if this is a new event or an edited event. If
 * we are returning from an error, the database is not reloaded.
 */

if ($event_id > 0 && $edit_switch != 1) {
	if (strlen($image_name))
		$image_name_temp = $image_name;

	$sql_result = mysql_query("select * from mod_calendar_events where event_id='$event_id'");
	$row = mysql_fetch_array ($sql_result);
	extract ($row);
	if ($image_name_temp)
		$image_name = $image_name_temp;
	if ($repeat_type)
		$repeat_event = 1;

	$rpt_days = explode (":",$repeat_week_day);
	list ($rpt_sun, $rpt_mon, $rpt_tue, $rpt_wed, $rpt_thur, $rpt_fri, $rpt_sat) = array_values($rpt_days);

	$post_result = mysql_query("select * from mod_calendar_post where post_event_id='$event_id'");
	if (mysql_num_rows($post_result)){
		$post_event = 1;
		$row = mysql_fetch_array ($post_result);
		extract ($row);
	}

}

if ($event_id > 0){
	$box_title = "
<table width=\"100%\">
<tr>
	<td>$tran[Edit_Event]</td>
	<td align=\"right\">
	<form action=\"calendar.php\" method=\"post\">
	<input type=\"hidden\" name=\"op\" value=\"event_admin\" />
	<input type=\"hidden\" name=\"event_id\" value=\"$event_id\" />
	<input type=\"submit\" name=\"delete_event\" value=\"$tran[Delete_Event]\" />
	</form>
	</td>
</tr>
</table>";
}
else{
	$box_title = "
<table width=\"100%\">
<tr>
	<td>$tran[Create_Event]</td>
</tr>
</table>";
}

if ($end_repeat) {
	$end_rpt_year = substr($end_repeat,0,4);
	$end_rpt_month = substr($end_repeat,4,2);
	$end_rpt_day = substr($end_repeat,6,2);
} else {
	$end_rpt_year= date_now(Y);
	$end_rpt_month=date_now(m);
	$end_rpt_day=date_now(d);
}

if ($post_start) {
	$post_start_year = substr($post_start,0,4);
	$post_start_month = substr($post_start,4,2);
	$post_start_day = substr($post_start,6,2);
} else {
	$post_start_year= date_now(Y);
	$post_start_month= date_now(m);
	$post_start_day= date_now(d);
}

if ($post_end) {
	$post_end_year = substr($post_end,0,4);
	$post_end_month = substr($post_end,4,2);
	$post_end_day = substr($post_end,6,2);
} else {
	$post_end_year= date_now(Y);
	$post_end_month= date_now(m);
	$post_end_day= date_now(d);
}

if (strlen($associate) < 1) {
	if ($cat_id && $subcat_id)
		$associate = "sub";
	else if ($cat_id)
		$associate = "cat";
	else
		$associate = "none";
}
if ($event_date){
	$year= substr ($event_date, 0, 4);
	$month=substr ($event_date, 4, 2);
	$day=substr ($event_date, 6, 2);
} else {
	$year= date_now(Y);
	$month=date_now(m);
	$day=date_now(d);
}

$content .= "
<form action=\"calendar.php\" method=\"post\" enctype=\"multipart/form-data\">
	<input type=\"hidden\" name=\"op\" value=\"event_action\" />";

if ($event_id > 0)
	 $content .= "
	<input type=\"hidden\" name=\"event_id\" value=\"$event_id\" />";

$content .= "
<table cellspacing=\"0\" cellpadding=\"4\" border=\"0\" width=\"100%\">
<tr>
	<td valign=\"top\">$tran[Image]:</td>
	<td>";

$content .= select_image($image_name);
$content .= "
	</td>
</tr>
<tr>
	<td colspan=\"2\">
	$tran[Associate_Event]:<br />
	<input type=\"radio\" name=\"associate\" value=\"none\"";

if ($associate != "cat" && $associate != "sub")
	$content .= " checked";

$content .=" />$tran[None]<br />";

$cat_result = mysql_query ("select cat_id, category from 
				mod_calendar_category order by category");

if (mysql_num_rows ($cat_result) > 0){

	$content .= "
	<input type=\"radio\" name=\"associate\" value=\"cat\"" . check_me($associate, "cat", "c") . " />
	$tran[cat_name]:
	<select name=\"cat_id\">";

while (list($sel_cat_id, $category) = mysql_fetch_array ($cat_result)){
		$content .= "
	<option value=\"$sel_cat_id\"" . check_me($sel_cat_id, $cat_id, "s") . ">$category</option>";
}

	$content .= "
	</select>
	<br />
";
}

$subcat_result = mysql_query ("
				select subcat_id, subcat, cat_id from 
				mod_calendar_subcat order by cat_id, subcat");

if (mysql_num_rows ($subcat_result) > 0){
	$content .= "
	<input type=\"radio\" name=\"associate\" value=\"sub\"" . check_me($associate, "sub", "c") . " />
	$tran[subcat_name]:
	<select name=\"subcat_id\">";

	while (list ($sel_subcat_id, $subcat, $sel_cat_id) = mysql_fetch_array ($subcat_result)){
		if ($sel_cat_id != $cat_id_cache) {
			$sql_result = mysql_query ("
					select category from mod_calendar_category 
					where cat_id=$sel_cat_id");

			list ($category) = mysql_fetch_row ($sql_result);
			$cat_id_cache = $sel_cat_id;
		}
		$content .= "
	<option value=\"$sel_subcat_id\"" . check_me($sel_subcat_id,$subcat_id,"s") . ">$category: $subcat</option>";
	}

	$content .= "
	</select>
";	
}

$content .= "<br />
	</td>
<tr>
	<td";

if ($title_error)
	$content .= " class=\"$error_color\"";

$content .= ">
	$tran[Title]:</td>
	<td";

if ($title_error)
	$content .= " class=\"$error_color\"";

$content .= ">
	<input type=\"text\" name=\"title\" size=\"30\" maxsize=\"40\" value=\"$title\" />
	</td>
</tr>
<tr>
	<td valign=\"top\">
	$tran[Description]:
	</td>
	<td>
	<textarea name=\"description\" rows=\"4\" cols=\"40\" wrap=\"soft\">".unparse_text($description)."</textarea>
	</td>
</tr>
<tr>
	<td valign=\"top\">$tran[Location]:
	</td>
	<td align=\"left\">";

$loc_result = mysql_query("select loc_id, loc_name from mod_calendar_location order by loc_name");

$content .= "
		<select name=\"loc_id\">
			<option value=\"\">$tran[No_Location]</option>";
while (list($sel_loc_id, $loc_name) = mysql_fetch_array($loc_result)){
	$content .= "
			<option value=\"$sel_loc_id\"" . check_me($loc_id, $sel_loc_id, "s") . ">$loc_name</option>";
}
$content .= "
		</select>";


$content .= " <a href=\"calendar.php?op=location_admin\">$tran[Add_Location]</a>";

$content .= "
	</td>
</tr>

<tr>
	<td";

if ($date_error)
	$content .= " class=\"$error_color\"";

$content .= ">
	$tran[Date_of_Event]:
	</td>
        <td";

if ($date_error)
	$content .= " class=\"$error_color\"";

$content .= ">";

switch ($date_order){
	case("mdy"):
		$content .= select_month ("month", $month) . select_day("day", $day) . select_year("year", $year);
		break;
	case("ymd"):
		$content .= select_year("year", $year) . select_month ("month", $month) . select_day("day", $day);
		break;
	case("dmy"):
		$content .= select_day("day", $day) . select_month ("month", $month) . select_year("year", $year);
		break;
}

$content .= "
	</td>
</tr>
<tr>
	<td valign=\"top\">
	<input type=\"radio\" name=\"allday\" value=\"0\"";

if ($allday != '1')
	$content .= " checked";

$content .= " /> $tran[Timed_Event]
	</td>
	<td";

if ($time_error)
	$content .= " class=\"$error_color\"";

$content .= ">";

$content .= "$tran[Start_Time]:
	<select name=\"start_hour\">";

if ($time_format == 's'){
	for ($i=1; $i < 13 ; $i++) {
		$content .= "
		<option" . check_me(date(g, mktime(substr($starttime, 0, 2),1)), date(g, mktime($i,1)), "s") . ">" . date ("h", mktime($i) ) . "</option>";
	}
}
else if ($time_format == 'm'){
	for ($i=0; $i < 24 ; $i++) {
		$content .= "
		<option" . check_me(date ("H", mktime(substr ($starttime, 0, 2) ) ), date ("H", mktime($i) ), "s") . ">" . date ("H", mktime($i) ) . "</option>";
	}
}

$content .= "
	</select>
	<select name=\"start_min\">";

for ($i=1 ; $i < 5 ; $i++){
	$content .= "<option" . check_me(substr ($starttime, 2, 2), get_min($i), "s") . ">" . get_min($i) . "</option>";
}

$content .= "
	</select>";

if ($time_format == 's') {
	$content .= "
	<select name=\"start_ampm\">
		<option";

	if ( substr ($starttime, 0, 2) < 12 )
		$content .= " selected";

	$content .= ">AM
		</option>
		<option";

	if ( substr ($starttime, 0, 2) >= 12 )
		$content .= " selected";

	$content .= ">PM
		</option>
	</select>";
}

$content .= "<br />End Time:
	<select name=\"end_hour\">";
if ($time_format == 's'){
	for ($i=1; $i < 13 ; $i++) {
		$content .= "
		<option" . check_me(date(g, mktime(substr($endtime, 0, 2),1)), date(g, mktime($i,1)), "s") . ">" . date ("h", mktime($i) ) . "</option>";
	}
} else if ($time_format == 'm'){
	for ($i=0; $i < 24 ; $i++) {
		$content .= "
		<option";

		if ( date ("H", mktime(substr ($endtime, 0, 2) ) ) == date ("H", mktime($i) ) )
			$content .= " selected";

		$content .= ">" . date ("H", mktime($i) ) . "
		</option>";
	}
}
$content .= "
	</select>
	<select name=\"end_min\">";

for ($i=1 ; $i < 5 ; $i++){
	$content .= "
		<option" . check_me(substr ($endtime, 2, 2), get_min($i), "s") . ">" . get_min($i) . "</option>";
}

$content .= "
	</select>";

if ($time_format == 's'){
	$content .= "
	<select name=\"end_ampm\">
		<option";

	if ( substr ($endtime, 0, 2) <= 12 )
		$content .= " selected";

	$content .= ">AM
		</option>
		<option";

	if ( substr ($endtime, 0, 2) > 12 )
		$content .= " selected";

	$content .= ">PM
		</option>
	</select>";
}

$content .= "
	</td>
</tr>
<tr>
	<td>
	<input type=\"radio\" name=\"allday\" value=\"1\"" . check_me($allday, "1", "c") . " /> $tran[All_day_event]	
	</td>
	<td>
	$tran[This_event_runs_all_day]
	</td>
</tr>
<tr>
	<td>
	<input type=\"radio\" name=\"allday\" value=\"2\"" . check_me($allday, "2", "c") . " /> $tran[No_Ending_Time]	
	</td>
	<td>
	$tran[This_event_starts].
	</td>
</tr>
<tr>
        <td align=\"center\" colspan=\"2\">";

if ($event_id > 0)
	$content .= "
	<input type=\"submit\" value=\"$tran[Update_Event]\" />";
else
	$content .= "
	<input type=\"submit\" value=\"$tran[Create_Event]\" />";

$content .= "
        </td>
</tr>
</table>";
$content .= back_to_admin();
thememainbox($box_title, $content);

if ($posted){
	$box_title = "$tran[Post_Date] : $tran[This_event_posted_on] " . format_date($post_start) . ".";
	$content = "$tran[You_may_edit_it] <a href=\"admin.php?op=EditStory&amp;sid=$article_id\">$tran[here]</a>.";
} else {
	$box_title = "
		<input type=\"checkbox\" name=\"post_event\" value=\"1\"" . check_me($post_event, 1, "c") . " />$tran[Post_Event]";
$content = "
<table cellspacing=\"0\" cellpadding=\"4\" border=\"0\" width=\"100%\">
<tr>
	<td";
if ($post_error)
	$content .= " class=\"$error_color\"";

$content .= ">$tran[Post_Date]</td>
	<td";
if ($post_error)
	$content .= " class=\"$error_color\"";

$content .= ">";

switch ($date_order){
	case("mdy"):
		$content .= select_month ("post_start_month", $post_start_month) . select_day("post_start_day", $post_start_day) . select_year("post_start_year", $post_start_year);
		break;
	case("ymd"):
		$content .= select_year("post_start_year", $post_start_year) . select_month ("post_start_month", $post_start_month) . select_day("post_start_day", $post_start_day);
		break;
	case("dmy"):
		$content .= select_day("post_start_day", $post_start_day) . select_month ("post_start_month", $post_start_month) . select_year("post_start_year", $post_start_year);
		break;
}

$content .= "
	</td>
</tr>
<tr>
	<td";
if ($post_error)
	$content .= " class=\"$error_color\"";

$content .= ">$tran[Remove_Post]</td>
	<td";
if ($post_error)
	$content .= " class=\"$error_color\"";

$content .= ">";

switch ($date_order){
	case("mdy"):
		$content .= select_month ("post_end_month", $post_end_month) . select_day("post_end_day", $post_end_day) . select_year("post_end_year", $post_end_year);
		break;
	case("ymd"):
		$content .= select_year("post_end_year", $post_end_year) . select_month ("post_end_month", $post_end_month) . select_day("post_end_day", $post_end_day);
		break;
	case("dmy"):
		$content .= select_day("post_end_day", $post_end_day) . select_month ("post_end_month", $post_end_month) . select_year("post_end_year", $post_end_year);
		break;
}
$topic_sql = mysql_query("select topicid, topictext from topics order by topictext");
$content .= "
	</td>
</tr>
<tr>
	<td>$tran[Topic]:</td>
	<td>";
	if (mysql_num_rows($topic_sql)){
		$content .= "
		<select name=\"topic\">";
		while (list($sel_topicid,$topictext) = mysql_fetch_row($topic_sql)){
			$content .= "
			<option value=\"$sel_topicid\"" . check_me($sel_topicid, $topicid, "s") . ">$topictext</option>";
		}
		$content .= "
		</select>";
	} else {
		$content .= "<i>$tran[None_Found]</i>";
	}

	$content .= "
	</td>
</tr>
";
 
$content .= "

<tr>
	<td colspan=\"2\">
	&nbsp;
	</td>
</tr>
<tr>
        <td align=\"center\" colspan=\"2\">";

if ($event_id > 0)
	$content .= "
	<input type=\"submit\" value=\"$tran[Update_Event]\" />";
else
	$content .= "
	<input type=\"submit\" value=\"$tran[Create_Event]\" />";

$content .= "
        </td>
</tr>
</table>";
}
$content .= back_to_admin();
thememainbox ($box_title, $content);

$box_title = "<input type=\"checkbox\" name=\"repeat_event\" value=\"1\"" . check_me($repeat_event, 1, "c") . " />$tran[Repeat_event]";
$content = "
<table cellspacing=\"0\" cellpadding=\"4\" border=\"0\" width=\"100%\">
<tr>
	<td colspan=\"2\">
	<input type=\"radio\" name=\"repeat_type\" value=\"day\"" . check_me($repeat_type, "day", "c") . " />$tran[Daily]<br />
	</td>
</tr>
<tr>

	<td";
if ($repeat_week_error)
	$content .= " class=\"$error_color\"";

$content .= " valign=\"top\">
	<input type=\"radio\" name=\"repeat_type\" value=\"week\"" .  check_me($repeat_type, "week", "c") . " />$tran[Weekly]
	</td>
	<td ";
if ($repeat_week_error)
	$content .= " class=\"$error_color\"";

$content .= ">
	<input type=\"checkbox\" name=\"rpt_mon\" value=\"1\"" . check_me($rpt_mon, 1, "c") . " />$tran[Monday]&nbsp;&nbsp;
	<input type=\"checkbox\" name=\"rpt_tue\" value=\"1\"" . check_me($rpt_tue, 1, "c") . " />$tran[Tuesday]&nbsp;&nbsp;
	<input type=\"checkbox\" name=\"rpt_wed\" value=\"1\"" . check_me($rpt_wed, 1, "c") . " />$tran[Wednesday]&nbsp;&nbsp;
	<input type=\"checkbox\" name=\"rpt_thur\" value=\"1\"" . check_me($rpt_thur, 1, "c") . " />$tran[Thursday]&nbsp;&nbsp;
	<input type=\"checkbox\" name=\"rpt_fri\" value=\"1\"" . check_me($rpt_fri, 1, "c") . " />$tran[Friday]<br />
	<input type=\"checkbox\" name=\"rpt_sat\" value=\"1\"" . check_me($rpt_sat, 1, "c") . " />$tran[Saturday]&nbsp;&nbsp;
	<input type=\"checkbox\" name=\"rpt_sun\" value=\"1\"" . check_me($rpt_sun, 1, "c") . " />$tran[Sunday]
	</td>
</tr>
<tr>
	<td valign=\"top\">
	<input type=\"radio\" name=\"repeat_type\" value=\"month\"" . check_me($repeat_type, "month", "c") . " />$tran[Monthly_by_Date]
	</td>
	<td valign=\"top\">
	<input type=\"radio\" name=\"month_repeat_type\" value=\"day\" ";

if ($month_repeat_type != "end")
	$content .= "checked ";

$content .= "/>This day of every month<br />
	<input type=\"radio\" name=\"month_repeat_type\" value=\"end\"" . check_me($month_repeat_type, "end", "c") . " /> $tran[End_of_every_month]
	</td>
</tr>
<tr>
	<td>
	<input type=\"radio\" name=\"repeat_type\" value=\"year\"" . check_me($repeat_type, "year", "c") . " />$tran[Yearly]
	</td>
</tr>
<tr>
	<td";

	if ($end_repeat_error)
		$content .= " class=\"$error_color\"";

	$content .= ">$tran[Last_Repeat_Day]:</td>
	<td";

	if ($end_repeat_error)
		$content .= " class=\"$error_color\"";

	$content .= ">";
switch ($date_order){
	case("mdy"):
		$content .= select_month ("end_rpt_month", $end_rpt_month) . select_day("end_rpt_day", $end_rpt_day) . select_year("end_rpt_year", $end_rpt_year);
		break;
	case("ymd"):
		$content .= select_year("end_rpt_year", $end_rpt_year) . select_month ("end_rpt_month", $end_rpt_month) . select_day("end_rpt_day", $end_rpt_day);
		break;
	case("dmy"):
		$content .= select_day("end_rpt_day", $end_rpt_day) . select_month ("end_rpt_month", $end_rpt_month) . select_year("end_rpt_year", $end_rpt_year);
		break;
}

	$content .= "
	</td>
</tr>
";

if ($error)
	$content .= "
<tr>
	<td class=\"$error_color\" colspan=\"2\" align=\"center\">
		$tran[The_highlighted_field].
	</td>
</tr>";

else
	$content .= "
<tr>
	<td colspan=\"2\">
		&nbsp;
	</td>
</tr>
";
$content .= "
<tr>
	<td colspan=\"2\" align=\"center\">";

if ($event_id > 0)
	$content .= "
	<input type=\"submit\" value=\"$tran[Update_Event]\" />";
else
	$content .= "
	<input type=\"submit\" value=\"$tran[Create_Event]\" />";

$content .= "
	</td>
</tr>
</table>
";

$content .= back_to_admin();

thememainbox ($box_title, $content);

$content .= "</form>";

## End of event_admin() ##
}

/**
 * Writes or updates an event in the database.
 *
 * This function checks whether a file has an error. If not it
 * either updates or creates an event in the database.
 *
 * @param event_id: the unique id of the event. if present, it updates that event
 * @param allday: determines whether the event goes all day, continues after a start time, or has a beginning and an end.
 * @param image_name: file of the image attached to event
 * @param title: name of the event
 * @param description
 * @param event_date: date of the event
 * @param loc_id: unique id of the location
 * @param error: bool value determining whether an error exists
 * @param date_error: bool value showing a date error
 * @param title_error: bool value showing a missing title
 * @param time_error: bool value showing a mismatched time
 * @param associate: indicates whether event is associated with a category or subcat
 * @param starttime: starting time of event, blank in allday mode
 * @param endtime: ending time of event, blank if allday or no ending time indicated
 * @param edit_switch: bool value indicating the user is editing
 * @param repeat_event: bool value that allows usage of repeat choices
 * @param repeat_type: text value telling what type of repeat the event uses
 * @param rpt_sun: bool value indicating a sunday repeat
 * @param rpt_mon: bool value indicating a monday repeat
 * @param rpt_tue: bool value indicating a tuesday repeat
 * @param rpt_wed: bool value indicating a wednesday repeat
 * @param rpt_thu: bool value indicating a thursday repeat
 * @param rpt_fri: bool value indicating a friday repeat
 * @param rpt_sat: bool value indicating a saturday repeat
 * @param month_repeat_type: indicates whether to repeat on the event date or at the end of each month
 * @param repeat_week_error: bool value indicated an user did not enter a weekday to repeat
 * @param end_repeat_error: date to end repeating events
 * @param tran: array of translation text
 * @param post_start: day to post article
 * @param post_end: day to end article
 * @param post_event: switch to allow posting of event as article
 * @param post_error: bool value indictating the user entered faulty post dates
 * @param topic : topic number used to post articles
 */

function event_action ($event_id)
{
global 	$start_ampm, $start_hour, $start_min, $end_ampm, $end_hour, $end_min, $edit_switch, $loc_id,
	$allday, $cat_id, $subcat_id, $image_name, $title, $description, $year, $month, $day, $event_date,
	$error, $date_error, $title_error, $time_error, $associate, $starttime, $endtime, $repeat_event,
	$repeat_type, $rpt_sun, $rpt_mon, $rpt_tue, $rpt_wed, $rpt_thur, $rpt_fri, $rpt_sat, $month_repeat_type, 
	$repeat_week_error, $end_repeat_error, $end_repeat, $end_rpt_year, $end_rpt_month, $end_rpt_day, 
	$post_start, $post_end, $post_event, $post_error, $post_start_year, $post_start_month, $post_start_day,
	$post_end_year, $post_end_month, $post_end_day, $topic;

$sql_result = mysql_query("select time_format from mod_calendar_settings");
list($time_format) = mysql_fetch_row($sql_result);

include ("plug-ins/calendar/calendar_config.php");


$edit_switch = 1;

if ($associate == "cat")
	$subcat_id = 0;

if ($allday==0){
	if ($time_format == 's'){
		$starttime = date ("Hi", mktime (military ($start_ampm, $start_hour), $start_min));
		$endtime = date ("Hi", mktime (military ($end_ampm, $end_hour), $end_min));
	} else {
		$starttime = $start_hour . $start_min;
		$endtime = $end_hour . $end_min;
	}

	if ( ($starttime == $endtime) || ($starttime > $endtime))
		$time_error= 1;
	else 
		$time_error= 0;

} else if ($allday==2) {
	if ($time_format == 's'){
		$starttime = date ("Hi", mktime (military ($start_ampm, $start_hour), $start_min));
		$endtime = '9999';
	} else {
		$starttime = $start_hour . $start_min;
		$endtime = '9999';
	}

}
$post_start = $post_start_year.$post_start_month.$post_start_day;
$post_end = $post_end_year.$post_end_month.$post_end_day; 

if ((!check_date($post_start) || !check_date($post_end) || ($post_start >= $post_end)) && $post_event)
	$post_error= 1; 
else
	$post_error= 0;


$event_date = $year . $month . $day;
if (!check_date($event_date))
	$date_error= 1; 
else
	$date_error= 0;

$end_repeat = $end_rpt_year.$end_rpt_month.$end_rpt_day;

if (!strlen($title))
	$title_error= 1;
else
	$title_error= 0;

if ($title_error || $date_error || $time_error || $repeat_week_error || $end_repeat_error || $post_error)
	$error = 1;
else
	$error = 0;

$description = parse_text($description);

if ($error){
	if ($event_id)
		event_admin($event_id);
	else
		event_admin();
}
else {
	if ($repeat_event){

		switch ($repeat_type){
			case ("day"):
				$month_repeat_type='';
				$repeat_week_day='';
				break;
			case ("week"):
				if ($rpt_sun || $rpt_mon || $rpt_tue || $rpt_wed || $rpt_thur || $rpt_fri || $rpt_sat)
					$repeat_week_day = "$rpt_sun:$rpt_mon:$rpt_tue:$rpt_wed:$rpt_thur:$rpt_fri:$rpt_sat";
				else
					$repeat_week_error = 1;
				$month_repeat_type='';
				break;
			case ("month"):
				$repeat_week_day='';
				break;
			case ("year"):
				$month_repeat_type='';
				$repeat_week_day='';
				break;
		}
	}

	if ($event_id){
		$sql	=	"update mod_calendar_events 
				set 
				title='$title', description='$description', loc_id='$loc_id', image_name='$image_name', 
				event_date='$event_date', ";

		switch ($associate){
			case ("cat"):
			$sql .= "cat_id=$cat_id, subcat_id=0, ";
			break;

			case ("sub"):
			$sql_result = mysql_query("select cat_id from mod_calendar_subcat where subcat_id='$subcat_id'");
			list ($cat_id) = mysql_fetch_row ($sql_result);
			$sql .= "cat_id=$cat_id, subcat_id=$subcat_id, ";
			break;

			default:
			break;
		}
		if ($allday != 1)
			$sql .= "starttime='$starttime', endtime='$endtime', ";
		else
			$sql .= "starttime='0000', endtime='9999', ";

		$sql 	.=	"allday='$allday'";

		if ($repeat_event)
			$sql .= ", repeat_type='$repeat_type', repeat_week_day='$repeat_week_day', 
			month_repeat_type='$month_repeat_type', end_repeat='$end_repeat'";
		else
			$sql .= ", repeat_type='', repeat_week_day='', 
			month_repeat_type='', end_repeat=''";


		$sql 	.= 	" where event_id='$event_id'";
#echo $sql;
		mysql_query($sql);

		if ($post_event){
			$id_check = mysql_query ("select post_event_id, posted from mod_calendar_post where post_event_id='$event_id'");
			if (mysql_num_rows($id_check)){
				$post_sql = 	"update mod_calendar_post
						set
						topic='$topic', post_start='$post_start', post_end='$post_end'
						where post_event_id='$event_id'";
			} else {
				$post_sql = 	"insert into mod_calendar_post
						(post_event_id, topic, post_start, post_end)
						values
						('$event_id', '$topic', '$post_start', '$post_end')";
			}
			mysql_query($post_sql);
		}
		header ("Location: ./calendar.php?op=mainmenu&note=Event+updated.");

	} else {
		$sql	=	"insert into mod_calendar_events 
				(title, description, loc_id, image_name, event_date, ";

		if ($associate != 'none')
			$sql .= "cat_id, subcat_id, ";

		$sql .= "starttime, endtime, allday, repeat_type, repeat_week_day, month_repeat_type, end_repeat";

		$sql	.=	") 
				values 
				('$title', '$description', '$loc_id', '$image_name', '$event_date', ";

		switch ($associate){
			case ("cat"):
			$sql .= "$cat_id, 0, ";
			break;

			case ("sub"):
			$sql_result = mysql_query("select cat_id from mod_calendar_subcat where subcat_id='$subcat_id'");
			list ($cat_id) = mysql_fetch_row ($sql_result);
			$sql .= "$cat_id, $subcat_id, ";
			break;

			default:
			break;
		}
		if ($allday != 1)
			$sql .=	"'$starttime', '$endtime', ";
		else
			$sql .= "'0000', '9999', ";

		$sql 	.=	"$allday";

		if ($repeat_event)
			$sql .= ", '$repeat_type', '$repeat_week_day', '$month_repeat_type', '$end_repeat'";
		else
			$sql .= ", '', '', '', ''";

		$sql 	.=	")";
#echo $sql;
		mysql_query($sql);

		if ($post_event){
			$id_pull = mysql_query("select event_id from mod_calendar_events order by event_id desc limit 1");
			list ($event_id) = mysql_fetch_row($id_pull);
			$post_sql = 	"insert into mod_calendar_post
					(post_event_id, topic, post_start, post_end)
					values
					('$event_id', '$topic', '$post_start', '$post_end')";
			mysql_query($post_sql);
		}

		header ("Location: ./calendar.php?op=mainmenu&note=Event+created.");
	}
}
## End of event_action() ##
}

/**
 * Copies user submitted image from temporary directory to the 
 * calendar image directory.
 * 
 * @param image : system temp filename
 * @param image_name : user designated image name
 * @image_size : image byte size
 * @image_type : extension (jpg, gif, png)
 *
 */
function copy_image ($image, $image_name, $image_size, $image_type){
	include ("config.php");
	include ("./plug-ins/calendar/calendar_config.php");
	global $tran;
	if($image) {
		if($image_size > $max_user_file_size){
			page_error("$image_name : $tran[Image_too_large]. 
			<br />$tran[largest_allowable_size]: $max_user_file_size b.
			<br />$tran[Your_file_is]: $image_size b.");
		}
		if(substr_count($user_file_types, $image_type)>0){
			if (@copy($image, $calendar_image_dir.$image_name));
			else
				page_error("$image_name $tran[failed_to_copy]!");
		}
		else {
			page_error("$image_name : $tran[wrong_file_type].
			<br />$tran[allowed_types_are]: $user_file_types
			<br />$tran[file_type]: $image_type");
		}
		unlink($image);
	}
}

/**
 * Prints php error. 
 * 
 * @param type : error message
 *
 */

function page_error($type)
{
        include ("header.php");
	include ("config.php");
	global $tran;
	$title = "$tran[Data_Error]!!";
	$content = "<b>$tran[error_occured]:</b><br /><br />
	$type<br /><br />
        $tran[go_back].
        ";
	thememainbox($title, $content);
	include ("footer.php");
	exit;
}

/**
 * A preview page for images.
 *
 * User can choose to use the image or not and also
 * they may delete it from here.
 *
 * @param picname: filename of image
 * @param return_op : operation to return to after selection
 * @param old_var : name of file from edit page, used if image not selected
 */
function show_image($picname, $return_op, $old_var=''){
	include ("header.php");
	include ("config.php");
	include ("./plug-ins/calendar/calendar_config.php");
	global $tran;
	$title = "$picname";
	if(file_exists("$calendar_image_dir$picname")){
		$size = @getimagesize ("$calendar_image_dir$picname");
		$content = "
		<div align=\"center\">
		<img src=\"$calendar_img_url$picname\" border=\"0\" width=\"$size[0]\" height=\"$size[1]\" alt=\"$picname\"/>
		<br /><br />
		<a href=\"calendar.php?op=$return_op";
		if (strlen ($old_var))
			$content .= "&amp;$old_var";

		
		$content .= "&amp;image_name=$picname\">Use Image</a>
		&nbsp;&nbsp;
		<a href=\"calendar.php?op=$return_op";
		if (strlen ($old_var))
			$content .= "&amp;$old_var";

		
		$content .= "\">$tran[Don_t_Use]</a>
		&nbsp;&nbsp;
		<a href=\"calendar.php?op=delete_image&amp;image_name=$picname\">$tran[Delete_Image]</a>
		</div>";

	} else {
		$content = "$tran[Unable_to_load].<br />
			<a href=\"calendar.php?op=$return_op";
		if (strlen ($old_var))
			$content .= "&amp;$old_var";

		$content .= "&$old_var\">$tran[Return_to_form]</a>";
	}

	thememainbox ($title, $content);
	include ("footer.php");
	exit;
## End of show_image() ##
}

/**
 * Deletes image from the directory
 *
 * If the user chooses to delete an image, this page shows
 * where the image is currently being used. If they still
 * want to delete it, it terminates the file, and erases it
 * from the categories, subcategories, events, months, and locations
 * that use it.
 * 
 * @param image_name : filename of image
 * @param delete : affirmation of deletion
 */
function delete_image($image_name, $delete='')
{
	include ("config.php");
	include ("./plug-ins/calendar/calendar_config.php");
	global $tran;
	$title = "$tran[Delete] $image_name";

if ($delete != 'yes'){
	include ("header.php");
	$sql_result1 = mysql_query ("select cat_id, category from mod_calendar_category where image_name='$image_name' order by category");
	$sql_result2 = mysql_query ("select cat_id, subcat_id, subcat from mod_calendar_subcat where image_name='$image_name' order by cat_id, subcat");
	$sql_result3 = mysql_query ("select cat_id, subcat_id, event_id, title from mod_calendar_events where image_name='$image_name' order by cat_id, subcat_id, title");
	$sql_result4 = mysql_query ("select loc_id, loc_name from mod_calendar_location where image_name='$image_name' order by loc_id, loc_name");

	$content = "<b>$tran[currently_using_image]:</b><br /><br />
<table cellspacing=\"0\" cellpadding=\"5\" border=\"0\" width=\"100%\">
<tr>
	<td class=\"$block_top\">$tran[cat_name]</td>
	<td class=\"$block_top\">$tran[subcat_name]</td>
	<td class=\"$block_top\">$tran[Event_Title]</td>
	<td class=\"$block_top\">$tran[Location]</td>
	<td class=\"$block_top\">$tran[Month]</td>
</tr>
<tr>
	<td>";

	if (mysql_num_rows($sql_result1) > 0) {
		while ($row = mysql_fetch_array($sql_result1)) {
			extract ($row);
			$content .= "
	$category<br />
			";
		}
	}
	else
		$content .= "&nbsp;";

	$content .= "
	</td>
	<td>";
	if (mysql_num_rows ($sql_result2) > 0) {
		while ($row = mysql_fetch_array($sql_result2)) {
			extract($row);
			$get_cat = mysql_query ("select category from mod_calendar_category where cat_id=$cat_id");
			list ($category)=mysql_fetch_row($get_cat);
			$content .= "
	$category: $subcat<br />
			";
		}
	}
	else
		$content .= "&nbsp;";


	$content .= "
	</td>
	<td>";
	if (mysql_num_rows ($sql_result3) > 0) {
		while ($row = mysql_fetch_array($sql_result3)) {
			extract($row);
			$get_cat = mysql_query ("select category from mod_calendar_category where cat_id=$cat_id");
			list ($category)=mysql_fetch_row($get_cat);

			$get_subcat = mysql_query ("select subcat from mod_calendar_subcat where subcat_id=$subcat_id");
			list ($subcat)=mysql_fetch_row($get_subcat);

			$content .= "
	<b>$category:</b>$subcat: $title<br />
			";
		}
	}
	else
		$content .= "&nbsp;";

	$content .= "
	</td>
	<td>";

	if (mysql_num_rows($sql_result4) > 0) {
		while ($row = mysql_fetch_array($sql_result4)) {
			extract ($row);
			$content .= "
	$loc_name<br />
			";
		}
	}
	else
		$content .= "&nbsp;";

	$content .= "
	</td>
	<td>";

	for ($i = 1; $i < 13; $i++){
		$count = date("h", mktime ($i,0,0));
		$image_months = mysql_query("select pic_$count from mod_calendar_settings where pic_$count='$image_name'");
		if (mysql_num_rows($image_months)){
			$month_name = date("F", mktime(0,0,0,$i));
			$content .= "$tran[$month_name]<br />";
		}
	}


	$content .= "
</tr>
<tr>
	<td colspan=\"5\" align=\"center\">
	<hr />
	$tran[Deleting_will_remove].<br /><br />
	$tran[Are_you_sure]?<br />
	<a href=\"calendar.php?op=delete_image&amp;image_name=$image_name&amp;delete=yes\">$tran[YES]</a>
	&nbsp;&nbsp;
	<a href=\"calendar.php?op=mainmenu&amp;note=$tran[Image_saved]\">$tran[NO]</a>
	</td>
</tr>
</table>";
	$content .= back_to_admin();
	thememainbox($title, $content);

}
else {
	if(file_exists("$calendar_image_dir$image_name")){
		$check_delete = unlink("$calendar_image_dir$image_name");
		if ($check_delete){
			mysql_query ("update mod_calendar_category set image_name='' where image_name='$image_name'");
			mysql_query ("update mod_calendar_subcat set image_name='' where image_name='$image_name'");
			mysql_query ("update mod_calendar_events set image_name='' where image_name='$image_name'");
			mysql_query ("update mod_calendar_location set image_name='' where image_name='$image_name'");
			for ($i = 1; $i < 13; $i++){
				$count = date("h", mktime ($i,0,0));
				mysql_query ("update mod_calendar_settings set pic_$count='' where pic_$count='$image_name'");
			}
			header("Location:./calendar.php?op=mainmenu&note=$tran[Image_plus_deleted]");
		}
		else
			header("Location:./calendar.php?op=mainmenu&note=$tran[Unable_to_delete_image]");
	}	
}
}

/**
 * Deletes categories from database
 *
 * Gets an affirmation from the user before deleting it.
 * Also wipes the references to it in other fields
 *
 * @param cat_id : id number of category to delete
 * @param delete : affirmation of delete
 */
function delete_cat($cat_id, $delete= '') {
	include ("config.php");
	include ("./plug-ins/calendar/calendar_config.php");
	global $tran;
	if (!strlen($delete)){
		include ("header.php");
		$sql_result = mysql_query("select category from mod_calendar_category where cat_id=$cat_id");
		list ($category) = mysql_fetch_row ($sql_result);
		$title = "$tran[Remove] $tran[cat_name]: $category";
		$content = "<p>$tran[Removing_this] $tran[cat_name] $tran[will_remove_all] $tran[subcat_name] $tran[beneath_it].</p>
<p>$tran[sure_you_want_to] <b>$category</b>?<br />
<form action=\"calendar.php\" method=\"post\">
	<input type=\"hidden\" name=\"op\" value=\"delete_cat\" />
	<input type=\"hidden\" name=\"cat_id\" value=\"$cat_id\" />
	<input type=\"submit\" name=\"delete\" value=\"$tran[Yes]\" />
	<input type=\"submit\" value=\"$tran[No]\" />
</form>";
		thememainbox($title,$content);
	} else if (strlen($delete)){
		mysql_query ("delete from mod_calendar_category WHERE cat_id = '$cat_id'");
		mysql_query("update mod_calendar_events set cat_id='' where cat_id='$cat_id'");
		$sql_result = mysql_query ("select subcat_id from mod_calendar_subcat where cat_id='$cat_id'");
		while (list($subcat_id) = mysql_fetch_row($sql_result)) {
			mysql_query ("delete from mod_calendar_subcat WHERE subcat_id = '$subcat_id'");
			mysql_query("update mod_calendar_events set subcat_id='' where subcat_id='$subcat_id'");
		}
		$note = $tran[cat_name]."+".$tran[removed];
		header("Location: ./calendar.php?op=mainmenu&note=$note");
	} 

}

/**
 * Deletes subcategories from database
 *
 * Gets an affirmation from the user before deleting it.
 * Also wipes the references to it in other fields
 *
 * @param subcat_id : id of subcategory to delete
 * @param delete : affirmation of deletion
 */
function delete_subcat($subcat_id, $delete= '') {
	include ("config.php");
	include ("./plug-ins/calendar/calendar_config.php");
	global $tran;
	if (!strlen($delete)){
		include ("header.php");
		$sql_result = mysql_query("select subcat from mod_calendar_subcat where subcat_id='$subcat_id'");
		list ($subcat) = mysql_fetch_row ($sql_result);
		$title = "$tran[Remove] $tran[subcat_name]: $subcat";
		$content = "<p>$tran[Removing_this] $tran[subcat_name] $tran[will_remove_all].</p>
<p>$tran[sure_you_want_to] <b>$subcat</b>?<br />
<form action=\"calendar.php\" method=\"post\">
	<input type=\"hidden\" name=\"op\" value=\"delete_subcat\" />
	<input type=\"hidden\" name=\"subcat_id\" value=\"$subcat_id\" />
	<input type=\"submit\" name=\"delete\" value=\"$tran[Yes]\" />
	<input type=\"submit\" value=\"$tran[No]\" />
</form>";
		thememainbox($title,$content);
	} else if (strlen($delete)){
		mysql_query ("DELETE FROM mod_calendar_subcat WHERE subcat_id = '$subcat_id'");
		mysql_query("update mod_calendar_events set subcat_id='' where subcat_id='$subcat_id'");
		header("Location: ./calendar.php?op=mainmenu&note=$tran[subcat_name]+removed");
	} 
}

/**
 * Deletes events from the database
 *
 * Also removes pending posts and repeats. There is
 * currently no way to remove parts of a repeat.
 *
 * @param event_id : id of event to be deleted
 * @param delete : affirmation of deletion
 */

function delete_event($event_id, $delete= '') {
	include ("config.php");
	include ("./plug-ins/calendar/calendar_config.php");
	global $tran;
	if (!strlen($delete)){
		include ("header.php");
		$sql_result = mysql_query("select title from mod_calendar_events where event_id='$event_id'");
		list ($event_title) = mysql_fetch_row ($sql_result);
		$title = "$tran[Remove]: $event_title";
		$content = "<p>$tran[Removing_repeats].</p>
<p>$tran[sure_you_want_to]?<br />
<form action=\"calendar.php\" method=\"post\">
	<input type=\"hidden\" name=\"op\" value=\"delete_event\" />
	<input type=\"hidden\" name=\"event_id\" value=\"$event_id\" />
	<input type=\"submit\" name=\"delete\" value=\"$tran[Yes]\" />
	<input type=\"submit\" value=\"$tran[No]\" />
</form>";
		thememainbox($title,$content);
	} else if (strlen($delete)){
		mysql_query ("DELETE FROM mod_calendar_events WHERE event_id = '$event_id'");
		$fetch_article = mysql_query ("select article_id from mod_calendar_post where post_event_id='$event_id'");
		list ($article_id) = mysql_fetch_row ($fetch_article);
		mysql_query ("delete from stories where sid = '$article_id'");
		mysql_query ("delete from mod_calendar_post where post_event_id = '$event_id'");
		$note = $tran[Eventremoved];
		header("Location: ./calendar.php?op=mainmenu&note=$note");
	} 
}

/**
 * Deletes locations from the database
 *
 * @param loc_id : id of location to be deleted
 * @param delete : affirmation of deletion
 */

function delete_location($loc_id, $delete= '') {
	include ("config.php");
	include ("./plug-ins/calendar/calendar_config.php");
	global $tran;
	if (!strlen($delete)){
		include ("header.php");
		$sql_result = mysql_query("select loc_name from mod_calendar_location where loc_id=$loc_id");
		list ($loc_name) = mysql_fetch_row ($sql_result);
		$title = "$tran[Remove_Location]: $loc_name";
		$content = "<p>$tran[Removing_location].</p>
<p>$tran[sure_you_want_to] <b>$loc_name?</b><br />
<form action=\"calendar.php\" method=\"post\">
	<input type=\"hidden\" name=\"op\" value=\"delete_location\" />
	<input type=\"hidden\" name=\"loc_id\" value=\"$loc_id\" />
	<input type=\"submit\" name=\"delete\" value=\"$tran[Yes]\" />
	<input type=\"submit\" value=\"$tran[No]\" />
</form>";
		thememainbox($title,$content);
	} else if (strlen($delete)){
		mysql_query ("DELETE FROM mod_calendar_location WHERE loc_id = '$loc_id'");
		mysql_query("update mod_calendar_events set loc_id='' where loc_id='$loc_id'");
		$note = $tran[Location]."+".$tran[removed];
		header("Location: ./calendar.php?op=mainmenu&note=$note");
	} 

}

/**
 * Shows image directory for selection of an image
 *
 * Checks image_file passed to it for selection purposes
 * Then images choices to user. User can also preview an
 * image or send on from their machine.
 * 
 * @param image_name : name of image file
 */
function select_image ($image_name){
	include ("plug-ins/calendar/calendar_config.php");
	global $tran;

	if ($dir=@opendir("$calendar_image_dir")){
		$info .= "
	<select name=\"use_image\">
		<option value=\"none\">$tran[No_Image]</option>";

		while ($file = readdir($dir)){
			if (ereg(".jpg$", $file) || ereg(".gif$", $file) || ereg(".pjpg$", $file))
				$info .= "
		<option" . check_me($file, $image_name, "s") . ">$file</option>";
		}
		closedir();

		$info .= "
	</select>
	<input type=\"submit\" name=\"preview_image\" value=\"$tran[Preview_Image]\" /><br />
	<input type=\"file\" name=\"image\" maxlength=\"60\" size=\"25\" />";
	} else {
		echo "$tran[An_image_directory_error_occurred_Please_check_your_calendar_config_php_file]";
		include ("footer.php");
		exit;
	}
return $info;
}

/**
 * Sets image for particular month in month view.
 * 
 *
 */
function set_month_image ($month, $image_name=''){

	include ("header.php");
	include ("config.php");
	include ("plug-ins/calendar/calendar_config.php");
	global $tran;
	$sql = "select pic_$month from mod_calendar_settings where pic_$month != ''";
	$sql_result = mysql_query($sql);
	if (!strlen($image_name))
		list($image_name) = mysql_fetch_row($sql_result);

	if(file_exists("$calendar_image_dir$image_name"))
		$size = @GetImageSize ("$calendar_img_url$image_name");

	$box_title = format_date("2000" . $month . "01", "long_month") . "'s Image";

	if (file_exists("$calendar_image_dir$image_name"))
		$content .= "<img src=\"$calendar_img_url$image_name\" width=\"$size[0]\" height=\"$size[1]\" alt=\"$month_name\" /><br /><br />";
	else
		$content .= "$tran[No_Image_Found]<br /><br />";

	$content .= "
	<form action=\"calendar.php\" method=\"post\" enctype=\"multipart/form-data\">
	<input type=\"hidden\" name=\"op\" value=\"set_month_image\" />
	<input type=\"hidden\" name=\"month\" value=\"$month\" />";
	
	$content .= select_image($image_name);

	$content .= "
	<br />
	<input type=\"submit\" name=\"write_image\" value=\"$tran[Change_Month_Image]\" />
	</form>";

	$content .= back_to_admin();
	thememainbox ($box_title, $content);
}



//Returns military time when given standard.
//Should be coded around using mktime function
//But there still might be instances.
function military ($AMPM, $hour) {
	if (($AMPM == "PM") && ($hour != 12)) {
		return $hour + 12;
	} else if ( ($hour==12) && ($AMPM == "AM")){
		return 0;
	} 

	return $hour;

}



//Checks a date to see if it legitimate.
//For example, returns false on Feb. 31
function check_date($date) {

	$year= substr ("$date", 0, 4);
	$month=substr ("$date", 4, 2);
	$day=substr ("$date", 6, 2);

	$leap = date ("L", mktime (0,0,0,$month,$day,$year));

	if ( ($month == 2) && ($day > 28) && !($leap) ){
		return FALSE;
	}

	if ( ($month == "04" || $month == "06" || $month == "09" || $month == "11") && $day >30){
		return FALSE;
	}

	if ( ($month == 2) && ($day >= 30) ){
		return FALSE;
	}
		return TRUE;
}



function get_min ($m) {
	switch ($m){
		case 1: return "00";
		case 2: return "15";
		case 3: return "30";
		case 4: return "45";
	}
	return "unknown-minute($m)";
}
##################################################
function purge_events($search_date){
include ("header.php");
include ("config.php");
include ("plug-ins/calendar/calendar_config.php");
global $check, $purge_date, $tran;

if (!$search_date)
	$search_date = date_now("Ymd");

$sql = "select event_id, title, event_date, starttime, repeat_type, end_repeat from mod_calendar_events where event_date < $search_date order by event_date";
$sql_result = mysql_query($sql);
$switch=1;

if (mysql_num_rows($sql_result)){
	$content = "$tran[Warning]
<form action=\"calendar.php\" method=\"post\">
<input type=\"hidden\" name=\"op\" value=\"purge_action\" />
<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\" width=\"100%\">
<tr>
	<td class=\"$block_top\" align=\"center\" width=\"10%\">$tran[Delete]?</td>
	<td class=\"$block_top\" align=\"left\">$tran[Title]</td>
	<td class=\"$block_top\" align=\"left\">$tran[Date]</td>
	<td class=\"$block_top\" align=\"left\">$tran[Repeat_status]</td>
	<td class=\"$block_top\" align=\"left\">$tran[Posted]</td>";

	while ($row = mysql_fetch_array ($sql_result)){
		extract ($row);
		$post_sql = mysql_query("select posted, post_start, post_end from mod_calendar_post where post_event_id='$event_id'");
		if (mysql_num_rows($post_sql)){
			list($posted, $post_start, $post_end) = mysql_fetch_row($post_sql);
			if ($posted)
				$post_info = "$tran[Event_has_been_posted].";
			else
				$post_info = "$tran[Event_schedule_to_post_on] ". format_date($post_start) .".";
		} else
			$post_info = "$tran[No_post_scheduled].";
		if ($repeat_type)
			if ($end_repeat < $search_date)
				$rpt = "$tran[Repeats_have_ended]";
			else
				$rpt = "$tran[Repeats_past] " . format_date($search_date); 
		else
			$rpt = "$tran[No_repeats]";

		if ($switch){
			$color = $misc_highlight;
			$switch = 0;
		} else {
			$color = "";
			$switch = 1;
		}
		$j++;
		$content .= "
<tr>
	<td class=\"$color\" align=\"center\"><input type=\"checkbox\" name=\"remove_$j\" value=\"$event_id\" $check /></td>
	<td class=\"$color\">$title</td>
	<td class=\"$color\">" . format_date($event_date) . "</td>
	<td class=\"$color\">$rpt</td>
	<td class=\"$color\">$post_info</td>
</tr>";
	}
$content .= "
</tr>
</table>
<input type=\"hidden\" name=\"total_events\" value=\"$j\" />
<div align=\"center\">
<br />
<input type=\"submit\" value=\"$tran[Delete_all_checked_events]\" />
</form>
<form action=\"calendar.php\" method=\"post\">
<input type=\"hidden\" name=\"op\" value=\"purge_events\" />
<input type=\"hidden\" name=\"purge_date\" value=\"$search_date\" />
<input type=\"submit\" name=\"check_all\" value=\"$tran[Check_All]\" />
<input type=\"submit\" name=\"check_none\" value=\"$tran[Uncheck_All]\" />
</form>";


}else
	$content .= "<i>$tran[No_events_found_before] " . format_date($search_date);

$content .= "<br /><br />";

$box_title = "$tran[Purge_Events]";
$content .= back_to_admin();
thememainbox ($box_title, $content);
}

#############################################################
function location_admin($loc_id=''){
include ("header.php");
include ("config.php");
include ("plug-ins/calendar/calendar_config.php");

global $loc_id, $loc_name, $loc_desc, $image_name, $email, $error, $name_error, $email_error, $tran;

$content .= "
<form action=\"calendar.php\" method=\"post\" enctype=\"multipart/form-data\">
<input type=\"hidden\" name=\"op\" value=\"loc_action\" />";

if ($loc_id){
	$sql_result = mysql_query ("select * from mod_calendar_location where loc_id='$loc_id'");
	if (!$error) {
		if ($image_name)
			$image_name_temp = $image_name;
		$row = mysql_fetch_array($sql_result);
		extract($row);
		if ($image_name_temp)
			$image_name = $image_name_temp;
	}
	$content .=  "
	<input type=\"hidden\" name=\"loc_id\" value=\"$loc_id\" />";
}

if ($loc_id)
	$box_title = "$tran[Edit_Location]: $loc_name";
else
	$box_title = "$tran[Add_Location]";

$content .=  "
<table cellspacing=\"0\" cellpadding=\"4\" border=\"0\" width=\"100%\">
<tr>
	<td valign=\"top\">$tran[Image]:</td>
	<td>";
$content .= select_image($image_name);
$content .= "
	</td>
</tr>
<tr>
	<td";

if ($name_error)
	$content .= " class=\"$error_color\"";

$content .= ">$tran[Location_Name]:
	</td>
	<td align=\"left\"";

if ($name_error)
	$content .= " class=\"$error_color\"";

$content .= ">
	<input type=\"text\" name=\"loc_name\" size=\"30\" maxlength=\"60\" value=\"$loc_name\" />
	</td>
</tr>
<tr>
	<td valign=\"top\">$tran[Description]:
	</td>
	<td align=\"left\">
	<textarea name=\"loc_desc\" rows=\"4\" cols=\"30\">".unparse_text($loc_desc)."</textarea>
	</td>
</tr>
<tr>
	<td";

if ($email_error)
	$content .= " class=\"$error_color\"";

$content .= ">
	$tran[Contact_Email_Address]:
	</td>
	<td align=\"left\"";

if ($email_error)
	$content .= " class=\"$error_color\"";

$content .= ">
	<input type=\"text\" name=\"email\" size=\"30\" value=\"$email\" />
	</td>
</tr>
<tr>
	<td colspan=\"2\" align=\"center\"";

if ($error)
	$content .=" class=\"$error_color\"> $tran[The_highlighted_field].
	</td>
</tr>";

else
	$content .= ">&nbsp;
	</td>
</tr>";

$content .= "
<tr>
	<td align=\"center\" colspan=\"2\">";

if ($loc_id)
	$content .= "
	<input type=\"submit\" value=\"$tran[Update]\" />";
else
	$content .= "
	<input type=\"submit\" value=\"$tran[Add]\" />";

$content .= "
	</td>
</tr>
</table>
</form>";

$error = $name_error = $email_error = 0;
$content .= back_to_admin();

thememainbox ($box_title, $content);
## End of location_admin ##
}

#####################################################
function loc_action (){

	global $loc_name, $loc_desc, $image_name, $email, $error, $name_error, $email_error, $loc_id;

	include ("plug-ins/calendar/calendar_config.php");

	if (!strlen($loc_name) )
		$name_error=1;
	else
		$name_error=0;

	if ($email){
		$email_check = strstr($email, "@") ;
		if($email_check)
			$email_error=0;
		else
			$email_error=1;
	}


	if (!$name_error && !$email_error)
		$error = 0;
	else
		$error = 1;
	$loc_desc = parse_text($loc_desc);
	if ($error)
		location_admin($loc_id);	

	else {
		if($loc_id) {
			$sql ="
			update mod_calendar_location 
			set loc_name='$loc_name', loc_desc='$loc_desc', 
			image_name='$image_name', email='$email' 
			where loc_id=$loc_id";
#echo $sql;
			mysql_query ($sql);
			$error=0;
			header("Location: ./calendar.php?op=mainmenu&note=Location+successfully+updated.");
		} else {
			$sql = "
			insert into mod_calendar_location 
			(loc_name, loc_desc, email, image_name) values 
			('$loc_name', '$loc_desc', '$email', '$image_name')";
#echo $sql;
			mysql_query ($sql);
			$error=0;
			header("Location: ./calendar.php?op=mainmenu&note=Location+successfully+created.");
		}
	}
#End of loc_action
}

function parse_text($text){
	if (stristr($text, "<br") || stristr($text,"<p>")){
		$text = str_replace("<br>", "<br />", $text);
		$text = str_replace("<BR>", "<br />", $text);
	}
	else
		$text = str_replace("\n", "<br />", $text);

	return $text;
}

function unparse_text($text){
	if (!stristr($text,"<p>"))
		$text = str_replace("<br />", "\n", $text);

	return $text;
}

?>
