/*
SMS Server Tools
Copyright (C) Stefan Frings

This program is free software unless you got it under another license directly
from the author. You can redistribute it and/or modify it under the terms of
the GNU General Public License as published by the Free Software Foundation.
Either version 2 of the License, or (at your option) any later version.

http://www.meinemullemaus.de/
mailto: smstools@meinemullemaus.de
*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "syslog.h"
#include "extras.h"
#include "cfgfile.h"
#include "smsd_cfg.h"
#include "stats.h"
#include "version.h"
#include "blacklist.h"
#include "whitelist.h"
#include "alarm.h"


void initcfg()
{
  int i;
  int j;
  autosplit=1;
  receive_before_send=0;
  number_parts=1;
  delaytime=10;
  blocktime=60*60;
  errorsleeptime=10;
  blacklist[0]=0;
  whitelist[0]=0;
  eventhandler[0]=0;
  checkhandler[0]=0;
  alarmhandler[0]=0;
  logfile[0]=0;
  loglevel=LOG_WARNING;
  alarmlevel=LOG_WARNING;
  
  strcpy(d_spool,"/var/spool/sms/outgoing");
  strcpy(d_incoming,"/var/spool/sms/incoming");
  strcpy(d_checked,"/var/spool/sms/checked");
  strcpy(mypath,"/usr/local/bin");
  d_failed[0]=0;
  logfile[0]=0;
  d_sent[0]=0;
  d_stats[0]=0;
  stats_interval=0;
  for (i=0; i<PROVIDER; i++)
  {
    queues[i].name[0]=0;
    queues[i].directory[0]=0;
    for (j=0; j<NUMS; j++)
      queues[i].numbers[j][0]=0;
  }
  for (i=0; i<DEVICES; i++)
  {
    devices[i].name[0]=0;
    devices[i].device[0]=0;
    devices[i].incoming=0;
    devices[i].pin[0]=0;
    devices[i].smsc[0]=0;
    devices[i].baudrate=19200;
    devices[i].cs_convert=0;
    devices[i].initstring[0]=0;
    devices[i].eventhandler[0]=0;
    devices[i].report=0;
    devices[i].rtscts=0;
    strcpy(devices[i].mode,"new");
    for (j=0; j<PROVIDER; j++)
      devices[i].queues[j][0]=0;
  }
}

void readcfg()
{
  FILE* File;
  char devices_list[256];
  char name[32];
  char value[PATH_MAX];
  char tmp[PATH_MAX];
  char device_name[32];
  int result;
  int i,j;
  File=fopen(configfile,"r");
  if (File)
  {
    /* read global parameter */
    result=getline(File,name,sizeof(name),value,sizeof(value));
    while (result==1)
    {
      if (strcmp(name,"devices")==0)
        strcpy(devices_list,value);
      else if (strcmp(name,"spool")==0)
        strcpy(d_spool,value);
      else if (strcmp(name,"outgoing")==0)
        strcpy(d_spool,value);
      else if (strcmp(name,"stats")==0)
        strcpy(d_stats,value);
      else if (strcmp(name,"failed")==0)
        strcpy(d_failed,value);
      else if (strcmp(name,"incoming")==0)
        strcpy(d_incoming,value);
      else if (strcmp(name,"checked")==0)
        strcpy(d_checked,value);
      else if (strcmp(name,"sent")==0)
        strcpy(d_sent,value);
      else if (strcmp(name,"mypath")==0)
        strcpy(mypath,value);
      else if (strcmp(name,"delaytime")==0)
        delaytime=atoi(value);
      else if (strcmp(name,"blocktime")==0)
        blocktime=atoi(value);
      else if (strcmp(name,"stats_interval")==0)
        stats_interval=atoi(value);
      else if (strcmp(name,"errorsleeptime")==0)
        errorsleeptime=atoi(value);
      else if (strcmp(name,"eventhandler")==0)
        strcpy(eventhandler,value);
      else if (strcmp(name,"checkhandler")==0)
        strcpy(checkhandler,value);	
      else if (strcmp(name,"alarmhandler")==0)
        strcpy(alarmhandler,value);
      else if (strcmp(name,"blacklist")==0)
        strcpy(blacklist,value);
      else if (strcmp(name,"whitelist")==0)
        strcpy(whitelist,value);
      else if (strcmp(name,"logfile")==0)
        strcpy(logfile,value);
      else if (strcmp(name,"loglevel")==0)
        loglevel=atoi(value);
      else if (strcmp(name,"alarmlevel")==0)
        alarmlevel=atoi(value);
      else if (strcmp(name,"autosplit")==0)
	autosplit=yesno(value);
      else if (strcmp(name,"receive_before_send")==0)
        receive_before_send=yesno(value);
      else if (strcmp(name,"number_parts")==0)
        number_parts=yesno(value);
      else
        fprintf(stderr,"Unknown variable in config file: %s\n",name);
      result=getline(File,name,sizeof(name),value,sizeof(value));
    }
    if (result==-1)
      fprintf(stderr,"Syntax Error in config file: %s\n",value);
    for (i=0; i<DEVICES; i++)
      strcpy(devices[i].queues[0],d_checked);
    /* read queue-settings */
    if (!gotosection(File,"queues"))
      fprintf(stderr,"Info: Could not find [queues] in config file.\n");
    i=0;
    result=getline(File,name,sizeof(name),value,sizeof(value));
    while ((result==1) && (i<PROVIDER))
    {
      strcpy(queues[i].name,name);
      strcpy(queues[i].directory,value);
      i++;
      result=getline(File,name,sizeof(name),value,sizeof(value));
    }
    if (result==-1)
      fprintf(stderr,"Syntax Error in config file: %s\n",value);
    /* read provider-settings */
    if (!gotosection(File,"provider"))
      fprintf(stderr,"Info: Could not find [provider] in config file.\n");
    result=getline(File,name,sizeof(name),value,sizeof(value));
    while (result==1)
    {
      i=getqueue(name,tmp);
      if (i>=0)
      {
        for (j=1; j<=NUMS; j++)
	{
	  if (getsubparam(value,j,tmp,sizeof(tmp)))
	  {
	    strcpy(queues[i].numbers[j-1],tmp);
	  }
	  else
	    break;
	}
      }
      else
        fprintf(stderr,"Error in config file: missing queue for %s.\n",name);
      result=getline(File,name,sizeof(name),value,sizeof(value));
    }
    if (result==-1)
      fprintf(stderr,"Syntax Error in config file: %s\n",value);
    /* read device-settings */
    for (i=0; i<DEVICES; i++)
    {
      if (getsubparam(devices_list,i+1,device_name,sizeof(device_name)))
      {
        if (!gotosection(File,device_name))
	  fprintf(stderr,"Could not find device [%s] in config file.\n",device_name);
	strcpy(devices[i].name,device_name);
        result=getline(File,name,sizeof(name),value,sizeof(value));
	while (result==1)
	{
	  if (strcmp(name,"device")==0)
	    strcpy(devices[i].device,value);
	  else if (strcmp(name,"queues")==0)
	  {
	    for (j=1; j<=NUMS; j++)
	      if (getsubparam(value,j,tmp,sizeof(tmp)))
	        strcpy(devices[i].queues[j-1],tmp);
  	      else
	        break;
	  }
	  else if (strcmp(name,"incoming")==0)
	  {
	    if (strcmp(value,"high") ==0)
               devices[i].incoming=2;
	    else
	    {
	      devices[i].incoming=atoi(value);
	      if (devices[i].incoming==0)  // For backward compatibility to older version wich boolean value
	        devices[i].incoming=yesno(value);
	    }
          }
	  else if (strcmp(name,"cs_convert")==0)
	    devices[i].cs_convert=yesno(value);
	  else if (strcmp(name,"pin")==0)
	    strcpy(devices[i].pin,value);
	  else if (strcmp(name,"mode")==0)
	    strcpy(devices[i].mode,value);
	  else if (strcmp(name,"smsc")==0)
	    strcpy(devices[i].smsc,value);
	  else if (strcmp(name,"baudrate")==0)
	    devices[i].baudrate=atoi(value);
	  else if (strcmp(name,"init")==0)
	    strcpy(devices[i].initstring,value);
	  else if (strcmp(name,"eventhandler")==0)
    	    strcpy(devices[i].eventhandler,value);
	  else if (strcmp(name,"report")==0)
    	    devices[i].report=yesno(value);
	  else if (strcmp(name,"rtscts")==0)
    	    devices[i].rtscts=yesno(value);
	  else
	    fprintf(stderr,"Unknown variable in config file [%s]: %s\n",device_name,name);
	  result=getline(File,name,sizeof(name),value,sizeof(value));
	}
        if (result==-1)
          fprintf(stderr,"Syntax Error in config file: %s\n",value);
      }
      else
        break;
    }
    fclose(File);
    set_alarmhandler(alarmhandler,alarmlevel,"SMSD");
  }
  else
    fprintf(stderr,"Cannot open config file for read.\n");
}


int getqueue(char* name, char* directory) // Name can also be a phone number
{
  int i;
  int j;
  // If no queues are defined, then directory is always d_checked
  if (queues[0].name[0]==0)
  {
    strcpy(directory,d_checked);
    return -2;
  } 
  if (is_number(name))
  { /* search queue by number  */
    i=0;
    while (queues[i].name[0] && (i<PROVIDER))
    {
      j=0;
      while (queues[i].numbers[j][0] && (j<NUMS))
      {
        if (!strncmp(queues[i].numbers[j],name,strlen(queues[i].numbers[j])))
	{
	  if (directory)
  	    strcpy(directory,queues[i].directory);
	  return i;
	}
	j++;
      }
      i++;
    }
  }
  else
  { /* search queue by name */
    i=0;
    while (queues[i].name[0] && (i<PROVIDER))
    {
      if (!strcmp(name,queues[i].name))
      {
        strcpy(directory,queues[i].directory);
        return i;
      }
      i++;
    }
  }
  /* not found */
  directory[0]=0;
  return -1;
}

int getdevice(char* name)
{
  int i=0;
  while (devices[i].name[0] && (i<DEVICES))
  {
    if (!strcmp(name,devices[i].name))
      return i;
    i++;
  }
  return -1;
}

void help()
{
  printf("smsd spools incoming and outgoing sms.\n\n");
  printf("Usage:\n");
  printf("         smsd [options]\n\n");
  printf("Options:\n");
  printf("         -cx set config file to x\n");
  printf("         -d  debug mode (does not really send SMS)\n");
  printf("         -h  this help\n");
  printf("         -s  display status monitor\n");
  printf("         -V  print copyright and version\n\n");
  printf("All other options are set by the file /etc/smsd.conf.\n\n");
  printf("Output is written to stdout, errors are written to stderr.\n\n");
  exit(0);
}

void parsearguments(int argc,char** argv)
{
  int result;
  strcpy(configfile,"/etc/smsd.conf");
  debug=0;
  printstatus=0;

  do
  {
    result=getopt(argc,argv,"sdhc:V");
    switch (result)
    {
      case 'h': help(); 
                break;
      case 'd': debug=1;
                break;
      case 'c': strcpy(configfile,optarg);
                break;
      case 's': printstatus=1;
                break;
      case 'V': printf("Version %s, Copyright (c) Stefan Frings, smstools@meinemullemaus.de\n",smsd_version);
                exit(0);
    }
  }
  while (result>0);
}

