/* $Id: debug.c,v 1.4 2001/04/07 22:55:50 roesch Exp $ */
/*
** Copyright (C) 1998,1999,2000,2001 Martin Roesch <roesch@clark.net>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "snort.h"



#ifdef DEBUG


int debuglevel = DEBUG_ALL;
char *DebugMessageFile = NULL;
int DebugMessageLine = 0;


int GetDebugLevel (void)
{
    if (getenv(DEBUG_VARIABLE))
        debuglevel = atoi(getenv(DEBUG_VARIABLE));

    return debuglevel;
}


void DebugMessageFunc(int level, char *fmt, ...)
{
    va_list ap;
    char buf[STD_BUF+1];


    if (!(level & GetDebugLevel()))
        return;

    /* filename and line number information */
    if (DebugMessageFile != NULL)
        printf("%s:%d: ", DebugMessageFile, DebugMessageLine);

    va_start(ap, fmt);
        
    if(pv.daemon_flag)
    {
        vsnprintf(buf, STD_BUF, fmt, ap);
        syslog(LOG_DAEMON | LOG_DEBUG, "%s", buf);
    }
    else
    {
        vprintf(fmt, ap);
    }

    va_end(ap);
}
#endif /* DEBUG */
