<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: lookup routines for AG information 
 *
 */

function GetAGIDbyName($ag_name, $db)
{
  $ag_id = "";
  $sql = "SELECT ag_id FROM acid_ag WHERE ag_name='".$ag_name."'";

  $result = $db->acidExecute($sql, -1, -1, false);

  if ( $db->acidErrorMessage() != "" )
     ErrorMessage("The specified AG name search is invalid.  Try again!");
  else if ( $result->acidRecordCount() < 1 )
     ErrorMessage("The specified AG does not exist.");
  else
  {
        $myrow = $result->acidFetchRow();
        $ag_id = $myrow[0]; 
        $result->acidFreeRows();
  }

  return $ag_id;
}

function GetAGNamebyID($ag_id, $db)
{
  $ag_name = "";
  $sql = "SELECT ag_name FROM acid_ag WHERE ag_id='".$ag_id."'";

  $result = $db->acidExecute($sql, -1, -1, false);

  if ( $db->acidErrorMessage() != "" )
     ErrorMessage("The specified AG ID search is invalid.  Try again!");
  else if ( $result->acidRecordCount() < 1 )
     ErrorMessage("The specified AG does not exist.");
  else
  {
        $myrow = $result->acidFetchRow();
        $ag_id = $myrow[0]; 
        $result->acidFreeRows();
  }

  return $ag_name;
}

function VerifyAGID($ag_id, $db)
{
  $sql = "SELECT ag_id FROM acid_ag WHERE ag_id='".$ag_id."'";
  $result = $db->acidExecute($sql, -1, -1, false);

  if ( $db->acidErrorMessage() != "" )
  {
     ErrorMessage("Error looking up an AG ID");
     return 0;
  }
  else if ( $result->acidRecordCount() < 1 )
     return 0;
  else
  {
     $result->acidFreeRows();
     return 1;
  }
}

?>
