<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Displays statistics on the detected source and
 *          destination IP addresses   
 *
 * Input GET/POST variables
 *   - addr_type: sets the type of address on which stats will
 *                be generated
 *          = 1: source address
 *          = 2: destination address
 *   - caller: specifies the canned snapshot to run
 *          = most_frequent: Most frequent IP address
 *   - sort_order: 
 *   - num_result_rows:
 *   - submit:
 *   - limit_start:
 *   - limit_offset:
 *   - current_view:
 */

 include("acid_conf.php");
 include("acid_db.inc");
 include("acid_net.inc");
 include("acid_signature.inc");
 include("acid_db_common.php");
 include("acid_common.php"); 
 include("acid_pkt_common.php");

 RegisterGlobalState();
 ImportGlobalState();

 //if ( isset($HTTP_GET_VARS["caller"]) )
 //   if ( $HTTP_GET_VARS["caller"] != "" )
 //      $caller = $HTTP_GET_VARS["caller"];
 //else
 //   $caller = "";

 $caller = ImportHTTPVar("caller");
 $sort_order = ImportHTTPVar("sort_order");
 $num_result_rows = ImportHTTPVar("num_result_rows");
 $submit = ImportHTTPVar("submit");
 $limit_start = ImportHTTPVar("limit_start");
 $limit_offset = ImportHTTPVar("limit_offset");
 $current_view = ImportHTTPVar("current_view");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <META HTTP-EQUIV="pragma" CONTENT="no-cache">
    <TITLE>ACID:      
      <?php if ( $addr_type == 1 ) 
              echo "Unique Source Address(es)";
           else if ( $addr_type == 2 )
              echo "Unique Destination Address(es)";

           if ( $caller == "most_frequent" ) 
              echo ": Most Frequent $freq_num_uaddr addresses";
       ?> 
     </TITLE>
    <LINK rel="stylesheet" type="text/css" href="acid_style.css">
</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">
     <?php if ( $addr_type == 1 ) 
              echo "Unique Source Address(es)";
           else if ( $addr_type == 2 )
              echo "Unique Destination Address(es)";

           if ( $caller == "most_frequent" ) 
              echo ": Most Frequent $freq_num_uaddr addresses";
     ?>
  </TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>
</TR>
</TABLE>
<P><P>

<?php

  if ( $debug_mode > 0 ) PrintPageHeader();

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidPConnect($alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  PrintCriteria("");
  $criteria_clauses = ProcessCriteria();

  $criteria = $criteria_clauses[0]." ".$criteria_clauses[1];
  /* catch the condition where the $criteria will attempt to join the
   * iphdr table again (and remove this join). ProcessCriteria()
   * pulls fields from event and then joins in iphdr.  This page
   * pulls fields from iphdr and then must potentially join in event.
   */
  if ( strstr($criteria, "JOIN iphdr") )
  {
     $criteria_clauses[0] = eregi_replace("LEFT JOIN iphdr ON event.sid=iphdr.sid AND event.cid=iphdr.cid", 
                                          "", $criteria_clauses[0]);
  }

  /* strip the leading 'event.cid > 0' from the criteria clause */
  if ( strstr($criteria_clauses[1], "event.") )
  {
     $criteria_clauses[1] = strstr($criteria_clauses[1], " AND");
  }

  /* add join to event table */
  $criteria_clauses[0] = " LEFT JOIN event ON ((iphdr.sid=event.sid) AND (iphdr.cid=event.cid)) ".
                         $criteria_clauses[0];

  $sort_tmp = "";
  if ( ($sort_order == "ip_a") && ($addr_type == 1) ) $sort_tmp = " ORDER BY ip_src ASC";
  if ( ($sort_order == "ip_a") && ($addr_type == 2) ) $sort_tmp = " ORDER BY ip_dst ASC";
  if ( ($sort_order == "ip_d") && ($addr_type == 1) ) $sort_tmp = " ORDER BY ip_dst DESC";
  if ( ($sort_order == "ip_d") && ($addr_type == 2) ) $sort_tmp = " ORDER BY ip_dst DESC";
  if ( $sort_order == "occur_a" ) $sort_tmp = " ORDER BY num_events ASC";
  if ( $sort_order == "occur_d" ) $sort_tmp = " ORDER BY num_events DESC";

  if ( $addr_type == 1 ) /* source IP */
     $sql = "SELECT DISTINCT ip_src, ".
            " COUNT(event.cid) as num_events".
            " FROM iphdr ".$criteria_clauses[0]." WHERE (ip_src > -1) ".$criteria_clauses[1].
            " GROUP BY ip_src ".$sort_tmp;
  else if ( $addr_type == 2 ) /* dest IP */
     $sql = "SELECT DISTINCT ip_dst, ".
            " COUNT(event.cid) as num_events ".
            " FROM iphdr ".$criteria_clauses[0]." WHERE (ip_dst > -1) ".$criteria_clauses[1].
            " GROUP BY ip_dst ".$sort_tmp;

  if ( $num_result_rows == "" )
  {
     $num_result_rows = -1;
     $current_view = -1;
  }
  else if ( $num_result_rows > 0 && 
            ord($submit) >= ord("0") && ord($submit) <= ord("9") )
    $current_view = $submit;
  
  echo '
  <FORM METHOD="POST" ACTION="acid_stat_uaddr.php">';

  if ( $debug_mode == 1 )
     echo '<HR><TABLE BORDER=1>
             <TR><TD>caller</TD><TD>submit</TD><TD>addr_type</TD>
                 <TD>criteria</TD><TD>num_result_rows</TD></TR>
             <TR><TD>'.$caller.'</TD><TD>'.$submit.'</TD><TD>'.$addr_type.'</TD>
                 <TD>'.$criteria.'</TD>
                 <TD>'.$num_result_rows.'</TD></TR>
           </TABLE>';

  flush();

  /* Run the query to determine the number of rows (No LIMIT)*/
  if ( $num_result_rows == -1 )
  {
     $current_view = 0; 
     $result = $db->acidExecute($sql);
 
     if ( $result  )
     {
        $num_result_rows = $result->acidRecordCount();
        if ( $num_result_rows > 0 )
        {
          /* Check here for pre-processor generated events (e.g. portscan, mini-frag)
             that generate alerts but no packet information */
          $myrow = $result->acidFetchRow();
          if ( $myrow[1] == "" )
          {
             echo '<CENTER><FONT>This type of alert did not log any IP addresses.  See this 
                 <A HREF="acid_app_faq.php#1">FAQ</A> for details</FONT></CENTER>';
            $num_result_rows = 0;
          }
        }
        $result->acidFreeRows();
     }
     else
        $num_result_rows = 0;
   }
   
  /* Run the Query again for the actual data (with the LIMIT */
 
  /* Check if a limit has already been enforced,
     e.g. from most frequent IP addresses */
  if ( $caller == "most_frequent" )
  {
     $result = $db->acidExecute($sql, 0, $freq_num_uaddr);
     $limit_tmp_offset = 0;  $limit_tmp_count = $freq_num_uaddr;
     $limit = $freq_num_uaddr;
  }
  else if ( ($limit_start == -1) || ($limit_start == "") )
  {
     $result = $db->acidExecute($sql, ($current_view * $show_rows), $show_rows);
     $limit = $show_rows;
  }
  else
  {
     $result = $db->acidExecute($sql, $limit_start, $limit_offset);
     $limit = $limit_offset;
  }
  echo '<P><HR>';

   if ( $debug_mode > 0 )
   {
      echo "limit_start = $limit_start<BR>
            limit_offset = $limit_offset<BR>";
      echo 'SQL: '.$sql.'<BR>';
   }

   /* Print the current view number and # of rows */
   if ( $num_result_rows != 0 )
   {
      /* If printing Last-X alerts, just print all the IP addresses */
      if ( $limit_start == -1  )
         printf("<FONT><CENTER>Displaying IP addresses %d-%d of %d total<BR></CENTER></FONT><BR>\n", 
                ($current_view * $show_rows)+1, 
                (($current_view * $show_rows) + $show_rows-1) < $num_result_rows ? 
                (($current_view * $show_rows) + $show_rows) : $num_result_rows, 
                $num_result_rows);
      else if ( $caller == "most_frequent" )
        printf("<FONT><CENTER>Displaying %d Most Frequent Addresses<BR> ".
            "</CENTER></FONT><BR>\n", $freq_num_uaddr); 
      else
         echo '<FONT><CENTER>Displaying '.$num_result_rows.' IP addresses<BR></CENTER></FONT><BR>';

      $param_str = "&num_result_rows=$num_result_rows&current_view=$current_view".
                   "&addr_type=$addr_type&limit_start=$limit_start";

      echo '<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 BGCOLOR="#000000">
            <TR><TD>';
      echo '<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
                <TR>
                 <TD CLASS="plfieldhdr">
                  <A HREF="acid_stat_uaddr.php?sort_order=ip_a'.$param_str.'">&lt;</A>
                  IP Address
                  <A HREF="acid_stat_uaddr.php?sort_order=ip_d'.$param_str.'">&gt;</A>
                 </TD>';
      if ( $resolve_IP == 1 )
         echo '  <TD CLASS="plfieldhdr">FQDN</TD>';
      echo '     <TD CLASS="plfieldhdr">&nbsp;# of <BR>Sensors&nbsp;</TD>
                 <TD CLASS="plfieldhdr">
                  <A HREF="acid_stat_uaddr.php?sort_order=occur_a'.$param_str.'">&lt;</A>
                   # of <BR>Occurances
                  <A HREF="acid_stat_uaddr.php?sort_order=occur_d'.$param_str.'">&gt;</A>
                 </TD>';
   }
   else
      printf("<P><CENTER><B>0 IP addresses were found</B></CENTER><P>\n");

   $i = 0;
   while ( ($myrow = $result->acidFetchRow()) && ($num_result_rows != 0) && ($i < $limit) )
   {
      $currentIP = acidLong2IP($myrow[0]);

      echo '<TR BGCOLOR="'.((($i % 2) == 0) ? "DDDDDD" : "FFFFFF").'">
             <TD>&nbsp;&nbsp;'.
                 BuildAddressLink($currentIP, 32).$currentIP.'</A>&nbsp;&nbsp</TD>';
    
      if ( $resolve_IP == 1 )
         echo '<TD>&nbsp;&nbsp;'.
                   acidGetHostByAddr($currentIP, $db, $dns_cache_lifetime).
              '&nbsp;&nbsp;</TD>';

      /* Print # of Sensors */
      if ( $addr_type == 1 )
         $sql2 = "SELECT DISTINCT iphdr.sid FROM iphdr ".$criteria_clauses[0].
                 " WHERE ip_src=$myrow[0] ".$criteria_clauses[1];
      else if ( $addr_type == 2 )
         $sql2 = "SELECT DISTINCT iphdr.sid FROM iphdr ".$criteria_clauses[0].
                 " WHERE ip_dst=$myrow[0] ".$criteria_clauses[1];

      $result2 = $db->acidExecute($sql2);
      
      echo '<TD ALIGN=CENTER>'.$result2->acidRecordCount().'</TD>';
      $result2->acidFreeRows();

      /* Print # of Occurances */
      $tmp_iplookup = 'acid_pkt_main.php?new=1'.
                      '&num_result_rows=-1'.
                      '&submit=Query+DB&current_view=-1&ip_addr_cnt=1';

      echo '<TD ALIGN=CENTER>';
      if ( $addr_type == 1 )
         echo '<A HREF="'.$tmp_iplookup.BuildSrcIPFormVars($currentIP).'">'.
                                $myrow[1].'</A>';
      else if ( $addr_type == 2 )
         echo '<A HREF="'.$tmp_iplookup.BuildDstIPFormVars($currentIP).'">'.
                                $myrow[1].'</A>';
      echo '</TD>';
      ++$i;
   }

   echo '</TABLE>
         </TD></TR></TABLE>';
   $result->acidFreeRows();     

   /* Export shared state */
   echo '<INPUT TYPE="hidden" NAME="num_result_rows" VALUE="'.$num_result_rows.'">
         <INPUT TYPE="hidden" NAME="current_view" VALUE="'.$current_view.'">
         <INPUT TYPE="hidden" NAME="addr_type" VALUE="'.$addr_type.'">
         <INPUT TYPE="hidden" NAME="limit_start" VALUE="'.$limit_start.'">
         <INPUT TYPE="hidden" NAME="sort_order" VALUE="'.$sort_order.'">';

  /* ****** Print out Browsing Buttons ********************************************/
  if ( (($limit_start == -1) || ($limit_start == "")) && ($caller == "") )
     PrintBrowseButtons($num_result_rows, $show_rows, $max_scroll_buttons, $current_view);
?>

</FORM>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

</HTML>




