#include "utils.h"
extern WINDOW  *alarm_win;
extern WINDOW  *alarmmsg_win;
extern WINDOW  *node_win;


extern WINDOW  *balarm_win;
extern WINDOW  *bnode_win;


extern winparam  alarmparam;
extern winparam  balarmparam;
extern winparam   nodeparam;
extern winparam  bnodeparam;
extern winparam  alarmmsgparam;

extern int maxfd;
extern fd_set allset;

#ifdef EXTRA_DEBUG
extern FILE *mylog;
#endif


cltnode *clthead;
cltnode *cltnext;

alertnode *alertnodes;

int connected;
int total;
int a_pos; // alert message position


/*
 * initialize connect datastructures. used by parent process
 *
 */

void connects_init(void) {

	clthead = (cltnode *)calloc(sizeof(cltnode), 1);
	cltnext = clthead;
	connected = 0;
	total = 0;


	a_pos=0;

	alertnodes = (alertnode *)calloc(sizeof(alertnode), alarmparam.lines);
	
}


cltnode *cltnodebypid(pid_t pid) {

	cltnode *tmp = clthead;

	while (tmp->next != NULL) {
		if (pid == tmp->pid) 
			return tmp;
		tmp = tmp->next;
	}
return NULL;
}

cltnode *cltnodebyid(int id) {
	
	cltnode *tmp = clthead;

	while (tmp->next != NULL) {
		if (id == tmp->id) 
			return tmp;
		tmp = tmp->next;
	}

return NULL;
}

int add_cltnode(int id, pid_t pid, unsigned long addr, unsigned long from) {

	cltnode *tmp;
	
	cltnext->id = id;
	cltnext->pid = pid;
	cltnext->addr = addr;
	if(pipe(cltnext->pipe)<0)
	{
		perror("pipe");
		return -1;
	}
	if (cltnext->pipe[0] >= maxfd) 
		maxfd = cltnext->pipe[0] + 1;

	if (connected == (FD_SETSIZE - 1))
	{
		fprintf(stderr," too many clients\n");
		return -1;
	}
			
	FD_SET(cltnext->pipe[0], &allset);

	cltnext->next = (cltnode *)calloc(sizeof(cltnode), 1);
	tmp = cltnext;
	cltnext = cltnext->next;
	cltnext->prev = tmp;

	return 0;
}

void remove_cltnode(cltnode *clt) {
	
	if (clt->prev)
		clt->prev->next = clt->next;
	
	if (clt->next)
		clt->next->prev = clt->prev;
	if (clt == clthead)
		clthead = clt->next;
	FD_CLR(clt->pipe[0],&allset);
	free(clt);
}


/*
 * add_node_connected( *node, id) : node - contains IP address where box is
 * connecting from.
 */


int 
add_node_connect(struct sockaddr_in * node, pid_t pid)
{
	
	if (add_cltnode(1, pid, node->sin_addr.s_addr,
			node->sin_addr.s_addr)<0) {
		wprintw(node_win,"[%i] error connecting the node!\n", total);
		return -1;
	}
		
	wprintw(node_win, "[%i]\tconnected from %s.\n",
		total, inet_ntoa(node->sin_addr));
	total++;
	connected++;
	sn_connected_status(connected, total);
	wnoutrefresh(bnode_win);
	wnoutrefresh(node_win);
	doupdate();
	
	return 0;
}
void 
remove_node_connect(pid_t pid,int status)
{
	cltnode *tmp;

	tmp = cltnodebypid(pid);
	
	if (tmp) 
		wprintw(node_win, "[%i]\t%s disconnected(%i)\n", pid,
			addr2str((void *)&tmp->addr,NULL),
			WEXITSTATUS(status));
	else
		wprintw(node_win, "[%i]\tERROR! Disconnected but no pid "
				"found. Please report!\n", pid);
	connected--;
	sn_connected_status(connected, total);
	wnoutrefresh(bnode_win);
	wnoutrefresh(node_win);
	doupdate();
	remove_cltnode(tmp);
}

void 
refuse_node_connect(struct sockaddr_in * node)
{
	wprintw(node_win, "[XXX]\trefused connect from %s\n",
			inet_ntoa(node->sin_addr));
	wnoutrefresh(bnode_win);
	wnoutrefresh(node_win);
	doupdate();
}

void put_alert(int idx) {

	if (alertnodes[idx].clt.sin_addr.s_addr == 0)
		return; // not used yet
	mvwprintw(alarm_win, idx, 0, "% 12s",
			inet_ntoa(alertnodes[idx].clt.sin_addr));
	switch(alertnodes[idx].alert.protocol) {
		case IPPROTO_TCP:
			mvwprintw(alarm_win, idx, 12, "|% 10s","TCP");
			break;
		case IPPROTO_UDP:
			mvwprintw(alarm_win, idx, 12, "|% 10s","UDP");
			break;
		case IPPROTO_ICMP:
			mvwprintw(alarm_win, idx, 12, "|% 10s","ICMP");
			break;
		default:
			mvwprintw(alarm_win, idx, 12, "|% 10i",
					alertnodes[idx].alert.protocol);
	}
			
	mvwprintw(alarm_win, idx, 23, "|% 12s",
			addr2str((void *)&(alertnodes[idx].alert.src_ip), 0));
	mvwprintw(alarm_win, idx, 39, "|% 12s",
			addr2str((void *)&(alertnodes[idx].alert.dst_ip), 0));

}

void 
display_alert(NetAlert * alert, struct sockaddr_in *clt)
{
	int i;

	bcopy(alert,&(alertnodes[a_pos].alert),sizeof(NetAlert));
	bcopy(clt, &(alertnodes[a_pos].clt), sizeof(struct sockaddr_in));
	
	for (i = 0; i< alarmparam.lines; i++) {
		if (a_pos == i) {
			wstandout(alarm_win);
			put_alert(i);
			wstandend(alarm_win);
		}
		else
			put_alert(i);
	}
	a_pos++;
	if (alarmparam.lines <=a_pos)
		a_pos = 0;
	
	wclear(alarmmsg_win);
	wmove(alarmmsg_win,0,0);
	wprintw(alarmmsg_win,"ALERT: %s\n",alert->msg);
	switch(alert->protocol) {
		case IPPROTO_TCP:
		case IPPROTO_UDP:
			wprintw(alarmmsg_win,"s.port: %i\nd.port: %i\n",
				ntohs(alert->sn_src_port),
				ntohs(alert->sn_dst_port));
			break;
		case IPPROTO_ICMP:
			wprintw(alarmmsg_win,"icmp type: %i\nicmp code: %i\n",
					ntohs(alert->sn_icmp_type),
					ntohs(alert->sn_icmp_code));
			break;
		default:
			break;
	}
	//wnoutrefresh(balarm_win);
	wnoutrefresh(alarm_win);
	wnoutrefresh(alarmmsg_win);
	doupdate();
}


void poll_select(int sd) {

	fd_set rset;
	int nready;
	cltnode *tmp = clthead;
	
	
#ifdef EXTRA_DEBUG
	fprintf(mylog,"polling select\n");
#endif

	rset = allset;
	nready = select(maxfd, &rset, NULL, NULL, NULL);
	if (nready < 0) {
		perror("select");
		return;
	}
	if (FD_ISSET(sd, &rset))  // we have a connection to accept 
		accept_connection(sd);

	while (tmp->next != NULL) { // we have some child passing data..
		if (FD_ISSET(tmp->pipe[0], &rset))
			read_alert(tmp);
		tmp = tmp->next;
	}
}



int read_alert( cltnode *clt) {

	alertnode alt;
	int n;
	char buf1[20],buf2[20],buf3[20];

	n=read(clt->pipe[0],&alt, sizeof(alt));
	display_alert(&(alt.alert), &(alt.clt));
	//log_alert(&(alt.alert), &(alt.clt));
	
	return 1;
}

int write_alert(NetAlert *alert, struct sockaddr_in *clt, cltnode *me) {
	alertnode alt;

	bcopy(alert,&(alt.alert),sizeof(NetAlert));
	bcopy(clt, &(alt.clt), sizeof(struct sockaddr_in));
	write(me->pipe[1], &alt, sizeof(alt));
	return 1;
}


/*
 * Copyright 1996 Massachusetts Institute of Technology
 * 
 * this routine is adopted from FreeBSD libc library.
 */

char           *
addr2str(const void *addrp, char *buf)
{
	static char     staticbuf[64];

	if (!buf)
		buf = staticbuf;

	strcpy(buf, inet_ntoa(*(const struct in_addr *) addrp));

	return buf;
}


#ifdef BROKEN_LINUX_WRAPPERS
/*
 * on some linuxes libwrap doesn't link cuz this routine is missed, clues?
 *
 */
char yp_get_default_domain() {
  
  return NULL; 
}
#endif

